//==========================================================================
//
//      devs/watchdog/arm/sp805/watchdog_sp805.cxx
//
//      Watchdog implementation for ARM SP805 PrimeCell controller
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2008, 2009 eCosCentric Limited                             
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2008 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: nickg, jlarmour
// Date:         2004-05-05
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the ARM SP805 watchdog timer.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_arm_sp805.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#if !defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)
#include <cyg/hal/hal_intr.h>
#include <cyg/kernel/intr.hxx>
#endif

#ifndef _WDOG_BASE
# error Port includes watchdog driver, but does not define _WDOG_BASE
#endif
#ifndef _WDOG_CLK
# error _WDOG_CLK not defined
#endif

// For backward compatibility, we only define these if not already defined by HAL.
#ifndef _WDOG_LOAD
#define _WDOG_LOAD              0x000
#define _WDOG_VALUE             0x004
#define _WDOG_CTRL              0x008
#define  _WDOG_CTRL_INTEN       (1<<0)
#define  _WDOG_CTRL_RESEN       (1<<1)
#define _WDOG_ICLR              0x00C
#define _WDOG_RIS               0x010
#define _WDOG_MIS               0x014

#define _WDOG_LOCK              0xC00
#define  _WDOG_LOCK_ACCESS      0x1ACCE551
#endif

//==========================================================================

#define RESOLUTION ((cyg_uint64)(CYGNUM_DEVS_WATCHDOG_ARM_SP805_DESIRED_TIMEOUT_MS*1000000))
#define WATCHDOG_INIT ((cyg_uint32)(((cyg_uint64)CYGNUM_DEVS_WATCHDOG_ARM_SP805_DESIRED_TIMEOUT_MS*_WDOG_CLK + 999) / 1000))

//==========================================================================

#if defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();
  resolution = RESOLUTION;
  CYG_REPORT_RETURN();
}

#define WDOG_CTRL (_WDOG_CTRL_RESEN|_WDOG_CTRL_INTEN)

#else /* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================

static Cyg_Watchdog *wd;

//==========================================================================

static cyg_uint32
isr(cyg_vector vector, CYG_ADDRWORD data)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARG2XV(vector, data);

  CYG_ASSERT( vector == CYGNUM_HAL_INTERRUPT_WATCHDOG, "WD ISR called with wrong vector");
    
  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, _WDOG_LOCK_ACCESS );
  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_ICLR, 1 );
  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, 0 );
  
  wd->trigger();
  Cyg_Interrupt::acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETVAL(Cyg_Interrupt::HANDLED);
  return Cyg_Interrupt::HANDLED;
}

//==========================================================================

static Cyg_Interrupt CYGBLD_ATTRIB_INIT_PRI( CYG_INIT_INTERRUPTS ) wdint(
    CYGNUM_HAL_INTERRUPT_WATCHDOG,
    4,
    0,
    isr,
    NULL
    );

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  wd = this;
  resolution = RESOLUTION;
  wdint.configure_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG, false, true);
  wdint.attach();
  wdint.acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  wdint.unmask_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETURN();
}

#define WDOG_CTRL (_WDOG_CTRL_INTEN)

#endif	/* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, _WDOG_LOCK_ACCESS );
  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOAD, WATCHDOG_INIT );
  HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, 0 );
  
  CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, _WDOG_LOCK_ACCESS );
    HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOAD, WATCHDOG_INIT );
    HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_CTRL, WDOG_CTRL );
    HAL_WRITE_UINT32( _WDOG_BASE+_WDOG_LOCK, 0 );

    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_sp805.cxx
