//==========================================================================
//
//      devs/watchdog/cortexm/lm3s/watchdog_lm3s.cxx
//
//      Watchdog implementation for LUMINARY LM3S variant CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006, 2009 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2009-07-30
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the LUMINARY LM3S on-board watchdog timer.
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <cyg/hal/drv_api.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_cortexm_lm3s.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#include <cyg/hal/hal_intr.h>
#include <cyg/kernel/intr.hxx>

#include <cyg/infra/diag.h>

//==========================================================================

__externC cyg_uint32 hal_lm3s_sysclk;

//==========================================================================

#define WD_LOAD (((cyg_uint64)hal_lm3s_sysclk*(cyg_uint64)CYGNUM_DEVS_WATCHDOG_CORTEXM_LM3S_DESIRED_TIMEOUT_US)/1000000LL)
#define WD_CTL  (CYGHWR_HAL_LM3S_WATCHDOG_CTL_RESEN|CYGHWR_HAL_LM3S_WATCHDOG_CTL_INTEN)
#define INT_PRIO 0x10

//==========================================================================

static Cyg_Watchdog *wd;

static volatile cyg_uint32 resets = 0;

//--------------------------------------------------------------------------

static cyg_uint32
lm3s_watchdog_isr(cyg_vector vector, CYG_ADDRWORD data)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARG2XV(vector, data);

  diag_printf("WDISR: ticks %d, resets %d\n", (int)cyg_current_time(), resets );

  // Clear the interrupt regardless
  HAL_WRITE_UINT32( CYGHWR_HAL_LM3S_WATCHDOG+CYGHWR_HAL_LM3S_WATCHDOG_ICR, 0 );
  
  if( resets == 0 )
  {  
#if defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)
      // Reset the processor
      HAL_PLATFORM_RESET();
#else
      // Call the trigger action
      wd->trigger();  
#endif
  }
  else
  {
      // Clear resets counter
      resets = 0;
  }
  
  Cyg_Interrupt::acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETVAL(Cyg_Interrupt::HANDLED);
  return Cyg_Interrupt::HANDLED;
}

//--------------------------------------------------------------------------

static cyg_interrupt    lm3s_watchdog_interrupt_data;
static cyg_handle_t     lm3s_watchdog_interrupt_handle;

//--------------------------------------------------------------------------

void
Cyg_Watchdog::init_hw(void)
{
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    CYGHWR_HAL_LM3S_CLOCK_ENABLE( CYGHWR_HAL_LM3S_WATCHDOG_CLOCK );
  
    wd = this;

    resolution = ((cyg_uint64)CYGNUM_DEVS_WATCHDOG_CORTEXM_LM3S_DESIRED_TIMEOUT_US)*1000LL;

    cyg_drv_interrupt_create(CYGNUM_HAL_INTERRUPT_WATCHDOG,
                             INT_PRIO,
                             (cyg_addrword_t) 0,
                             &lm3s_watchdog_isr,
                             NULL,
                             &lm3s_watchdog_interrupt_handle,
                             &lm3s_watchdog_interrupt_data);
    cyg_drv_interrupt_attach(lm3s_watchdog_interrupt_handle);
    HAL_INTERRUPT_UNMASK(CYGNUM_HAL_INTERRUPT_WATCHDOG);

    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    diag_printf("WDRST: ticks %d, resets %d\n", (int)cyg_current_time(), resets );    

    resets++;
        
    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    CYG_ADDRESS base = CYGHWR_HAL_LM3S_WATCHDOG;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    diag_printf("sysclk %d WD_LOAD %lld\n", hal_lm3s_sysclk, WD_LOAD );
    
    // Stall watchdog during debugging
    HAL_WRITE_UINT32( base+CYGHWR_HAL_LM3S_WATCHDOG_TEST, CYGHWR_HAL_LM3S_WATCHDOG_TEST_STALL );    
    
    HAL_WRITE_UINT32( base+CYGHWR_HAL_LM3S_WATCHDOG_LOAD, WD_LOAD );
    
    HAL_WRITE_UINT32( base+CYGHWR_HAL_LM3S_WATCHDOG_CTL, WD_CTL );

    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_lm3s.cxx
