
#ifndef __DONT_DEFINE_STRUCTS__


typedef unsigned short mbcs_t;
typedef unsigned short unicode_t;

struct cp2unicode_row
{
    int             row_index;
    int             row_base;
    int             row_size;
    unicode_t       *codes;
};
struct cp2unicode        
{
    int     col_base;
    int     col_count;
    struct cp2unicode_row **row;
};


#endif

static unicode_t korean_row_codes_0[] =
{
/* 0x0000 */
0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
/* 0x0010 */
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
/* 0x0020 */
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
/* 0x0030 */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
/* 0x0040 */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
/* 0x0050 */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
/* 0x0060 */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
/* 0x0070 */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
};
static struct cp2unicode_row korean_row_0 = { 0x0, 0x0, 0x80, korean_row_codes_0 };
static unicode_t korean_row_codes_81[] =
{
/* 0x8141 */
0xac02, 0xac03, 0xac05, 0xac06, 0xac0b, 0xac0c, 0xac0d, 0xac0e, 0xac0f, 0xac18, 0xac1e, 0xac1f, 0xac21, 0xac22, 0xac23, 
/* 0x8150 */
0xac25, 0xac26, 0xac27, 0xac28, 0xac29, 0xac2a, 0xac2b, 0xac2e, 0xac32, 0xac33, 0xac34, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8160 */
0x0000, 0xac35, 0xac36, 0xac37, 0xac3a, 0xac3b, 0xac3d, 0xac3e, 0xac3f, 0xac41, 0xac42, 0xac43, 0xac44, 0xac45, 0xac46, 0xac47, 
/* 0x8170 */
0xac48, 0xac49, 0xac4a, 0xac4c, 0xac4e, 0xac4f, 0xac50, 0xac51, 0xac52, 0xac53, 0xac55, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8180 */
0x0000, 0xac56, 0xac57, 0xac59, 0xac5a, 0xac5b, 0xac5d, 0xac5e, 0xac5f, 0xac60, 0xac61, 0xac62, 0xac63, 0xac64, 0xac65, 0xac66, 
/* 0x8190 */
0xac67, 0xac68, 0xac69, 0xac6a, 0xac6b, 0xac6c, 0xac6d, 0xac6e, 0xac6f, 0xac72, 0xac73, 0xac75, 0xac76, 0xac79, 0xac7b, 0xac7c, 
/* 0x81a0 */
0xac7d, 0xac7e, 0xac7f, 0xac82, 0xac87, 0xac88, 0xac8d, 0xac8e, 0xac8f, 0xac91, 0xac92, 0xac93, 0xac95, 0xac96, 0xac97, 0xac98, 
/* 0x81b0 */
0xac99, 0xac9a, 0xac9b, 0xac9e, 0xaca2, 0xaca3, 0xaca4, 0xaca5, 0xaca6, 0xaca7, 0xacab, 0xacad, 0xacae, 0xacb1, 0xacb2, 0xacb3, 
/* 0x81c0 */
0xacb4, 0xacb5, 0xacb6, 0xacb7, 0xacba, 0xacbe, 0xacbf, 0xacc0, 0xacc2, 0xacc3, 0xacc5, 0xacc6, 0xacc7, 0xacc9, 0xacca, 0xaccb, 
/* 0x81d0 */
0xaccd, 0xacce, 0xaccf, 0xacd0, 0xacd1, 0xacd2, 0xacd3, 0xacd4, 0xacd6, 0xacd8, 0xacd9, 0xacda, 0xacdb, 0xacdc, 0xacdd, 0xacde, 
/* 0x81e0 */
0xacdf, 0xace2, 0xace3, 0xace5, 0xace6, 0xace9, 0xaceb, 0xaced, 0xacee, 0xacf2, 0xacf4, 0xacf7, 0xacf8, 0xacf9, 0xacfa, 0xacfb, 
/* 0x81f0 */
0xacfe, 0xacff, 0xad01, 0xad02, 0xad03, 0xad05, 0xad07, 0xad08, 0xad09, 0xad0a, 0xad0b, 0xad0e, 0xad10, 0xad12, 0xad13, 
};
static struct cp2unicode_row korean_row_81 = { 0x81, 0x41, 0xbe, korean_row_codes_81 };
static unicode_t korean_row_codes_82[] =
{
/* 0x8241 */
0xad14, 0xad15, 0xad16, 0xad17, 0xad19, 0xad1a, 0xad1b, 0xad1d, 0xad1e, 0xad1f, 0xad21, 0xad22, 0xad23, 0xad24, 0xad25, 
/* 0x8250 */
0xad26, 0xad27, 0xad28, 0xad2a, 0xad2b, 0xad2e, 0xad2f, 0xad30, 0xad31, 0xad32, 0xad33, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8260 */
0x0000, 0xad36, 0xad37, 0xad39, 0xad3a, 0xad3b, 0xad3d, 0xad3e, 0xad3f, 0xad40, 0xad41, 0xad42, 0xad43, 0xad46, 0xad48, 0xad4a, 
/* 0x8270 */
0xad4b, 0xad4c, 0xad4d, 0xad4e, 0xad4f, 0xad51, 0xad52, 0xad53, 0xad55, 0xad56, 0xad57, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8280 */
0x0000, 0xad59, 0xad5a, 0xad5b, 0xad5c, 0xad5d, 0xad5e, 0xad5f, 0xad60, 0xad62, 0xad64, 0xad65, 0xad66, 0xad67, 0xad68, 0xad69, 
/* 0x8290 */
0xad6a, 0xad6b, 0xad6e, 0xad6f, 0xad71, 0xad72, 0xad77, 0xad78, 0xad79, 0xad7a, 0xad7e, 0xad80, 0xad83, 0xad84, 0xad85, 0xad86, 
/* 0x82a0 */
0xad87, 0xad8a, 0xad8b, 0xad8d, 0xad8e, 0xad8f, 0xad91, 0xad92, 0xad93, 0xad94, 0xad95, 0xad96, 0xad97, 0xad98, 0xad99, 0xad9a, 
/* 0x82b0 */
0xad9b, 0xad9e, 0xad9f, 0xada0, 0xada1, 0xada2, 0xada3, 0xada5, 0xada6, 0xada7, 0xada8, 0xada9, 0xadaa, 0xadab, 0xadac, 0xadad, 
/* 0x82c0 */
0xadae, 0xadaf, 0xadb0, 0xadb1, 0xadb2, 0xadb3, 0xadb4, 0xadb5, 0xadb6, 0xadb8, 0xadb9, 0xadba, 0xadbb, 0xadbc, 0xadbd, 0xadbe, 
/* 0x82d0 */
0xadbf, 0xadc2, 0xadc3, 0xadc5, 0xadc6, 0xadc7, 0xadc9, 0xadca, 0xadcb, 0xadcc, 0xadcd, 0xadce, 0xadcf, 0xadd2, 0xadd4, 0xadd5, 
/* 0x82e0 */
0xadd6, 0xadd7, 0xadd8, 0xadd9, 0xadda, 0xaddb, 0xaddd, 0xadde, 0xaddf, 0xade1, 0xade2, 0xade3, 0xade5, 0xade6, 0xade7, 0xade8, 
/* 0x82f0 */
0xade9, 0xadea, 0xadeb, 0xadec, 0xaded, 0xadee, 0xadef, 0xadf0, 0xadf1, 0xadf2, 0xadf3, 0xadf4, 0xadf5, 0xadf6, 0xadf7, 
};
static struct cp2unicode_row korean_row_82 = { 0x82, 0x41, 0xbe, korean_row_codes_82 };
static unicode_t korean_row_codes_83[] =
{
/* 0x8341 */
0xadfa, 0xadfb, 0xadfd, 0xadfe, 0xae02, 0xae03, 0xae04, 0xae05, 0xae06, 0xae07, 0xae0a, 0xae0c, 0xae0e, 0xae0f, 0xae10, 
/* 0x8350 */
0xae11, 0xae12, 0xae13, 0xae15, 0xae16, 0xae17, 0xae18, 0xae19, 0xae1a, 0xae1b, 0xae1c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8360 */
0x0000, 0xae1d, 0xae1e, 0xae1f, 0xae20, 0xae21, 0xae22, 0xae23, 0xae24, 0xae25, 0xae26, 0xae27, 0xae28, 0xae29, 0xae2a, 0xae2b, 
/* 0x8370 */
0xae2c, 0xae2d, 0xae2e, 0xae2f, 0xae32, 0xae33, 0xae35, 0xae36, 0xae39, 0xae3b, 0xae3c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8380 */
0x0000, 0xae3d, 0xae3e, 0xae3f, 0xae42, 0xae44, 0xae47, 0xae48, 0xae49, 0xae4b, 0xae4f, 0xae51, 0xae52, 0xae53, 0xae55, 0xae57, 
/* 0x8390 */
0xae58, 0xae59, 0xae5a, 0xae5b, 0xae5e, 0xae62, 0xae63, 0xae64, 0xae66, 0xae67, 0xae6a, 0xae6b, 0xae6d, 0xae6e, 0xae6f, 0xae71, 
/* 0x83a0 */
0xae72, 0xae73, 0xae74, 0xae75, 0xae76, 0xae77, 0xae7a, 0xae7e, 0xae7f, 0xae80, 0xae81, 0xae82, 0xae83, 0xae86, 0xae87, 0xae88, 
/* 0x83b0 */
0xae89, 0xae8a, 0xae8b, 0xae8d, 0xae8e, 0xae8f, 0xae90, 0xae91, 0xae92, 0xae93, 0xae94, 0xae95, 0xae96, 0xae97, 0xae98, 0xae99, 
/* 0x83c0 */
0xae9a, 0xae9b, 0xae9c, 0xae9d, 0xae9e, 0xae9f, 0xaea0, 0xaea1, 0xaea2, 0xaea3, 0xaea4, 0xaea5, 0xaea6, 0xaea7, 0xaea8, 0xaea9, 
/* 0x83d0 */
0xaeaa, 0xaeab, 0xaeac, 0xaead, 0xaeae, 0xaeaf, 0xaeb0, 0xaeb1, 0xaeb2, 0xaeb3, 0xaeb4, 0xaeb5, 0xaeb6, 0xaeb7, 0xaeb8, 0xaeb9, 
/* 0x83e0 */
0xaeba, 0xaebb, 0xaebf, 0xaec1, 0xaec2, 0xaec3, 0xaec5, 0xaec6, 0xaec7, 0xaec8, 0xaec9, 0xaeca, 0xaecb, 0xaece, 0xaed2, 0xaed3, 
/* 0x83f0 */
0xaed4, 0xaed5, 0xaed6, 0xaed7, 0xaeda, 0xaedb, 0xaedd, 0xaede, 0xaedf, 0xaee0, 0xaee1, 0xaee2, 0xaee3, 0xaee4, 0xaee5, 
};
static struct cp2unicode_row korean_row_83 = { 0x83, 0x41, 0xbe, korean_row_codes_83 };
static unicode_t korean_row_codes_84[] =
{
/* 0x8441 */
0xaee6, 0xaee7, 0xaee9, 0xaeea, 0xaeec, 0xaeee, 0xaeef, 0xaef0, 0xaef1, 0xaef2, 0xaef3, 0xaef5, 0xaef6, 0xaef7, 0xaef9, 
/* 0x8450 */
0xaefa, 0xaefb, 0xaefd, 0xaefe, 0xaeff, 0xaf00, 0xaf01, 0xaf02, 0xaf03, 0xaf04, 0xaf05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8460 */
0x0000, 0xaf06, 0xaf09, 0xaf0a, 0xaf0b, 0xaf0c, 0xaf0e, 0xaf0f, 0xaf11, 0xaf12, 0xaf13, 0xaf14, 0xaf15, 0xaf16, 0xaf17, 0xaf18, 
/* 0x8470 */
0xaf19, 0xaf1a, 0xaf1b, 0xaf1c, 0xaf1d, 0xaf1e, 0xaf1f, 0xaf20, 0xaf21, 0xaf22, 0xaf23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8480 */
0x0000, 0xaf24, 0xaf25, 0xaf26, 0xaf27, 0xaf28, 0xaf29, 0xaf2a, 0xaf2b, 0xaf2e, 0xaf2f, 0xaf31, 0xaf33, 0xaf35, 0xaf36, 0xaf37, 
/* 0x8490 */
0xaf38, 0xaf39, 0xaf3a, 0xaf3b, 0xaf3e, 0xaf40, 0xaf44, 0xaf45, 0xaf46, 0xaf47, 0xaf4a, 0xaf4b, 0xaf4c, 0xaf4d, 0xaf4e, 0xaf4f, 
/* 0x84a0 */
0xaf51, 0xaf52, 0xaf53, 0xaf54, 0xaf55, 0xaf56, 0xaf57, 0xaf58, 0xaf59, 0xaf5a, 0xaf5b, 0xaf5e, 0xaf5f, 0xaf60, 0xaf61, 0xaf62, 
/* 0x84b0 */
0xaf63, 0xaf66, 0xaf67, 0xaf68, 0xaf69, 0xaf6a, 0xaf6b, 0xaf6c, 0xaf6d, 0xaf6e, 0xaf6f, 0xaf70, 0xaf71, 0xaf72, 0xaf73, 0xaf74, 
/* 0x84c0 */
0xaf75, 0xaf76, 0xaf77, 0xaf78, 0xaf7a, 0xaf7b, 0xaf7c, 0xaf7d, 0xaf7e, 0xaf7f, 0xaf81, 0xaf82, 0xaf83, 0xaf85, 0xaf86, 0xaf87, 
/* 0x84d0 */
0xaf89, 0xaf8a, 0xaf8b, 0xaf8c, 0xaf8d, 0xaf8e, 0xaf8f, 0xaf92, 0xaf93, 0xaf94, 0xaf96, 0xaf97, 0xaf98, 0xaf99, 0xaf9a, 0xaf9b, 
/* 0x84e0 */
0xaf9d, 0xaf9e, 0xaf9f, 0xafa0, 0xafa1, 0xafa2, 0xafa3, 0xafa4, 0xafa5, 0xafa6, 0xafa7, 0xafa8, 0xafa9, 0xafaa, 0xafab, 0xafac, 
/* 0x84f0 */
0xafad, 0xafae, 0xafaf, 0xafb0, 0xafb1, 0xafb2, 0xafb3, 0xafb4, 0xafb5, 0xafb6, 0xafb7, 0xafba, 0xafbb, 0xafbd, 0xafbe, 
};
static struct cp2unicode_row korean_row_84 = { 0x84, 0x41, 0xbe, korean_row_codes_84 };
static unicode_t korean_row_codes_85[] =
{
/* 0x8541 */
0xafbf, 0xafc1, 0xafc2, 0xafc3, 0xafc4, 0xafc5, 0xafc6, 0xafca, 0xafcc, 0xafcf, 0xafd0, 0xafd1, 0xafd2, 0xafd3, 0xafd5, 
/* 0x8550 */
0xafd6, 0xafd7, 0xafd8, 0xafd9, 0xafda, 0xafdb, 0xafdd, 0xafde, 0xafdf, 0xafe0, 0xafe1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8560 */
0x0000, 0xafe2, 0xafe3, 0xafe4, 0xafe5, 0xafe6, 0xafe7, 0xafea, 0xafeb, 0xafec, 0xafed, 0xafee, 0xafef, 0xaff2, 0xaff3, 0xaff5, 
/* 0x8570 */
0xaff6, 0xaff7, 0xaff9, 0xaffa, 0xaffb, 0xaffc, 0xaffd, 0xaffe, 0xafff, 0xb002, 0xb003, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8580 */
0x0000, 0xb005, 0xb006, 0xb007, 0xb008, 0xb009, 0xb00a, 0xb00b, 0xb00d, 0xb00e, 0xb00f, 0xb011, 0xb012, 0xb013, 0xb015, 0xb016, 
/* 0x8590 */
0xb017, 0xb018, 0xb019, 0xb01a, 0xb01b, 0xb01e, 0xb01f, 0xb020, 0xb021, 0xb022, 0xb023, 0xb024, 0xb025, 0xb026, 0xb027, 0xb029, 
/* 0x85a0 */
0xb02a, 0xb02b, 0xb02c, 0xb02d, 0xb02e, 0xb02f, 0xb030, 0xb031, 0xb032, 0xb033, 0xb034, 0xb035, 0xb036, 0xb037, 0xb038, 0xb039, 
/* 0x85b0 */
0xb03a, 0xb03b, 0xb03c, 0xb03d, 0xb03e, 0xb03f, 0xb040, 0xb041, 0xb042, 0xb043, 0xb046, 0xb047, 0xb049, 0xb04b, 0xb04d, 0xb04f, 
/* 0x85c0 */
0xb050, 0xb051, 0xb052, 0xb056, 0xb058, 0xb05a, 0xb05b, 0xb05c, 0xb05e, 0xb05f, 0xb060, 0xb061, 0xb062, 0xb063, 0xb064, 0xb065, 
/* 0x85d0 */
0xb066, 0xb067, 0xb068, 0xb069, 0xb06a, 0xb06b, 0xb06c, 0xb06d, 0xb06e, 0xb06f, 0xb070, 0xb071, 0xb072, 0xb073, 0xb074, 0xb075, 
/* 0x85e0 */
0xb076, 0xb077, 0xb078, 0xb079, 0xb07a, 0xb07b, 0xb07e, 0xb07f, 0xb081, 0xb082, 0xb083, 0xb085, 0xb086, 0xb087, 0xb088, 0xb089, 
/* 0x85f0 */
0xb08a, 0xb08b, 0xb08e, 0xb090, 0xb092, 0xb093, 0xb094, 0xb095, 0xb096, 0xb097, 0xb09b, 0xb09d, 0xb09e, 0xb0a3, 0xb0a4, 
};
static struct cp2unicode_row korean_row_85 = { 0x85, 0x41, 0xbe, korean_row_codes_85 };
static unicode_t korean_row_codes_86[] =
{
/* 0x8641 */
0xb0a5, 0xb0a6, 0xb0a7, 0xb0aa, 0xb0b0, 0xb0b2, 0xb0b6, 0xb0b7, 0xb0b9, 0xb0ba, 0xb0bb, 0xb0bd, 0xb0be, 0xb0bf, 0xb0c0, 
/* 0x8650 */
0xb0c1, 0xb0c2, 0xb0c3, 0xb0c6, 0xb0ca, 0xb0cb, 0xb0cc, 0xb0cd, 0xb0ce, 0xb0cf, 0xb0d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8660 */
0x0000, 0xb0d3, 0xb0d5, 0xb0d6, 0xb0d7, 0xb0d9, 0xb0da, 0xb0db, 0xb0dc, 0xb0dd, 0xb0de, 0xb0df, 0xb0e1, 0xb0e2, 0xb0e3, 0xb0e4, 
/* 0x8670 */
0xb0e6, 0xb0e7, 0xb0e8, 0xb0e9, 0xb0ea, 0xb0eb, 0xb0ec, 0xb0ed, 0xb0ee, 0xb0ef, 0xb0f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8680 */
0x0000, 0xb0f1, 0xb0f2, 0xb0f3, 0xb0f4, 0xb0f5, 0xb0f6, 0xb0f7, 0xb0f8, 0xb0f9, 0xb0fa, 0xb0fb, 0xb0fc, 0xb0fd, 0xb0fe, 0xb0ff, 
/* 0x8690 */
0xb100, 0xb101, 0xb102, 0xb103, 0xb104, 0xb105, 0xb106, 0xb107, 0xb10a, 0xb10d, 0xb10e, 0xb10f, 0xb111, 0xb114, 0xb115, 0xb116, 
/* 0x86a0 */
0xb117, 0xb11a, 0xb11e, 0xb11f, 0xb120, 0xb121, 0xb122, 0xb126, 0xb127, 0xb129, 0xb12a, 0xb12b, 0xb12d, 0xb12e, 0xb12f, 0xb130, 
/* 0x86b0 */
0xb131, 0xb132, 0xb133, 0xb136, 0xb13a, 0xb13b, 0xb13c, 0xb13d, 0xb13e, 0xb13f, 0xb142, 0xb143, 0xb145, 0xb146, 0xb147, 0xb149, 
/* 0x86c0 */
0xb14a, 0xb14b, 0xb14c, 0xb14d, 0xb14e, 0xb14f, 0xb152, 0xb153, 0xb156, 0xb157, 0xb159, 0xb15a, 0xb15b, 0xb15d, 0xb15e, 0xb15f, 
/* 0x86d0 */
0xb161, 0xb162, 0xb163, 0xb164, 0xb165, 0xb166, 0xb167, 0xb168, 0xb169, 0xb16a, 0xb16b, 0xb16c, 0xb16d, 0xb16e, 0xb16f, 0xb170, 
/* 0x86e0 */
0xb171, 0xb172, 0xb173, 0xb174, 0xb175, 0xb176, 0xb177, 0xb17a, 0xb17b, 0xb17d, 0xb17e, 0xb17f, 0xb181, 0xb183, 0xb184, 0xb185, 
/* 0x86f0 */
0xb186, 0xb187, 0xb18a, 0xb18c, 0xb18e, 0xb18f, 0xb190, 0xb191, 0xb195, 0xb196, 0xb197, 0xb199, 0xb19a, 0xb19b, 0xb19d, 
};
static struct cp2unicode_row korean_row_86 = { 0x86, 0x41, 0xbe, korean_row_codes_86 };
static unicode_t korean_row_codes_87[] =
{
/* 0x8741 */
0xb19e, 0xb19f, 0xb1a0, 0xb1a1, 0xb1a2, 0xb1a3, 0xb1a4, 0xb1a5, 0xb1a6, 0xb1a7, 0xb1a9, 0xb1aa, 0xb1ab, 0xb1ac, 0xb1ad, 
/* 0x8750 */
0xb1ae, 0xb1af, 0xb1b0, 0xb1b1, 0xb1b2, 0xb1b3, 0xb1b4, 0xb1b5, 0xb1b6, 0xb1b7, 0xb1b8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8760 */
0x0000, 0xb1b9, 0xb1ba, 0xb1bb, 0xb1bc, 0xb1bd, 0xb1be, 0xb1bf, 0xb1c0, 0xb1c1, 0xb1c2, 0xb1c3, 0xb1c4, 0xb1c5, 0xb1c6, 0xb1c7, 
/* 0x8770 */
0xb1c8, 0xb1c9, 0xb1ca, 0xb1cb, 0xb1cd, 0xb1ce, 0xb1cf, 0xb1d1, 0xb1d2, 0xb1d3, 0xb1d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8780 */
0x0000, 0xb1d6, 0xb1d7, 0xb1d8, 0xb1d9, 0xb1da, 0xb1db, 0xb1de, 0xb1e0, 0xb1e1, 0xb1e2, 0xb1e3, 0xb1e4, 0xb1e5, 0xb1e6, 0xb1e7, 
/* 0x8790 */
0xb1ea, 0xb1eb, 0xb1ed, 0xb1ee, 0xb1ef, 0xb1f1, 0xb1f2, 0xb1f3, 0xb1f4, 0xb1f5, 0xb1f6, 0xb1f7, 0xb1f8, 0xb1fa, 0xb1fc, 0xb1fe, 
/* 0x87a0 */
0xb1ff, 0xb200, 0xb201, 0xb202, 0xb203, 0xb206, 0xb207, 0xb209, 0xb20a, 0xb20d, 0xb20e, 0xb20f, 0xb210, 0xb211, 0xb212, 0xb213, 
/* 0x87b0 */
0xb216, 0xb218, 0xb21a, 0xb21b, 0xb21c, 0xb21d, 0xb21e, 0xb21f, 0xb221, 0xb222, 0xb223, 0xb224, 0xb225, 0xb226, 0xb227, 0xb228, 
/* 0x87c0 */
0xb229, 0xb22a, 0xb22b, 0xb22c, 0xb22d, 0xb22e, 0xb22f, 0xb230, 0xb231, 0xb232, 0xb233, 0xb235, 0xb236, 0xb237, 0xb238, 0xb239, 
/* 0x87d0 */
0xb23a, 0xb23b, 0xb23d, 0xb23e, 0xb23f, 0xb240, 0xb241, 0xb242, 0xb243, 0xb244, 0xb245, 0xb246, 0xb247, 0xb248, 0xb249, 0xb24a, 
/* 0x87e0 */
0xb24b, 0xb24c, 0xb24d, 0xb24e, 0xb24f, 0xb250, 0xb251, 0xb252, 0xb253, 0xb254, 0xb255, 0xb256, 0xb257, 0xb259, 0xb25a, 0xb25b, 
/* 0x87f0 */
0xb25d, 0xb25e, 0xb25f, 0xb261, 0xb262, 0xb263, 0xb264, 0xb265, 0xb266, 0xb267, 0xb26a, 0xb26b, 0xb26c, 0xb26d, 0xb26e, 
};
static struct cp2unicode_row korean_row_87 = { 0x87, 0x41, 0xbe, korean_row_codes_87 };
static unicode_t korean_row_codes_88[] =
{
/* 0x8841 */
0xb26f, 0xb270, 0xb271, 0xb272, 0xb273, 0xb276, 0xb277, 0xb278, 0xb279, 0xb27a, 0xb27b, 0xb27d, 0xb27e, 0xb27f, 0xb280, 
/* 0x8850 */
0xb281, 0xb282, 0xb283, 0xb286, 0xb287, 0xb288, 0xb28a, 0xb28b, 0xb28c, 0xb28d, 0xb28e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8860 */
0x0000, 0xb28f, 0xb292, 0xb293, 0xb295, 0xb296, 0xb297, 0xb29b, 0xb29c, 0xb29d, 0xb29e, 0xb29f, 0xb2a2, 0xb2a4, 0xb2a7, 0xb2a8, 
/* 0x8870 */
0xb2a9, 0xb2ab, 0xb2ad, 0xb2ae, 0xb2af, 0xb2b1, 0xb2b2, 0xb2b3, 0xb2b5, 0xb2b6, 0xb2b7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8880 */
0x0000, 0xb2b8, 0xb2b9, 0xb2ba, 0xb2bb, 0xb2bc, 0xb2bd, 0xb2be, 0xb2bf, 0xb2c0, 0xb2c1, 0xb2c2, 0xb2c3, 0xb2c4, 0xb2c5, 0xb2c6, 
/* 0x8890 */
0xb2c7, 0xb2ca, 0xb2cb, 0xb2cd, 0xb2ce, 0xb2cf, 0xb2d1, 0xb2d3, 0xb2d4, 0xb2d5, 0xb2d6, 0xb2d7, 0xb2da, 0xb2dc, 0xb2de, 0xb2df, 
/* 0x88a0 */
0xb2e0, 0xb2e1, 0xb2e3, 0xb2e7, 0xb2e9, 0xb2ea, 0xb2f0, 0xb2f1, 0xb2f2, 0xb2f6, 0xb2fc, 0xb2fd, 0xb2fe, 0xb302, 0xb303, 0xb305, 
/* 0x88b0 */
0xb306, 0xb307, 0xb309, 0xb30a, 0xb30b, 0xb30c, 0xb30d, 0xb30e, 0xb30f, 0xb312, 0xb316, 0xb317, 0xb318, 0xb319, 0xb31a, 0xb31b, 
/* 0x88c0 */
0xb31d, 0xb31e, 0xb31f, 0xb320, 0xb321, 0xb322, 0xb323, 0xb324, 0xb325, 0xb326, 0xb327, 0xb328, 0xb329, 0xb32a, 0xb32b, 0xb32c, 
/* 0x88d0 */
0xb32d, 0xb32e, 0xb32f, 0xb330, 0xb331, 0xb332, 0xb333, 0xb334, 0xb335, 0xb336, 0xb337, 0xb338, 0xb339, 0xb33a, 0xb33b, 0xb33c, 
/* 0x88e0 */
0xb33d, 0xb33e, 0xb33f, 0xb340, 0xb341, 0xb342, 0xb343, 0xb344, 0xb345, 0xb346, 0xb347, 0xb348, 0xb349, 0xb34a, 0xb34b, 0xb34c, 
/* 0x88f0 */
0xb34d, 0xb34e, 0xb34f, 0xb350, 0xb351, 0xb352, 0xb353, 0xb357, 0xb359, 0xb35a, 0xb35d, 0xb360, 0xb361, 0xb362, 0xb363, 
};
static struct cp2unicode_row korean_row_88 = { 0x88, 0x41, 0xbe, korean_row_codes_88 };
static unicode_t korean_row_codes_89[] =
{
/* 0x8941 */
0xb366, 0xb368, 0xb36a, 0xb36c, 0xb36d, 0xb36f, 0xb372, 0xb373, 0xb375, 0xb376, 0xb377, 0xb379, 0xb37a, 0xb37b, 0xb37c, 
/* 0x8950 */
0xb37d, 0xb37e, 0xb37f, 0xb382, 0xb386, 0xb387, 0xb388, 0xb389, 0xb38a, 0xb38b, 0xb38d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8960 */
0x0000, 0xb38e, 0xb38f, 0xb391, 0xb392, 0xb393, 0xb395, 0xb396, 0xb397, 0xb398, 0xb399, 0xb39a, 0xb39b, 0xb39c, 0xb39d, 0xb39e, 
/* 0x8970 */
0xb39f, 0xb3a2, 0xb3a3, 0xb3a4, 0xb3a5, 0xb3a6, 0xb3a7, 0xb3a9, 0xb3aa, 0xb3ab, 0xb3ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8980 */
0x0000, 0xb3ae, 0xb3af, 0xb3b0, 0xb3b1, 0xb3b2, 0xb3b3, 0xb3b4, 0xb3b5, 0xb3b6, 0xb3b7, 0xb3b8, 0xb3b9, 0xb3ba, 0xb3bb, 0xb3bc, 
/* 0x8990 */
0xb3bd, 0xb3be, 0xb3bf, 0xb3c0, 0xb3c1, 0xb3c2, 0xb3c3, 0xb3c6, 0xb3c7, 0xb3c9, 0xb3ca, 0xb3cd, 0xb3cf, 0xb3d1, 0xb3d2, 0xb3d3, 
/* 0x89a0 */
0xb3d6, 0xb3d8, 0xb3da, 0xb3dc, 0xb3de, 0xb3df, 0xb3e1, 0xb3e2, 0xb3e3, 0xb3e5, 0xb3e6, 0xb3e7, 0xb3e9, 0xb3ea, 0xb3eb, 0xb3ec, 
/* 0x89b0 */
0xb3ed, 0xb3ee, 0xb3ef, 0xb3f0, 0xb3f1, 0xb3f2, 0xb3f3, 0xb3f4, 0xb3f5, 0xb3f6, 0xb3f7, 0xb3f8, 0xb3f9, 0xb3fa, 0xb3fb, 0xb3fd, 
/* 0x89c0 */
0xb3fe, 0xb3ff, 0xb400, 0xb401, 0xb402, 0xb403, 0xb404, 0xb405, 0xb406, 0xb407, 0xb408, 0xb409, 0xb40a, 0xb40b, 0xb40c, 0xb40d, 
/* 0x89d0 */
0xb40e, 0xb40f, 0xb411, 0xb412, 0xb413, 0xb414, 0xb415, 0xb416, 0xb417, 0xb419, 0xb41a, 0xb41b, 0xb41d, 0xb41e, 0xb41f, 0xb421, 
/* 0x89e0 */
0xb422, 0xb423, 0xb424, 0xb425, 0xb426, 0xb427, 0xb42a, 0xb42c, 0xb42d, 0xb42e, 0xb42f, 0xb430, 0xb431, 0xb432, 0xb433, 0xb435, 
/* 0x89f0 */
0xb436, 0xb437, 0xb438, 0xb439, 0xb43a, 0xb43b, 0xb43c, 0xb43d, 0xb43e, 0xb43f, 0xb440, 0xb441, 0xb442, 0xb443, 0xb444, 
};
static struct cp2unicode_row korean_row_89 = { 0x89, 0x41, 0xbe, korean_row_codes_89 };
static unicode_t korean_row_codes_8a[] =
{
/* 0x8a41 */
0xb445, 0xb446, 0xb447, 0xb448, 0xb449, 0xb44a, 0xb44b, 0xb44c, 0xb44d, 0xb44e, 0xb44f, 0xb452, 0xb453, 0xb455, 0xb456, 
/* 0x8a50 */
0xb457, 0xb459, 0xb45a, 0xb45b, 0xb45c, 0xb45d, 0xb45e, 0xb45f, 0xb462, 0xb464, 0xb466, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8a60 */
0x0000, 0xb467, 0xb468, 0xb469, 0xb46a, 0xb46b, 0xb46d, 0xb46e, 0xb46f, 0xb470, 0xb471, 0xb472, 0xb473, 0xb474, 0xb475, 0xb476, 
/* 0x8a70 */
0xb477, 0xb478, 0xb479, 0xb47a, 0xb47b, 0xb47c, 0xb47d, 0xb47e, 0xb47f, 0xb481, 0xb482, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8a80 */
0x0000, 0xb483, 0xb484, 0xb485, 0xb486, 0xb487, 0xb489, 0xb48a, 0xb48b, 0xb48c, 0xb48d, 0xb48e, 0xb48f, 0xb490, 0xb491, 0xb492, 
/* 0x8a90 */
0xb493, 0xb494, 0xb495, 0xb496, 0xb497, 0xb498, 0xb499, 0xb49a, 0xb49b, 0xb49c, 0xb49e, 0xb49f, 0xb4a0, 0xb4a1, 0xb4a2, 0xb4a3, 
/* 0x8aa0 */
0xb4a5, 0xb4a6, 0xb4a7, 0xb4a9, 0xb4aa, 0xb4ab, 0xb4ad, 0xb4ae, 0xb4af, 0xb4b0, 0xb4b1, 0xb4b2, 0xb4b3, 0xb4b4, 0xb4b6, 0xb4b8, 
/* 0x8ab0 */
0xb4ba, 0xb4bb, 0xb4bc, 0xb4bd, 0xb4be, 0xb4bf, 0xb4c1, 0xb4c2, 0xb4c3, 0xb4c5, 0xb4c6, 0xb4c7, 0xb4c9, 0xb4ca, 0xb4cb, 0xb4cc, 
/* 0x8ac0 */
0xb4cd, 0xb4ce, 0xb4cf, 0xb4d1, 0xb4d2, 0xb4d3, 0xb4d4, 0xb4d6, 0xb4d7, 0xb4d8, 0xb4d9, 0xb4da, 0xb4db, 0xb4de, 0xb4df, 0xb4e1, 
/* 0x8ad0 */
0xb4e2, 0xb4e5, 0xb4e7, 0xb4e8, 0xb4e9, 0xb4ea, 0xb4eb, 0xb4ee, 0xb4f0, 0xb4f2, 0xb4f3, 0xb4f4, 0xb4f5, 0xb4f6, 0xb4f7, 0xb4f9, 
/* 0x8ae0 */
0xb4fa, 0xb4fb, 0xb4fc, 0xb4fd, 0xb4fe, 0xb4ff, 0xb500, 0xb501, 0xb502, 0xb503, 0xb504, 0xb505, 0xb506, 0xb507, 0xb508, 0xb509, 
/* 0x8af0 */
0xb50a, 0xb50b, 0xb50c, 0xb50d, 0xb50e, 0xb50f, 0xb510, 0xb511, 0xb512, 0xb513, 0xb516, 0xb517, 0xb519, 0xb51a, 0xb51d, 
};
static struct cp2unicode_row korean_row_8a = { 0x8a, 0x41, 0xbe, korean_row_codes_8a };
static unicode_t korean_row_codes_8b[] =
{
/* 0x8b41 */
0xb51e, 0xb51f, 0xb520, 0xb521, 0xb522, 0xb523, 0xb526, 0xb52b, 0xb52c, 0xb52d, 0xb52e, 0xb52f, 0xb532, 0xb533, 0xb535, 
/* 0x8b50 */
0xb536, 0xb537, 0xb539, 0xb53a, 0xb53b, 0xb53c, 0xb53d, 0xb53e, 0xb53f, 0xb542, 0xb546, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8b60 */
0x0000, 0xb547, 0xb548, 0xb549, 0xb54a, 0xb54e, 0xb54f, 0xb551, 0xb552, 0xb553, 0xb555, 0xb556, 0xb557, 0xb558, 0xb559, 0xb55a, 
/* 0x8b70 */
0xb55b, 0xb55e, 0xb562, 0xb563, 0xb564, 0xb565, 0xb566, 0xb567, 0xb568, 0xb569, 0xb56a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8b80 */
0x0000, 0xb56b, 0xb56c, 0xb56d, 0xb56e, 0xb56f, 0xb570, 0xb571, 0xb572, 0xb573, 0xb574, 0xb575, 0xb576, 0xb577, 0xb578, 0xb579, 
/* 0x8b90 */
0xb57a, 0xb57b, 0xb57c, 0xb57d, 0xb57e, 0xb57f, 0xb580, 0xb581, 0xb582, 0xb583, 0xb584, 0xb585, 0xb586, 0xb587, 0xb588, 0xb589, 
/* 0x8ba0 */
0xb58a, 0xb58b, 0xb58c, 0xb58d, 0xb58e, 0xb58f, 0xb590, 0xb591, 0xb592, 0xb593, 0xb594, 0xb595, 0xb596, 0xb597, 0xb598, 0xb599, 
/* 0x8bb0 */
0xb59a, 0xb59b, 0xb59c, 0xb59d, 0xb59e, 0xb59f, 0xb5a2, 0xb5a3, 0xb5a5, 0xb5a6, 0xb5a7, 0xb5a9, 0xb5ac, 0xb5ad, 0xb5ae, 0xb5af, 
/* 0x8bc0 */
0xb5b2, 0xb5b6, 0xb5b7, 0xb5b8, 0xb5b9, 0xb5ba, 0xb5be, 0xb5bf, 0xb5c1, 0xb5c2, 0xb5c3, 0xb5c5, 0xb5c6, 0xb5c7, 0xb5c8, 0xb5c9, 
/* 0x8bd0 */
0xb5ca, 0xb5cb, 0xb5ce, 0xb5d2, 0xb5d3, 0xb5d4, 0xb5d5, 0xb5d6, 0xb5d7, 0xb5d9, 0xb5da, 0xb5db, 0xb5dc, 0xb5dd, 0xb5de, 0xb5df, 
/* 0x8be0 */
0xb5e0, 0xb5e1, 0xb5e2, 0xb5e3, 0xb5e4, 0xb5e5, 0xb5e6, 0xb5e7, 0xb5e8, 0xb5e9, 0xb5ea, 0xb5eb, 0xb5ed, 0xb5ee, 0xb5ef, 0xb5f0, 
/* 0x8bf0 */
0xb5f1, 0xb5f2, 0xb5f3, 0xb5f4, 0xb5f5, 0xb5f6, 0xb5f7, 0xb5f8, 0xb5f9, 0xb5fa, 0xb5fb, 0xb5fc, 0xb5fd, 0xb5fe, 0xb5ff, 
};
static struct cp2unicode_row korean_row_8b = { 0x8b, 0x41, 0xbe, korean_row_codes_8b };
static unicode_t korean_row_codes_8c[] =
{
/* 0x8c41 */
0xb600, 0xb601, 0xb602, 0xb603, 0xb604, 0xb605, 0xb606, 0xb607, 0xb608, 0xb609, 0xb60a, 0xb60b, 0xb60c, 0xb60d, 0xb60e, 
/* 0x8c50 */
0xb60f, 0xb612, 0xb613, 0xb615, 0xb616, 0xb617, 0xb619, 0xb61a, 0xb61b, 0xb61c, 0xb61d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8c60 */
0x0000, 0xb61e, 0xb61f, 0xb620, 0xb621, 0xb622, 0xb623, 0xb624, 0xb626, 0xb627, 0xb628, 0xb629, 0xb62a, 0xb62b, 0xb62d, 0xb62e, 
/* 0x8c70 */
0xb62f, 0xb630, 0xb631, 0xb632, 0xb633, 0xb635, 0xb636, 0xb637, 0xb638, 0xb639, 0xb63a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8c80 */
0x0000, 0xb63b, 0xb63c, 0xb63d, 0xb63e, 0xb63f, 0xb640, 0xb641, 0xb642, 0xb643, 0xb644, 0xb645, 0xb646, 0xb647, 0xb649, 0xb64a, 
/* 0x8c90 */
0xb64b, 0xb64c, 0xb64d, 0xb64e, 0xb64f, 0xb650, 0xb651, 0xb652, 0xb653, 0xb654, 0xb655, 0xb656, 0xb657, 0xb658, 0xb659, 0xb65a, 
/* 0x8ca0 */
0xb65b, 0xb65c, 0xb65d, 0xb65e, 0xb65f, 0xb660, 0xb661, 0xb662, 0xb663, 0xb665, 0xb666, 0xb667, 0xb669, 0xb66a, 0xb66b, 0xb66c, 
/* 0x8cb0 */
0xb66d, 0xb66e, 0xb66f, 0xb670, 0xb671, 0xb672, 0xb673, 0xb674, 0xb675, 0xb676, 0xb677, 0xb678, 0xb679, 0xb67a, 0xb67b, 0xb67c, 
/* 0x8cc0 */
0xb67d, 0xb67e, 0xb67f, 0xb680, 0xb681, 0xb682, 0xb683, 0xb684, 0xb685, 0xb686, 0xb687, 0xb688, 0xb689, 0xb68a, 0xb68b, 0xb68c, 
/* 0x8cd0 */
0xb68d, 0xb68e, 0xb68f, 0xb690, 0xb691, 0xb692, 0xb693, 0xb694, 0xb695, 0xb696, 0xb697, 0xb698, 0xb699, 0xb69a, 0xb69b, 0xb69e, 
/* 0x8ce0 */
0xb69f, 0xb6a1, 0xb6a2, 0xb6a3, 0xb6a5, 0xb6a6, 0xb6a7, 0xb6a8, 0xb6a9, 0xb6aa, 0xb6ad, 0xb6ae, 0xb6af, 0xb6b0, 0xb6b2, 0xb6b3, 
/* 0x8cf0 */
0xb6b4, 0xb6b5, 0xb6b6, 0xb6b7, 0xb6b8, 0xb6b9, 0xb6ba, 0xb6bb, 0xb6bc, 0xb6bd, 0xb6be, 0xb6bf, 0xb6c0, 0xb6c1, 0xb6c2, 
};
static struct cp2unicode_row korean_row_8c = { 0x8c, 0x41, 0xbe, korean_row_codes_8c };
static unicode_t korean_row_codes_8d[] =
{
/* 0x8d41 */
0xb6c3, 0xb6c4, 0xb6c5, 0xb6c6, 0xb6c7, 0xb6c8, 0xb6c9, 0xb6ca, 0xb6cb, 0xb6cc, 0xb6cd, 0xb6ce, 0xb6cf, 0xb6d0, 0xb6d1, 
/* 0x8d50 */
0xb6d2, 0xb6d3, 0xb6d5, 0xb6d6, 0xb6d7, 0xb6d8, 0xb6d9, 0xb6da, 0xb6db, 0xb6dc, 0xb6dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8d60 */
0x0000, 0xb6de, 0xb6df, 0xb6e0, 0xb6e1, 0xb6e2, 0xb6e3, 0xb6e4, 0xb6e5, 0xb6e6, 0xb6e7, 0xb6e8, 0xb6e9, 0xb6ea, 0xb6eb, 0xb6ec, 
/* 0x8d70 */
0xb6ed, 0xb6ee, 0xb6ef, 0xb6f1, 0xb6f2, 0xb6f3, 0xb6f5, 0xb6f6, 0xb6f7, 0xb6f9, 0xb6fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8d80 */
0x0000, 0xb6fb, 0xb6fc, 0xb6fd, 0xb6fe, 0xb6ff, 0xb702, 0xb703, 0xb704, 0xb706, 0xb707, 0xb708, 0xb709, 0xb70a, 0xb70b, 0xb70c, 
/* 0x8d90 */
0xb70d, 0xb70e, 0xb70f, 0xb710, 0xb711, 0xb712, 0xb713, 0xb714, 0xb715, 0xb716, 0xb717, 0xb718, 0xb719, 0xb71a, 0xb71b, 0xb71c, 
/* 0x8da0 */
0xb71d, 0xb71e, 0xb71f, 0xb720, 0xb721, 0xb722, 0xb723, 0xb724, 0xb725, 0xb726, 0xb727, 0xb72a, 0xb72b, 0xb72d, 0xb72e, 0xb731, 
/* 0x8db0 */
0xb732, 0xb733, 0xb734, 0xb735, 0xb736, 0xb737, 0xb73a, 0xb73c, 0xb73d, 0xb73e, 0xb73f, 0xb740, 0xb741, 0xb742, 0xb743, 0xb745, 
/* 0x8dc0 */
0xb746, 0xb747, 0xb749, 0xb74a, 0xb74b, 0xb74d, 0xb74e, 0xb74f, 0xb750, 0xb751, 0xb752, 0xb753, 0xb756, 0xb757, 0xb758, 0xb759, 
/* 0x8dd0 */
0xb75a, 0xb75b, 0xb75c, 0xb75d, 0xb75e, 0xb75f, 0xb761, 0xb762, 0xb763, 0xb765, 0xb766, 0xb767, 0xb769, 0xb76a, 0xb76b, 0xb76c, 
/* 0x8de0 */
0xb76d, 0xb76e, 0xb76f, 0xb772, 0xb774, 0xb776, 0xb777, 0xb778, 0xb779, 0xb77a, 0xb77b, 0xb77e, 0xb77f, 0xb781, 0xb782, 0xb783, 
/* 0x8df0 */
0xb785, 0xb786, 0xb787, 0xb788, 0xb789, 0xb78a, 0xb78b, 0xb78e, 0xb793, 0xb794, 0xb795, 0xb79a, 0xb79b, 0xb79d, 0xb79e, 
};
static struct cp2unicode_row korean_row_8d = { 0x8d, 0x41, 0xbe, korean_row_codes_8d };
static unicode_t korean_row_codes_8e[] =
{
/* 0x8e41 */
0xb79f, 0xb7a1, 0xb7a2, 0xb7a3, 0xb7a4, 0xb7a5, 0xb7a6, 0xb7a7, 0xb7aa, 0xb7ae, 0xb7af, 0xb7b0, 0xb7b1, 0xb7b2, 0xb7b3, 
/* 0x8e50 */
0xb7b6, 0xb7b7, 0xb7b9, 0xb7ba, 0xb7bb, 0xb7bc, 0xb7bd, 0xb7be, 0xb7bf, 0xb7c0, 0xb7c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8e60 */
0x0000, 0xb7c2, 0xb7c3, 0xb7c4, 0xb7c5, 0xb7c6, 0xb7c8, 0xb7ca, 0xb7cb, 0xb7cc, 0xb7cd, 0xb7ce, 0xb7cf, 0xb7d0, 0xb7d1, 0xb7d2, 
/* 0x8e70 */
0xb7d3, 0xb7d4, 0xb7d5, 0xb7d6, 0xb7d7, 0xb7d8, 0xb7d9, 0xb7da, 0xb7db, 0xb7dc, 0xb7dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8e80 */
0x0000, 0xb7de, 0xb7df, 0xb7e0, 0xb7e1, 0xb7e2, 0xb7e3, 0xb7e4, 0xb7e5, 0xb7e6, 0xb7e7, 0xb7e8, 0xb7e9, 0xb7ea, 0xb7eb, 0xb7ee, 
/* 0x8e90 */
0xb7ef, 0xb7f1, 0xb7f2, 0xb7f3, 0xb7f5, 0xb7f6, 0xb7f7, 0xb7f8, 0xb7f9, 0xb7fa, 0xb7fb, 0xb7fe, 0xb802, 0xb803, 0xb804, 0xb805, 
/* 0x8ea0 */
0xb806, 0xb80a, 0xb80b, 0xb80d, 0xb80e, 0xb80f, 0xb811, 0xb812, 0xb813, 0xb814, 0xb815, 0xb816, 0xb817, 0xb81a, 0xb81c, 0xb81e, 
/* 0x8eb0 */
0xb81f, 0xb820, 0xb821, 0xb822, 0xb823, 0xb826, 0xb827, 0xb829, 0xb82a, 0xb82b, 0xb82d, 0xb82e, 0xb82f, 0xb830, 0xb831, 0xb832, 
/* 0x8ec0 */
0xb833, 0xb836, 0xb83a, 0xb83b, 0xb83c, 0xb83d, 0xb83e, 0xb83f, 0xb841, 0xb842, 0xb843, 0xb845, 0xb846, 0xb847, 0xb848, 0xb849, 
/* 0x8ed0 */
0xb84a, 0xb84b, 0xb84c, 0xb84d, 0xb84e, 0xb84f, 0xb850, 0xb852, 0xb854, 0xb855, 0xb856, 0xb857, 0xb858, 0xb859, 0xb85a, 0xb85b, 
/* 0x8ee0 */
0xb85e, 0xb85f, 0xb861, 0xb862, 0xb863, 0xb865, 0xb866, 0xb867, 0xb868, 0xb869, 0xb86a, 0xb86b, 0xb86e, 0xb870, 0xb872, 0xb873, 
/* 0x8ef0 */
0xb874, 0xb875, 0xb876, 0xb877, 0xb879, 0xb87a, 0xb87b, 0xb87d, 0xb87e, 0xb87f, 0xb880, 0xb881, 0xb882, 0xb883, 0xb884, 
};
static struct cp2unicode_row korean_row_8e = { 0x8e, 0x41, 0xbe, korean_row_codes_8e };
static unicode_t korean_row_codes_8f[] =
{
/* 0x8f41 */
0xb885, 0xb886, 0xb887, 0xb888, 0xb889, 0xb88a, 0xb88b, 0xb88c, 0xb88e, 0xb88f, 0xb890, 0xb891, 0xb892, 0xb893, 0xb894, 
/* 0x8f50 */
0xb895, 0xb896, 0xb897, 0xb898, 0xb899, 0xb89a, 0xb89b, 0xb89c, 0xb89d, 0xb89e, 0xb89f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8f60 */
0x0000, 0xb8a0, 0xb8a1, 0xb8a2, 0xb8a3, 0xb8a4, 0xb8a5, 0xb8a6, 0xb8a7, 0xb8a9, 0xb8aa, 0xb8ab, 0xb8ac, 0xb8ad, 0xb8ae, 0xb8af, 
/* 0x8f70 */
0xb8b1, 0xb8b2, 0xb8b3, 0xb8b5, 0xb8b6, 0xb8b7, 0xb8b9, 0xb8ba, 0xb8bb, 0xb8bc, 0xb8bd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x8f80 */
0x0000, 0xb8be, 0xb8bf, 0xb8c2, 0xb8c4, 0xb8c6, 0xb8c7, 0xb8c8, 0xb8c9, 0xb8ca, 0xb8cb, 0xb8cd, 0xb8ce, 0xb8cf, 0xb8d1, 0xb8d2, 
/* 0x8f90 */
0xb8d3, 0xb8d5, 0xb8d6, 0xb8d7, 0xb8d8, 0xb8d9, 0xb8da, 0xb8db, 0xb8dc, 0xb8de, 0xb8e0, 0xb8e2, 0xb8e3, 0xb8e4, 0xb8e5, 0xb8e6, 
/* 0x8fa0 */
0xb8e7, 0xb8ea, 0xb8eb, 0xb8ed, 0xb8ee, 0xb8ef, 0xb8f1, 0xb8f2, 0xb8f3, 0xb8f4, 0xb8f5, 0xb8f6, 0xb8f7, 0xb8fa, 0xb8fc, 0xb8fe, 
/* 0x8fb0 */
0xb8ff, 0xb900, 0xb901, 0xb902, 0xb903, 0xb905, 0xb906, 0xb907, 0xb908, 0xb909, 0xb90a, 0xb90b, 0xb90c, 0xb90d, 0xb90e, 0xb90f, 
/* 0x8fc0 */
0xb910, 0xb911, 0xb912, 0xb913, 0xb914, 0xb915, 0xb916, 0xb917, 0xb919, 0xb91a, 0xb91b, 0xb91c, 0xb91d, 0xb91e, 0xb91f, 0xb921, 
/* 0x8fd0 */
0xb922, 0xb923, 0xb924, 0xb925, 0xb926, 0xb927, 0xb928, 0xb929, 0xb92a, 0xb92b, 0xb92c, 0xb92d, 0xb92e, 0xb92f, 0xb930, 0xb931, 
/* 0x8fe0 */
0xb932, 0xb933, 0xb934, 0xb935, 0xb936, 0xb937, 0xb938, 0xb939, 0xb93a, 0xb93b, 0xb93e, 0xb93f, 0xb941, 0xb942, 0xb943, 0xb945, 
/* 0x8ff0 */
0xb946, 0xb947, 0xb948, 0xb949, 0xb94a, 0xb94b, 0xb94d, 0xb94e, 0xb950, 0xb952, 0xb953, 0xb954, 0xb955, 0xb956, 0xb957, 
};
static struct cp2unicode_row korean_row_8f = { 0x8f, 0x41, 0xbe, korean_row_codes_8f };
static unicode_t korean_row_codes_90[] =
{
/* 0x9041 */
0xb95a, 0xb95b, 0xb95d, 0xb95e, 0xb95f, 0xb961, 0xb962, 0xb963, 0xb964, 0xb965, 0xb966, 0xb967, 0xb96a, 0xb96c, 0xb96e, 
/* 0x9050 */
0xb96f, 0xb970, 0xb971, 0xb972, 0xb973, 0xb976, 0xb977, 0xb979, 0xb97a, 0xb97b, 0xb97d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9060 */
0x0000, 0xb97e, 0xb97f, 0xb980, 0xb981, 0xb982, 0xb983, 0xb986, 0xb988, 0xb98b, 0xb98c, 0xb98f, 0xb990, 0xb991, 0xb992, 0xb993, 
/* 0x9070 */
0xb994, 0xb995, 0xb996, 0xb997, 0xb998, 0xb999, 0xb99a, 0xb99b, 0xb99c, 0xb99d, 0xb99e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9080 */
0x0000, 0xb99f, 0xb9a0, 0xb9a1, 0xb9a2, 0xb9a3, 0xb9a4, 0xb9a5, 0xb9a6, 0xb9a7, 0xb9a8, 0xb9a9, 0xb9aa, 0xb9ab, 0xb9ae, 0xb9af, 
/* 0x9090 */
0xb9b1, 0xb9b2, 0xb9b3, 0xb9b5, 0xb9b6, 0xb9b7, 0xb9b8, 0xb9b9, 0xb9ba, 0xb9bb, 0xb9be, 0xb9c0, 0xb9c2, 0xb9c3, 0xb9c4, 0xb9c5, 
/* 0x90a0 */
0xb9c6, 0xb9c7, 0xb9ca, 0xb9cb, 0xb9cd, 0xb9d3, 0xb9d4, 0xb9d5, 0xb9d6, 0xb9d7, 0xb9da, 0xb9dc, 0xb9df, 0xb9e0, 0xb9e2, 0xb9e6, 
/* 0x90b0 */
0xb9e7, 0xb9e9, 0xb9ea, 0xb9eb, 0xb9ed, 0xb9ee, 0xb9ef, 0xb9f0, 0xb9f1, 0xb9f2, 0xb9f3, 0xb9f6, 0xb9fb, 0xb9fc, 0xb9fd, 0xb9fe, 
/* 0x90c0 */
0xb9ff, 0xba02, 0xba03, 0xba04, 0xba05, 0xba06, 0xba07, 0xba09, 0xba0a, 0xba0b, 0xba0c, 0xba0d, 0xba0e, 0xba0f, 0xba10, 0xba11, 
/* 0x90d0 */
0xba12, 0xba13, 0xba14, 0xba16, 0xba17, 0xba18, 0xba19, 0xba1a, 0xba1b, 0xba1c, 0xba1d, 0xba1e, 0xba1f, 0xba20, 0xba21, 0xba22, 
/* 0x90e0 */
0xba23, 0xba24, 0xba25, 0xba26, 0xba27, 0xba28, 0xba29, 0xba2a, 0xba2b, 0xba2c, 0xba2d, 0xba2e, 0xba2f, 0xba30, 0xba31, 0xba32, 
/* 0x90f0 */
0xba33, 0xba34, 0xba35, 0xba36, 0xba37, 0xba3a, 0xba3b, 0xba3d, 0xba3e, 0xba3f, 0xba41, 0xba43, 0xba44, 0xba45, 0xba46, 
};
static struct cp2unicode_row korean_row_90 = { 0x90, 0x41, 0xbe, korean_row_codes_90 };
static unicode_t korean_row_codes_91[] =
{
/* 0x9141 */
0xba47, 0xba4a, 0xba4c, 0xba4f, 0xba50, 0xba51, 0xba52, 0xba56, 0xba57, 0xba59, 0xba5a, 0xba5b, 0xba5d, 0xba5e, 0xba5f, 
/* 0x9150 */
0xba60, 0xba61, 0xba62, 0xba63, 0xba66, 0xba6a, 0xba6b, 0xba6c, 0xba6d, 0xba6e, 0xba6f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9160 */
0x0000, 0xba72, 0xba73, 0xba75, 0xba76, 0xba77, 0xba79, 0xba7a, 0xba7b, 0xba7c, 0xba7d, 0xba7e, 0xba7f, 0xba80, 0xba81, 0xba82, 
/* 0x9170 */
0xba86, 0xba88, 0xba89, 0xba8a, 0xba8b, 0xba8d, 0xba8e, 0xba8f, 0xba90, 0xba91, 0xba92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9180 */
0x0000, 0xba93, 0xba94, 0xba95, 0xba96, 0xba97, 0xba98, 0xba99, 0xba9a, 0xba9b, 0xba9c, 0xba9d, 0xba9e, 0xba9f, 0xbaa0, 0xbaa1, 
/* 0x9190 */
0xbaa2, 0xbaa3, 0xbaa4, 0xbaa5, 0xbaa6, 0xbaa7, 0xbaaa, 0xbaad, 0xbaae, 0xbaaf, 0xbab1, 0xbab3, 0xbab4, 0xbab5, 0xbab6, 0xbab7, 
/* 0x91a0 */
0xbaba, 0xbabc, 0xbabe, 0xbabf, 0xbac0, 0xbac1, 0xbac2, 0xbac3, 0xbac5, 0xbac6, 0xbac7, 0xbac9, 0xbaca, 0xbacb, 0xbacc, 0xbacd, 
/* 0x91b0 */
0xbace, 0xbacf, 0xbad0, 0xbad1, 0xbad2, 0xbad3, 0xbad4, 0xbad5, 0xbad6, 0xbad7, 0xbada, 0xbadb, 0xbadc, 0xbadd, 0xbade, 0xbadf, 
/* 0x91c0 */
0xbae0, 0xbae1, 0xbae2, 0xbae3, 0xbae4, 0xbae5, 0xbae6, 0xbae7, 0xbae8, 0xbae9, 0xbaea, 0xbaeb, 0xbaec, 0xbaed, 0xbaee, 0xbaef, 
/* 0x91d0 */
0xbaf0, 0xbaf1, 0xbaf2, 0xbaf3, 0xbaf4, 0xbaf5, 0xbaf6, 0xbaf7, 0xbaf8, 0xbaf9, 0xbafa, 0xbafb, 0xbafd, 0xbafe, 0xbaff, 0xbb01, 
/* 0x91e0 */
0xbb02, 0xbb03, 0xbb05, 0xbb06, 0xbb07, 0xbb08, 0xbb09, 0xbb0a, 0xbb0b, 0xbb0c, 0xbb0e, 0xbb10, 0xbb12, 0xbb13, 0xbb14, 0xbb15, 
/* 0x91f0 */
0xbb16, 0xbb17, 0xbb19, 0xbb1a, 0xbb1b, 0xbb1d, 0xbb1e, 0xbb1f, 0xbb21, 0xbb22, 0xbb23, 0xbb24, 0xbb25, 0xbb26, 0xbb27, 
};
static struct cp2unicode_row korean_row_91 = { 0x91, 0x41, 0xbe, korean_row_codes_91 };
static unicode_t korean_row_codes_92[] =
{
/* 0x9241 */
0xbb28, 0xbb2a, 0xbb2c, 0xbb2d, 0xbb2e, 0xbb2f, 0xbb30, 0xbb31, 0xbb32, 0xbb33, 0xbb37, 0xbb39, 0xbb3a, 0xbb3f, 0xbb40, 
/* 0x9250 */
0xbb41, 0xbb42, 0xbb43, 0xbb46, 0xbb48, 0xbb4a, 0xbb4b, 0xbb4c, 0xbb4e, 0xbb51, 0xbb52, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9260 */
0x0000, 0xbb53, 0xbb55, 0xbb56, 0xbb57, 0xbb59, 0xbb5a, 0xbb5b, 0xbb5c, 0xbb5d, 0xbb5e, 0xbb5f, 0xbb60, 0xbb62, 0xbb64, 0xbb65, 
/* 0x9270 */
0xbb66, 0xbb67, 0xbb68, 0xbb69, 0xbb6a, 0xbb6b, 0xbb6d, 0xbb6e, 0xbb6f, 0xbb70, 0xbb71, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9280 */
0x0000, 0xbb72, 0xbb73, 0xbb74, 0xbb75, 0xbb76, 0xbb77, 0xbb78, 0xbb79, 0xbb7a, 0xbb7b, 0xbb7c, 0xbb7d, 0xbb7e, 0xbb7f, 0xbb80, 
/* 0x9290 */
0xbb81, 0xbb82, 0xbb83, 0xbb84, 0xbb85, 0xbb86, 0xbb87, 0xbb89, 0xbb8a, 0xbb8b, 0xbb8d, 0xbb8e, 0xbb8f, 0xbb91, 0xbb92, 0xbb93, 
/* 0x92a0 */
0xbb94, 0xbb95, 0xbb96, 0xbb97, 0xbb98, 0xbb99, 0xbb9a, 0xbb9b, 0xbb9c, 0xbb9d, 0xbb9e, 0xbb9f, 0xbba0, 0xbba1, 0xbba2, 0xbba3, 
/* 0x92b0 */
0xbba5, 0xbba6, 0xbba7, 0xbba9, 0xbbaa, 0xbbab, 0xbbad, 0xbbae, 0xbbaf, 0xbbb0, 0xbbb1, 0xbbb2, 0xbbb3, 0xbbb5, 0xbbb6, 0xbbb8, 
/* 0x92c0 */
0xbbb9, 0xbbba, 0xbbbb, 0xbbbc, 0xbbbd, 0xbbbe, 0xbbbf, 0xbbc1, 0xbbc2, 0xbbc3, 0xbbc5, 0xbbc6, 0xbbc7, 0xbbc9, 0xbbca, 0xbbcb, 
/* 0x92d0 */
0xbbcc, 0xbbcd, 0xbbce, 0xbbcf, 0xbbd1, 0xbbd2, 0xbbd4, 0xbbd5, 0xbbd6, 0xbbd7, 0xbbd8, 0xbbd9, 0xbbda, 0xbbdb, 0xbbdc, 0xbbdd, 
/* 0x92e0 */
0xbbde, 0xbbdf, 0xbbe0, 0xbbe1, 0xbbe2, 0xbbe3, 0xbbe4, 0xbbe5, 0xbbe6, 0xbbe7, 0xbbe8, 0xbbe9, 0xbbea, 0xbbeb, 0xbbec, 0xbbed, 
/* 0x92f0 */
0xbbee, 0xbbef, 0xbbf0, 0xbbf1, 0xbbf2, 0xbbf3, 0xbbf4, 0xbbf5, 0xbbf6, 0xbbf7, 0xbbfa, 0xbbfb, 0xbbfd, 0xbbfe, 0xbc01, 
};
static struct cp2unicode_row korean_row_92 = { 0x92, 0x41, 0xbe, korean_row_codes_92 };
static unicode_t korean_row_codes_93[] =
{
/* 0x9341 */
0xbc03, 0xbc04, 0xbc05, 0xbc06, 0xbc07, 0xbc0a, 0xbc0e, 0xbc10, 0xbc12, 0xbc13, 0xbc19, 0xbc1a, 0xbc20, 0xbc21, 0xbc22, 
/* 0x9350 */
0xbc23, 0xbc26, 0xbc28, 0xbc2a, 0xbc2b, 0xbc2c, 0xbc2e, 0xbc2f, 0xbc32, 0xbc33, 0xbc35, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9360 */
0x0000, 0xbc36, 0xbc37, 0xbc39, 0xbc3a, 0xbc3b, 0xbc3c, 0xbc3d, 0xbc3e, 0xbc3f, 0xbc42, 0xbc46, 0xbc47, 0xbc48, 0xbc4a, 0xbc4b, 
/* 0x9370 */
0xbc4e, 0xbc4f, 0xbc51, 0xbc52, 0xbc53, 0xbc54, 0xbc55, 0xbc56, 0xbc57, 0xbc58, 0xbc59, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9380 */
0x0000, 0xbc5a, 0xbc5b, 0xbc5c, 0xbc5e, 0xbc5f, 0xbc60, 0xbc61, 0xbc62, 0xbc63, 0xbc64, 0xbc65, 0xbc66, 0xbc67, 0xbc68, 0xbc69, 
/* 0x9390 */
0xbc6a, 0xbc6b, 0xbc6c, 0xbc6d, 0xbc6e, 0xbc6f, 0xbc70, 0xbc71, 0xbc72, 0xbc73, 0xbc74, 0xbc75, 0xbc76, 0xbc77, 0xbc78, 0xbc79, 
/* 0x93a0 */
0xbc7a, 0xbc7b, 0xbc7c, 0xbc7d, 0xbc7e, 0xbc7f, 0xbc80, 0xbc81, 0xbc82, 0xbc83, 0xbc86, 0xbc87, 0xbc89, 0xbc8a, 0xbc8d, 0xbc8f, 
/* 0x93b0 */
0xbc90, 0xbc91, 0xbc92, 0xbc93, 0xbc96, 0xbc98, 0xbc9b, 0xbc9c, 0xbc9d, 0xbc9e, 0xbc9f, 0xbca2, 0xbca3, 0xbca5, 0xbca6, 0xbca9, 
/* 0x93c0 */
0xbcaa, 0xbcab, 0xbcac, 0xbcad, 0xbcae, 0xbcaf, 0xbcb2, 0xbcb6, 0xbcb7, 0xbcb8, 0xbcb9, 0xbcba, 0xbcbb, 0xbcbe, 0xbcbf, 0xbcc1, 
/* 0x93d0 */
0xbcc2, 0xbcc3, 0xbcc5, 0xbcc6, 0xbcc7, 0xbcc8, 0xbcc9, 0xbcca, 0xbccb, 0xbccc, 0xbcce, 0xbcd2, 0xbcd3, 0xbcd4, 0xbcd6, 0xbcd7, 
/* 0x93e0 */
0xbcd9, 0xbcda, 0xbcdb, 0xbcdd, 0xbcde, 0xbcdf, 0xbce0, 0xbce1, 0xbce2, 0xbce3, 0xbce4, 0xbce5, 0xbce6, 0xbce7, 0xbce8, 0xbce9, 
/* 0x93f0 */
0xbcea, 0xbceb, 0xbcec, 0xbced, 0xbcee, 0xbcef, 0xbcf0, 0xbcf1, 0xbcf2, 0xbcf3, 0xbcf7, 0xbcf9, 0xbcfa, 0xbcfb, 0xbcfd, 
};
static struct cp2unicode_row korean_row_93 = { 0x93, 0x41, 0xbe, korean_row_codes_93 };
static unicode_t korean_row_codes_94[] =
{
/* 0x9441 */
0xbcfe, 0xbcff, 0xbd00, 0xbd01, 0xbd02, 0xbd03, 0xbd06, 0xbd08, 0xbd0a, 0xbd0b, 0xbd0c, 0xbd0d, 0xbd0e, 0xbd0f, 0xbd11, 
/* 0x9450 */
0xbd12, 0xbd13, 0xbd15, 0xbd16, 0xbd17, 0xbd18, 0xbd19, 0xbd1a, 0xbd1b, 0xbd1c, 0xbd1d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9460 */
0x0000, 0xbd1e, 0xbd1f, 0xbd20, 0xbd21, 0xbd22, 0xbd23, 0xbd25, 0xbd26, 0xbd27, 0xbd28, 0xbd29, 0xbd2a, 0xbd2b, 0xbd2d, 0xbd2e, 
/* 0x9470 */
0xbd2f, 0xbd30, 0xbd31, 0xbd32, 0xbd33, 0xbd34, 0xbd35, 0xbd36, 0xbd37, 0xbd38, 0xbd39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9480 */
0x0000, 0xbd3a, 0xbd3b, 0xbd3c, 0xbd3d, 0xbd3e, 0xbd3f, 0xbd41, 0xbd42, 0xbd43, 0xbd44, 0xbd45, 0xbd46, 0xbd47, 0xbd4a, 0xbd4b, 
/* 0x9490 */
0xbd4d, 0xbd4e, 0xbd4f, 0xbd51, 0xbd52, 0xbd53, 0xbd54, 0xbd55, 0xbd56, 0xbd57, 0xbd5a, 0xbd5b, 0xbd5c, 0xbd5d, 0xbd5e, 0xbd5f, 
/* 0x94a0 */
0xbd60, 0xbd61, 0xbd62, 0xbd63, 0xbd65, 0xbd66, 0xbd67, 0xbd69, 0xbd6a, 0xbd6b, 0xbd6c, 0xbd6d, 0xbd6e, 0xbd6f, 0xbd70, 0xbd71, 
/* 0x94b0 */
0xbd72, 0xbd73, 0xbd74, 0xbd75, 0xbd76, 0xbd77, 0xbd78, 0xbd79, 0xbd7a, 0xbd7b, 0xbd7c, 0xbd7d, 0xbd7e, 0xbd7f, 0xbd82, 0xbd83, 
/* 0x94c0 */
0xbd85, 0xbd86, 0xbd8b, 0xbd8c, 0xbd8d, 0xbd8e, 0xbd8f, 0xbd92, 0xbd94, 0xbd96, 0xbd97, 0xbd98, 0xbd9b, 0xbd9d, 0xbd9e, 0xbd9f, 
/* 0x94d0 */
0xbda0, 0xbda1, 0xbda2, 0xbda3, 0xbda5, 0xbda6, 0xbda7, 0xbda8, 0xbda9, 0xbdaa, 0xbdab, 0xbdac, 0xbdad, 0xbdae, 0xbdaf, 0xbdb1, 
/* 0x94e0 */
0xbdb2, 0xbdb3, 0xbdb4, 0xbdb5, 0xbdb6, 0xbdb7, 0xbdb9, 0xbdba, 0xbdbb, 0xbdbc, 0xbdbd, 0xbdbe, 0xbdbf, 0xbdc0, 0xbdc1, 0xbdc2, 
/* 0x94f0 */
0xbdc3, 0xbdc4, 0xbdc5, 0xbdc6, 0xbdc7, 0xbdc8, 0xbdc9, 0xbdca, 0xbdcb, 0xbdcc, 0xbdcd, 0xbdce, 0xbdcf, 0xbdd0, 0xbdd1, 
};
static struct cp2unicode_row korean_row_94 = { 0x94, 0x41, 0xbe, korean_row_codes_94 };
static unicode_t korean_row_codes_95[] =
{
/* 0x9541 */
0xbdd2, 0xbdd3, 0xbdd6, 0xbdd7, 0xbdd9, 0xbdda, 0xbddb, 0xbddd, 0xbdde, 0xbddf, 0xbde0, 0xbde1, 0xbde2, 0xbde3, 0xbde4, 
/* 0x9550 */
0xbde5, 0xbde6, 0xbde7, 0xbde8, 0xbdea, 0xbdeb, 0xbdec, 0xbded, 0xbdee, 0xbdef, 0xbdf1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9560 */
0x0000, 0xbdf2, 0xbdf3, 0xbdf5, 0xbdf6, 0xbdf7, 0xbdf9, 0xbdfa, 0xbdfb, 0xbdfc, 0xbdfd, 0xbdfe, 0xbdff, 0xbe01, 0xbe02, 0xbe04, 
/* 0x9570 */
0xbe06, 0xbe07, 0xbe08, 0xbe09, 0xbe0a, 0xbe0b, 0xbe0e, 0xbe0f, 0xbe11, 0xbe12, 0xbe13, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9580 */
0x0000, 0xbe15, 0xbe16, 0xbe17, 0xbe18, 0xbe19, 0xbe1a, 0xbe1b, 0xbe1e, 0xbe20, 0xbe21, 0xbe22, 0xbe23, 0xbe24, 0xbe25, 0xbe26, 
/* 0x9590 */
0xbe27, 0xbe28, 0xbe29, 0xbe2a, 0xbe2b, 0xbe2c, 0xbe2d, 0xbe2e, 0xbe2f, 0xbe30, 0xbe31, 0xbe32, 0xbe33, 0xbe34, 0xbe35, 0xbe36, 
/* 0x95a0 */
0xbe37, 0xbe38, 0xbe39, 0xbe3a, 0xbe3b, 0xbe3c, 0xbe3d, 0xbe3e, 0xbe3f, 0xbe40, 0xbe41, 0xbe42, 0xbe43, 0xbe46, 0xbe47, 0xbe49, 
/* 0x95b0 */
0xbe4a, 0xbe4b, 0xbe4d, 0xbe4f, 0xbe50, 0xbe51, 0xbe52, 0xbe53, 0xbe56, 0xbe58, 0xbe5c, 0xbe5d, 0xbe5e, 0xbe5f, 0xbe62, 0xbe63, 
/* 0x95c0 */
0xbe65, 0xbe66, 0xbe67, 0xbe69, 0xbe6b, 0xbe6c, 0xbe6d, 0xbe6e, 0xbe6f, 0xbe72, 0xbe76, 0xbe77, 0xbe78, 0xbe79, 0xbe7a, 0xbe7e, 
/* 0x95d0 */
0xbe7f, 0xbe81, 0xbe82, 0xbe83, 0xbe85, 0xbe86, 0xbe87, 0xbe88, 0xbe89, 0xbe8a, 0xbe8b, 0xbe8e, 0xbe92, 0xbe93, 0xbe94, 0xbe95, 
/* 0x95e0 */
0xbe96, 0xbe97, 0xbe9a, 0xbe9b, 0xbe9c, 0xbe9d, 0xbe9e, 0xbe9f, 0xbea0, 0xbea1, 0xbea2, 0xbea3, 0xbea4, 0xbea5, 0xbea6, 0xbea7, 
/* 0x95f0 */
0xbea9, 0xbeaa, 0xbeab, 0xbeac, 0xbead, 0xbeae, 0xbeaf, 0xbeb0, 0xbeb1, 0xbeb2, 0xbeb3, 0xbeb4, 0xbeb5, 0xbeb6, 0xbeb7, 
};
static struct cp2unicode_row korean_row_95 = { 0x95, 0x41, 0xbe, korean_row_codes_95 };
static unicode_t korean_row_codes_96[] =
{
/* 0x9641 */
0xbeb8, 0xbeb9, 0xbeba, 0xbebb, 0xbebc, 0xbebd, 0xbebe, 0xbebf, 0xbec0, 0xbec1, 0xbec2, 0xbec3, 0xbec4, 0xbec5, 0xbec6, 
/* 0x9650 */
0xbec7, 0xbec8, 0xbec9, 0xbeca, 0xbecb, 0xbecc, 0xbecd, 0xbece, 0xbecf, 0xbed2, 0xbed3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9660 */
0x0000, 0xbed5, 0xbed6, 0xbed9, 0xbeda, 0xbedb, 0xbedc, 0xbedd, 0xbede, 0xbedf, 0xbee1, 0xbee2, 0xbee6, 0xbee7, 0xbee8, 0xbee9, 
/* 0x9670 */
0xbeea, 0xbeeb, 0xbeed, 0xbeee, 0xbeef, 0xbef0, 0xbef1, 0xbef2, 0xbef3, 0xbef4, 0xbef5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9680 */
0x0000, 0xbef6, 0xbef7, 0xbef8, 0xbef9, 0xbefa, 0xbefb, 0xbefc, 0xbefd, 0xbefe, 0xbeff, 0xbf00, 0xbf02, 0xbf03, 0xbf04, 0xbf05, 
/* 0x9690 */
0xbf06, 0xbf07, 0xbf0a, 0xbf0b, 0xbf0c, 0xbf0d, 0xbf0e, 0xbf0f, 0xbf10, 0xbf11, 0xbf12, 0xbf13, 0xbf14, 0xbf15, 0xbf16, 0xbf17, 
/* 0x96a0 */
0xbf1a, 0xbf1e, 0xbf1f, 0xbf20, 0xbf21, 0xbf22, 0xbf23, 0xbf24, 0xbf25, 0xbf26, 0xbf27, 0xbf28, 0xbf29, 0xbf2a, 0xbf2b, 0xbf2c, 
/* 0x96b0 */
0xbf2d, 0xbf2e, 0xbf2f, 0xbf30, 0xbf31, 0xbf32, 0xbf33, 0xbf34, 0xbf35, 0xbf36, 0xbf37, 0xbf38, 0xbf39, 0xbf3a, 0xbf3b, 0xbf3c, 
/* 0x96c0 */
0xbf3d, 0xbf3e, 0xbf3f, 0xbf42, 0xbf43, 0xbf45, 0xbf46, 0xbf47, 0xbf49, 0xbf4a, 0xbf4b, 0xbf4c, 0xbf4d, 0xbf4e, 0xbf4f, 0xbf52, 
/* 0x96d0 */
0xbf53, 0xbf54, 0xbf56, 0xbf57, 0xbf58, 0xbf59, 0xbf5a, 0xbf5b, 0xbf5c, 0xbf5d, 0xbf5e, 0xbf5f, 0xbf60, 0xbf61, 0xbf62, 0xbf63, 
/* 0x96e0 */
0xbf64, 0xbf65, 0xbf66, 0xbf67, 0xbf68, 0xbf69, 0xbf6a, 0xbf6b, 0xbf6c, 0xbf6d, 0xbf6e, 0xbf6f, 0xbf70, 0xbf71, 0xbf72, 0xbf73, 
/* 0x96f0 */
0xbf74, 0xbf75, 0xbf76, 0xbf77, 0xbf78, 0xbf79, 0xbf7a, 0xbf7b, 0xbf7c, 0xbf7d, 0xbf7e, 0xbf7f, 0xbf80, 0xbf81, 0xbf82, 
};
static struct cp2unicode_row korean_row_96 = { 0x96, 0x41, 0xbe, korean_row_codes_96 };
static unicode_t korean_row_codes_97[] =
{
/* 0x9741 */
0xbf83, 0xbf84, 0xbf85, 0xbf86, 0xbf87, 0xbf88, 0xbf89, 0xbf8a, 0xbf8b, 0xbf8c, 0xbf8d, 0xbf8e, 0xbf8f, 0xbf90, 0xbf91, 
/* 0x9750 */
0xbf92, 0xbf93, 0xbf95, 0xbf96, 0xbf97, 0xbf98, 0xbf99, 0xbf9a, 0xbf9b, 0xbf9c, 0xbf9d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9760 */
0x0000, 0xbf9e, 0xbf9f, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbfa4, 0xbfa5, 0xbfa6, 0xbfa7, 0xbfa8, 0xbfa9, 0xbfaa, 0xbfab, 0xbfac, 
/* 0x9770 */
0xbfad, 0xbfae, 0xbfaf, 0xbfb1, 0xbfb2, 0xbfb3, 0xbfb4, 0xbfb5, 0xbfb6, 0xbfb7, 0xbfb8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9780 */
0x0000, 0xbfb9, 0xbfba, 0xbfbb, 0xbfbc, 0xbfbd, 0xbfbe, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbfc3, 0xbfc4, 0xbfc6, 0xbfc7, 0xbfc8, 
/* 0x9790 */
0xbfc9, 0xbfca, 0xbfcb, 0xbfce, 0xbfcf, 0xbfd1, 0xbfd2, 0xbfd3, 0xbfd5, 0xbfd6, 0xbfd7, 0xbfd8, 0xbfd9, 0xbfda, 0xbfdb, 0xbfdd, 
/* 0x97a0 */
0xbfde, 0xbfe0, 0xbfe2, 0xbfe3, 0xbfe4, 0xbfe5, 0xbfe6, 0xbfe7, 0xbfe8, 0xbfe9, 0xbfea, 0xbfeb, 0xbfec, 0xbfed, 0xbfee, 0xbfef, 
/* 0x97b0 */
0xbff0, 0xbff1, 0xbff2, 0xbff3, 0xbff4, 0xbff5, 0xbff6, 0xbff7, 0xbff8, 0xbff9, 0xbffa, 0xbffb, 0xbffc, 0xbffd, 0xbffe, 0xbfff, 
/* 0x97c0 */
0xc000, 0xc001, 0xc002, 0xc003, 0xc004, 0xc005, 0xc006, 0xc007, 0xc008, 0xc009, 0xc00a, 0xc00b, 0xc00c, 0xc00d, 0xc00e, 0xc00f, 
/* 0x97d0 */
0xc010, 0xc011, 0xc012, 0xc013, 0xc014, 0xc015, 0xc016, 0xc017, 0xc018, 0xc019, 0xc01a, 0xc01b, 0xc01c, 0xc01d, 0xc01e, 0xc01f, 
/* 0x97e0 */
0xc020, 0xc021, 0xc022, 0xc023, 0xc024, 0xc025, 0xc026, 0xc027, 0xc028, 0xc029, 0xc02a, 0xc02b, 0xc02c, 0xc02d, 0xc02e, 0xc02f, 
/* 0x97f0 */
0xc030, 0xc031, 0xc032, 0xc033, 0xc034, 0xc035, 0xc036, 0xc037, 0xc038, 0xc039, 0xc03a, 0xc03b, 0xc03d, 0xc03e, 0xc03f, 
};
static struct cp2unicode_row korean_row_97 = { 0x97, 0x41, 0xbe, korean_row_codes_97 };
static unicode_t korean_row_codes_98[] =
{
/* 0x9841 */
0xc040, 0xc041, 0xc042, 0xc043, 0xc044, 0xc045, 0xc046, 0xc047, 0xc048, 0xc049, 0xc04a, 0xc04b, 0xc04c, 0xc04d, 0xc04e, 
/* 0x9850 */
0xc04f, 0xc050, 0xc052, 0xc053, 0xc054, 0xc055, 0xc056, 0xc057, 0xc059, 0xc05a, 0xc05b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9860 */
0x0000, 0xc05d, 0xc05e, 0xc05f, 0xc061, 0xc062, 0xc063, 0xc064, 0xc065, 0xc066, 0xc067, 0xc06a, 0xc06b, 0xc06c, 0xc06d, 0xc06e, 
/* 0x9870 */
0xc06f, 0xc070, 0xc071, 0xc072, 0xc073, 0xc074, 0xc075, 0xc076, 0xc077, 0xc078, 0xc079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9880 */
0x0000, 0xc07a, 0xc07b, 0xc07c, 0xc07d, 0xc07e, 0xc07f, 0xc080, 0xc081, 0xc082, 0xc083, 0xc084, 0xc085, 0xc086, 0xc087, 0xc088, 
/* 0x9890 */
0xc089, 0xc08a, 0xc08b, 0xc08c, 0xc08d, 0xc08e, 0xc08f, 0xc092, 0xc093, 0xc095, 0xc096, 0xc097, 0xc099, 0xc09a, 0xc09b, 0xc09c, 
/* 0x98a0 */
0xc09d, 0xc09e, 0xc09f, 0xc0a2, 0xc0a4, 0xc0a6, 0xc0a7, 0xc0a8, 0xc0a9, 0xc0aa, 0xc0ab, 0xc0ae, 0xc0b1, 0xc0b2, 0xc0b7, 0xc0b8, 
/* 0x98b0 */
0xc0b9, 0xc0ba, 0xc0bb, 0xc0be, 0xc0c2, 0xc0c3, 0xc0c4, 0xc0c6, 0xc0c7, 0xc0ca, 0xc0cb, 0xc0cd, 0xc0ce, 0xc0cf, 0xc0d1, 0xc0d2, 
/* 0x98c0 */
0xc0d3, 0xc0d4, 0xc0d5, 0xc0d6, 0xc0d7, 0xc0da, 0xc0de, 0xc0df, 0xc0e0, 0xc0e1, 0xc0e2, 0xc0e3, 0xc0e6, 0xc0e7, 0xc0e9, 0xc0ea, 
/* 0x98d0 */
0xc0eb, 0xc0ed, 0xc0ee, 0xc0ef, 0xc0f0, 0xc0f1, 0xc0f2, 0xc0f3, 0xc0f6, 0xc0f8, 0xc0fa, 0xc0fb, 0xc0fc, 0xc0fd, 0xc0fe, 0xc0ff, 
/* 0x98e0 */
0xc101, 0xc102, 0xc103, 0xc105, 0xc106, 0xc107, 0xc109, 0xc10a, 0xc10b, 0xc10c, 0xc10d, 0xc10e, 0xc10f, 0xc111, 0xc112, 0xc113, 
/* 0x98f0 */
0xc114, 0xc116, 0xc117, 0xc118, 0xc119, 0xc11a, 0xc11b, 0xc121, 0xc122, 0xc125, 0xc128, 0xc129, 0xc12a, 0xc12b, 0xc12e, 
};
static struct cp2unicode_row korean_row_98 = { 0x98, 0x41, 0xbe, korean_row_codes_98 };
static unicode_t korean_row_codes_99[] =
{
/* 0x9941 */
0xc132, 0xc133, 0xc134, 0xc135, 0xc137, 0xc13a, 0xc13b, 0xc13d, 0xc13e, 0xc13f, 0xc141, 0xc142, 0xc143, 0xc144, 0xc145, 
/* 0x9950 */
0xc146, 0xc147, 0xc14a, 0xc14e, 0xc14f, 0xc150, 0xc151, 0xc152, 0xc153, 0xc156, 0xc157, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9960 */
0x0000, 0xc159, 0xc15a, 0xc15b, 0xc15d, 0xc15e, 0xc15f, 0xc160, 0xc161, 0xc162, 0xc163, 0xc166, 0xc16a, 0xc16b, 0xc16c, 0xc16d, 
/* 0x9970 */
0xc16e, 0xc16f, 0xc171, 0xc172, 0xc173, 0xc175, 0xc176, 0xc177, 0xc179, 0xc17a, 0xc17b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9980 */
0x0000, 0xc17c, 0xc17d, 0xc17e, 0xc17f, 0xc180, 0xc181, 0xc182, 0xc183, 0xc184, 0xc186, 0xc187, 0xc188, 0xc189, 0xc18a, 0xc18b, 
/* 0x9990 */
0xc18f, 0xc191, 0xc192, 0xc193, 0xc195, 0xc197, 0xc198, 0xc199, 0xc19a, 0xc19b, 0xc19e, 0xc1a0, 0xc1a2, 0xc1a3, 0xc1a4, 0xc1a6, 
/* 0x99a0 */
0xc1a7, 0xc1aa, 0xc1ab, 0xc1ad, 0xc1ae, 0xc1af, 0xc1b1, 0xc1b2, 0xc1b3, 0xc1b4, 0xc1b5, 0xc1b6, 0xc1b7, 0xc1b8, 0xc1b9, 0xc1ba, 
/* 0x99b0 */
0xc1bb, 0xc1bc, 0xc1be, 0xc1bf, 0xc1c0, 0xc1c1, 0xc1c2, 0xc1c3, 0xc1c5, 0xc1c6, 0xc1c7, 0xc1c9, 0xc1ca, 0xc1cb, 0xc1cd, 0xc1ce, 
/* 0x99c0 */
0xc1cf, 0xc1d0, 0xc1d1, 0xc1d2, 0xc1d3, 0xc1d5, 0xc1d6, 0xc1d9, 0xc1da, 0xc1db, 0xc1dc, 0xc1dd, 0xc1de, 0xc1df, 0xc1e1, 0xc1e2, 
/* 0x99d0 */
0xc1e3, 0xc1e5, 0xc1e6, 0xc1e7, 0xc1e9, 0xc1ea, 0xc1eb, 0xc1ec, 0xc1ed, 0xc1ee, 0xc1ef, 0xc1f2, 0xc1f4, 0xc1f5, 0xc1f6, 0xc1f7, 
/* 0x99e0 */
0xc1f8, 0xc1f9, 0xc1fa, 0xc1fb, 0xc1fe, 0xc1ff, 0xc201, 0xc202, 0xc203, 0xc205, 0xc206, 0xc207, 0xc208, 0xc209, 0xc20a, 0xc20b, 
/* 0x99f0 */
0xc20e, 0xc210, 0xc212, 0xc213, 0xc214, 0xc215, 0xc216, 0xc217, 0xc21a, 0xc21b, 0xc21d, 0xc21e, 0xc221, 0xc222, 0xc223, 
};
static struct cp2unicode_row korean_row_99 = { 0x99, 0x41, 0xbe, korean_row_codes_99 };
static unicode_t korean_row_codes_9a[] =
{
/* 0x9a41 */
0xc224, 0xc225, 0xc226, 0xc227, 0xc22a, 0xc22c, 0xc22e, 0xc230, 0xc233, 0xc235, 0xc236, 0xc237, 0xc238, 0xc239, 0xc23a, 
/* 0x9a50 */
0xc23b, 0xc23c, 0xc23d, 0xc23e, 0xc23f, 0xc240, 0xc241, 0xc242, 0xc243, 0xc244, 0xc245, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9a60 */
0x0000, 0xc246, 0xc247, 0xc249, 0xc24a, 0xc24b, 0xc24c, 0xc24d, 0xc24e, 0xc24f, 0xc252, 0xc253, 0xc255, 0xc256, 0xc257, 0xc259, 
/* 0x9a70 */
0xc25a, 0xc25b, 0xc25c, 0xc25d, 0xc25e, 0xc25f, 0xc261, 0xc262, 0xc263, 0xc264, 0xc266, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9a80 */
0x0000, 0xc267, 0xc268, 0xc269, 0xc26a, 0xc26b, 0xc26e, 0xc26f, 0xc271, 0xc272, 0xc273, 0xc275, 0xc276, 0xc277, 0xc278, 0xc279, 
/* 0x9a90 */
0xc27a, 0xc27b, 0xc27e, 0xc280, 0xc282, 0xc283, 0xc284, 0xc285, 0xc286, 0xc287, 0xc28a, 0xc28b, 0xc28c, 0xc28d, 0xc28e, 0xc28f, 
/* 0x9aa0 */
0xc291, 0xc292, 0xc293, 0xc294, 0xc295, 0xc296, 0xc297, 0xc299, 0xc29a, 0xc29c, 0xc29e, 0xc29f, 0xc2a0, 0xc2a1, 0xc2a2, 0xc2a3, 
/* 0x9ab0 */
0xc2a6, 0xc2a7, 0xc2a9, 0xc2aa, 0xc2ab, 0xc2ae, 0xc2af, 0xc2b0, 0xc2b1, 0xc2b2, 0xc2b3, 0xc2b6, 0xc2b8, 0xc2ba, 0xc2bb, 0xc2bc, 
/* 0x9ac0 */
0xc2bd, 0xc2be, 0xc2bf, 0xc2c0, 0xc2c1, 0xc2c2, 0xc2c3, 0xc2c4, 0xc2c5, 0xc2c6, 0xc2c7, 0xc2c8, 0xc2c9, 0xc2ca, 0xc2cb, 0xc2cc, 
/* 0x9ad0 */
0xc2cd, 0xc2ce, 0xc2cf, 0xc2d0, 0xc2d1, 0xc2d2, 0xc2d3, 0xc2d4, 0xc2d5, 0xc2d6, 0xc2d7, 0xc2d8, 0xc2d9, 0xc2da, 0xc2db, 0xc2de, 
/* 0x9ae0 */
0xc2df, 0xc2e1, 0xc2e2, 0xc2e5, 0xc2e6, 0xc2e7, 0xc2e8, 0xc2e9, 0xc2ea, 0xc2ee, 0xc2f0, 0xc2f2, 0xc2f3, 0xc2f4, 0xc2f5, 0xc2f7, 
/* 0x9af0 */
0xc2fa, 0xc2fd, 0xc2fe, 0xc2ff, 0xc301, 0xc302, 0xc303, 0xc304, 0xc305, 0xc306, 0xc307, 0xc30a, 0xc30b, 0xc30e, 0xc30f, 
};
static struct cp2unicode_row korean_row_9a = { 0x9a, 0x41, 0xbe, korean_row_codes_9a };
static unicode_t korean_row_codes_9b[] =
{
/* 0x9b41 */
0xc310, 0xc311, 0xc312, 0xc316, 0xc317, 0xc319, 0xc31a, 0xc31b, 0xc31d, 0xc31e, 0xc31f, 0xc320, 0xc321, 0xc322, 0xc323, 
/* 0x9b50 */
0xc326, 0xc327, 0xc32a, 0xc32b, 0xc32c, 0xc32d, 0xc32e, 0xc32f, 0xc330, 0xc331, 0xc332, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9b60 */
0x0000, 0xc333, 0xc334, 0xc335, 0xc336, 0xc337, 0xc338, 0xc339, 0xc33a, 0xc33b, 0xc33c, 0xc33d, 0xc33e, 0xc33f, 0xc340, 0xc341, 
/* 0x9b70 */
0xc342, 0xc343, 0xc344, 0xc346, 0xc347, 0xc348, 0xc349, 0xc34a, 0xc34b, 0xc34c, 0xc34d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9b80 */
0x0000, 0xc34e, 0xc34f, 0xc350, 0xc351, 0xc352, 0xc353, 0xc354, 0xc355, 0xc356, 0xc357, 0xc358, 0xc359, 0xc35a, 0xc35b, 0xc35c, 
/* 0x9b90 */
0xc35d, 0xc35e, 0xc35f, 0xc360, 0xc361, 0xc362, 0xc363, 0xc364, 0xc365, 0xc366, 0xc367, 0xc36a, 0xc36b, 0xc36d, 0xc36e, 0xc36f, 
/* 0x9ba0 */
0xc371, 0xc373, 0xc374, 0xc375, 0xc376, 0xc377, 0xc37a, 0xc37b, 0xc37e, 0xc37f, 0xc380, 0xc381, 0xc382, 0xc383, 0xc385, 0xc386, 
/* 0x9bb0 */
0xc387, 0xc389, 0xc38a, 0xc38b, 0xc38d, 0xc38e, 0xc38f, 0xc390, 0xc391, 0xc392, 0xc393, 0xc394, 0xc395, 0xc396, 0xc397, 0xc398, 
/* 0x9bc0 */
0xc399, 0xc39a, 0xc39b, 0xc39c, 0xc39d, 0xc39e, 0xc39f, 0xc3a0, 0xc3a1, 0xc3a2, 0xc3a3, 0xc3a4, 0xc3a5, 0xc3a6, 0xc3a7, 0xc3a8, 
/* 0x9bd0 */
0xc3a9, 0xc3aa, 0xc3ab, 0xc3ac, 0xc3ad, 0xc3ae, 0xc3af, 0xc3b0, 0xc3b1, 0xc3b2, 0xc3b3, 0xc3b4, 0xc3b5, 0xc3b6, 0xc3b7, 0xc3b8, 
/* 0x9be0 */
0xc3b9, 0xc3ba, 0xc3bb, 0xc3bc, 0xc3bd, 0xc3be, 0xc3bf, 0xc3c1, 0xc3c2, 0xc3c3, 0xc3c4, 0xc3c5, 0xc3c6, 0xc3c7, 0xc3c8, 0xc3c9, 
/* 0x9bf0 */
0xc3ca, 0xc3cb, 0xc3cc, 0xc3cd, 0xc3ce, 0xc3cf, 0xc3d0, 0xc3d1, 0xc3d2, 0xc3d3, 0xc3d4, 0xc3d5, 0xc3d6, 0xc3d7, 0xc3da, 
};
static struct cp2unicode_row korean_row_9b = { 0x9b, 0x41, 0xbe, korean_row_codes_9b };
static unicode_t korean_row_codes_9c[] =
{
/* 0x9c41 */
0xc3db, 0xc3dd, 0xc3de, 0xc3e1, 0xc3e3, 0xc3e4, 0xc3e5, 0xc3e6, 0xc3e7, 0xc3ea, 0xc3eb, 0xc3ec, 0xc3ee, 0xc3ef, 0xc3f0, 
/* 0x9c50 */
0xc3f1, 0xc3f2, 0xc3f3, 0xc3f6, 0xc3f7, 0xc3f9, 0xc3fa, 0xc3fb, 0xc3fc, 0xc3fd, 0xc3fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9c60 */
0x0000, 0xc3ff, 0xc400, 0xc401, 0xc402, 0xc403, 0xc404, 0xc405, 0xc406, 0xc407, 0xc409, 0xc40a, 0xc40b, 0xc40c, 0xc40d, 0xc40e, 
/* 0x9c70 */
0xc40f, 0xc411, 0xc412, 0xc413, 0xc414, 0xc415, 0xc416, 0xc417, 0xc418, 0xc419, 0xc41a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9c80 */
0x0000, 0xc41b, 0xc41c, 0xc41d, 0xc41e, 0xc41f, 0xc420, 0xc421, 0xc422, 0xc423, 0xc425, 0xc426, 0xc427, 0xc428, 0xc429, 0xc42a, 
/* 0x9c90 */
0xc42b, 0xc42d, 0xc42e, 0xc42f, 0xc431, 0xc432, 0xc433, 0xc435, 0xc436, 0xc437, 0xc438, 0xc439, 0xc43a, 0xc43b, 0xc43e, 0xc43f, 
/* 0x9ca0 */
0xc440, 0xc441, 0xc442, 0xc443, 0xc444, 0xc445, 0xc446, 0xc447, 0xc449, 0xc44a, 0xc44b, 0xc44c, 0xc44d, 0xc44e, 0xc44f, 0xc450, 
/* 0x9cb0 */
0xc451, 0xc452, 0xc453, 0xc454, 0xc455, 0xc456, 0xc457, 0xc458, 0xc459, 0xc45a, 0xc45b, 0xc45c, 0xc45d, 0xc45e, 0xc45f, 0xc460, 
/* 0x9cc0 */
0xc461, 0xc462, 0xc463, 0xc466, 0xc467, 0xc469, 0xc46a, 0xc46b, 0xc46d, 0xc46e, 0xc46f, 0xc470, 0xc471, 0xc472, 0xc473, 0xc476, 
/* 0x9cd0 */
0xc477, 0xc478, 0xc47a, 0xc47b, 0xc47c, 0xc47d, 0xc47e, 0xc47f, 0xc481, 0xc482, 0xc483, 0xc484, 0xc485, 0xc486, 0xc487, 0xc488, 
/* 0x9ce0 */
0xc489, 0xc48a, 0xc48b, 0xc48c, 0xc48d, 0xc48e, 0xc48f, 0xc490, 0xc491, 0xc492, 0xc493, 0xc495, 0xc496, 0xc497, 0xc498, 0xc499, 
/* 0x9cf0 */
0xc49a, 0xc49b, 0xc49d, 0xc49e, 0xc49f, 0xc4a0, 0xc4a1, 0xc4a2, 0xc4a3, 0xc4a4, 0xc4a5, 0xc4a6, 0xc4a7, 0xc4a8, 0xc4a9, 
};
static struct cp2unicode_row korean_row_9c = { 0x9c, 0x41, 0xbe, korean_row_codes_9c };
static unicode_t korean_row_codes_9d[] =
{
/* 0x9d41 */
0xc4aa, 0xc4ab, 0xc4ac, 0xc4ad, 0xc4ae, 0xc4af, 0xc4b0, 0xc4b1, 0xc4b2, 0xc4b3, 0xc4b4, 0xc4b5, 0xc4b6, 0xc4b7, 0xc4b9, 
/* 0x9d50 */
0xc4ba, 0xc4bb, 0xc4bd, 0xc4be, 0xc4bf, 0xc4c0, 0xc4c1, 0xc4c2, 0xc4c3, 0xc4c4, 0xc4c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9d60 */
0x0000, 0xc4c6, 0xc4c7, 0xc4c8, 0xc4c9, 0xc4ca, 0xc4cb, 0xc4cc, 0xc4cd, 0xc4ce, 0xc4cf, 0xc4d0, 0xc4d1, 0xc4d2, 0xc4d3, 0xc4d4, 
/* 0x9d70 */
0xc4d5, 0xc4d6, 0xc4d7, 0xc4d8, 0xc4d9, 0xc4da, 0xc4db, 0xc4dc, 0xc4dd, 0xc4de, 0xc4df, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9d80 */
0x0000, 0xc4e0, 0xc4e1, 0xc4e2, 0xc4e3, 0xc4e4, 0xc4e5, 0xc4e6, 0xc4e7, 0xc4e8, 0xc4ea, 0xc4eb, 0xc4ec, 0xc4ed, 0xc4ee, 0xc4ef, 
/* 0x9d90 */
0xc4f2, 0xc4f3, 0xc4f5, 0xc4f6, 0xc4f7, 0xc4f9, 0xc4fb, 0xc4fc, 0xc4fd, 0xc4fe, 0xc502, 0xc503, 0xc504, 0xc505, 0xc506, 0xc507, 
/* 0x9da0 */
0xc508, 0xc509, 0xc50a, 0xc50b, 0xc50d, 0xc50e, 0xc50f, 0xc511, 0xc512, 0xc513, 0xc515, 0xc516, 0xc517, 0xc518, 0xc519, 0xc51a, 
/* 0x9db0 */
0xc51b, 0xc51d, 0xc51e, 0xc51f, 0xc520, 0xc521, 0xc522, 0xc523, 0xc524, 0xc525, 0xc526, 0xc527, 0xc52a, 0xc52b, 0xc52d, 0xc52e, 
/* 0x9dc0 */
0xc52f, 0xc531, 0xc532, 0xc533, 0xc534, 0xc535, 0xc536, 0xc537, 0xc53a, 0xc53c, 0xc53e, 0xc53f, 0xc540, 0xc541, 0xc542, 0xc543, 
/* 0x9dd0 */
0xc546, 0xc547, 0xc54b, 0xc54f, 0xc550, 0xc551, 0xc552, 0xc556, 0xc55a, 0xc55b, 0xc55c, 0xc55f, 0xc562, 0xc563, 0xc565, 0xc566, 
/* 0x9de0 */
0xc567, 0xc569, 0xc56a, 0xc56b, 0xc56c, 0xc56d, 0xc56e, 0xc56f, 0xc572, 0xc576, 0xc577, 0xc578, 0xc579, 0xc57a, 0xc57b, 0xc57e, 
/* 0x9df0 */
0xc57f, 0xc581, 0xc582, 0xc583, 0xc585, 0xc586, 0xc588, 0xc589, 0xc58a, 0xc58b, 0xc58e, 0xc590, 0xc592, 0xc593, 0xc594, 
};
static struct cp2unicode_row korean_row_9d = { 0x9d, 0x41, 0xbe, korean_row_codes_9d };
static unicode_t korean_row_codes_9e[] =
{
/* 0x9e41 */
0xc596, 0xc599, 0xc59a, 0xc59b, 0xc59d, 0xc59e, 0xc59f, 0xc5a1, 0xc5a2, 0xc5a3, 0xc5a4, 0xc5a5, 0xc5a6, 0xc5a7, 0xc5a8, 
/* 0x9e50 */
0xc5aa, 0xc5ab, 0xc5ac, 0xc5ad, 0xc5ae, 0xc5af, 0xc5b0, 0xc5b1, 0xc5b2, 0xc5b3, 0xc5b6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9e60 */
0x0000, 0xc5b7, 0xc5ba, 0xc5bf, 0xc5c0, 0xc5c1, 0xc5c2, 0xc5c3, 0xc5cb, 0xc5cd, 0xc5cf, 0xc5d2, 0xc5d3, 0xc5d5, 0xc5d6, 0xc5d7, 
/* 0x9e70 */
0xc5d9, 0xc5da, 0xc5db, 0xc5dc, 0xc5dd, 0xc5de, 0xc5df, 0xc5e2, 0xc5e4, 0xc5e6, 0xc5e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9e80 */
0x0000, 0xc5e8, 0xc5e9, 0xc5ea, 0xc5eb, 0xc5ef, 0xc5f1, 0xc5f2, 0xc5f3, 0xc5f5, 0xc5f8, 0xc5f9, 0xc5fa, 0xc5fb, 0xc602, 0xc603, 
/* 0x9e90 */
0xc604, 0xc609, 0xc60a, 0xc60b, 0xc60d, 0xc60e, 0xc60f, 0xc611, 0xc612, 0xc613, 0xc614, 0xc615, 0xc616, 0xc617, 0xc61a, 0xc61d, 
/* 0x9ea0 */
0xc61e, 0xc61f, 0xc620, 0xc621, 0xc622, 0xc623, 0xc626, 0xc627, 0xc629, 0xc62a, 0xc62b, 0xc62f, 0xc631, 0xc632, 0xc636, 0xc638, 
/* 0x9eb0 */
0xc63a, 0xc63c, 0xc63d, 0xc63e, 0xc63f, 0xc642, 0xc643, 0xc645, 0xc646, 0xc647, 0xc649, 0xc64a, 0xc64b, 0xc64c, 0xc64d, 0xc64e, 
/* 0x9ec0 */
0xc64f, 0xc652, 0xc656, 0xc657, 0xc658, 0xc659, 0xc65a, 0xc65b, 0xc65e, 0xc65f, 0xc661, 0xc662, 0xc663, 0xc664, 0xc665, 0xc666, 
/* 0x9ed0 */
0xc667, 0xc668, 0xc669, 0xc66a, 0xc66b, 0xc66d, 0xc66e, 0xc670, 0xc672, 0xc673, 0xc674, 0xc675, 0xc676, 0xc677, 0xc67a, 0xc67b, 
/* 0x9ee0 */
0xc67d, 0xc67e, 0xc67f, 0xc681, 0xc682, 0xc683, 0xc684, 0xc685, 0xc686, 0xc687, 0xc68a, 0xc68c, 0xc68e, 0xc68f, 0xc690, 0xc691, 
/* 0x9ef0 */
0xc692, 0xc693, 0xc696, 0xc697, 0xc699, 0xc69a, 0xc69b, 0xc69d, 0xc69e, 0xc69f, 0xc6a0, 0xc6a1, 0xc6a2, 0xc6a3, 0xc6a6, 
};
static struct cp2unicode_row korean_row_9e = { 0x9e, 0x41, 0xbe, korean_row_codes_9e };
static unicode_t korean_row_codes_9f[] =
{
/* 0x9f41 */
0xc6a8, 0xc6aa, 0xc6ab, 0xc6ac, 0xc6ad, 0xc6ae, 0xc6af, 0xc6b2, 0xc6b3, 0xc6b5, 0xc6b6, 0xc6b7, 0xc6bb, 0xc6bc, 0xc6bd, 
/* 0x9f50 */
0xc6be, 0xc6bf, 0xc6c2, 0xc6c4, 0xc6c6, 0xc6c7, 0xc6c8, 0xc6c9, 0xc6ca, 0xc6cb, 0xc6ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9f60 */
0x0000, 0xc6cf, 0xc6d1, 0xc6d2, 0xc6d3, 0xc6d5, 0xc6d6, 0xc6d7, 0xc6d8, 0xc6d9, 0xc6da, 0xc6db, 0xc6de, 0xc6df, 0xc6e2, 0xc6e3, 
/* 0x9f70 */
0xc6e4, 0xc6e5, 0xc6e6, 0xc6e7, 0xc6ea, 0xc6eb, 0xc6ed, 0xc6ee, 0xc6ef, 0xc6f1, 0xc6f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0x9f80 */
0x0000, 0xc6f3, 0xc6f4, 0xc6f5, 0xc6f6, 0xc6f7, 0xc6fa, 0xc6fb, 0xc6fc, 0xc6fe, 0xc6ff, 0xc700, 0xc701, 0xc702, 0xc703, 0xc706, 
/* 0x9f90 */
0xc707, 0xc709, 0xc70a, 0xc70b, 0xc70d, 0xc70e, 0xc70f, 0xc710, 0xc711, 0xc712, 0xc713, 0xc716, 0xc718, 0xc71a, 0xc71b, 0xc71c, 
/* 0x9fa0 */
0xc71d, 0xc71e, 0xc71f, 0xc722, 0xc723, 0xc725, 0xc726, 0xc727, 0xc729, 0xc72a, 0xc72b, 0xc72c, 0xc72d, 0xc72e, 0xc72f, 0xc732, 
/* 0x9fb0 */
0xc734, 0xc736, 0xc738, 0xc739, 0xc73a, 0xc73b, 0xc73e, 0xc73f, 0xc741, 0xc742, 0xc743, 0xc745, 0xc746, 0xc747, 0xc748, 0xc749, 
/* 0x9fc0 */
0xc74b, 0xc74e, 0xc750, 0xc759, 0xc75a, 0xc75b, 0xc75d, 0xc75e, 0xc75f, 0xc761, 0xc762, 0xc763, 0xc764, 0xc765, 0xc766, 0xc767, 
/* 0x9fd0 */
0xc769, 0xc76a, 0xc76c, 0xc76d, 0xc76e, 0xc76f, 0xc770, 0xc771, 0xc772, 0xc773, 0xc776, 0xc777, 0xc779, 0xc77a, 0xc77b, 0xc77f, 
/* 0x9fe0 */
0xc780, 0xc781, 0xc782, 0xc786, 0xc78b, 0xc78c, 0xc78d, 0xc78f, 0xc792, 0xc793, 0xc795, 0xc799, 0xc79b, 0xc79c, 0xc79d, 0xc79e, 
/* 0x9ff0 */
0xc79f, 0xc7a2, 0xc7a7, 0xc7a8, 0xc7a9, 0xc7aa, 0xc7ab, 0xc7ae, 0xc7af, 0xc7b1, 0xc7b2, 0xc7b3, 0xc7b5, 0xc7b6, 0xc7b7, 
};
static struct cp2unicode_row korean_row_9f = { 0x9f, 0x41, 0xbe, korean_row_codes_9f };
static unicode_t korean_row_codes_a0[] =
{
/* 0xa041 */
0xc7b8, 0xc7b9, 0xc7ba, 0xc7bb, 0xc7be, 0xc7c2, 0xc7c3, 0xc7c4, 0xc7c5, 0xc7c6, 0xc7c7, 0xc7ca, 0xc7cb, 0xc7cd, 0xc7cf, 
/* 0xa050 */
0xc7d1, 0xc7d2, 0xc7d3, 0xc7d4, 0xc7d5, 0xc7d6, 0xc7d7, 0xc7d9, 0xc7da, 0xc7db, 0xc7dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa060 */
0x0000, 0xc7de, 0xc7df, 0xc7e0, 0xc7e1, 0xc7e2, 0xc7e3, 0xc7e5, 0xc7e6, 0xc7e7, 0xc7e9, 0xc7ea, 0xc7eb, 0xc7ed, 0xc7ee, 0xc7ef, 
/* 0xa070 */
0xc7f0, 0xc7f1, 0xc7f2, 0xc7f3, 0xc7f4, 0xc7f5, 0xc7f6, 0xc7f7, 0xc7f8, 0xc7f9, 0xc7fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa080 */
0x0000, 0xc7fb, 0xc7fc, 0xc7fd, 0xc7fe, 0xc7ff, 0xc802, 0xc803, 0xc805, 0xc806, 0xc807, 0xc809, 0xc80b, 0xc80c, 0xc80d, 0xc80e, 
/* 0xa090 */
0xc80f, 0xc812, 0xc814, 0xc817, 0xc818, 0xc819, 0xc81a, 0xc81b, 0xc81e, 0xc81f, 0xc821, 0xc822, 0xc823, 0xc825, 0xc826, 0xc827, 
/* 0xa0a0 */
0xc828, 0xc829, 0xc82a, 0xc82b, 0xc82e, 0xc830, 0xc832, 0xc833, 0xc834, 0xc835, 0xc836, 0xc837, 0xc839, 0xc83a, 0xc83b, 0xc83d, 
/* 0xa0b0 */
0xc83e, 0xc83f, 0xc841, 0xc842, 0xc843, 0xc844, 0xc845, 0xc846, 0xc847, 0xc84a, 0xc84b, 0xc84e, 0xc84f, 0xc850, 0xc851, 0xc852, 
/* 0xa0c0 */
0xc853, 0xc855, 0xc856, 0xc857, 0xc858, 0xc859, 0xc85a, 0xc85b, 0xc85c, 0xc85d, 0xc85e, 0xc85f, 0xc860, 0xc861, 0xc862, 0xc863, 
/* 0xa0d0 */
0xc864, 0xc865, 0xc866, 0xc867, 0xc868, 0xc869, 0xc86a, 0xc86b, 0xc86c, 0xc86d, 0xc86e, 0xc86f, 0xc872, 0xc873, 0xc875, 0xc876, 
/* 0xa0e0 */
0xc877, 0xc879, 0xc87b, 0xc87c, 0xc87d, 0xc87e, 0xc87f, 0xc882, 0xc884, 0xc888, 0xc889, 0xc88a, 0xc88e, 0xc88f, 0xc890, 0xc891, 
/* 0xa0f0 */
0xc892, 0xc893, 0xc895, 0xc896, 0xc897, 0xc898, 0xc899, 0xc89a, 0xc89b, 0xc89c, 0xc89e, 0xc8a0, 0xc8a2, 0xc8a3, 0xc8a4, 
};
static struct cp2unicode_row korean_row_a0 = { 0xa0, 0x41, 0xbe, korean_row_codes_a0 };
static unicode_t korean_row_codes_a1[] =
{
/* 0xa141 */
0xc8a5, 0xc8a6, 0xc8a7, 0xc8a9, 0xc8aa, 0xc8ab, 0xc8ac, 0xc8ad, 0xc8ae, 0xc8af, 0xc8b0, 0xc8b1, 0xc8b2, 0xc8b3, 0xc8b4, 
/* 0xa150 */
0xc8b5, 0xc8b6, 0xc8b7, 0xc8b8, 0xc8b9, 0xc8ba, 0xc8bb, 0xc8be, 0xc8bf, 0xc8c0, 0xc8c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa160 */
0x0000, 0xc8c2, 0xc8c3, 0xc8c5, 0xc8c6, 0xc8c7, 0xc8c9, 0xc8ca, 0xc8cb, 0xc8cd, 0xc8ce, 0xc8cf, 0xc8d0, 0xc8d1, 0xc8d2, 0xc8d3, 
/* 0xa170 */
0xc8d6, 0xc8d8, 0xc8da, 0xc8db, 0xc8dc, 0xc8dd, 0xc8de, 0xc8df, 0xc8e2, 0xc8e3, 0xc8e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa180 */
0x0000, 0xc8e6, 0xc8e7, 0xc8e8, 0xc8e9, 0xc8ea, 0xc8eb, 0xc8ec, 0xc8ed, 0xc8ee, 0xc8ef, 0xc8f0, 0xc8f1, 0xc8f2, 0xc8f3, 0xc8f4, 
/* 0xa190 */
0xc8f6, 0xc8f7, 0xc8f8, 0xc8f9, 0xc8fa, 0xc8fb, 0xc8fe, 0xc8ff, 0xc901, 0xc902, 0xc903, 0xc907, 0xc908, 0xc909, 0xc90a, 0xc90b, 
/* 0xa1a0 */
0xc90e, 0x3000, 0x3001, 0x3002, 0x00b7, 0x2025, 0x2026, 0x00a8, 0x3003, 0x00ad, 0x2015, 0x2225, 0xff3c, 0x223c, 0x2018, 0x2019, 
/* 0xa1b0 */
0x201c, 0x201d, 0x3014, 0x3015, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e, 0x300f, 0x3010, 0x3011, 0x00b1, 0x00d7, 
/* 0xa1c0 */
0x00f7, 0x2260, 0x2264, 0x2265, 0x221e, 0x2234, 0x00b0, 0x2032, 0x2033, 0x2103, 0x212b, 0xffe0, 0xffe1, 0xffe5, 0x2642, 0x2640, 
/* 0xa1d0 */
0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 0x00a7, 0x203b, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6, 
/* 0xa1e0 */
0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x2192, 0x2190, 0x2191, 0x2193, 0x2194, 0x3013, 0x226a, 0x226b, 0x221a, 0x223d, 
/* 0xa1f0 */
0x221d, 0x2235, 0x222b, 0x222c, 0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 0x2229, 0x2227, 0x2228, 0xffe2, 
};
static struct cp2unicode_row korean_row_a1 = { 0xa1, 0x41, 0xbe, korean_row_codes_a1 };
static unicode_t korean_row_codes_a2[] =
{
/* 0xa241 */
0xc910, 0xc912, 0xc913, 0xc914, 0xc915, 0xc916, 0xc917, 0xc919, 0xc91a, 0xc91b, 0xc91c, 0xc91d, 0xc91e, 0xc91f, 0xc920, 
/* 0xa250 */
0xc921, 0xc922, 0xc923, 0xc924, 0xc925, 0xc926, 0xc927, 0xc928, 0xc929, 0xc92a, 0xc92b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa260 */
0x0000, 0xc92d, 0xc92e, 0xc92f, 0xc930, 0xc931, 0xc932, 0xc933, 0xc935, 0xc936, 0xc937, 0xc938, 0xc939, 0xc93a, 0xc93b, 0xc93c, 
/* 0xa270 */
0xc93d, 0xc93e, 0xc93f, 0xc940, 0xc941, 0xc942, 0xc943, 0xc944, 0xc945, 0xc946, 0xc947, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa280 */
0x0000, 0xc948, 0xc949, 0xc94a, 0xc94b, 0xc94c, 0xc94d, 0xc94e, 0xc94f, 0xc952, 0xc953, 0xc955, 0xc956, 0xc957, 0xc959, 0xc95a, 
/* 0xa290 */
0xc95b, 0xc95c, 0xc95d, 0xc95e, 0xc95f, 0xc962, 0xc964, 0xc965, 0xc966, 0xc967, 0xc968, 0xc969, 0xc96a, 0xc96b, 0xc96d, 0xc96e, 
/* 0xa2a0 */
0xc96f, 0x21d2, 0x21d4, 0x2200, 0x2203, 0x00b4, 0xff5e, 0x02c7, 0x02d8, 0x02dd, 0x02da, 0x02d9, 0x00b8, 0x02db, 0x00a1, 0x00bf, 
/* 0xa2b0 */
0x02d0, 0x222e, 0x2211, 0x220f, 0x00a4, 0x2109, 0x2030, 0x25c1, 0x25c0, 0x25b7, 0x25b6, 0x2664, 0x2660, 0x2661, 0x2665, 0x2667, 
/* 0xa2c0 */
0x2663, 0x2299, 0x25c8, 0x25a3, 0x25d0, 0x25d1, 0x2592, 0x25a4, 0x25a5, 0x25a8, 0x25a7, 0x25a6, 0x25a9, 0x2668, 0x260f, 0x260e, 
/* 0xa2d0 */
0x261c, 0x261e, 0x00b6, 0x2020, 0x2021, 0x2195, 0x2197, 0x2199, 0x2196, 0x2198, 0x266d, 0x2669, 0x266a, 0x266c, 0x327f, 0x321c, 
/* 0xa2e0 */
0x2116, 0x33c7, 0x2122, 0x33c2, 0x33d8, 0x2121, 0x20ac, 0x00ae, 
};
static struct cp2unicode_row korean_row_a2 = { 0xa2, 0x41, 0xa7, korean_row_codes_a2 };
static unicode_t korean_row_codes_a3[] =
{
/* 0xa341 */
0xc971, 0xc972, 0xc973, 0xc975, 0xc976, 0xc977, 0xc978, 0xc979, 0xc97a, 0xc97b, 0xc97d, 0xc97e, 0xc97f, 0xc980, 0xc981, 
/* 0xa350 */
0xc982, 0xc983, 0xc984, 0xc985, 0xc986, 0xc987, 0xc98a, 0xc98b, 0xc98d, 0xc98e, 0xc98f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa360 */
0x0000, 0xc991, 0xc992, 0xc993, 0xc994, 0xc995, 0xc996, 0xc997, 0xc99a, 0xc99c, 0xc99e, 0xc99f, 0xc9a0, 0xc9a1, 0xc9a2, 0xc9a3, 
/* 0xa370 */
0xc9a4, 0xc9a5, 0xc9a6, 0xc9a7, 0xc9a8, 0xc9a9, 0xc9aa, 0xc9ab, 0xc9ac, 0xc9ad, 0xc9ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa380 */
0x0000, 0xc9af, 0xc9b0, 0xc9b1, 0xc9b2, 0xc9b3, 0xc9b4, 0xc9b5, 0xc9b6, 0xc9b7, 0xc9b8, 0xc9b9, 0xc9ba, 0xc9bb, 0xc9bc, 0xc9bd, 
/* 0xa390 */
0xc9be, 0xc9bf, 0xc9c2, 0xc9c3, 0xc9c5, 0xc9c6, 0xc9c9, 0xc9cb, 0xc9cc, 0xc9cd, 0xc9ce, 0xc9cf, 0xc9d2, 0xc9d4, 0xc9d7, 0xc9d8, 
/* 0xa3a0 */
0xc9db, 0xff01, 0xff02, 0xff03, 0xff04, 0xff05, 0xff06, 0xff07, 0xff08, 0xff09, 0xff0a, 0xff0b, 0xff0c, 0xff0d, 0xff0e, 0xff0f, 
/* 0xa3b0 */
0xff10, 0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xff1a, 0xff1b, 0xff1c, 0xff1d, 0xff1e, 0xff1f, 
/* 0xa3c0 */
0xff20, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f, 
/* 0xa3d0 */
0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a, 0xff3b, 0xffe6, 0xff3d, 0xff3e, 0xff3f, 
/* 0xa3e0 */
0xff40, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f, 
/* 0xa3f0 */
0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a, 0xff5b, 0xff5c, 0xff5d, 0xffe3, 
};
static struct cp2unicode_row korean_row_a3 = { 0xa3, 0x41, 0xbe, korean_row_codes_a3 };
static unicode_t korean_row_codes_a4[] =
{
/* 0xa441 */
0xc9de, 0xc9df, 0xc9e1, 0xc9e3, 0xc9e5, 0xc9e6, 0xc9e8, 0xc9e9, 0xc9ea, 0xc9eb, 0xc9ee, 0xc9f2, 0xc9f3, 0xc9f4, 0xc9f5, 
/* 0xa450 */
0xc9f6, 0xc9f7, 0xc9fa, 0xc9fb, 0xc9fd, 0xc9fe, 0xc9ff, 0xca01, 0xca02, 0xca03, 0xca04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa460 */
0x0000, 0xca05, 0xca06, 0xca07, 0xca0a, 0xca0e, 0xca0f, 0xca10, 0xca11, 0xca12, 0xca13, 0xca15, 0xca16, 0xca17, 0xca19, 0xca1a, 
/* 0xa470 */
0xca1b, 0xca1c, 0xca1d, 0xca1e, 0xca1f, 0xca20, 0xca21, 0xca22, 0xca23, 0xca24, 0xca25, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa480 */
0x0000, 0xca26, 0xca27, 0xca28, 0xca2a, 0xca2b, 0xca2c, 0xca2d, 0xca2e, 0xca2f, 0xca30, 0xca31, 0xca32, 0xca33, 0xca34, 0xca35, 
/* 0xa490 */
0xca36, 0xca37, 0xca38, 0xca39, 0xca3a, 0xca3b, 0xca3c, 0xca3d, 0xca3e, 0xca3f, 0xca40, 0xca41, 0xca42, 0xca43, 0xca44, 0xca45, 
/* 0xa4a0 */
0xca46, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138, 0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e, 0x313f, 
/* 0xa4b0 */
0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x314f, 
/* 0xa4c0 */
0x3150, 0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315a, 0x315b, 0x315c, 0x315d, 0x315e, 0x315f, 
/* 0xa4d0 */
0x3160, 0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168, 0x3169, 0x316a, 0x316b, 0x316c, 0x316d, 0x316e, 0x316f, 
/* 0xa4e0 */
0x3170, 0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176, 0x3177, 0x3178, 0x3179, 0x317a, 0x317b, 0x317c, 0x317d, 0x317e, 0x317f, 
/* 0xa4f0 */
0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 0x3188, 0x3189, 0x318a, 0x318b, 0x318c, 0x318d, 0x318e, 
};
static struct cp2unicode_row korean_row_a4 = { 0xa4, 0x41, 0xbe, korean_row_codes_a4 };
static unicode_t korean_row_codes_a5[] =
{
/* 0xa541 */
0xca47, 0xca48, 0xca49, 0xca4a, 0xca4b, 0xca4e, 0xca4f, 0xca51, 0xca52, 0xca53, 0xca55, 0xca56, 0xca57, 0xca58, 0xca59, 
/* 0xa550 */
0xca5a, 0xca5b, 0xca5e, 0xca62, 0xca63, 0xca64, 0xca65, 0xca66, 0xca67, 0xca69, 0xca6a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa560 */
0x0000, 0xca6b, 0xca6c, 0xca6d, 0xca6e, 0xca6f, 0xca70, 0xca71, 0xca72, 0xca73, 0xca74, 0xca75, 0xca76, 0xca77, 0xca78, 0xca79, 
/* 0xa570 */
0xca7a, 0xca7b, 0xca7c, 0xca7e, 0xca7f, 0xca80, 0xca81, 0xca82, 0xca83, 0xca85, 0xca86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa580 */
0x0000, 0xca87, 0xca88, 0xca89, 0xca8a, 0xca8b, 0xca8c, 0xca8d, 0xca8e, 0xca8f, 0xca90, 0xca91, 0xca92, 0xca93, 0xca94, 0xca95, 
/* 0xa590 */
0xca96, 0xca97, 0xca99, 0xca9a, 0xca9b, 0xca9c, 0xca9d, 0xca9e, 0xca9f, 0xcaa0, 0xcaa1, 0xcaa2, 0xcaa3, 0xcaa4, 0xcaa5, 0xcaa6, 
/* 0xa5a0 */
0xcaa7, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa5b0 */
0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa5c0 */
0x0000, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
/* 0xa5d0 */
0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa5e0 */
0x0000, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 
/* 0xa5f0 */
0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 
};
static struct cp2unicode_row korean_row_a5 = { 0xa5, 0x41, 0xb8, korean_row_codes_a5 };
static unicode_t korean_row_codes_a6[] =
{
/* 0xa641 */
0xcaa8, 0xcaa9, 0xcaaa, 0xcaab, 0xcaac, 0xcaad, 0xcaae, 0xcaaf, 0xcab0, 0xcab1, 0xcab2, 0xcab3, 0xcab4, 0xcab5, 0xcab6, 
/* 0xa650 */
0xcab7, 0xcab8, 0xcab9, 0xcaba, 0xcabb, 0xcabe, 0xcabf, 0xcac1, 0xcac2, 0xcac3, 0xcac5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa660 */
0x0000, 0xcac6, 0xcac7, 0xcac8, 0xcac9, 0xcaca, 0xcacb, 0xcace, 0xcad0, 0xcad2, 0xcad4, 0xcad5, 0xcad6, 0xcad7, 0xcada, 0xcadb, 
/* 0xa670 */
0xcadc, 0xcadd, 0xcade, 0xcadf, 0xcae1, 0xcae2, 0xcae3, 0xcae4, 0xcae5, 0xcae6, 0xcae7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa680 */
0x0000, 0xcae8, 0xcae9, 0xcaea, 0xcaeb, 0xcaed, 0xcaee, 0xcaef, 0xcaf0, 0xcaf1, 0xcaf2, 0xcaf3, 0xcaf5, 0xcaf6, 0xcaf7, 0xcaf8, 
/* 0xa690 */
0xcaf9, 0xcafa, 0xcafb, 0xcafc, 0xcafd, 0xcafe, 0xcaff, 0xcb00, 0xcb01, 0xcb02, 0xcb03, 0xcb04, 0xcb05, 0xcb06, 0xcb07, 0xcb09, 
/* 0xa6a0 */
0xcb0a, 0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524, 0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 
/* 0xa6b0 */
0x251b, 0x2517, 0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528, 0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 
/* 0xa6c0 */
0x2542, 0x2512, 0x2511, 0x251a, 0x2519, 0x2516, 0x2515, 0x250e, 0x250d, 0x251e, 0x251f, 0x2521, 0x2522, 0x2526, 0x2527, 0x2529, 
/* 0xa6d0 */
0x252a, 0x252d, 0x252e, 0x2531, 0x2532, 0x2535, 0x2536, 0x2539, 0x253a, 0x253d, 0x253e, 0x2540, 0x2541, 0x2543, 0x2544, 0x2545, 
/* 0xa6e0 */
0x2546, 0x2547, 0x2548, 0x2549, 0x254a, 
};
static struct cp2unicode_row korean_row_a6 = { 0xa6, 0x41, 0xa4, korean_row_codes_a6 };
static unicode_t korean_row_codes_a7[] =
{
/* 0xa741 */
0xcb0b, 0xcb0c, 0xcb0d, 0xcb0e, 0xcb0f, 0xcb11, 0xcb12, 0xcb13, 0xcb15, 0xcb16, 0xcb17, 0xcb19, 0xcb1a, 0xcb1b, 0xcb1c, 
/* 0xa750 */
0xcb1d, 0xcb1e, 0xcb1f, 0xcb22, 0xcb23, 0xcb24, 0xcb25, 0xcb26, 0xcb27, 0xcb28, 0xcb29, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa760 */
0x0000, 0xcb2a, 0xcb2b, 0xcb2c, 0xcb2d, 0xcb2e, 0xcb2f, 0xcb30, 0xcb31, 0xcb32, 0xcb33, 0xcb34, 0xcb35, 0xcb36, 0xcb37, 0xcb38, 
/* 0xa770 */
0xcb39, 0xcb3a, 0xcb3b, 0xcb3c, 0xcb3d, 0xcb3e, 0xcb3f, 0xcb40, 0xcb42, 0xcb43, 0xcb44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa780 */
0x0000, 0xcb45, 0xcb46, 0xcb47, 0xcb4a, 0xcb4b, 0xcb4d, 0xcb4e, 0xcb4f, 0xcb51, 0xcb52, 0xcb53, 0xcb54, 0xcb55, 0xcb56, 0xcb57, 
/* 0xa790 */
0xcb5a, 0xcb5b, 0xcb5c, 0xcb5e, 0xcb5f, 0xcb60, 0xcb61, 0xcb62, 0xcb63, 0xcb65, 0xcb66, 0xcb67, 0xcb68, 0xcb69, 0xcb6a, 0xcb6b, 
/* 0xa7a0 */
0xcb6c, 0x3395, 0x3396, 0x3397, 0x2113, 0x3398, 0x33c4, 0x33a3, 0x33a4, 0x33a5, 0x33a6, 0x3399, 0x339a, 0x339b, 0x339c, 0x339d, 
/* 0xa7b0 */
0x339e, 0x339f, 0x33a0, 0x33a1, 0x33a2, 0x33ca, 0x338d, 0x338e, 0x338f, 0x33cf, 0x3388, 0x3389, 0x33c8, 0x33a7, 0x33a8, 0x33b0, 
/* 0xa7c0 */
0x33b1, 0x33b2, 0x33b3, 0x33b4, 0x33b5, 0x33b6, 0x33b7, 0x33b8, 0x33b9, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x33ba, 0x33bb, 
/* 0xa7d0 */
0x33bc, 0x33bd, 0x33be, 0x33bf, 0x3390, 0x3391, 0x3392, 0x3393, 0x3394, 0x2126, 0x33c0, 0x33c1, 0x338a, 0x338b, 0x338c, 0x33d6, 
/* 0xa7e0 */
0x33c5, 0x33ad, 0x33ae, 0x33af, 0x33db, 0x33a9, 0x33aa, 0x33ab, 0x33ac, 0x33dd, 0x33d0, 0x33d3, 0x33c3, 0x33c9, 0x33dc, 0x33c6, 
};
static struct cp2unicode_row korean_row_a7 = { 0xa7, 0x41, 0xaf, korean_row_codes_a7 };
static unicode_t korean_row_codes_a8[] =
{
/* 0xa841 */
0xcb6d, 0xcb6e, 0xcb6f, 0xcb70, 0xcb71, 0xcb72, 0xcb73, 0xcb74, 0xcb75, 0xcb76, 0xcb77, 0xcb7a, 0xcb7b, 0xcb7c, 0xcb7d, 
/* 0xa850 */
0xcb7e, 0xcb7f, 0xcb80, 0xcb81, 0xcb82, 0xcb83, 0xcb84, 0xcb85, 0xcb86, 0xcb87, 0xcb88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa860 */
0x0000, 0xcb89, 0xcb8a, 0xcb8b, 0xcb8c, 0xcb8d, 0xcb8e, 0xcb8f, 0xcb90, 0xcb91, 0xcb92, 0xcb93, 0xcb94, 0xcb95, 0xcb96, 0xcb97, 
/* 0xa870 */
0xcb98, 0xcb99, 0xcb9a, 0xcb9b, 0xcb9d, 0xcb9e, 0xcb9f, 0xcba0, 0xcba1, 0xcba2, 0xcba3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa880 */
0x0000, 0xcba4, 0xcba5, 0xcba6, 0xcba7, 0xcba8, 0xcba9, 0xcbaa, 0xcbab, 0xcbac, 0xcbad, 0xcbae, 0xcbaf, 0xcbb0, 0xcbb1, 0xcbb2, 
/* 0xa890 */
0xcbb3, 0xcbb4, 0xcbb5, 0xcbb6, 0xcbb7, 0xcbb9, 0xcbba, 0xcbbb, 0xcbbc, 0xcbbd, 0xcbbe, 0xcbbf, 0xcbc0, 0xcbc1, 0xcbc2, 0xcbc3, 
/* 0xa8a0 */
0xcbc4, 0x00c6, 0x00d0, 0x00aa, 0x0126, 0x0000, 0x0132, 0x0000, 0x013f, 0x0141, 0x00d8, 0x0152, 0x00ba, 0x00de, 0x0166, 0x014a, 
/* 0xa8b0 */
0x0000, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266, 0x3267, 0x3268, 0x3269, 0x326a, 0x326b, 0x326c, 0x326d, 0x326e, 
/* 0xa8c0 */
0x326f, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276, 0x3277, 0x3278, 0x3279, 0x327a, 0x327b, 0x24d0, 0x24d1, 0x24d2, 
/* 0xa8d0 */
0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9, 0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1, 0x24e2, 
/* 0xa8e0 */
0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 
/* 0xa8f0 */
0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x00bd, 0x2153, 0x2154, 0x00bc, 0x00be, 0x215b, 0x215c, 0x215d, 0x215e, 
};
static struct cp2unicode_row korean_row_a8 = { 0xa8, 0x41, 0xbe, korean_row_codes_a8 };
static unicode_t korean_row_codes_a9[] =
{
/* 0xa941 */
0xcbc5, 0xcbc6, 0xcbc7, 0xcbc8, 0xcbc9, 0xcbca, 0xcbcb, 0xcbcc, 0xcbcd, 0xcbce, 0xcbcf, 0xcbd0, 0xcbd1, 0xcbd2, 0xcbd3, 
/* 0xa950 */
0xcbd5, 0xcbd6, 0xcbd7, 0xcbd8, 0xcbd9, 0xcbda, 0xcbdb, 0xcbdc, 0xcbdd, 0xcbde, 0xcbdf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa960 */
0x0000, 0xcbe0, 0xcbe1, 0xcbe2, 0xcbe3, 0xcbe5, 0xcbe6, 0xcbe8, 0xcbea, 0xcbeb, 0xcbec, 0xcbed, 0xcbee, 0xcbef, 0xcbf0, 0xcbf1, 
/* 0xa970 */
0xcbf2, 0xcbf3, 0xcbf4, 0xcbf5, 0xcbf6, 0xcbf7, 0xcbf8, 0xcbf9, 0xcbfa, 0xcbfb, 0xcbfc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xa980 */
0x0000, 0xcbfd, 0xcbfe, 0xcbff, 0xcc00, 0xcc01, 0xcc02, 0xcc03, 0xcc04, 0xcc05, 0xcc06, 0xcc07, 0xcc08, 0xcc09, 0xcc0a, 0xcc0b, 
/* 0xa990 */
0xcc0e, 0xcc0f, 0xcc11, 0xcc12, 0xcc13, 0xcc15, 0xcc16, 0xcc17, 0xcc18, 0xcc19, 0xcc1a, 0xcc1b, 0xcc1e, 0xcc1f, 0xcc20, 0xcc23, 
/* 0xa9a0 */
0xcc24, 0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0140, 0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 0x0167, 0x014b, 
/* 0xa9b0 */
0x0149, 0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207, 0x3208, 0x3209, 0x320a, 0x320b, 0x320c, 0x320d, 0x320e, 
/* 0xa9c0 */
0x320f, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217, 0x3218, 0x3219, 0x321a, 0x321b, 0x249c, 0x249d, 0x249e, 
/* 0xa9d0 */
0x249f, 0x24a0, 0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 0x24a6, 0x24a7, 0x24a8, 0x24a9, 0x24aa, 0x24ab, 0x24ac, 0x24ad, 0x24ae, 
/* 0xa9e0 */
0x24af, 0x24b0, 0x24b1, 0x24b2, 0x24b3, 0x24b4, 0x24b5, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c, 
/* 0xa9f0 */
0x247d, 0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 0x00b9, 0x00b2, 0x00b3, 0x2074, 0x207f, 0x2081, 0x2082, 0x2083, 0x2084, 
};
static struct cp2unicode_row korean_row_a9 = { 0xa9, 0x41, 0xbe, korean_row_codes_a9 };
static unicode_t korean_row_codes_aa[] =
{
/* 0xaa41 */
0xcc25, 0xcc26, 0xcc2a, 0xcc2b, 0xcc2d, 0xcc2f, 0xcc31, 0xcc32, 0xcc33, 0xcc34, 0xcc35, 0xcc36, 0xcc37, 0xcc3a, 0xcc3f, 
/* 0xaa50 */
0xcc40, 0xcc41, 0xcc42, 0xcc43, 0xcc46, 0xcc47, 0xcc49, 0xcc4a, 0xcc4b, 0xcc4d, 0xcc4e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xaa60 */
0x0000, 0xcc4f, 0xcc50, 0xcc51, 0xcc52, 0xcc53, 0xcc56, 0xcc5a, 0xcc5b, 0xcc5c, 0xcc5d, 0xcc5e, 0xcc5f, 0xcc61, 0xcc62, 0xcc63, 
/* 0xaa70 */
0xcc65, 0xcc67, 0xcc69, 0xcc6a, 0xcc6b, 0xcc6c, 0xcc6d, 0xcc6e, 0xcc6f, 0xcc71, 0xcc72, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xaa80 */
0x0000, 0xcc73, 0xcc74, 0xcc76, 0xcc77, 0xcc78, 0xcc79, 0xcc7a, 0xcc7b, 0xcc7c, 0xcc7d, 0xcc7e, 0xcc7f, 0xcc80, 0xcc81, 0xcc82, 
/* 0xaa90 */
0xcc83, 0xcc84, 0xcc85, 0xcc86, 0xcc87, 0xcc88, 0xcc89, 0xcc8a, 0xcc8b, 0xcc8c, 0xcc8d, 0xcc8e, 0xcc8f, 0xcc90, 0xcc91, 0xcc92, 
/* 0xaaa0 */
0xcc93, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 
/* 0xaab0 */
0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f, 
/* 0xaac0 */
0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 
/* 0xaad0 */
0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 
/* 0xaae0 */
0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 
/* 0xaaf0 */
0x3090, 0x3091, 0x3092, 0x3093, 
};
static struct cp2unicode_row korean_row_aa = { 0xaa, 0x41, 0xb3, korean_row_codes_aa };
static unicode_t korean_row_codes_ab[] =
{
/* 0xab41 */
0xcc94, 0xcc95, 0xcc96, 0xcc97, 0xcc9a, 0xcc9b, 0xcc9d, 0xcc9e, 0xcc9f, 0xcca1, 0xcca2, 0xcca3, 0xcca4, 0xcca5, 0xcca6, 
/* 0xab50 */
0xcca7, 0xccaa, 0xccae, 0xccaf, 0xccb0, 0xccb1, 0xccb2, 0xccb3, 0xccb6, 0xccb7, 0xccb9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xab60 */
0x0000, 0xccba, 0xccbb, 0xccbd, 0xccbe, 0xccbf, 0xccc0, 0xccc1, 0xccc2, 0xccc3, 0xccc6, 0xccc8, 0xccca, 0xcccb, 0xcccc, 0xcccd, 
/* 0xab70 */
0xccce, 0xcccf, 0xccd1, 0xccd2, 0xccd3, 0xccd5, 0xccd6, 0xccd7, 0xccd8, 0xccd9, 0xccda, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xab80 */
0x0000, 0xccdb, 0xccdc, 0xccdd, 0xccde, 0xccdf, 0xcce0, 0xcce1, 0xcce2, 0xcce3, 0xcce5, 0xcce6, 0xcce7, 0xcce8, 0xcce9, 0xccea, 
/* 0xab90 */
0xcceb, 0xcced, 0xccee, 0xccef, 0xccf1, 0xccf2, 0xccf3, 0xccf4, 0xccf5, 0xccf6, 0xccf7, 0xccf8, 0xccf9, 0xccfa, 0xccfb, 0xccfc, 
/* 0xaba0 */
0xccfd, 0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8, 0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 
/* 0xabb0 */
0x30b0, 0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8, 0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 
/* 0xabc0 */
0x30c0, 0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 
/* 0xabd0 */
0x30d0, 0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8, 0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 
/* 0xabe0 */
0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef, 
/* 0xabf0 */
0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 
};
static struct cp2unicode_row korean_row_ab = { 0xab, 0x41, 0xb6, korean_row_codes_ab };
static unicode_t korean_row_codes_ac[] =
{
/* 0xac41 */
0xccfe, 0xccff, 0xcd00, 0xcd02, 0xcd03, 0xcd04, 0xcd05, 0xcd06, 0xcd07, 0xcd0a, 0xcd0b, 0xcd0d, 0xcd0e, 0xcd0f, 0xcd11, 
/* 0xac50 */
0xcd12, 0xcd13, 0xcd14, 0xcd15, 0xcd16, 0xcd17, 0xcd1a, 0xcd1c, 0xcd1e, 0xcd1f, 0xcd20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xac60 */
0x0000, 0xcd21, 0xcd22, 0xcd23, 0xcd25, 0xcd26, 0xcd27, 0xcd29, 0xcd2a, 0xcd2b, 0xcd2d, 0xcd2e, 0xcd2f, 0xcd30, 0xcd31, 0xcd32, 
/* 0xac70 */
0xcd33, 0xcd34, 0xcd35, 0xcd36, 0xcd37, 0xcd38, 0xcd3a, 0xcd3b, 0xcd3c, 0xcd3d, 0xcd3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xac80 */
0x0000, 0xcd3f, 0xcd40, 0xcd41, 0xcd42, 0xcd43, 0xcd44, 0xcd45, 0xcd46, 0xcd47, 0xcd48, 0xcd49, 0xcd4a, 0xcd4b, 0xcd4c, 0xcd4d, 
/* 0xac90 */
0xcd4e, 0xcd4f, 0xcd50, 0xcd51, 0xcd52, 0xcd53, 0xcd54, 0xcd55, 0xcd56, 0xcd57, 0xcd58, 0xcd59, 0xcd5a, 0xcd5b, 0xcd5d, 0xcd5e, 
/* 0xaca0 */
0xcd5f, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 
/* 0xacb0 */
0x041e, 0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 
/* 0xacc0 */
0x042e, 0x042f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xacd0 */
0x0000, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 
/* 0xace0 */
0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 
/* 0xacf0 */
0x044e, 0x044f, 
};
static struct cp2unicode_row korean_row_ac = { 0xac, 0x41, 0xb1, korean_row_codes_ac };
static unicode_t korean_row_codes_ad[] =
{
/* 0xad41 */
0xcd61, 0xcd62, 0xcd63, 0xcd65, 0xcd66, 0xcd67, 0xcd68, 0xcd69, 0xcd6a, 0xcd6b, 0xcd6e, 0xcd70, 0xcd72, 0xcd73, 0xcd74, 
/* 0xad50 */
0xcd75, 0xcd76, 0xcd77, 0xcd79, 0xcd7a, 0xcd7b, 0xcd7c, 0xcd7d, 0xcd7e, 0xcd7f, 0xcd80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xad60 */
0x0000, 0xcd81, 0xcd82, 0xcd83, 0xcd84, 0xcd85, 0xcd86, 0xcd87, 0xcd89, 0xcd8a, 0xcd8b, 0xcd8c, 0xcd8d, 0xcd8e, 0xcd8f, 0xcd90, 
/* 0xad70 */
0xcd91, 0xcd92, 0xcd93, 0xcd96, 0xcd97, 0xcd99, 0xcd9a, 0xcd9b, 0xcd9d, 0xcd9e, 0xcd9f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xad80 */
0x0000, 0xcda0, 0xcda1, 0xcda2, 0xcda3, 0xcda6, 0xcda8, 0xcdaa, 0xcdab, 0xcdac, 0xcdad, 0xcdae, 0xcdaf, 0xcdb1, 0xcdb2, 0xcdb3, 
/* 0xad90 */
0xcdb4, 0xcdb5, 0xcdb6, 0xcdb7, 0xcdb8, 0xcdb9, 0xcdba, 0xcdbb, 0xcdbc, 0xcdbd, 0xcdbe, 0xcdbf, 0xcdc0, 0xcdc1, 0xcdc2, 0xcdc3, 
/* 0xada0 */
0xcdc5, 
};
static struct cp2unicode_row korean_row_ad = { 0xad, 0x41, 0x60, korean_row_codes_ad };
static unicode_t korean_row_codes_ae[] =
{
/* 0xae41 */
0xcdc6, 0xcdc7, 0xcdc8, 0xcdc9, 0xcdca, 0xcdcb, 0xcdcd, 0xcdce, 0xcdcf, 0xcdd1, 0xcdd2, 0xcdd3, 0xcdd4, 0xcdd5, 0xcdd6, 
/* 0xae50 */
0xcdd7, 0xcdd8, 0xcdd9, 0xcdda, 0xcddb, 0xcddc, 0xcddd, 0xcdde, 0xcddf, 0xcde0, 0xcde1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xae60 */
0x0000, 0xcde2, 0xcde3, 0xcde4, 0xcde5, 0xcde6, 0xcde7, 0xcde9, 0xcdea, 0xcdeb, 0xcded, 0xcdee, 0xcdef, 0xcdf1, 0xcdf2, 0xcdf3, 
/* 0xae70 */
0xcdf4, 0xcdf5, 0xcdf6, 0xcdf7, 0xcdfa, 0xcdfc, 0xcdfe, 0xcdff, 0xce00, 0xce01, 0xce02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xae80 */
0x0000, 0xce03, 0xce05, 0xce06, 0xce07, 0xce09, 0xce0a, 0xce0b, 0xce0d, 0xce0e, 0xce0f, 0xce10, 0xce11, 0xce12, 0xce13, 0xce15, 
/* 0xae90 */
0xce16, 0xce17, 0xce18, 0xce1a, 0xce1b, 0xce1c, 0xce1d, 0xce1e, 0xce1f, 0xce22, 0xce23, 0xce25, 0xce26, 0xce27, 0xce29, 0xce2a, 
/* 0xaea0 */
0xce2b, 
};
static struct cp2unicode_row korean_row_ae = { 0xae, 0x41, 0x60, korean_row_codes_ae };
static unicode_t korean_row_codes_af[] =
{
/* 0xaf41 */
0xce2c, 0xce2d, 0xce2e, 0xce2f, 0xce32, 0xce34, 0xce36, 0xce37, 0xce38, 0xce39, 0xce3a, 0xce3b, 0xce3c, 0xce3d, 0xce3e, 
/* 0xaf50 */
0xce3f, 0xce40, 0xce41, 0xce42, 0xce43, 0xce44, 0xce45, 0xce46, 0xce47, 0xce48, 0xce49, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xaf60 */
0x0000, 0xce4a, 0xce4b, 0xce4c, 0xce4d, 0xce4e, 0xce4f, 0xce50, 0xce51, 0xce52, 0xce53, 0xce54, 0xce55, 0xce56, 0xce57, 0xce5a, 
/* 0xaf70 */
0xce5b, 0xce5d, 0xce5e, 0xce62, 0xce63, 0xce64, 0xce65, 0xce66, 0xce67, 0xce6a, 0xce6c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xaf80 */
0x0000, 0xce6e, 0xce6f, 0xce70, 0xce71, 0xce72, 0xce73, 0xce76, 0xce77, 0xce79, 0xce7a, 0xce7b, 0xce7d, 0xce7e, 0xce7f, 0xce80, 
/* 0xaf90 */
0xce81, 0xce82, 0xce83, 0xce86, 0xce88, 0xce8a, 0xce8b, 0xce8c, 0xce8d, 0xce8e, 0xce8f, 0xce92, 0xce93, 0xce95, 0xce96, 0xce97, 
/* 0xafa0 */
0xce99, 
};
static struct cp2unicode_row korean_row_af = { 0xaf, 0x41, 0x60, korean_row_codes_af };
static unicode_t korean_row_codes_b0[] =
{
/* 0xb041 */
0xce9a, 0xce9b, 0xce9c, 0xce9d, 0xce9e, 0xce9f, 0xcea2, 0xcea6, 0xcea7, 0xcea8, 0xcea9, 0xceaa, 0xceab, 0xceae, 0xceaf, 
/* 0xb050 */
0xceb0, 0xceb1, 0xceb2, 0xceb3, 0xceb4, 0xceb5, 0xceb6, 0xceb7, 0xceb8, 0xceb9, 0xceba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb060 */
0x0000, 0xcebb, 0xcebc, 0xcebd, 0xcebe, 0xcebf, 0xcec0, 0xcec2, 0xcec3, 0xcec4, 0xcec5, 0xcec6, 0xcec7, 0xcec8, 0xcec9, 0xceca, 
/* 0xb070 */
0xcecb, 0xcecc, 0xcecd, 0xcece, 0xcecf, 0xced0, 0xced1, 0xced2, 0xced3, 0xced4, 0xced5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb080 */
0x0000, 0xced6, 0xced7, 0xced8, 0xced9, 0xceda, 0xcedb, 0xcedc, 0xcedd, 0xcede, 0xcedf, 0xcee0, 0xcee1, 0xcee2, 0xcee3, 0xcee6, 
/* 0xb090 */
0xcee7, 0xcee9, 0xceea, 0xceed, 0xceee, 0xceef, 0xcef0, 0xcef1, 0xcef2, 0xcef3, 0xcef6, 0xcefa, 0xcefb, 0xcefc, 0xcefd, 0xcefe, 
/* 0xb0a0 */
0xceff, 0xac00, 0xac01, 0xac04, 0xac07, 0xac08, 0xac09, 0xac0a, 0xac10, 0xac11, 0xac12, 0xac13, 0xac14, 0xac15, 0xac16, 0xac17, 
/* 0xb0b0 */
0xac19, 0xac1a, 0xac1b, 0xac1c, 0xac1d, 0xac20, 0xac24, 0xac2c, 0xac2d, 0xac2f, 0xac30, 0xac31, 0xac38, 0xac39, 0xac3c, 0xac40, 
/* 0xb0c0 */
0xac4b, 0xac4d, 0xac54, 0xac58, 0xac5c, 0xac70, 0xac71, 0xac74, 0xac77, 0xac78, 0xac7a, 0xac80, 0xac81, 0xac83, 0xac84, 0xac85, 
/* 0xb0d0 */
0xac86, 0xac89, 0xac8a, 0xac8b, 0xac8c, 0xac90, 0xac94, 0xac9c, 0xac9d, 0xac9f, 0xaca0, 0xaca1, 0xaca8, 0xaca9, 0xacaa, 0xacac, 
/* 0xb0e0 */
0xacaf, 0xacb0, 0xacb8, 0xacb9, 0xacbb, 0xacbc, 0xacbd, 0xacc1, 0xacc4, 0xacc8, 0xaccc, 0xacd5, 0xacd7, 0xace0, 0xace1, 0xace4, 
/* 0xb0f0 */
0xace7, 0xace8, 0xacea, 0xacec, 0xacef, 0xacf0, 0xacf1, 0xacf3, 0xacf5, 0xacf6, 0xacfc, 0xacfd, 0xad00, 0xad04, 0xad06, 
};
static struct cp2unicode_row korean_row_b0 = { 0xb0, 0x41, 0xbe, korean_row_codes_b0 };
static unicode_t korean_row_codes_b1[] =
{
/* 0xb141 */
0xcf02, 0xcf03, 0xcf05, 0xcf06, 0xcf07, 0xcf09, 0xcf0a, 0xcf0b, 0xcf0c, 0xcf0d, 0xcf0e, 0xcf0f, 0xcf12, 0xcf14, 0xcf16, 
/* 0xb150 */
0xcf17, 0xcf18, 0xcf19, 0xcf1a, 0xcf1b, 0xcf1d, 0xcf1e, 0xcf1f, 0xcf21, 0xcf22, 0xcf23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb160 */
0x0000, 0xcf25, 0xcf26, 0xcf27, 0xcf28, 0xcf29, 0xcf2a, 0xcf2b, 0xcf2e, 0xcf32, 0xcf33, 0xcf34, 0xcf35, 0xcf36, 0xcf37, 0xcf39, 
/* 0xb170 */
0xcf3a, 0xcf3b, 0xcf3c, 0xcf3d, 0xcf3e, 0xcf3f, 0xcf40, 0xcf41, 0xcf42, 0xcf43, 0xcf44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb180 */
0x0000, 0xcf45, 0xcf46, 0xcf47, 0xcf48, 0xcf49, 0xcf4a, 0xcf4b, 0xcf4c, 0xcf4d, 0xcf4e, 0xcf4f, 0xcf50, 0xcf51, 0xcf52, 0xcf53, 
/* 0xb190 */
0xcf56, 0xcf57, 0xcf59, 0xcf5a, 0xcf5b, 0xcf5d, 0xcf5e, 0xcf5f, 0xcf60, 0xcf61, 0xcf62, 0xcf63, 0xcf66, 0xcf68, 0xcf6a, 0xcf6b, 
/* 0xb1a0 */
0xcf6c, 0xad0c, 0xad0d, 0xad0f, 0xad11, 0xad18, 0xad1c, 0xad20, 0xad29, 0xad2c, 0xad2d, 0xad34, 0xad35, 0xad38, 0xad3c, 0xad44, 
/* 0xb1b0 */
0xad45, 0xad47, 0xad49, 0xad50, 0xad54, 0xad58, 0xad61, 0xad63, 0xad6c, 0xad6d, 0xad70, 0xad73, 0xad74, 0xad75, 0xad76, 0xad7b, 
/* 0xb1c0 */
0xad7c, 0xad7d, 0xad7f, 0xad81, 0xad82, 0xad88, 0xad89, 0xad8c, 0xad90, 0xad9c, 0xad9d, 0xada4, 0xadb7, 0xadc0, 0xadc1, 0xadc4, 
/* 0xb1d0 */
0xadc8, 0xadd0, 0xadd1, 0xadd3, 0xaddc, 0xade0, 0xade4, 0xadf8, 0xadf9, 0xadfc, 0xadff, 0xae00, 0xae01, 0xae08, 0xae09, 0xae0b, 
/* 0xb1e0 */
0xae0d, 0xae14, 0xae30, 0xae31, 0xae34, 0xae37, 0xae38, 0xae3a, 0xae40, 0xae41, 0xae43, 0xae45, 0xae46, 0xae4a, 0xae4c, 0xae4d, 
/* 0xb1f0 */
0xae4e, 0xae50, 0xae54, 0xae56, 0xae5c, 0xae5d, 0xae5f, 0xae60, 0xae61, 0xae65, 0xae68, 0xae69, 0xae6c, 0xae70, 0xae78, 
};
static struct cp2unicode_row korean_row_b1 = { 0xb1, 0x41, 0xbe, korean_row_codes_b1 };
static unicode_t korean_row_codes_b2[] =
{
/* 0xb241 */
0xcf6d, 0xcf6e, 0xcf6f, 0xcf72, 0xcf73, 0xcf75, 0xcf76, 0xcf77, 0xcf79, 0xcf7a, 0xcf7b, 0xcf7c, 0xcf7d, 0xcf7e, 0xcf7f, 
/* 0xb250 */
0xcf81, 0xcf82, 0xcf83, 0xcf84, 0xcf86, 0xcf87, 0xcf88, 0xcf89, 0xcf8a, 0xcf8b, 0xcf8d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb260 */
0x0000, 0xcf8e, 0xcf8f, 0xcf90, 0xcf91, 0xcf92, 0xcf93, 0xcf94, 0xcf95, 0xcf96, 0xcf97, 0xcf98, 0xcf99, 0xcf9a, 0xcf9b, 0xcf9c, 
/* 0xb270 */
0xcf9d, 0xcf9e, 0xcf9f, 0xcfa0, 0xcfa2, 0xcfa3, 0xcfa4, 0xcfa5, 0xcfa6, 0xcfa7, 0xcfa9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb280 */
0x0000, 0xcfaa, 0xcfab, 0xcfac, 0xcfad, 0xcfae, 0xcfaf, 0xcfb1, 0xcfb2, 0xcfb3, 0xcfb4, 0xcfb5, 0xcfb6, 0xcfb7, 0xcfb8, 0xcfb9, 
/* 0xb290 */
0xcfba, 0xcfbb, 0xcfbc, 0xcfbd, 0xcfbe, 0xcfbf, 0xcfc0, 0xcfc1, 0xcfc2, 0xcfc3, 0xcfc5, 0xcfc6, 0xcfc7, 0xcfc8, 0xcfc9, 0xcfca, 
/* 0xb2a0 */
0xcfcb, 0xae79, 0xae7b, 0xae7c, 0xae7d, 0xae84, 0xae85, 0xae8c, 0xaebc, 0xaebd, 0xaebe, 0xaec0, 0xaec4, 0xaecc, 0xaecd, 0xaecf, 
/* 0xb2b0 */
0xaed0, 0xaed1, 0xaed8, 0xaed9, 0xaedc, 0xaee8, 0xaeeb, 0xaeed, 0xaef4, 0xaef8, 0xaefc, 0xaf07, 0xaf08, 0xaf0d, 0xaf10, 0xaf2c, 
/* 0xb2c0 */
0xaf2d, 0xaf30, 0xaf32, 0xaf34, 0xaf3c, 0xaf3d, 0xaf3f, 0xaf41, 0xaf42, 0xaf43, 0xaf48, 0xaf49, 0xaf50, 0xaf5c, 0xaf5d, 0xaf64, 
/* 0xb2d0 */
0xaf65, 0xaf79, 0xaf80, 0xaf84, 0xaf88, 0xaf90, 0xaf91, 0xaf95, 0xaf9c, 0xafb8, 0xafb9, 0xafbc, 0xafc0, 0xafc7, 0xafc8, 0xafc9, 
/* 0xb2e0 */
0xafcb, 0xafcd, 0xafce, 0xafd4, 0xafdc, 0xafe8, 0xafe9, 0xaff0, 0xaff1, 0xaff4, 0xaff8, 0xb000, 0xb001, 0xb004, 0xb00c, 0xb010, 
/* 0xb2f0 */
0xb014, 0xb01c, 0xb01d, 0xb028, 0xb044, 0xb045, 0xb048, 0xb04a, 0xb04c, 0xb04e, 0xb053, 0xb054, 0xb055, 0xb057, 0xb059, 
};
static struct cp2unicode_row korean_row_b2 = { 0xb2, 0x41, 0xbe, korean_row_codes_b2 };
static unicode_t korean_row_codes_b3[] =
{
/* 0xb341 */
0xcfcc, 0xcfcd, 0xcfce, 0xcfcf, 0xcfd0, 0xcfd1, 0xcfd2, 0xcfd3, 0xcfd4, 0xcfd5, 0xcfd6, 0xcfd7, 0xcfd8, 0xcfd9, 0xcfda, 
/* 0xb350 */
0xcfdb, 0xcfdc, 0xcfdd, 0xcfde, 0xcfdf, 0xcfe2, 0xcfe3, 0xcfe5, 0xcfe6, 0xcfe7, 0xcfe9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb360 */
0x0000, 0xcfea, 0xcfeb, 0xcfec, 0xcfed, 0xcfee, 0xcfef, 0xcff2, 0xcff4, 0xcff6, 0xcff7, 0xcff8, 0xcff9, 0xcffa, 0xcffb, 0xcffd, 
/* 0xb370 */
0xcffe, 0xcfff, 0xd001, 0xd002, 0xd003, 0xd005, 0xd006, 0xd007, 0xd008, 0xd009, 0xd00a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb380 */
0x0000, 0xd00b, 0xd00c, 0xd00d, 0xd00e, 0xd00f, 0xd010, 0xd012, 0xd013, 0xd014, 0xd015, 0xd016, 0xd017, 0xd019, 0xd01a, 0xd01b, 
/* 0xb390 */
0xd01c, 0xd01d, 0xd01e, 0xd01f, 0xd020, 0xd021, 0xd022, 0xd023, 0xd024, 0xd025, 0xd026, 0xd027, 0xd028, 0xd029, 0xd02a, 0xd02b, 
/* 0xb3a0 */
0xd02c, 0xb05d, 0xb07c, 0xb07d, 0xb080, 0xb084, 0xb08c, 0xb08d, 0xb08f, 0xb091, 0xb098, 0xb099, 0xb09a, 0xb09c, 0xb09f, 0xb0a0, 
/* 0xb3b0 */
0xb0a1, 0xb0a2, 0xb0a8, 0xb0a9, 0xb0ab, 0xb0ac, 0xb0ad, 0xb0ae, 0xb0af, 0xb0b1, 0xb0b3, 0xb0b4, 0xb0b5, 0xb0b8, 0xb0bc, 0xb0c4, 
/* 0xb3c0 */
0xb0c5, 0xb0c7, 0xb0c8, 0xb0c9, 0xb0d0, 0xb0d1, 0xb0d4, 0xb0d8, 0xb0e0, 0xb0e5, 0xb108, 0xb109, 0xb10b, 0xb10c, 0xb110, 0xb112, 
/* 0xb3d0 */
0xb113, 0xb118, 0xb119, 0xb11b, 0xb11c, 0xb11d, 0xb123, 0xb124, 0xb125, 0xb128, 0xb12c, 0xb134, 0xb135, 0xb137, 0xb138, 0xb139, 
/* 0xb3e0 */
0xb140, 0xb141, 0xb144, 0xb148, 0xb150, 0xb151, 0xb154, 0xb155, 0xb158, 0xb15c, 0xb160, 0xb178, 0xb179, 0xb17c, 0xb180, 0xb182, 
/* 0xb3f0 */
0xb188, 0xb189, 0xb18b, 0xb18d, 0xb192, 0xb193, 0xb194, 0xb198, 0xb19c, 0xb1a8, 0xb1cc, 0xb1d0, 0xb1d4, 0xb1dc, 0xb1dd, 
};
static struct cp2unicode_row korean_row_b3 = { 0xb3, 0x41, 0xbe, korean_row_codes_b3 };
static unicode_t korean_row_codes_b4[] =
{
/* 0xb441 */
0xd02e, 0xd02f, 0xd030, 0xd031, 0xd032, 0xd033, 0xd036, 0xd037, 0xd039, 0xd03a, 0xd03b, 0xd03d, 0xd03e, 0xd03f, 0xd040, 
/* 0xb450 */
0xd041, 0xd042, 0xd043, 0xd046, 0xd048, 0xd04a, 0xd04b, 0xd04c, 0xd04d, 0xd04e, 0xd04f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb460 */
0x0000, 0xd051, 0xd052, 0xd053, 0xd055, 0xd056, 0xd057, 0xd059, 0xd05a, 0xd05b, 0xd05c, 0xd05d, 0xd05e, 0xd05f, 0xd061, 0xd062, 
/* 0xb470 */
0xd063, 0xd064, 0xd065, 0xd066, 0xd067, 0xd068, 0xd069, 0xd06a, 0xd06b, 0xd06e, 0xd06f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb480 */
0x0000, 0xd071, 0xd072, 0xd073, 0xd075, 0xd076, 0xd077, 0xd078, 0xd079, 0xd07a, 0xd07b, 0xd07e, 0xd07f, 0xd080, 0xd082, 0xd083, 
/* 0xb490 */
0xd084, 0xd085, 0xd086, 0xd087, 0xd088, 0xd089, 0xd08a, 0xd08b, 0xd08c, 0xd08d, 0xd08e, 0xd08f, 0xd090, 0xd091, 0xd092, 0xd093, 
/* 0xb4a0 */
0xd094, 0xb1df, 0xb1e8, 0xb1e9, 0xb1ec, 0xb1f0, 0xb1f9, 0xb1fb, 0xb1fd, 0xb204, 0xb205, 0xb208, 0xb20b, 0xb20c, 0xb214, 0xb215, 
/* 0xb4b0 */
0xb217, 0xb219, 0xb220, 0xb234, 0xb23c, 0xb258, 0xb25c, 0xb260, 0xb268, 0xb269, 0xb274, 0xb275, 0xb27c, 0xb284, 0xb285, 0xb289, 
/* 0xb4c0 */
0xb290, 0xb291, 0xb294, 0xb298, 0xb299, 0xb29a, 0xb2a0, 0xb2a1, 0xb2a3, 0xb2a5, 0xb2a6, 0xb2aa, 0xb2ac, 0xb2b0, 0xb2b4, 0xb2c8, 
/* 0xb4d0 */
0xb2c9, 0xb2cc, 0xb2d0, 0xb2d2, 0xb2d8, 0xb2d9, 0xb2db, 0xb2dd, 0xb2e2, 0xb2e4, 0xb2e5, 0xb2e6, 0xb2e8, 0xb2eb, 0xb2ec, 0xb2ed, 
/* 0xb4e0 */
0xb2ee, 0xb2ef, 0xb2f3, 0xb2f4, 0xb2f5, 0xb2f7, 0xb2f8, 0xb2f9, 0xb2fa, 0xb2fb, 0xb2ff, 0xb300, 0xb301, 0xb304, 0xb308, 0xb310, 
/* 0xb4f0 */
0xb311, 0xb313, 0xb314, 0xb315, 0xb31c, 0xb354, 0xb355, 0xb356, 0xb358, 0xb35b, 0xb35c, 0xb35e, 0xb35f, 0xb364, 0xb365, 
};
static struct cp2unicode_row korean_row_b4 = { 0xb4, 0x41, 0xbe, korean_row_codes_b4 };
static unicode_t korean_row_codes_b5[] =
{
/* 0xb541 */
0xd095, 0xd096, 0xd097, 0xd098, 0xd099, 0xd09a, 0xd09b, 0xd09c, 0xd09d, 0xd09e, 0xd09f, 0xd0a0, 0xd0a1, 0xd0a2, 0xd0a3, 
/* 0xb550 */
0xd0a6, 0xd0a7, 0xd0a9, 0xd0aa, 0xd0ab, 0xd0ad, 0xd0ae, 0xd0af, 0xd0b0, 0xd0b1, 0xd0b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb560 */
0x0000, 0xd0b3, 0xd0b6, 0xd0b8, 0xd0ba, 0xd0bb, 0xd0bc, 0xd0bd, 0xd0be, 0xd0bf, 0xd0c2, 0xd0c3, 0xd0c5, 0xd0c6, 0xd0c7, 0xd0ca, 
/* 0xb570 */
0xd0cb, 0xd0cc, 0xd0cd, 0xd0ce, 0xd0cf, 0xd0d2, 0xd0d6, 0xd0d7, 0xd0d8, 0xd0d9, 0xd0da, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb580 */
0x0000, 0xd0db, 0xd0de, 0xd0df, 0xd0e1, 0xd0e2, 0xd0e3, 0xd0e5, 0xd0e6, 0xd0e7, 0xd0e8, 0xd0e9, 0xd0ea, 0xd0eb, 0xd0ee, 0xd0f2, 
/* 0xb590 */
0xd0f3, 0xd0f4, 0xd0f5, 0xd0f6, 0xd0f7, 0xd0f9, 0xd0fa, 0xd0fb, 0xd0fc, 0xd0fd, 0xd0fe, 0xd0ff, 0xd100, 0xd101, 0xd102, 0xd103, 
/* 0xb5a0 */
0xd104, 0xb367, 0xb369, 0xb36b, 0xb36e, 0xb370, 0xb371, 0xb374, 0xb378, 0xb380, 0xb381, 0xb383, 0xb384, 0xb385, 0xb38c, 0xb390, 
/* 0xb5b0 */
0xb394, 0xb3a0, 0xb3a1, 0xb3a8, 0xb3ac, 0xb3c4, 0xb3c5, 0xb3c8, 0xb3cb, 0xb3cc, 0xb3ce, 0xb3d0, 0xb3d4, 0xb3d5, 0xb3d7, 0xb3d9, 
/* 0xb5c0 */
0xb3db, 0xb3dd, 0xb3e0, 0xb3e4, 0xb3e8, 0xb3fc, 0xb410, 0xb418, 0xb41c, 0xb420, 0xb428, 0xb429, 0xb42b, 0xb434, 0xb450, 0xb451, 
/* 0xb5d0 */
0xb454, 0xb458, 0xb460, 0xb461, 0xb463, 0xb465, 0xb46c, 0xb480, 0xb488, 0xb49d, 0xb4a4, 0xb4a8, 0xb4ac, 0xb4b5, 0xb4b7, 0xb4b9, 
/* 0xb5e0 */
0xb4c0, 0xb4c4, 0xb4c8, 0xb4d0, 0xb4d5, 0xb4dc, 0xb4dd, 0xb4e0, 0xb4e3, 0xb4e4, 0xb4e6, 0xb4ec, 0xb4ed, 0xb4ef, 0xb4f1, 0xb4f8, 
/* 0xb5f0 */
0xb514, 0xb515, 0xb518, 0xb51b, 0xb51c, 0xb524, 0xb525, 0xb527, 0xb528, 0xb529, 0xb52a, 0xb530, 0xb531, 0xb534, 0xb538, 
};
static struct cp2unicode_row korean_row_b5 = { 0xb5, 0x41, 0xbe, korean_row_codes_b5 };
static unicode_t korean_row_codes_b6[] =
{
/* 0xb641 */
0xd105, 0xd106, 0xd107, 0xd108, 0xd109, 0xd10a, 0xd10b, 0xd10c, 0xd10e, 0xd10f, 0xd110, 0xd111, 0xd112, 0xd113, 0xd114, 
/* 0xb650 */
0xd115, 0xd116, 0xd117, 0xd118, 0xd119, 0xd11a, 0xd11b, 0xd11c, 0xd11d, 0xd11e, 0xd11f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb660 */
0x0000, 0xd120, 0xd121, 0xd122, 0xd123, 0xd124, 0xd125, 0xd126, 0xd127, 0xd128, 0xd129, 0xd12a, 0xd12b, 0xd12c, 0xd12d, 0xd12e, 
/* 0xb670 */
0xd12f, 0xd132, 0xd133, 0xd135, 0xd136, 0xd137, 0xd139, 0xd13b, 0xd13c, 0xd13d, 0xd13e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb680 */
0x0000, 0xd13f, 0xd142, 0xd146, 0xd147, 0xd148, 0xd149, 0xd14a, 0xd14b, 0xd14e, 0xd14f, 0xd151, 0xd152, 0xd153, 0xd155, 0xd156, 
/* 0xb690 */
0xd157, 0xd158, 0xd159, 0xd15a, 0xd15b, 0xd15e, 0xd160, 0xd162, 0xd163, 0xd164, 0xd165, 0xd166, 0xd167, 0xd169, 0xd16a, 0xd16b, 
/* 0xb6a0 */
0xd16d, 0xb540, 0xb541, 0xb543, 0xb544, 0xb545, 0xb54b, 0xb54c, 0xb54d, 0xb550, 0xb554, 0xb55c, 0xb55d, 0xb55f, 0xb560, 0xb561, 
/* 0xb6b0 */
0xb5a0, 0xb5a1, 0xb5a4, 0xb5a8, 0xb5aa, 0xb5ab, 0xb5b0, 0xb5b1, 0xb5b3, 0xb5b4, 0xb5b5, 0xb5bb, 0xb5bc, 0xb5bd, 0xb5c0, 0xb5c4, 
/* 0xb6c0 */
0xb5cc, 0xb5cd, 0xb5cf, 0xb5d0, 0xb5d1, 0xb5d8, 0xb5ec, 0xb610, 0xb611, 0xb614, 0xb618, 0xb625, 0xb62c, 0xb634, 0xb648, 0xb664, 
/* 0xb6d0 */
0xb668, 0xb69c, 0xb69d, 0xb6a0, 0xb6a4, 0xb6ab, 0xb6ac, 0xb6b1, 0xb6d4, 0xb6f0, 0xb6f4, 0xb6f8, 0xb700, 0xb701, 0xb705, 0xb728, 
/* 0xb6e0 */
0xb729, 0xb72c, 0xb72f, 0xb730, 0xb738, 0xb739, 0xb73b, 0xb744, 0xb748, 0xb74c, 0xb754, 0xb755, 0xb760, 0xb764, 0xb768, 0xb770, 
/* 0xb6f0 */
0xb771, 0xb773, 0xb775, 0xb77c, 0xb77d, 0xb780, 0xb784, 0xb78c, 0xb78d, 0xb78f, 0xb790, 0xb791, 0xb792, 0xb796, 0xb797, 
};
static struct cp2unicode_row korean_row_b6 = { 0xb6, 0x41, 0xbe, korean_row_codes_b6 };
static unicode_t korean_row_codes_b7[] =
{
/* 0xb741 */
0xd16e, 0xd16f, 0xd170, 0xd171, 0xd172, 0xd173, 0xd174, 0xd175, 0xd176, 0xd177, 0xd178, 0xd179, 0xd17a, 0xd17b, 0xd17d, 
/* 0xb750 */
0xd17e, 0xd17f, 0xd180, 0xd181, 0xd182, 0xd183, 0xd185, 0xd186, 0xd187, 0xd189, 0xd18a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb760 */
0x0000, 0xd18b, 0xd18c, 0xd18d, 0xd18e, 0xd18f, 0xd190, 0xd191, 0xd192, 0xd193, 0xd194, 0xd195, 0xd196, 0xd197, 0xd198, 0xd199, 
/* 0xb770 */
0xd19a, 0xd19b, 0xd19c, 0xd19d, 0xd19e, 0xd19f, 0xd1a2, 0xd1a3, 0xd1a5, 0xd1a6, 0xd1a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb780 */
0x0000, 0xd1a9, 0xd1aa, 0xd1ab, 0xd1ac, 0xd1ad, 0xd1ae, 0xd1af, 0xd1b2, 0xd1b4, 0xd1b6, 0xd1b7, 0xd1b8, 0xd1b9, 0xd1bb, 0xd1bd, 
/* 0xb790 */
0xd1be, 0xd1bf, 0xd1c1, 0xd1c2, 0xd1c3, 0xd1c4, 0xd1c5, 0xd1c6, 0xd1c7, 0xd1c8, 0xd1c9, 0xd1ca, 0xd1cb, 0xd1cc, 0xd1cd, 0xd1ce, 
/* 0xb7a0 */
0xd1cf, 0xb798, 0xb799, 0xb79c, 0xb7a0, 0xb7a8, 0xb7a9, 0xb7ab, 0xb7ac, 0xb7ad, 0xb7b4, 0xb7b5, 0xb7b8, 0xb7c7, 0xb7c9, 0xb7ec, 
/* 0xb7b0 */
0xb7ed, 0xb7f0, 0xb7f4, 0xb7fc, 0xb7fd, 0xb7ff, 0xb800, 0xb801, 0xb807, 0xb808, 0xb809, 0xb80c, 0xb810, 0xb818, 0xb819, 0xb81b, 
/* 0xb7c0 */
0xb81d, 0xb824, 0xb825, 0xb828, 0xb82c, 0xb834, 0xb835, 0xb837, 0xb838, 0xb839, 0xb840, 0xb844, 0xb851, 0xb853, 0xb85c, 0xb85d, 
/* 0xb7d0 */
0xb860, 0xb864, 0xb86c, 0xb86d, 0xb86f, 0xb871, 0xb878, 0xb87c, 0xb88d, 0xb8a8, 0xb8b0, 0xb8b4, 0xb8b8, 0xb8c0, 0xb8c1, 0xb8c3, 
/* 0xb7e0 */
0xb8c5, 0xb8cc, 0xb8d0, 0xb8d4, 0xb8dd, 0xb8df, 0xb8e1, 0xb8e8, 0xb8e9, 0xb8ec, 0xb8f0, 0xb8f8, 0xb8f9, 0xb8fb, 0xb8fd, 0xb904, 
/* 0xb7f0 */
0xb918, 0xb920, 0xb93c, 0xb93d, 0xb940, 0xb944, 0xb94c, 0xb94f, 0xb951, 0xb958, 0xb959, 0xb95c, 0xb960, 0xb968, 0xb969, 
};
static struct cp2unicode_row korean_row_b7 = { 0xb7, 0x41, 0xbe, korean_row_codes_b7 };
static unicode_t korean_row_codes_b8[] =
{
/* 0xb841 */
0xd1d0, 0xd1d1, 0xd1d2, 0xd1d3, 0xd1d4, 0xd1d5, 0xd1d6, 0xd1d7, 0xd1d9, 0xd1da, 0xd1db, 0xd1dc, 0xd1dd, 0xd1de, 0xd1df, 
/* 0xb850 */
0xd1e0, 0xd1e1, 0xd1e2, 0xd1e3, 0xd1e4, 0xd1e5, 0xd1e6, 0xd1e7, 0xd1e8, 0xd1e9, 0xd1ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb860 */
0x0000, 0xd1eb, 0xd1ec, 0xd1ed, 0xd1ee, 0xd1ef, 0xd1f0, 0xd1f1, 0xd1f2, 0xd1f3, 0xd1f5, 0xd1f6, 0xd1f7, 0xd1f9, 0xd1fa, 0xd1fb, 
/* 0xb870 */
0xd1fc, 0xd1fd, 0xd1fe, 0xd1ff, 0xd200, 0xd201, 0xd202, 0xd203, 0xd204, 0xd205, 0xd206, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb880 */
0x0000, 0xd208, 0xd20a, 0xd20b, 0xd20c, 0xd20d, 0xd20e, 0xd20f, 0xd211, 0xd212, 0xd213, 0xd214, 0xd215, 0xd216, 0xd217, 0xd218, 
/* 0xb890 */
0xd219, 0xd21a, 0xd21b, 0xd21c, 0xd21d, 0xd21e, 0xd21f, 0xd220, 0xd221, 0xd222, 0xd223, 0xd224, 0xd225, 0xd226, 0xd227, 0xd228, 
/* 0xb8a0 */
0xd229, 0xb96b, 0xb96d, 0xb974, 0xb975, 0xb978, 0xb97c, 0xb984, 0xb985, 0xb987, 0xb989, 0xb98a, 0xb98d, 0xb98e, 0xb9ac, 0xb9ad, 
/* 0xb8b0 */
0xb9b0, 0xb9b4, 0xb9bc, 0xb9bd, 0xb9bf, 0xb9c1, 0xb9c8, 0xb9c9, 0xb9cc, 0xb9ce, 0xb9cf, 0xb9d0, 0xb9d1, 0xb9d2, 0xb9d8, 0xb9d9, 
/* 0xb8c0 */
0xb9db, 0xb9dd, 0xb9de, 0xb9e1, 0xb9e3, 0xb9e4, 0xb9e5, 0xb9e8, 0xb9ec, 0xb9f4, 0xb9f5, 0xb9f7, 0xb9f8, 0xb9f9, 0xb9fa, 0xba00, 
/* 0xb8d0 */
0xba01, 0xba08, 0xba15, 0xba38, 0xba39, 0xba3c, 0xba40, 0xba42, 0xba48, 0xba49, 0xba4b, 0xba4d, 0xba4e, 0xba53, 0xba54, 0xba55, 
/* 0xb8e0 */
0xba58, 0xba5c, 0xba64, 0xba65, 0xba67, 0xba68, 0xba69, 0xba70, 0xba71, 0xba74, 0xba78, 0xba83, 0xba84, 0xba85, 0xba87, 0xba8c, 
/* 0xb8f0 */
0xbaa8, 0xbaa9, 0xbaab, 0xbaac, 0xbab0, 0xbab2, 0xbab8, 0xbab9, 0xbabb, 0xbabd, 0xbac4, 0xbac8, 0xbad8, 0xbad9, 0xbafc, 
};
static struct cp2unicode_row korean_row_b8 = { 0xb8, 0x41, 0xbe, korean_row_codes_b8 };
static unicode_t korean_row_codes_b9[] =
{
/* 0xb941 */
0xd22a, 0xd22b, 0xd22e, 0xd22f, 0xd231, 0xd232, 0xd233, 0xd235, 0xd236, 0xd237, 0xd238, 0xd239, 0xd23a, 0xd23b, 0xd23e, 
/* 0xb950 */
0xd240, 0xd242, 0xd243, 0xd244, 0xd245, 0xd246, 0xd247, 0xd249, 0xd24a, 0xd24b, 0xd24c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb960 */
0x0000, 0xd24d, 0xd24e, 0xd24f, 0xd250, 0xd251, 0xd252, 0xd253, 0xd254, 0xd255, 0xd256, 0xd257, 0xd258, 0xd259, 0xd25a, 0xd25b, 
/* 0xb970 */
0xd25d, 0xd25e, 0xd25f, 0xd260, 0xd261, 0xd262, 0xd263, 0xd265, 0xd266, 0xd267, 0xd268, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xb980 */
0x0000, 0xd269, 0xd26a, 0xd26b, 0xd26c, 0xd26d, 0xd26e, 0xd26f, 0xd270, 0xd271, 0xd272, 0xd273, 0xd274, 0xd275, 0xd276, 0xd277, 
/* 0xb990 */
0xd278, 0xd279, 0xd27a, 0xd27b, 0xd27c, 0xd27d, 0xd27e, 0xd27f, 0xd282, 0xd283, 0xd285, 0xd286, 0xd287, 0xd289, 0xd28a, 0xd28b, 
/* 0xb9a0 */
0xd28c, 0xbb00, 0xbb04, 0xbb0d, 0xbb0f, 0xbb11, 0xbb18, 0xbb1c, 0xbb20, 0xbb29, 0xbb2b, 0xbb34, 0xbb35, 0xbb36, 0xbb38, 0xbb3b, 
/* 0xb9b0 */
0xbb3c, 0xbb3d, 0xbb3e, 0xbb44, 0xbb45, 0xbb47, 0xbb49, 0xbb4d, 0xbb4f, 0xbb50, 0xbb54, 0xbb58, 0xbb61, 0xbb63, 0xbb6c, 0xbb88, 
/* 0xb9c0 */
0xbb8c, 0xbb90, 0xbba4, 0xbba8, 0xbbac, 0xbbb4, 0xbbb7, 0xbbc0, 0xbbc4, 0xbbc8, 0xbbd0, 0xbbd3, 0xbbf8, 0xbbf9, 0xbbfc, 0xbbff, 
/* 0xb9d0 */
0xbc00, 0xbc02, 0xbc08, 0xbc09, 0xbc0b, 0xbc0c, 0xbc0d, 0xbc0f, 0xbc11, 0xbc14, 0xbc15, 0xbc16, 0xbc17, 0xbc18, 0xbc1b, 0xbc1c, 
/* 0xb9e0 */
0xbc1d, 0xbc1e, 0xbc1f, 0xbc24, 0xbc25, 0xbc27, 0xbc29, 0xbc2d, 0xbc30, 0xbc31, 0xbc34, 0xbc38, 0xbc40, 0xbc41, 0xbc43, 0xbc44, 
/* 0xb9f0 */
0xbc45, 0xbc49, 0xbc4c, 0xbc4d, 0xbc50, 0xbc5d, 0xbc84, 0xbc85, 0xbc88, 0xbc8b, 0xbc8c, 0xbc8e, 0xbc94, 0xbc95, 0xbc97, 
};
static struct cp2unicode_row korean_row_b9 = { 0xb9, 0x41, 0xbe, korean_row_codes_b9 };
static unicode_t korean_row_codes_ba[] =
{
/* 0xba41 */
0xd28d, 0xd28e, 0xd28f, 0xd292, 0xd293, 0xd294, 0xd296, 0xd297, 0xd298, 0xd299, 0xd29a, 0xd29b, 0xd29d, 0xd29e, 0xd29f, 
/* 0xba50 */
0xd2a1, 0xd2a2, 0xd2a3, 0xd2a5, 0xd2a6, 0xd2a7, 0xd2a8, 0xd2a9, 0xd2aa, 0xd2ab, 0xd2ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xba60 */
0x0000, 0xd2ae, 0xd2af, 0xd2b0, 0xd2b2, 0xd2b3, 0xd2b4, 0xd2b5, 0xd2b6, 0xd2b7, 0xd2ba, 0xd2bb, 0xd2bd, 0xd2be, 0xd2c1, 0xd2c3, 
/* 0xba70 */
0xd2c4, 0xd2c5, 0xd2c6, 0xd2c7, 0xd2ca, 0xd2cc, 0xd2cd, 0xd2ce, 0xd2cf, 0xd2d0, 0xd2d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xba80 */
0x0000, 0xd2d2, 0xd2d3, 0xd2d5, 0xd2d6, 0xd2d7, 0xd2d9, 0xd2da, 0xd2db, 0xd2dd, 0xd2de, 0xd2df, 0xd2e0, 0xd2e1, 0xd2e2, 0xd2e3, 
/* 0xba90 */
0xd2e6, 0xd2e7, 0xd2e8, 0xd2e9, 0xd2ea, 0xd2eb, 0xd2ec, 0xd2ed, 0xd2ee, 0xd2ef, 0xd2f2, 0xd2f3, 0xd2f5, 0xd2f6, 0xd2f7, 0xd2f9, 
/* 0xbaa0 */
0xd2fa, 0xbc99, 0xbc9a, 0xbca0, 0xbca1, 0xbca4, 0xbca7, 0xbca8, 0xbcb0, 0xbcb1, 0xbcb3, 0xbcb4, 0xbcb5, 0xbcbc, 0xbcbd, 0xbcc0, 
/* 0xbab0 */
0xbcc4, 0xbccd, 0xbccf, 0xbcd0, 0xbcd1, 0xbcd5, 0xbcd8, 0xbcdc, 0xbcf4, 0xbcf5, 0xbcf6, 0xbcf8, 0xbcfc, 0xbd04, 0xbd05, 0xbd07, 
/* 0xbac0 */
0xbd09, 0xbd10, 0xbd14, 0xbd24, 0xbd2c, 0xbd40, 0xbd48, 0xbd49, 0xbd4c, 0xbd50, 0xbd58, 0xbd59, 0xbd64, 0xbd68, 0xbd80, 0xbd81, 
/* 0xbad0 */
0xbd84, 0xbd87, 0xbd88, 0xbd89, 0xbd8a, 0xbd90, 0xbd91, 0xbd93, 0xbd95, 0xbd99, 0xbd9a, 0xbd9c, 0xbda4, 0xbdb0, 0xbdb8, 0xbdd4, 
/* 0xbae0 */
0xbdd5, 0xbdd8, 0xbddc, 0xbde9, 0xbdf0, 0xbdf4, 0xbdf8, 0xbe00, 0xbe03, 0xbe05, 0xbe0c, 0xbe0d, 0xbe10, 0xbe14, 0xbe1c, 0xbe1d, 
/* 0xbaf0 */
0xbe1f, 0xbe44, 0xbe45, 0xbe48, 0xbe4c, 0xbe4e, 0xbe54, 0xbe55, 0xbe57, 0xbe59, 0xbe5a, 0xbe5b, 0xbe60, 0xbe61, 0xbe64, 
};
static struct cp2unicode_row korean_row_ba = { 0xba, 0x41, 0xbe, korean_row_codes_ba };
static unicode_t korean_row_codes_bb[] =
{
/* 0xbb41 */
0xd2fb, 0xd2fc, 0xd2fd, 0xd2fe, 0xd2ff, 0xd302, 0xd304, 0xd306, 0xd307, 0xd308, 0xd309, 0xd30a, 0xd30b, 0xd30f, 0xd311, 
/* 0xbb50 */
0xd312, 0xd313, 0xd315, 0xd317, 0xd318, 0xd319, 0xd31a, 0xd31b, 0xd31e, 0xd322, 0xd323, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbb60 */
0x0000, 0xd324, 0xd326, 0xd327, 0xd32a, 0xd32b, 0xd32d, 0xd32e, 0xd32f, 0xd331, 0xd332, 0xd333, 0xd334, 0xd335, 0xd336, 0xd337, 
/* 0xbb70 */
0xd33a, 0xd33e, 0xd33f, 0xd340, 0xd341, 0xd342, 0xd343, 0xd346, 0xd347, 0xd348, 0xd349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbb80 */
0x0000, 0xd34a, 0xd34b, 0xd34c, 0xd34d, 0xd34e, 0xd34f, 0xd350, 0xd351, 0xd352, 0xd353, 0xd354, 0xd355, 0xd356, 0xd357, 0xd358, 
/* 0xbb90 */
0xd359, 0xd35a, 0xd35b, 0xd35c, 0xd35d, 0xd35e, 0xd35f, 0xd360, 0xd361, 0xd362, 0xd363, 0xd364, 0xd365, 0xd366, 0xd367, 0xd368, 
/* 0xbba0 */
0xd369, 0xbe68, 0xbe6a, 0xbe70, 0xbe71, 0xbe73, 0xbe74, 0xbe75, 0xbe7b, 0xbe7c, 0xbe7d, 0xbe80, 0xbe84, 0xbe8c, 0xbe8d, 0xbe8f, 
/* 0xbbb0 */
0xbe90, 0xbe91, 0xbe98, 0xbe99, 0xbea8, 0xbed0, 0xbed1, 0xbed4, 0xbed7, 0xbed8, 0xbee0, 0xbee3, 0xbee4, 0xbee5, 0xbeec, 0xbf01, 
/* 0xbbc0 */
0xbf08, 0xbf09, 0xbf18, 0xbf19, 0xbf1b, 0xbf1c, 0xbf1d, 0xbf40, 0xbf41, 0xbf44, 0xbf48, 0xbf50, 0xbf51, 0xbf55, 0xbf94, 0xbfb0, 
/* 0xbbd0 */
0xbfc5, 0xbfcc, 0xbfcd, 0xbfd0, 0xbfd4, 0xbfdc, 0xbfdf, 0xbfe1, 0xc03c, 0xc051, 0xc058, 0xc05c, 0xc060, 0xc068, 0xc069, 0xc090, 
/* 0xbbe0 */
0xc091, 0xc094, 0xc098, 0xc0a0, 0xc0a1, 0xc0a3, 0xc0a5, 0xc0ac, 0xc0ad, 0xc0af, 0xc0b0, 0xc0b3, 0xc0b4, 0xc0b5, 0xc0b6, 0xc0bc, 
/* 0xbbf0 */
0xc0bd, 0xc0bf, 0xc0c0, 0xc0c1, 0xc0c5, 0xc0c8, 0xc0c9, 0xc0cc, 0xc0d0, 0xc0d8, 0xc0d9, 0xc0db, 0xc0dc, 0xc0dd, 0xc0e4, 
};
static struct cp2unicode_row korean_row_bb = { 0xbb, 0x41, 0xbe, korean_row_codes_bb };
static unicode_t korean_row_codes_bc[] =
{
/* 0xbc41 */
0xd36a, 0xd36b, 0xd36c, 0xd36d, 0xd36e, 0xd36f, 0xd370, 0xd371, 0xd372, 0xd373, 0xd374, 0xd375, 0xd376, 0xd377, 0xd378, 
/* 0xbc50 */
0xd379, 0xd37a, 0xd37b, 0xd37e, 0xd37f, 0xd381, 0xd382, 0xd383, 0xd385, 0xd386, 0xd387, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbc60 */
0x0000, 0xd388, 0xd389, 0xd38a, 0xd38b, 0xd38e, 0xd392, 0xd393, 0xd394, 0xd395, 0xd396, 0xd397, 0xd39a, 0xd39b, 0xd39d, 0xd39e, 
/* 0xbc70 */
0xd39f, 0xd3a1, 0xd3a2, 0xd3a3, 0xd3a4, 0xd3a5, 0xd3a6, 0xd3a7, 0xd3aa, 0xd3ac, 0xd3ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbc80 */
0x0000, 0xd3af, 0xd3b0, 0xd3b1, 0xd3b2, 0xd3b3, 0xd3b5, 0xd3b6, 0xd3b7, 0xd3b9, 0xd3ba, 0xd3bb, 0xd3bd, 0xd3be, 0xd3bf, 0xd3c0, 
/* 0xbc90 */
0xd3c1, 0xd3c2, 0xd3c3, 0xd3c6, 0xd3c7, 0xd3ca, 0xd3cb, 0xd3cc, 0xd3cd, 0xd3ce, 0xd3cf, 0xd3d1, 0xd3d2, 0xd3d3, 0xd3d4, 0xd3d5, 
/* 0xbca0 */
0xd3d6, 0xc0e5, 0xc0e8, 0xc0ec, 0xc0f4, 0xc0f5, 0xc0f7, 0xc0f9, 0xc100, 0xc104, 0xc108, 0xc110, 0xc115, 0xc11c, 0xc11d, 0xc11e, 
/* 0xbcb0 */
0xc11f, 0xc120, 0xc123, 0xc124, 0xc126, 0xc127, 0xc12c, 0xc12d, 0xc12f, 0xc130, 0xc131, 0xc136, 0xc138, 0xc139, 0xc13c, 0xc140, 
/* 0xbcc0 */
0xc148, 0xc149, 0xc14b, 0xc14c, 0xc14d, 0xc154, 0xc155, 0xc158, 0xc15c, 0xc164, 0xc165, 0xc167, 0xc168, 0xc169, 0xc170, 0xc174, 
/* 0xbcd0 */
0xc178, 0xc185, 0xc18c, 0xc18d, 0xc18e, 0xc190, 0xc194, 0xc196, 0xc19c, 0xc19d, 0xc19f, 0xc1a1, 0xc1a5, 0xc1a8, 0xc1a9, 0xc1ac, 
/* 0xbce0 */
0xc1b0, 0xc1bd, 0xc1c4, 0xc1c8, 0xc1cc, 0xc1d4, 0xc1d7, 0xc1d8, 0xc1e0, 0xc1e4, 0xc1e8, 0xc1f0, 0xc1f1, 0xc1f3, 0xc1fc, 0xc1fd, 
/* 0xbcf0 */
0xc200, 0xc204, 0xc20c, 0xc20d, 0xc20f, 0xc211, 0xc218, 0xc219, 0xc21c, 0xc21f, 0xc220, 0xc228, 0xc229, 0xc22b, 0xc22d, 
};
static struct cp2unicode_row korean_row_bc = { 0xbc, 0x41, 0xbe, korean_row_codes_bc };
static unicode_t korean_row_codes_bd[] =
{
/* 0xbd41 */
0xd3d7, 0xd3d9, 0xd3da, 0xd3db, 0xd3dc, 0xd3dd, 0xd3de, 0xd3df, 0xd3e0, 0xd3e2, 0xd3e4, 0xd3e5, 0xd3e6, 0xd3e7, 0xd3e8, 
/* 0xbd50 */
0xd3e9, 0xd3ea, 0xd3eb, 0xd3ee, 0xd3ef, 0xd3f1, 0xd3f2, 0xd3f3, 0xd3f5, 0xd3f6, 0xd3f7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbd60 */
0x0000, 0xd3f8, 0xd3f9, 0xd3fa, 0xd3fb, 0xd3fe, 0xd400, 0xd402, 0xd403, 0xd404, 0xd405, 0xd406, 0xd407, 0xd409, 0xd40a, 0xd40b, 
/* 0xbd70 */
0xd40c, 0xd40d, 0xd40e, 0xd40f, 0xd410, 0xd411, 0xd412, 0xd413, 0xd414, 0xd415, 0xd416, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbd80 */
0x0000, 0xd417, 0xd418, 0xd419, 0xd41a, 0xd41b, 0xd41c, 0xd41e, 0xd41f, 0xd420, 0xd421, 0xd422, 0xd423, 0xd424, 0xd425, 0xd426, 
/* 0xbd90 */
0xd427, 0xd428, 0xd429, 0xd42a, 0xd42b, 0xd42c, 0xd42d, 0xd42e, 0xd42f, 0xd430, 0xd431, 0xd432, 0xd433, 0xd434, 0xd435, 0xd436, 
/* 0xbda0 */
0xd437, 0xc22f, 0xc231, 0xc232, 0xc234, 0xc248, 0xc250, 0xc251, 0xc254, 0xc258, 0xc260, 0xc265, 0xc26c, 0xc26d, 0xc270, 0xc274, 
/* 0xbdb0 */
0xc27c, 0xc27d, 0xc27f, 0xc281, 0xc288, 0xc289, 0xc290, 0xc298, 0xc29b, 0xc29d, 0xc2a4, 0xc2a5, 0xc2a8, 0xc2ac, 0xc2ad, 0xc2b4, 
/* 0xbdc0 */
0xc2b5, 0xc2b7, 0xc2b9, 0xc2dc, 0xc2dd, 0xc2e0, 0xc2e3, 0xc2e4, 0xc2eb, 0xc2ec, 0xc2ed, 0xc2ef, 0xc2f1, 0xc2f6, 0xc2f8, 0xc2f9, 
/* 0xbdd0 */
0xc2fb, 0xc2fc, 0xc300, 0xc308, 0xc309, 0xc30c, 0xc30d, 0xc313, 0xc314, 0xc315, 0xc318, 0xc31c, 0xc324, 0xc325, 0xc328, 0xc329, 
/* 0xbde0 */
0xc345, 0xc368, 0xc369, 0xc36c, 0xc370, 0xc372, 0xc378, 0xc379, 0xc37c, 0xc37d, 0xc384, 0xc388, 0xc38c, 0xc3c0, 0xc3d8, 0xc3d9, 
/* 0xbdf0 */
0xc3dc, 0xc3df, 0xc3e0, 0xc3e2, 0xc3e8, 0xc3e9, 0xc3ed, 0xc3f4, 0xc3f5, 0xc3f8, 0xc408, 0xc410, 0xc424, 0xc42c, 0xc430, 
};
static struct cp2unicode_row korean_row_bd = { 0xbd, 0x41, 0xbe, korean_row_codes_bd };
static unicode_t korean_row_codes_be[] =
{
/* 0xbe41 */
0xd438, 0xd439, 0xd43a, 0xd43b, 0xd43c, 0xd43d, 0xd43e, 0xd43f, 0xd441, 0xd442, 0xd443, 0xd445, 0xd446, 0xd447, 0xd448, 
/* 0xbe50 */
0xd449, 0xd44a, 0xd44b, 0xd44c, 0xd44d, 0xd44e, 0xd44f, 0xd450, 0xd451, 0xd452, 0xd453, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbe60 */
0x0000, 0xd454, 0xd455, 0xd456, 0xd457, 0xd458, 0xd459, 0xd45a, 0xd45b, 0xd45d, 0xd45e, 0xd45f, 0xd461, 0xd462, 0xd463, 0xd465, 
/* 0xbe70 */
0xd466, 0xd467, 0xd468, 0xd469, 0xd46a, 0xd46b, 0xd46c, 0xd46e, 0xd470, 0xd471, 0xd472, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbe80 */
0x0000, 0xd473, 0xd474, 0xd475, 0xd476, 0xd477, 0xd47a, 0xd47b, 0xd47d, 0xd47e, 0xd481, 0xd483, 0xd484, 0xd485, 0xd486, 0xd487, 
/* 0xbe90 */
0xd48a, 0xd48c, 0xd48e, 0xd48f, 0xd490, 0xd491, 0xd492, 0xd493, 0xd495, 0xd496, 0xd497, 0xd498, 0xd499, 0xd49a, 0xd49b, 0xd49c, 
/* 0xbea0 */
0xd49d, 0xc434, 0xc43c, 0xc43d, 0xc448, 0xc464, 0xc465, 0xc468, 0xc46c, 0xc474, 0xc475, 0xc479, 0xc480, 0xc494, 0xc49c, 0xc4b8, 
/* 0xbeb0 */
0xc4bc, 0xc4e9, 0xc4f0, 0xc4f1, 0xc4f4, 0xc4f8, 0xc4fa, 0xc4ff, 0xc500, 0xc501, 0xc50c, 0xc510, 0xc514, 0xc51c, 0xc528, 0xc529, 
/* 0xbec0 */
0xc52c, 0xc530, 0xc538, 0xc539, 0xc53b, 0xc53d, 0xc544, 0xc545, 0xc548, 0xc549, 0xc54a, 0xc54c, 0xc54d, 0xc54e, 0xc553, 0xc554, 
/* 0xbed0 */
0xc555, 0xc557, 0xc558, 0xc559, 0xc55d, 0xc55e, 0xc560, 0xc561, 0xc564, 0xc568, 0xc570, 0xc571, 0xc573, 0xc574, 0xc575, 0xc57c, 
/* 0xbee0 */
0xc57d, 0xc580, 0xc584, 0xc587, 0xc58c, 0xc58d, 0xc58f, 0xc591, 0xc595, 0xc597, 0xc598, 0xc59c, 0xc5a0, 0xc5a9, 0xc5b4, 0xc5b5, 
/* 0xbef0 */
0xc5b8, 0xc5b9, 0xc5bb, 0xc5bc, 0xc5bd, 0xc5be, 0xc5c4, 0xc5c5, 0xc5c6, 0xc5c7, 0xc5c8, 0xc5c9, 0xc5ca, 0xc5cc, 0xc5ce, 
};
static struct cp2unicode_row korean_row_be = { 0xbe, 0x41, 0xbe, korean_row_codes_be };
static unicode_t korean_row_codes_bf[] =
{
/* 0xbf41 */
0xd49e, 0xd49f, 0xd4a0, 0xd4a1, 0xd4a2, 0xd4a3, 0xd4a4, 0xd4a5, 0xd4a6, 0xd4a7, 0xd4a8, 0xd4aa, 0xd4ab, 0xd4ac, 0xd4ad, 
/* 0xbf50 */
0xd4ae, 0xd4af, 0xd4b0, 0xd4b1, 0xd4b2, 0xd4b3, 0xd4b4, 0xd4b5, 0xd4b6, 0xd4b7, 0xd4b8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbf60 */
0x0000, 0xd4b9, 0xd4ba, 0xd4bb, 0xd4bc, 0xd4bd, 0xd4be, 0xd4bf, 0xd4c0, 0xd4c1, 0xd4c2, 0xd4c3, 0xd4c4, 0xd4c5, 0xd4c6, 0xd4c7, 
/* 0xbf70 */
0xd4c8, 0xd4c9, 0xd4ca, 0xd4cb, 0xd4cd, 0xd4ce, 0xd4cf, 0xd4d1, 0xd4d2, 0xd4d3, 0xd4d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xbf80 */
0x0000, 0xd4d6, 0xd4d7, 0xd4d8, 0xd4d9, 0xd4da, 0xd4db, 0xd4dd, 0xd4de, 0xd4e0, 0xd4e1, 0xd4e2, 0xd4e3, 0xd4e4, 0xd4e5, 0xd4e6, 
/* 0xbf90 */
0xd4e7, 0xd4e9, 0xd4ea, 0xd4eb, 0xd4ed, 0xd4ee, 0xd4ef, 0xd4f1, 0xd4f2, 0xd4f3, 0xd4f4, 0xd4f5, 0xd4f6, 0xd4f7, 0xd4f9, 0xd4fa, 
/* 0xbfa0 */
0xd4fc, 0xc5d0, 0xc5d1, 0xc5d4, 0xc5d8, 0xc5e0, 0xc5e1, 0xc5e3, 0xc5e5, 0xc5ec, 0xc5ed, 0xc5ee, 0xc5f0, 0xc5f4, 0xc5f6, 0xc5f7, 
/* 0xbfb0 */
0xc5fc, 0xc5fd, 0xc5fe, 0xc5ff, 0xc600, 0xc601, 0xc605, 0xc606, 0xc607, 0xc608, 0xc60c, 0xc610, 0xc618, 0xc619, 0xc61b, 0xc61c, 
/* 0xbfc0 */
0xc624, 0xc625, 0xc628, 0xc62c, 0xc62d, 0xc62e, 0xc630, 0xc633, 0xc634, 0xc635, 0xc637, 0xc639, 0xc63b, 0xc640, 0xc641, 0xc644, 
/* 0xbfd0 */
0xc648, 0xc650, 0xc651, 0xc653, 0xc654, 0xc655, 0xc65c, 0xc65d, 0xc660, 0xc66c, 0xc66f, 0xc671, 0xc678, 0xc679, 0xc67c, 0xc680, 
/* 0xbfe0 */
0xc688, 0xc689, 0xc68b, 0xc68d, 0xc694, 0xc695, 0xc698, 0xc69c, 0xc6a4, 0xc6a5, 0xc6a7, 0xc6a9, 0xc6b0, 0xc6b1, 0xc6b4, 0xc6b8, 
/* 0xbff0 */
0xc6b9, 0xc6ba, 0xc6c0, 0xc6c1, 0xc6c3, 0xc6c5, 0xc6cc, 0xc6cd, 0xc6d0, 0xc6d4, 0xc6dc, 0xc6dd, 0xc6e0, 0xc6e1, 0xc6e8, 
};
static struct cp2unicode_row korean_row_bf = { 0xbf, 0x41, 0xbe, korean_row_codes_bf };
static unicode_t korean_row_codes_c0[] =
{
/* 0xc041 */
0xd4fe, 0xd4ff, 0xd500, 0xd501, 0xd502, 0xd503, 0xd505, 0xd506, 0xd507, 0xd509, 0xd50a, 0xd50b, 0xd50d, 0xd50e, 0xd50f, 
/* 0xc050 */
0xd510, 0xd511, 0xd512, 0xd513, 0xd516, 0xd518, 0xd519, 0xd51a, 0xd51b, 0xd51c, 0xd51d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc060 */
0x0000, 0xd51e, 0xd51f, 0xd520, 0xd521, 0xd522, 0xd523, 0xd524, 0xd525, 0xd526, 0xd527, 0xd528, 0xd529, 0xd52a, 0xd52b, 0xd52c, 
/* 0xc070 */
0xd52d, 0xd52e, 0xd52f, 0xd530, 0xd531, 0xd532, 0xd533, 0xd534, 0xd535, 0xd536, 0xd537, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc080 */
0x0000, 0xd538, 0xd539, 0xd53a, 0xd53b, 0xd53e, 0xd53f, 0xd541, 0xd542, 0xd543, 0xd545, 0xd546, 0xd547, 0xd548, 0xd549, 0xd54a, 
/* 0xc090 */
0xd54b, 0xd54e, 0xd550, 0xd552, 0xd553, 0xd554, 0xd555, 0xd556, 0xd557, 0xd55a, 0xd55b, 0xd55d, 0xd55e, 0xd55f, 0xd561, 0xd562, 
/* 0xc0a0 */
0xd563, 0xc6e9, 0xc6ec, 0xc6f0, 0xc6f8, 0xc6f9, 0xc6fd, 0xc704, 0xc705, 0xc708, 0xc70c, 0xc714, 0xc715, 0xc717, 0xc719, 0xc720, 
/* 0xc0b0 */
0xc721, 0xc724, 0xc728, 0xc730, 0xc731, 0xc733, 0xc735, 0xc737, 0xc73c, 0xc73d, 0xc740, 0xc744, 0xc74a, 0xc74c, 0xc74d, 0xc74f, 
/* 0xc0c0 */
0xc751, 0xc752, 0xc753, 0xc754, 0xc755, 0xc756, 0xc757, 0xc758, 0xc75c, 0xc760, 0xc768, 0xc76b, 0xc774, 0xc775, 0xc778, 0xc77c, 
/* 0xc0d0 */
0xc77d, 0xc77e, 0xc783, 0xc784, 0xc785, 0xc787, 0xc788, 0xc789, 0xc78a, 0xc78e, 0xc790, 0xc791, 0xc794, 0xc796, 0xc797, 0xc798, 
/* 0xc0e0 */
0xc79a, 0xc7a0, 0xc7a1, 0xc7a3, 0xc7a4, 0xc7a5, 0xc7a6, 0xc7ac, 0xc7ad, 0xc7b0, 0xc7b4, 0xc7bc, 0xc7bd, 0xc7bf, 0xc7c0, 0xc7c1, 
/* 0xc0f0 */
0xc7c8, 0xc7c9, 0xc7cc, 0xc7ce, 0xc7d0, 0xc7d8, 0xc7dd, 0xc7e4, 0xc7e8, 0xc7ec, 0xc800, 0xc801, 0xc804, 0xc808, 0xc80a, 
};
static struct cp2unicode_row korean_row_c0 = { 0xc0, 0x41, 0xbe, korean_row_codes_c0 };
static unicode_t korean_row_codes_c1[] =
{
/* 0xc141 */
0xd564, 0xd566, 0xd567, 0xd56a, 0xd56c, 0xd56e, 0xd56f, 0xd570, 0xd571, 0xd572, 0xd573, 0xd576, 0xd577, 0xd579, 0xd57a, 
/* 0xc150 */
0xd57b, 0xd57d, 0xd57e, 0xd57f, 0xd580, 0xd581, 0xd582, 0xd583, 0xd586, 0xd58a, 0xd58b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc160 */
0x0000, 0xd58c, 0xd58d, 0xd58e, 0xd58f, 0xd591, 0xd592, 0xd593, 0xd594, 0xd595, 0xd596, 0xd597, 0xd598, 0xd599, 0xd59a, 0xd59b, 
/* 0xc170 */
0xd59c, 0xd59d, 0xd59e, 0xd59f, 0xd5a0, 0xd5a1, 0xd5a2, 0xd5a3, 0xd5a4, 0xd5a6, 0xd5a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc180 */
0x0000, 0xd5a8, 0xd5a9, 0xd5aa, 0xd5ab, 0xd5ac, 0xd5ad, 0xd5ae, 0xd5af, 0xd5b0, 0xd5b1, 0xd5b2, 0xd5b3, 0xd5b4, 0xd5b5, 0xd5b6, 
/* 0xc190 */
0xd5b7, 0xd5b8, 0xd5b9, 0xd5ba, 0xd5bb, 0xd5bc, 0xd5bd, 0xd5be, 0xd5bf, 0xd5c0, 0xd5c1, 0xd5c2, 0xd5c3, 0xd5c4, 0xd5c5, 0xd5c6, 
/* 0xc1a0 */
0xd5c7, 0xc810, 0xc811, 0xc813, 0xc815, 0xc816, 0xc81c, 0xc81d, 0xc820, 0xc824, 0xc82c, 0xc82d, 0xc82f, 0xc831, 0xc838, 0xc83c, 
/* 0xc1b0 */
0xc840, 0xc848, 0xc849, 0xc84c, 0xc84d, 0xc854, 0xc870, 0xc871, 0xc874, 0xc878, 0xc87a, 0xc880, 0xc881, 0xc883, 0xc885, 0xc886, 
/* 0xc1c0 */
0xc887, 0xc88b, 0xc88c, 0xc88d, 0xc894, 0xc89d, 0xc89f, 0xc8a1, 0xc8a8, 0xc8bc, 0xc8bd, 0xc8c4, 0xc8c8, 0xc8cc, 0xc8d4, 0xc8d5, 
/* 0xc1d0 */
0xc8d7, 0xc8d9, 0xc8e0, 0xc8e1, 0xc8e4, 0xc8f5, 0xc8fc, 0xc8fd, 0xc900, 0xc904, 0xc905, 0xc906, 0xc90c, 0xc90d, 0xc90f, 0xc911, 
/* 0xc1e0 */
0xc918, 0xc92c, 0xc934, 0xc950, 0xc951, 0xc954, 0xc958, 0xc960, 0xc961, 0xc963, 0xc96c, 0xc970, 0xc974, 0xc97c, 0xc988, 0xc989, 
/* 0xc1f0 */
0xc98c, 0xc990, 0xc998, 0xc999, 0xc99b, 0xc99d, 0xc9c0, 0xc9c1, 0xc9c4, 0xc9c7, 0xc9c8, 0xc9ca, 0xc9d0, 0xc9d1, 0xc9d3, 
};
static struct cp2unicode_row korean_row_c1 = { 0xc1, 0x41, 0xbe, korean_row_codes_c1 };
static unicode_t korean_row_codes_c2[] =
{
/* 0xc241 */
0xd5ca, 0xd5cb, 0xd5cd, 0xd5ce, 0xd5cf, 0xd5d1, 0xd5d3, 0xd5d4, 0xd5d5, 0xd5d6, 0xd5d7, 0xd5da, 0xd5dc, 0xd5de, 0xd5df, 
/* 0xc250 */
0xd5e0, 0xd5e1, 0xd5e2, 0xd5e3, 0xd5e6, 0xd5e7, 0xd5e9, 0xd5ea, 0xd5eb, 0xd5ed, 0xd5ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc260 */
0x0000, 0xd5ef, 0xd5f0, 0xd5f1, 0xd5f2, 0xd5f3, 0xd5f6, 0xd5f8, 0xd5fa, 0xd5fb, 0xd5fc, 0xd5fd, 0xd5fe, 0xd5ff, 0xd602, 0xd603, 
/* 0xc270 */
0xd605, 0xd606, 0xd607, 0xd609, 0xd60a, 0xd60b, 0xd60c, 0xd60d, 0xd60e, 0xd60f, 0xd612, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc280 */
0x0000, 0xd616, 0xd617, 0xd618, 0xd619, 0xd61a, 0xd61b, 0xd61d, 0xd61e, 0xd61f, 0xd621, 0xd622, 0xd623, 0xd625, 0xd626, 0xd627, 
/* 0xc290 */
0xd628, 0xd629, 0xd62a, 0xd62b, 0xd62c, 0xd62e, 0xd62f, 0xd630, 0xd631, 0xd632, 0xd633, 0xd634, 0xd635, 0xd636, 0xd637, 0xd63a, 
/* 0xc2a0 */
0xd63b, 0xc9d5, 0xc9d6, 0xc9d9, 0xc9da, 0xc9dc, 0xc9dd, 0xc9e0, 0xc9e2, 0xc9e4, 0xc9e7, 0xc9ec, 0xc9ed, 0xc9ef, 0xc9f0, 0xc9f1, 
/* 0xc2b0 */
0xc9f8, 0xc9f9, 0xc9fc, 0xca00, 0xca08, 0xca09, 0xca0b, 0xca0c, 0xca0d, 0xca14, 0xca18, 0xca29, 0xca4c, 0xca4d, 0xca50, 0xca54, 
/* 0xc2c0 */
0xca5c, 0xca5d, 0xca5f, 0xca60, 0xca61, 0xca68, 0xca7d, 0xca84, 0xca98, 0xcabc, 0xcabd, 0xcac0, 0xcac4, 0xcacc, 0xcacd, 0xcacf, 
/* 0xc2d0 */
0xcad1, 0xcad3, 0xcad8, 0xcad9, 0xcae0, 0xcaec, 0xcaf4, 0xcb08, 0xcb10, 0xcb14, 0xcb18, 0xcb20, 0xcb21, 0xcb41, 0xcb48, 0xcb49, 
/* 0xc2e0 */
0xcb4c, 0xcb50, 0xcb58, 0xcb59, 0xcb5d, 0xcb64, 0xcb78, 0xcb79, 0xcb9c, 0xcbb8, 0xcbd4, 0xcbe4, 0xcbe7, 0xcbe9, 0xcc0c, 0xcc0d, 
/* 0xc2f0 */
0xcc10, 0xcc14, 0xcc1c, 0xcc1d, 0xcc21, 0xcc22, 0xcc27, 0xcc28, 0xcc29, 0xcc2c, 0xcc2e, 0xcc30, 0xcc38, 0xcc39, 0xcc3b, 
};
static struct cp2unicode_row korean_row_c2 = { 0xc2, 0x41, 0xbe, korean_row_codes_c2 };
static unicode_t korean_row_codes_c3[] =
{
/* 0xc341 */
0xd63d, 0xd63e, 0xd63f, 0xd641, 0xd642, 0xd643, 0xd644, 0xd646, 0xd647, 0xd64a, 0xd64c, 0xd64e, 0xd64f, 0xd650, 0xd652, 
/* 0xc350 */
0xd653, 0xd656, 0xd657, 0xd659, 0xd65a, 0xd65b, 0xd65d, 0xd65e, 0xd65f, 0xd660, 0xd661, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc360 */
0x0000, 0xd662, 0xd663, 0xd664, 0xd665, 0xd666, 0xd668, 0xd66a, 0xd66b, 0xd66c, 0xd66d, 0xd66e, 0xd66f, 0xd672, 0xd673, 0xd675, 
/* 0xc370 */
0xd676, 0xd677, 0xd678, 0xd679, 0xd67a, 0xd67b, 0xd67c, 0xd67d, 0xd67e, 0xd67f, 0xd680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc380 */
0x0000, 0xd681, 0xd682, 0xd684, 0xd686, 0xd687, 0xd688, 0xd689, 0xd68a, 0xd68b, 0xd68e, 0xd68f, 0xd691, 0xd692, 0xd693, 0xd695, 
/* 0xc390 */
0xd696, 0xd697, 0xd698, 0xd699, 0xd69a, 0xd69b, 0xd69c, 0xd69e, 0xd6a0, 0xd6a2, 0xd6a3, 0xd6a4, 0xd6a5, 0xd6a6, 0xd6a7, 0xd6a9, 
/* 0xc3a0 */
0xd6aa, 0xcc3c, 0xcc3d, 0xcc3e, 0xcc44, 0xcc45, 0xcc48, 0xcc4c, 0xcc54, 0xcc55, 0xcc57, 0xcc58, 0xcc59, 0xcc60, 0xcc64, 0xcc66, 
/* 0xc3b0 */
0xcc68, 0xcc70, 0xcc75, 0xcc98, 0xcc99, 0xcc9c, 0xcca0, 0xcca8, 0xcca9, 0xccab, 0xccac, 0xccad, 0xccb4, 0xccb5, 0xccb8, 0xccbc, 
/* 0xc3c0 */
0xccc4, 0xccc5, 0xccc7, 0xccc9, 0xccd0, 0xccd4, 0xcce4, 0xccec, 0xccf0, 0xcd01, 0xcd08, 0xcd09, 0xcd0c, 0xcd10, 0xcd18, 0xcd19, 
/* 0xc3d0 */
0xcd1b, 0xcd1d, 0xcd24, 0xcd28, 0xcd2c, 0xcd39, 0xcd5c, 0xcd60, 0xcd64, 0xcd6c, 0xcd6d, 0xcd6f, 0xcd71, 0xcd78, 0xcd88, 0xcd94, 
/* 0xc3e0 */
0xcd95, 0xcd98, 0xcd9c, 0xcda4, 0xcda5, 0xcda7, 0xcda9, 0xcdb0, 0xcdc4, 0xcdcc, 0xcdd0, 0xcde8, 0xcdec, 0xcdf0, 0xcdf8, 0xcdf9, 
/* 0xc3f0 */
0xcdfb, 0xcdfd, 0xce04, 0xce08, 0xce0c, 0xce14, 0xce19, 0xce20, 0xce21, 0xce24, 0xce28, 0xce30, 0xce31, 0xce33, 0xce35, 
};
static struct cp2unicode_row korean_row_c3 = { 0xc3, 0x41, 0xbe, korean_row_codes_c3 };
static unicode_t korean_row_codes_c4[] =
{
/* 0xc441 */
0xd6ab, 0xd6ad, 0xd6ae, 0xd6af, 0xd6b1, 0xd6b2, 0xd6b3, 0xd6b4, 0xd6b5, 0xd6b6, 0xd6b7, 0xd6b8, 0xd6ba, 0xd6bc, 0xd6bd, 
/* 0xc450 */
0xd6be, 0xd6bf, 0xd6c0, 0xd6c1, 0xd6c2, 0xd6c3, 0xd6c6, 0xd6c7, 0xd6c9, 0xd6ca, 0xd6cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc460 */
0x0000, 0xd6cd, 0xd6ce, 0xd6cf, 0xd6d0, 0xd6d2, 0xd6d3, 0xd6d5, 0xd6d6, 0xd6d8, 0xd6da, 0xd6db, 0xd6dc, 0xd6dd, 0xd6de, 0xd6df, 
/* 0xc470 */
0xd6e1, 0xd6e2, 0xd6e3, 0xd6e5, 0xd6e6, 0xd6e7, 0xd6e9, 0xd6ea, 0xd6eb, 0xd6ec, 0xd6ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc480 */
0x0000, 0xd6ee, 0xd6ef, 0xd6f1, 0xd6f2, 0xd6f3, 0xd6f4, 0xd6f6, 0xd6f7, 0xd6f8, 0xd6f9, 0xd6fa, 0xd6fb, 0xd6fe, 0xd6ff, 0xd701, 
/* 0xc490 */
0xd702, 0xd703, 0xd705, 0xd706, 0xd707, 0xd708, 0xd709, 0xd70a, 0xd70b, 0xd70c, 0xd70d, 0xd70e, 0xd70f, 0xd710, 0xd712, 0xd713, 
/* 0xc4a0 */
0xd714, 0xce58, 0xce59, 0xce5c, 0xce5f, 0xce60, 0xce61, 0xce68, 0xce69, 0xce6b, 0xce6d, 0xce74, 0xce75, 0xce78, 0xce7c, 0xce84, 
/* 0xc4b0 */
0xce85, 0xce87, 0xce89, 0xce90, 0xce91, 0xce94, 0xce98, 0xcea0, 0xcea1, 0xcea3, 0xcea4, 0xcea5, 0xceac, 0xcead, 0xcec1, 0xcee4, 
/* 0xc4c0 */
0xcee5, 0xcee8, 0xceeb, 0xceec, 0xcef4, 0xcef5, 0xcef7, 0xcef8, 0xcef9, 0xcf00, 0xcf01, 0xcf04, 0xcf08, 0xcf10, 0xcf11, 0xcf13, 
/* 0xc4d0 */
0xcf15, 0xcf1c, 0xcf20, 0xcf24, 0xcf2c, 0xcf2d, 0xcf2f, 0xcf30, 0xcf31, 0xcf38, 0xcf54, 0xcf55, 0xcf58, 0xcf5c, 0xcf64, 0xcf65, 
/* 0xc4e0 */
0xcf67, 0xcf69, 0xcf70, 0xcf71, 0xcf74, 0xcf78, 0xcf80, 0xcf85, 0xcf8c, 0xcfa1, 0xcfa8, 0xcfb0, 0xcfc4, 0xcfe0, 0xcfe1, 0xcfe4, 
/* 0xc4f0 */
0xcfe8, 0xcff0, 0xcff1, 0xcff3, 0xcff5, 0xcffc, 0xd000, 0xd004, 0xd011, 0xd018, 0xd02d, 0xd034, 0xd035, 0xd038, 0xd03c, 
};
static struct cp2unicode_row korean_row_c4 = { 0xc4, 0x41, 0xbe, korean_row_codes_c4 };
static unicode_t korean_row_codes_c5[] =
{
/* 0xc541 */
0xd715, 0xd716, 0xd717, 0xd71a, 0xd71b, 0xd71d, 0xd71e, 0xd71f, 0xd721, 0xd722, 0xd723, 0xd724, 0xd725, 0xd726, 0xd727, 
/* 0xc550 */
0xd72a, 0xd72c, 0xd72e, 0xd72f, 0xd730, 0xd731, 0xd732, 0xd733, 0xd736, 0xd737, 0xd739, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc560 */
0x0000, 0xd73a, 0xd73b, 0xd73d, 0xd73e, 0xd73f, 0xd740, 0xd741, 0xd742, 0xd743, 0xd745, 0xd746, 0xd748, 0xd74a, 0xd74b, 0xd74c, 
/* 0xc570 */
0xd74d, 0xd74e, 0xd74f, 0xd752, 0xd753, 0xd755, 0xd75a, 0xd75b, 0xd75c, 0xd75d, 0xd75e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc580 */
0x0000, 0xd75f, 0xd762, 0xd764, 0xd766, 0xd767, 0xd768, 0xd76a, 0xd76b, 0xd76d, 0xd76e, 0xd76f, 0xd771, 0xd772, 0xd773, 0xd775, 
/* 0xc590 */
0xd776, 0xd777, 0xd778, 0xd779, 0xd77a, 0xd77b, 0xd77e, 0xd77f, 0xd780, 0xd782, 0xd783, 0xd784, 0xd785, 0xd786, 0xd787, 0xd78a, 
/* 0xc5a0 */
0xd78b, 0xd044, 0xd045, 0xd047, 0xd049, 0xd050, 0xd054, 0xd058, 0xd060, 0xd06c, 0xd06d, 0xd070, 0xd074, 0xd07c, 0xd07d, 0xd081, 
/* 0xc5b0 */
0xd0a4, 0xd0a5, 0xd0a8, 0xd0ac, 0xd0b4, 0xd0b5, 0xd0b7, 0xd0b9, 0xd0c0, 0xd0c1, 0xd0c4, 0xd0c8, 0xd0c9, 0xd0d0, 0xd0d1, 0xd0d3, 
/* 0xc5c0 */
0xd0d4, 0xd0d5, 0xd0dc, 0xd0dd, 0xd0e0, 0xd0e4, 0xd0ec, 0xd0ed, 0xd0ef, 0xd0f0, 0xd0f1, 0xd0f8, 0xd10d, 0xd130, 0xd131, 0xd134, 
/* 0xc5d0 */
0xd138, 0xd13a, 0xd140, 0xd141, 0xd143, 0xd144, 0xd145, 0xd14c, 0xd14d, 0xd150, 0xd154, 0xd15c, 0xd15d, 0xd15f, 0xd161, 0xd168, 
/* 0xc5e0 */
0xd16c, 0xd17c, 0xd184, 0xd188, 0xd1a0, 0xd1a1, 0xd1a4, 0xd1a8, 0xd1b0, 0xd1b1, 0xd1b3, 0xd1b5, 0xd1ba, 0xd1bc, 0xd1c0, 0xd1d8, 
/* 0xc5f0 */
0xd1f4, 0xd1f8, 0xd207, 0xd209, 0xd210, 0xd22c, 0xd22d, 0xd230, 0xd234, 0xd23c, 0xd23d, 0xd23f, 0xd241, 0xd248, 0xd25c, 
};
static struct cp2unicode_row korean_row_c5 = { 0xc5, 0x41, 0xbe, korean_row_codes_c5 };
static unicode_t korean_row_codes_c6[] =
{
/* 0xc641 */
0xd78d, 0xd78e, 0xd78f, 0xd791, 0xd792, 0xd793, 0xd794, 0xd795, 0xd796, 0xd797, 0xd79a, 0xd79c, 0xd79e, 0xd79f, 0xd7a0, 
/* 0xc650 */
0xd7a1, 0xd7a2, 0xd7a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc660 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc670 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc680 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc690 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
/* 0xc6a0 */
0x0000, 0xd264, 0xd280, 0xd281, 0xd284, 0xd288, 0xd290, 0xd291, 0xd295, 0xd29c, 0xd2a0, 0xd2a4, 0xd2ac, 0xd2b1, 0xd2b8, 0xd2b9, 
/* 0xc6b0 */
0xd2bc, 0xd2bf, 0xd2c0, 0xd2c2, 0xd2c8, 0xd2c9, 0xd2cb, 0xd2d4, 0xd2d8, 0xd2dc, 0xd2e4, 0xd2e5, 0xd2f0, 0xd2f1, 0xd2f4, 0xd2f8, 
/* 0xc6c0 */
0xd300, 0xd301, 0xd303, 0xd305, 0xd30c, 0xd30d, 0xd30e, 0xd310, 0xd314, 0xd316, 0xd31c, 0xd31d, 0xd31f, 0xd320, 0xd321, 0xd325, 
/* 0xc6d0 */
0xd328, 0xd329, 0xd32c, 0xd330, 0xd338, 0xd339, 0xd33b, 0xd33c, 0xd33d, 0xd344, 0xd345, 0xd37c, 0xd37d, 0xd380, 0xd384, 0xd38c, 
/* 0xc6e0 */
0xd38d, 0xd38f, 0xd390, 0xd391, 0xd398, 0xd399, 0xd39c, 0xd3a0, 0xd3a8, 0xd3a9, 0xd3ab, 0xd3ad, 0xd3b4, 0xd3b8, 0xd3bc, 0xd3c4, 
/* 0xc6f0 */
0xd3c5, 0xd3c8, 0xd3c9, 0xd3d0, 0xd3d8, 0xd3e1, 0xd3e3, 0xd3ec, 0xd3ed, 0xd3f0, 0xd3f4, 0xd3fc, 0xd3fd, 0xd3ff, 0xd401, 
};
static struct cp2unicode_row korean_row_c6 = { 0xc6, 0x41, 0xbe, korean_row_codes_c6 };
static unicode_t korean_row_codes_c7[] =
{
/* 0xc7a1 */
0xd408, 0xd41d, 0xd440, 0xd444, 0xd45c, 0xd460, 0xd464, 0xd46d, 0xd46f, 0xd478, 0xd479, 0xd47c, 0xd47f, 0xd480, 0xd482, 
/* 0xc7b0 */
0xd488, 0xd489, 0xd48b, 0xd48d, 0xd494, 0xd4a9, 0xd4cc, 0xd4d0, 0xd4d4, 0xd4dc, 0xd4df, 0xd4e8, 0xd4ec, 0xd4f0, 0xd4f8, 0xd4fb, 
/* 0xc7c0 */
0xd4fd, 0xd504, 0xd508, 0xd50c, 0xd514, 0xd515, 0xd517, 0xd53c, 0xd53d, 0xd540, 0xd544, 0xd54c, 0xd54d, 0xd54f, 0xd551, 0xd558, 
/* 0xc7d0 */
0xd559, 0xd55c, 0xd560, 0xd565, 0xd568, 0xd569, 0xd56b, 0xd56d, 0xd574, 0xd575, 0xd578, 0xd57c, 0xd584, 0xd585, 0xd587, 0xd588, 
/* 0xc7e0 */
0xd589, 0xd590, 0xd5a5, 0xd5c8, 0xd5c9, 0xd5cc, 0xd5d0, 0xd5d2, 0xd5d8, 0xd5d9, 0xd5db, 0xd5dd, 0xd5e4, 0xd5e5, 0xd5e8, 0xd5ec, 
/* 0xc7f0 */
0xd5f4, 0xd5f5, 0xd5f7, 0xd5f9, 0xd600, 0xd601, 0xd604, 0xd608, 0xd610, 0xd611, 0xd613, 0xd614, 0xd615, 0xd61c, 0xd620, 
};
static struct cp2unicode_row korean_row_c7 = { 0xc7, 0xa1, 0x5e, korean_row_codes_c7 };
static unicode_t korean_row_codes_c8[] =
{
/* 0xc8a1 */
0xd624, 0xd62d, 0xd638, 0xd639, 0xd63c, 0xd640, 0xd645, 0xd648, 0xd649, 0xd64b, 0xd64d, 0xd651, 0xd654, 0xd655, 0xd658, 
/* 0xc8b0 */
0xd65c, 0xd667, 0xd669, 0xd670, 0xd671, 0xd674, 0xd683, 0xd685, 0xd68c, 0xd68d, 0xd690, 0xd694, 0xd69d, 0xd69f, 0xd6a1, 0xd6a8, 
/* 0xc8c0 */
0xd6ac, 0xd6b0, 0xd6b9, 0xd6bb, 0xd6c4, 0xd6c5, 0xd6c8, 0xd6cc, 0xd6d1, 0xd6d4, 0xd6d7, 0xd6d9, 0xd6e0, 0xd6e4, 0xd6e8, 0xd6f0, 
/* 0xc8d0 */
0xd6f5, 0xd6fc, 0xd6fd, 0xd700, 0xd704, 0xd711, 0xd718, 0xd719, 0xd71c, 0xd720, 0xd728, 0xd729, 0xd72b, 0xd72d, 0xd734, 0xd735, 
/* 0xc8e0 */
0xd738, 0xd73c, 0xd744, 0xd747, 0xd749, 0xd750, 0xd751, 0xd754, 0xd756, 0xd757, 0xd758, 0xd759, 0xd760, 0xd761, 0xd763, 0xd765, 
/* 0xc8f0 */
0xd769, 0xd76c, 0xd770, 0xd774, 0xd77c, 0xd77d, 0xd781, 0xd788, 0xd789, 0xd78c, 0xd790, 0xd798, 0xd799, 0xd79b, 0xd79d, 
};
static struct cp2unicode_row korean_row_c8 = { 0xc8, 0xa1, 0x5e, korean_row_codes_c8 };
static unicode_t korean_row_codes_ca[] =
{
/* 0xcaa1 */
0x4f3d, 0x4f73, 0x5047, 0x50f9, 0x52a0, 0x53ef, 0x5475, 0x54e5, 0x5609, 0x5ac1, 0x5bb6, 0x6687, 0x67b6, 0x67b7, 0x67ef, 
/* 0xcab0 */
0x6b4c, 0x73c2, 0x75c2, 0x7a3c, 0x82db, 0x8304, 0x8857, 0x8888, 0x8a36, 0x8cc8, 0x8dcf, 0x8efb, 0x8fe6, 0x99d5, 0x523b, 0x5374, 
/* 0xcac0 */
0x5404, 0x606a, 0x6164, 0x6bbc, 0x73cf, 0x811a, 0x89ba, 0x89d2, 0x95a3, 0x4f83, 0x520a, 0x58be, 0x5978, 0x59e6, 0x5e72, 0x5e79, 
/* 0xcad0 */
0x61c7, 0x63c0, 0x6746, 0x67ec, 0x687f, 0x6f97, 0x764e, 0x770b, 0x78f5, 0x7a08, 0x7aff, 0x7c21, 0x809d, 0x826e, 0x8271, 0x8aeb, 
/* 0xcae0 */
0x9593, 0x4e6b, 0x559d, 0x66f7, 0x6e34, 0x78a3, 0x7aed, 0x845b, 0x8910, 0x874e, 0x97a8, 0x52d8, 0x574e, 0x582a, 0x5d4c, 0x611f, 
/* 0xcaf0 */
0x61be, 0x6221, 0x6562, 0x67d1, 0x6a44, 0x6e1b, 0x7518, 0x75b3, 0x76e3, 0x77b0, 0x7d3a, 0x90af, 0x9451, 0x9452, 0x9f95, 
};
static struct cp2unicode_row korean_row_ca = { 0xca, 0xa1, 0x5e, korean_row_codes_ca };
static unicode_t korean_row_codes_cb[] =
{
/* 0xcba1 */
0x5323, 0x5cac, 0x7532, 0x80db, 0x9240, 0x9598, 0x525b, 0x5808, 0x59dc, 0x5ca1, 0x5d17, 0x5eb7, 0x5f3a, 0x5f4a, 0x6177, 
/* 0xcbb0 */
0x6c5f, 0x757a, 0x7586, 0x7ce0, 0x7d73, 0x7db1, 0x7f8c, 0x8154, 0x8221, 0x8591, 0x8941, 0x8b1b, 0x92fc, 0x964d, 0x9c47, 0x4ecb, 
/* 0xcbc0 */
0x4ef7, 0x500b, 0x51f1, 0x584f, 0x6137, 0x613e, 0x6168, 0x6539, 0x69ea, 0x6f11, 0x75a5, 0x7686, 0x76d6, 0x7b87, 0x82a5, 0x84cb, 
/* 0xcbd0 */
0xf900, 0x93a7, 0x958b, 0x5580, 0x5ba2, 0x5751, 0xf901, 0x7cb3, 0x7fb9, 0x91b5, 0x5028, 0x53bb, 0x5c45, 0x5de8, 0x62d2, 0x636e, 
/* 0xcbe0 */
0x64da, 0x64e7, 0x6e20, 0x70ac, 0x795b, 0x8ddd, 0x8e1e, 0xf902, 0x907d, 0x9245, 0x92f8, 0x4e7e, 0x4ef6, 0x5065, 0x5dfe, 0x5efa, 
/* 0xcbf0 */
0x6106, 0x6957, 0x8171, 0x8654, 0x8e47, 0x9375, 0x9a2b, 0x4e5e, 0x5091, 0x6770, 0x6840, 0x5109, 0x528d, 0x5292, 0x6aa2, 
};
static struct cp2unicode_row korean_row_cb = { 0xcb, 0xa1, 0x5e, korean_row_codes_cb };
static unicode_t korean_row_codes_cc[] =
{
/* 0xcca1 */
0x77bc, 0x9210, 0x9ed4, 0x52ab, 0x602f, 0x8ff2, 0x5048, 0x61a9, 0x63ed, 0x64ca, 0x683c, 0x6a84, 0x6fc0, 0x8188, 0x89a1, 
/* 0xccb0 */
0x9694, 0x5805, 0x727d, 0x72ac, 0x7504, 0x7d79, 0x7e6d, 0x80a9, 0x898b, 0x8b74, 0x9063, 0x9d51, 0x6289, 0x6c7a, 0x6f54, 0x7d50, 
/* 0xccc0 */
0x7f3a, 0x8a23, 0x517c, 0x614a, 0x7b9d, 0x8b19, 0x9257, 0x938c, 0x4eac, 0x4fd3, 0x501e, 0x50be, 0x5106, 0x52c1, 0x52cd, 0x537f, 
/* 0xccd0 */
0x5770, 0x5883, 0x5e9a, 0x5f91, 0x6176, 0x61ac, 0x64ce, 0x656c, 0x666f, 0x66bb, 0x66f4, 0x6897, 0x6d87, 0x7085, 0x70f1, 0x749f, 
/* 0xcce0 */
0x74a5, 0x74ca, 0x75d9, 0x786c, 0x78ec, 0x7adf, 0x7af6, 0x7d45, 0x7d93, 0x8015, 0x803f, 0x811b, 0x8396, 0x8b66, 0x8f15, 0x9015, 
/* 0xccf0 */
0x93e1, 0x9803, 0x9838, 0x9a5a, 0x9be8, 0x4fc2, 0x5553, 0x583a, 0x5951, 0x5b63, 0x5c46, 0x60b8, 0x6212, 0x6842, 0x68b0, 
};
static struct cp2unicode_row korean_row_cc = { 0xcc, 0xa1, 0x5e, korean_row_codes_cc };
static unicode_t korean_row_codes_cd[] =
{
/* 0xcda1 */
0x68e8, 0x6eaa, 0x754c, 0x7678, 0x78ce, 0x7a3d, 0x7cfb, 0x7e6b, 0x7e7c, 0x8a08, 0x8aa1, 0x8c3f, 0x968e, 0x9dc4, 0x53e4, 
/* 0xcdb0 */
0x53e9, 0x544a, 0x5471, 0x56fa, 0x59d1, 0x5b64, 0x5c3b, 0x5eab, 0x62f7, 0x6537, 0x6545, 0x6572, 0x66a0, 0x67af, 0x69c1, 0x6cbd, 
/* 0xcdc0 */
0x75fc, 0x7690, 0x777e, 0x7a3f, 0x7f94, 0x8003, 0x80a1, 0x818f, 0x82e6, 0x82fd, 0x83f0, 0x85c1, 0x8831, 0x88b4, 0x8aa5, 0xf903, 
/* 0xcdd0 */
0x8f9c, 0x932e, 0x96c7, 0x9867, 0x9ad8, 0x9f13, 0x54ed, 0x659b, 0x66f2, 0x688f, 0x7a40, 0x8c37, 0x9d60, 0x56f0, 0x5764, 0x5d11, 
/* 0xcde0 */
0x6606, 0x68b1, 0x68cd, 0x6efe, 0x7428, 0x889e, 0x9be4, 0x6c68, 0xf904, 0x9aa8, 0x4f9b, 0x516c, 0x5171, 0x529f, 0x5b54, 0x5de5, 
/* 0xcdf0 */
0x6050, 0x606d, 0x62f1, 0x63a7, 0x653b, 0x73d9, 0x7a7a, 0x86a3, 0x8ca2, 0x978f, 0x4e32, 0x5be1, 0x6208, 0x679c, 0x74dc, 
};
static struct cp2unicode_row korean_row_cd = { 0xcd, 0xa1, 0x5e, korean_row_codes_cd };
static unicode_t korean_row_codes_ce[] =
{
/* 0xcea1 */
0x79d1, 0x83d3, 0x8a87, 0x8ab2, 0x8de8, 0x904e, 0x934b, 0x9846, 0x5ed3, 0x69e8, 0x85ff, 0x90ed, 0xf905, 0x51a0, 0x5b98, 
/* 0xceb0 */
0x5bec, 0x6163, 0x68fa, 0x6b3e, 0x704c, 0x742f, 0x74d8, 0x7ba1, 0x7f50, 0x83c5, 0x89c0, 0x8cab, 0x95dc, 0x9928, 0x522e, 0x605d, 
/* 0xcec0 */
0x62ec, 0x9002, 0x4f8a, 0x5149, 0x5321, 0x58d9, 0x5ee3, 0x66e0, 0x6d38, 0x709a, 0x72c2, 0x73d6, 0x7b50, 0x80f1, 0x945b, 0x5366, 
/* 0xced0 */
0x639b, 0x7f6b, 0x4e56, 0x5080, 0x584a, 0x58de, 0x602a, 0x6127, 0x62d0, 0x69d0, 0x9b41, 0x5b8f, 0x7d18, 0x80b1, 0x8f5f, 0x4ea4, 
/* 0xcee0 */
0x50d1, 0x54ac, 0x55ac, 0x5b0c, 0x5da0, 0x5de7, 0x652a, 0x654e, 0x6821, 0x6a4b, 0x72e1, 0x768e, 0x77ef, 0x7d5e, 0x7ff9, 0x81a0, 
/* 0xcef0 */
0x854e, 0x86df, 0x8f03, 0x8f4e, 0x90ca, 0x9903, 0x9a55, 0x9bab, 0x4e18, 0x4e45, 0x4e5d, 0x4ec7, 0x4ff1, 0x5177, 0x52fe, 
};
static struct cp2unicode_row korean_row_ce = { 0xce, 0xa1, 0x5e, korean_row_codes_ce };
static unicode_t korean_row_codes_cf[] =
{
/* 0xcfa1 */
0x5340, 0x53e3, 0x53e5, 0x548e, 0x5614, 0x5775, 0x57a2, 0x5bc7, 0x5d87, 0x5ed0, 0x61fc, 0x62d8, 0x6551, 0x67b8, 0x67e9, 
/* 0xcfb0 */
0x69cb, 0x6b50, 0x6bc6, 0x6bec, 0x6c42, 0x6e9d, 0x7078, 0x72d7, 0x7396, 0x7403, 0x77bf, 0x77e9, 0x7a76, 0x7d7f, 0x8009, 0x81fc, 
/* 0xcfc0 */
0x8205, 0x820a, 0x82df, 0x8862, 0x8b33, 0x8cfc, 0x8ec0, 0x9011, 0x90b1, 0x9264, 0x92b6, 0x99d2, 0x9a45, 0x9ce9, 0x9dd7, 0x9f9c, 
/* 0xcfd0 */
0x570b, 0x5c40, 0x83ca, 0x97a0, 0x97ab, 0x9eb4, 0x541b, 0x7a98, 0x7fa4, 0x88d9, 0x8ecd, 0x90e1, 0x5800, 0x5c48, 0x6398, 0x7a9f, 
/* 0xcfe0 */
0x5bae, 0x5f13, 0x7a79, 0x7aae, 0x828e, 0x8eac, 0x5026, 0x5238, 0x52f8, 0x5377, 0x5708, 0x62f3, 0x6372, 0x6b0a, 0x6dc3, 0x7737, 
/* 0xcff0 */
0x53a5, 0x7357, 0x8568, 0x8e76, 0x95d5, 0x673a, 0x6ac3, 0x6f70, 0x8a6d, 0x8ecc, 0x994b, 0xf906, 0x6677, 0x6b78, 0x8cb4, 
};
static struct cp2unicode_row korean_row_cf = { 0xcf, 0xa1, 0x5e, korean_row_codes_cf };
static unicode_t korean_row_codes_d0[] =
{
/* 0xd0a1 */
0x9b3c, 0xf907, 0x53eb, 0x572d, 0x594e, 0x63c6, 0x69fb, 0x73ea, 0x7845, 0x7aba, 0x7ac5, 0x7cfe, 0x8475, 0x898f, 0x8d73, 
/* 0xd0b0 */
0x9035, 0x95a8, 0x52fb, 0x5747, 0x7547, 0x7b60, 0x83cc, 0x921e, 0xf908, 0x6a58, 0x514b, 0x524b, 0x5287, 0x621f, 0x68d8, 0x6975, 
/* 0xd0c0 */
0x9699, 0x50c5, 0x52a4, 0x52e4, 0x61c3, 0x65a4, 0x6839, 0x69ff, 0x747e, 0x7b4b, 0x82b9, 0x83eb, 0x89b2, 0x8b39, 0x8fd1, 0x9949, 
/* 0xd0d0 */
0xf909, 0x4eca, 0x5997, 0x64d2, 0x6611, 0x6a8e, 0x7434, 0x7981, 0x79bd, 0x82a9, 0x887e, 0x887f, 0x895f, 0xf90a, 0x9326, 0x4f0b, 
/* 0xd0e0 */
0x53ca, 0x6025, 0x6271, 0x6c72, 0x7d1a, 0x7d66, 0x4e98, 0x5162, 0x77dc, 0x80af, 0x4f01, 0x4f0e, 0x5176, 0x5180, 0x55dc, 0x5668, 
/* 0xd0f0 */
0x573b, 0x57fa, 0x57fc, 0x5914, 0x5947, 0x5993, 0x5bc4, 0x5c90, 0x5d0e, 0x5df1, 0x5e7e, 0x5fcc, 0x6280, 0x65d7, 0x65e3, 
};
static struct cp2unicode_row korean_row_d0 = { 0xd0, 0xa1, 0x5e, korean_row_codes_d0 };
static unicode_t korean_row_codes_d1[] =
{
/* 0xd1a1 */
0x671e, 0x671f, 0x675e, 0x68cb, 0x68c4, 0x6a5f, 0x6b3a, 0x6c23, 0x6c7d, 0x6c82, 0x6dc7, 0x7398, 0x7426, 0x742a, 0x7482, 
/* 0xd1b0 */
0x74a3, 0x7578, 0x757f, 0x7881, 0x78ef, 0x7941, 0x7947, 0x7948, 0x797a, 0x7b95, 0x7d00, 0x7dba, 0x7f88, 0x8006, 0x802d, 0x808c, 
/* 0xd1c0 */
0x8a18, 0x8b4f, 0x8c48, 0x8d77, 0x9321, 0x9324, 0x98e2, 0x9951, 0x9a0e, 0x9a0f, 0x9a65, 0x9e92, 0x7dca, 0x4f76, 0x5409, 0x62ee, 
/* 0xd1d0 */
0x6854, 0x91d1, 0x55ab, 0x513a, 0xf90b, 0xf90c, 0x5a1c, 0x61e6, 0xf90d, 0x62cf, 0x62ff, 0xf90e, 0xf90f, 0xf910, 0xf911, 0xf912, 
/* 0xd1e0 */
0xf913, 0x90a3, 0xf914, 0xf915, 0xf916, 0xf917, 0xf918, 0x8afe, 0xf919, 0xf91a, 0xf91b, 0xf91c, 0x6696, 0xf91d, 0x7156, 0xf91e, 
/* 0xd1f0 */
0xf91f, 0x96e3, 0xf920, 0x634f, 0x637a, 0x5357, 0xf921, 0x678f, 0x6960, 0x6e73, 0xf922, 0x7537, 0xf923, 0xf924, 0xf925, 
};
static struct cp2unicode_row korean_row_d1 = { 0xd1, 0xa1, 0x5e, korean_row_codes_d1 };
static unicode_t korean_row_codes_d2[] =
{
/* 0xd2a1 */
0x7d0d, 0xf926, 0xf927, 0x8872, 0x56ca, 0x5a18, 0xf928, 0xf929, 0xf92a, 0xf92b, 0xf92c, 0x4e43, 0xf92d, 0x5167, 0x5948, 
/* 0xd2b0 */
0x67f0, 0x8010, 0xf92e, 0x5973, 0x5e74, 0x649a, 0x79ca, 0x5ff5, 0x606c, 0x62c8, 0x637b, 0x5be7, 0x5bd7, 0x52aa, 0xf92f, 0x5974, 
/* 0xd2c0 */
0x5f29, 0x6012, 0xf930, 0xf931, 0xf932, 0x7459, 0xf933, 0xf934, 0xf935, 0xf936, 0xf937, 0xf938, 0x99d1, 0xf939, 0xf93a, 0xf93b, 
/* 0xd2d0 */
0xf93c, 0xf93d, 0xf93e, 0xf93f, 0xf940, 0xf941, 0xf942, 0xf943, 0x6fc3, 0xf944, 0xf945, 0x81bf, 0x8fb2, 0x60f1, 0xf946, 0xf947, 
/* 0xd2e0 */
0x8166, 0xf948, 0xf949, 0x5c3f, 0xf94a, 0xf94b, 0xf94c, 0xf94d, 0xf94e, 0xf94f, 0xf950, 0xf951, 0x5ae9, 0x8a25, 0x677b, 0x7d10, 
/* 0xd2f0 */
0xf952, 0xf953, 0xf954, 0xf955, 0xf956, 0xf957, 0x80fd, 0xf958, 0xf959, 0x5c3c, 0x6ce5, 0x533f, 0x6eba, 0x591a, 0x8336, 
};
static struct cp2unicode_row korean_row_d2 = { 0xd2, 0xa1, 0x5e, korean_row_codes_d2 };
static unicode_t korean_row_codes_d3[] =
{
/* 0xd3a1 */
0x4e39, 0x4eb6, 0x4f46, 0x55ae, 0x5718, 0x58c7, 0x5f56, 0x65b7, 0x65e6, 0x6a80, 0x6bb5, 0x6e4d, 0x77ed, 0x7aef, 0x7c1e, 
/* 0xd3b0 */
0x7dde, 0x86cb, 0x8892, 0x9132, 0x935b, 0x64bb, 0x6fbe, 0x737a, 0x75b8, 0x9054, 0x5556, 0x574d, 0x61ba, 0x64d4, 0x66c7, 0x6de1, 
/* 0xd3c0 */
0x6e5b, 0x6f6d, 0x6fb9, 0x75f0, 0x8043, 0x81bd, 0x8541, 0x8983, 0x8ac7, 0x8b5a, 0x931f, 0x6c93, 0x7553, 0x7b54, 0x8e0f, 0x905d, 
/* 0xd3d0 */
0x5510, 0x5802, 0x5858, 0x5e62, 0x6207, 0x649e, 0x68e0, 0x7576, 0x7cd6, 0x87b3, 0x9ee8, 0x4ee3, 0x5788, 0x576e, 0x5927, 0x5c0d, 
/* 0xd3e0 */
0x5cb1, 0x5e36, 0x5f85, 0x6234, 0x64e1, 0x73b3, 0x81fa, 0x888b, 0x8cb8, 0x968a, 0x9edb, 0x5b85, 0x5fb7, 0x60b3, 0x5012, 0x5200, 
/* 0xd3f0 */
0x5230, 0x5716, 0x5835, 0x5857, 0x5c0e, 0x5c60, 0x5cf6, 0x5d8b, 0x5ea6, 0x5f92, 0x60bc, 0x6311, 0x6389, 0x6417, 0x6843, 
};
static struct cp2unicode_row korean_row_d3 = { 0xd3, 0xa1, 0x5e, korean_row_codes_d3 };
static unicode_t korean_row_codes_d4[] =
{
/* 0xd4a1 */
0x68f9, 0x6ac2, 0x6dd8, 0x6e21, 0x6ed4, 0x6fe4, 0x71fe, 0x76dc, 0x7779, 0x79b1, 0x7a3b, 0x8404, 0x89a9, 0x8ced, 0x8df3, 
/* 0xd4b0 */
0x8e48, 0x9003, 0x9014, 0x9053, 0x90fd, 0x934d, 0x9676, 0x97dc, 0x6bd2, 0x7006, 0x7258, 0x72a2, 0x7368, 0x7763, 0x79bf, 0x7be4, 
/* 0xd4c0 */
0x7e9b, 0x8b80, 0x58a9, 0x60c7, 0x6566, 0x65fd, 0x66be, 0x6c8c, 0x711e, 0x71c9, 0x8c5a, 0x9813, 0x4e6d, 0x7a81, 0x4edd, 0x51ac, 
/* 0xd4d0 */
0x51cd, 0x52d5, 0x540c, 0x61a7, 0x6771, 0x6850, 0x68df, 0x6d1e, 0x6f7c, 0x75bc, 0x77b3, 0x7ae5, 0x80f4, 0x8463, 0x9285, 0x515c, 
/* 0xd4e0 */
0x6597, 0x675c, 0x6793, 0x75d8, 0x7ac7, 0x8373, 0xf95a, 0x8c46, 0x9017, 0x982d, 0x5c6f, 0x81c0, 0x829a, 0x9041, 0x906f, 0x920d, 
/* 0xd4f0 */
0x5f97, 0x5d9d, 0x6a59, 0x71c8, 0x767b, 0x7b49, 0x85e4, 0x8b04, 0x9127, 0x9a30, 0x5587, 0x61f6, 0xf95b, 0x7669, 0x7f85, 
};
static struct cp2unicode_row korean_row_d4 = { 0xd4, 0xa1, 0x5e, korean_row_codes_d4 };
static unicode_t korean_row_codes_d5[] =
{
/* 0xd5a1 */
0x863f, 0x87ba, 0x88f8, 0x908f, 0xf95c, 0x6d1b, 0x70d9, 0x73de, 0x7d61, 0x843d, 0xf95d, 0x916a, 0x99f1, 0xf95e, 0x4e82, 
/* 0xd5b0 */
0x5375, 0x6b04, 0x6b12, 0x703e, 0x721b, 0x862d, 0x9e1e, 0x524c, 0x8fa3, 0x5d50, 0x64e5, 0x652c, 0x6b16, 0x6feb, 0x7c43, 0x7e9c, 
/* 0xd5c0 */
0x85cd, 0x8964, 0x89bd, 0x62c9, 0x81d8, 0x881f, 0x5eca, 0x6717, 0x6d6a, 0x72fc, 0x7405, 0x746f, 0x8782, 0x90de, 0x4f86, 0x5d0d, 
/* 0xd5d0 */
0x5fa0, 0x840a, 0x51b7, 0x63a0, 0x7565, 0x4eae, 0x5006, 0x5169, 0x51c9, 0x6881, 0x6a11, 0x7cae, 0x7cb1, 0x7ce7, 0x826f, 0x8ad2, 
/* 0xd5e0 */
0x8f1b, 0x91cf, 0x4fb6, 0x5137, 0x52f5, 0x5442, 0x5eec, 0x616e, 0x623e, 0x65c5, 0x6ada, 0x6ffe, 0x792a, 0x85dc, 0x8823, 0x95ad, 
/* 0xd5f0 */
0x9a62, 0x9a6a, 0x9e97, 0x9ece, 0x529b, 0x66c6, 0x6b77, 0x701d, 0x792b, 0x8f62, 0x9742, 0x6190, 0x6200, 0x6523, 0x6f23, 
};
static struct cp2unicode_row korean_row_d5 = { 0xd5, 0xa1, 0x5e, korean_row_codes_d5 };
static unicode_t korean_row_codes_d6[] =
{
/* 0xd6a1 */
0x7149, 0x7489, 0x7df4, 0x806f, 0x84ee, 0x8f26, 0x9023, 0x934a, 0x51bd, 0x5217, 0x52a3, 0x6d0c, 0x70c8, 0x88c2, 0x5ec9, 
/* 0xd6b0 */
0x6582, 0x6bae, 0x6fc2, 0x7c3e, 0x7375, 0x4ee4, 0x4f36, 0x56f9, 0xf95f, 0x5cba, 0x5dba, 0x601c, 0x73b2, 0x7b2d, 0x7f9a, 0x7fce, 
/* 0xd6c0 */
0x8046, 0x901e, 0x9234, 0x96f6, 0x9748, 0x9818, 0x9f61, 0x4f8b, 0x6fa7, 0x79ae, 0x91b4, 0x96b7, 0x52de, 0xf960, 0x6488, 0x64c4, 
/* 0xd6d0 */
0x6ad3, 0x6f5e, 0x7018, 0x7210, 0x76e7, 0x8001, 0x8606, 0x865c, 0x8def, 0x8f05, 0x9732, 0x9b6f, 0x9dfa, 0x9e75, 0x788c, 0x797f, 
/* 0xd6e0 */
0x7da0, 0x83c9, 0x9304, 0x9e7f, 0x9e93, 0x8ad6, 0x58df, 0x5f04, 0x6727, 0x7027, 0x74cf, 0x7c60, 0x807e, 0x5121, 0x7028, 0x7262, 
/* 0xd6f0 */
0x78ca, 0x8cc2, 0x8cda, 0x8cf4, 0x96f7, 0x4e86, 0x50da, 0x5bee, 0x5ed6, 0x6599, 0x71ce, 0x7642, 0x77ad, 0x804a, 0x84fc, 
};
static struct cp2unicode_row korean_row_d6 = { 0xd6, 0xa1, 0x5e, korean_row_codes_d6 };
static unicode_t korean_row_codes_d7[] =
{
/* 0xd7a1 */
0x907c, 0x9b27, 0x9f8d, 0x58d8, 0x5a41, 0x5c62, 0x6a13, 0x6dda, 0x6f0f, 0x763b, 0x7d2f, 0x7e37, 0x851e, 0x8938, 0x93e4, 
/* 0xd7b0 */
0x964b, 0x5289, 0x65d2, 0x67f3, 0x69b4, 0x6d41, 0x6e9c, 0x700f, 0x7409, 0x7460, 0x7559, 0x7624, 0x786b, 0x8b2c, 0x985e, 0x516d, 
/* 0xd7c0 */
0x622e, 0x9678, 0x4f96, 0x502b, 0x5d19, 0x6dea, 0x7db8, 0x8f2a, 0x5f8b, 0x6144, 0x6817, 0xf961, 0x9686, 0x52d2, 0x808b, 0x51dc, 
/* 0xd7d0 */
0x51cc, 0x695e, 0x7a1c, 0x7dbe, 0x83f1, 0x9675, 0x4fda, 0x5229, 0x5398, 0x540f, 0x550e, 0x5c65, 0x60a7, 0x674e, 0x68a8, 0x6d6c, 
/* 0xd7e0 */
0x7281, 0x72f8, 0x7406, 0x7483, 0xf962, 0x75e2, 0x7c6c, 0x7f79, 0x7fb8, 0x8389, 0x88cf, 0x88e1, 0x91cc, 0x91d0, 0x96e2, 0x9bc9, 
/* 0xd7f0 */
0x541d, 0x6f7e, 0x71d0, 0x7498, 0x85fa, 0x8eaa, 0x96a3, 0x9c57, 0x9e9f, 0x6797, 0x6dcb, 0x7433, 0x81e8, 0x9716, 0x782c, 
};
static struct cp2unicode_row korean_row_d7 = { 0xd7, 0xa1, 0x5e, korean_row_codes_d7 };
static unicode_t korean_row_codes_d8[] =
{
/* 0xd8a1 */
0x7acb, 0x7b20, 0x7c92, 0x6469, 0x746a, 0x75f2, 0x78bc, 0x78e8, 0x99ac, 0x9b54, 0x9ebb, 0x5bde, 0x5e55, 0x6f20, 0x819c, 
/* 0xd8b0 */
0x83ab, 0x9088, 0x4e07, 0x534d, 0x5a29, 0x5dd2, 0x5f4e, 0x6162, 0x633d, 0x6669, 0x66fc, 0x6eff, 0x6f2b, 0x7063, 0x779e, 0x842c, 
/* 0xd8c0 */
0x8513, 0x883b, 0x8f13, 0x9945, 0x9c3b, 0x551c, 0x62b9, 0x672b, 0x6cab, 0x8309, 0x896a, 0x977a, 0x4ea1, 0x5984, 0x5fd8, 0x5fd9, 
/* 0xd8d0 */
0x671b, 0x7db2, 0x7f54, 0x8292, 0x832b, 0x83bd, 0x8f1e, 0x9099, 0x57cb, 0x59b9, 0x5a92, 0x5bd0, 0x6627, 0x679a, 0x6885, 0x6bcf, 
/* 0xd8e0 */
0x7164, 0x7f75, 0x8cb7, 0x8ce3, 0x9081, 0x9b45, 0x8108, 0x8c8a, 0x964c, 0x9a40, 0x9ea5, 0x5b5f, 0x6c13, 0x731b, 0x76f2, 0x76df, 
/* 0xd8f0 */
0x840c, 0x51aa, 0x8993, 0x514d, 0x5195, 0x52c9, 0x68c9, 0x6c94, 0x7704, 0x7720, 0x7dbf, 0x7dec, 0x9762, 0x9eb5, 0x6ec5, 
};
static struct cp2unicode_row korean_row_d8 = { 0xd8, 0xa1, 0x5e, korean_row_codes_d8 };
static unicode_t korean_row_codes_d9[] =
{
/* 0xd9a1 */
0x8511, 0x51a5, 0x540d, 0x547d, 0x660e, 0x669d, 0x6927, 0x6e9f, 0x76bf, 0x7791, 0x8317, 0x84c2, 0x879f, 0x9169, 0x9298, 
/* 0xd9b0 */
0x9cf4, 0x8882, 0x4fae, 0x5192, 0x52df, 0x59c6, 0x5e3d, 0x6155, 0x6478, 0x6479, 0x66ae, 0x67d0, 0x6a21, 0x6bcd, 0x6bdb, 0x725f, 
/* 0xd9c0 */
0x7261, 0x7441, 0x7738, 0x77db, 0x8017, 0x82bc, 0x8305, 0x8b00, 0x8b28, 0x8c8c, 0x6728, 0x6c90, 0x7267, 0x76ee, 0x7766, 0x7a46, 
/* 0xd9d0 */
0x9da9, 0x6b7f, 0x6c92, 0x5922, 0x6726, 0x8499, 0x536f, 0x5893, 0x5999, 0x5edf, 0x63cf, 0x6634, 0x6773, 0x6e3a, 0x732b, 0x7ad7, 
/* 0xd9e0 */
0x82d7, 0x9328, 0x52d9, 0x5deb, 0x61ae, 0x61cb, 0x620a, 0x62c7, 0x64ab, 0x65e0, 0x6959, 0x6b66, 0x6bcb, 0x7121, 0x73f7, 0x755d, 
/* 0xd9f0 */
0x7e46, 0x821e, 0x8302, 0x856a, 0x8aa3, 0x8cbf, 0x9727, 0x9d61, 0x58a8, 0x9ed8, 0x5011, 0x520e, 0x543b, 0x554f, 0x6587, 
};
static struct cp2unicode_row korean_row_d9 = { 0xd9, 0xa1, 0x5e, korean_row_codes_d9 };
static unicode_t korean_row_codes_da[] =
{
/* 0xdaa1 */
0x6c76, 0x7d0a, 0x7d0b, 0x805e, 0x868a, 0x9580, 0x96ef, 0x52ff, 0x6c95, 0x7269, 0x5473, 0x5a9a, 0x5c3e, 0x5d4b, 0x5f4c, 
/* 0xdab0 */
0x5fae, 0x672a, 0x68b6, 0x6963, 0x6e3c, 0x6e44, 0x7709, 0x7c73, 0x7f8e, 0x8587, 0x8b0e, 0x8ff7, 0x9761, 0x9ef4, 0x5cb7, 0x60b6, 
/* 0xdac0 */
0x610d, 0x61ab, 0x654f, 0x65fb, 0x65fc, 0x6c11, 0x6cef, 0x739f, 0x73c9, 0x7de1, 0x9594, 0x5bc6, 0x871c, 0x8b10, 0x525d, 0x535a, 
/* 0xdad0 */
0x62cd, 0x640f, 0x64b2, 0x6734, 0x6a38, 0x6cca, 0x73c0, 0x749e, 0x7b94, 0x7c95, 0x7e1b, 0x818a, 0x8236, 0x8584, 0x8feb, 0x96f9, 
/* 0xdae0 */
0x99c1, 0x4f34, 0x534a, 0x53cd, 0x53db, 0x62cc, 0x642c, 0x6500, 0x6591, 0x69c3, 0x6cee, 0x6f58, 0x73ed, 0x7554, 0x7622, 0x76e4, 
/* 0xdaf0 */
0x76fc, 0x78d0, 0x78fb, 0x792c, 0x7d46, 0x822c, 0x87e0, 0x8fd4, 0x9812, 0x98ef, 0x52c3, 0x62d4, 0x64a5, 0x6e24, 0x6f51, 
};
static struct cp2unicode_row korean_row_da = { 0xda, 0xa1, 0x5e, korean_row_codes_da };
static unicode_t korean_row_codes_db[] =
{
/* 0xdba1 */
0x767c, 0x8dcb, 0x91b1, 0x9262, 0x9aee, 0x9b43, 0x5023, 0x508d, 0x574a, 0x59a8, 0x5c28, 0x5e47, 0x5f77, 0x623f, 0x653e, 
/* 0xdbb0 */
0x65b9, 0x65c1, 0x6609, 0x678b, 0x699c, 0x6ec2, 0x78c5, 0x7d21, 0x80aa, 0x8180, 0x822b, 0x82b3, 0x84a1, 0x868c, 0x8a2a, 0x8b17, 
/* 0xdbc0 */
0x90a6, 0x9632, 0x9f90, 0x500d, 0x4ff3, 0xf963, 0x57f9, 0x5f98, 0x62dc, 0x6392, 0x676f, 0x6e43, 0x7119, 0x76c3, 0x80cc, 0x80da, 
/* 0xdbd0 */
0x88f4, 0x88f5, 0x8919, 0x8ce0, 0x8f29, 0x914d, 0x966a, 0x4f2f, 0x4f70, 0x5e1b, 0x67cf, 0x6822, 0x767d, 0x767e, 0x9b44, 0x5e61, 
/* 0xdbe0 */
0x6a0a, 0x7169, 0x71d4, 0x756a, 0xf964, 0x7e41, 0x8543, 0x85e9, 0x98dc, 0x4f10, 0x7b4f, 0x7f70, 0x95a5, 0x51e1, 0x5e06, 0x68b5, 
/* 0xdbf0 */
0x6c3e, 0x6c4e, 0x6cdb, 0x72af, 0x7bc4, 0x8303, 0x6cd5, 0x743a, 0x50fb, 0x5288, 0x58c1, 0x64d8, 0x6a97, 0x74a7, 0x7656, 
};
static struct cp2unicode_row korean_row_db = { 0xdb, 0xa1, 0x5e, korean_row_codes_db };
static unicode_t korean_row_codes_dc[] =
{
/* 0xdca1 */
0x78a7, 0x8617, 0x95e2, 0x9739, 0xf965, 0x535e, 0x5f01, 0x8b8a, 0x8fa8, 0x8faf, 0x908a, 0x5225, 0x77a5, 0x9c49, 0x9f08, 
/* 0xdcb0 */
0x4e19, 0x5002, 0x5175, 0x5c5b, 0x5e77, 0x661e, 0x663a, 0x67c4, 0x68c5, 0x70b3, 0x7501, 0x75c5, 0x79c9, 0x7add, 0x8f27, 0x9920, 
/* 0xdcc0 */
0x9a08, 0x4fdd, 0x5821, 0x5831, 0x5bf6, 0x666e, 0x6b65, 0x6d11, 0x6e7a, 0x6f7d, 0x73e4, 0x752b, 0x83e9, 0x88dc, 0x8913, 0x8b5c, 
/* 0xdcd0 */
0x8f14, 0x4f0f, 0x50d5, 0x5310, 0x535c, 0x5b93, 0x5fa9, 0x670d, 0x798f, 0x8179, 0x832f, 0x8514, 0x8907, 0x8986, 0x8f39, 0x8f3b, 
/* 0xdce0 */
0x99a5, 0x9c12, 0x672c, 0x4e76, 0x4ff8, 0x5949, 0x5c01, 0x5cef, 0x5cf0, 0x6367, 0x68d2, 0x70fd, 0x71a2, 0x742b, 0x7e2b, 0x84ec, 
/* 0xdcf0 */
0x8702, 0x9022, 0x92d2, 0x9cf3, 0x4e0d, 0x4ed8, 0x4fef, 0x5085, 0x5256, 0x526f, 0x5426, 0x5490, 0x57e0, 0x592b, 0x5a66, 
};
static struct cp2unicode_row korean_row_dc = { 0xdc, 0xa1, 0x5e, korean_row_codes_dc };
static unicode_t korean_row_codes_dd[] =
{
/* 0xdda1 */
0x5b5a, 0x5b75, 0x5bcc, 0x5e9c, 0xf966, 0x6276, 0x6577, 0x65a7, 0x6d6e, 0x6ea5, 0x7236, 0x7b26, 0x7c3f, 0x7f36, 0x8150, 
/* 0xddb0 */
0x8151, 0x819a, 0x8240, 0x8299, 0x83a9, 0x8a03, 0x8ca0, 0x8ce6, 0x8cfb, 0x8d74, 0x8dba, 0x90e8, 0x91dc, 0x961c, 0x9644, 0x99d9, 
/* 0xddc0 */
0x9ce7, 0x5317, 0x5206, 0x5429, 0x5674, 0x58b3, 0x5954, 0x596e, 0x5fff, 0x61a4, 0x626e, 0x6610, 0x6c7e, 0x711a, 0x76c6, 0x7c89, 
/* 0xddd0 */
0x7cde, 0x7d1b, 0x82ac, 0x8cc1, 0x96f0, 0xf967, 0x4f5b, 0x5f17, 0x5f7f, 0x62c2, 0x5d29, 0x670b, 0x68da, 0x787c, 0x7e43, 0x9d6c, 
/* 0xdde0 */
0x4e15, 0x5099, 0x5315, 0x532a, 0x5351, 0x5983, 0x5a62, 0x5e87, 0x60b2, 0x618a, 0x6249, 0x6279, 0x6590, 0x6787, 0x69a7, 0x6bd4, 
/* 0xddf0 */
0x6bd6, 0x6bd7, 0x6bd8, 0x6cb8, 0xf968, 0x7435, 0x75fa, 0x7812, 0x7891, 0x79d5, 0x79d8, 0x7c83, 0x7dcb, 0x7fe1, 0x80a5, 
};
static struct cp2unicode_row korean_row_dd = { 0xdd, 0xa1, 0x5e, korean_row_codes_dd };
static unicode_t korean_row_codes_de[] =
{
/* 0xdea1 */
0x813e, 0x81c2, 0x83f2, 0x871a, 0x88e8, 0x8ab9, 0x8b6c, 0x8cbb, 0x9119, 0x975e, 0x98db, 0x9f3b, 0x56ac, 0x5b2a, 0x5f6c, 
/* 0xdeb0 */
0x658c, 0x6ab3, 0x6baf, 0x6d5c, 0x6ff1, 0x7015, 0x725d, 0x73ad, 0x8ca7, 0x8cd3, 0x983b, 0x6191, 0x6c37, 0x8058, 0x9a01, 0x4e4d, 
/* 0xdec0 */
0x4e8b, 0x4e9b, 0x4ed5, 0x4f3a, 0x4f3c, 0x4f7f, 0x4fdf, 0x50ff, 0x53f2, 0x53f8, 0x5506, 0x55e3, 0x56db, 0x58eb, 0x5962, 0x5a11, 
/* 0xded0 */
0x5beb, 0x5bfa, 0x5c04, 0x5df3, 0x5e2b, 0x5f99, 0x601d, 0x6368, 0x659c, 0x65af, 0x67f6, 0x67fb, 0x68ad, 0x6b7b, 0x6c99, 0x6cd7, 
/* 0xdee0 */
0x6e23, 0x7009, 0x7345, 0x7802, 0x793e, 0x7940, 0x7960, 0x79c1, 0x7be9, 0x7d17, 0x7d72, 0x8086, 0x820d, 0x838e, 0x84d1, 0x86c7, 
/* 0xdef0 */
0x88df, 0x8a50, 0x8a5e, 0x8b1d, 0x8cdc, 0x8d66, 0x8fad, 0x90aa, 0x98fc, 0x99df, 0x9e9d, 0x524a, 0xf969, 0x6714, 0xf96a, 
};
static struct cp2unicode_row korean_row_de = { 0xde, 0xa1, 0x5e, korean_row_codes_de };
static unicode_t korean_row_codes_df[] =
{
/* 0xdfa1 */
0x5098, 0x522a, 0x5c71, 0x6563, 0x6c55, 0x73ca, 0x7523, 0x759d, 0x7b97, 0x849c, 0x9178, 0x9730, 0x4e77, 0x6492, 0x6bba, 
/* 0xdfb0 */
0x715e, 0x85a9, 0x4e09, 0xf96b, 0x6749, 0x68ee, 0x6e17, 0x829f, 0x8518, 0x886b, 0x63f7, 0x6f81, 0x9212, 0x98af, 0x4e0a, 0x50b7, 
/* 0xdfc0 */
0x50cf, 0x511f, 0x5546, 0x55aa, 0x5617, 0x5b40, 0x5c19, 0x5ce0, 0x5e38, 0x5e8a, 0x5ea0, 0x5ec2, 0x60f3, 0x6851, 0x6a61, 0x6e58, 
/* 0xdfd0 */
0x723d, 0x7240, 0x72c0, 0x76f8, 0x7965, 0x7bb1, 0x7fd4, 0x88f3, 0x89f4, 0x8a73, 0x8c61, 0x8cde, 0x971c, 0x585e, 0x74bd, 0x8cfd, 
/* 0xdfe0 */
0x55c7, 0xf96c, 0x7a61, 0x7d22, 0x8272, 0x7272, 0x751f, 0x7525, 0xf96d, 0x7b19, 0x5885, 0x58fb, 0x5dbc, 0x5e8f, 0x5eb6, 0x5f90, 
/* 0xdff0 */
0x6055, 0x6292, 0x637f, 0x654d, 0x6691, 0x66d9, 0x66f8, 0x6816, 0x68f2, 0x7280, 0x745e, 0x7b6e, 0x7d6e, 0x7dd6, 0x7f72, 
};
static struct cp2unicode_row korean_row_df = { 0xdf, 0xa1, 0x5e, korean_row_codes_df };
static unicode_t korean_row_codes_e0[] =
{
/* 0xe0a1 */
0x80e5, 0x8212, 0x85af, 0x897f, 0x8a93, 0x901d, 0x92e4, 0x9ecd, 0x9f20, 0x5915, 0x596d, 0x5e2d, 0x60dc, 0x6614, 0x6673, 
/* 0xe0b0 */
0x6790, 0x6c50, 0x6dc5, 0x6f5f, 0x77f3, 0x78a9, 0x84c6, 0x91cb, 0x932b, 0x4ed9, 0x50ca, 0x5148, 0x5584, 0x5b0b, 0x5ba3, 0x6247, 
/* 0xe0c0 */
0x657e, 0x65cb, 0x6e32, 0x717d, 0x7401, 0x7444, 0x7487, 0x74bf, 0x766c, 0x79aa, 0x7dda, 0x7e55, 0x7fa8, 0x817a, 0x81b3, 0x8239, 
/* 0xe0d0 */
0x861a, 0x87ec, 0x8a75, 0x8de3, 0x9078, 0x9291, 0x9425, 0x994d, 0x9bae, 0x5368, 0x5c51, 0x6954, 0x6cc4, 0x6d29, 0x6e2b, 0x820c, 
/* 0xe0e0 */
0x859b, 0x893b, 0x8a2d, 0x8aaa, 0x96ea, 0x9f67, 0x5261, 0x66b9, 0x6bb2, 0x7e96, 0x87fe, 0x8d0d, 0x9583, 0x965d, 0x651d, 0x6d89, 
/* 0xe0f0 */
0x71ee, 0xf96e, 0x57ce, 0x59d3, 0x5bac, 0x6027, 0x60fa, 0x6210, 0x661f, 0x665f, 0x7329, 0x73f9, 0x76db, 0x7701, 0x7b6c, 
};
static struct cp2unicode_row korean_row_e0 = { 0xe0, 0xa1, 0x5e, korean_row_codes_e0 };
static unicode_t korean_row_codes_e1[] =
{
/* 0xe1a1 */
0x8056, 0x8072, 0x8165, 0x8aa0, 0x9192, 0x4e16, 0x52e2, 0x6b72, 0x6d17, 0x7a05, 0x7b39, 0x7d30, 0xf96f, 0x8cb0, 0x53ec, 
/* 0xe1b0 */
0x562f, 0x5851, 0x5bb5, 0x5c0f, 0x5c11, 0x5de2, 0x6240, 0x6383, 0x6414, 0x662d, 0x68b3, 0x6cbc, 0x6d88, 0x6eaf, 0x701f, 0x70a4, 
/* 0xe1c0 */
0x71d2, 0x7526, 0x758f, 0x758e, 0x7619, 0x7b11, 0x7be0, 0x7c2b, 0x7d20, 0x7d39, 0x852c, 0x856d, 0x8607, 0x8a34, 0x900d, 0x9061, 
/* 0xe1d0 */
0x90b5, 0x92b7, 0x97f6, 0x9a37, 0x4fd7, 0x5c6c, 0x675f, 0x6d91, 0x7c9f, 0x7e8c, 0x8b16, 0x8d16, 0x901f, 0x5b6b, 0x5dfd, 0x640d, 
/* 0xe1e0 */
0x84c0, 0x905c, 0x98e1, 0x7387, 0x5b8b, 0x609a, 0x677e, 0x6dde, 0x8a1f, 0x8aa6, 0x9001, 0x980c, 0x5237, 0xf970, 0x7051, 0x788e, 
/* 0xe1f0 */
0x9396, 0x8870, 0x91d7, 0x4fee, 0x53d7, 0x55fd, 0x56da, 0x5782, 0x58fd, 0x5ac2, 0x5b88, 0x5cab, 0x5cc0, 0x5e25, 0x6101, 
};
static struct cp2unicode_row korean_row_e1 = { 0xe1, 0xa1, 0x5e, korean_row_codes_e1 };
static unicode_t korean_row_codes_e2[] =
{
/* 0xe2a1 */
0x620d, 0x624b, 0x6388, 0x641c, 0x6536, 0x6578, 0x6a39, 0x6b8a, 0x6c34, 0x6d19, 0x6f31, 0x71e7, 0x72e9, 0x7378, 0x7407, 
/* 0xe2b0 */
0x74b2, 0x7626, 0x7761, 0x79c0, 0x7a57, 0x7aea, 0x7cb9, 0x7d8f, 0x7dac, 0x7e61, 0x7f9e, 0x8129, 0x8331, 0x8490, 0x84da, 0x85ea, 
/* 0xe2c0 */
0x8896, 0x8ab0, 0x8b90, 0x8f38, 0x9042, 0x9083, 0x916c, 0x9296, 0x92b9, 0x968b, 0x96a7, 0x96a8, 0x96d6, 0x9700, 0x9808, 0x9996, 
/* 0xe2d0 */
0x9ad3, 0x9b1a, 0x53d4, 0x587e, 0x5919, 0x5b70, 0x5bbf, 0x6dd1, 0x6f5a, 0x719f, 0x7421, 0x74b9, 0x8085, 0x83fd, 0x5de1, 0x5f87, 
/* 0xe2e0 */
0x5faa, 0x6042, 0x65ec, 0x6812, 0x696f, 0x6a53, 0x6b89, 0x6d35, 0x6df3, 0x73e3, 0x76fe, 0x77ac, 0x7b4d, 0x7d14, 0x8123, 0x821c, 
/* 0xe2f0 */
0x8340, 0x84f4, 0x8563, 0x8a62, 0x8ac4, 0x9187, 0x931e, 0x9806, 0x99b4, 0x620c, 0x8853, 0x8ff0, 0x9265, 0x5d07, 0x5d27, 
};
static struct cp2unicode_row korean_row_e2 = { 0xe2, 0xa1, 0x5e, korean_row_codes_e2 };
static unicode_t korean_row_codes_e3[] =
{
/* 0xe3a1 */
0x5d69, 0x745f, 0x819d, 0x8768, 0x6fd5, 0x62fe, 0x7fd2, 0x8936, 0x8972, 0x4e1e, 0x4e58, 0x50e7, 0x52dd, 0x5347, 0x627f, 
/* 0xe3b0 */
0x6607, 0x7e69, 0x8805, 0x965e, 0x4f8d, 0x5319, 0x5636, 0x59cb, 0x5aa4, 0x5c38, 0x5c4e, 0x5c4d, 0x5e02, 0x5f11, 0x6043, 0x65bd, 
/* 0xe3c0 */
0x662f, 0x6642, 0x67be, 0x67f4, 0x731c, 0x77e2, 0x793a, 0x7fc5, 0x8494, 0x84cd, 0x8996, 0x8a66, 0x8a69, 0x8ae1, 0x8c55, 0x8c7a, 
/* 0xe3d0 */
0x57f4, 0x5bd4, 0x5f0f, 0x606f, 0x62ed, 0x690d, 0x6b96, 0x6e5c, 0x7184, 0x7bd2, 0x8755, 0x8b58, 0x8efe, 0x98df, 0x98fe, 0x4f38, 
/* 0xe3e0 */
0x4f81, 0x4fe1, 0x547b, 0x5a20, 0x5bb8, 0x613c, 0x65b0, 0x6668, 0x71fc, 0x7533, 0x795e, 0x7d33, 0x814e, 0x81e3, 0x8398, 0x85aa, 
/* 0xe3f0 */
0x85ce, 0x8703, 0x8a0a, 0x8eab, 0x8f9b, 0xf971, 0x8fc5, 0x5931, 0x5ba4, 0x5be6, 0x6089, 0x5be9, 0x5c0b, 0x5fc3, 0x6c81, 
};
static struct cp2unicode_row korean_row_e3 = { 0xe3, 0xa1, 0x5e, korean_row_codes_e3 };
static unicode_t korean_row_codes_e4[] =
{
/* 0xe4a1 */
0xf972, 0x6df1, 0x700b, 0x751a, 0x82af, 0x8af6, 0x4ec0, 0x5341, 0xf973, 0x96d9, 0x6c0f, 0x4e9e, 0x4fc4, 0x5152, 0x555e, 
/* 0xe4b0 */
0x5a25, 0x5ce8, 0x6211, 0x7259, 0x82bd, 0x83aa, 0x86fe, 0x8859, 0x8a1d, 0x963f, 0x96c5, 0x9913, 0x9d09, 0x9d5d, 0x580a, 0x5cb3, 
/* 0xe4c0 */
0x5dbd, 0x5e44, 0x60e1, 0x6115, 0x63e1, 0x6a02, 0x6e25, 0x9102, 0x9354, 0x984e, 0x9c10, 0x9f77, 0x5b89, 0x5cb8, 0x6309, 0x664f, 
/* 0xe4d0 */
0x6848, 0x773c, 0x96c1, 0x978d, 0x9854, 0x9b9f, 0x65a1, 0x8b01, 0x8ecb, 0x95bc, 0x5535, 0x5ca9, 0x5dd6, 0x5eb5, 0x6697, 0x764c, 
/* 0xe4e0 */
0x83f4, 0x95c7, 0x58d3, 0x62bc, 0x72ce, 0x9d28, 0x4ef0, 0x592e, 0x600f, 0x663b, 0x6b83, 0x79e7, 0x9d26, 0x5393, 0x54c0, 0x57c3, 
/* 0xe4f0 */
0x5d16, 0x611b, 0x66d6, 0x6daf, 0x788d, 0x827e, 0x9698, 0x9744, 0x5384, 0x627c, 0x6396, 0x6db2, 0x7e0a, 0x814b, 0x984d, 
};
static struct cp2unicode_row korean_row_e4 = { 0xe4, 0xa1, 0x5e, korean_row_codes_e4 };
static unicode_t korean_row_codes_e5[] =
{
/* 0xe5a1 */
0x6afb, 0x7f4c, 0x9daf, 0x9e1a, 0x4e5f, 0x503b, 0x51b6, 0x591c, 0x60f9, 0x63f6, 0x6930, 0x723a, 0x8036, 0xf974, 0x91ce, 
/* 0xe5b0 */
0x5f31, 0xf975, 0xf976, 0x7d04, 0x82e5, 0x846f, 0x84bb, 0x85e5, 0x8e8d, 0xf977, 0x4f6f, 0xf978, 0xf979, 0x58e4, 0x5b43, 0x6059, 
/* 0xe5c0 */
0x63da, 0x6518, 0x656d, 0x6698, 0xf97a, 0x694a, 0x6a23, 0x6d0b, 0x7001, 0x716c, 0x75d2, 0x760d, 0x79b3, 0x7a70, 0xf97b, 0x7f8a, 
/* 0xe5d0 */
0xf97c, 0x8944, 0xf97d, 0x8b93, 0x91c0, 0x967d, 0xf97e, 0x990a, 0x5704, 0x5fa1, 0x65bc, 0x6f01, 0x7600, 0x79a6, 0x8a9e, 0x99ad, 
/* 0xe5e0 */
0x9b5a, 0x9f6c, 0x5104, 0x61b6, 0x6291, 0x6a8d, 0x81c6, 0x5043, 0x5830, 0x5f66, 0x7109, 0x8a00, 0x8afa, 0x5b7c, 0x8616, 0x4ffa, 
/* 0xe5f0 */
0x513c, 0x56b4, 0x5944, 0x63a9, 0x6df9, 0x5daa, 0x696d, 0x5186, 0x4e88, 0x4f59, 0xf97f, 0xf980, 0xf981, 0x5982, 0xf982, 
};
static struct cp2unicode_row korean_row_e5 = { 0xe5, 0xa1, 0x5e, korean_row_codes_e5 };
static unicode_t korean_row_codes_e6[] =
{
/* 0xe6a1 */
0xf983, 0x6b5f, 0x6c5d, 0xf984, 0x74b5, 0x7916, 0xf985, 0x8207, 0x8245, 0x8339, 0x8f3f, 0x8f5d, 0xf986, 0x9918, 0xf987, 
/* 0xe6b0 */
0xf988, 0xf989, 0x4ea6, 0xf98a, 0x57df, 0x5f79, 0x6613, 0xf98b, 0xf98c, 0x75ab, 0x7e79, 0x8b6f, 0xf98d, 0x9006, 0x9a5b, 0x56a5, 
/* 0xe6c0 */
0x5827, 0x59f8, 0x5a1f, 0x5bb4, 0xf98e, 0x5ef6, 0xf98f, 0xf990, 0x6350, 0x633b, 0xf991, 0x693d, 0x6c87, 0x6cbf, 0x6d8e, 0x6d93, 
/* 0xe6d0 */
0x6df5, 0x6f14, 0xf992, 0x70df, 0x7136, 0x7159, 0xf993, 0x71c3, 0x71d5, 0xf994, 0x784f, 0x786f, 0xf995, 0x7b75, 0x7de3, 0xf996, 
/* 0xe6e0 */
0x7e2f, 0xf997, 0x884d, 0x8edf, 0xf998, 0xf999, 0xf99a, 0x925b, 0xf99b, 0x9cf6, 0xf99c, 0xf99d, 0xf99e, 0x6085, 0x6d85, 0xf99f, 
/* 0xe6f0 */
0x71b1, 0xf9a0, 0xf9a1, 0x95b1, 0x53ad, 0xf9a2, 0xf9a3, 0xf9a4, 0x67d3, 0xf9a5, 0x708e, 0x7130, 0x7430, 0x8276, 0x82d2, 
};
static struct cp2unicode_row korean_row_e6 = { 0xe6, 0xa1, 0x5e, korean_row_codes_e6 };
static unicode_t korean_row_codes_e7[] =
{
/* 0xe7a1 */
0xf9a6, 0x95bb, 0x9ae5, 0x9e7d, 0x66c4, 0xf9a7, 0x71c1, 0x8449, 0xf9a8, 0xf9a9, 0x584b, 0xf9aa, 0xf9ab, 0x5db8, 0x5f71, 
/* 0xe7b0 */
0xf9ac, 0x6620, 0x668e, 0x6979, 0x69ae, 0x6c38, 0x6cf3, 0x6e36, 0x6f41, 0x6fda, 0x701b, 0x702f, 0x7150, 0x71df, 0x7370, 0xf9ad, 
/* 0xe7c0 */
0x745b, 0xf9ae, 0x74d4, 0x76c8, 0x7a4e, 0x7e93, 0xf9af, 0xf9b0, 0x82f1, 0x8a60, 0x8fce, 0xf9b1, 0x9348, 0xf9b2, 0x9719, 0xf9b3, 
/* 0xe7d0 */
0xf9b4, 0x4e42, 0x502a, 0xf9b5, 0x5208, 0x53e1, 0x66f3, 0x6c6d, 0x6fca, 0x730a, 0x777f, 0x7a62, 0x82ae, 0x85dd, 0x8602, 0xf9b6, 
/* 0xe7e0 */
0x88d4, 0x8a63, 0x8b7d, 0x8c6b, 0xf9b7, 0x92b3, 0xf9b8, 0x9713, 0x9810, 0x4e94, 0x4f0d, 0x4fc9, 0x50b2, 0x5348, 0x543e, 0x5433, 
/* 0xe7f0 */
0x55da, 0x5862, 0x58ba, 0x5967, 0x5a1b, 0x5be4, 0x609f, 0xf9b9, 0x61ca, 0x6556, 0x65ff, 0x6664, 0x68a7, 0x6c5a, 0x6fb3, 
};
static struct cp2unicode_row korean_row_e7 = { 0xe7, 0xa1, 0x5e, korean_row_codes_e7 };
static unicode_t korean_row_codes_e8[] =
{
/* 0xe8a1 */
0x70cf, 0x71ac, 0x7352, 0x7b7d, 0x8708, 0x8aa4, 0x9c32, 0x9f07, 0x5c4b, 0x6c83, 0x7344, 0x7389, 0x923a, 0x6eab, 0x7465, 
/* 0xe8b0 */
0x761f, 0x7a69, 0x7e15, 0x860a, 0x5140, 0x58c5, 0x64c1, 0x74ee, 0x7515, 0x7670, 0x7fc1, 0x9095, 0x96cd, 0x9954, 0x6e26, 0x74e6, 
/* 0xe8c0 */
0x7aa9, 0x7aaa, 0x81e5, 0x86d9, 0x8778, 0x8a1b, 0x5a49, 0x5b8c, 0x5b9b, 0x68a1, 0x6900, 0x6d63, 0x73a9, 0x7413, 0x742c, 0x7897, 
/* 0xe8d0 */
0x7de9, 0x7feb, 0x8118, 0x8155, 0x839e, 0x8c4c, 0x962e, 0x9811, 0x66f0, 0x5f80, 0x65fa, 0x6789, 0x6c6a, 0x738b, 0x502d, 0x5a03, 
/* 0xe8e0 */
0x6b6a, 0x77ee, 0x5916, 0x5d6c, 0x5dcd, 0x7325, 0x754f, 0xf9ba, 0xf9bb, 0x50e5, 0x51f9, 0x582f, 0x592d, 0x5996, 0x59da, 0x5be5, 
/* 0xe8f0 */
0xf9bc, 0xf9bd, 0x5da2, 0x62d7, 0x6416, 0x6493, 0x64fe, 0xf9be, 0x66dc, 0xf9bf, 0x6a48, 0xf9c0, 0x71ff, 0x7464, 0xf9c1, 
};
static struct cp2unicode_row korean_row_e8 = { 0xe8, 0xa1, 0x5e, korean_row_codes_e8 };
static unicode_t korean_row_codes_e9[] =
{
/* 0xe9a1 */
0x7a88, 0x7aaf, 0x7e47, 0x7e5e, 0x8000, 0x8170, 0xf9c2, 0x87ef, 0x8981, 0x8b20, 0x9059, 0xf9c3, 0x9080, 0x9952, 0x617e, 
/* 0xe9b0 */
0x6b32, 0x6d74, 0x7e1f, 0x8925, 0x8fb1, 0x4fd1, 0x50ad, 0x5197, 0x52c7, 0x57c7, 0x5889, 0x5bb9, 0x5eb8, 0x6142, 0x6995, 0x6d8c, 
/* 0xe9c0 */
0x6e67, 0x6eb6, 0x7194, 0x7462, 0x7528, 0x752c, 0x8073, 0x8338, 0x84c9, 0x8e0a, 0x9394, 0x93de, 0xf9c4, 0x4e8e, 0x4f51, 0x5076, 
/* 0xe9d0 */
0x512a, 0x53c8, 0x53cb, 0x53f3, 0x5b87, 0x5bd3, 0x5c24, 0x611a, 0x6182, 0x65f4, 0x725b, 0x7397, 0x7440, 0x76c2, 0x7950, 0x7991, 
/* 0xe9e0 */
0x79b9, 0x7d06, 0x7fbd, 0x828b, 0x85d5, 0x865e, 0x8fc2, 0x9047, 0x90f5, 0x91ea, 0x9685, 0x96e8, 0x96e9, 0x52d6, 0x5f67, 0x65ed, 
/* 0xe9f0 */
0x6631, 0x682f, 0x715c, 0x7a36, 0x90c1, 0x980a, 0x4e91, 0xf9c5, 0x6a52, 0x6b9e, 0x6f90, 0x7189, 0x8018, 0x82b8, 0x8553, 
};
static struct cp2unicode_row korean_row_e9 = { 0xe9, 0xa1, 0x5e, korean_row_codes_e9 };
static unicode_t korean_row_codes_ea[] =
{
/* 0xeaa1 */
0x904b, 0x9695, 0x96f2, 0x97fb, 0x851a, 0x9b31, 0x4e90, 0x718a, 0x96c4, 0x5143, 0x539f, 0x54e1, 0x5713, 0x5712, 0x57a3, 
/* 0xeab0 */
0x5a9b, 0x5ac4, 0x5bc3, 0x6028, 0x613f, 0x63f4, 0x6c85, 0x6d39, 0x6e72, 0x6e90, 0x7230, 0x733f, 0x7457, 0x82d1, 0x8881, 0x8f45, 
/* 0xeac0 */
0x9060, 0xf9c6, 0x9662, 0x9858, 0x9d1b, 0x6708, 0x8d8a, 0x925e, 0x4f4d, 0x5049, 0x50de, 0x5371, 0x570d, 0x59d4, 0x5a01, 0x5c09, 
/* 0xead0 */
0x6170, 0x6690, 0x6e2d, 0x7232, 0x744b, 0x7def, 0x80c3, 0x840e, 0x8466, 0x853f, 0x875f, 0x885b, 0x8918, 0x8b02, 0x9055, 0x97cb, 
/* 0xeae0 */
0x9b4f, 0x4e73, 0x4f91, 0x5112, 0x516a, 0xf9c7, 0x552f, 0x55a9, 0x5b7a, 0x5ba5, 0x5e7c, 0x5e7d, 0x5ebe, 0x60a0, 0x60df, 0x6108, 
/* 0xeaf0 */
0x6109, 0x63c4, 0x6538, 0x6709, 0xf9c8, 0x67d4, 0x67da, 0xf9c9, 0x6961, 0x6962, 0x6cb9, 0x6d27, 0xf9ca, 0x6e38, 0xf9cb, 
};
static struct cp2unicode_row korean_row_ea = { 0xea, 0xa1, 0x5e, korean_row_codes_ea };
static unicode_t korean_row_codes_eb[] =
{
/* 0xeba1 */
0x6fe1, 0x7336, 0x7337, 0xf9cc, 0x745c, 0x7531, 0xf9cd, 0x7652, 0xf9ce, 0xf9cf, 0x7dad, 0x81fe, 0x8438, 0x88d5, 0x8a98, 
/* 0xebb0 */
0x8adb, 0x8aed, 0x8e30, 0x8e42, 0x904a, 0x903e, 0x907a, 0x9149, 0x91c9, 0x936e, 0xf9d0, 0xf9d1, 0x5809, 0xf9d2, 0x6bd3, 0x8089, 
/* 0xebc0 */
0x80b2, 0xf9d3, 0xf9d4, 0x5141, 0x596b, 0x5c39, 0xf9d5, 0xf9d6, 0x6f64, 0x73a7, 0x80e4, 0x8d07, 0xf9d7, 0x9217, 0x958f, 0xf9d8, 
/* 0xebd0 */
0xf9d9, 0xf9da, 0xf9db, 0x807f, 0x620e, 0x701c, 0x7d68, 0x878d, 0xf9dc, 0x57a0, 0x6069, 0x6147, 0x6bb7, 0x8abe, 0x9280, 0x96b1, 
/* 0xebe0 */
0x4e59, 0x541f, 0x6deb, 0x852d, 0x9670, 0x97f3, 0x98ee, 0x63d6, 0x6ce3, 0x9091, 0x51dd, 0x61c9, 0x81ba, 0x9df9, 0x4f9d, 0x501a, 
/* 0xebf0 */
0x5100, 0x5b9c, 0x610f, 0x61ff, 0x64ec, 0x6905, 0x6bc5, 0x7591, 0x77e3, 0x7fa9, 0x8264, 0x858f, 0x87fb, 0x8863, 0x8abc, 
};
static struct cp2unicode_row korean_row_eb = { 0xeb, 0xa1, 0x5e, korean_row_codes_eb };
static unicode_t korean_row_codes_ec[] =
{
/* 0xeca1 */
0x8b70, 0x91ab, 0x4e8c, 0x4ee5, 0x4f0a, 0xf9dd, 0xf9de, 0x5937, 0x59e8, 0xf9df, 0x5df2, 0x5f1b, 0x5f5b, 0x6021, 0xf9e0, 
/* 0xecb0 */
0xf9e1, 0xf9e2, 0xf9e3, 0x723e, 0x73e5, 0xf9e4, 0x7570, 0x75cd, 0xf9e5, 0x79fb, 0xf9e6, 0x800c, 0x8033, 0x8084, 0x82e1, 0x8351, 
/* 0xecc0 */
0xf9e7, 0xf9e8, 0x8cbd, 0x8cb3, 0x9087, 0xf9e9, 0xf9ea, 0x98f4, 0x990c, 0xf9eb, 0xf9ec, 0x7037, 0x76ca, 0x7fca, 0x7fcc, 0x7ffc, 
/* 0xecd0 */
0x8b1a, 0x4eba, 0x4ec1, 0x5203, 0x5370, 0xf9ed, 0x54bd, 0x56e0, 0x59fb, 0x5bc5, 0x5f15, 0x5fcd, 0x6e6e, 0xf9ee, 0xf9ef, 0x7d6a, 
/* 0xece0 */
0x8335, 0xf9f0, 0x8693, 0x8a8d, 0xf9f1, 0x976d, 0x9777, 0xf9f2, 0xf9f3, 0x4e00, 0x4f5a, 0x4f7e, 0x58f9, 0x65e5, 0x6ea2, 0x9038, 
/* 0xecf0 */
0x93b0, 0x99b9, 0x4efb, 0x58ec, 0x598a, 0x59d9, 0x6041, 0xf9f4, 0xf9f5, 0x7a14, 0xf9f6, 0x834f, 0x8cc3, 0x5165, 0x5344, 
};
static struct cp2unicode_row korean_row_ec = { 0xec, 0xa1, 0x5e, korean_row_codes_ec };
static unicode_t korean_row_codes_ed[] =
{
/* 0xeda1 */
0xf9f7, 0xf9f8, 0xf9f9, 0x4ecd, 0x5269, 0x5b55, 0x82bf, 0x4ed4, 0x523a, 0x54a8, 0x59c9, 0x59ff, 0x5b50, 0x5b57, 0x5b5c, 
/* 0xedb0 */
0x6063, 0x6148, 0x6ecb, 0x7099, 0x716e, 0x7386, 0x74f7, 0x75b5, 0x78c1, 0x7d2b, 0x8005, 0x81ea, 0x8328, 0x8517, 0x85c9, 0x8aee, 
/* 0xedc0 */
0x8cc7, 0x96cc, 0x4f5c, 0x52fa, 0x56bc, 0x65ab, 0x6628, 0x707c, 0x70b8, 0x7235, 0x7dbd, 0x828d, 0x914c, 0x96c0, 0x9d72, 0x5b71, 
/* 0xedd0 */
0x68e7, 0x6b98, 0x6f7a, 0x76de, 0x5c91, 0x66ab, 0x6f5b, 0x7bb4, 0x7c2a, 0x8836, 0x96dc, 0x4e08, 0x4ed7, 0x5320, 0x5834, 0x58bb, 
/* 0xede0 */
0x58ef, 0x596c, 0x5c07, 0x5e33, 0x5e84, 0x5f35, 0x638c, 0x66b2, 0x6756, 0x6a1f, 0x6aa3, 0x6b0c, 0x6f3f, 0x7246, 0xf9fa, 0x7350, 
/* 0xedf0 */
0x748b, 0x7ae0, 0x7ca7, 0x8178, 0x81df, 0x81e7, 0x838a, 0x846c, 0x8523, 0x8594, 0x85cf, 0x88dd, 0x8d13, 0x91ac, 0x9577, 
};
static struct cp2unicode_row korean_row_ed = { 0xed, 0xa1, 0x5e, korean_row_codes_ed };
static unicode_t korean_row_codes_ee[] =
{
/* 0xeea1 */
0x969c, 0x518d, 0x54c9, 0x5728, 0x5bb0, 0x624d, 0x6750, 0x683d, 0x6893, 0x6e3d, 0x6ed3, 0x707d, 0x7e21, 0x88c1, 0x8ca1, 
/* 0xeeb0 */
0x8f09, 0x9f4b, 0x9f4e, 0x722d, 0x7b8f, 0x8acd, 0x931a, 0x4f47, 0x4f4e, 0x5132, 0x5480, 0x59d0, 0x5e95, 0x62b5, 0x6775, 0x696e, 
/* 0xeec0 */
0x6a17, 0x6cae, 0x6e1a, 0x72d9, 0x732a, 0x75bd, 0x7bb8, 0x7d35, 0x82e7, 0x83f9, 0x8457, 0x85f7, 0x8a5b, 0x8caf, 0x8e87, 0x9019, 
/* 0xeed0 */
0x90b8, 0x96ce, 0x9f5f, 0x52e3, 0x540a, 0x5ae1, 0x5bc2, 0x6458, 0x6575, 0x6ef4, 0x72c4, 0xf9fb, 0x7684, 0x7a4d, 0x7b1b, 0x7c4d, 
/* 0xeee0 */
0x7e3e, 0x7fdf, 0x837b, 0x8b2b, 0x8cca, 0x8d64, 0x8de1, 0x8e5f, 0x8fea, 0x8ff9, 0x9069, 0x93d1, 0x4f43, 0x4f7a, 0x50b3, 0x5168, 
/* 0xeef0 */
0x5178, 0x524d, 0x526a, 0x5861, 0x587c, 0x5960, 0x5c08, 0x5c55, 0x5edb, 0x609b, 0x6230, 0x6813, 0x6bbf, 0x6c08, 0x6fb1, 
};
static struct cp2unicode_row korean_row_ee = { 0xee, 0xa1, 0x5e, korean_row_codes_ee };
static unicode_t korean_row_codes_ef[] =
{
/* 0xefa1 */
0x714e, 0x7420, 0x7530, 0x7538, 0x7551, 0x7672, 0x7b4c, 0x7b8b, 0x7bad, 0x7bc6, 0x7e8f, 0x8a6e, 0x8f3e, 0x8f49, 0x923f, 
/* 0xefb0 */
0x9293, 0x9322, 0x942b, 0x96fb, 0x985a, 0x986b, 0x991e, 0x5207, 0x622a, 0x6298, 0x6d59, 0x7664, 0x7aca, 0x7bc0, 0x7d76, 0x5360, 
/* 0xefc0 */
0x5cbe, 0x5e97, 0x6f38, 0x70b9, 0x7c98, 0x9711, 0x9b8e, 0x9ede, 0x63a5, 0x647a, 0x8776, 0x4e01, 0x4e95, 0x4ead, 0x505c, 0x5075, 
/* 0xefd0 */
0x5448, 0x59c3, 0x5b9a, 0x5e40, 0x5ead, 0x5ef7, 0x5f81, 0x60c5, 0x633a, 0x653f, 0x6574, 0x65cc, 0x6676, 0x6678, 0x67fe, 0x6968, 
/* 0xefe0 */
0x6a89, 0x6b63, 0x6c40, 0x6dc0, 0x6de8, 0x6e1f, 0x6e5e, 0x701e, 0x70a1, 0x738e, 0x73fd, 0x753a, 0x775b, 0x7887, 0x798e, 0x7a0b, 
/* 0xeff0 */
0x7a7d, 0x7cbe, 0x7d8e, 0x8247, 0x8a02, 0x8aea, 0x8c9e, 0x912d, 0x914a, 0x91d8, 0x9266, 0x92cc, 0x9320, 0x9706, 0x9756, 
};
static struct cp2unicode_row korean_row_ef = { 0xef, 0xa1, 0x5e, korean_row_codes_ef };
static unicode_t korean_row_codes_f0[] =
{
/* 0xf0a1 */
0x975c, 0x9802, 0x9f0e, 0x5236, 0x5291, 0x557c, 0x5824, 0x5e1d, 0x5f1f, 0x608c, 0x63d0, 0x68af, 0x6fdf, 0x796d, 0x7b2c, 
/* 0xf0b0 */
0x81cd, 0x85ba, 0x88fd, 0x8af8, 0x8e44, 0x918d, 0x9664, 0x969b, 0x973d, 0x984c, 0x9f4a, 0x4fce, 0x5146, 0x51cb, 0x52a9, 0x5632, 
/* 0xf0c0 */
0x5f14, 0x5f6b, 0x63aa, 0x64cd, 0x65e9, 0x6641, 0x66fa, 0x66f9, 0x671d, 0x689d, 0x68d7, 0x69fd, 0x6f15, 0x6f6e, 0x7167, 0x71e5, 
/* 0xf0d0 */
0x722a, 0x74aa, 0x773a, 0x7956, 0x795a, 0x79df, 0x7a20, 0x7a95, 0x7c97, 0x7cdf, 0x7d44, 0x7e70, 0x8087, 0x85fb, 0x86a4, 0x8a54, 
/* 0xf0e0 */
0x8abf, 0x8d99, 0x8e81, 0x9020, 0x906d, 0x91e3, 0x963b, 0x96d5, 0x9ce5, 0x65cf, 0x7c07, 0x8db3, 0x93c3, 0x5b58, 0x5c0a, 0x5352, 
/* 0xf0f0 */
0x62d9, 0x731d, 0x5027, 0x5b97, 0x5f9e, 0x60b0, 0x616b, 0x68d5, 0x6dd9, 0x742e, 0x7a2e, 0x7d42, 0x7d9c, 0x7e31, 0x816b, 
};
static struct cp2unicode_row korean_row_f0 = { 0xf0, 0xa1, 0x5e, korean_row_codes_f0 };
static unicode_t korean_row_codes_f1[] =
{
/* 0xf1a1 */
0x8e2a, 0x8e35, 0x937e, 0x9418, 0x4f50, 0x5750, 0x5de6, 0x5ea7, 0x632b, 0x7f6a, 0x4e3b, 0x4f4f, 0x4f8f, 0x505a, 0x59dd, 
/* 0xf1b0 */
0x80c4, 0x546a, 0x5468, 0x55fe, 0x594f, 0x5b99, 0x5dde, 0x5eda, 0x665d, 0x6731, 0x67f1, 0x682a, 0x6ce8, 0x6d32, 0x6e4a, 0x6f8d, 
/* 0xf1c0 */
0x70b7, 0x73e0, 0x7587, 0x7c4c, 0x7d02, 0x7d2c, 0x7da2, 0x821f, 0x86db, 0x8a3b, 0x8a85, 0x8d70, 0x8e8a, 0x8f33, 0x9031, 0x914e, 
/* 0xf1d0 */
0x9152, 0x9444, 0x99d0, 0x7af9, 0x7ca5, 0x4fca, 0x5101, 0x51c6, 0x57c8, 0x5bef, 0x5cfb, 0x6659, 0x6a3d, 0x6d5a, 0x6e96, 0x6fec, 
/* 0xf1e0 */
0x710c, 0x756f, 0x7ae3, 0x8822, 0x9021, 0x9075, 0x96cb, 0x99ff, 0x8301, 0x4e2d, 0x4ef2, 0x8846, 0x91cd, 0x537d, 0x6adb, 0x696b, 
/* 0xf1f0 */
0x6c41, 0x847a, 0x589e, 0x618e, 0x66fe, 0x62ef, 0x70dd, 0x7511, 0x75c7, 0x7e52, 0x84b8, 0x8b49, 0x8d08, 0x4e4b, 0x53ea, 
};
static struct cp2unicode_row korean_row_f1 = { 0xf1, 0xa1, 0x5e, korean_row_codes_f1 };
static unicode_t korean_row_codes_f2[] =
{
/* 0xf2a1 */
0x54ab, 0x5730, 0x5740, 0x5fd7, 0x6301, 0x6307, 0x646f, 0x652f, 0x65e8, 0x667a, 0x679d, 0x67b3, 0x6b62, 0x6c60, 0x6c9a, 
/* 0xf2b0 */
0x6f2c, 0x77e5, 0x7825, 0x7949, 0x7957, 0x7d19, 0x80a2, 0x8102, 0x81f3, 0x829d, 0x82b7, 0x8718, 0x8a8c, 0xf9fc, 0x8d04, 0x8dbe, 
/* 0xf2c0 */
0x9072, 0x76f4, 0x7a19, 0x7a37, 0x7e54, 0x8077, 0x5507, 0x55d4, 0x5875, 0x632f, 0x6422, 0x6649, 0x664b, 0x686d, 0x699b, 0x6b84, 
/* 0xf2d0 */
0x6d25, 0x6eb1, 0x73cd, 0x7468, 0x74a1, 0x755b, 0x75b9, 0x76e1, 0x771e, 0x778b, 0x79e6, 0x7e09, 0x7e1d, 0x81fb, 0x852f, 0x8897, 
/* 0xf2e0 */
0x8a3a, 0x8cd1, 0x8eeb, 0x8fb0, 0x9032, 0x93ad, 0x9663, 0x9673, 0x9707, 0x4f84, 0x53f1, 0x59ea, 0x5ac9, 0x5e19, 0x684e, 0x74c6, 
/* 0xf2f0 */
0x75be, 0x79e9, 0x7a92, 0x81a3, 0x86ed, 0x8cea, 0x8dcc, 0x8fed, 0x659f, 0x6715, 0xf9fd, 0x57f7, 0x6f57, 0x7ddd, 0x8f2f, 
};
static struct cp2unicode_row korean_row_f2 = { 0xf2, 0xa1, 0x5e, korean_row_codes_f2 };
static unicode_t korean_row_codes_f3[] =
{
/* 0xf3a1 */
0x93f6, 0x96c6, 0x5fb5, 0x61f2, 0x6f84, 0x4e14, 0x4f98, 0x501f, 0x53c9, 0x55df, 0x5d6f, 0x5dee, 0x6b21, 0x6b64, 0x78cb, 
/* 0xf3b0 */
0x7b9a, 0xf9fe, 0x8e49, 0x8eca, 0x906e, 0x6349, 0x643e, 0x7740, 0x7a84, 0x932f, 0x947f, 0x9f6a, 0x64b0, 0x6faf, 0x71e6, 0x74a8, 
/* 0xf3c0 */
0x74da, 0x7ac4, 0x7c12, 0x7e82, 0x7cb2, 0x7e98, 0x8b9a, 0x8d0a, 0x947d, 0x9910, 0x994c, 0x5239, 0x5bdf, 0x64e6, 0x672d, 0x7d2e, 
/* 0xf3d0 */
0x50ed, 0x53c3, 0x5879, 0x6158, 0x6159, 0x61fa, 0x65ac, 0x7ad9, 0x8b92, 0x8b96, 0x5009, 0x5021, 0x5275, 0x5531, 0x5a3c, 0x5ee0, 
/* 0xf3e0 */
0x5f70, 0x6134, 0x655e, 0x660c, 0x6636, 0x66a2, 0x69cd, 0x6ec4, 0x6f32, 0x7316, 0x7621, 0x7a93, 0x8139, 0x8259, 0x83d6, 0x84bc, 
/* 0xf3f0 */
0x50b5, 0x57f0, 0x5bc0, 0x5be8, 0x5f69, 0x63a1, 0x7826, 0x7db5, 0x83dc, 0x8521, 0x91c7, 0x91f5, 0x518a, 0x67f5, 0x7b56, 
};
static struct cp2unicode_row korean_row_f3 = { 0xf3, 0xa1, 0x5e, korean_row_codes_f3 };
static unicode_t korean_row_codes_f4[] =
{
/* 0xf4a1 */
0x8cac, 0x51c4, 0x59bb, 0x60bd, 0x8655, 0x501c, 0xf9ff, 0x5254, 0x5c3a, 0x617d, 0x621a, 0x62d3, 0x64f2, 0x65a5, 0x6ecc, 
/* 0xf4b0 */
0x7620, 0x810a, 0x8e60, 0x965f, 0x96bb, 0x4edf, 0x5343, 0x5598, 0x5929, 0x5ddd, 0x64c5, 0x6cc9, 0x6dfa, 0x7394, 0x7a7f, 0x821b, 
/* 0xf4c0 */
0x85a6, 0x8ce4, 0x8e10, 0x9077, 0x91e7, 0x95e1, 0x9621, 0x97c6, 0x51f8, 0x54f2, 0x5586, 0x5fb9, 0x64a4, 0x6f88, 0x7db4, 0x8f1f, 
/* 0xf4d0 */
0x8f4d, 0x9435, 0x50c9, 0x5c16, 0x6cbe, 0x6dfb, 0x751b, 0x77bb, 0x7c3d, 0x7c64, 0x8a79, 0x8ac2, 0x581e, 0x59be, 0x5e16, 0x6377, 
/* 0xf4e0 */
0x7252, 0x758a, 0x776b, 0x8adc, 0x8cbc, 0x8f12, 0x5ef3, 0x6674, 0x6df8, 0x807d, 0x83c1, 0x8acb, 0x9751, 0x9bd6, 0xfa00, 0x5243, 
/* 0xf4f0 */
0x66ff, 0x6d95, 0x6eef, 0x7de0, 0x8ae6, 0x902e, 0x905e, 0x9ad4, 0x521d, 0x527f, 0x54e8, 0x6194, 0x6284, 0x62db, 0x68a2, 
};
static struct cp2unicode_row korean_row_f4 = { 0xf4, 0xa1, 0x5e, korean_row_codes_f4 };
static unicode_t korean_row_codes_f5[] =
{
/* 0xf5a1 */
0x6912, 0x695a, 0x6a35, 0x7092, 0x7126, 0x785d, 0x7901, 0x790e, 0x79d2, 0x7a0d, 0x8096, 0x8278, 0x82d5, 0x8349, 0x8549, 
/* 0xf5b0 */
0x8c82, 0x8d85, 0x9162, 0x918b, 0x91ae, 0x4fc3, 0x56d1, 0x71ed, 0x77d7, 0x8700, 0x89f8, 0x5bf8, 0x5fd6, 0x6751, 0x90a8, 0x53e2, 
/* 0xf5c0 */
0x585a, 0x5bf5, 0x60a4, 0x6181, 0x6460, 0x7e3d, 0x8070, 0x8525, 0x9283, 0x64ae, 0x50ac, 0x5d14, 0x6700, 0x589c, 0x62bd, 0x63a8, 
/* 0xf5d0 */
0x690e, 0x6978, 0x6a1e, 0x6e6b, 0x76ba, 0x79cb, 0x82bb, 0x8429, 0x8acf, 0x8da8, 0x8ffd, 0x9112, 0x914b, 0x919c, 0x9310, 0x9318, 
/* 0xf5e0 */
0x939a, 0x96db, 0x9a36, 0x9c0d, 0x4e11, 0x755c, 0x795d, 0x7afa, 0x7b51, 0x7bc9, 0x7e2e, 0x84c4, 0x8e59, 0x8e74, 0x8ef8, 0x9010, 
/* 0xf5f0 */
0x6625, 0x693f, 0x7443, 0x51fa, 0x672e, 0x9edc, 0x5145, 0x5fe0, 0x6c96, 0x87f2, 0x885d, 0x8877, 0x60b4, 0x81b5, 0x8403, 
};
static struct cp2unicode_row korean_row_f5 = { 0xf5, 0xa1, 0x5e, korean_row_codes_f5 };
static unicode_t korean_row_codes_f6[] =
{
/* 0xf6a1 */
0x8d05, 0x53d6, 0x5439, 0x5634, 0x5a36, 0x5c31, 0x708a, 0x7fe0, 0x805a, 0x8106, 0x81ed, 0x8da3, 0x9189, 0x9a5f, 0x9df2, 
/* 0xf6b0 */
0x5074, 0x4ec4, 0x53a0, 0x60fb, 0x6e2c, 0x5c64, 0x4f88, 0x5024, 0x55e4, 0x5cd9, 0x5e5f, 0x6065, 0x6894, 0x6cbb, 0x6dc4, 0x71be, 
/* 0xf6c0 */
0x75d4, 0x75f4, 0x7661, 0x7a1a, 0x7a49, 0x7dc7, 0x7dfb, 0x7f6e, 0x81f4, 0x86a9, 0x8f1c, 0x96c9, 0x99b3, 0x9f52, 0x5247, 0x52c5, 
/* 0xf6d0 */
0x98ed, 0x89aa, 0x4e03, 0x67d2, 0x6f06, 0x4fb5, 0x5be2, 0x6795, 0x6c88, 0x6d78, 0x741b, 0x7827, 0x91dd, 0x937c, 0x87c4, 0x79e4, 
/* 0xf6e0 */
0x7a31, 0x5feb, 0x4ed6, 0x54a4, 0x553e, 0x58ae, 0x59a5, 0x60f0, 0x6253, 0x62d6, 0x6736, 0x6955, 0x8235, 0x9640, 0x99b1, 0x99dd, 
/* 0xf6f0 */
0x502c, 0x5353, 0x5544, 0x577c, 0xfa01, 0x6258, 0xfa02, 0x64e2, 0x666b, 0x67dd, 0x6fc1, 0x6fef, 0x7422, 0x7438, 0x8a17, 
};
static struct cp2unicode_row korean_row_f6 = { 0xf6, 0xa1, 0x5e, korean_row_codes_f6 };
static unicode_t korean_row_codes_f7[] =
{
/* 0xf7a1 */
0x9438, 0x5451, 0x5606, 0x5766, 0x5f48, 0x619a, 0x6b4e, 0x7058, 0x70ad, 0x7dbb, 0x8a95, 0x596a, 0x812b, 0x63a2, 0x7708, 
/* 0xf7b0 */
0x803d, 0x8caa, 0x5854, 0x642d, 0x69bb, 0x5b95, 0x5e11, 0x6e6f, 0xfa03, 0x8569, 0x514c, 0x53f0, 0x592a, 0x6020, 0x614b, 0x6b86, 
/* 0xf7c0 */
0x6c70, 0x6cf0, 0x7b1e, 0x80ce, 0x82d4, 0x8dc6, 0x90b0, 0x98b1, 0xfa04, 0x64c7, 0x6fa4, 0x6491, 0x6504, 0x514e, 0x5410, 0x571f, 
/* 0xf7d0 */
0x8a0e, 0x615f, 0x6876, 0xfa05, 0x75db, 0x7b52, 0x7d71, 0x901a, 0x5806, 0x69cc, 0x817f, 0x892a, 0x9000, 0x9839, 0x5078, 0x5957, 
/* 0xf7e0 */
0x59ac, 0x6295, 0x900f, 0x9b2a, 0x615d, 0x7279, 0x95d6, 0x5761, 0x5a46, 0x5df4, 0x628a, 0x64ad, 0x64fa, 0x6777, 0x6ce2, 0x6d3e, 
/* 0xf7f0 */
0x722c, 0x7436, 0x7834, 0x7f77, 0x82ad, 0x8ddb, 0x9817, 0x5224, 0x5742, 0x677f, 0x7248, 0x74e3, 0x8ca9, 0x8fa6, 0x9211, 
};
static struct cp2unicode_row korean_row_f7 = { 0xf7, 0xa1, 0x5e, korean_row_codes_f7 };
static unicode_t korean_row_codes_f8[] =
{
/* 0xf8a1 */
0x962a, 0x516b, 0x53ed, 0x634c, 0x4f69, 0x5504, 0x6096, 0x6557, 0x6c9b, 0x6d7f, 0x724c, 0x72fd, 0x7a17, 0x8987, 0x8c9d, 
/* 0xf8b0 */
0x5f6d, 0x6f8e, 0x70f9, 0x81a8, 0x610e, 0x4fbf, 0x504f, 0x6241, 0x7247, 0x7bc7, 0x7de8, 0x7fe9, 0x904d, 0x97ad, 0x9a19, 0x8cb6, 
/* 0xf8c0 */
0x576a, 0x5e73, 0x67b0, 0x840d, 0x8a55, 0x5420, 0x5b16, 0x5e63, 0x5ee2, 0x5f0a, 0x6583, 0x80ba, 0x853d, 0x9589, 0x965b, 0x4f48, 
/* 0xf8d0 */
0x5305, 0x530d, 0x530f, 0x5486, 0x54fa, 0x5703, 0x5e03, 0x6016, 0x629b, 0x62b1, 0x6355, 0xfa06, 0x6ce1, 0x6d66, 0x75b1, 0x7832, 
/* 0xf8e0 */
0x80de, 0x812f, 0x82de, 0x8461, 0x84b2, 0x888d, 0x8912, 0x900b, 0x92ea, 0x98fd, 0x9b91, 0x5e45, 0x66b4, 0x66dd, 0x7011, 0x7206, 
/* 0xf8f0 */
0xfa07, 0x4ff5, 0x527d, 0x5f6a, 0x6153, 0x6753, 0x6a19, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8c79, 0x98c7, 0x98c4, 0x9a43, 
};
static struct cp2unicode_row korean_row_f8 = { 0xf8, 0xa1, 0x5e, korean_row_codes_f8 };
static unicode_t korean_row_codes_f9[] =
{
/* 0xf9a1 */
0x54c1, 0x7a1f, 0x6953, 0x8af7, 0x8c4a, 0x98a8, 0x99ae, 0x5f7c, 0x62ab, 0x75b2, 0x76ae, 0x88ab, 0x907f, 0x9642, 0x5339, 
/* 0xf9b0 */
0x5f3c, 0x5fc5, 0x6ccc, 0x73cc, 0x7562, 0x758b, 0x7b46, 0x82fe, 0x999d, 0x4e4f, 0x903c, 0x4e0b, 0x4f55, 0x53a6, 0x590f, 0x5ec8, 
/* 0xf9c0 */
0x6630, 0x6cb3, 0x7455, 0x8377, 0x8766, 0x8cc0, 0x9050, 0x971e, 0x9c15, 0x58d1, 0x5b78, 0x8650, 0x8b14, 0x9db4, 0x5bd2, 0x6068, 
/* 0xf9d0 */
0x608d, 0x65f1, 0x6c57, 0x6f22, 0x6fa3, 0x701a, 0x7f55, 0x7ff0, 0x9591, 0x9592, 0x9650, 0x97d3, 0x5272, 0x8f44, 0x51fd, 0x542b, 
/* 0xf9e0 */
0x54b8, 0x5563, 0x558a, 0x6abb, 0x6db5, 0x7dd8, 0x8266, 0x929c, 0x9677, 0x9e79, 0x5408, 0x54c8, 0x76d2, 0x86e4, 0x95a4, 0x95d4, 
/* 0xf9f0 */
0x965c, 0x4ea2, 0x4f09, 0x59ee, 0x5ae6, 0x5df7, 0x6052, 0x6297, 0x676d, 0x6841, 0x6c86, 0x6e2f, 0x7f38, 0x809b, 0x822a, 
};
static struct cp2unicode_row korean_row_f9 = { 0xf9, 0xa1, 0x5e, korean_row_codes_f9 };
static unicode_t korean_row_codes_fa[] =
{
/* 0xfaa1 */
0xfa08, 0xfa09, 0x9805, 0x4ea5, 0x5055, 0x54b3, 0x5793, 0x595a, 0x5b69, 0x5bb3, 0x61c8, 0x6977, 0x6d77, 0x7023, 0x87f9, 
/* 0xfab0 */
0x89e3, 0x8a72, 0x8ae7, 0x9082, 0x99ed, 0x9ab8, 0x52be, 0x6838, 0x5016, 0x5e78, 0x674f, 0x8347, 0x884c, 0x4eab, 0x5411, 0x56ae, 
/* 0xfac0 */
0x73e6, 0x9115, 0x97ff, 0x9909, 0x9957, 0x9999, 0x5653, 0x589f, 0x865b, 0x8a31, 0x61b2, 0x6af6, 0x737b, 0x8ed2, 0x6b47, 0x96aa, 
/* 0xfad0 */
0x9a57, 0x5955, 0x7200, 0x8d6b, 0x9769, 0x4fd4, 0x5cf4, 0x5f26, 0x61f8, 0x665b, 0x6ceb, 0x70ab, 0x7384, 0x73b9, 0x73fe, 0x7729, 
/* 0xfae0 */
0x774d, 0x7d43, 0x7d62, 0x7e23, 0x8237, 0x8852, 0xfa0a, 0x8ce2, 0x9249, 0x986f, 0x5b51, 0x7a74, 0x8840, 0x9801, 0x5acc, 0x4fe0, 
/* 0xfaf0 */
0x5354, 0x593e, 0x5cfd, 0x633e, 0x6d79, 0x72f9, 0x8105, 0x8107, 0x83a2, 0x92cf, 0x9830, 0x4ea8, 0x5144, 0x5211, 0x578b, 
};
static struct cp2unicode_row korean_row_fa = { 0xfa, 0xa1, 0x5e, korean_row_codes_fa };
static unicode_t korean_row_codes_fb[] =
{
/* 0xfba1 */
0x5f62, 0x6cc2, 0x6ece, 0x7005, 0x7050, 0x70af, 0x7192, 0x73e9, 0x7469, 0x834a, 0x87a2, 0x8861, 0x9008, 0x90a2, 0x93a3, 
/* 0xfbb0 */
0x99a8, 0x516e, 0x5f57, 0x60e0, 0x6167, 0x66b3, 0x8559, 0x8e4a, 0x91af, 0x978b, 0x4e4e, 0x4e92, 0x547c, 0x58d5, 0x58fa, 0x597d, 
/* 0xfbc0 */
0x5cb5, 0x5f27, 0x6236, 0x6248, 0x660a, 0x6667, 0x6beb, 0x6d69, 0x6dcf, 0x6e56, 0x6ef8, 0x6f94, 0x6fe0, 0x6fe9, 0x705d, 0x72d0, 
/* 0xfbd0 */
0x7425, 0x745a, 0x74e0, 0x7693, 0x795c, 0x7cca, 0x7e1e, 0x80e1, 0x82a6, 0x846b, 0x84bf, 0x864e, 0x865f, 0x8774, 0x8b77, 0x8c6a, 
/* 0xfbe0 */
0x93ac, 0x9800, 0x9865, 0x60d1, 0x6216, 0x9177, 0x5a5a, 0x660f, 0x6df7, 0x6e3e, 0x743f, 0x9b42, 0x5ffd, 0x60da, 0x7b0f, 0x54c4, 
/* 0xfbf0 */
0x5f18, 0x6c5e, 0x6cd3, 0x6d2a, 0x70d8, 0x7d05, 0x8679, 0x8a0c, 0x9d3b, 0x5316, 0x548c, 0x5b05, 0x6a3a, 0x706b, 0x7575, 
};
static struct cp2unicode_row korean_row_fb = { 0xfb, 0xa1, 0x5e, korean_row_codes_fb };
static unicode_t korean_row_codes_fc[] =
{
/* 0xfca1 */
0x798d, 0x79be, 0x82b1, 0x83ef, 0x8a71, 0x8b41, 0x8ca8, 0x9774, 0xfa0b, 0x64f4, 0x652b, 0x78ba, 0x78bb, 0x7a6b, 0x4e38, 
/* 0xfcb0 */
0x559a, 0x5950, 0x5ba6, 0x5e7b, 0x60a3, 0x63db, 0x6b61, 0x6665, 0x6853, 0x6e19, 0x7165, 0x74b0, 0x7d08, 0x9084, 0x9a69, 0x9c25, 
/* 0xfcc0 */
0x6d3b, 0x6ed1, 0x733e, 0x8c41, 0x95ca, 0x51f0, 0x5e4c, 0x5fa8, 0x604d, 0x60f6, 0x6130, 0x614c, 0x6643, 0x6644, 0x69a5, 0x6cc1, 
/* 0xfcd0 */
0x6e5f, 0x6ec9, 0x6f62, 0x714c, 0x749c, 0x7687, 0x7bc1, 0x7c27, 0x8352, 0x8757, 0x9051, 0x968d, 0x9ec3, 0x532f, 0x56de, 0x5efb, 
/* 0xfce0 */
0x5f8a, 0x6062, 0x6094, 0x61f7, 0x6666, 0x6703, 0x6a9c, 0x6dee, 0x6fae, 0x7070, 0x736a, 0x7e6a, 0x81be, 0x8334, 0x86d4, 0x8aa8, 
/* 0xfcf0 */
0x8cc4, 0x5283, 0x7372, 0x5b96, 0x6a6b, 0x9404, 0x54ee, 0x5686, 0x5b5d, 0x6548, 0x6585, 0x66c9, 0x689f, 0x6d8d, 0x6dc6, 
};
static struct cp2unicode_row korean_row_fc = { 0xfc, 0xa1, 0x5e, korean_row_codes_fc };
static unicode_t korean_row_codes_fd[] =
{
/* 0xfda1 */
0x723b, 0x80b4, 0x9175, 0x9a4d, 0x4faf, 0x5019, 0x539a, 0x540e, 0x543c, 0x5589, 0x55c5, 0x5e3f, 0x5f8c, 0x673d, 0x7166, 
/* 0xfdb0 */
0x73dd, 0x9005, 0x52db, 0x52f3, 0x5864, 0x58ce, 0x7104, 0x718f, 0x71fb, 0x85b0, 0x8a13, 0x6688, 0x85a8, 0x55a7, 0x6684, 0x714a, 
/* 0xfdc0 */
0x8431, 0x5349, 0x5599, 0x6bc1, 0x5f59, 0x5fbd, 0x63ee, 0x6689, 0x7147, 0x8af1, 0x8f1d, 0x9ebe, 0x4f11, 0x643a, 0x70cb, 0x7566, 
/* 0xfdd0 */
0x8667, 0x6064, 0x8b4e, 0x9df8, 0x5147, 0x51f6, 0x5308, 0x6d36, 0x80f8, 0x9ed1, 0x6615, 0x6b23, 0x7098, 0x75d5, 0x5403, 0x5c79, 
/* 0xfde0 */
0x7d07, 0x8a16, 0x6b20, 0x6b3d, 0x6b46, 0x5438, 0x6070, 0x6d3d, 0x7fd5, 0x8208, 0x50d6, 0x51de, 0x559c, 0x566b, 0x56cd, 0x59ec, 
/* 0xfdf0 */
0x5b09, 0x5e0c, 0x6199, 0x6198, 0x6231, 0x665e, 0x66e6, 0x7199, 0x71b9, 0x71ba, 0x72a7, 0x79a7, 0x7a00, 0x7fb2, 0x8a70, 
};
static struct cp2unicode_row korean_row_fd = { 0xfd, 0xa1, 0x5e, korean_row_codes_fd };

static struct cp2unicode_row *korean_row_array[] =
{
/* 0x0000 */
&korean_row_0, &korean_row_81, &korean_row_82, &korean_row_83, &korean_row_84, &korean_row_85, &korean_row_86, &korean_row_87, &korean_row_88, &korean_row_89, &korean_row_8a, &korean_row_8b, &korean_row_8c, &korean_row_8d, &korean_row_8e, &korean_row_8f, 
/* 0x0090 */
&korean_row_90, &korean_row_91, &korean_row_92, &korean_row_93, &korean_row_94, &korean_row_95, &korean_row_96, &korean_row_97, &korean_row_98, &korean_row_99, &korean_row_9a, &korean_row_9b, &korean_row_9c, &korean_row_9d, &korean_row_9e, &korean_row_9f, 
/* 0x00a0 */
&korean_row_a0, &korean_row_a1, &korean_row_a2, &korean_row_a3, &korean_row_a4, &korean_row_a5, &korean_row_a6, &korean_row_a7, &korean_row_a8, &korean_row_a9, &korean_row_aa, &korean_row_ab, &korean_row_ac, &korean_row_ad, &korean_row_ae, &korean_row_af, 
/* 0x00b0 */
&korean_row_b0, &korean_row_b1, &korean_row_b2, &korean_row_b3, &korean_row_b4, &korean_row_b5, &korean_row_b6, &korean_row_b7, &korean_row_b8, &korean_row_b9, &korean_row_ba, &korean_row_bb, &korean_row_bc, &korean_row_bd, &korean_row_be, &korean_row_bf, 
/* 0x00c0 */
&korean_row_c0, &korean_row_c1, &korean_row_c2, &korean_row_c3, &korean_row_c4, &korean_row_c5, &korean_row_c6, &korean_row_c7, &korean_row_c8, &korean_row_ca, &korean_row_cb, &korean_row_cc, &korean_row_cd, &korean_row_ce, &korean_row_cf, 
/* 0x00d0 */
&korean_row_d0, &korean_row_d1, &korean_row_d2, &korean_row_d3, &korean_row_d4, &korean_row_d5, &korean_row_d6, &korean_row_d7, &korean_row_d8, &korean_row_d9, &korean_row_da, &korean_row_db, &korean_row_dc, &korean_row_dd, &korean_row_de, &korean_row_df, 
/* 0x00e0 */
&korean_row_e0, &korean_row_e1, &korean_row_e2, &korean_row_e3, &korean_row_e4, &korean_row_e5, &korean_row_e6, &korean_row_e7, &korean_row_e8, &korean_row_e9, &korean_row_ea, &korean_row_eb, &korean_row_ec, &korean_row_ed, &korean_row_ee, &korean_row_ef, 
/* 0x00f0 */
&korean_row_f0, &korean_row_f1, &korean_row_f2, &korean_row_f3, &korean_row_f4, &korean_row_f5, &korean_row_f6, &korean_row_f7, &korean_row_f8, &korean_row_f9, &korean_row_fa, &korean_row_fb, &korean_row_fc, &korean_row_fd, 
};

struct cp2unicode korean_table = { 0x0, 0xfe, korean_row_array };
