#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006, 2008 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric, jskov
// Contributors: 
// Date:         2005-07-29
// Purpose:      Atmel AT91RM9200 DK/EK platform specific registers
// Description: 
// Usage:        #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <cyg/hal/atmel-at91rm9200-kits.h>
#include <pkgconf/hal_arm_arm9_at91rm9200.h>

//-----------------------------------------------------------------------------
// Address space translation macros
#define CYGARC_PHYSICAL_ADDRESS(_x_)                                                          \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                                                     \
 if (_p >= ATMEL_AT91RM9200_KITS_SDRAM_VIRT_BASE &&                                           \
     _p < (ATMEL_AT91RM9200_KITS_SDRAM_VIRT_BASE+ATMEL_AT91RM9200_KITS_SDRAM_SIZE))           \
     _p = (_p & ATMEL_AT91RM9200_KITS_SDRAM_MASK) + ATMEL_AT91RM9200_KITS_SDRAM_PHYS_BASE;    \
 else if (_p >= ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE &&                                       \
          _p < (ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE+ATMEL_AT91RM9200_KITS_SRAM_SIZE))        \
     _p = (_p & ATMEL_AT91RM9200_KITS_SRAM_MASK) + ATMEL_AT91RM9200_KITS_SRAM_PHYS_BASE;      \
 else if (_p >= ATMEL_AT91RM9200_KITS_FLASH_VIRT_BASE &&                                      \
          _p < (ATMEL_AT91RM9200_KITS_FLASH_VIRT_BASE+ATMEL_AT91RM9200_KITS_FLASH_SIZE))      \
     _p = (_p & ATMEL_AT91RM9200_KITS_FLASH_MASK) + ATMEL_AT91RM9200_KITS_FLASH_PHYS_BASE;    \
 else if (_p >= ATMEL_AT91RM9200_KITS_IROM_VIRT_BASE &&                                       \
          _p < (ATMEL_AT91RM9200_KITS_IROM_VIRT_BASE+ATMEL_AT91RM9200_KITS_IROM_SIZE))        \
     _p = (_p & ATMEL_AT91RM9200_KITS_IROM_MASK) + ATMEL_AT91RM9200_KITS_IROM_PHYS_BASE;      \
 else if (_p >= ATMEL_AT91RM9200_KITS_UHPREG_VIRT_BASE &&                                     \
          _p < (ATMEL_AT91RM9200_KITS_UHPREG_VIRT_BASE+ATMEL_AT91RM9200_KITS_UHPREG_SIZE))    \
     _p = (_p & ATMEL_AT91RM9200_KITS_UHPREG_MASK) + ATMEL_AT91RM9200_KITS_UHPREG_PHYS_BASE;  \
 _p; })

#define CYGARC_VIRTUAL_ADDRESS(_x_)                                                           \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                                                     \
 if (_p >= ATMEL_AT91RM9200_KITS_SDRAM_PHYS_BASE &&                                           \
     _p < (ATMEL_AT91RM9200_KITS_SDRAM_PHYS_BASE+ATMEL_AT91RM9200_KITS_SDRAM_SIZE))           \
     _p = (_p & ATMEL_AT91RM9200_KITS_SDRAM_MASK) + ATMEL_AT91RM9200_KITS_SDRAM_VIRT_BASE;    \
 else if (_p >= ATMEL_AT91RM9200_KITS_SRAM_PHYS_BASE &&                                       \
          _p < (ATMEL_AT91RM9200_KITS_SRAM_PHYS_BASE+ATMEL_AT91RM9200_KITS_SRAM_SIZE))        \
     _p = (_p & ATMEL_AT91RM9200_KITS_SRAM_MASK) + ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE;      \
 else if (_p >= ATMEL_AT91RM9200_KITS_FLASH_PHYS_BASE &&                                      \
          _p < (ATMEL_AT91RM9200_KITS_FLASH_PHYS_BASE+ATMEL_AT91RM9200_KITS_FLASH_SIZE))      \
     _p = (_p & ATMEL_AT91RM9200_KITS_FLASH_MASK) + ATMEL_AT91RM9200_KITS_FLASH_VIRT_BASE;    \
 else if (_p >= ATMEL_AT91RM9200_KITS_IROM_PHYS_BASE &&                                       \
          _p < (ATMEL_AT91RM9200_KITS_IROM_PHYS_BASE+ATMEL_AT91RM9200_KITS_IROM_SIZE))        \
     _p = (_p & ATMEL_AT91RM9200_KITS_IROM_MASK) + ATMEL_AT91RM9200_KITS_IROM_VIRT_BASE;      \
 else if (_p >= ATMEL_AT91RM9200_KITS_UHPREG_PHYS_BASE &&                                     \
          _p < (ATMEL_AT91RM9200_KITS_UHPREG_PHYS_BASE+ATMEL_AT91RM9200_KITS_UHPREG_SIZE))    \
     _p = (_p & ATMEL_AT91RM9200_KITS_UHPREG_MASK) + ATMEL_AT91RM9200_KITS_UHPREG_VIRT_BASE;  \
 _p; })

#define CYGARC_UNCACHED_ADDRESS(_x_)                                                          \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                                                     \
 if (_p >= ATMEL_AT91RM9200_KITS_SDRAM_VIRT_BASE &&                                           \
     _p < (ATMEL_AT91RM9200_KITS_SDRAM_VIRT_BASE+ATMEL_AT91RM9200_KITS_SDRAM_SIZE))           \
     _p = (_p & ATMEL_AT91RM9200_KITS_SDRAM_MASK) + ATMEL_AT91RM9200_KITS_SDRAM_UNCACHED_BASE;\
 else if (_p >= ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE &&                                       \
     _p < (ATMEL_AT91RM9200_KITS_SRAM_VIRT_BASE+ATMEL_AT91RM9200_KITS_SRAM_SIZE))             \
     _p = _p + ATMEL_AT91RM9200_KITS_SRAM_UNCACHED_OFFSET;                                    \
 else if (_p >= ATMEL_AT91RM9200_KITS_FLASH_VIRT_BASE &&                                      \
          _p < (ATMEL_AT91RM9200_KITS_FLASH_VIRT_BASE+ATMEL_AT91RM9200_KITS_FLASH_SIZE))      \
     _p = _p + ATMEL_AT91RM9200_KITS_FLASH_UNCACHED_OFFSET;                                   \
 else if (_p >= ATMEL_AT91RM9200_KITS_IROM_VIRT_BASE &&                                       \
          _p < (ATMEL_AT91RM9200_KITS_IROM_VIRT_BASE+ATMEL_AT91RM9200_KITS_IROM_SIZE))        \
     _p = _p + ATMEL_AT91RM9200_KITS_IROM_UNCACHED_OFFSET;                                    \
 else if (_p >= ATMEL_AT91RM9200_KITS_UHPREG_VIRT_BASE &&                                     \
          _p < (ATMEL_AT91RM9200_KITS_UHPREG_VIRT_BASE+ATMEL_AT91RM9200_KITS_UHPREG_SIZE))    \
     _p = _p + ATMEL_AT91RM9200_KITS_UHPREG_UNCACHED_OFFSET;                                  \
 _p; })

//-----------------------------------------------------------------------------
// TWI (I2C) bus

#ifdef CYGPKG_HAL_AT91RM9200_TWI
# define HAL_I2C_EXPORTED_DEVICES \
    extern cyg_i2c_bus hal_at91rm9200_i2c_bus;
#endif

//-----------------------------------------------------------------------------
// MMC Interface (MCI) bus

// Only files that need the below defines will have set __MMCSD_DRIVER_PRIVATE before inclusion.
#if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_AT91RM9200_MCI)
#include <cyg/infra/cyg_type.h>

// Only one socket, so ignore card and bus throughout below.

// Platform hook for bus initialisation, independent of socket, e.g.
// socket-independent pin config.
// err only needs to be set if there's an error.
//#define HAL_MMCSD_PLF_INIT_BUS( _bus_, _err_ )

// Platform hook for retrieval of capabilities for each socket.
// Sets socket's sockethw_caps and sockethw_vdd fields.
// err only needs to be set if there's an error.
#ifdef CYGIMP_HAL_ARM_ARM9_AT91RM9200_MCI_INTMODE
# define __MCI_INTMODE 1
#else
# define __MCI_INTMODE 0
#endif

#define HAL_MMCSD_PLF_GET_SOCKET_CAPABILITY(_bus_, _socket_, _err_)     \
    CYG_MACRO_START                                                     \
    (_socket_)->sockethw_caps.valid = 1;                                \
    (_socket_)->sockethw_caps.sd = 1;                                   \
    (_socket_)->sockethw_caps.fourbit = 1;                              \
    (_socket_)->sockethw_caps.card_detect = 1;                          \
    (_socket_)->sockethw_caps.card_detect_int = __MCI_INTMODE;          \
    (_socket_)->sockethw_vdd = MMCSD_OCR_REGISTER_VDD_32_33;            \
    (_socket_)->sockethw_caps.multiblock_io = 0;                        \
    CYG_MACRO_END
    

// Platform hook for initialising socket, primarily pin configuration.
// err only needs to be set if there's an error.

// For EK board:
// Select MMC mode on EK board SPI/MMC socket using PB22.
// There is no datasheet for the logic that this controls, but
// by experimentation, PB22 must be *set* to enable the MCI pins,
// (and cleared for SPI).
// PA17 == write protect input
#define HAL_MMCSD_PLF_INIT_SOCKET( _card_, _err_ )                                    \
    CYG_MACRO_START                                                                   \
    /* Configure PA17 as GPIO input (SD write-protect switch) */                      \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IDR, 1<<17 );  /* no intr */             \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_ODR, 1<<17 );  /* input */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_IFER, 1<<17 ); /* glitch filter on */    \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_PUER, 1<<17 ); /* pull-up on */          \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_PER, 1<<17 );  /* set PIO mode */        \
    /* Configure PB22 as output, set to 1 */                                          \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_SODR, 1<<22 ); /* set 1 */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_OER, 1<<22 );  /* output */              \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PER, 1<<22 );  /* set PIO mode */        \
    CYG_MACRO_END

// Platform hook for initialising card detection for polling. Usually some PIOs.
// Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT if relevant.
//
// For EK board:
// PB27 == card detect input
#define HAL_MMCSD_PLF_INIT_CARD_DETECT( _bus_, _card_, _err_ )                        \
    CYG_MACRO_START                                                                   \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IDR, 1<<27 );  /* no intr */             \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_ODR, 1<<27 );  /* input */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IFER, 1<<27 ); /* glitch filter on */    \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PUER, 1<<27 ); /* pull-up on */          \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PER, 1<<27 );  /* set PIO mode */        \
    CYG_MACRO_END


// Platform hook for initialisation of interrupt handler for card
// insertion/removal detection. Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT.
// err only needs to be set if there's an error.
#if defined(CYGFUN_DEVS_DISK_MMCSD_BUS_REMOVABLE_MEDIA_SUPPORT) && \
    defined(CYGIMP_HAL_ARM_ARM9_AT91RM9200_MCI_INTMODE)
struct cyg_mmcsd_card; // forward declaration
__externC void cyg_hal_at91rm9200kit_init_card_detect_intr(struct cyg_mmcsd_card *socket);

# define HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT(_bus_, _socket_, _err_) \
    cyg_hal_at91rm9200kit_init_card_detect_intr(_socket_)
#endif

// Update card's cardflags field with card presence
#define HAL_MMCSD_PLF_SAMPLE_CARD_DETECT( _card_, _err_ )               \
    CYG_MACRO_START                                                     \
    cyg_uint32 pdsr;                                                    \
    HAL_READ_UINT32( AT91RM9200_PIOB + _PIO_PDSR, pdsr );               \
    (_card_)->cardflags.card_present = ( 0 != (pdsr & (1<<27)) );       \
    CYG_MACRO_END

// Update card's cardflags field with physical write-protect switch state
#define HAL_MMCSD_PLF_SAMPLE_CARD_WP( _card_, _err_ )                   \
    CYG_MACRO_START                                                     \
    cyg_uint32 pdsr;                                                    \
    HAL_READ_UINT32( AT91RM9200_PIOA + _PIO_PDSR, pdsr );               \
    (_card_)->cardflags.hw_writeprotect = ( 0 != (pdsr & (1<<17)) );    \
    CYG_MACRO_END

#endif // if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_AT91RM9200_MCI)

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
