#ifndef CYGONCE_ATMEL_AT91RM9200_KITS_H
#define CYGONCE_ATMEL_AT91RM9200_KITS_H
/*=============================================================================
//
//      dnp_sk23.h
//
//      Platform specific support (register layout, etc)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: eCosCentric, jskov
// Date:         2006-06-01
// Purpose:      SSV DNP/SK23 platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/atmel-at91rm9200-kits.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/system.h>
#include CYGBLD_HAL_PLATFORM_H
#include <cyg/hal/at91rm9200.h>        // CPU details

//---------------------------------------------------------------------------
// Memory layout details needed by conversion macros in plf_io.h


// DK has 2MiB Flash, EK has 8MiB Flash
#define DNP_SK23_FLASH_PHYS_BASE         0x10000000
#define DNP_SK23_FLASH_VIRT_BASE         0x60000000
#define DNP_SK23_FLASH_UNCACHED_OFFSET   0xb0000000
#define DNP_SK23_FLASH_SIZE              0x01000000
#define DNP_SK23_FLASH_MASK              (DNP_SK23_FLASH_SIZE-1)

#define DNP_SK23_SDRAM_PHYS_BASE         0x20000000
#define DNP_SK23_SDRAM_VIRT_BASE         0x20000000
#define DNP_SK23_SDRAM_UNCACHED_BASE     0x30000000
#define DNP_SK23_SDRAM_SIZE              0x02000000
#define DNP_SK23_SDRAM_MASK              (DNP_SK23_SDRAM_SIZE-1)

#define DNP_SK23_IROM_PHYS_BASE          0x00100000
#define DNP_SK23_IROM_VIRT_BASE          0x71000000
#define DNP_SK23_IROM_UNCACHED_OFFSET    0x00800000
#define DNP_SK23_IROM_SIZE               0x00020000
#define DNP_SK23_IROM_MASK               (DNP_SK23_IROM_SIZE-1)

#define DNP_SK23_SRAM_PHYS_BASE          0x00200000
#define DNP_SK23_SRAM_VIRT_BASE          0x70000000
#define DNP_SK23_SRAM_UNCACHED_OFFSET    0x00100000
#define DNP_SK23_SRAM_SIZE               0x00004000
#define DNP_SK23_SRAM_MASK               (DNP_SK23_SRAM_SIZE-1)

#define DNP_SK23_UHPREG_PHYS_BASE        0x00300000
#define DNP_SK23_UHPREG_VIRT_BASE        0x72000000
#define DNP_SK23_UHPREG_UNCACHED_OFFSET  0x00800000
#define DNP_SK23_UHPREG_SIZE             0x00100000
#define DNP_SK23_UHPREG_MASK             (DNP_SK23_UHPREG_SIZE-1)

/*---------------------------------------------------------------------------*/
#endif /* CYGONCE_DNP_SK23_H */
/* end of dnp_sk23.h                                                         */
