#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005 Free Software Foundation, Inc.
// Copyright (C) 2003,2005 eCosCentric Limited                              
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   eCosCentric
// Contributors:jskov
// Date:        2001-10-31
// Purpose:     ARM/KB9200 platform specific registers
// Description: 
// Usage:       #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <cyg/hal/kb9200.h>

//-----------------------------------------------------------------------------
// Address space translation macros

#define CYGARC_PHYSICAL_ADDRESS(_x_)                                    \
    ({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                           \
        if (_p >= KB9200_SDRAM_VIRT_BASE &&                             \
            _p < (KB9200_SDRAM_VIRT_BASE+KB9200_SDRAM_SIZE))            \
            _p = (_p & KB9200_SDRAM_MASK) + KB9200_SDRAM_PHYS_BASE;     \
        else if (_p >= KB9200_SRAM_VIRT_BASE &&                         \
                 _p < (KB9200_SRAM_VIRT_BASE+KB9200_SRAM_SIZE))         \
            _p = (_p & KB9200_SRAM_MASK) + KB9200_SRAM_PHYS_BASE;       \
        else if (_p >= KB9200_FLASH_VIRT_BASE &&                        \
                 _p < (KB9200_FLASH_VIRT_BASE+KB9200_FLASH_SIZE))       \
            _p = (_p & KB9200_FLASH_MASK) + KB9200_FLASH_PHYS_BASE;     \
        else if (_p >= KB9200_IROM_VIRT_BASE &&                         \
                 _p < (KB9200_IROM_VIRT_BASE+KB9200_IROM_SIZE))         \
            _p = (_p & KB9200_IROM_MASK) + KB9200_IROM_PHYS_BASE;       \
        else if (_p >= KB9200_UHPREG_VIRT_BASE &&                       \
                 _p < (KB9200_UHPREG_VIRT_BASE+KB9200_UHPREG_SIZE))     \
            _p = (_p & KB9200_UHPREG_MASK) + KB9200_UHPREG_PHYS_BASE;   \
        _p; })

#define CYGARC_VIRTUAL_ADDRESS(_x_)                                     \
    ({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                           \
        if (_p >= KB9200_SDRAM_PHYS_BASE &&                             \
            _p < (KB9200_SDRAM_PHYS_BASE+KB9200_SDRAM_SIZE))            \
            _p = (_p & KB9200_SDRAM_MASK) + KB9200_SDRAM_VIRT_BASE;     \
        else if (_p >= KB9200_SRAM_PHYS_BASE &&                         \
                 _p < (KB9200_SRAM_PHYS_BASE+KB9200_SRAM_SIZE))         \
            _p = (_p & KB9200_SRAM_MASK) + KB9200_SRAM_VIRT_BASE;       \
        else if (_p >= KB9200_FLASH_PHYS_BASE &&                        \
                 _p < (KB9200_FLASH_PHYS_BASE+KB9200_FLASH_SIZE))       \
            _p = (_p & KB9200_FLASH_MASK) + KB9200_FLASH_VIRT_BASE;     \
        else if (_p >= KB9200_IROM_PHYS_BASE &&                         \
                 _p < (KB9200_IROM_PHYS_BASE+KB9200_IROM_SIZE))         \
            _p = (_p & KB9200_IROM_MASK) + KB9200_IROM_VIRT_BASE;       \
        else if (_p >= KB9200_UHPREG_PHYS_BASE &&                       \
                 _p < (KB9200_UHPREG_PHYS_BASE+KB9200_UHPREG_SIZE))     \
            _p = (_p & KB9200_UHPREG_MASK) + KB9200_UHPREG_VIRT_BASE;   \
 _p; })

#define CYGARC_UNCACHED_ADDRESS(_x_)                                    \
    ({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                           \
        if (_p >= KB9200_SDRAM_VIRT_BASE &&                             \
            _p < (KB9200_SDRAM_VIRT_BASE+KB9200_SDRAM_SIZE))            \
            _p = (_p & KB9200_SDRAM_MASK) + KB9200_SDRAM_PHYS_BASE;     \
        else if (_p >= KB9200_SRAM_VIRT_BASE &&                         \
                 _p < (KB9200_SRAM_VIRT_BASE+KB9200_SRAM_SIZE))         \
            _p = _p + KB9200_SRAM_UNCACHED_OFFSET;                      \
        else if (_p >= KB9200_FLASH_VIRT_BASE &&                        \
                 _p < (KB9200_FLASH_VIRT_BASE+KB9200_FLASH_SIZE))       \
            _p = _p + KB9200_FLASH_UNCACHED_OFFSET;                     \
        else if (_p >= KB9200_IROM_VIRT_BASE &&                         \
                 _p < (KB9200_IROM_VIRT_BASE+KB9200_IROM_SIZE))         \
            _p = _p + KB9200_IROM_UNCACHED_OFFSET;                      \
        else if (_p >= KB9200_UHPREG_VIRT_BASE &&                       \
                 _p < (KB9200_UHPREG_VIRT_BASE+KB9200_UHPREG_SIZE))     \
            _p = _p + KB9200_UHPREG_UNCACHED_OFFSET;                    \
 _p; })

//-----------------------------------------------------------------------------
// Macro used for translating from flash address used by RedBoot to that
// used by ARM Boot monitor.
#define _ADDR_REDBOOT_TO_ARM(x) (((CYG_ADDRESS)x & ~0x60000000) | 0x04000000)

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
