#ifndef CYGONCE_MC9328MXL_H
#define CYGONCE_MC9328MXL_H
/*=============================================================================
//
//      mc9328mxl.h
//
//      Register layout, etc, for Motorola MC9328MXL CPU
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2003, 2004 Free Software Foundation, Inc.                  
// Copyright (C) 2003, 2004 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2004-07-05
// Purpose:      Motorola MC9328MXL CPU variant definitions
// Description: 
// Usage:        #include <cyg/hal/mc9328mxl.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/


#define MC9328MXL_BASE                          0x00200000

/*---------------------------------------------------------------------------*/

#define MC9328MXL_AIPI1                         0x00200000
#define MC9328MXL_AIPI2                         0x00210000

#define MC9328MXL_AIPI_PSR0                     0x00
#define MC9328MXL_AIPI_PSR1                     0x04
#define MC9328MXL_AIPI_PAR                      0x08
#define MC9328MXL_AIPI_PCR                      0x0c
#define MC9328MXL_AIPI_TSR                      0x10

/*---------------------------------------------------------------------------*/
/* Watchdog                                                                  */

#define MC9328MXL_WDOG                          0x00201000

#define MC9328MXL_WDOG_CR                       0x00
#define  MC9328MXL_WDOG_CR_WDE                          (1<<0)
#define  MC9328MXL_WDOG_CR_WDEC                         (1<<1)
#define  MC9328MXL_WDOG_CR_SWR                          (1<<2)
#define  MC9328MXL_WDOG_CR_TMD                          (1<<3)
#define  MC9328MXL_WDOG_CR_WIE                          (1<<4)
#define  MC9328MXL_WDOG_CR_WT                           (0x7f<<8)
#define  MC9328MXL_WDOG_CR_WT_SHIFT                     8
#define  MC9328MXL_WDOG_CR_WHALT                        (1<<15)
#define MC9328MXL_WDOG_SR                       0x04
#define MC9328MXL_WDOG_SR_VAL1                          0x5555
#define MC9328MXL_WDOG_SR_VAL2                          0xAAAA
#define MC9328MXL_WDOG_STR                      0x08
#define MC9328MXL_WDOG_STR_TOUT                         (1<<0)
#define MC9328MXL_WDOG_STR_TINT                         (1<<8)


/*---------------------------------------------------------------------------*/

#define MC9328MXL_TIMER1                        0x00202000
#define MC9328MXL_TIMER2                        0x00203000

#define MC9328MXL_TIMER_CONTROL                 0x00
#define  MC9328MXL_TIMER_CONTROL_TEN                    (1<<0)
#define  MC9328MXL_TIMER_CONTROL_STOP                   (0<<1)
#define  MC9328MXL_TIMER_CONTROL_PERCLK1                (1<<1)
#define  MC9328MXL_TIMER_CONTROL_PERCLK1_DIV16          (2<<1)
#define  MC9328MXL_TIMER_CONTROL_TIN                    (3<<1)
#define  MC9328MXL_TIMER_CONTROL_IRQEN                  (1<<4)
#define  MC9328MXL_TIMER_CONTROL_OM                     (1<<5)
#define  MC9328MXL_TIMER_CONTROL_CAP_DIS                (0<<6)
#define  MC9328MXL_TIMER_CONTROL_CAP_RISING             (1<<6)
#define  MC9328MXL_TIMER_CONTROL_CAP_FALLING            (2<<6)
#define  MC9328MXL_TIMER_CONTROL_CAP_BOTH               (3<<6)
#define  MC9328MXL_TIMER_CONTROL_RESTART                (0<<8)
#define  MC9328MXL_TIMER_CONTROL_FREERUN                (1<<8)
#define  MC9328MXL_TIMER_CONTROL_SWR                    (1<<15)

#define MC9328MXL_TIMER_PRESCALE                0x04
#define MC9328MXL_TIMER_COMPARE                 0x08
#define MC9328MXL_TIMER_CAPTURE                 0x0c
#define MC9328MXL_TIMER_COUNT                   0x10
#define MC9328MXL_TIMER_STATUS                  0x14
#define  MC9328MXL_TIMER_STATUS_COMPARE                 (1<<0)
#define  MC9328MXL_TIMER_STATUS_CAPTURE                 (1<<1)


/*---------------------------------------------------------------------------*/
/* UARTs                                                                     */

#define MC9328MXL_UART1                         0x00206000
#define MC9328MXL_UART2                         0x00207000

#define MC9328MXL_UART_RXR                      0x00
#define  MC9328MXL_UART_RXR_RDY                         (1<<15)         // Set if character ready
#define MC9328MXL_UART_TXR                      0x40

#define MC9328MXL_UART_CR1                      0x80
#define  MC9328MXL_UART_CR1_ADEN                        (1<<15)         // Auto dectect interrupt
#define  MC9328MXL_UART_CR1_ADBR                        (1<<14)         // Auto detect baud rate
#define  MC9328MXL_UART_CR1_TRDYEN                      (1<<13)         // Transmitter ready interrupt enable
#define  MC9328MXL_UART_CR1_IDEN                        (1<<12)         // Idle condition interrupt
#define  MC9328MXL_UART_CR1_RRDYEN                      (1<<9)          // Recv ready interrupt enable
#define  MC9328MXL_UART_CR1_RDMAEN                      (1<<8)          // Recv ready DMA enable
#define  MC9328MXL_UART_CR1_IREN                        (1<<7)          // Infrared interface enable
#define  MC9328MXL_UART_CR1_TXMPTYEN                    (1<<6)          // Transimitter empty interrupt enable
#define  MC9328MXL_UART_CR1_RTSDEN                      (1<<5)          // RTS delta interrupt enable
#define  MC9328MXL_UART_CR1_SNDBRK                      (1<<4)          // Send break
#define  MC9328MXL_UART_CR1_TDMAEN                      (1<<3)          // Transmitter ready DMA enable
#define  MC9328MXL_UART_CR1_UARTCLKEN                   (1<<2)          // UART clock enabled
#define  MC9328MXL_UART_CR1_DOZE                        (1<<1)          // Doze
#define  MC9328MXL_UART_CR1_UARTEN                      (1<<0)          // UART enabled

#define MC9328MXL_UART_CR2                      0x84
#define  MC9328MXL_UART_CR2_ESCI                        (1<<15)         // Escape seq interrupt enable 
#define  MC9328MXL_UART_CR2_IRTS                        (1<<14)         // Ignore RTS pin
#define  MC9328MXL_UART_CR2_CTSC                        (1<<13)         // CTS pin control
#define  MC9328MXL_UART_CR2_CTS                         (1<<12)         // Clear to send
#define  MC9328MXL_UART_CR2_ESCEN                       (1<<11)         // Escape enable
#define  MC9328MXL_UART_CR2_PREN                        (1<<8)          // Parity enable
#define  MC9328MXL_UART_CR2_PROE                        (1<<7)          // Parity odd/even
#define  MC9328MXL_UART_CR2_STPB                        (1<<6)          // Stop
#define  MC9328MXL_UART_CR2_WS                          (1<<5)          // Word size 
#define  MC9328MXL_UART_CR2_RTSEN                       (1<<4)          // Request to send interrupt enable 
#define  MC9328MXL_UART_CR2_TXEN                        (1<<2)          // Transmitter enabled 
#define  MC9328MXL_UART_CR2_RXEN                        (1<<1)          // Receiver enabled 
#define  MC9328MXL_UART_CR2_SRST_                       (1<<0)          // SW reset 

#define MC9328MXL_UART_CR3                      0x88
#define  MC9328MXL_UART_CR3_DTREN                       (1<<13)         // DTR interrupt enable
#define  MC9328MXL_UART_CR3_PARERREN                    (1<<12)         // Parity enable
#define  MC9328MXL_UART_CR3_FRAERREN                    (1<<11)         // Frame error interrupt enable
#define  MC9328MXL_UART_CR3_DSR                         (1<<10)         // Data set ready
#define  MC9328MXL_UART_CR3_DCD                         (1<<9)          // Data carrier detect
#define  MC9328MXL_UART_CR3_RI                          (1<<8)          // Ring indicator
#define  MC9328MXL_UART_CR3_TIMEOUTEN                   (1<<7)          // Timeout interrupt enable
#define  MC9328MXL_UART_CR3_RXDSEN                      (1<<6)          // Receive status interrupt enable
#define  MC9328MXL_UART_CR3_AIRINTEN                    (1<<5)          // Async IR wake interrupt enable
#define  MC9328MXL_UART_CR3_AWAKEN                      (1<<4)          // Async wake interrupt enable
#define  MC9328MXL_UART_CR3_REF25                       (1<<3)          // Ref freq 25 MHz
#define  MC9328MXL_UART_CR3_REF30                       (1<<2)          // Ref Freq 30 MHz
#define  MC9328MXL_UART_CR3_INVT                        (1<<1)          // Inverted Infrared transmission
#define  MC9328MXL_UART_CR3_BPEN                        (1<<0)          // Preset registers enable

#define MC9328MXL_UART_CR4                      0x8c
#define  MC9328MXL_UART_CR4_CTSTL_32                    (32<<10)        // CTS trigger level (32 chars)
#define  MC9328MXL_UART_CR4_INVR                        (1<<9)          // Inverted infrared reception 
#define  MC9328MXL_UART_CR4_ENIRI                       (1<<8)          // Serial infrared interrupt enable 
#define  MC9328MXL_UART_CR4_WKEN                        (1<<7)          // Wake interrupt enable 
#define  MC9328MXL_UART_CR4_REF16                       (1<<6)          // Ref freq 16 MHz 
#define  MC9328MXL_UART_CR4_IRSC                        (1<<5)          // IR special case 
#define  MC9328MXL_UART_CR4_TCEN                        (1<<3)          // Transmit complete interrupt enable
#define  MC9328MXL_UART_CR4_BKEN                        (1<<2)          // Break condition interrupt enable 
#define  MC9328MXL_UART_CR4_OREN                        (1<<1)          // Receiver overrun interrupt enable 
#define  MC9328MXL_UART_CR4_DREN                        (1<<0)          // Recv data ready interrupt enable 

#define MC9328MXL_UART_FCR                      0x90
#define  MC9328MXL_UART_FCR_RXTL_SHF                    0               // Receiver trigger level shift
#define  MC9328MXL_UART_FCR_RFDIV_1                     (5<<7)          // Reference freq divider (div 1)
#define  MC9328MXL_UART_FCR_TXTL_SHF                    10              // Transmitter trigger level shift

#define MC9328MXL_UART_SR1                      0x94
#define  MC9328MXL_UART_SR1_PARITYERR                   (1<<15)         // Parity error interrupt flag
#define  MC9328MXL_UART_SR1_RTSS                        (1<<14)         // RTS pin status
#define  MC9328MXL_UART_SR1_TRDY                        (1<<13)         // Transmitter ready interrupt/dma flag
#define  MC9328MXL_UART_SR1_RTSD                        (1<<12)         // RTS delta
#define  MC9328MXL_UART_SR1_ESCF                        (1<<11)         // Escape seq interrupt flag
#define  MC9328MXL_UART_SR1_FRAMERR                     (1<<10)         // Frame error interrupt flag
#define  MC9328MXL_UART_SR1_RRDY                        (1<<9)          // Receiver ready interrupt/dma flag
#define  MC9328MXL_UART_SR1_TIMEOUT                     (1<<7)          // Receive timeout interrupt status 
#define  MC9328MXL_UART_SR1_RXDS                        (1<<6)          // Receiver idle interrupt flag
#define  MC9328MXL_UART_SR1_AIRINT                      (1<<5)          // Async IR wake interrupt flag
#define  MC9328MXL_UART_SR1_AWAKE                       (1<<4)          // Aysnc wake interrupt flag

#define MC9328MXL_UART_SR2                      0x98
#define  MC9328MXL_UART_SR2_ADET                        (1<<15)         // Auto baud rate detect complete
#define  MC9328MXL_UART_SR2_TXFE                        (1<<14)         // Transmit buffer FIFO empty
#define  MC9328MXL_UART_SR2_DTRF                        (1<<13)         // DTR edge interrupt flag
#define  MC9328MXL_UART_SR2_IDLE                        (1<<12)         // Idle condition
#define  MC9328MXL_UART_SR2_IRINT                       (1<<8)          // Serial infrared interrupt flag
#define  MC9328MXL_UART_SR2_WAKE                        (1<<7)          // Wake
#define  MC9328MXL_UART_SR2_RTSF                        (1<<4)          // RTS edge interrupt flag
#define  MC9328MXL_UART_SR2_TXDC                        (1<<3)          // Transmitter complete
#define  MC9328MXL_UART_SR2_BRCD                        (1<<2)          // Break condition
#define  MC9328MXL_UART_SR2_ORE                         (1<<1)          // Overrun error
#define  MC9328MXL_UART_SR2_RDR                         (1<<0)          // Recv data ready

#define MC9328MXL_UART_ESC                      0x9c
#define MC9328MXL_UART_ETR                      0xa0
#define MC9328MXL_UART_BIR                      0xa4
#define MC9328MXL_UART_BRM                      0xa8
#define MC9328MXL_UART_BRC                      0xac
#define MC9328MXL_UART_BIPR1                    0xb0
#define MC9328MXL_UART_BIPR2                    0xb4
#define MC9328MXL_UART_BIPR3                    0xb8
#define MC9328MXL_UART_BIPR4                    0xbc
#define MC9328MXL_UART_BMPR1                    0xc0
#define MC9328MXL_UART_BMPR2                    0xc4
#define MC9328MXL_UART_BMPR3                    0xc8
#define MC9328MXL_UART_BMPR4                    0xcc
#define MC9328MXL_UART_TS                       0xd0
#define  MC9328MXL_UART_TS_FRCPERR                      (1<<13)         // Force parity error
#define  MC9328MXL_UART_TS_LOOP                         (1<<12)         // Loop tx and rx
#define  MC9328MXL_UART_TS_TXEMPTY                      (1<<6)          // TxFIFO empty
#define  MC9328MXL_UART_TS_RXEMPTY                      (1<<5)          // RxFIFO empty
#define  MC9328MXL_UART_TS_TXFULL                       (1<<4)          // TxFIFO full
#define  MC9328MXL_UART_TS_RXFULL                       (1<<3)          // RxFIFO full
#define  MC9328MXL_UART_TS_SOFTRST                      (1<<0)          // Software reset

/*---------------------------------------------------------------------------*/
/* PLL and Clock control                                                     */

#define MC9328MXL_PCC                           0x0021B000

#define MC9328MXL_PCC_CSCR                      0x00
#define MC9328MXL_PCC_MPCTL0                    0x04
#define MC9328MXL_PCC_MPCTL1                    0x08
#define MC9328MXL_PCC_SPCTL0                    0x0c
#define MC9328MXL_PCC_SPCTL1                    0x10
#define MC9328MXL_PCC_PCDR                      0x20

/*---------------------------------------------------------------------------*/
/* System Control                                                            */

#define MC9328MXL_SYS                           0x0021b800

#define MC9328MXL_SYS_ID                        0x04
#define  MC9328MXL_SYS_ID_CORSICA1                      0x04d4c01d
#define  MC9328MXL_SYS_ID_CORSICA2                      0x00d4c01d

#define MC9328MXL_SYS_FMCR                      0x08
#define MC9328MXL_SYS_GPCR                      0x0c
#define MC9328MXL_SYS_GCCR                      0x10

/*---------------------------------------------------------------------------*/
/* GPIO ports                                                                */

#define MC9328MXL_GPIOA                         0x0021C000
#define MC9328MXL_GPIOB                         0x0021C100
#define MC9328MXL_GPIOC                         0x0021C200
#define MC9328MXL_GPIOD                         0x0021C300

#define MC9328MXL_GPIO_DDIR                     0x00
#define MC9328MXL_GPIO_OCR1                     0x04
#define MC9328MXL_GPIO_OCR2                     0x08
#define MC9328MXL_GPIO_ICRA1                    0x0c
#define MC9328MXL_GPIO_ICRA2                    0x10
#define MC9328MXL_GPIO_ICRB1                    0x14
#define MC9328MXL_GPIO_ICRB2                    0x18
#define MC9328MXL_GPIO_DR                       0x1c
#define MC9328MXL_GPIO_GIUS                     0x20
#define MC9328MXL_GPIO_SSR                      0x24
#define MC9328MXL_GPIO_ICR1                     0x28
#define MC9328MXL_GPIO_ICR2                     0x2c
#define MC9328MXL_GPIO_IMR                      0x30
#define MC9328MXL_GPIO_ISR                      0x34
#define MC9328MXL_GPIO_GPR                      0x38
#define MC9328MXL_GPIO_SWR                      0x3c
#define MC9328MXL_GPIO_PUEN                     0x40

/*---------------------------------------------------------------------------*/
/* External Interface Module                                                 */

#define MC9328MXL_EIM                           0x00220000

#define MC9328MXL_EIM_CS0_U                     0x00
#define MC9328MXL_EIM_CS0_L                     0x04
#define MC9328MXL_EIM_CS1_U                     0x08
#define MC9328MXL_EIM_CS1_L                     0x0c
#define MC9328MXL_EIM_CS2_U                     0x10
#define MC9328MXL_EIM_CS2_L                     0x14
#define MC9328MXL_EIM_CS3_U                     0x18
#define MC9328MXL_EIM_CS3_L                     0x1c
#define MC9328MXL_EIM_CS4_U                     0x20
#define MC9328MXL_EIM_CS4_L                     0x24
#define MC9328MXL_EIM_CS5_U                     0x28
#define MC9328MXL_EIM_CS5_L                     0x2c
#define MC9328MXL_EIM_CFG                       0x30


/*---------------------------------------------------------------------------*/
/* SDRAM Controller                                                          */

#define MC9328MXL_SDC                           0x00221000

#define MC9328MXL_SDC_CTL0                      0x00
#define MC9328MXL_SDC_CTL1                      0x04
#define MC9328MXL_SDC_RESET                     0x08
#define MC9328MXL_SDC_MISC                      0x0c

/*---------------------------------------------------------------------------*/
/* AITC Interrupt controller                                                 */

#define MC9328MXL_AITC                          0x00223000

#define MC9328MXL_AITC_CNTL                     0x00
#define MC9328MXL_AITC_MASK                     0x04
#define MC9328MXL_AITC_ENNUM                    0x08
#define MC9328MXL_AITC_DISNUM                   0x0c
#define MC9328MXL_AITC_ENHI                     0x10
#define MC9328MXL_AITC_ENLO                     0x14
#define MC9328MXL_AITC_TYPEHI                   0x18
#define MC9328MXL_AITC_TYPELO                   0x1c
#define MC9328MXL_AITC_PRI(n)                   (0x20+(7-(n))*4)
#define MC9328MXL_AITC_VSR                      0x40
#define MC9328MXL_AITC_FVSR                     0x44
#define MC9328MXL_AITC_ISRHI                    0x48
#define MC9328MXL_AITC_ISRLO                    0x4c
#define MC9328MXL_AITC_IFRHI                    0x50
#define MC9328MXL_AITC_IFRLO                    0x54
#define MC9328MXL_AITC_IPRHI                    0x58
#define MC9328MXL_AITC_IPRLO                    0x5c
#define MC9328MXL_AITC_FIPRHI                   0x60
#define MC9328MXL_AITC_FIPRLO                   0x64

/*---------------------------------------------------------------------------*/
/* end of mc9328mxl.h                                                        */
#endif /* CYGONCE_MC9328MXL_H */
