#ifndef CYGONCE_HAL_VAR_INTS_H
#define CYGONCE_HAL_VAR_INTS_H
//==========================================================================
//
//      var_ints.h
//
//      ARM9/SAM9 variant Interrupt and clock support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2007 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005, 2007 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2007-09-27
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the Atmel SAM9 are defined here.
// Usage:
//               #include <cyg/hal/hal_var_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/sam9.h>
#include <cyg/hal/hal_io.h>


#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260)

#define CYGNUM_HAL_INTERRUPT_FIQ     0 // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SYSTEM  1 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA    2 // Parallel IO Controller A
#define CYGNUM_HAL_INTERRUPT_PIOB    3 // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_PIOC    4 // Parallel IO Controller C
#define CYGNUM_HAL_INTERRUPT_ADC     5 // Analog to Digital Converter
#define CYGNUM_HAL_INTERRUPT_US0     6 // USART 0
#define CYGNUM_HAL_INTERRUPT_US1     7 // USART 1
#define CYGNUM_HAL_INTERRUPT_US2     8 // USART 2
#define CYGNUM_HAL_INTERRUPT_MCI     9 // Multimedia Card Interface
#define CYGNUM_HAL_INTERRUPT_UDP    10 // USB Device Port
#define CYGNUM_HAL_INTERRUPT_TWI    11 // Two-Wire Interface
#define CYGNUM_HAL_INTERRUPT_SPI    12 // Serial Peripheral Interface 0
#define CYGNUM_HAL_INTERRUPT_SPI1   13 // Serial Peripheral Interface 1
#define CYGNUM_HAL_INTERRUPT_SSC0   14 // Serial Synchronous Controller 0
                                       // Vector 15 unused
                                       // Vector 16 unused
#define CYGNUM_HAL_INTERRUPT_TC0    17 // Timer Counter 0
#define CYGNUM_HAL_INTERRUPT_TC1    18 // Timer Counter 1
#define CYGNUM_HAL_INTERRUPT_TC2    19 // Timer Counter 2
#define CYGNUM_HAL_INTERRUPT_UHP    20 // USB Host port
#define CYGNUM_HAL_INTERRUPT_EMAC   21 // Ethernet MAC
#define CYGNUM_HAL_INTERRUPT_ISI    22 // Image Sensor Interface
#define CYGNUM_HAL_INTERRUPT_US3    23 // USART 3
#define CYGNUM_HAL_INTERRUPT_US4    24 // USART 4
#define CYGNUM_HAL_INTERRUPT_US5    25 // USART 5
#define CYGNUM_HAL_INTERRUPT_TC3    26 // Timer Counter 3
#define CYGNUM_HAL_INTERRUPT_TC4    27 // Timer Counter 4
#define CYGNUM_HAL_INTERRUPT_TC5    28 // Timer Counter 5
#define CYGNUM_HAL_INTERRUPT_IRQ0   29 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_INTERRUPT_IRQ1   30 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_INTERRUPT_IRQ2   31 // Advanced Interrupt Controller (IRQ2)

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define CYGNUM_HAL_INTERRUPT_FIQ     0 // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SYSTEM  1 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA    2 // Parallel IO Controller A
#define CYGNUM_HAL_INTERRUPT_PIOB    3 // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_PIOC    4 // Parallel IO Controller C
                                       // Vector 5 unused
#define CYGNUM_HAL_INTERRUPT_US0     6 // USART 0
#define CYGNUM_HAL_INTERRUPT_US1     7 // USART 1
#define CYGNUM_HAL_INTERRUPT_US2     8 // USART 2
#define CYGNUM_HAL_INTERRUPT_MCI     9 // Multimedia Card Interface
#define CYGNUM_HAL_INTERRUPT_UDP    10 // USB Device Port
#define CYGNUM_HAL_INTERRUPT_TWI    11 // Two-Wire Interface
#define CYGNUM_HAL_INTERRUPT_SPI    12 // Serial Peripheral Interface 0
#define CYGNUM_HAL_INTERRUPT_SPI1   13 // Serial Peripheral Interface 1
#define CYGNUM_HAL_INTERRUPT_SSC0   14 // Serial Synchronous Controller 0
#define CYGNUM_HAL_INTERRUPT_SSC1   15 // Serial Synchronous Controller 1
#define CYGNUM_HAL_INTERRUPT_SSC2   16 // Serial Synchronous Controller 2
#define CYGNUM_HAL_INTERRUPT_TC0    17 // Timer Counter 0
#define CYGNUM_HAL_INTERRUPT_TC1    18 // Timer Counter 1
#define CYGNUM_HAL_INTERRUPT_TC2    19 // Timer Counter 2
#define CYGNUM_HAL_INTERRUPT_UHP    20 // USB Host port
#define CYGNUM_HAL_INTERRUPT_LCD    21 // LCD controller
                                       // Vectors 22..28 unused
#define CYGNUM_HAL_INTERRUPT_IRQ0   29 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_INTERRUPT_IRQ1   30 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_INTERRUPT_IRQ2   31 // Advanced Interrupt Controller (IRQ2)

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define CYGNUM_HAL_INTERRUPT_FIQ     0 // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SYSTEM  1 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA    2 // Parallel IO Controller A
#define CYGNUM_HAL_INTERRUPT_PIOB    3 // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_PIOC    4 // Parallel IO Controllers C, D & E
                                       // Vector 5 unused
                                       // Vector 6 unused
#define CYGNUM_HAL_INTERRUPT_US0     7 // USART 0
#define CYGNUM_HAL_INTERRUPT_US1     8 // USART 1
#define CYGNUM_HAL_INTERRUPT_US2     9 // USART 2
#define CYGNUM_HAL_INTERRUPT_MCI0   10 // Multimedia Card Interface 0
#define CYGNUM_HAL_INTERRUPT_MCI1   11 // Multimedia Card Interface 1
#define CYGNUM_HAL_INTERRUPT_CAN    12 // CAN Bus Controller
#define CYGNUM_HAL_INTERRUPT_TWI    13 // Two-Wire Interface
#define CYGNUM_HAL_INTERRUPT_SPI    14 // Serial Peripheral Interface 0
#define CYGNUM_HAL_INTERRUPT_SPI1   15 // Serial Peripheral Interface 1
#define CYGNUM_HAL_INTERRUPT_SSC0   16 // Serial Synchronous Controller 0
#define CYGNUM_HAL_INTERRUPT_SSC1   17 // Serial Synchronous Controller 1
#define CYGNUM_HAL_INTERRUPT_AC97   18 // AC97 Controller
#define CYGNUM_HAL_INTERRUPT_TC0    19 // Timer Counters 0, 1 & 2
#define CYGNUM_HAL_INTERRUPT_PWM    20 // Pulse Width Modulator
#define CYGNUM_HAL_INTERRUPT_EMAC   21 // Ethernet MAC
                                       // Vector 22 unused
#define CYGNUM_HAL_INTERRUPT_2DGE   23 // 2D Graphics Engine
#define CYGNUM_HAL_INTERRUPT_UDP    24 // USB Device Port
#define CYGNUM_HAL_INTERRUPT_ISI    25 // Image Sensor Interface
#define CYGNUM_HAL_INTERRUPT_LCD    26 // LCD controller
#define CYGNUM_HAL_INTERRUPT_DMA    27 // DMA controller
                                       // Vector 28 unused
#define CYGNUM_HAL_INTERRUPT_UHP    29 // USB Host port
#define CYGNUM_HAL_INTERRUPT_IRQ0   30 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_INTERRUPT_IRQ1   31 // Advanced Interrupt Controller (IRQ1)

// Select MCI interface interrupt for MMC device driver
#ifdef CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263_MCI_SAM9_MCI0
#define CYGNUM_HAL_INTERRUPT_MCI    CYGNUM_HAL_INTERRUPT_MCI0
#else
#define CYGNUM_HAL_INTERRUPT_MCI    CYGNUM_HAL_INTERRUPT_MCI1
#endif

#else

#error Unknown SAM9 variant

#endif


// The following interrupts are derived from the SYSTEM interrupt
#define CYGNUM_HAL_INTERRUPT_PITC   32 // System Timer Period Interval Timer
#define CYGNUM_HAL_INTERRUPT_DEBUG  33 // Debug unit
#define CYGNUM_HAL_INTERRUPT_WDTC   34 // Watchdog
#define CYGNUM_HAL_INTERRUPT_RTTC   35 // Real Time Clock
#define CYGNUM_HAL_INTERRUPT_PMC    36 // Power Management Controller
#define CYGNUM_HAL_INTERRUPT_RSTC   37 // Reset Controller


#define CYGNUM_HAL_INTERRUPT_NONE    -1

#define CYGNUM_HAL_ISR_MIN            0
#define CYGNUM_HAL_ISR_MAX           37

#define CYGNUM_HAL_ISR_COUNT         (CYGNUM_HAL_ISR_MAX-CYGNUM_HAL_ISR_MIN+1)

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC      CYGNUM_HAL_INTERRUPT_PITC

//==========================================================================
// VSR table extension
//
// The SAM9 Advanced Interrupt Controller has a vector unit that decodes
// incoming interrupt sources into one of the thirty-two interrupts. The vector
// for the current source is then available via another register. Here we
// virtually extend the VSR table to include the controller's thirty-two
// AIC vector registers and replace the IRQ and FIQ vector instructions to
// jump via the current vector register.

// FIQ is already defined as vector 7 in the architecture hal_intr.h

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260)

#define CYGNUM_HAL_VECTOR_SYSTEM  8 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_VECTOR_PIOA    9 // Parallel IO Controller A
#define CYGNUM_HAL_VECTOR_PIOB   10 // Parallel IO Controller B
#define CYGNUM_HAL_VECTOR_PIOC   11 // Parallel IO Controller C
#define CYGNUM_HAL_VECTOR_ADC    12 // Analog to Digital Converter
#define CYGNUM_HAL_VECTOR_US0    13 // USART 0
#define CYGNUM_HAL_VECTOR_US1    14 // USART 1
#define CYGNUM_HAL_VECTOR_US2    15 // USART 2
#define CYGNUM_HAL_VECTOR_MCI    16 // Multimedia Card Interface
#define CYGNUM_HAL_VECTOR_UDP    17 // USB Device Port
#define CYGNUM_HAL_VECTOR_TWI    18 // Two-Wire Interface
#define CYGNUM_HAL_VECTOR_SPI    19 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SPI1   20 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SSC0   21 // Serial Synchronous Controller 0
                                    // VSR 22 unused
                                    // VSR 23 unused
#define CYGNUM_HAL_VECTOR_TC0    24 // Timer Counter 0
#define CYGNUM_HAL_VECTOR_TC1    25 // Timer Counter 1
#define CYGNUM_HAL_VECTOR_TC2    26 // Timer Counter 2
#define CYGNUM_HAL_VECTOR_UHP    27 // USB Host port
#define CYGNUM_HAL_VECTOR_EMAC   28 // Ethernet MAC
#define CYGNUM_HAL_VECTOR_ISI    29 // Image Sensor Interface
#define CYGNUM_HAL_VECTOR_US3    30 // USART 3
#define CYGNUM_HAL_VECTOR_US4    31 // USART 4
#define CYGNUM_HAL_VECTOR_US5    32 // USART 5
#define CYGNUM_HAL_VECTOR_TC3    33 // Timer Counter 3
#define CYGNUM_HAL_VECTOR_TC4    34 // Timer Counter 4
#define CYGNUM_HAL_VECTOR_TC5    35 // Timer Counter 5
#define CYGNUM_HAL_VECTOR_IRQ0   36 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_VECTOR_IRQ1   37 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_VECTOR_IRQ2   38 // Advanced Interrupt Controller (IRQ2)

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define CYGNUM_HAL_VECTOR_SYSTEM  8 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_VECTOR_PIOA    9 // Parallel IO Controller A
#define CYGNUM_HAL_VECTOR_PIOB   10 // Parallel IO Controller B
#define CYGNUM_HAL_VECTOR_PIOC   11 // Parallel IO Controller C
                                    // VSR 12 unused
#define CYGNUM_HAL_VECTOR_US0    13 // USART 0
#define CYGNUM_HAL_VECTOR_US1    14 // USART 1
#define CYGNUM_HAL_VECTOR_US2    15 // USART 2
#define CYGNUM_HAL_VECTOR_MCI    16 // Multimedia Card Interface
#define CYGNUM_HAL_VECTOR_UDP    17 // USB Device Port
#define CYGNUM_HAL_VECTOR_TWI    18 // Two-Wire Interface
#define CYGNUM_HAL_VECTOR_SPI    19 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SPI1   20 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SSC0   21 // Serial Synchronous Controller 0
#define CYGNUM_HAL_VECTOR_SSC1   22 // Serial Synchronous Controller 1
#define CYGNUM_HAL_VECTOR_SSC2   23 // Serial Synchronous Controller 2
#define CYGNUM_HAL_VECTOR_TC0    24 // Timer Counter 0
#define CYGNUM_HAL_VECTOR_TC1    25 // Timer Counter 1
#define CYGNUM_HAL_VECTOR_TC2    26 // Timer Counter 2
#define CYGNUM_HAL_VECTOR_UHP    27 // USB Host port
#define CYGNUM_HAL_VECTOR_LCD    28 // LCD controller
                                    // VSRs 29..35 unused
#define CYGNUM_HAL_VECTOR_IRQ0   36 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_VECTOR_IRQ1   37 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_VECTOR_IRQ2   38 // Advanced Interrupt Controller (IRQ2)


#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define CYGNUM_HAL_VECTOR_SYSTEM  8 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_VECTOR_PIOA    9 // Parallel IO Controller A
#define CYGNUM_HAL_VECTOR_PIOB   10 // Parallel IO Controller B
#define CYGNUM_HAL_VECTOR_PIOC   11 // Parallel IO Controllers C, D & E
                                    // VSR 12 unused
                                    // VSR 13 unused
#define CYGNUM_HAL_VECTOR_US0    14 // USART 0
#define CYGNUM_HAL_VECTOR_US1    15 // USART 1
#define CYGNUM_HAL_VECTOR_US2    16 // USART 2
#define CYGNUM_HAL_VECTOR_MCI    17 // Multimedia Card Interface 0
#define CYGNUM_HAL_VECTOR_MCI1   18 // Multimedia Card Interface 1
#define CYGNUM_HAL_VECTOR_CAN    19 // CAN Bus Controller
#define CYGNUM_HAL_VECTOR_TWI    20 // Two-Wire Interface
#define CYGNUM_HAL_VECTOR_SPI    21 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SPI1   22 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SSC0   23 // Serial Synchronous Controller 0
#define CYGNUM_HAL_VECTOR_SSC1   24 // Serial Synchronous Controller 1
#define CYGNUM_HAL_VECTOR_AC97   25 // AC97 Controller
#define CYGNUM_HAL_VECTOR_TC0    26 // Timer Counters 0, 1 & 2
#define CYGNUM_HAL_VECTOR_PWM    27 // Pulse Width Modulator
#define CYGNUM_HAL_VECTOR_EMAC   28 // Ethernet MAC
                                    // VSR 29 unused
#define CYGNUM_HAL_VECTOR_2DGE   30 // 2D Graphics Engine
#define CYGNUM_HAL_VECTOR_UDP    31 // USB Device Port
#define CYGNUM_HAL_VECTOR_ISI    32 // Image Sensor Interface
#define CYGNUM_HAL_VECTOR_LCD    33 // LCD controller
#define CYGNUM_HAL_VECTOR_DMA    34 // DMA controller
                                    // VSR 35 unused
#define CYGNUM_HAL_VECTOR_UHP    36 // USB Host port
#define CYGNUM_HAL_VECTOR_IRQ0   37 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_VECTOR_IRQ1   38 // Advanced Interrupt Controller (IRQ1)

#else

#error Unknown SAM9 variant

#endif

// This makes the maximum acceptable VSR support all the above VSRs (checked
// in the kernel VSR support for example). But in practice the underlying
// hal_vsr_table remains at 8 entries.
#define CYGNUM_HAL_VSR_MAX       38


#if CYGINT_HAL_SAM9_AIC_VSR

#define HAL_VSR_GET( _vector_, _pvsr_ )                                 \
CYG_MACRO_START                                                         \
    CYG_ADDRESS __p;                                                    \
    if( (_vector_) < CYGNUM_HAL_VECTOR_FIQ )                            \
        __p = hal_vsr_table[(_vector_)];                                \
    else                                                                \
        HAL_READ_UINT32( _AIC_SVR + 4*((_vector_) - 7),  __p);          \
    *(CYG_ADDRESS *)(_pvsr_) = __p;                                     \
CYG_MACRO_END

#define HAL_VSR_SET( _vector_, _vsr_, _poldvsr_ )                       \
CYG_MACRO_START                                                         \
    if( (_poldvsr_) != NULL )                                           \
        HAL_VSR_GET( _vector_, _poldvsr_ );                             \
    if( (_vector_) < CYGNUM_HAL_VECTOR_FIQ )                            \
        hal_vsr_table[(_vector_)] = (CYG_ADDRESS)(_vsr_);               \
    else                                                                \
        HAL_WRITE_UINT32( _AIC_SVR + 4*((_vector_) - 7),                \
                          (CYG_ADDRESS)(_vsr_));                        \
CYG_MACRO_END

#endif
//==========================================================================
// Reset.

externC void cyg_hal_sam9_reset(void);
#define HAL_PLATFORM_RESET() cyg_hal_sam9_reset()

#define HAL_PLATFORM_RESET_ENTRY 0x00000000

//==========================================================================
// Power saving support.

__externC void cyg_hal_sam9_powersave_init( cyg_uint32 ip_addr );

__externC void cyg_hal_sam9_powerdown( void );

//==========================================================================
#endif // CYGONCE_HAL_VAR_INTS_H
