#ifndef CYGONCE_DEVS_SPI_ARM_SAM9260EK_H
#define CYGONCE_DEVS_SPI_ARM_SAM9260EK_H
//==========================================================================
//
//      spi_sam9260ek.h
//
//      Atmel AT91SAM9260EK SPI devices defines
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2006 Free Software Foundation, Inc.
// Copyright (C) 2006 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Date:          2006-10-27
//
//####DESCRIPTIONEND####
//
//==========================================================================
// NPCS lines
//
// SPI0 one line in PIOA and three in PIOC. We only use CS 0 and 1
// since 2 and 3 clash with the D16-31 lines in PIOC.
//
// SPI1 has one line in PIOB and three in PIOC.

#define AT91_SPI_PIO_NPCSA(__x) (((__x)&1)<<3)
#define AT91_SPI_PIO_NPCSC(__x) (((__x)&2)<<10)
#define AT91_SPI1_PIO_NPCSB(__x) ((((__x)&1)<<3))
#define AT91_SPI1_PIO_NPCSC(__x) ((((__x)&2)<<4)|(((__x)&4)<<2)|(((__x)&8)<<0))

//-----------------------------------------------------------------------------
// SAM9260EK SPI exported devices 

#define HAL_SPI_EXPORTED_DEVICES                        \
    externC cyg_spi_device *cyg_spi_dataflash_dev0;     \
    externC cyg_spi_device *cyg_spi_dataflash_dev1;

//-----------------------------------------------------------------------------

// NOTE: here we let the SPI controller control
//       the data in, out and clock signals, but
//       we need to handle the chip selects manually
//       in order to achieve better chip select control
//       inbetween transactions.

#define CYGHWR_AT91_SPI_CONFIGURE_SPI0()                                \
do {                                                                    \
    /* Put SPI MISO, MOIS and SPCK pins into peripheral A mode */       \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_PDR, AT91_PIO_PSR_SPI_SPCK |        \
                                         AT91_PIO_PSR_SPI_MISO |        \
                                         AT91_PIO_PSR_SPI_MOSI);        \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_ASR, AT91_PIO_PSR_SPI_SPCK |        \
                                         AT91_PIO_PSR_SPI_MISO |        \
                                         AT91_PIO_PSR_SPI_MOSI);        \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_ODR, AT91_PIO_PSR_SPI_SPCK |        \
                                         AT91_PIO_PSR_SPI_MISO |        \
                                         AT91_PIO_PSR_SPI_MOSI);        \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_PUER, AT91_PIO_PSR_SPI_SPCK |       \
                                         AT91_PIO_PSR_SPI_MISO |        \
                                         AT91_PIO_PSR_SPI_MOSI);        \
    /* Disable MCI clock (MCCK) on PA8 which is linked to */            \
    /* the SPI CLK (SPI0_SPCK) on SAM9260-EK, by setting  */            \
    /* it as a PIO input */                                             \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_ODR, 1<<8);                         \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_PER, 1<<8);                         \
                                                                        \
    /* Put SPI chip select pins in IO output mode */                    \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_SODR, AT91_SPI_PIO_NPCSA(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_PER,  AT91_SPI_PIO_NPCSA(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_OER,  AT91_SPI_PIO_NPCSA(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOA+_PIO_PUDR, AT91_SPI_PIO_NPCSA(0x0F));    \
                                                                        \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_SODR, AT91_SPI_PIO_NPCSC(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_PER,  AT91_SPI_PIO_NPCSC(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_OER,  AT91_SPI_PIO_NPCSC(0x0F));    \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_PUDR, AT91_SPI_PIO_NPCSC(0x0F));    \
} while(0)

#define CYGHWR_AT91_SPI_CONFIGURE_SPI1()                                \
do {                                                                    \
    /* Put SPI MISO, MOIS and SPCK pins into peripheral A mode */       \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_PDR, AT91_PIO_PSR_SPI1_SPCK |       \
                                         AT91_PIO_PSR_SPI1_MISO |       \
                                         AT91_PIO_PSR_SPI1_MOSI);       \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_ASR, AT91_PIO_PSR_SPI1_SPCK |       \
                                         AT91_PIO_PSR_SPI1_MISO |       \
                                         AT91_PIO_PSR_SPI1_MOSI);       \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_ODR, AT91_PIO_PSR_SPI1_SPCK |       \
                                         AT91_PIO_PSR_SPI1_MISO |       \
                                         AT91_PIO_PSR_SPI1_MOSI);       \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_PUER, AT91_PIO_PSR_SPI1_SPCK |      \
                                         AT91_PIO_PSR_SPI1_MISO |       \
                                         AT91_PIO_PSR_SPI1_MOSI);       \
                                                                        \
    /* Put SPI chip select pins in IO output mode */                    \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_SODR, AT91_SPI1_PIO_NPCSB(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_PER,  AT91_SPI1_PIO_NPCSB(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_OER,  AT91_SPI1_PIO_NPCSB(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOB+_PIO_PUDR, AT91_SPI1_PIO_NPCSB(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_SODR, AT91_SPI1_PIO_NPCSC(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_PER,  AT91_SPI1_PIO_NPCSC(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_OER,  AT91_SPI1_PIO_NPCSC(0x0F));   \
    HAL_WRITE_UINT32(SAM9_PIOC+_PIO_PUDR, AT91_SPI1_PIO_NPCSC(0x0F));   \
} while(0)


#define CYGHWR_AT91_SPI_CONFIGURE_PINS( __base )        \
{                                                       \
    if( __base == AT91_SPI )                            \
        CYGHWR_AT91_SPI_CONFIGURE_SPI0();               \
    else                                                \
        CYGHWR_AT91_SPI_CONFIGURE_SPI1();               \
}

#define CYGHWR_AT91_SPI_CLOCK_SPEED CYGARC_HAL_ARM_ARM9_SAM9_MCK


#define CYGHWR_AT91_SPI_RAISE_CS( __num, __bus )                                        \
{                                                                                       \
    if( __bus == 0 )                                                                    \
    {                                                                                   \
        HAL_WRITE_UINT32(SAM9_PIOA+_PIO_CODR, AT91_SPI_PIO_NPCSA(1<<(__num)));          \
        HAL_WRITE_UINT32(SAM9_PIOC+_PIO_CODR, AT91_SPI_PIO_NPCSC(1<<(__num)));          \
    }                                                                                   \
    else                                                                                \
    {                                                                                   \
        HAL_WRITE_UINT32(SAM9_PIOB+_PIO_CODR, AT91_SPI1_PIO_NPCSB(1<<(__num)));         \
        HAL_WRITE_UINT32(SAM9_PIOC+_PIO_CODR, AT91_SPI1_PIO_NPCSC(1<<(__num)));         \
    }                                                                                   \
}

#define CYGHWR_AT91_SPI_DROP_CS( __num, __bus )                                 \
{                                                                               \
    if( __bus == 0 )                                                            \
    {                                                                           \
        HAL_WRITE_UINT32(SAM9_PIOA+_PIO_SODR, AT91_SPI_PIO_NPCSA(0x0F));        \
        HAL_WRITE_UINT32(SAM9_PIOC+_PIO_SODR, AT91_SPI_PIO_NPCSC(0x0F));        \
    }                                                                           \
    else                                                                        \
    {                                                                           \
        HAL_WRITE_UINT32(SAM9_PIOB+_PIO_SODR, AT91_SPI1_PIO_NPCSB(0x0F));       \
        HAL_WRITE_UINT32(SAM9_PIOC+_PIO_SODR, AT91_SPI1_PIO_NPCSC(0x0F));       \
    }                                                                           \
}

#define CYGHWR_AT91_SPI_ENABLE_SPI_CLOCK( __bus )               \
{                                                               \
    if( __bus == 0 )                                            \
        HAL_WRITE_UINT32(_PMC_PCER, AT91_PMC_PCER_SPI);         \
    else                                                        \
        HAL_WRITE_UINT32(_PMC_PCER, AT91_PMC_PCER_SPI1);        \
}

#define CYGHWR_AT91_SPI_DISABLE_SPI_CLOCK( __bus )              \
{                                                               \
    if( __bus == 0 )                                            \
        HAL_WRITE_UINT32(_PMC_PCDR, AT91_PMC_PCER_SPI);         \
    else                                                        \
        HAL_WRITE_UINT32(_PMC_PCDR, AT91_PMC_PCER_SPI1);        \
}

//-----------------------------------------------------------------------------

#endif // CYGONCE_DEVS_SPI_ARM_SAM9260EK_H 

//-----------------------------------------------------------------------------
// End of spi_sam9260ek.h
