#ifndef CYGONCE_VPB926EJS_H
#define CYGONCE_VPB926EJS_H
/*=============================================================================
//
//      vpb926ejs.h
//
//      Platform specific support (register layout, etc)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2006, 2008 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: nickg
// Date:         2004-05-07
// Purpose:      ARM VPB926EJS platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/vpb926ejs.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/
// Memory layout details needed by conversion macro

#define VPB926EJS_SDRAM_PHYS_BASE         0x00000000
#define VPB926EJS_SDRAM_VIRT_BASE         0x00000000
#define VPB926EJS_SDRAM_SIZE              0x08000000
#define VPB926EJS_SDRAM_MASK              (VPB926EJS_SDRAM_SIZE-1)
#define VPB926EJS_SDRAM_UNCACHED_OFFSET   0x70000000

#define VPB926EJS_SRAM_PHYS_BASE          0x38000000
#define VPB926EJS_SRAM_VIRT_BASE          0x38000000
#define VPB926EJS_SRAM_SIZE               0x00200000
#define VPB926EJS_SRAM_MASK               (VPB926EJS_SRAM_SIZE-1)
#define VPB926EJS_SRAM_UNCACHED_OFFSET    0x40000000

#define VPB926EJS_FLASH_PHYS_BASE         0x34000000
#define VPB926EJS_FLASH_VIRT_BASE         0x34000000
#define VPB926EJS_FLASH_SIZE              0x04000000
#define VPB926EJS_FLASH_MASK              (VPB926EJS_FLASH_SIZE-1)
#define VPB926EJS_FLASH_UNCACHED_OFFSET   0x48000000

//===========================================================================
// FPGA System Control Registers

#define VPB926EJS_SYS   0x10000000

#define _SYS_ID         0x00
#define _SYS_SW         0x04
#define _SYS_LED        0x08
#define _SYS_OSC0       0x0C
#define _SYS_OSC1       0x10
#define _SYS_OSC2       0x14
#define _SYS_OSC3       0x18
#define _SYS_OSC4       0x1C
#define _SYS_LOCK       0x20
#define _SYS_100HZ      0x24
#define _SYS_CFGDATA1   0x28
#define _SYS_CFGDATA2   0x2C
#define _SYS_FLAGS      0x30
#define _SYS_FLAGSSET   0x30
#define _SYS_FLAGSCLR   0x34
#define _SYS_NVFLAGS    0x38
#define _SYS_NVFLAGSSET 0x38
#define _SYS_NVFLAGSCLR 0x3C
#define _SYS_RESETCTL   0x40
#define _SYS_PCICTL     0x44
#define _SYS_MCI        0x48
#define _SYS_FLASH      0x4C
#define _SYS_CLCD       0x50
#define _SYS_CLCDSER    0x54
#define _SYS_BOOTCS     0x58
#define _SYS_24MHZ      0x5C
#define _SYS_MISC       0x60
#define  _SYS_FPGA_REMAP (1<<2)
#define _SYS_TEST_OSC0  0x80
#define _SYS_TEST_OSC1  0x84
#define _SYS_TEST_OSC2  0x88
#define _SYS_TEST_OSC3  0x8C
#define _SYS_TEST_OSC4  0x90


//===========================================================================
// 926EJ-S System Controller

#define VPB926EJS_SC            0x101E0000

#define _SC_CTRL                0x000
#define  _SC_CTRL_MODE           0x007
#define  _SC_CTRL_MODE_NORMAL    0x004
#define  _SC_CTRL_REMAP          0x100
#define  _SC_CTRL_REMAP_STAT     0x200
#define  _SC_CTRL_WDEN           (1<<23)

//===========================================================================
// Interrupt controller

#define VPB926EJS_VIC                   0x10140000

#define _VIC_ISR                        0x00
#define _VIC_FSR                        0x04
#define _VIC_RSR                        0x08
#define _VIC_SELR                       0x0C
#define _VIC_IER                        0x10
#define _VIC_ICR                        0x14

#define VPB926EJS_SIC                   0x10003000

#define _SIC_ISR                        0x00
#define _SIC_RSR                        0x04
#define _SIC_IER                        0x08
#define _SIC_ICR                        0x0C

#define _SIC_PICSTAT                    0x20
#define _SIC_PICSET                     0x20
#define _SIC_PICCLR                     0x24

//===========================================================================
// Timers

#define VPB926EJS_TIMER0                0x101E2000
#define VPB926EJS_TIMER1                0x101E2020
#define VPB926EJS_TIMER2                0x101E3000
#define VPB926EJS_TIMER3                0x101E3020

#define _TIMER_LOAD                     0x00
#define _TIMER_VALUE                    0x04
#define _TIMER_CR                       0x08
#define  _TIMER_CR_ENABLED           0x80
#define  _TIMER_CR_PERIODIC          0x40
#define  _TIMER_CR_INT_ENABLED       0x20
#define  _TIMER_CR_PRESC_256         0x08
#define  _TIMER_CR_PRESC_16          0x04
#define  _TIMER_CR_PRESC_1           0x00
#define  _TIMER_CR_SIZE              0x02
#define  _TIMER_CR_ONE_SHOT          0x01
#define _TIMER_ICR                      0x0C
#define _TIMER_RIS                      0x10
#define _TIMER_MIS                      0x14
#define _TIMER_BGLOAD                   0x18

//===========================================================================
// MPMC memory controller

#define VPB926EJS_MPMC                  0x10110000

#define _MPMC_CTRL                      0x00
#define _MPMC_STATUS                    0x04
#define _MPMC_CONFIG                    0x08

#define _MPMC_Control                   0x000
#define _MPMC_Status                    0x004
#define _MPMC_Config                    0x008
#define _MPMC_DynamicControl            0x020
#define _MPMC_DynamicRefresh            0x024
#define _MPMC_DynamicReadConfig         0x028
#define _MPMC_DynamictRP                0x030
#define _MPMC_DynamictRAS               0x034
#define _MPMC_DynamictSREX              0x038
#define _MPMC_DynamictWR                0x044
#define _MPMC_DynamictRC                0x048
#define _MPMC_DynamictRFC               0x04c
#define _MPMC_DynamictXSR               0x050
#define _MPMC_DynamictRRD               0x054
#define _MPMC_DynamictMRD               0x058
#define _MPMC_DynamictCDLR              0x05c
#define _MPMC_StaticExtendedWait        0x080
#define _MPMC_DynamicConfig0            0x100
#define _MPMC_DynamicRasCas0            0x104
#define _MPMC_DynamicConfig1            0x120
#define _MPMC_DynamicRasCas1            0x124
#define _MPMC_DynamicConfig2            0x140
#define _MPMC_DynamicRasCas2            0x144
#define _MPMC_DynamicConfig3            0x160
#define _MPMC_DynamicRasCas3            0x164
#define _MPMC_AHBTimeout0               0x408
#define _MPMC_AHBTimeout1               0x428
#define _MPMC_AHBTimeout2               0x448  
#define _MPMC_AHBTimeout3               0x468
#define _MPMC_AHBTimeout4               0x488
#define _MPMC_AHBTimeout5               0x4a8

//===========================================================================
// SSMC memory controller

#define VPB926EJS_SSMC                  0x10100000

#define _SSMC_BANK0_CR                  0x34
#define _SSMC_BANK1_CR                  0x54
#define _SSMC_BANK2_CR                  0x74
#define _SSMC_BANK3_CR                  0x94

//===========================================================================
// UARTs

#define VPB926EJS_UART0                 0x101F1000
#define VPB926EJS_UART1                 0x101F2000
#define VPB926EJS_UART2                 0x101F3000

#define _UART_DR                   0x00     /*  Data read or written from the interface. */

#define _UART_RSR                  0x04     /*  Receive status register (Read). */
#define _UART_ECR                  0x04     /*  Error clear register (Write). */
#define  _UART_RSR_OE               0x08
#define  _UART_RSR_BE               0x04
#define  _UART_RSR_PE               0x02
#define  _UART_RSR_FE               0x01

#define _UART_FR                   0x18     /*  Flag register (Read only). */
#define  _UART_FR_RI                0x100
#define  _UART_FR_TXFE              0x080
#define  _UART_FR_RXFF              0x040
#define  _UART_FR_TXFF              0x020
#define  _UART_FR_RXFE              0x010
#define  _UART_FR_BUSY              0x008
#define  _UART_FR_DCD               0x004
#define  _UART_FR_DSR               0x002
#define  _UART_FR_CTS               0x001

#define _UART_IBRD                 0x24
#define _UART_FBRD                 0x28

#define _UART_LCRH                 0x2C
#define  _UART_LCRH_SPS             (1 << 7)
#define  _UART_LCRH_WLEN_8          (3 << 5)
#define  _UART_LCRH_WLEN_7          (2 << 5)
#define  _UART_LCRH_WLEN_6          (1 << 5)
#define  _UART_LCRH_WLEN_5          (0 << 5)
#define  _UART_LCRH_FEN             (1 << 4)
#define  _UART_LCRH_STP2            (1 << 3)
#define  _UART_LCRH_EPS             (1 << 2)
#define  _UART_LCRH_PEN             (1 << 1)
#define  _UART_LCRH_BRK             (1 << 0)

#define _UART_CR                   0x30
#define  _UART_CR_CTSEN             (1 << 15)
#define  _UART_CR_RTSEN             (1 << 14)
#define  _UART_CR_OUT2              (1 << 13)
#define  _UART_CR_OUT1              (1 << 12)
#define  _UART_CR_RTS               (1 << 11)
#define  _UART_CR_DTR               (1 << 10)
#define  _UART_CR_RXE               (1 << 9)
#define  _UART_CR_TXE               (1 << 8)
#define  _UART_CR_LPE               (1 << 7)
#define  _UART_CR_IIRLP             (1 << 2)
#define  _UART_CR_SIREN             (1 << 1)
#define  _UART_CR_UARTEN            (1 << 0)

#define _UART_IMSC                 0x38
#define _UART_MIS                  0x40
#define _UART_ICR                  0x44
#define  _UART_IMSC_OEIM            (1 << 10)
#define  _UART_IMSC_BEIM            (1 << 9)
#define  _UART_IMSC_PEIM            (1 << 8)
#define  _UART_IMSC_FEIM            (1 << 7)
#define  _UART_IMSC_RTIM            (1 << 6)
#define  _UART_IMSC_TXIM            (1 << 5)
#define  _UART_IMSC_RXIM            (1 << 4)
#define  _UART_IMSC_DSRMIM          (1 << 3)
#define  _UART_IMSC_DCDMIM          (1 << 2)
#define  _UART_IMSC_CTSMIM          (1 << 1)
#define  _UART_IMSC_RIMIM           (1 << 0)

//===========================================================================
// Watchdog

#define VPB926EJS_WDOG                  0x101E1000
// For watchdog driver:
#define _WDOG_BASE                      VPB926EJS_WDOG
#define _WDOG_CLK                       40000


#define _WDOG_LOAD              0x000
#define _WDOG_VALUE             0x004
#define _WDOG_CTRL              0x008
#define  _WDOG_CTRL_INTEN       (1<<0)
#define  _WDOG_CTRL_RESEN       (1<<1)
#define _WDOG_ICLR              0x00C
#define _WDOG_RIS               0x010
#define _WDOG_MIS               0x014

#define _WDOG_LOCK              0xC00
#define  _WDOG_LOCK_ACCESS      0x1ACCE551

//===========================================================================
// I2C support

#define VPB926EJS_I2C           0x10002000

#define _I2C_READ               0x00
#define _I2C_SET                0x00
#define _I2C_CLR                0x04

#define _I2C_SCL                0x01
#define _I2C_SDA                0x02
#define _I2C_BOTH               0x03


#ifndef __ASSEMBLER__

__externC int _vpb926ejs_i2c_write_reg(int addr, int reg, unsigned char val);

__externC int _vpb926ejs_i2c_read_reg(int addr, int reg);

#endif

//===========================================================================
// Character LCD

#define VPB926EJS_CLCD          0x10008000

#define _CLCD_COM               0x00
#define _CLCD_DAT               0x04
#define _CLCD_RD                0x08
#define _CLCD_RAW               0x0C
#define _CLCD_MASK              0x10
#define _CLCD_STAT              0x14

#define _CLCD_BUSY              0x80

// Commands
#define _CLCD_CLR_DISPLAY    1
#define _CLCD_HOME           2
#define _CLCD_ENTRY_MODE_SET 4
#define _CLCD_DISP_CTRL      8
#define _CLCD_CUR_DIS_SHIFT  16
#define _CLCD_FUNC_SET       32
#define _CLCD_CGRAM_ADDR     64
#define _CLCD_DDRAM_ADDR     128

#define _CLCD_INC             2                              
#define _CLCD_DEC             0
#define _CLCD_COM_DIS_SHIFT   1
#define _CLCD_DISP_ON         4
#define _CLCD_CURS_ON         2
#define _CLCD_BLINK_ON        1
#define _CLCD_DISP_OFF        0
#define _CLCD_CURS_OFF        0
#define _CLCD_BLINK_OFF       0
#define _CLCD_DISP_SHIFT      8
#define _CLCD_CURS_SHIFT      0
#define _CLCD_SHIFT_RIGHT     4
#define _CLCD_SHIFT_LEFT      0
#define _CLCD_IF4BIT          0
#define _CLCD_IF8BIT          0x10
#define _CLCD_NUMLINES2       8
#define _CLCD_NUMLINES1       0
#define _CLCD_FONT5X10        4
#define _CLCD_FONT5X8         0


/*---------------------------------------------------------------------------*/
/* end of vpb926ejs.h                                                        */
#endif /* CYGONCE_VPB926EJS_H */
