//==========================================================================
//
//      omap_l1xx_spi.c
//
//      Support for the SPI devices on LM3S8962-EVAL board
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2008-02-27
//
//####DESCRIPTIONEND####
//=============================================================================

#include <pkgconf/hal.h>
#include <pkgconf/io_spi.h>
#include <pkgconf/hal_arm_arm9_omap_l1xx.h>
#include <pkgconf/hal_arm_arm9_zoom_l138.h>


#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_intr.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/io/spi.h>
#include <cyg/io/spi_omap.h>

// -------------------------------------------------------------------------
// SPI bus 0

#ifdef CYGPKG_HAL_ARM_ZOOM_L1XX_SPI0

static const cyg_uint32 cyg_spi_omap_bus0_cs_pins[] = { CYGDAT_HAL_ARM_ZOOM_L138_SPI0_CS_PINS };

static const cyg_uint32 cyg_spi_omap_bus0_cs_pinmux[] =
{
    CYGHWR_HAL_OMAP_SPI0_CS0, 
    CYGHWR_HAL_OMAP_SPI0_CS1, 
    CYGHWR_HAL_OMAP_SPI0_CS2, 
    CYGHWR_HAL_OMAP_SPI0_CS3, 
    CYGHWR_HAL_OMAP_SPI0_CS4, 
    CYGHWR_HAL_OMAP_SPI0_CS5
};

cyg_spi_omap_bus_t cyg_spi_omap_bus0 =
{
    .spi_bus.spi_transaction_begin    = cyg_spi_omap_transaction_begin,
    .spi_bus.spi_transaction_transfer = cyg_spi_omap_transaction_transfer,
    .spi_bus.spi_transaction_tick     = cyg_spi_omap_transaction_tick,
    .spi_bus.spi_transaction_end      = cyg_spi_omap_transaction_end,
    .spi_bus.spi_get_config           = cyg_spi_omap_get_config,
    .spi_bus.spi_set_config           = cyg_spi_omap_set_config,
    
    .interrupt_number                 = CYGNUM_HAL_INTERRUPT_SPI0,
    .interrupt_priority               = 15,
    .base                             = CYGHWR_HAL_L1XX_SPI0,
    .cs_pinmux                        = cyg_spi_omap_bus0_cs_pinmux,
    .bus_num                          = 0,
    .enable                           = CYGHWR_HAL_OMAP_SPI0_POWER,
    .sclk_pin                         = CYGHWR_HAL_OMAP_SPI0_CLK,
    .miso_pin                         = CYGHWR_HAL_OMAP_SPI0_MISO,
    .mosi_pin                         = CYGHWR_HAL_OMAP_SPI0_MOSI,
    .cs_pin                           = &cyg_spi_omap_bus0_cs_pins[0],
    .cs_count                         = sizeof(cyg_spi_omap_bus0_cs_pins)/sizeof(cyg_uint32),
    .tx_dma                           = CYGHWR_HAL_OMAP_SPI0_TXDMA,
    .rx_dma                           = CYGHWR_HAL_OMAP_SPI0_RXDMA,
};

CYG_SPI_DEFINE_BUS_TABLE( cyg_spi_omap_device_t, 0 );

#endif

// -------------------------------------------------------------------------
// SPI bus 1

#ifdef CYGPKG_HAL_ARM_ZOOM_L1XX_SPI1

static const cyg_uint32 cyg_spi_omap_bus1_cs_pins[] = { CYGDAT_HAL_ARM_ZOOM_L138_SPI1_CS_PINS };

static const cyg_uint32 cyg_spi_omap_bus1_cs_pinmux[] =
{
    CYGHWR_HAL_OMAP_SPI1_CS0, 
    CYGHWR_HAL_OMAP_SPI1_CS1, 
    CYGHWR_HAL_OMAP_SPI1_CS2, 
    CYGHWR_HAL_OMAP_SPI1_CS3, 
    CYGHWR_HAL_OMAP_SPI1_CS4, 
    CYGHWR_HAL_OMAP_SPI1_CS5,
    CYGHWR_HAL_OMAP_SPI1_CS6,
    CYGHWR_HAL_OMAP_SPI1_CS7
};

cyg_spi_omap_bus_t cyg_spi_omap_bus1 =
{
    .spi_bus.spi_transaction_begin    = cyg_spi_omap_transaction_begin,
    .spi_bus.spi_transaction_transfer = cyg_spi_omap_transaction_transfer,
    .spi_bus.spi_transaction_tick     = cyg_spi_omap_transaction_tick,
    .spi_bus.spi_transaction_end      = cyg_spi_omap_transaction_end,
    .spi_bus.spi_get_config           = cyg_spi_omap_get_config,
    .spi_bus.spi_set_config           = cyg_spi_omap_set_config,
    
    .interrupt_number                 = CYGNUM_HAL_INTERRUPT_SPI1,
    .interrupt_priority               = 15,
    .base                             = CYGHWR_HAL_L1XX_SPI1,
    .cs_pinmux                        = cyg_spi_omap_bus1_cs_pinmux,    
    .bus_num                          = 1,
    .enable                           = CYGHWR_HAL_OMAP_SPI1_POWER,
    .sclk_pin                         = CYGHWR_HAL_OMAP_SPI1_CLK,
    .miso_pin                         = CYGHWR_HAL_OMAP_SPI1_MISO,
    .mosi_pin                         = CYGHWR_HAL_OMAP_SPI1_MOSI,
    .cs_pin                           = &cyg_spi_omap_bus1_cs_pins[0],
    .cs_count                         = sizeof(cyg_spi_omap_bus1_cs_pins)/sizeof(cyg_uint32),
    .tx_dma                           = CYGHWR_HAL_OMAP_SPI1_TXDMA,
    .rx_dma                           = CYGHWR_HAL_OMAP_SPI1_RXDMA,
};

CYG_SPI_DEFINE_BUS_TABLE( cyg_spi_omap_device_t, 1 );

#endif

// -------------------------------------------------------------------------
// M25P64 SPI flash
//
// This is on SPI1 CS0

#ifdef CYGHWR_HAL_ARM_ARM9_OMAP_L1XX_FLASH_M25P64

#include <cyg/io/m25pxx.h>

cyg_spi_omap_device_t cyg_m25pxx_spi_device CYG_SPI_DEVICE_ON_BUS(1) = 
{
    .spi_device.spi_bus = &cyg_spi_omap_bus1.spi_bus,

    .dev_num     = 0,       // Device number
    .cl_pol      = 0,       // Clock polarity (0 or 1)
    .cl_pha      = 1,       // Clock phase (0 or 1)
    .cl_brate    = 50000000, // Clock baud rate.
    .cs_up_udly  = 1,       // Delay in usec between CS up and transfer start.
    .cs_dw_udly  = 1,       // Delay in usec between transfer end and CS down
    .tr_bt_udly  = 1        // Delay in usec between two transfers
};

// Instantiate the M25Pxx device driver.

CYG_DEVS_FLASH_SPI_M25PXX_DRIVER ( m25pxx_flash_device,
                                   0x70000000,
                                   &cyg_m25pxx_spi_device );

#endif

//=============================================================================
// EOF omap_l1xx_spi.c
