#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2006, 2007, 2008 Free Software Foundation, Inc.
// Copyright (C) 2006, 2007, 2008 eCosCentric Limited
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later
// version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License
// along with eCos; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// As a special exception, if other files instantiate templates or use
// macros or inline functions from this file, or you compile this file
// and link it with other works to produce a work based on this file,
// this file does not by itself cause the resulting work to be covered by
// the GNU General Public License. However the source code for this file
// must still be made available in accordance with section (3) of the GNU
// General Public License v2.
//
// This exception does not invalidate any other reasons why a work based
// on this file might be covered by the GNU General Public License.
// -------------------------------------------
// ####ECOSGPLCOPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   gthomas
// Contributors:gthomas, asl, dhogg
// Date:        2010-07-28
// Purpose:     AT91SAM7S platform specific support routines, updated
//              to include initialisation of the EBI
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>
#include <cyg/hal/plf_io.h>


// Macro to initialise the Memory Controller
        .macro _flash_init
__flash_init__:
        ldr     r0,=AT91_MC+AT91_MC_EFC0
        // When the clock is running faster than 30MHz we need wait states
        // The X512 (rev A at least) has flash access problems, so we
        // run it at 2FWS for all speeds.
#if (CYGNUM_HAL_ARM_AT91_CLOCK_SPEED > 60000000) || defined(CYGHWR_HAL_ARM_AT91SAM7_at91sam7x512) || defined(CYGHWR_HAL_ARM_AT91SAM7_at91sam7s512)
        // When the clock is running faster than 60MHz we need two wait states
        ldr     r1,=(AT91_MC_FMR_2FWS)
#elif CYGNUM_HAL_ARM_AT91_CLOCK_SPEED > 30000000
        // When the clock is running faster than 30MHz we need a wait state
        ldr     r1,=(AT91_MC_FMR_1FWS)
#else
        // We have a slow clock, no extra wait states are needed
        ldr     r1,=(AT91_MC_FMR_0FWS)
#endif
        str     r1,[r0,#AT91_MC_EFCN(0)+AT91_MC_FMR]
#if defined(AT91_MC_FMR1)
        str     r1,[r0,#AT91_MC_EFCN(1)+AT91_MC_FMR]
#endif
        .endm

// ----------------------------------------------------------------
        // Set up external memory controller:
        // CS0 - FLASH
        // CS1 - static RAM
        // CS2 - LCD display

//        ldr     r4,=CYGARC_HAL_STR7XX_EMI_BASE
//        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(3)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_16)
//        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON0]
//        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(3)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_16)
//        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON1]
//        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(10)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_8)
//        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(15)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_8)
//        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON2]

// ebi stuff
//         mask        PIO               ID            TYPE       ATTR
//    {0x80000000, AT91C_BASE_PIOA, AT91C_ID_PIOA, PIO_INPUT, PIO_PULLUP},
//    {0x0003FFFF, AT91C_BASE_PIOB, AT91C_ID_PIOB, PIO_PERIPH_B, PIO_DEFAULT},
//    {0x000FFFFF, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_PERIPH_A, PIO_DEFAULT},
//    {0x00E00000, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_PERIPH_B, PIO_DEFAULT}

        .macro _ebi_init
__ebi_init:

		// from BOARD_ConfigureFlash48MHz
		ldr     r0,=(AT91_MC + AT91_MC_EFC0)
		ldr		r1,=(0x2 <<  8)
		str     r1, [r0]

		ldr		r0,=(AT91_PMC + AT91_PMC_PCER)
		ldr		r1, =4
		str		r1,[r0]

		// Set up the PIO pins for the flash chip
		// First to be set up is PA31 for ry/by

		ldr		r0,=(AT91_PIOA + AT91_PIO_IDR)
		ldr		r1, =0x80000000
		str		r1,[r0]

		ldr		r0,=(AT91_PIOA + AT91_PIO_PPUER)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOA + AT91_PIO_IFDR)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOA + AT91_PIO_ODR)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOA )//+ AT91_PIO_PDR)
		str		r1,[r0]

		// Next setup PIOB First to be set up is PA31 for ry/by
		ldr		r0,=(AT91_PIOB + AT91_PIO_IDR)
		ldr		r1,=0x0003FFFF
		str		r1,[r0]

		ldr		r0,=(AT91_PIOB + AT91_PIO_PPUER)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOB + AT91_PIO_BSR)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOB + AT91_PIO_PDR)
		str		r1,[r0]

		// Next setup PIOC Peripheral A
		ldr		r0,=(AT91_PIOC + AT91_PIO_IDR)
		ldr		r1,=0x001FFFFF
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_PPUER)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_ASR)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_PDR)
		str		r1,[r0]

		// Next setup PIOC Peripheral B
		ldr		r0,=(AT91_PIOC + AT91_PIO_IDR)
		ldr		r1,=0x00E00000
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_PPUER)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_BSR)
		str		r1,[r0]

		ldr		r0,=(AT91_PIOC + AT91_PIO_PDR)
		str		r1,[r0]

		// Setup the memory control for the NOR flash at CSR0
		ldr 	r0,=(AT91_EBI_SMC_CSR_NWS(6)|AT91_EBI_SMC_CSR_WSEN|AT91_EBI_SMC_CSR_TDF(0)|AT91_EBI_SMC_CSR_BAT_1x16|	   \
				  	AT91_EBI_SMC_CSR_DBW_16|AT91_EBI_SMC_CSR_DRP_STD|AT91_EBI_SMC_CSR_ACSS(0)|AT91_EBI_SMC_CSR_RWSETUP(0)|   \
				  	AT91_EBI_SMC_CSR_RWHOLD(3))
		ldr 	r4,=(AT91_MC+AT91_EBI_SMC_CSR(0))
		str		r0,[r4]
		.endm

// Macro to start the main clock.
        .macro  _main_clock_init
__main_clock_init__:
        ldr     r0,=AT91_PMC

          // Check that we have a stable clock before we start switching
wait_pmc_sr_0:
        ldr     r1,[r0,#AT91_PMC_SR]
        ands    r1,r1,#AT91_PMC_SR_MCKRDY
        beq     wait_pmc_sr_0

          // Swap to the slow clock, just to be sure.
        ldr     r1,=(AT91_PMC_MCKR_PRES_CLK|AT91_PMC_MCKR_SLOW_CLK)
        str     r1,[r0,#AT91_PMC_MCKR]

        // Wait for the MCLK ready indication
wait_pmc_sr_1:
        ldr     r1,[r0,#AT91_PMC_SR]
        ands    r1,r1,#AT91_PMC_SR_MCKRDY
        beq     wait_pmc_sr_1

#if defined(CYGNUM_HAL_ARM_AT91_CLOCK_TYPE_EXTCLOCK)
        ldr     r1,=(AT91_PMC_MOR_OSCBYPASS)
#else
        ldr     r1,=(AT91_PMC_MOR_OSCCOUNT(CYGNUM_HAL_ARM_AT91_PMC_MOR_OSCCOUNT)|AT91_PMC_MOR_MOSCEN)
#endif
        str     r1,[r0,#AT91_PMC_MOR]

        // Wait for oscilator start timeout
wait_pmc_sr_2:
        ldr     r1,[r0,#AT91_PMC_SR]
        ands    r1,r1,#AT91_PMC_SR_MOSCS
        beq     wait_pmc_sr_2

        // Set the PLL multiplier and divider.
        // First disable it, just in case JTAG init enabled it.
        ldr     r2,=AT91_PMC_PLLR_MUL(0)
        str     r2,[r0,#AT91_PMC_PLLR]

        // 16 slow clocks go by before the LOCK bit is set.
        ldr     r2,=((AT91_PMC_PLLR_DIV(CYGNUM_HAL_ARM_AT91_PLL_DIVIDER))|(AT91_PMC_PLLR_PLLCOUNT(CYGNUM_HAL_ARM_AT91_PLL_COUNT))|(AT91_PMC_PLLR_MUL(CYGNUM_HAL_ARM_AT91_PLL_MULTIPLIER-1)))
        str     r2,[r0,#AT91_PMC_PLLR]

        // Wait for PLL locked indication
wait_pmc_sr_3:
        ldr     r1,[r0,#AT91_PMC_SR]
        ands    r1,r1,#AT91_PMC_SR_LOCK
        beq     wait_pmc_sr_3

        // Enable the PLL clock and set the prescale to 2 */
        ldr     r1,=(AT91_PMC_MCKR_PRES_CLK_2|AT91_PMC_MCKR_PLL_CLK)
        str     r1,[r0,#AT91_PMC_MCKR]

        // Wait for the MCLK ready indication
wait_pmc_sr_4:
        ldr     r1,[r0,#AT91_PMC_SR]
        ands    r1,r1,#AT91_PMC_SR_MCKRDY
        beq     wait_pmc_sr_4
        .endm

// Remap the flash from address 0x0 and place RAM there instead.
        .macro  _remap_flash
__remap_flash:
        ldr     r0,=0x000004 // Use the underfined instruction exception
        ldr     r1,=0x200004
        ldr     r2,[r0]      // Save away copies so we can restore them
        ldr     r3,[r1]
        ldr     r4,=0xffffff
        eor     r4,r3,r4     // XOR the contents of 0x20004
        str     r4,[r1]      // and write it
        ldr     r5,[r0]      // Read from low memory
        cmp     r5,r4
        beq     remap_done
        ldr     r0,=AT91_MC  // Need to do a remap
        ldr     r5,=1
        str     r5,[r0,#AT91_MC_RCR]
remap_done:
        str     r3,[r1]      // restore the value we changed
        .endm

//-----------------------------------------------------------------------------


// Macro to initialise the Memory Controller
        .macro _sam7a_amc_init
__amc_init:
        ldr     r0,=AT91_AMC
        ldr     r1,=0x400030a9
        str     r1,[r0,#AT91_AMC_CSR0]
        ldr     r1,=0x48003081
        str     r1,[r0,#AT91_AMC_CSR1]
        ldr     r1,=0x00000010
        str     r1,[r0,#AT91_AMC_MCR]
        .endm

// Macro to start the main clock.
        .macro  _sam7a_main_clock_init
__main_clock_init:
        // Switch off PLL
        ldr     r0,=AT91_CM
        ldr     r1,=(AT91_CM_CS_PLLSLCT|AT91_CM_CD_KEY)
        str     r1,[r0,#AT91_CM_CD]
        // Now initialize the clocks
        ldr     r1,=AT91_CM_PDIV_INIT
        str     r1,[r0,#AT91_CM_PDIV]
        ldr     r1,=AT91_CM_CD_INIT
        str     r1,[r0,#AT91_CM_CD]
        ldr     r1,=AT91_CM_CE_INIT
        str     r1,[r0,#AT91_CM_CE]
        ldr     r1,=AT91_CM_MDIV_INIT
        str     r1,[r0,#AT91_CM_MDIV]
        .endm

// Remap the flash from address 0x0 and place on-chip RAM there instead.
        .macro  _sam7a_remap_flash
__remap_flash:
        ldr     r2,=__remap_done                // Address in ROM
        ldr     r0,=AT91_AMC
        ldr     r1,=AT91_AMC_RCR_RCB
        str     r1,[r0,#AT91_AMC_RCR]
        mov     pc,r2                           // Jump to remapped dest
__remap_done:
        .endm


//-----------------------------------------------------------------------------

#if defined(CYG_HAL_STARTUP_ROM)
#warning rom build
#if defined(CYGHWR_HAL_ARM_AT91SAM7A)
        .macro  _setup
        _sam7a_amc_init
        _sam7a_main_clock_init
        _sam7a_remap_flash
        .endm
#else
        .macro  _setup
        _flash_init
        _main_clock_init
        _remap_flash
        .endm
#endif

#define PLATFORM_SETUP1     _setup
#else
#warning NOT ROM STARTUP
#if defined(CYGHWR_HAL_ARM_AT91SAM7A)
#warning SAM7A
#define PLATFORM_SETUP1
#else
#warning NOT SAM7A (ebi)
#define PLATFORM_SETUP1     _ebi_init ; _remap_flash
#endif
#endif

#if defined(CYGHWR_HAL_ARM_AT91SAM7A)
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#endif

//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
