#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Keil MCB2387 specific registers and I/O defines
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006, 2008 Free Software Foundation, Inc.            
// Copyright (C) 2004, 2006, 2008 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2004-09-27
// Purpose:      Keil MCB2387 specific registers
// Description:
// Usage:       #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#define HAL_39VFXXX_UNCACHED_ADDRESS(__x) (__x)

//-----------------------------------------------------------------------------
// Use fast GPIO registers

#define CYGHWR_HAL_LPC2XXX_FAST_GPIO 1

//----------------------------------------------------------------------------
// Memory access checks.

// Accesses to areas not backed by real devices or memory can cause
// the CPU to hang. These macros allow GDB to avoid making accidental
// accesses to this area.
//
// We isolate the top 4 bits of the address and use a bitmap to
// describe which areas are accessible.

#define CYG_HAL_STUB_PERMIT_DATA_MAP ((1<<0x0)|(1<<0x3)|(1<<0x4)|(1<<0x7)|(1<<0x8)|(1<<0xA)|(1<<0xE)|(1<<0xF))

#define CYG_HAL_STUB_PERMIT_DATA_READ(_addr_, _count_)  \
({                                                      \
    cyg_uint32 __addr = _addr_;                         \
    int __area = (__addr>>28)&0xF;                      \
    cyg_uint16 __map = CYG_HAL_STUB_PERMIT_DATA_MAP;    \
    __map&(1<<__area);                                  \
})

#define CYG_HAL_STUB_PERMIT_DATA_WRITE(_addr_, __count_) \
        CYG_HAL_STUB_PERMIT_DATA_READ(_addr_, _count_)

//-----------------------------------------------------------------------------
// I2C devices

#if defined(CYGPKG_HAL_ARM_LPC2XXX_I2C)

# define HAL_I2C_EXPORTED_DEVICES

#endif


//-----------------------------------------------------------------------------


#if !defined(HAL_IDLE_THREAD_ACTION) && defined(CYGIMP_HAL_ARM_LPC2XXX_IDLE_THREAD_USES_IDLE)

#define HAL_IDLE_THREAD_ACTION(__count)                                 \
CYG_MACRO_START                                                         \
{                                                                       \
    cyg_uint32 __ix = ((__count)>>4)&15;                                \
    cyg_uint32 __mask = 1<<(__ix&8 ? 7-(__ix&7) : (__ix&7));            \
    HAL_WRITE_UINT32(CYGARC_HAL_LPC2XXX_REG_FIO_BASE+CYGARC_HAL_LPC2XXX_REG_FIOCLR(2), 0xFF ); \
    HAL_WRITE_UINT32(CYGARC_HAL_LPC2XXX_REG_FIO_BASE+CYGARC_HAL_LPC2XXX_REG_FIOSET(2), __mask ); \
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_SCB_BASE + CYGARC_HAL_LPC2XXX_REG_PCON, \
                     CYGARC_HAL_LPC2XXX_REG_PCON_IDL );                 \
}                                                                       \
CYG_MACRO_END

#endif

//-----------------------------------------------------------------------------
// MMC/SD Interface (MCI) bus

// Only files that need the below defines will have set __MMCSD_DRIVER_PRIVATE before inclusion.
#ifdef __MMCSD_DRIVER_PRIVATE

#include <pkgconf/system.h>
#ifdef CYGPKG_DEVS_MMCSD_ARM_PRIMECELL_MCI
#include <cyg/infra/cyg_type.h>
#include <pkgconf/mmcsd_primecell_mci.h>
#include <cyg/hal/hal_io.h> // just in case we were included directly

// Only one socket, so ignore card and bus throughout below.

// Platform hook for bus initialisation, independent of socket, e.g.
// socket-independent pin config.
// err only needs to be set if there's an error.
struct cyg_mmcsd_bus; /* forward declaration */
__externC void cyg_hal_mcb2387_mmcsd_init_bus( struct cyg_mmcsd_bus * );
#define HAL_MMCSD_PLF_INIT_BUS( _bus_, _err_ )                          \
    CYG_MACRO_START                                                     \
    cyg_hal_mcb2387_mmcsd_init_bus( _bus_ );                         \
    CYG_MACRO_END

// Platform hook for retrieval of capabilities for each socket.
// Sets socket's sockethw_caps and sockethw_vdd fields.
// err only needs to be set if there's an error.
#ifdef CYGIMP_DEVS_MMCSD_PRIMECELL_MCI_INTMODE
# define __MCI_INTMODE 1
#else
# define __MCI_INTMODE 0
#endif

// NB: Commented out part is because the EA board does not have card
// detect support. Left in as commented to give a hint as to what to
// do on boards derived from this HAL which do have card detect support.
#define HAL_MMCSD_PLF_GET_SOCKET_CAPABILITY(_bus_, _socket_, _err_)     \
    CYG_MACRO_START                                                     \
    (_socket_)->sockethw_caps.valid = 1;                                \
    (_socket_)->sockethw_caps.sd = 1;                                   \
    (_socket_)->sockethw_caps.fourbit = 1;                              \
    /*    (_socket_)->sockethw_caps.card_detect = 1;                    \
          (_socket_)->sockethw_caps.card_detect_int = __MCI_INTMODE; */ \
    (_socket_)->sockethw_caps.card_detect = 0;                          \
    (_socket_)->sockethw_caps.card_detect_int = 0;                      \
    (_socket_)->sockethw_vdd = MMCSD_OCR_REGISTER_VDD_32_33;            \
    (_socket_)->sockethw_caps.multiblock_io = 0;                        \
    CYG_MACRO_END
    

// Platform hook for initialising socket, primarily pin configuration.
// err only needs to be set if there's an error.
struct cyg_mmcsd_card; /* forward declaration */
__externC void cyg_hal_mcb2387_mmcsd_init_socket( struct cyg_mmcsd_card * );
#define HAL_MMCSD_PLF_INIT_SOCKET( _card_, _err_ )                      \
    CYG_MACRO_START                                                     \
    cyg_hal_mcb2387_mmcsd_init_socket( _card_ );                     \
    CYG_MACRO_END


// Primecell MCI MCLK frequency
// By persistent pestering of NXP I learnt that on the LPC2468, MCLK == PCLK
// something which is entirely undocumented!
// In cyg_hal_mcb2387_mmcsd_init_bus() we set PCLK to CCLK, hence:
#define HAL_MMCSD_PLF_PRIMECELL_MCLK              (CYGNUM_HAL_ARM_LPC2XXX_CCLK_SPEED)

// Unfortunately the LPC2468 cannot always keep up with the data transfer
// requirements at slower CPU speeds. Therefore we limit the max MCI bus
// frequency.
#define HAL_MMCSD_PLF_LIMIT_MCI_BUS_SPEED( _f_wanted_, _f_ )    \
    CYG_MACRO_START                                             \
    if ((_f_wanted_) > CYGNUM_HAL_ARM_LPC2XXX_MCB2387_MCI_BUS_SPEED_LIMIT) { \
        (_f_) = CYGNUM_HAL_ARM_LPC2XXX_MCB2387_MCI_BUS_SPEED_LIMIT;  \
    } else {                                                    \
        (_f_) = (_f_wanted_);                                   \
    }                                                           \
    CYG_MACRO_END

// If asked to use USB memory for MCI DMA, then the following hook
// is used by the LPC2XXX MCI support in lpc2xxx_mci.c to indicate
// the DMA address.
#ifdef CYGSEM_HAL_ARM_LPC2XXX_MCB2387_MCI_USE_USB_MEM_FOR_DMA
#define HAL_ARM_LPC2XXX_MCI_NEEDS_ALT_DMA_BUF( _card_, _read_,          \
                                               _buf_, _bufsize_,        \
                                               _dmabuf_ )               \
    CYG_MACRO_START                                                     \
    *(_dmabuf_) = (cyg_uint8 *)0x7FD00000;                              \
    CYG_MACRO_END
#endif

// If asked to lock the AHB during MCI DMA transfers, we indicate
// this to the LPC2XXX MCI support with the following define:
#ifdef CYGSEM_HAL_ARM_LPC2XXX_MCB2387_MCI_DMA_LOCKS_AHB
# define HAL_ARM_LPC2XXX_MCI_DMA_LOCKS_AHB 1
#endif

#if 0
// ##############################################
// These hooks are #if 0'd as the EA board does not have any means of detecting
// cards or write protect switches. The code that is provided here is from the
// Atmel AT91RM9200-EK HAL which does support these features and were used for
// testing the features. This code is provided so it can be used as a
// template for HALs derived from this EA board HAL.
// ##############################################

// Platform hook for initialising socket, primarily pin configuration.
// err only needs to be set if there's an error.

// For EK board:
// Select MMC mode on EK board SPI/MMC socket using PB22.
// There is no datasheet for the logic that this controls, but
// by experimentation, PB22 must be *set* to enable the MCI pins,
// (and cleared for SPI).
// PA17 == write protect input
#define HAL_MMCSD_PLF_INIT_SOCKET( _card_, _err_ )                                    \
    CYG_MACRO_START                                                                   \
    /* Configure PA17 as GPIO input (SD write-protect switch) */                      \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IDR, 1<<17 );  /* no intr */             \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_ODR, 1<<17 );  /* input */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_IFER, 1<<17 ); /* glitch filter on */    \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_PUER, 1<<17 ); /* pull-up on */          \
    HAL_WRITE_UINT32( AT91RM9200_PIOA + _PIO_PER, 1<<17 );  /* set PIO mode */        \
    /* Configure PB22 as output, set to 1 */                                          \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_SODR, 1<<22 ); /* set 1 */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_OER, 1<<22 );  /* output */              \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PER, 1<<22 );  /* set PIO mode */        \
    CYG_MACRO_END

// Platform hook for initialising card detection for polling. Usually some PIOs.
// Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT if relevant.
//
// For EK board:
// PB27 == card detect input
#define HAL_MMCSD_PLF_INIT_CARD_DETECT( _bus_, _card_, _err_ )                        \
    CYG_MACRO_START                                                                   \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IDR, 1<<27 );  /* no intr */             \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_ODR, 1<<27 );  /* input */               \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_IFER, 1<<27 ); /* glitch filter on */    \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PUER, 1<<27 ); /* pull-up on */          \
    HAL_WRITE_UINT32( AT91RM9200_PIOB + _PIO_PER, 1<<27 );  /* set PIO mode */        \
    CYG_MACRO_END


// Platform hook for initialisation of interrupt handler for card
// insertion/removal detection. Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT.
// err only needs to be set if there's an error.
#if defined(CYGFUN_DEVS_DISK_MMCSD_BUS_REMOVABLE_MEDIA_SUPPORT) && \
    defined(CYGIMP_HAL_ARM_ARM9_AT91RM9200_MCI_INTMODE)
struct cyg_mmcsd_card; // forward declaration
__externC void cyg_hal_at91rm9200kit_init_card_detect_intr(struct cyg_mmcsd_card *socket);

# define HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT(_bus_, _socket_, _err_) \
    cyg_hal_at91rm9200kit_init_card_detect_intr(_socket_)
#endif

// Update card's cardflags field with card presence
#define HAL_MMCSD_PLF_SAMPLE_CARD_DETECT( _card_, _err_ )               \
    CYG_MACRO_START                                                     \
    cyg_uint32 pdsr;                                                    \
    HAL_READ_UINT32( AT91RM9200_PIOB + _PIO_PDSR, pdsr );               \
    (_card_)->cardflags.card_present = ( 0 != (pdsr & (1<<27)) );       \
    CYG_MACRO_END

// Update card's cardflags field with physical write-protect switch state
#define HAL_MMCSD_PLF_SAMPLE_CARD_WP( _card_, _err_ )                   \
    CYG_MACRO_START                                                     \
    cyg_uint32 pdsr;                                                    \
    HAL_READ_UINT32( AT91RM9200_PIOA + _PIO_PDSR, pdsr );               \
    (_card_)->cardflags.hw_writeprotect = ( 0 != (pdsr & (1<<17)) );    \
    CYG_MACRO_END

// ##############################################
#endif // #if 0 of example code for different target.

#endif // ifdef CYGPKG_DEVS_MMCSD_ARM_PRIMECELL_MCI
#endif // ifdef __MMCSD_DRIVER_PRIVATE

//-----------------------------------------------------------------------------
#endif // CYGONCE_HAL_PLF_IO_H

// end of plf_io.h
