#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour, nickg
// Contributors:nickg
// Date:        2004-09-27
// Purpose:     PhyCORE LPC229x Board platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>


        // ----------------------------------------------------------------
            

        .macro  _led_init
        // Set GPIO direction for LED pin (P0.8). Don't touch others.
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_IO_BASE
        ldr     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IO0DIR]
        ldrc    r2,0x00000100
        orr     r1,r1,r2
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IO0DIR]

        // LED off to start with        
        ldrc    r1,0x00000100
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IOSET]
        .endm

        // ----------------------------------------------------------------

        .macro _led y
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_IO_BASE
        ldrc    r1,0x00000100
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_IOSET]
        ldrc    r2,((\y&1)<<8)
        str     r2,[r0,#CYGARC_HAL_LPC2XXX_REG_IOCLR]
        .endm

        
        // ----------------------------------------------------------------
        
        .macro lpc2xxx_common_init

        // Set PINSEL0 to allow all relevant pins to allow UART0/1 signals
        // rather than default GPIO.
        // Enable I2C pins too.
        
        lpc2xxx_init_pinsel0 0x55555555

        // Set PINSEL1 to default value. This leaves all pins in GPIO
	// mode except:
        // P0.27 to P0.30:  set to the A/D converter.
        // P0.23 to P0.25:  set to CAN1 and CAN2
        // P0.16:           EINT0 for ethernet                           
        
        lpc2xxx_init_pinsel1 0x15454001                           

        lpc2xxx_init_pinsel2 0x0E6149E4

        // It would also be nice to init the PLL for RAM startup too, but
        // if this is done, the serial can lose sync, thus losing the first character,
        // thus losing a GDB '+' ack, thus causing nasty stuff.
                           
        _led_init
                 
        .endm

        // ----------------------------------------------------------------
        
        .macro  lpc2xxx_rom_init
        lpc2xxx_common_init
        _led    0
        lpc2xxx_init_pll
        _led    12
        lpc2xxx_init_emc 0x2000ffef,0x20003CE3,0x20001422,0
        lpc2xxx_copy_romram
        _led    13
        lpc2xxx_remap
        _led    14
        lpc2xxx_init_mam
        _led    15
        .endm

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_ROMRAM) || defined(CYG_HAL_STARTUP_SRAM)        
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     lpc2xxx_rom_init
#else
#define PLATFORM_SETUP1     lpc2xxx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
