#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Contributors:
// Date:        2006-03-20
// Purpose:     ST STR710-EVAL Board platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>

//-----------------------------------------------------------------------------

        .macro  _led_init
        // All LEDs on to start with
        _led    0xff
        .endm

//-----------------------------------------------------------------------------
// Sets both LEDs and 7-segment display to the given value.
// Note that this code does not assemble in thumb mode.
                   
        .macro _led y
#if 0 //ndef __thumb__
        ldr     r3,=CYGARC_HAL_FPGA_BASE        @ R3 = FPGA base
        ldr     r0,=\y                          @ R0 = value to display
        mvn     r1,r0                           @ R1 = ~value
        str     r1,[r3,#CYGARC_HAL_FPGA_LED]    @ write it to leds
        mov     r1,r0,asr #4                    @ R1 = value>>4
        and     r0,r0,#15                       @ R0 = value&0xf
        and     r1,r1,#15                       @ R1 = (value>>4)&0xf
        ldr     r2,=cyg_hal_fpga_7segment_digits @ R2 = &digits array
        ldrb    r0,[r2,r0]                      @ R0 = ls digit pattern
        ldrb    r1,[r2,r1]                      @ R1 = ms digit pattern
        orr     r1,r1,r0,lsl #8                 @ R1 |= R0<<8
        str     r1,[r3,#CYGARC_HAL_FPGA_7SEGMENT] @ set 7 segment display

#if 0
        // Optional delay after setting LEDs: allows developer to see
	// sequence of changes.
        
        ldr     r0,=(10000000/2)
1:      sub     r0,r0,#1
        cmp     r0,#0
        bne     1b
#endif
#endif        
        .endm

#define CYGHWR_LED_MACRO _led \x

//-----------------------------------------------------------------------------
        
        .macro str7xx_common_init
        _led_init
        .endm

//-----------------------------------------------------------------------------
        
        .macro  str7xx_rom_init
        str7xx_common_init

        // ----------------------------------------------------------------
        // Initialize PIO ports to basic system defaults. Individual lines
        // may be ajusted later by device drivers and other subsystems.

        // Set all P0 lines to GPIO mode except:
        // P0.15 - WAKEUP (TTL input)
        ldr     r4,=CYGARC_HAL_STR7XX_PIO0_BASE
        ldr     r0,=0xffff
        ldr     r1,=0x7fff
        ldr     r2,=0x0000
        str     r0,[r4,#CYGARC_HAL_STR7XX_PIO_PC0]
        str     r1,[r4,#CYGARC_HAL_STR7XX_PIO_PC1]
        str     r2,[r4,#CYGARC_HAL_STR7XX_PIO_PC2]

        // Set all P1 lines to GPIO mode except:
        // No exceptions at present
        ldr     r4,=CYGARC_HAL_STR7XX_PIO1_BASE
        ldr     r0,=0xffff
        ldr     r1,=0xffff
        ldr     r2,=0x0000
        str     r0,[r4,#CYGARC_HAL_STR7XX_PIO_PC0]
        str     r1,[r4,#CYGARC_HAL_STR7XX_PIO_PC1]
        str     r2,[r4,#CYGARC_HAL_STR7XX_PIO_PC2]

        // Set all P1 lines to GPIO mode except:        
        // P2.0-P2.7 - EMI CS and address lines
        ldr     r4,=CYGARC_HAL_STR7XX_PIO2_BASE
        ldr     r0,=0x00ff
        ldr     r1,=0x00ff
        ldr     r2,=0x00ff
        str     r0,[r4,#CYGARC_HAL_STR7XX_PIO_PC0]
        str     r1,[r4,#CYGARC_HAL_STR7XX_PIO_PC1]
        str     r2,[r4,#CYGARC_HAL_STR7XX_PIO_PC2]
        
        // ----------------------------------------------------------------
        // Set up external memory controller:
        // CS0 - FLASH
        // CS1 - static RAM
        // CS2 - LCD display

        ldr     r4,=CYGARC_HAL_STR7XX_EMI_BASE
        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(3)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_16)
        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON0]
        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(3)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_16)
        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON1]
//        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(10)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_8)
        ldr     r0,=(CYGARC_HAL_STR7XX_EMI_BCON_BE|CYGARC_HAL_STR7XX_EMI_BCON_CLENGTH(15)|CYGARC_HAL_STR7XX_EMI_BCON_BSIZE_8)        
        str     r0,[r4,#CYGARC_HAL_STR7XX_EMI_BCON2]
                                                            
        // ----------------------------------------------------------------
        // If we are running from the reset vector at 0x00000000,
	// switch execution to the real address of this code in the
	// memory map. If we are already there, this is a no-op.
        
        ldr     pc,=1f                  @ jump to label 1 in ROM
1:

        // ----------------------------------------------------------------
        // Map internal RAM to location zero
        
        ldr     r4,=CYGARC_HAL_STR7XX_PRCCU_BASE
        ldr     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_BOOTCR]
        bic     r0,r0,#CYGARC_HAL_STR7XX_PRCCU_BOOTCR_BOOT
        ldr     r1,=CYGARC_HAL_STR7XX_PRCCU_BOOTCR_BOOT_RAM
        orr     r0,r0,r1
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_BOOTCR]
                
        // ----------------------------------------------------------------
        // Set up clocks to the default setting. This uses the input clock
        // divided by 2, no PLL and no dividers on MCLK, PCLK1 and
	// PCLK2. The result will run everything at half the crystal
	// frequency. This should be fast enough to boot while not incurring
        // the delays and power drain needed for the PLL.

        ldr     r4,=CYGARC_HAL_STR7XX_PRCCU_BASE
        ldr     r0,=0x00008008
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_CFR]
        ldr     r0,=0x00000007
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_PLL1CR]
        ldr     r0,=0x00000000
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_CCR]
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_MDIVR]
        str     r0,[r4,#CYGARC_HAL_STR7XX_PRCCU_PDIVR]

        // ----------------------------------------------------------------        

        _led    0
        
        .endm

//-----------------------------------------------------------------------------        

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_ROMRAM) || defined(CYG_HAL_STARTUP_JTAG)
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     str7xx_rom_init
#else
#define PLATFORM_SETUP1     str7xx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
