//==========================================================================
//
//      ixp425_cf_ide.inl
//
//      IXP425 CompactFlash True IDE disk driver configuration
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2004,2006 eCosCentric Limited                              
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jlarmour
// Derived from: Based on i386 PC target IDE driver by nickg
// Contributors: 
// Date:         2006-01-23
//
//####DESCRIPTIONEND####
//
//==========================================================================

// FIXME: Should this be included from var_io.h?

#include <pkgconf/system.h>
#include <pkgconf/hal_arm_xscale_ixp425.h>

#ifdef CYGFUN_HAL_IXP4XX_CF_TRUE_IDE_SUPPORT

#include <cyg/infra/cyg_type.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_ixp425.h>

#define __IXP_CF_IDE_DEBUG( format, ... )
//#define __IXP_CF_IDE_DEBUG( format, ... ) diag_printf(format, ## __VA_ARGS__)

// ----------------------------------------------------------------------------
// IDE Register Indices

#define IDE_REG_DATA      0
#define IDE_REG_ERROR     1
#define IDE_REG_FEATURES  1
#define IDE_REG_COUNT     2
#define IDE_REG_REASON    2  // ATAPI
#define IDE_REG_LBALOW    3
#define IDE_REG_LBAMID    4
#define IDE_REG_LBAHI     5
#define IDE_REG_DEVICE    6
#define IDE_REG_STATUS    7
#define IDE_REG_COMMAND   7

// Commands
#define	IDE_CMD_ATAPI_RESET 0x08	/* ATAPI soft reset		*/
#define IDE_CMD_RESTORE     0x10	/* Restore			*/
#define IDE_CMD_READ        0x20	/* Read sectors			*/
#define IDE_CMD_READLONG    0x22	/* Read long			*/
#define IDE_CMD_WRITE       0x30	/* Write sectors		*/
#define IDE_CMD_WRITELONG   0x32	/* Write long			*/
#define IDE_CMD_VERIFY      0x40	/* Read/Verify			*/
#define IDE_CMD_FORMAT      0x50	/* Format track			*/
#define IDE_CMD_SEEK        0x70	/* Seek				*/
#define IDE_CMD_DIAG        0x90	/* Diagnostic tests		*/
#define IDE_CMD_PACKET	    0xA0	/* ATAPI packet function	*/
#define IDE_CMD_PACKET_ID   0xA1	/* ATAPI packet identify	*/	
#define IDE_CMD_READMUL     0xc4	/* Multiple read		*/
#define IDE_CMD_WRITEMUL    0xc5	/* Multiple write		*/
#define IDE_CMD_SETMUL      0xc6	/* Set multiple mode		*/
#define IDE_CMD_STANDBY     0xe0	/* Standby			*/
#define IDE_CMD_IDLE        0xe1	/* Idle				*/
#define IDE_CMD_STANDBYTO   0xe2	/* Timeout standby		*/
#define IDE_CMD_IDLETO      0xe3	/* Timeout idle			*/
#define IDE_CMD_RDBUF       0xe4	/* Read buffer			*/
#define IDE_CMD_CHKPOWER    0xe5	/* Check power mode		*/
#define IDE_CMD_SLEEP       0xe6	/* Set sleep mode		*/
#define IDE_CMD_WRBUF       0xe8	/* Write buffer			*/
#define IDE_CMD_GETID       0xec	/* Get drive's ID		*/
#define IDE_CMD_SETSUP      0xef	/* Set features supported	*/

#define IDE_STAT_BSY      0x80
#define IDE_STAT_DRDY     0x40
#define IDE_STAT_SERVICE  0x10
#define IDE_STAT_DRQ      0x08
#define IDE_STAT_CORR     0x04
#define IDE_STAT_ERR      0x01

#define IDE_REASON_REL    0x04
#define IDE_REASON_IO     0x02
#define IDE_REASON_COD    0x01

//
// Drive ID offsets of interest
//
#define IDE_DEVID_GENCONFIG      0
#define IDE_DEVID_CYLS           2
#define IDE_DEVID_HEADS          6
#define IDE_DEVID_SECTORS       12
#define IDE_DEVID_SERNO         20
#define IDE_DEVID_FIRMWARE_REV  46
#define IDE_DEVID_MODEL         54
#define IDE_DEVID_LBA_CAPACITY 120


#define SECTOR_SIZE      512

#define CDROM_SECTOR_SIZE 2048
#define SECTORS_PER_CDROM_SECTOR (CDROM_SECTOR_SIZE/SECTOR_SIZE)

// ----------------------------------------------------------------------------

// Expansion bus chip select configuration. One for 16-bit accesses, one for 8-bit.
#define IXP425_CF_IDE_EXP_CSx_INIT_16  (EXP_SZ_512 | EXP_BYTE_RD16 | EXP_WR_EN | EXP_CS_EN | EXP_RECOVERY_T(15) | EXP_HOLD_T(3) | EXP_STROBE_T(15) | EXP_SETUP_T(3) | EXP_ADDR_T(3))
#define IXP425_CF_IDE_EXP_CSx_INIT_8   (IXP425_CF_IDE_EXP_CSx_INIT_16 | EXP_BYTE_EN)

// Task file reg base - expansion bus chip select #1 == CF IDE chip select #0
#define TF_BASE  (0x51000000)
// Device control reg base - expansion bus chip select #2 == CF IDE chip select #1
#define DC_BASE  (0x52000000)

// ----------------------------------------------------------------------------

#define HAL_IDE_NUM_CONTROLLERS 1

//#include <cyg/hal/hal_if.h>
static __inline__ int
cyg_hal_ixp425_cf_ide_init(void)
{
#if 0
    // If debugging, this is useful to get non-mangled output.
# ifdef CYG_HAL_STARTUP_RAM
    CYGACC_CALL_IF_SET_CONSOLE_COMM(CYGNUM_CALL_IF_SET_COMM_ID_MANGLER);
# else
    CYGACC_CALL_IF_SET_CONSOLE_COMM(CYGNUM_HAL_VIRTUAL_VECTOR_DEBUG_CHANNEL);
# endif
#endif

    // get chip selects into known good state
    HAL_WRITE_UINT32( IXP425_EXP_CS1, IXP425_CF_IDE_EXP_CSx_INIT_8 );
    HAL_WRITE_UINT32( IXP425_EXP_CS2, IXP425_CF_IDE_EXP_CSx_INIT_8 );

    return HAL_IDE_NUM_CONTROLLERS;
}


// Initialize the IDE controller(s).
#define HAL_IDE_INIT() cyg_hal_ixp425_cf_ide_init()

#define HAL_IDE_READ_UINT8( __ctlr, __regno, __val )                               \
    CYG_MACRO_START                                                                \
    HAL_WRITE_UINT32( IXP425_EXP_CS1, IXP425_CF_IDE_EXP_CSx_INIT_8 );              \
    HAL_READ_UINT8( TF_BASE + (__regno), (__val));                                 \
    __IXP_CF_IDE_DEBUG( "CFIDE: R8  %d = 0x%x\n", (int)__regno, (unsigned)__val ); \
    CYG_MACRO_END

#define HAL_IDE_READ_UINT16( __ctlr, __regno, __val )                              \
    CYG_MACRO_START                                                                \
    cyg_uint16 __tmp;                                                              \
    HAL_WRITE_UINT32( IXP425_EXP_CS1, IXP425_CF_IDE_EXP_CSx_INIT_16 );             \
    HAL_READ_UINT16( TF_BASE + (__regno), __tmp);                                  \
    (__val) = (__tmp >> 8) | (__tmp << 8);                                         \
    __IXP_CF_IDE_DEBUG( "CFIDE: R16 %d = 0x%x\n", (int)__regno, (unsigned)__val ); \
    CYG_MACRO_END

#undef HAL_IDE_READ_ALTSTATUS
#define HAL_IDE_READ_ALTSTATUS( __ctlr, __val )                         \
    CYG_MACRO_START                                                     \
    HAL_WRITE_UINT32( IXP425_EXP_CS2, IXP425_CF_IDE_EXP_CSx_INIT_8 );   \
    HAL_READ_UINT8( DC_BASE + 6, (__val));                              \
    __IXP_CF_IDE_DEBUG( "CFIDE: RSt   = 0x%x\n", (unsigned)__val );     \
    CYG_MACRO_END

#define HAL_IDE_WRITE_UINT8( __ctlr, __regno, __val )                              \
    CYG_MACRO_START                                                                \
    HAL_WRITE_UINT32( IXP425_EXP_CS1, IXP425_CF_IDE_EXP_CSx_INIT_8 );              \
    HAL_WRITE_UINT8( TF_BASE + (__regno), (__val));                                \
    __IXP_CF_IDE_DEBUG( "CFIDE: W8  %d = 0x%x\n", (int)__regno, (unsigned)__val ); \
    CYG_MACRO_END

#define HAL_IDE_WRITE_UINT16( __ctlr, __regno, __val )                             \
    CYG_MACRO_START                                                                \
    cyg_uint16 __tmp;                                                              \
    HAL_WRITE_UINT32( IXP425_EXP_CS1, IXP425_CF_IDE_EXP_CSx_INIT_16 );             \
    (__tmp) = (__val >> 8) | (__val << 8);                                         \
    HAL_WRITE_UINT16( TF_BASE + (__regno), (__tmp));                               \
    __IXP_CF_IDE_DEBUG( "CFIDE: W16 %d = 0x%x\n", (int)__regno, (unsigned)__val ); \
    CYG_MACRO_END

#undef HAL_IDE_WRITE_CONTROL
#define HAL_IDE_WRITE_CONTROL( __ctlr, __val )                          \
    CYG_MACRO_START                                                     \
    HAL_WRITE_UINT32( IXP425_EXP_CS2, IXP425_CF_IDE_EXP_CSx_INIT_8 );   \
    HAL_WRITE_UINT8( DC_BASE + 6, (__val));                             \
    __IXP_CF_IDE_DEBUG( "CFIDE: WCt   = 0x%x\n", (unsigned)__val );     \
    CYG_MACRO_END


//==========================================================================
// IDE disks

// ----------------------------------------------------------------------------

#ifdef CYGPKG_DEVS_DISK_IDE

static ide_controller_info_t ide_controller_info_0 = {
    ctlr:       0,
#ifndef CYGVAR_DEVS_DISK_IDE_POLLED    
    vector:     HAL_IDE_INTERRUPT_PRI
#endif
};

static DISK_CONTROLLER( ide_disk_controller_0, ide_controller_info_0 );

// ----------------------------------------------------------------------------

#define IDE_DISK_INSTANCE(_number_,_ctlr_,_dev_,_mbr_supp_)     \
static ide_disk_info_t ide_disk_info##_number_ = {              \
    num:           _number_,                                    \
    ctlr:          &ide_controller_info_##_ctlr_,               \
    dev:           _dev_,                                       \
};                                                              \
static DISK_CHANNEL(ide_disk_channel##_number_,                 \
                    ide_disk_funs,                              \
                    ide_disk_info##_number_,                    \
                    ide_disk_controller_##_ctlr_,               \
                    _mbr_supp_                                  \
);                                                              \
BLOCK_DEVTAB_ENTRY(ide_disk_io##_number_,                       \
                   CYGDAT_HAL_IXP4XX_CF_TRUE_IDE_DISK_NAME,     \
                   0,                                           \
                   &cyg_io_disk_devio,                          \
                   ide_disk_init,                               \
                   ide_disk_lookup,                             \
                   &ide_disk_channel##_number_                  \
);

// ----------------------------------------------------------------------------

IDE_DISK_INSTANCE(0, 0, 0, true);

#endif // CYGPKG_DEVS_DISK_IDE

#endif // ifdef CYGFUN_HAL_IXP4XX_CF_TRUE_IDE_SUPPORT

// ----------------------------------------------------------------------------
// EOF ixp425_cf_ide.inl
