/*==========================================================================
//
//      context.S
//
//      Cortex-M context switch code
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Date:         2008-07-30
// Description:  This file contains thread context switch code.
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/system.h>
#include <pkgconf/hal.h>
#include <pkgconf/hal_cortexm.h>
#ifdef CYGPKG_KERNEL
#include <pkgconf/kernel.h>
#endif

//==========================================================================

        .syntax unified
        .thumb
        .text
        
//==========================================================================
// Context switch
//
// R0 contains a pointer to the SP of the thread to load, R1 contains
// a pointer to the SP of the current thread.        
        
        .globl  hal_thread_switch_context
        .thumb
        .thumb_func
        .type   hal_thread_switch_context, %function
hal_thread_switch_context:

        push    {r0-r12,lr}             // Push all savable register
        mov     r2,#2                   // Set state type == thread
        mrs     r3,basepri              // Get priority base register
        mov     r4,sp                   // Get SP (for info only)
        push    {r2-r4}                 // Push them
        
        str     sp,[r1]                 // Save SP

        // Fall through
        
//--------------------------------------------------------------------------
// Load context
//
// This is used to load a thread context, abandoning the current one. This
// function is also the second half of hal_thread_switch_context.

        .globl  hal_thread_load_context
        .thumb
        .thumb_func
        .type   hal_thread_load_context, %function
hal_thread_load_context:

        ldr     sp,[r0]                 // Load SP
        pop     {r2-r4}                 // Pop type, basepri and SP (discarded)
        msr     basepri,r3              // Set BASEPRI
        pop     {r0-r12,pc}             // Pop all register and return

//==========================================================================        
//  HAL longjmp, setjmp implementations
//        
//  hal_setjmp saves only to callee save registers R4-14
//  and LR into buffer supplied in r0[arg0].

        .globl  hal_setjmp
        .thumb
        .thumb_func
        .type   hal_setjmp, %function        
hal_setjmp:
        mov     r3,sp
        stmea   r0,{r3-r12,r14}
        mov     r0,#0
        bx      lr

//  hal_longjmp loads state from r0[arg0] and returns
        
        .globl  hal_longjmp
        .thumb
        .thumb_func
        .type   hal_longjmp, %function
hal_longjmp:
        ldmfd   r0,{r3-r12,r14}
        mov     sp,r3
        mov     r0,r1           // return [arg1]
        bx      lr

// start-sanitize-ecospro        
//==========================================================================
// Profiling support.
//
// When code is compiled with -pg the compiler inserts calls to mcount()
// at the start of each function. This can be used to build a callgraph
// of the application. mcount() is tied to the compiler internals and does
// not follow standard calling conventions. On the ARM we have the following
// sequence at the start of each function:              
//
//     .data
// .LP1:
//     .word    0
//     .text
//     mov      ip,lr
//     bl       mcount
//     .word    .LP1
//
// So mcount is invoked with the caller address in ip and the callee
// address in lr. This sequence is used for both ARM and thumb. There are
// no spare registers so everything has to be saved before being used.      
// The goal of mcount() is to call __profile_mcount(caller,callee)
// with interrupts disabled. r4 is used to save the current interrupt
// status. Four words of padding are added to front and back so that
// with a default bucket size of 16 bytes the mcount() profile timer
// hits do not get assigned to neighbouring functions.
        
#ifdef CYGPKG_PROFILE_GPROF
        
        .section .text.mcount
_mcount_head_padding_ignore:
        .word   0,0,0,0
        
        .globl mcount
        .thumb
        .thumb_func
        .type   mcount, %function        
        
mcount:
        push    {r0-r4,lr}              // Push arg and work regs

                                        // Disable interrupts
        mrs     r4,basepri              // Fetch basepri
        ldr     r0,=CYGNUM_HAL_CORTEXM_PRIORITY_MAX
        msr     basepri,r0              // Set basepri to mask interrupts
        
        mov     r0,ip                   // R0 = arg1 = callee
        mov     r1,lr                   // R1 = arg1 = callee
        bl      __profile_mcount        // Call __profile_mcount

        msr     basepri,r4              // Restore original interrupt priority

        pop     {r0-r4,lr}              // Pop saved registers
        add     lr,lr,#4                // Skip past the .word .LP1
        bx      lr                      // Return
        
_mcount_tail_padding_ignore:
        .word   0,0,0,0

#endif

//==========================================================================
// Synthesize a breakpoint for the gdb file I/O code.

        .section .text._gdb_hwdebug_breakpoint

        .globl  _gdb_hwdebug_breakpoint
        .thumb
        .thumb_func
        .type   _gdb_hwdebug_breakpoint, %function        
        
_gdb_hwdebug_breakpoint:
        
        // Use the BKPT instruction, not an illegal instruction exception,
        // since BKPT is expected to interact with hardware debug units.
        bkpt 0

        .globl  _gdb_hwdebug_continue
        .thumb
        .thumb_func
        .type   _gdb_hwdebug_continue, %function        

_gdb_hwdebug_continue:  
        bx      lr
        
// end-sanitize-ecospro
//==========================================================================
// EOF context.S
