#ifndef CYGONCE_HAL_VAR_IO_H
#define CYGONCE_HAL_VAR_IO_H
//=============================================================================
//
//      var_io.h
//
//      Variant specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008, 2009 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2009-07-30
// Purpose:     LM3S variant specific registers
// Description: 
// Usage:       #include <cyg/hal/var_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal_cortexm_lm3s.h>

#include <cyg/hal/plf_io.h>

//=============================================================================

__externC cyg_uint32 hal_lm3s_sysclk;

//=============================================================================
// Peripherals


#define CYGHWR_HAL_LM3S_WATCHDOG        0x40000000
#define CYGHWR_HAL_LM3S_GPIOA           0x40004000
#define CYGHWR_HAL_LM3S_GPIOB           0x40005000
#define CYGHWR_HAL_LM3S_GPIOC           0x40006000
#define CYGHWR_HAL_LM3S_GPIOD           0x40007000
#define CYGHWR_HAL_LM3S_SSI0            0x40008000
#define CYGHWR_HAL_LM3S_UART0           0x4000C000
#define CYGHWR_HAL_LM3S_UART1           0x4000D000
#define CYGHWR_HAL_LM3S_I2C0            0x40020000
#define CYGHWR_HAL_LM3S_GPIOE           0x40024000
#define CYGHWR_HAL_LM3S_GPIOF           0x40025000
#define CYGHWR_HAL_LM3S_GPIOG           0x40026000
#define CYGHWR_HAL_LM3S_PWM             0x40028000
#define CYGHWR_HAL_LM3S_QEI0            0x4002C000
#define CYGHWR_HAL_LM3S_QEI1            0x4002D000
#define CYGHWR_HAL_LM3S_TIMER0          0x40030000
#define CYGHWR_HAL_LM3S_TIMER1          0x40031000
#define CYGHWR_HAL_LM3S_TIMER2          0x40032000
#define CYGHWR_HAL_LM3S_TIMER3          0x40033000
#define CYGHWR_HAL_LM3S_ADC             0x40038000
#define CYGHWR_HAL_LM3S_ANALOG          0x4003C000
#define CYGHWR_HAL_LM3S_CAN0            0x40040000
#define CYGHWR_HAL_LM3S_ETH             0x40048000
#define CYGHWR_HAL_LM3S_HIBERNATE       0x400FC000
#define CYGHWR_HAL_LM3S_FLASH           0x400FD000
#define CYGHWR_HAL_LM3S_SYSTEM          0x400FE000


//=============================================================================
// System Control
//
// Not all registers are fully described here

#define CYGHWR_HAL_LM3S_SYSTEM_DID0             0x000
#define CYGHWR_HAL_LM3S_SYSTEM_DID1             0x004
#define CYGHWR_HAL_LM3S_SYSTEM_DC0              0x008
#define CYGHWR_HAL_LM3S_SYSTEM_DC1              0x010
#define CYGHWR_HAL_LM3S_SYSTEM_DC2              0x014
#define CYGHWR_HAL_LM3S_SYSTEM_DC3              0x018
#define CYGHWR_HAL_LM3S_SYSTEM_DC4              0x01C
#define CYGHWR_HAL_LM3S_SYSTEM_PBORCTL          0x030
#define CYGHWR_HAL_LM3S_SYSTEM_LDOPCTL          0x034
#define CYGHWR_HAL_LM3S_SYSTEM_SRCR0            0x040
#define CYGHWR_HAL_LM3S_SYSTEM_SRCR1            0x044
#define CYGHWR_HAL_LM3S_SYSTEM_SRCR2            0x048
#define CYGHWR_HAL_LM3S_SYSTEM_RIS              0x050
#define CYGHWR_HAL_LM3S_SYSTEM_IMC              0x054
#define CYGHWR_HAL_LM3S_SYSTEM_MISC             0x058
#define CYGHWR_HAL_LM3S_SYSTEM_RESC             0x05C
#define CYGHWR_HAL_LM3S_SYSTEM_RCC              0x060
#define CYGHWR_HAL_LM3S_SYSTEM_PLLCFG           0x064
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2             0x070
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0            0x100
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1            0x104
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2            0x108
#define CYGHWR_HAL_LM3S_SYSTEM_SCGC0            0x110
#define CYGHWR_HAL_LM3S_SYSTEM_SCGC1            0x114
#define CYGHWR_HAL_LM3S_SYSTEM_SCGC2            0x118
#define CYGHWR_HAL_LM3S_SYSTEM_DCGC0            0x120
#define CYGHWR_HAL_LM3S_SYSTEM_DCGC1            0x124
#define CYGHWR_HAL_LM3S_SYSTEM_DCGC2            0x128
#define CYGHWR_HAL_LM3S_SYSTEM_DSLPCLKCFG       0x144

// DC0 fields

#define CYGHWR_HAL_LM3S_SYSTEM_DC0_SRAMSZ(__d)  (((__d)>>16)&0xFFFF)
#define CYGHWR_HAL_LM3S_SYSTEM_DC0_FLASHSZ(__d) (((__d)>> 0)&0xFFFF)


// RIS bits

#define CYGHWR_HAL_LM3S_SYSTEM_RIS_PLLL         BIT_(6)
#define CYGHWR_HAL_LM3S_SYSTEM_RIS_BOR          BIT_(1)

// MISC bits

#define CYGHWR_HAL_LM3S_SYSTEM_MISC_PLLL        BIT_(6)
#define CYGHWR_HAL_LM3S_SYSTEM_MISC_BOR         BIT_(1)

// RCC fields
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_ACG          BIT_(27)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_SYSDIV_MASK  MASK_(23,4)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_SYSDIV(__x)  VALUE_(23,__x)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_USESYSDIV    BIT_(22)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_USEPWMDIV    BIT_(20)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_PWMDIV(__x)  VALUE_(17,__x)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_PWRDN        BIT_(13)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_BYPASS       BIT_(11)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_MASK    MASK_(6,4)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_1_000   VALUE_(6,0)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_1_8432  VALUE_(6,1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_2_000   VALUE_(6,2)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_2_4576  VALUE_(6,3)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_3_5795  VALUE_(6,4)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_3_6864  VALUE_(6,5)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_4       VALUE_(6,6)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_4_096   VALUE_(6,7)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_4_9152  VALUE_(6,8)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_5       VALUE_(6,9)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_5_12    VALUE_(6,10)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_6       VALUE_(6,11)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_6_144   VALUE_(6,12)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_7_3728  VALUE_(6,13)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_8       VALUE_(6,14)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_XTAL_8_192   VALUE_(6,15)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_OSCSRC_MAIN  VALUE_(4,0)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_OSCSRC_INT   VALUE_(4,1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_OSCSRC_INT_4 VALUE_(4,2)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_OSCSRC_30K   VALUE_(4,3)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_IOSCDIS      BIT_(1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC_MOSCDIS      BIT_(0)

// RCC2 fields
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_USERCC2     BIT_(31)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_SYSDIV2_MASK MASK_(23,6)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_SYSDIV2(__x) VALUE_(23,__x)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_PWRDN2      BIT_(13)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_BYPASS2     BIT_(11)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_MASK  MASK_(4,3)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_MAIN  VALUE_(4,0)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_INT   VALUE_(4,1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_INT_4 VALUE_(4,2)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_30K   VALUE_(4,3)
#define CYGHWR_HAL_LM3S_SYSTEM_RCC2_OSCSRC2_32K   VALUE_(4,7)


// RCGC0/1/2 bits
//
// Note that the following are bit numbers, not masks. They should
// either be used with the CYGHWR_HAL_LM3S_CLOCK() macro or used to
// shift a 1, perhaps using the BIT_() macro.


#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0_CAN0       (24)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0_PWM        (20)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0_ADC        (16)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0_HIB        (6)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC0_WDT        (3)

#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_COMP0      (24)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_TIMER3     (19)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_TIMER2     (18)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_TIMER1     (17)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_TIMER0     (16)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_I2C0       (12)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_QEI1       (9)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_QEI0       (8)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_SSI0       (4)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_UART1      (1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC1_UART0      (0)

#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_EPHY0      (30)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_EMAC0      (28)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOG      (6)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOF      (5)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOE      (4)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOD      (3)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOC      (2)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOB      (1)
#define CYGHWR_HAL_LM3S_SYSTEM_RCGC2_GPIOA      (0)


// The following encodes the control register and clock bit number
// into a 32 bit descriptor.
#define CYGHWR_HAL_LM3S_CLOCK( __reg, __pin )                           \
            ((CYGHWR_HAL_LM3S_SYSTEM_RCGC##__reg) |                     \
             ((CYGHWR_HAL_LM3S_SYSTEM_RCGC##__reg##_##__pin)<<16))

// Macros to extract encoded values.
#define CYGHWR_HAL_LM3S_CLOCK_REG( __desc ) ((__desc)&0xFFF)
#define CYGHWR_HAL_LM3S_CLOCK_PIN( __desc ) (((__desc)>>16)&0xFF)

// Functions and macros to enable/disable clocks.

__externC void hal_lm3s_clock_enable( cyg_uint32 desc );
__externC void hal_lm3s_clock_disable( cyg_uint32 desc );

#define CYGHWR_HAL_LM3S_CLOCK_ENABLE( __desc ) hal_lm3s_clock_enable( __desc )
#define CYGHWR_HAL_LM3S_CLOCK_DISABLE( __desc ) hal_lm3s_clock_disable( __desc )

//=============================================================================
// Watchdog

#define CYGHWR_HAL_LM3S_WATCHDOG_LOAD           0x000
#define CYGHWR_HAL_LM3S_WATCHDOG_VALUE          0x004
#define CYGHWR_HAL_LM3S_WATCHDOG_CTL            0x008
#define CYGHWR_HAL_LM3S_WATCHDOG_ICR            0x00c
#define CYGHWR_HAL_LM3S_WATCHDOG_RIS            0x010
#define CYGHWR_HAL_LM3S_WATCHDOG_MIS            0x014
#define CYGHWR_HAL_LM3S_WATCHDOG_TEST           0x418
#define CYGHWR_HAL_LM3S_WATCHDOG_LOCK           0xc00

// CTL register
#define CYGHWR_HAL_LM3S_WATCHDOG_CTL_RESEN      BIT_(1)
#define CYGHWR_HAL_LM3S_WATCHDOG_CTL_INTEN      BIT_(0)

// RIS and MIS registers
#define CYGHWR_HAL_LM3S_WATCHDOG_INT            BIT_(0)

// TEST register
#define CYGHWR_HAL_LM3S_WATCHDOG_TEST_STALL     BIT_(8)

#define CYGHWR_HAL_LM3S_WATCHDOG_LOCK_KEY       0x1ACCE551


// Clock control

#define CYGHWR_HAL_LM3S_WATCHDOG_CLOCK          CYGHWR_HAL_LM3S_CLOCK( 0, WDT )

//=============================================================================
// GPIO ports

#define CYGHWR_HAL_LM3S_GPIO_DATA               0x000
#define CYGHWR_HAL_LM3S_GPIO_DIR                0x400
#define CYGHWR_HAL_LM3S_GPIO_IS                 0x404
#define CYGHWR_HAL_LM3S_GPIO_IBE                0x408
#define CYGHWR_HAL_LM3S_GPIO_IEV                0x40C
#define CYGHWR_HAL_LM3S_GPIO_IM                 0x410
#define CYGHWR_HAL_LM3S_GPIO_RIS                0x414
#define CYGHWR_HAL_LM3S_GPIO_MIS                0x418
#define CYGHWR_HAL_LM3S_GPIO_ICR                0x41C
#define CYGHWR_HAL_LM3S_GPIO_AFSEL              0x420
#define CYGHWR_HAL_LM3S_GPIO_DR2R               0x500
#define CYGHWR_HAL_LM3S_GPIO_DR4R               0x504
#define CYGHWR_HAL_LM3S_GPIO_DR8R               0x508
#define CYGHWR_HAL_LM3S_GPIO_ODR                0x50C
#define CYGHWR_HAL_LM3S_GPIO_PUR                0x510
#define CYGHWR_HAL_LM3S_GPIO_PDR                0x514
#define CYGHWR_HAL_LM3S_GPIO_SLR                0x518
#define CYGHWR_HAL_LM3S_GPIO_DEN                0x51C
#define CYGHWR_HAL_LM3S_GPIO_LOCK               0x520
#define CYGHWR_HAL_LM3S_GPIO_CR                 0x524

#define CYGHWR_HAL_LM3S_GPIO_LOCK_KEY           0x1ACCE551


// GPIO pin mode encoding
#define CYGHWR_HAL_LM3S_GPIO_MODE_IN            0
#define CYGHWR_HAL_LM3S_GPIO_MODE_OUT           BIT_(0)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT           BIT_(1)
#define CYGHWR_HAL_LM3S_GPIO_MODE_DRIVE         MASK_(2,2)
#define CYGHWR_HAL_LM3S_GPIO_MODE_D2mA          VALUE_(2,1)
#define CYGHWR_HAL_LM3S_GPIO_MODE_D4mA          VALUE_(2,2)
#define CYGHWR_HAL_LM3S_GPIO_MODE_D8mA          VALUE_(2,3)
#define CYGHWR_HAL_LM3S_GPIO_MODE_OPENDRAIN     BIT_(4)
#define CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL      0
#define CYGHWR_HAL_LM3S_GPIO_MODE_PULLDOWN      BIT_(5)
#define CYGHWR_HAL_LM3S_GPIO_MODE_PULLUP        BIT_(6)
#define CYGHWR_HAL_LM3S_GPIO_MODE_SLEW          BIT_(7)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ANALOG        BIT_(8)

#define CYGHWR_HAL_LM3S_GPIO_MODE_D8mAS         (CYGHWR_HAL_LM3S_GPIO_MODE_D8mA|CYGHWR_HAL_LM3S_GPIO_MODE_SLEW)

// Combined configuations. Only those combinations that are generally
// useful, or are needed for supported devices are defined here. More
// obscure combinations can either be added here or defined on a
// per-application basis.
#define CYGHWR_HAL_LM3S_GPIO_MODE_IN_PUSHPULL   (CYGHWR_HAL_LM3S_GPIO_MODE_IN|CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL)
#define CYGHWR_HAL_LM3S_GPIO_MODE_IN_PULLUP     (CYGHWR_HAL_LM3S_GPIO_MODE_IN|CYGHWR_HAL_LM3S_GPIO_MODE_PULLUP)
#define CYGHWR_HAL_LM3S_GPIO_MODE_IN_PULLDOWN   (CYGHWR_HAL_LM3S_GPIO_MODE_IN|CYGHWR_HAL_LM3S_GPIO_MODE_PULLDOWN)
#define CYGHWR_HAL_LM3S_GPIO_MODE_OUT_OPENDRAIN (CYGHWR_HAL_LM3S_GPIO_MODE_OUT|CYGHWR_HAL_LM3S_GPIO_MODE_OPENDRAIN)
#define CYGHWR_HAL_LM3S_GPIO_MODE_OUT_PUSHPULL  (CYGHWR_HAL_LM3S_GPIO_MODE_OUT|CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL)

#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_DIGITAL   (CYGHWR_HAL_LM3S_GPIO_MODE_ALT)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_OD        (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_OPENDRAIN)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_ODPU      (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_OPENDRAIN|CYGHWR_HAL_LM3S_GPIO_MODE_PULLUP)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_ODPD      (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_OPENDRAIN|CYGHWR_HAL_LM3S_GPIO_MODE_PULLDOWN)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_PP        (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_PPPU      (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL|CYGHWR_HAL_LM3S_GPIO_MODE_PULLUP)
#define CYGHWR_HAL_LM3S_GPIO_MODE_ALT_PPPD      (CYGHWR_HAL_LM3S_GPIO_MODE_ALT|CYGHWR_HAL_LM3S_GPIO_MODE_PUSHPULL|CYGHWR_HAL_LM3S_GPIO_MODE_PULLDOWN)

// This macro packs the port number, bit number and mode for a GPIO
// pin into a single word. The packing puts the drive level and mode
// in the ls 9 bits, the bit number in 20:24 and the offset of the
// GPIO port from GPIOA in bits 12:19. The port, and mode are only
// specified using the last component of the names to keep definitions
// short.

#define CYGHWR_HAL_LM3S_GPIO(__port, __bit, __drive, __mode )           \
            ((CYGHWR_HAL_LM3S_GPIO##__port - CYGHWR_HAL_LM3S_GPIOA)   | \
             (__bit<<20)                                              | \
             (CYGHWR_HAL_LM3S_GPIO_MODE_##__mode)                     | \
             (CYGHWR_HAL_LM3S_GPIO_MODE_D##__drive)                   )

// Macros to extract encoded values
#define CYGHWR_HAL_LM3S_GPIO_PORT(__pin)       (CYGHWR_HAL_LM3S_GPIOA+((__pin)&0x000FF000))
#define CYGHWR_HAL_LM3S_GPIO_BIT(__pin)        (((__pin)>>20)&0x1F)
#define CYGHWR_HAL_LM3S_GPIO_MODE(__pin)       ((__pin)&0x1FF)

#define CYGHWR_HAL_LM3S_GPIO_NONE      (0xFFFFFFFF)

// Functions and macros to configure GPIO ports.

__externC void hal_lm3s_gpio_set( cyg_uint32 pin );
__externC void hal_lm3s_gpio_out( cyg_uint32 pin, int val );
__externC void hal_lm3s_gpio_in ( cyg_uint32 pin, int *val );

#define CYGHWR_HAL_LM3S_GPIO_SET(__pin ) hal_lm3s_gpio_set( __pin )
#define CYGHWR_HAL_LM3S_GPIO_OUT(__pin, __val ) hal_lm3s_gpio_out( __pin, __val )
#define CYGHWR_HAL_LM3S_GPIO_IN(__pin,  __val ) hal_lm3s_gpio_in( __pin, __val )

//=============================================================================
// UARTs
//
// These are based on the ARM PL011 macrocell

#define CYGHWR_HAL_LM3S_UART_DR                 0x00     /*  Data read or written from the interface. */
#define CYGHWR_HAL_LM3S_UART_RSR                0x04     /*  Receive status register (Read). */
#define CYGHWR_HAL_LM3S_UART_ECR                0x04     /*  Error clear register (Write). */
#define CYGHWR_HAL_LM3S_UART_FR                 0x18     /*  Flag register (Read only). */
#define CYGHWR_HAL_LM3S_UART_IBRD               0x24
#define CYGHWR_HAL_LM3S_UART_FBRD               0x28
#define CYGHWR_HAL_LM3S_UART_LCRH               0x2C
#define CYGHWR_HAL_LM3S_UART_CR                 0x30
#define CYGHWR_HAL_LM3S_UART_IFLS               0x34
#define CYGHWR_HAL_LM3S_UART_IMSC               0x38
#define CYGHWR_HAL_LM3S_UART_RIS                0x3C
#define CYGHWR_HAL_LM3S_UART_MIS                0x40
#define CYGHWR_HAL_LM3S_UART_ICR                0x44

// RSR bits
#define  CYGHWR_HAL_LM3S_UART_RSR_OE            BIT_(3)
#define  CYGHWR_HAL_LM3S_UART_RSR_BE            BIT_(2)
#define  CYGHWR_HAL_LM3S_UART_RSR_PE            BIT_(1)
#define  CYGHWR_HAL_LM3S_UART_RSR_FE            BIT_(0)

// FR bits
#define  CYGHWR_HAL_LM3S_UART_FR_RI             BIT_(8)
#define  CYGHWR_HAL_LM3S_UART_FR_TXFE           BIT_(7)
#define  CYGHWR_HAL_LM3S_UART_FR_RXFF           BIT_(6)
#define  CYGHWR_HAL_LM3S_UART_FR_TXFF           BIT_(5)
#define  CYGHWR_HAL_LM3S_UART_FR_RXFE           BIT_(4)
#define  CYGHWR_HAL_LM3S_UART_FR_BUSY           BIT_(3)
#define  CYGHWR_HAL_LM3S_UART_FR_DCD            BIT_(2) 
#define  CYGHWR_HAL_LM3S_UART_FR_DSR            BIT_(1)
#define  CYGHWR_HAL_LM3S_UART_FR_CTS            BIT_(0)

// LCRH bits
#define  CYGHWR_HAL_LM3S_UART_LCRH_SPS          BIT_(7)
#define  CYGHWR_HAL_LM3S_UART_LCRH_WLEN_8       VALUE_(5,3)
#define  CYGHWR_HAL_LM3S_UART_LCRH_WLEN_7       VALUE_(5,2)
#define  CYGHWR_HAL_LM3S_UART_LCRH_WLEN_6       VALUE_(5,1)
#define  CYGHWR_HAL_LM3S_UART_LCRH_WLEN_5       VALUE_(5,0)
#define  CYGHWR_HAL_LM3S_UART_LCRH_FEN          BIT_(4)
#define  CYGHWR_HAL_LM3S_UART_LCRH_STP2         BIT_(3)
#define  CYGHWR_HAL_LM3S_UART_LCRH_EPS          BIT_(2)
#define  CYGHWR_HAL_LM3S_UART_LCRH_PEN          BIT_(1)
#define  CYGHWR_HAL_LM3S_UART_LCRH_BRK          BIT_(0)

// CR bits
#define  CYGHWR_HAL_LM3S_UART_CR_CTSEN          BIT_(15)
#define  CYGHWR_HAL_LM3S_UART_CR_RTSEN          BIT_(14)
#define  CYGHWR_HAL_LM3S_UART_CR_OUT2           BIT_(13)
#define  CYGHWR_HAL_LM3S_UART_CR_OUT1           BIT_(12)
#define  CYGHWR_HAL_LM3S_UART_CR_RTS            BIT_(11)
#define  CYGHWR_HAL_LM3S_UART_CR_DTR            BIT_(10)
#define  CYGHWR_HAL_LM3S_UART_CR_RXE            BIT_(9)
#define  CYGHWR_HAL_LM3S_UART_CR_TXE            BIT_(8)
#define  CYGHWR_HAL_LM3S_UART_CR_LPE            BIT_(7)
#define  CYGHWR_HAL_LM3S_UART_CR_IIRLP          BIT_(2)
#define  CYGHWR_HAL_LM3S_UART_CR_SIREN          BIT_(1)
#define  CYGHWR_HAL_LM3S_UART_CR_UARTEN         BIT_(0)

// IMSC/RIS/MIS/ICR bits
#define  CYGHWR_HAL_LM3S_UART_IMSC_OEIM         BIT_(10)
#define  CYGHWR_HAL_LM3S_UART_IMSC_BEIM         BIT_(9)
#define  CYGHWR_HAL_LM3S_UART_IMSC_PEIM         BIT_(8)
#define  CYGHWR_HAL_LM3S_UART_IMSC_FEIM         BIT_(7)
#define  CYGHWR_HAL_LM3S_UART_IMSC_RTIM         BIT_(6)
#define  CYGHWR_HAL_LM3S_UART_IMSC_TXIM         BIT_(5)
#define  CYGHWR_HAL_LM3S_UART_IMSC_RXIM         BIT_(4)
#define  CYGHWR_HAL_LM3S_UART_IMSC_DSRMIM       BIT_(3)
#define  CYGHWR_HAL_LM3S_UART_IMSC_DCDMIM       BIT_(2)
#define  CYGHWR_HAL_LM3S_UART_IMSC_CTSMIM       BIT_(1)
#define  CYGHWR_HAL_LM3S_UART_IMSC_RIMIM        BIT_(0)

// UART GPIO pins

#define CYGHWR_HAL_LM3S_UART0_RX                CYGHWR_HAL_LM3S_GPIO( A,  0, 2mA, ALT_DIGITAL )
#define CYGHWR_HAL_LM3S_UART0_TX                CYGHWR_HAL_LM3S_GPIO( A,  1, 2mA, ALT_DIGITAL )
#define CYGHWR_HAL_LM3S_UART0_CLOCK             CYGHWR_HAL_LM3S_CLOCK( 1, UART0 )

#define CYGHWR_HAL_LM3S_UART1_RX                CYGHWR_HAL_LM3S_GPIO( D,  2, 2mA, ALT_DIGITAL )
#define CYGHWR_HAL_LM3S_UART1_TX                CYGHWR_HAL_LM3S_GPIO( D,  3, 2mA, ALT_DIGITAL )
#define CYGHWR_HAL_LM3S_UART1_CLOCK             CYGHWR_HAL_LM3S_CLOCK( 1, UART1 )

#ifndef __ASSEMBLER__

__externC void hal_lm3s_uart_setbaud( CYG_ADDRESS uart, cyg_uint32 baud );

#endif

//=============================================================================
// I2C
//
// Only the master mode register fields are defined.

#define CYGHWR_HAL_LM3S_I2C_MSA                 0x000
#define CYGHWR_HAL_LM3S_I2C_MCS                 0x004
#define CYGHWR_HAL_LM3S_I2C_MDR                 0x008
#define CYGHWR_HAL_LM3S_I2C_MTPR                0x00C
#define CYGHWR_HAL_LM3S_I2C_MIMR                0x010
#define CYGHWR_HAL_LM3S_I2C_MRIS                0x014
#define CYGHWR_HAL_LM3S_I2C_MIS                 0x018
#define CYGHWR_HAL_LM3S_I2C_MICR                0x01C
#define CYGHWR_HAL_LM3S_I2C_MCR                 0x020

#define CYGHWR_HAL_LM3S_I2C_MSA_RX              BIT_(0)
#define CYGHWR_HAL_LM3S_I2C_MSA_TX              0
#define CYGHWR_HAL_LM3S_I2C_MSA_SA(__sa)        VALUE_(1,__sa)

// MCS read-only bits
#define CYGHWR_HAL_LM3S_I2C_MCS_BUSBSY          BIT_(6)
#define CYGHWR_HAL_LM3S_I2C_MCS_IDLE            BIT_(5)
#define CYGHWR_HAL_LM3S_I2C_MCS_ARBLST          BIT_(4)
#define CYGHWR_HAL_LM3S_I2C_MCS_DATACK          BIT_(3)
#define CYGHWR_HAL_LM3S_I2C_MCS_ARDACK          BIT_(2)
#define CYGHWR_HAL_LM3S_I2C_MCS_ERROR           BIT_(1)
#define CYGHWR_HAL_LM3S_I2C_MCS_BUSY            BIT_(0)

// MCS write-only bits
#define CYGHWR_HAL_LM3S_I2C_MCS_ACK             BIT_(3)
#define CYGHWR_HAL_LM3S_I2C_MCS_STOP            BIT_(2)
#define CYGHWR_HAL_LM3S_I2C_MCS_START           BIT_(1)
#define CYGHWR_HAL_LM3S_I2C_MCS_RUN             BIT_(0)

// MIMR, MRIS, MIS, MICR
#define CYGHWR_HAL_LM3S_I2C_MINT                BIT_(0)

// MCR
#define CYGHWR_HAL_LM3S_I2C_MCR_SFE             BIT_(5)
#define CYGHWR_HAL_LM3S_I2C_MCR_MFE             BIT_(4)
#define CYGHWR_HAL_LM3S_I2C_MCR_LPBK            BIT_(0)

// GPIO pin descriptors

#define CYGHWR_HAL_LM3S_I2C0_SCL                CYGHWR_HAL_LM3S_GPIO( B, 2, 2mA, ALT_ODPU )
#define CYGHWR_HAL_LM3S_I2C0_SDA                CYGHWR_HAL_LM3S_GPIO( B, 3, 2mA, ALT_ODPU )

// Clock enable

#define CYGHWR_HAL_LM3S_I2C0_CLOCK              CYGHWR_HAL_LM3S_CLOCK( 1, I2C0 )

__externC void hal_lm3s_i2c_init( cyg_uint32 bus, cyg_uint32 clock );

//=============================================================================
// SPI
//
// The SSI device is actually an ARM PL022 primecell. There is a
// generic driver for this that contains all the register
// definitions. So here we define only the GPIO and clock control
// descriptors.

// GPIO pin descriptors

#define CYGHWR_HAL_LM3S_SPI0_SCLK               CYGHWR_HAL_LM3S_GPIO( A, 2, 2mA, ALT_PP )
#define CYGHWR_HAL_LM3S_SPI0_MISO               CYGHWR_HAL_LM3S_GPIO( A, 4, 2mA, ALT_PP )
#define CYGHWR_HAL_LM3S_SPI0_MOSI               CYGHWR_HAL_LM3S_GPIO( A, 5, 2mA, ALT_PP )

// Clock enable

#define CYGHWR_HAL_LM3S_SPI0_CLOCK              CYGHWR_HAL_LM3S_CLOCK( 1, SSI0 )

//=============================================================================
// Flash controller
//
// We ignore the protection registers since they are write-once from
// software.

#define CYGHWR_HAL_LM3S_FLASH_FMA               0x000
#define CYGHWR_HAL_LM3S_FLASH_FMD               0x004
#define CYGHWR_HAL_LM3S_FLASH_FMC               0x008

// System controller registers
#define CYGHWR_HAL_LM3S_FLASH_USECRL            0x140

// FMC bits
#define CYGHWR_HAL_LM3S_FLASH_FMC_KEY           VALUE_(16,0xA442)
#define CYGHWR_HAL_LM3S_FLASH_FMC_COMT          BIT_(3)
#define CYGHWR_HAL_LM3S_FLASH_FMC_MERASE        BIT_(2)
#define CYGHWR_HAL_LM3S_FLASH_FMC_ERASE         BIT_(1)
#define CYGHWR_HAL_LM3S_FLASH_FMC_WRITE         BIT_(0)

//=============================================================================
// Timers

#define CYGHWR_HAL_LM3S_TIMER_CFG               0x000
#define CYGHWR_HAL_LM3S_TIMER_TAMR              0x004
#define CYGHWR_HAL_LM3S_TIMER_TBMR              0x008
#define CYGHWR_HAL_LM3S_TIMER_CTL               0x00C
#define CYGHWR_HAL_LM3S_TIMER_IMR               0x018
#define CYGHWR_HAL_LM3S_TIMER_RIS               0x01C
#define CYGHWR_HAL_LM3S_TIMER_MIS               0x020
#define CYGHWR_HAL_LM3S_TIMER_ICR               0x024
#define CYGHWR_HAL_LM3S_TIMER_TAILR             0x028
#define CYGHWR_HAL_LM3S_TIMER_TBILR             0x02C
#define CYGHWR_HAL_LM3S_TIMER_TAMATCHR          0x030
#define CYGHWR_HAL_LM3S_TIMER_TBMATCHR          0x034
#define CYGHWR_HAL_LM3S_TIMER_TAPR              0x038
#define CYGHWR_HAL_LM3S_TIMER_TBPR              0x03C
#define CYGHWR_HAL_LM3S_TIMER_TAPMR             0x040
#define CYGHWR_HAL_LM3S_TIMER_TBPMR             0x044
#define CYGHWR_HAL_LM3S_TIMER_TAR               0x048
#define CYGHWR_HAL_LM3S_TIMER_TBR               0x04C

// CFG register
#define CYGHWR_HAL_LM3S_TIMER_CFG_32BIT         VALUE_(0,0)
#define CYGHWR_HAL_LM3S_TIMER_CFG_32BIT_RTC     VALUE_(0,1)
#define CYGHWR_HAL_LM3S_TIMER_CFG_16BIT         VALUE_(0,4)

// TxMR registers
#define CYGHWR_HAL_LM3S_TIMER_TxMR_AM_CAPTURE   0
#define CYGHWR_HAL_LM3S_TIMER_TxMR_AM_PWM       BIT_(3)
#define CYGHWR_HAL_LM3S_TIMER_TxMR_EDGE_COUNT   0
#define CYGHWR_HAL_LM3S_TIMER_TxMR_EDGE_TIME    BIT_(2)
#define CYGHWR_HAL_LM3S_TIMER_TxMR_ONE_SHOT     VALUE_(0,1)
#define CYGHWR_HAL_LM3S_TIMER_TxMR_PERIODIC     VALUE_(0,2)
#define CYGHWR_HAL_LM3S_TIMER_TxMR_CAPTURE      VALUE_(0,3)

// CTL register
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBPWML        BIT_(14)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBOTE         BIT_(13)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBEVENT_POS   VALUE_(10,0)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBEVENT_NEG   VALUE_(10,1)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBEVENT_BOTH  VALUE_(10,3)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBSTALL       BIT_(9)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TBEN          BIT_(8)

#define CYGHWR_HAL_LM3S_TIMER_CTL_TAPWML        BIT_(6)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TAOTE         BIT_(5)
#define CYGHWR_HAL_LM3S_TIMER_CTL_RTCEN         BIT_(4)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TAEVENT_POS   VALUE_(2,0)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TAEVENT_NEG   VALUE_(2,1)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TAEVENT_BOTH  VALUE_(2,3)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TASTALL       BIT_(1)
#define CYGHWR_HAL_LM3S_TIMER_CTL_TAEN          BIT_(0)

// IMR, RIS, MIS, ICR registers
#define CYGHWR_HAL_LM3S_TIMER_INT_CBE           BIT_(10)
#define CYGHWR_HAL_LM3S_TIMER_INT_CBM           BIT_(9)
#define CYGHWR_HAL_LM3S_TIMER_INT_TBTO          BIT_(8)
#define CYGHWR_HAL_LM3S_TIMER_INT_RTC           BIT_(3)
#define CYGHWR_HAL_LM3S_TIMER_INT_CAE           BIT_(2)
#define CYGHWR_HAL_LM3S_TIMER_INT_CAM           BIT_(1)
#define CYGHWR_HAL_LM3S_TIMER_INT_TATO          BIT_(0)

// Clock control

#define CYGHWR_HAL_LM3S_TIMER0_CLOCK            CYGHWR_HAL_LM3S_CLOCK( 1, TIMER0 )
#define CYGHWR_HAL_LM3S_TIMER1_CLOCK            CYGHWR_HAL_LM3S_CLOCK( 1, TIMER1 )
#define CYGHWR_HAL_LM3S_TIMER2_CLOCK            CYGHWR_HAL_LM3S_CLOCK( 1, TIMER2 )
#define CYGHWR_HAL_LM3S_TIMER3_CLOCK            CYGHWR_HAL_LM3S_CLOCK( 1, TIMER3 )

//=============================================================================
// Ethernet MAC and PHY

#define CYGHWR_HAL_LM3S_ETH_RIS                 0x000
#define CYGHWR_HAL_LM3S_ETH_IACK                0x000
#define CYGHWR_HAL_LM3S_ETH_IM                  0x004
#define CYGHWR_HAL_LM3S_ETH_RCTRL               0x008
#define CYGHWR_HAL_LM3S_ETH_TCTRL               0x00C
#define CYGHWR_HAL_LM3S_ETH_DATA                0x010
#define CYGHWR_HAL_LM3S_ETH_IA0                 0x014
#define CYGHWR_HAL_LM3S_ETH_IA1                 0x018
#define CYGHWR_HAL_LM3S_ETH_THR                 0x01C
#define CYGHWR_HAL_LM3S_ETH_MCTL                0x020
#define CYGHWR_HAL_LM3S_ETH_MDV                 0x024
#define CYGHWR_HAL_LM3S_ETH_MTXD                0x02C
#define CYGHWR_HAL_LM3S_ETH_MRXD                0x030
#define CYGHWR_HAL_LM3S_ETH_NP                  0x034
#define CYGHWR_HAL_LM3S_ETH_TR                  0x038
#define CYGHWR_HAL_LM3S_ETH_TS                  0x03C

// RIS, IACK and IM
#define CYGHWR_HAL_LM3S_ETH_INT_PHY             BIT_(6)
#define CYGHWR_HAL_LM3S_ETH_INT_MD              BIT_(5)
#define CYGHWR_HAL_LM3S_ETH_INT_RXER            BIT_(4)
#define CYGHWR_HAL_LM3S_ETH_INT_FOV             BIT_(3)
#define CYGHWR_HAL_LM3S_ETH_INT_TXEMP           BIT_(2)
#define CYGHWR_HAL_LM3S_ETH_INT_TXER            BIT_(1)
#define CYGHWR_HAL_LM3S_ETH_INT_RXINT           BIT_(0)

// RCTR
#define CYGHWR_HAL_LM3S_ETH_RCTRL_RSTFIFO       BIT_(4)
#define CYGHWR_HAL_LM3S_ETH_RCTRL_BADCRC        BIT_(3)
#define CYGHWR_HAL_LM3S_ETH_RCTRL_PRMS          BIT_(2)
#define CYGHWR_HAL_LM3S_ETH_RCTRL_AMUL          BIT_(1)
#define CYGHWR_HAL_LM3S_ETH_RCTRL_RXEN          BIT_(0)

// TCTRL
#define CYGHWR_HAL_LM3S_ETH_TCTRL_DUPLEX        BIT_(4)
#define CYGHWR_HAL_LM3S_ETH_TCTRL_CRC           BIT_(2)
#define CYGHWR_HAL_LM3S_ETH_TCTRL_PADEN         BIT_(1)
#define CYGHWR_HAL_LM3S_ETH_TCTRL_TXEN          BIT_(0)

#define CYGHWR_HAL_LM3S_ETH_MCTL_REGADDR(__x)   VALUE_(3,__x)
#define CYGHWR_HAL_LM3S_ETH_MCTL_WRITE          BIT_(1)
#define CYGHWR_HAL_LM3S_ETH_MCTL_START          BIT_(0)

#define CYGHWR_HAL_LM3S_ETH_TR_NEWTX            BIT_(0)

#define CYGHWR_HAL_LM3S_ETH_TS_TSEN             BIT_(0)

// Clock enable
#define CYGHWR_HAL_LM3S_ETH_MAC0_CLOCK          CYGHWR_HAL_LM3S_CLOCK( 2, EMAC0 )
#define CYGHWR_HAL_LM3S_ETH_PHY0_CLOCK          CYGHWR_HAL_LM3S_CLOCK( 2, EPHY0 )

// GPIO pins
#define CYGHWR_HAL_LM3S_ETH_ETH0_LED0           CYGHWR_HAL_LM3S_GPIO( F, 2, 2mA, ALT_DIGITAL )
#define CYGHWR_HAL_LM3S_ETH_ETH0_LED1           CYGHWR_HAL_LM3S_GPIO( F, 3, 2mA, ALT_DIGITAL )


//-----------------------------------------------------------------------------
// end of var_io.h
#endif // CYGONCE_HAL_VAR_IO_H
