//==========================================================================
//
//      fileio2.c
//
//      Test fileio system
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):           nickg
// Contributors:        nickg
// Date:                2000-05-25
// Purpose:             Test fileio system
// Description:         This test uses the testfs to check out the initialization
//                      and basic operation of the fileio system
//                      
//                      
//                      
//                      
//                      
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/io_fileio.h>
#include <pkgconf/isoinfra.h>

#include <cyg/infra/cyg_trac.h>        // tracing macros
#include <cyg/infra/cyg_ass.h>         // assertion macros

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>

#include <cyg/infra/testcase.h>
#include <cyg/infra/diag.h>            // HAL polled output

//==========================================================================
// Include the test filesystem.
// If we could make tests out of multiple files, then we could just link
// against the object file for this rather than including it.

#include "testfs.c"

//==========================================================================

#define SHOW_RESULT( _fn, _res ) \
db_printf("<INFO>: %3d " #_fn "() returned %ld %s\n", __LINE__, (long)_res, _res<0?strerror(errno):"");

//==========================================================================

#define IOSIZE  100

#define NTHREAD 2

#define RUNTIME 8

//==========================================================================


static cyg_mutex_t db_lock;

#define db_printf( args... )                    \
{                                               \
    cyg_mutex_lock( &db_lock );                 \
    diag_printf("%d: ",id);                     \
    diag_printf( args );                        \
    cyg_mutex_unlock( &db_lock );               \
}

static cyg_sem_t sem;

static volatile int test0_running = 1;

//==========================================================================

void fileio2_test_0( int id, int loops )
{
    int err;
    int i;

    for( i = 0; i < loops; i++ )
    {
        cyg_thread_delay(1);
        err = mount( "", "/fs0", "testfs" );
        if( err < 0 ) SHOW_RESULT( mount, err );    

        cyg_thread_delay(1);
        err = umount( "/fs0" );
        if( err < 0 ) SHOW_RESULT( umount, err );
    }
    
    err = mount( "", "/fs0", "testfs" );
    if( err < 0 ) SHOW_RESULT( mount, err );    

    err = mkdir( "/fs0/test0", 0 );
    if( err < 0 ) SHOW_RESULT( mkdir, err );

    err = mkdir( "/fs0/test1", 0 );
    if( err < 0 ) SHOW_RESULT( mkdir, err );


    for( i = 0; i < loops; i++ )
    {
        cyg_thread_delay(1);
        err = chdir( "/fs0/test0" );
        if( err < 0 ) SHOW_RESULT( chdir, err );

        cyg_thread_delay(1);
        err = chdir( "/fs0/test1" );
        if( err < 0 ) SHOW_RESULT( chdir, err );
        
    }    

    
    err = chdir( "/" );
    if( err < 0 ) SHOW_RESULT( chdir, err );

    err = rmdir( "/fs0/test0" );
    if( err < 0 ) SHOW_RESULT( rmdir, err );

    err = rmdir( "/fs0/test1" );
    if( err < 0 ) SHOW_RESULT( rmdir, err );


    
    err = umount( "/fs0" );
    if( err < 0 ) SHOW_RESULT( umount, err );    
}

//==========================================================================

void fileio2_test_1( int id, int loops )
{
    int err;
    int i, j;

    for( i = 0; i < loops; i++ )
    {
        err = mount( "", "/fs1", "testfs" );
        if( err < 0 ) SHOW_RESULT( mount, err );    
        
        err = umount( "/fs1" );
        if( err < 0 ) SHOW_RESULT( umount, err );    
    }

    err = mount( "", "/fs1", "testfs" );
    if( err < 0 ) SHOW_RESULT( mount, err );    

    err = mkdir( "/fs1/test0", 0 );
    if( err < 0 ) SHOW_RESULT( mkdir, err );

    err = mkdir( "/fs1/test1", 0 );
    if( err < 0 ) SHOW_RESULT( mkdir, err );

    for( i = 0; i < loops; i++ )
    {
        err = chdir( "/fs1/test0" );
        if( err < 0 ) SHOW_RESULT( chdir, err );

        err = chdir( "/fs1/test1" );
        if( err < 0 ) SHOW_RESULT( chdir, err );

    }

    err = chdir( "/" );
    if( err < 0 ) SHOW_RESULT( chdir, err );

    err = rmdir( "/fs1/test0" );
    if( err < 0 ) SHOW_RESULT( rmdir, err );

    err = rmdir( "/fs1/test1" );
    if( err < 0 ) SHOW_RESULT( rmdir, err );
    
    err = umount( "/fs1" );
    if( err < 0 ) SHOW_RESULT( umount, err );    
}

//==========================================================================
// main

void fileio2_main( CYG_ADDRWORD arg )
{
    int id = (int)arg;
    int err;

    if( id == 0 )
    {
        fileio2_test_0(id, RUNTIME*50);
        test0_running = 0;
    }
    else
    {
        while( test0_running )
            fileio2_test_1(id, 1000);
    }

    if( id == 0 )
    {
        int i;
        db_printf("<INFO>: waiting for other threads to finish\n");        
        for( i = 0; i < NTHREAD-1; i++ )
            cyg_semaphore_wait( &sem );

        testfs_dump();
    
        CYG_TEST_PASS_FINISH("fileio2");
    }
    else
    {
        db_printf("<INFO>: thread finished\n");
        cyg_semaphore_post( &sem );
    }
    
    cyg_thread_exit();

    
}

// -------------------------------------------------------------------------

#include <cyg/kernel/kapi.h>

#define STACK_SIZE (CYGNUM_HAL_STACK_SIZE_TYPICAL*2)

static char stack[NTHREAD][STACK_SIZE];
static cyg_handle_t thread_handle[NTHREAD];
static cyg_thread thread[NTHREAD];

externC void
cyg_start( void )
{
    int i;

    CYG_TEST_INIT();

    cyg_mutex_init( &db_lock );
    
    cyg_semaphore_init( &sem, 0 );
    
    for( i = 0; i < NTHREAD; i++ )
    {
        cyg_thread_create(3+i,                  // Priority - just a number
                          fileio2_main,         // entry
                          i,                    // index
                          0,                    // no name
                          &stack[i][0],         // Stack
                          STACK_SIZE,           // Size
                          &thread_handle[i],    // Handle
                          &thread[i]            // Thread data structure
            );
        cyg_thread_resume(thread_handle[i]);
    }

    cyg_scheduler_start();
}

// -------------------------------------------------------------------------
// EOF fileio2.c
