//==========================================================================
//
//        kmutex5.c
//
//        Mutex test 5 - mutex timeouts
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2005, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2005, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Contributors:  nickg
// Date:          2005-12-19
// Description:   Tests mutex timeout functionality.
//
//####DESCRIPTIONEND####
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/kernel.h>

#include <cyg/infra/testcase.h>

#include <cyg/hal/hal_arch.h>           // CYGNUM_HAL_STACK_SIZE_TYPICAL

#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/infra/diag.h>             // diag_printf

#include <cyg/kernel/kapi.h>

// ------------------------------------------------------------------------

#define NTHREADS 2

#define STACKSIZE CYGNUM_HAL_STACK_SIZE_TYPICAL

static cyg_handle_t thread[NTHREADS];
static cyg_thread thread_obj[NTHREADS];
static char stack[NTHREADS][STACKSIZE];

// ------------------------------------------------------------------------

#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
externC void
cyg_hal_invoke_constructors();
#endif

// ------------------------------------------------------------------------
//

#if defined(CYGVAR_KERNEL_COUNTERS_CLOCK) &&                                    \
    (CYGNUM_KERNEL_SCHED_PRIORITIES > 20) &&                                    \
    defined(CYGFUN_KERNEL_API_C) &&                                             \
    !defined(CYGPKG_KERNEL_SMP_SUPPORT)


// ------------------------------------------------------------------------

cyg_mutex_t mx1;

volatile cyg_bool_t expect;

volatile int fails = 0;

// ------------------------------------------------------------------------
// This thread just loops on a mutex timeout.

static void thread1( cyg_addrword_t data )
{
    cyg_tick_count_t timeout = cyg_current_time() + 100;

    for(;;)
    {
        cyg_bool_t result = cyg_mutex_timed_lock( &mx1, timeout );

        if( result != expect )
        {
            CYG_TEST_FAIL("Result not as expected");
            fails++;
        }
        
        if( result )
        {
            diag_printf("<INFO>: %6lld: cyg_mutex_timed_lock returned true\n",cyg_current_time());

            cyg_mutex_unlock( &mx1 );

            cyg_thread_delay(120);
        }
        else
        {
            if( timeout <= cyg_current_time() )
            {
                diag_printf("<INFO>: %6lld: cyg_mutex_timed_lock timeout\n", cyg_current_time());
                timeout = cyg_current_time() + 100;
            }
            else
            {
                diag_printf("<INFO>: %6lld: cyg_mutex_timed_lock non-timeout\n", cyg_current_time());                
            }
        }
    }
}

// ------------------------------------------------------------------------

static void control_thread( cyg_addrword_t data )
{
//    cyg_handle_t self = cyg_thread_self();

    cyg_mutex_init( &mx1 );
    cyg_mutex_lock( &mx1 );

    // Start thread1
    cyg_thread_create( 10,
                       thread1,
                       (cyg_addrword_t)0,
                       "control_thread",
                       (void *)stack[1],
                       STACKSIZE,
                       &thread[1],
                       &thread_obj[1]);
    cyg_thread_resume(thread[1]);

    
    // Wait a bit and then release thread1 to check that it returns
    // false.

    expect = false;
    cyg_thread_delay(150);
    cyg_thread_release( thread[1] );

    cyg_thread_delay(200);

    // Next, unlock the mutex so that thread1 acquires it.
    
    expect = true;
    cyg_mutex_unlock( &mx1 );
    cyg_thread_delay( 100 );
    cyg_mutex_lock( &mx1 );

    
    // Let the thread run for a few more ticks
    expect = false;
    cyg_thread_delay(1000);

    if( fails > 0 )
        CYG_TEST_FAIL_FINISH("Kmutex 5");
    else
        CYG_TEST_PASS_FINISH("Kmutex 5");
}

// ------------------------------------------------------------------------

externC void
cyg_user_start( void )
{ 
#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
    cyg_hal_invoke_constructors();
#endif

    CYG_TEST_INIT();
    
    cyg_thread_create( 4,
                       control_thread ,
                       (cyg_addrword_t)0,
                       "control_thread",
                       (void *)stack[0],
                       STACKSIZE,
                       &thread[0],
                       &thread_obj[0]);
    cyg_thread_resume(thread[0]);

    cyg_scheduler_start();

    CYG_TEST_FAIL_FINISH("Not reached");
}

#else // CYGVAR_KERNEL_COUNTERS_CLOCK &c

externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_INFO("KMutex5 test requires:\n"
                         "CYGFUN_KERNEL_API_C &&\n"
                         "CYGVAR_KERNEL_COUNTERS_CLOCK &&\n"
                         "!defined(CYGPKG_KERNEL_SMP_SUPPORT) &&\n"
                         "(CYGNUM_KERNEL_SCHED_PRIORITIES > 20) &&\n"
        );
    CYG_TEST_NA("KMutex5 test requirements");
}
#endif // CYGVAR_KERNEL_COUNTERS_CLOCK &c

// ------------------------------------------------------------------------
// EOF mutex5.c
