#include <pkgconf/system.h>
#include <pkgconf/libstdcxx.h> // config header
#ifdef CYGPKG_ISOINFRA
# include <pkgconf/isoinfra.h>
#endif
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_ISOINFRA)
# define NA_MSG "Requires isoinfra package"
#elif !defined(CYGPKG_LIBSTDCXX_LIBRARY)
# define NA_MSG "Requires libstdc++ library support"
#elif !CYGINT_ISO_MAIN_STARTUP
# define NA_MSG "Requires main() startup"
#endif

#ifdef NA_MSG

externC void
cyg_start()
{
    CYG_TEST_INIT();
    CYG_TEST_NA( NA_MSG );
    CYG_TEST_FINISH("Done");
}
#else

// 2003-03-29  Paolo Carlini  <pcarlini@unitus.it>

// Copyright (C) 2003 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// stdio_filebuf.h

#include <ext/stdio_filebuf.h>
#include <cstdio>
#include <fstream>
#include "tscpp/testsuite_hooks.h"

// Small stack-based buffers (i.e., using _M_unbuf) were not flushed
// out by _M_really_overflow upon overflow.
void test01()
{
  
  using namespace std;
  bool test = true;

  const char* name = "tmp_file1";
  FILE* file = fopen(name, "w");
  {
    using namespace __gnu_cxx;
    
    // One char big stack-based buffer.
    stdio_filebuf<char> sbuf(file, ios_base::out, 1); 
    sbuf.sputc('T');
    sbuf.sputc('S');
  }
  fclose(file);

  filebuf fbuf;
  fbuf.open(name, ios_base::in);
  char buf[10];
  streamsize n = fbuf.sgetn(buf, sizeof(buf));	
  fbuf.close();
  
  VERIFY( n == 2 );
  VERIFY( !memcmp(buf, "TS", 2) );
}

int main()
{
    CYG_TEST_INIT();
#ifdef CYGPKG_FS_RAM_not_defined
  test01();
#endif
  CYG_TEST_PASS_FINISH( "stdio_filebuf_2 done" );
  return 0;
}

#endif // !NA_MSG

// EOF
