/*========================================================================
//
//      mathfp/s_mathcnst.c
//
//      Part of the standard mathematical function library
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     jlarmour
// Contributors:  
// Date:          2004-02-30
// Purpose:       
// Description:   Derived from newlib libm
//                http://sources.redhat.com/newlib
//                in turn based on SunSoft fdlibm.
//                See copyright/license information below.
// Usage:         #include <math.h>
//
//####DESCRIPTIONEND####
//======================================================================*/

/* @(#)z_mathcnst.c 1.0 98/08/13 */

#include "zmath.h"
#include "mathincl/fdlibm.h"

double BIGX = 7.09782712893383973096e+02;
double SMALLX = -7.45133219101941108420e+02;
double z_rooteps = 7.4505859692e-9;
float  z_rooteps_f = 1.7263349182589107e-4;

ufloat z_hugeval_f  = { 0x7f800000 };
ufloat z_infinity_f = { 0x7f800000 };
ufloat z_notanum_f  = { 0xffd00000 };

#ifdef ___IEEE_LITTLE_ENDIAN
udouble z_hugeval  = { 0x7ff00000, 0 };
udouble z_infinity = { 0x7ff00000, 0 };
udouble z_notanum  = { 0xfff80000, 0 };
#else
udouble z_hugeval  = { 0, 0x7ff00000 };
udouble z_infinity = { 0, 0x7ff00000 };
udouble z_notanum  = { 0, 0xfff80000 };
#endif /* ___IEEE_LITTLE_ENDIAN */


// EOF s_mathcnst.c
