//========================================================================
//
//      lwip_opts.h
//
//      Configuration options for lwIP within eCos
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006, 2007 Free Software Foundation, Inc.            
// Copyright (C) 2004, 2006, 2007 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Authors: Jani Monoses <jani@iv.ro>, jlarmour
 *
 */
#ifndef __LWIPOPTS_H__
#define __LWIPOPTS_H__

/* Include the eCos package configuration */
#include <pkgconf/net_lwip.h>

/* Platform specific locking */

/*
 * Inter-task protection
 * for certain critical regions during buffer allocation, deallocation and memory
 * allocation and deallocation.
 */
#define SYS_LIGHTWEIGHT_PROT            1

/* Checksum algorithm to use in core/inet.c. This probably wants to be a CDL
 * option. Since eCos is pretty much always 32-bits, I guess the chksum4
 * variant should be the best.
 */
#define LWIP_CHKSUM lwip_standard_chksum4


/* ---------- Memory options ---------- */
/* MEM_ALIGNMENT: should be set to the alignment of the CPU for which
   lwIP is compiled. 4 byte alignment -> define MEM_ALIGNMENT to 4, 2
   byte alignment -> define MEM_ALIGNMENT to 2. */
#define MEM_ALIGNMENT          CYGNUM_LWIP_MEM_ALIGNMENT

/* MEM_SIZE: the size of the heap memory. If the application will send
a lot of data that needs to be copied, this should be set high. */
#define MEM_SIZE               CYGNUM_LWIP_MEM_SIZE

#define MEMP_SANITY_CHECK      defined(CYGBDG_LWIP_MEMP_SANITY_CHECK)

/* MEMP_NUM_PBUF: the number of memp struct pbufs. If the application
   sends a lot of data out of ROM (or other static memory), this
   should be set high. */
#define MEMP_NUM_PBUF           CYGNUM_LWIP_MEMP_NUM_PBUF

/* Number of raw connection PCBs */
#ifdef CYGNUM_LWIP_MEMP_NUM_RAW_PCB
# define MEMP_NUM_RAW_PCB        CYGNUM_LWIP_MEMP_NUM_RAW_PCB
#else
# define MEMP_NUM_RAW_PCB        0
#endif

/* MEMP_NUM_UDP_PCB: the number of UDP protocol control blocks. One
   per active UDP "connection". */
#ifdef CYGNUM_LWIP_MEMP_NUM_UDP_PCB
# define MEMP_NUM_UDP_PCB        CYGNUM_LWIP_MEMP_NUM_UDP_PCB
#else
# define MEMP_NUM_UDP_PCB        0
#endif

/* MEMP_NUM_TCP_PCB: the number of simulatenously active TCP
   connections. */
#ifdef CYGNUM_LWIP_MEMP_NUM_TCP_PCB
# define MEMP_NUM_TCP_PCB        CYGNUM_LWIP_MEMP_NUM_TCP_PCB
#else
# define MEMP_NUM_TCP_PCB        0
#endif

/* MEMP_NUM_TCP_PCB_LISTEN: the number of listening TCP
   connections. */
#ifdef CYGNUM_LWIP_MEMP_NUM_TCP_PCB_LISTEN
# define MEMP_NUM_TCP_PCB_LISTEN CYGNUM_LWIP_MEMP_NUM_TCP_PCB_LISTEN
#else
# define MEMP_NUM_TCP_PCB_LISTEN 0
#endif

/* MEMP_NUM_TCP_SEG: the number of simultaneously queued TCP
   segments. */
#ifdef CYGNUM_LWIP_MEMP_NUM_TCP_SEG
# define MEMP_NUM_TCP_SEG        CYGNUM_LWIP_MEMP_NUM_TCP_SEG
#else
# define MEMP_NUM_TCP_SEG        0
#endif

/* MEMP_NUM_SYS_TIMEOUT: the number of simulateously active
   timeouts. */
#define MEMP_NUM_SYS_TIMEOUT    \
    (CYGNUM_LWIP_MEMP_NUM_INTERNAL_TIMEOUTS+CYGNUM_LWIP_MEMP_NUM_USER_TIMEOUTS)


/* The following four are used only with the sequential API and can be
   set to 0 if the application only will use the raw API. */
/* MEMP_NUM_NETBUF: the number of struct netbufs. */
#ifdef CYGNUM_LWIP_MEMP_NUM_NETBUF
# define MEMP_NUM_NETBUF         CYGNUM_LWIP_MEMP_NUM_NETBUF
#else
# define MEMP_NUM_NETBUF         0
#endif

/* MEMP_NUM_NETCONN: the number of struct netconns. */
#ifdef CYGNUM_LWIP_MEMP_NUM_NETCONN
# define MEMP_NUM_NETCONN        CYGNUM_LWIP_MEMP_NUM_NETCONN
#else
# define MEMP_NUM_NETCONN        0
#endif
/* MEMP_NUM_APIMSG: the number of struct api_msg, used for
   communication between the TCP/IP stack and the sequential
   programs. */
#ifdef CYGNUM_LWIP_MEMP_NUM_API_MSG
# define MEMP_NUM_API_MSG        CYGNUM_LWIP_MEMP_NUM_API_MSG
#else
# define MEMP_NUM_API_MSG        0
#endif
/* MEMP_NUM_TCPIPMSG: the number of struct tcpip_msg, which is used
   for sequential API communication and incoming packets. Used in
   src/api/tcpip.c. */
#define MEMP_NUM_TCPIP_MSG      CYGNUM_LWIP_MEMP_NUM_TCPIP_MSG

/* ---------- Pbuf options ---------- */
/* PBUF_POOL_SIZE: the number of buffers in the pbuf pool. */
#define PBUF_POOL_SIZE          CYGNUM_LWIP_PBUF_POOL_SIZE

/* PBUF_POOL_BUFSIZE: the size of each pbuf in the pbuf pool. */
#define PBUF_POOL_BUFSIZE       CYGNUM_LWIP_PBUF_POOL_BUFSIZE

/* PBUF_LINK_HLEN: the number of bytes that should be allocated for a
   link level header. */
#define PBUF_LINK_HLEN          CYGNUM_LWIP_PBUF_LINK_HLEN

/* ---------- TCP options ---------- */
#define LWIP_TCP                defined(CYGPKG_LWIP_TCP)
#define TCP_TTL                 CYGNUM_LWIP_TCP_TTL

/* Controls if TCP should queue segments that arrive out of
   order. Define to 0 if your device is low on memory. */
#define TCP_QUEUE_OOSEQ         defined(CYGIMP_LWIP_TCP_QUEUE_OOSEQ)
    
/* TCP Maximum segment size. */
#define TCP_MSS                 CYGNUM_LWIP_TCP_MSS

/* TCP sender buffer space (bytes). */
#define TCP_SND_BUF             CYGNUM_LWIP_TCP_SND_BUF
#define TCP_SNDLOWAT            CYGNUM_LWIP_TCP_SNDLOWAT

/* TCP sender buffer space (pbufs). This must be at least = 2 *
   TCP_SND_BUF/TCP_MSS for things to work. */
#define TCP_SND_QUEUELEN        CYGNUM_LWIP_TCP_SND_QUEUELEN

/* TCP receive window. */
#define TCP_WND                 CYGNUM_LWIP_TCP_WND

/* Maximum number of retransmissions of data segments. */
#define TCP_MAXRTX              CYGNUM_LWIP_TCP_MAXRTX

/* Maximum number of retransmissions of SYN segments. */
#define TCP_SYNMAXRTX           CYGNUM_LWIP_TCP_SYNMAXRTX

/* ---------- ARP options ---------- */
#define ARP_TABLE_SIZE          CYGNUM_LWIP_ARP_TABLE_SIZE
/* Outgoing packets are queued during hardware address resolution. */
#define ARP_QUEUEING            defined(CYGSEM_LWIP_ARP_QUEUEING)

/* ---------- IP options ---------- */
/* Define IP_FORWARD to 1 if you wish to have the ability to forward
   IP packets across network interfaces. If you are going to run lwIP
   on a device with only one network interface, define this to 0. */
#define IP_FORWARD              defined(CYGFUN_LWIP_IP_FORWARD)


/* If defined to 1, IP options are allowed (but not parsed). If
   defined to 0, all packets with IP options are dropped. */
#define IP_OPTIONS              defined(CYGFUN_LWIP_IP_OPTIONS)

/** IP reassembly and segmentation. Even if they both deal with IP
 *  fragments, note that these are orthogonal, one dealing with incoming
 *  packets, the other with outgoing packets
 */

/** Reassemble incoming fragmented IP packets */
#define IP_REASSEMBLY           defined(CYGFUN_LWIP_IP_REASS)

/* IP reassembly buffer size (minus IP header) */
#define IP_REASS_BUFSIZE        CYGNUM_LWIP_IP_REASS_BUFSIZE

/* IP reassembly default age in seconds */
#define IP_REASS_MAXAGE         CYGNUM_LWIP_IP_REASS_MAXAGE

/** Fragment outgoing IP packets if their size exceeds MTU */
#define IP_FRAG                 defined(CYGFUN_LWIP_IP_FRAG)

/* Use a static MTU-sized buffer for IP fragmentation.
 * Otherwise pbufs are allocated and reference the original
 * packet data to be fragmented.
 */
#define IP_FRAG_USES_STATIC_BUF defined(CYGIMP_LWIP_IP_FRAG_USES_STATIC_BUF)

/* Assumed max MTU on any interface for IP frag buffer */
#if IP_FRAG_USES_STATIC_BUF
# define IP_FRAG_MAX_MTU        CYGNUM_LWIP_IP_FRAG_MAX_MTU
#endif

/* ---------- ICMP options ---------- */
#define ICMP_TTL                CYGNUM_LWIP_ICMP_TTL


/* ---------- DHCP options ---------- */
/* Define LWIP_DHCP to 1 if you want DHCP configuration of
   interfaces.*/
#define LWIP_DHCP               defined(CYGFUN_LWIP_DHCP)
#define DHCP_DOES_ARP_CHECK     defined(CYGIMP_LWIP_DHCP_ARP_CHECK)


/* ---------- UDP options ---------- */
#define LWIP_UDP                defined(CYGPKG_LWIP_UDP)
#define UDP_TTL                 CYGNUM_LWIP_UDP_TTL

/* ---------- RAW socket support ---------- */
#define LWIP_RAW                defined(CYGPKG_LWIP_RAW)

#define RAW_TTL                 CYGNUM_LWIP_RAW_TTL

/* ---------- SLIP options --------- */ 
#define LWIP_SLIP               defined(CYGPKG_LWIP_SLIP)
#define SLIP_DEV                CYGDAT_LWIP_SLIP_DEV

/* ---------- LOOPIF options --------- */ 
#define LWIP_HAVE_LOOPIF	    defined(CYGFUN_LWIP_LOOPIF)

/* ---------- PPP options --------- */ 
#define PPP_SUPPORT             defined(CYGPKG_LWIP_PPP)
#define NUM_PPP                 1 /* for now */
#define PPP_DEV                 CYGDAT_LWIP_PPP_DEV
#define MD5_SUPPORT             defined(CYGIMP_LWIP_PPP_MD5)
#ifdef CYGFUN_LWIP_PPP_PAP_AUTH
# define PAP_SUPPORT	        1
#else
# define PAP_SUPPORT            0
#endif
#ifdef CYGFUN_LWIP_PPP_CHAP_AUTH
# define CHAP_SUPPORT	        1
#else
# define CHAP_SUPPORT	        0
#endif
#define VJ_SUPPORT              defined(CYGIMP_LWIP_PPP_VJ_HEADER_COMPRESS)

/* ------- Thread priorities ---------------*/
#define TCPIP_THREAD_PRIO       CYGNUM_LWIP_NETWORK_THREAD_PRIORITY
#define SLIPIF_THREAD_PRIO      CYGNUM_LWIP_SLIP_THREAD_PRIORITY
#define PPP_THREAD_PRIO         CYGNUM_LWIP_PPP_THREAD_PRIORITY


/* ---------- Statistics options ---------- */
#define LWIP_STATS	        defined(CYGDBG_LWIP_STATS)

#if LWIP_STATS
/* Always include functions to display statistics - no overhead for us in eCos
 * just to build them - linker GC will discard if truly unused. */
# define LWIP_STATS_DISPLAY      1

# define LINK_STATS              defined(CYGDBG_LWIP_STATS_LINK)
# define IP_STATS                defined(CYGDBG_LWIP_STATS_IP)
# define IPFRAG_STATS            defined(CYGDBG_LWIP_STATS_IPFRAG)
# define ICMP_STATS              defined(CYGDBG_LWIP_STATS_ICMP)
# define UDP_STATS               defined(CYGDBG_LWIP_STATS_UDP)
# define TCP_STATS               defined(CYGDBG_LWIP_STATS_TCP)
# define MEM_STATS               defined(CYGDBG_LWIP_STATS_MEM)
# define MEMP_STATS              defined(CYGDBG_LWIP_STATS_MEMP)
# define PBUF_STATS              defined(CYGDBG_LWIP_STATS_PBUF)
# define SYS_STATS               defined(CYGDBG_LWIP_STATS_SYS)
# define RAW_STATS               defined(CYGDBG_LWIP_STATS_RAW)
#endif


// --------- Sockets options --------------
#define LWIP_COMPAT_SOCKETS     defined(CYGFUN_LWIP_COMPAT_SOCKETS)


/* checksum options */

#define CHECKSUM_GEN_IP                 defined(CYGIMP_LWIP_CHECKSUMS_GEN_IP)
#define CHECKSUM_GEN_UDP                defined(CYGIMP_LWIP_CHECKSUMS_GEN_UDP)
#define CHECKSUM_GEN_TCP                defined(CYGIMP_LWIP_CHECKSUMS_GEN_TCP)
#define CHECKSUM_CHECK_IP               defined(CYGIMP_LWIP_CHECKSUMS_CHECK_IP)
#define CHECKSUM_CHECK_UDP              defined(CYGIMP_LWIP_CHECKSUMS_CHECK_UDP)
#define CHECKSUM_CHECK_TCP              defined(CYGIMP_LWIP_CHECKSUMS_CHECK_TCP)

/* ------------------------------------------------------------------------ */
/* ---------- Debug options ---------- */
#if !defined(CYGDBG_LWIP_ASSERTS)
#define LWIP_NOASSERT
#endif

#if defined(CYGDBG_LWIP_DEBUG)
# define LWIP_DEBUG

# if defined(CYGDBG_LWIP_DEBUG_MIN_LEVEL_All)
#  define DBG_MIN_LEVEL DBG_LEVEL_OFF
# elif defined(CYGDBG_LWIP_DEBUG_MIN_LEVEL_Warning)
#  define DBG_MIN_LEVEL DBG_LEVEL_WARNING
# elif defined(CYGDBG_LWIP_DEBUG_MIN_LEVEL_Serious)
#  define DBG_MIN_LEVEL DBG_LEVEL_SERIOUS
# elif defined(CYGDBG_LWIP_DEBUG_MIN_LEVEL_Severe)
#  define DBG_MIN_LEVEL DBG_LEVEL_SEVERE
# endif

# ifdef CYGDBG_LWIP_DEBUG_TYPE_NORMAL
#  define _LWIP_DBG_TYPE_ON DBG_ON
# else
#  define _LWIP_DBG_TYPE_ON 0
# endif

# ifdef CYGDBG_LWIP_DEBUG_TYPE_TRACE
#  define _LWIP_DBG_TYPE_TRACE DBG_TRACE
# else
#  define _LWIP_DBG_TYPE_TRACE 0
# endif

# ifdef CYGDBG_LWIP_DEBUG_TYPE_STATE
#  define _LWIP_DBG_TYPE_STATE DBG_STATE
# else
#  define _LWIP_DBG_TYPE_STATE 0
# endif

# ifdef CYGDBG_LWIP_DEBUG_TYPE_FRESH
#  define _LWIP_DBG_TYPE_FRESH DBG_FRESH
# else
#  define _LWIP_DBG_TYPE_FRESH 0
# endif

# define DBG_TYPES_ON    (_LWIP_DBG_TYPE_ON|_LWIP_DBG_TYPE_TRACE|_LWIP_DBG_TYPE_STATE|_LWIP_DBG_TYPE_FRESH|DBG_HALT)

# ifdef CYGDBG_LWIP_DEBUG_ETHARP
#  define ETHARP_DEBUG             DBG_ON
# else
#  define ETHARP_DEBUG             DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_NETIF
#  define NETIF_DEBUG              DBG_ON
# else
#  define NETIF_DEBUG              DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_PBUF
#  define PBUF_DEBUG               DBG_ON
# else
#  define PBUF_DEBUG               DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_API_LIB
#  define API_LIB_DEBUG            DBG_ON
# else
#  define API_LIB_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_API_MSG
#  define API_MSG_DEBUG            DBG_ON
# else
#  define API_MSG_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_SOCKETS
#  define SOCKETS_DEBUG            DBG_ON
# else
#  define SOCKETS_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_ICMP
#  define ICMP_DEBUG               DBG_ON
# else
#  define ICMP_DEBUG               DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_INET
#  define INET_DEBUG               DBG_ON
# else
#  define INET_DEBUG               DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_IP
#  define IP_DEBUG                 DBG_ON
# else
#  define IP_DEBUG                 DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_IP_REASS
#  define IP_REASS_DEBUG           DBG_ON
# else
#  define IP_REASS_DEBUG           DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_RAW
#  define RAW_DEBUG                DBG_ON
# else
#  define RAW_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_MEM
#  define MEM_DEBUG                DBG_ON
# else
#  define MEM_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_MEMP
#  define MEMP_DEBUG               DBG_ON
# else
#  define MEMP_DEBUG               DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_SYS
#  define SYS_DEBUG                DBG_ON
# else
#  define SYS_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP
#  define TCP_DEBUG                DBG_ON
# else
#  define TCP_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_INPUT
#  define TCP_INPUT_DEBUG          DBG_ON
# else
#  define TCP_INPUT_DEBUG          DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_FR
#  define TCP_FR_DEBUG             DBG_ON
# else
#  define TCP_FR_DEBUG             DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_RTO
#  define TCP_RTO_DEBUG            DBG_ON
# else
#  define TCP_RTO_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_REXMIT
#  define TCP_REXMIT_DEBUG         DBG_ON
# else
#  define TCP_REXMIT_DEBUG         DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_CWND
#  define TCP_CWND_DEBUG           DBG_ON
# else
#  define TCP_CWND_DEBUG           DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_WND
#  define TCP_WND_DEBUG            DBG_ON
# else
#  define TCP_WND_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_OUTPUT
#  define TCP_OUTPUT_DEBUG         DBG_ON
# else
#  define TCP_OUTPUT_DEBUG         DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_RST
#  define TCP_RST_DEBUG            DBG_ON
# else
#  define TCP_RST_DEBUG            DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCP_QLEN
#  define TCP_QLEN_DEBUG           DBG_ON
# else
#  define TCP_QLEN_DEBUG           DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_UDP
#  define UDP_DEBUG                DBG_ON
# else
#  define UDP_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_TCPIP
#  define TCPIP_DEBUG              DBG_ON
# else
#  define TCPIP_DEBUG              DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_PPP
#  define PPP_DEBUG                DBG_ON
# else
#  define PPP_DEBUG                DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_SLIP
#  define SLIP_DEBUG               DBG_ON
# else
#  define SLIP_DEBUG               DBG_OFF
# endif

# ifdef CYGDBG_LWIP_DEBUG_DHCP
#  define DHCP_DEBUG               DBG_ON
# else
#  define DHCP_DEBUG               DBG_OFF
# endif

#endif /* if defined(CYGDBG_LWIP_DEBUG) */

#endif /* __LWIPOPTS_H__ */

/* EOF lwipopts.h */
