//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2004, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================

/* Simple test-case for the BSD socket API  : echo on TCP port 7 */

#include <pkgconf/net_lwip.h>
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_LWIP_TCP)
#define NA_MSG "TCP support disabled"
#elif !defined(CYGFUN_LWIP_COMPAT_SOCKETS)
#define NA_MSG "BSD socket compatibility disabled"
#elif (CYGNUM_LWIP_MEMP_NUM_NETCONN < 2)
#define NA_MSG "Not enough netconns for sockets"
#endif

#ifdef NA_MSG
__externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_NA(NA_MSG);
}
#else

#include <lwip/sys.h>
#include <lwip/sockets.h>
#include <lwip/inet.h>
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h> // CYGNUM_HAL_STACK_SIZE_TYPICAL

char buf[400];
static void
socket_thread(cyg_addrword_t arg)
{
    int sock,s;
    int len, err, loops;
    struct sockaddr_in addr,rem;

    CYG_TEST_INFO( "Starting lwIP socket echo test");
    cyg_lwip_init();
    CYG_TEST_PASS( "Completed cyg_lwip_init");

    sock = socket(AF_INET,SOCK_STREAM,0);
    CYG_TEST_PASS_FAIL( sock >= 0, "socket creation" );

    addr.sin_family = AF_INET;
    addr.sin_port = htons(7);
    addr.sin_addr.s_addr = INADDR_ANY;
    
    err = bind(sock,(struct sockaddr *)&addr,sizeof(addr));
    CYG_TEST_PASS_FAIL( 0 == err, "bind" );
    
    err = listen(sock,5);
    CYG_TEST_PASS_FAIL( 0 == err, "listen" );

    CYG_TEST_INFO("Listening on TCP port 7");
    CYG_TEST_INFO("Will wait for two connections");

    for (loops=0; loops<2; loops++) {
        len = sizeof(rem);
        s = accept(sock,(struct sockaddr*)&rem,&len);
        CYG_TEST_PASS_FAIL( s >= 0, "accept" );
        while((len = read(s,buf,400)) > 0) {
            err = write(s,buf,len);
            CYG_TEST_CHECK( err == len, "wrote all bytes");
        }
        CYG_TEST_PASS_FAIL( len == 0, "read up to EOF ok" );
        
        err = close(s);
        CYG_TEST_PASS_FAIL( err == 0, "close" );
    }	
    CYG_TEST_PASS_FINISH("socket echo test");
}

#define STACK_SIZE CYGNUM_HAL_STACK_SIZE_TYPICAL
static char stack[STACK_SIZE] CYGBLD_ATTRIB_ALIGN_MAX;
static cyg_thread thread_data;
static cyg_handle_t thread_handle;

void
cyg_user_start(void)
{
    CYG_TEST_INIT();
    // Create a main thread, so we can run the scheduler and have time 'pass'
    CYG_TEST_INFO("Creating socket test thread");
    cyg_thread_create(7,                 // Priority - just a number
                      socket_thread,  // entry
                      0,                 // entry parameter
                      "socket echo test",        // Name
                      &stack[0],         // Stack
                      STACK_SIZE,        // Size
                      &thread_handle,    // Handle
                      &thread_data       // Thread data structure
                      );
    cyg_thread_resume(thread_handle);  // Start it
}

#endif // !defined NA_MSG

// EOF socket.c
