//==========================================================================
//
//      ticks.c
//
//      Stand-alone timer support for RedBoot
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    gthomas
// Contributors: gthomas
// Date:         2000-07-14
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include "redboot.h"

static unsigned long ticks = 0;
static long elapsed = 0;

unsigned long
do_ms_tick(void)
{
    CYGACC_CALL_IF_DELAY_US(CYGDBG_REDBOOT_TICK_GRANULARITY);
    elapsed += CYGDBG_REDBOOT_TICK_GRANULARITY;
    if (elapsed >= 1000) {
        elapsed = 0;
        ticks++;
    }
    return ticks;
}

unsigned long
get_ms_ticks(void)
{
    return ticks;
}

// This function allows external functions to update Redboot's idea
// of ticks if they do their own delays.
void
ms_ticks_add_us(long us)
{
    elapsed += us;
    while (elapsed >= 1000) {
        elapsed -= 1000;
        ticks++;
    }
}

// EOF ticks.c
