/* =================================================================
 *
 *      hello.c
 *
 *      Sample module to test the object loader
 *
 * ================================================================= 
 * ####ECOSGPLCOPYRIGHTBEGIN####                                     
 * -------------------------------------------                       
 * This file is part of eCos, the Embedded Configurable Operating System.
 * Copyright (C) 2005, 2008 Free Software Foundation, Inc.           
 * Copyright (C) 2005, 2008 eCosCentric Limited                      
 *
 * eCos is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 or (at your option) any later
 * version.                                                          
 *
 * eCos is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.                                                 
 *
 * You should have received a copy of the GNU General Public License 
 * along with eCos; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.     
 *
 * As a special exception, if other files instantiate templates or use
 * macros or inline functions from this file, or you compile this file
 * and link it with other works to produce a work based on this file,
 * this file does not by itself cause the resulting work to be covered by
 * the GNU General Public License. However the source code for this file
 * must still be made available in accordance with section (3) of the GNU
 * General Public License v2.                                        
 *
 * This exception does not invalidate any other reasons why a work based
 * on this file might be covered by the GNU General Public License.  
 * -------------------------------------------                       
 * ####ECOSGPLCOPYRIGHTEND####                                       
 * =================================================================
 * #####DESCRIPTIONBEGIN####
 * 
 *  Author(s):    Anthony Tonizzo (atonizzo@gmail.com)
 *  Date:         2005-05-13
 *  Purpose:      
 *  Description:  
 *               
 * ####DESCRIPTIONEND####
 * 
 * =================================================================
 */

#include <cyg/kernel/kapi.h>    // Kernel API.
#include <cyg/infra/diag.h>     // For diagnostic printing.
#include <cyg/infra/testcase.h>

// =================================================================

cyg_sem_t sem_signal_thread;
int thread_a_count;

extern int weak_fn_called;

// =================================================================

void weak_function(void) CYGBLD_ATTRIB_WEAK;
void weak_function(void)
{
    // Store the data value passed in for this thread.
    diag_printf("INFO:< This is the module weak function>");
    CYG_TEST_FAIL ("Libraries weak function called when apps should be called");
}

// =================================================================

void module_open(void)
{
    // Initialize the count for thread a.
    thread_a_count = 0;

    // Initialize the semaphore with a count of zero,
    // prior to creating the threads.
    cyg_semaphore_init(&sem_signal_thread, 0);
    CYG_TEST_INFO("Module initialized");
}

// =================================================================

void module_close(void)
{
    CYG_TEST_INFO("Module closed");
}

// =================================================================

void print_message(void)
{
    diag_printf("INFO:<Printing a silly message...>\n");
}

// =================================================================

static void print_message_internal(char c)
{
    diag_printf("INFO:<Printing an internal message from thread %c>\n",c);
}

// =================================================================
// Arithmetic tests
//
// These functions test linking against libgcc by invoking various
// arithmetic operations on different types. The arguments and locals
// are all defined volatile to prevent to compiler trying to optimize
// any of this code and force it to compile each arithmetic operation.
// Obviously it depends on the target and compiler options which
// operations are handled inline and which are done with calls.

void float_arithmetic( volatile float a, volatile float b )
{
    volatile float c, d;

    diag_printf("INFO:<float arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;
}

void double_arithmetic( volatile double a, volatile double b )
{
    volatile double c, d;

    diag_printf("INFO:<double arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;    
}

void long_arithmetic( volatile long a, volatile long b )
{
    volatile long c, d;

    diag_printf("INFO:<long arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;    
    
    c = b % 10;
    d = a << b;
    a = c >> b;
}

void longlong_arithmetic( volatile long long a, volatile long long b )
{
    volatile long long c, d;

    diag_printf("INFO:<long long arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;    
    
    c = b % 10;    
    d = a << b;
    a = c >> b;
}

void ulong_arithmetic( volatile unsigned long a, volatile unsigned long b )
{
    volatile unsigned long c, d;

    diag_printf("INFO:<unsigned long arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;    

    c = b % 10;    
    d = a << b;
    a = c >> b;
}

void ulonglong_arithmetic( volatile unsigned long long a, volatile unsigned long long b )
{
    volatile unsigned long long c, d;

    diag_printf("INFO:<unsigned long long arithmetic test>\n");
    
    if( a >  b ) c = a * b;
    if( c <  a ) d = c / b;
    if( d <= a ) a = d - c;
    if( a >= b ) b = c + a;
    if( c == b ) d = b - a;
    if( c != b ) c = a * c;    
    
    c = b % 10;    
    d = a << b;
    a = c >> b;
}

// =================================================================
// Thread A - signals thread B via semaphore.

//

void thread_a(cyg_addrword_t data)
{
    // Store the data value passed in for this thread.
    int msg = (int)data;
    
    diag_printf("INFO:<Thread A started: message: %d>\n", msg);
    
    weak_function ();

    print_message_internal('A');

    float_arithmetic( 1.2, 4.6 );
    double_arithmetic( 10.3, 8.456 );
    long_arithmetic( 100, 4560 );
    longlong_arithmetic( 5643, -392 );
    ulong_arithmetic( 7894, 234 );
    ulonglong_arithmetic( 9876, 1353 );

    diag_printf("INFO:<done arithmetic tests>\n");
    
    while(thread_a_count < 5)
    {
        // Increment the thread a count.
        thread_a_count++;

        // Send out a message to the diagnostic port.
        diag_printf("INFO:<Thread A, count: %d  message: %d>\n", thread_a_count, msg);

        // Delay for 1 second.
        cyg_thread_delay(100);

        // Signal thread B using the semaphore.
        cyg_semaphore_post(&sem_signal_thread);
    }

    CYG_TEST_CHECK(weak_fn_called == 2 , "Application weak function not called");
    CYG_TEST_FINISH("Object loader test finished");
}

// =================================================================
// Thread B - waits for semaphore signal from thread A.

void thread_b(cyg_addrword_t data)
{
    // Store the data value passed in for this thread.
    int msg = (int)data;

    diag_printf("INFO:<Thread B started: message: %d>\n", msg);

    print_message_internal('B');    
    
    while(1)
    {

        // Signal thread B using the semaphore.
        cyg_semaphore_wait(&sem_signal_thread);

        // Send out a message to the diagnostic port.
        diag_printf("INFO:< Thread B, message: %d>\n", msg);
    }
}

// =================================================================
