#include <config.h>
#include <common.h>
#include <linux-adapter.h>
#include <asm/arch/platform.h>


static void _delay_cl(unsigned long cl)
{
	for(cl=(cl*CFG_CPUCLK_SCALE)>>2; cl!=0; cl--)
		__asm__ __volatile__("nop");
}

static void _delay_cl_100(void)
{
	_delay_cl(100);
}

void cpu_init_sysctrl(void)
{
	unsigned long base = REG_BASE_SCTL;

	__raw_writel(REG_VALUE_SC_NOLOCK, base + REG_SC_PERLOCK);
	__raw_writel( 0x7fff0, base + REG_SC_XTALCTRL);
	__raw_writel( 0xfffffb0, base + REG_SC_PLLCTRL);
	
	//APLL
	__raw_writel(REG_CONF_PERCTRL0,base + REG_SC_PERCTRL0);
	__raw_writel(REG_CONF_PERCTRL1,base + REG_SC_PERCTRL1);
	_delay_cl_100();
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL1)|(1<<22),base + REG_SC_PERCTRL1);
	 
	 while(((__raw_readl(base + REG_SC_PERCTRL23) >> 0) & 0x1) != 0x1);
	
	 /* change arm to NORMAL */
	__raw_writel(__raw_readl(base + REG_SC_CTRL) | 0x7, base + REG_SC_CTRL);
	
	 while((__raw_readl(base + REG_SC_CTRL)>>3 & 0xf) != 0x4);
}

void cpu_init_smi(void)
{
#ifdef CFG_FLASH_TIMING_OPT
#endif
}

void lowlevel_memzero_8burst(unsigned long start, unsigned long end); 
#define memzero_8burst(start, end) do{ \
		__asm__ __volatile__("stmdb sp!, {r4-r12, lr}"); \
		lowlevel_memzero_8burst(start, end); \
		__asm__ __volatile__("ldmia sp!, {r4-r12, lr}"); \
	} while(0)

void cpu_init_ddrc(void)
{	
	unsigned long base = REG_BASE_DDRC;
	
	_delay_cl(40000);
	__raw_writel(0x00000004,base+0x004); _delay_cl(5000);//step1:REGLDR_OFS_WR(0x0004,0x00000000,RLF_DELAY(0x50)) 
	__raw_writel(0x0000000A,base+0x278); _delay_cl_100();//config dll tune=-2

//	__raw_writel(0x00460852,base+0x008); _delay_cl_100();//step2:config the DDR mode register 
	__raw_writel(DDRC_MRS0_VALUE,base+REG_DDRC_EMRS01); _delay_cl_100();//step2:config the DDR mode register 
	__raw_writel(0x00000004,base+0x270); _delay_cl_100();//DDR2 IO ODT=2'b01 75ohm
	
//	__raw_writel(0x800070a2,base+REG_DDRC_CONFIG); _delay_cl_100();//step3:config DDR config register
	__raw_writel(DDRC_CONFIG_VALUE,base+REG_DDRC_CONFIG); _delay_cl_100();//step3:config DDR config register
	
	__raw_writel(0x23440F0B,base+0x020); _delay_cl_100();//step4:config DDR  timing parameter
	__raw_writel(0xc8423420,base+0x024); _delay_cl_100();
	__raw_writel(0x3240C072,base+0x028); _delay_cl_100();
	__raw_writel(0x00000F02,base+0x02c); _delay_cl_100();
	
	__raw_writel(0x0f000003,base+0x03c); _delay_cl_100();//step5:ODT use default config,config trian/track

	__raw_writel(0x00009654,base+0x104); _delay_cl_100();//step6:config port pri
	__raw_writel(0x00000887,base+0x100); _delay_cl_100();
	__raw_writel(0x00000003,base+0x10C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x110); _delay_cl_100();
	__raw_writel(0x00000007,base+0x114); _delay_cl_100();
	__raw_writel(0x00010f01,base+0x118); _delay_cl_100();
	__raw_writel(0x00010f01,base+0x11C); _delay_cl_100();
	__raw_writel(0x00010020,base+0x128); _delay_cl_100();
	__raw_writel(0x000103a2,base+0x12C); _delay_cl_100();
	
	__raw_writel(0x00000005,base+0x130); _delay_cl_100();
	__raw_writel(0x00000007,base+0x134); _delay_cl_100();
	__raw_writel(0x00010804,base+0x138); _delay_cl_100();
	__raw_writel(0x00000007,base+0x13C); _delay_cl_100();
	
	__raw_writel(0x00000006,base+0x004); _delay_cl_100();// step7:start initialization
}

#ifdef CONFIG_RANDOM_ETHADDR
int random_init_r(void)
{
	unsigned long seed;
	unsigned long *base = MEM_BASE_ITCM;
	unsigned int size = ((MEM_BASE_ITCM + MEM_SIZE_ITCM) >> 2);
	for(; base < size; base++){
		seed ^= *base;
	}
	srandom(seed);
	return 0;
}
#endif
