#include <common.h>
#include <command.h>
#include <malloc.h>
#include <devices.h>
#include <version.h>
#include <net.h>
#include <asm/io.h>
#include <asm/arch/platform.h>
#include <asm/sizes.h>
#include <config.h>

unsigned long jpeg_size=0;

typedef unsigned int UINT32;
typedef unsigned char UINT8;
typedef unsigned short UINT16;

extern UINT32  LoadJpegFile(void *pImg);
extern unsigned long ImgWidth, ImgHeight;

const char hilogo_magic_str[] = "HISILICON LOGO MAGIC";
unsigned char hilogo[786*1024];
unsigned long VIDEO_DATA_BASE=0;

int jpeg_decode(void)
{
//#define CFG_MMU_HANDLE
#ifdef CFG_MMU_HANDLE
    unsigned long pdt = MEM_BASE_DDR + SZ_64K;
    mmu_pagedir_init(pdt);
    mmu_pagedir_cached_range(pdt, MEM_BASE_FLASH, SZ_16M);
    mmu_pagedir_cached_range(pdt, MEM_BASE_DDR, SZ_64M);
    mmu_startup(pdt);
#endif

    LoadJpegFile((void *)VIDEO_DATA_BASE);

#ifdef CFG_MMU_HANDLE
    flush_cache_off();
    mmu_turnoff();
#endif

#undef CFG_MMU_HANDLE

    return 0;
}

int load_jpeg(void)
{
    char *s=NULL;
    char *t=NULL;
    long u=0;

    printf("jpeg decoding ...\n");

#if 0
    run_command("setenv vobuf 0xcf000000",0);
    run_command("setenv jpeg_size 0x20000",0);
    run_command("setenv jpeg_addr 0x81f00000",0);
#endif

    s = getenv("vobuf");
    if(s)
    {
    	VIDEO_DATA_BASE = simple_strtol(s,NULL,0);
    }
    else
    {
    	printf("Invalid vobuf address!\n");
    	return 1;
    }

    if(VIDEO_DATA_BASE == 0)
    {
        printf("Invalid VOU buffer address 0x%08X\n",VIDEO_DATA_BASE);
        return -1;
    }

    jpeg_size=simple_strtol(getenv("jpeg_size"),NULL,0);

    t = getenv("jpeg_addr");

    memset(hilogo,0x0,786*1024);

    if(t)
    {
    	u=  simple_strtol(t,NULL,0);
        printf("<<addr=%#x, size=%#x, vobuf=%#x>>\n", u,jpeg_size,VIDEO_DATA_BASE);
    	memcpy(hilogo, (char*)u,jpeg_size);
    	if (*(volatile unsigned char *)hilogo != 0xFF || *(volatile unsigned char *)(hilogo+1) != 0xD8)
    	{
    		printf("addr:%#x,size:%d,logoaddr:%#x,:%2x,%2x\n",hilogo,jpeg_size,u
    			,*(volatile unsigned char *)hilogo,*(volatile unsigned char *)(hilogo+1));
    	    return -1;
    	}
    	return 0;
    }
    else
    {
    	printf("you should set jpeg picture's address!\n");
    	return -1;
    }
}


