
#include "hieth.h"
#include "mdio.h"
#include "mac.h"
#include "ctrl.h"
#include "glb.h"
#include "sys.h"

#define HIETH_SYSREG_BASE	(0x20050000)

static void hieth_set_regbit(ulong reg, int bit, int shift)
{
	ulong val;

	val = _readl(reg);

	bit = bit ? 1 : 0;

	val &= ~(1<<shift);
	val |= bit<<shift;

	_writel(val, reg);
}

static void hieth_reset(int rst)
{
#define REG_RESET	0x50
#define RESET_SHIFT	18

	hieth_set_regbit(HIETH_SYSREG_BASE + REG_RESET, rst, RESET_SHIFT);

	udelay(100);
}

#define hieth_clk_ena() do{ _writel(1<<21, HIETH_SYSREG_BASE + 0x024); udelay(100); }while(0)
#define hieth_clk_dis() do{ _writel(1<<21, HIETH_SYSREG_BASE + 0x028); udelay(100); }while(0)

#if 0
#define REG_FUNC_SEL 0x040
#define FUNC_SEL_SHIFT 27

static int function_sel = 0;

static void hieth_function_sel(int dev, int sel)
{
//	hieth_set_regbit(HIETH_SYSREG_BASE + REG_FUNC_SEL, sel, FUNC_SEL_SHIFT);
}

#endif

void hieth_sys_reset(int port)
{
//	hieth_reset(0);
	hieth_reset(1);
}

void hieth_sys_startup(int port)
{
	hieth_clk_ena();
	hieth_sys_reset(0);
}

void hieth_sys_allstop(int port)
{
//	hieth_reset(0);
//	hieth_clk_dis();
}
#if 0
void hieth_sys_shutdown(int port)
{
	hieth_clk_dis();
}

void hieth_sys_resume(int port)
{
	hieth_clk_ena();
}
static void my_udelay( int us){
	volatile long long i = 0;
#define AHB_FREQ 200	/*MHZ*/
	long long sycle = (us * AHB_FREQ) / 6;
	for(; i < sycle; ){
		i++;
	}
}
#endif
void hieth_sys_init(void)
{

//	function_sel = _readl(HIETH_SYSREG_BASE + REG_FUNC_SEL);

//	hieth_reset(0);
//	hieth_function_sel(0, 1);
	hieth_clk_ena();
	hieth_reset(1);
}

void hieth_sys_exit(void)
{
//	hieth_function_sel(0, function_sel & (1<<FUNC_SEL_SHIFT));
}


