#include <common.h>
#include <command.h>
#include <version.h>
#include <asm/io.h>
#include <asm/arch/platform.h>
#include <asm/sizes.h>
#include <config.h>

#include "vou_adp.h"

#define RGB(r,g,b)   (((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff))
#define RGB_RED(c)   ((c & 0xff0000) >> 16)
#define RGB_GREEN(c) ((c & 0xff00) >> 8)
#define RGB_BLUE(c)  (c & 0xff)

#define YUV(y,u,v)   (((y & 0xff) << 16) | ((u & 0xff) << 8) | (v & 0xff))
#define YUV_Y(c)     ((c & 0xff0000) >> 16)
#define YUV_U(c)     ((c & 0xff00) >> 8)
#define YUV_V(c)     (c & 0xff)

static HI_U32 g_au32BgColor[3] = {0xFF00, 0xFF00,0xFF00};	 /* default value is GREEN */

static inline HI_U32 Rgb2Yuv(HI_U32 u32Rgb)
{
    HI_U8 r,g,b;
    HI_U8 y,u,v;

    r = RGB_RED(u32Rgb);
    g = RGB_GREEN(u32Rgb);
    b = RGB_BLUE(u32Rgb);

    /* Y */
    y = (HI_U8)((r*66+g*129+b*25)/256 + 16);

    /* Cb */
    u = (HI_U8)(((b*112-r*38)-g*74)/256 + 128);

    /* Cr */
    v = (HI_U8)(((r*112-g*94)-b*18)/256 + 128);

    return YUV(y,u,v);
}

int set_vobg(unsigned int dev, unsigned int rgb)
{
	if (dev < 3) 
	{
		g_au32BgColor[dev] = rgb;
	}
	return 0;
}

int start_vo(unsigned int dev, unsigned int type, unsigned int sync)
{
    VOU_DRV_BoardInit();

    VOU_DRV_Close(dev);

    VOU_DRV_SetDevMux(dev, type);
    VOU_DRV_SetDevBgColor(dev, Rgb2Yuv(g_au32BgColor[dev]));
    VOU_DRV_SetDevNorm(dev, sync);

    VOU_DRV_Open(dev);

    return 0;
}

int stop_vo(unsigned int dev)
{
    VOU_DRV_Close(dev);

    return 0;
}

int start_gx(unsigned int layer, unsigned addr, unsigned int strd, unsigned int x, unsigned int y, unsigned int w, unsigned int h)
{
    RECT_S stDispRect = {x, y, w, h};

    VOU_DRV_SetLayerAddr(layer,addr);
    VOU_DRV_SetLayerStride(layer,strd);
    VOU_DRV_SetLayerRect(layer,stDispRect);

    VOU_DRV_SetLayerGlobalAlpha(layer, GRAPHIC_ALPHA_OPACITY);
    VOU_DRV_SetLayerDataFmt(layer, LAYER_DTFMT_ARGB1555);

    if (layer == 0 || layer == 1)
    {
        VOU_DRV_SetLayerCSC(layer, HI_TRUE, VOU_CSC_MODE_BT709);
    }
    else
    {
        VOU_DRV_SetLayerCSC(layer, HI_TRUE, VOU_CSC_MODE_BT601);
    }

    VOU_DRV_LayerRegUpdate(layer);

    VOU_DRV_LayerEnable(layer, HI_TRUE);

    return 0;
}

int stop_gx(unsigned int layer)
{
    VOU_DRV_LayerRegUpdate(layer);
    VOU_DRV_LayerEnable(layer, HI_FALSE);
    VOU_DRV_LayerRegUpdate(layer);

    return 0;
}

