/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_adp.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2009/03/13
  Description   :
  History       :
  1.Date        : 2009/03/13
    Author      : x00100808
    Modification: Created file

******************************************************************************/

#ifndef __VOU_ADP_H__
#define __VOU_ADP_H__

#include "hi_type.h"
#include <hi35xx_vo.h>

#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */

#define GRAPHIC_ALPHA_TRANSPARENT   0x0
#define GRAPHIC_ALPHA_OPACITY       0xff

#define hi3515

typedef struct hiRECT_S
{
    HI_S32 s32X;
    HI_S32 s32Y;
    HI_U32 u32Width;
    HI_U32 u32Height;
}RECT_S;

typedef enum hiOUT_DEV_E
{
    OUT_DEV_HD  = 0,                 /* high definition device */
    OUT_DEV_AD  = 1,                 /* assistant device */
    OUT_DEV_SD  = 2,                 /* spot device */
    OUT_DEV_BUTT

} OUT_DEV_E;

typedef enum
{
    VOU_LAYER_HD        = 0,
    VOU_LAYER_AD        = 1,
    VOU_LAYER_SD        = 2,
    VOU_LAYER_BUTT

}VOU_LAYER_E;

typedef enum hiVOU_MIXER_E
{
    VOU_MIXER_1     = 0,
    VOU_MIXER_2     = 1,
    VOU_MIXER_3     = 2,
    VOU_MIXER_BUTT

} VOU_MIXER_E;

typedef enum hiGRPHIC_LAYER_E
{
    GRPHIC_LAYER_G0     = 0,
    GRPHIC_LAYER_G1     = 1,
    GRPHIC_LAYER_G2     = 2,
    GRPHIC_LAYER_G3     = 3,
    GRPHIC_LAYER_HC     = 4,
    GRPHIC_LAYER_BUTT

} GRPHIC_LAYER_E;

typedef enum hiLAYER_DTFMT_E
{
    LAYER_DTFMT_1BPP        = 0,       /* 1bpp */
    LAYER_DTFMT_2BPP        = 1,       /* 2bpp */
    LAYER_DTFMT_4BPP        = 2,       /* 4bpp */
    LAYER_DTFMT_8BPP        = 3,       /* 8bpp */
    LAYER_DTFMT_KRGB444     = 4,       /* RGB444 */
    LAYER_DTFMT_KRGB555     = 5,       /* RGB555 */
    LAYER_DTFMT_RGB565      = 6,       /* RGB565 */
    LAYER_DTFMT_ARGB4444    = 7,       /* RGB4444 */
    LAYER_DTFMT_ARGB1555    = 8,       /* RGB1555 */
    LAYER_DTFMT_KRGB888     = 9,       /* RGB888 */
    LAYER_DTFMT_ARGB8888    = 10,      /* RGB8888 */
    LAYER_DTFMT_BUTT
}LAYER_DTFMT_E;

typedef enum hiVOU_COLORKEY_MODE_E
{
    VOU_COLORKEY_IN     = 0x0,
    VOU_COLORKEY_OUT    = 0x1,
    VOU_COLORKEY_BUTT
} VOU_COLORKEY_MODE_E;

typedef enum hiVOU_CSC_MODE_E
{
    VOU_CSC_MODE_BT601      = 0x0,
    VOU_CSC_MODE_BT709      = 0x1,
    VOU_CSC_MODE_BUTT
} VOU_CSC_MODE_E;

typedef enum hiVOU_BITEXT_MODE_E
{
    VOU_BITEXT_LOW_ZERO         = 0x0,
    VOU_BITEXT_LOW_HIGHBIT      = 0x2,
    VOU_BITEXT_LOW_HIGHBITS     = 0x3,
    VOU_BITEXT_BUTT
} VOU_BITEXT_MODE_E;

/*****************************************************************************
 Family          : Device Operation

 Description     : public settings for device only

  History
  1.Date         : 2009/12/17
    Author       : x00100808
    Modification : Created function

*****************************************************************************/
HI_VOID VOU_DRV_BoardInit(HI_VOID);
HI_VOID VOU_DRV_Open(VO_DEV_E VoDev);
HI_VOID VOU_DRV_Close(VO_DEV_E VoDev);
HI_VOID VOU_DRV_SetDevMux(VO_DEV_E VoDev, VO_INTF_TYPE_E enVoMux);
HI_VOID VOU_DRV_SetDevBgColor(VO_DEV_E VoDev, HI_U32 u32BgColor);
HI_VOID VOU_DRV_SetDevNorm(VO_DEV_E VoDev, VO_INTF_SYNC_E enVoOutMode);
HI_VOID VOU_DRV_LayerVBindMixer(VO_DEV_E VoDev, VOU_MIXER_E Mixer);
HI_VOID VOU_DRV_DateSetting(VOU_LAYER_E Layer, VO_INTF_SYNC_E enOutSync);


/*****************************************************************************
 Family          : Graphics Layer Operation

 Description     : special settings for graphics only

  History
  1.Date         : 2009/3/13
    Author       : x00100808
    Modification : Created function

*****************************************************************************/
HI_S32 VOU_DRV_LayerEnable         (GRPHIC_LAYER_E Layer, HI_BOOL Enable);
HI_S32 VOU_DRV_LayerBindMixer      (GRPHIC_LAYER_E Layer, OUT_DEV_E OutDev);
HI_S32 VOU_DRV_SetLayerAddr        (GRPHIC_LAYER_E Layer, HI_U32 LayerLumaAddr);
HI_S32 VOU_DRV_SetLayerStride      (GRPHIC_LAYER_E Layer, HI_U32 LayerLumaAddr);
HI_S32 VOU_DRV_GetLayerStrideAlign(GRPHIC_LAYER_E Layer, HI_U32 *pu32StrideAlign);
HI_S32 VOU_DRV_SetLayerRect        (GRPHIC_LAYER_E Layer, RECT_S stRect);
HI_S32 VOU_DRV_SetLayerPixelAlpha  (GRPHIC_LAYER_E Layer, HI_BOOL bEnable, HI_U8 u8Alpha0, HI_U8 u8Alpha1);
HI_S32 VOU_DRV_SetLayerGlobalAlpha(GRPHIC_LAYER_E Layer, HI_U32 Alpha);
HI_S32 VOU_DRV_SetLayerPriority    (GRPHIC_LAYER_E Layer, HI_U32 Priority);
HI_S32 VOU_DRV_SetLayerDataFmt     (GRPHIC_LAYER_E Layer, LAYER_DTFMT_E DataFmt);
HI_S32 VOU_DRV_LayerColorKeyEnable (GRPHIC_LAYER_E Layer, HI_BOOL Enable);
HI_S32 VOU_DRV_LayerColorKeyMode   (GRPHIC_LAYER_E Layer, VOU_COLORKEY_MODE_E Mode);
HI_S32 VOU_DRV_LayerColorKeyLimit  (GRPHIC_LAYER_E Layer, HI_U32 MinRgb, HI_U32 MaxRgb);
HI_S32 VOU_DRV_LayerPixAlphaEnable (GRPHIC_LAYER_E Layer, HI_BOOL Enable);
HI_S32 VOU_DRV_SetLayerCSC         (GRPHIC_LAYER_E Layer, HI_BOOL Enable, VOU_CSC_MODE_E Mode);
HI_S32 VOU_DRV_SetLayerBitExtMode  (GRPHIC_LAYER_E Layer, HI_BOOL Enable, VOU_BITEXT_MODE_E Mode);
HI_S32 VOU_DRV_LayerRegUpdate      (GRPHIC_LAYER_E Layer);
HI_S32 VOU_DRV_LayerGetIntfSize    (GRPHIC_LAYER_E Layer, HI_U32 *pu32Width, HI_U32 *pu32Height);



#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

#endif	/* End of #ifdef __VOU_ADP_H__ */

