/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_def.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2009/03/13
  Description   :
  History       :
  1.Date        : 2009/03/13
    Author      : x00100808
    Modification: Created file

******************************************************************************/

#ifndef __VOU_DEF_H__
#define __VOU_DEF_H__

#include "hi_type.h"


#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */

#define VO_BASE_ADDR    0x20130000

/* display channel                                                          */
typedef enum hiHAL_DISP_CHANNEL_E
{
    HAL_DISP_CHANNEL_DHD   = 0,
    HAL_DISP_CHANNEL_DAD   = 1,
    HAL_DISP_CHANNEL_DSD   = 2,
    HAL_DISP_CHANNEL_BUTT

} HAL_DISP_CHANNEL_E;

/* display mux interface                                                    */
typedef enum hiHAL_DISP_MUX_E
{
    HAL_DISP_MUX_CVBS       = 0,
    HAL_DISP_MUX_BT656      = 1,
    HAL_DISP_MUX_VGA        = 2,
    HAL_DISP_MUX_YPBPR      = 3,
    HAL_DISP_MUX_BT1120     = 4,
    HAL_DISP_MUX_LCD        = 5,
    HAL_DISP_MUX_BT1120S    = 6,
    HAL_DISP_MUX_BUTT

} HAL_DISP_MUX_E;

typedef enum hiHAL_DISP_SYNC_MODE_E
{
    HAL_DISP_SYNC_MODE_TIMING   = 0x0,
    HAL_DISP_SYNC_MODE_SIGNAL   = 0x1,
    HAL_DISP_SYNC_MODE_BUTT

} HAL_DISP_SYNC_MODE_E;

typedef enum hiHAL_DISP_BIT_WIDTH_E
{
    HAL_DISP_BIT_WIDTH_1    = 0x0,
    HAL_DISP_BIT_WIDTH_2    = 0x1,
    HAL_DISP_BIT_WIDTH_3    = 0x2,
    HAL_DISP_BIT_WIDTH_BUTT

} HAL_DISP_BIT_WIDTH_E;

/* video surface                                                            */
typedef enum hiHAL_VIDEO_LAYER_E
{
    HAL_VIDEO_LAYER_HD  = 0,
    HAL_VIDEO_LAYER_AD  = 1,
    HAL_VIDEO_LAYER_SD  = 2,
    HAL_VIDEO_LAYER_BUTT

} HAL_VIDEO_LAYER_E;

/* graphic surface                                                          */
typedef enum hiHAL_GRAPHIC_LAYER_E
{
    HAL_GRAPHIC_LAYER_G0    = 0,
    HAL_GRAPHIC_LAYER_G1    = 1,
    HAL_GRAPHIC_LAYER_G2    = 2,
    HAL_GRAPHIC_LAYER_G3    = 3,
    HAL_GRAPHIC_LAYER_HC    = 4,
    HAL_GRAPHIC_LAYER_BUTT

} HAL_GRAPHIC_LAYER_E;

/* alpha arange                                                             */
typedef enum hiHAL_GRAPHIC_ALPHA_ARANGE_E
{
    HAL_GRAPHIC_ALPHA_ARANGE_128    = 0x0,
    HAL_GRAPHIC_ALPHA_ARANGE_256    = 0x1,
    HAL_GRAPHIC_ALPHA_ARANGE_BUTT

} HAL_GRAPHIC_ALPHA_ARANGE_E;

/* pixel format                                                             */
typedef enum hiHAL_PIXEL_FORMAT_E
{
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_400       = 0x0,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_411_1X4   = 0x1,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_411_4X1   = 0x2,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_420       = 0x3,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_422_1X2   = 0x4,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_422_2X1   = 0x5,
    HAL_PIXEL_FORMAT_YCbCr_SEMIPLANAR_444_2X1   = 0x6,

    HAL_PIXEL_FORMAT_CbYCrY_PACKAGE_422         = 0x10,
    HAL_PIXEL_FORMAT_YCbYCr_PACKAGE_422         = 0x11,
    HAL_PIXEL_FORMAT_YCrYCb_PACKAGE_422         = 0x12,
    HAL_PIXEL_FORMAT_YCbCr_PACKAGE_444          = 0x13,

    HAL_PIXEL_FORMAT_CLUT_1BPP                  = 0x00,
    HAL_PIXEL_FORMAT_CLUT_2BPP                  = 0x10,
    HAL_PIXEL_FORMAT_CLUT_4BPP                  = 0x20,
    HAL_PIXEL_FORMAT_CLUT_8BPP                  = 0x30,
    HAL_PIXEL_FORMAT_ACLUT_88                   = 0x38,

    HAL_PIXEL_FORMAT_RGB_444                    = 0x41,
    HAL_PIXEL_FORMAT_RGB_555                    = 0x42,
    HAL_PIXEL_FORMAT_RGB_565                    = 0x43,
    HAL_PIXEL_FORMAT_KRGB_888                   = 0x50,
    HAL_PIXEL_FORMAT_RGB_888                    = 0x60,

    HAL_PIXEL_FORMAT_ARGB_4444                  = 0x48,
    HAL_PIXEL_FORMAT_ARGB_1555                  = 0x49,
    HAL_PIXEL_FORMAT_ARGB_8565                  = 0x51,
    HAL_PIXEL_FORMAT_ARGB_6666                  = 0x52,
    HAL_PIXEL_FORMAT_ARGB_8888                  = 0x68,

    HAL_PIXEL_FORMAT_BUTT

} HAL_PIXEL_FORMAT_E;

/* interface data format                                                    */
typedef enum hiHAL_INTF_DATA_FORMAT_E
{
    HAL_INTF_DATA_FORMAT_YCBCR422   = 0x0,
    HAL_INTF_DATA_FORMAT_YCBCR444   = 0xC,
    HAL_INTF_DATA_FORMAT_RGB888     = 0xC,
    HAL_INTF_DATA_FORMAT_BUTT

} HAL_INTF_DATA_FORMAT_E;

/* csc mode                                                                 */
typedef enum tagHAL_CSC_MODE_E
{
    HAL_CSC_MODE_601    = 0x0,
    HAL_CSC_MODE_709    = 0x1,
    HAL_CSC_MODE_BUTT

} HAL_CSC_MODE_E;

/* scan mode                                                                */
typedef enum tagHAL_SCAN_MODE_E
{
    HAL_SCAN_MODE_INTERLACED       = 0x0,
    HAL_SCAN_MODE_PROGRESSIVE      = 0x1,
    HAL_SCAN_MODE_TOP              = 0x2,
    HAL_SCAN_MODE_BOTTOM           = 0x3,
    HAL_SCAN_MODE_BUTT

}HAL_SCAN_MODE_E;

/* display norm                                                             */
typedef enum hiHAL_DISP_NORM_E
{
    HAL_DISP_NORM_PAL   = 0x0,
    HAL_DISP_NORM_NTSC  = 0x1,
    HAL_DISP_NORM_VGA   = 0x2,
    HAL_DISP_NORM_BUTT

} HAL_DISP_NORM_E;

/* picture pointer                                                          */
typedef enum hiHAL_PIC_POINTER_E
{
    HAL_PIC_THIS        = 0x0,
    HAL_PIC_LAST        = 0x1,
    HAL_PIC_NEXT        = 0x2,
    HAL_PIC_BUTT

} HAL_PIC_POINTER_E;

/* rect structure                                                           */
typedef struct hiHAL_RECT_S
{
    HI_S32 s32X;
    HI_S32 s32Y;
    HI_U32 u32Width;
    HI_U32 u32Height;
}HAL_RECT_S;

/* update mode                                                              */
typedef enum hiHAL_UPDATE_MODE_E
{
    HAL_UPDATE_MODE_FRAME = 0x0,
    HAL_UPDATE_MODE_FILED = 0x1,
    HAL_UPDATE_MODE_BUTT

} HAL_UPDATE_MODE_E;

/* interrupt mask type                                                      */
typedef enum tagHAL_DISP_INTMSK_E
{
    HAL_DISP_INTMSK_NONE        = 0,

    HAL_DISP_INTMSK_DHDVTTHD    = 0x10,
    HAL_DISP_INTMSK_DADVTTHD    = 0x4,
    HAL_DISP_INTMSK_DSDVTTHD    = 0x1,

    HAL_DISP_INTMSK_DHDLBW      = 0x20,
    HAL_DISP_INTMSK_DADLBW      = 0x8,
    HAL_DISP_INTMSK_DSDLBW      = 0x2,

    HAL_DISP_INTMSK_VSDRRINT    = 0x100000,
    HAL_DISP_INTMSK_VADRRINT    = 0x200000,
    HAL_DISP_INTMSK_VHDRRINT    = 0x400000,
    HAL_DISP_INTMSK_G0RRINT     = 0x800000,
    HAL_DISP_INTMSK_G1RRINT     = 0x1000000,
    HAL_DISP_INTMSK_G2RRINT     = 0x2000000,
    HAL_DISP_INTMSK_G3RRINT     = 0x4000000,
    HAL_DISP_INTMSK_HCRRINT     = 0x8000000,

    HAL_DISP_INTMSK_VHDLBW      = 0x20000000,
    HAL_DISP_INTMSK_VADLBW      = 0x10000000,

    HAL_DISP_INTMSK_ALL         = 0xFFF000FF,
    HAL_DISP_INTMSK_BUTT

} HAL_DISP_INTMSK_E;

/* interrupt type                                                           */
typedef enum tagHAL_DISP_INT_E
{
    HAL_DISP_INT_NONE   = 0,

    HAL_DISP_INT_DHDVT  = 0x10,
    HAL_DISP_INT_DADVT  = 0x4,
    HAL_DISP_INT_DSDVT  = 0x1,

    HAL_DISP_INT_VSDRR  = 0x100000,
    HAL_DISP_INT_VADRR  = 0x200000,
    HAL_DISP_INT_VHDRR  = 0x400000,

    HAL_DISP_INT_ALL    = 0xFFF000FF,
    HAL_DISP_INT_BUTT

} HAL_DISP_INT_E;

/* vou graphic layer data extend mode */
typedef enum
{
    HAL_GFX_BITEXTEND_1ST   = 0x0,
    HAL_GFX_BITEXTEND_2ND   = 0x2,
    HAL_GFX_BITEXTEND_3RD   = 0x3

}HAL_GFX_BITEXTEND_E;

/* colorkey mode                                                            */
typedef enum hiHAL_COLORKEY_MODE_E
{
    HAL_COLORKEY_IN     = 0x0,
    HAL_COLORKEY_OUT    = 0x1,
    HAL_COLORKEY_BUTT

} HAL_COLORKEY_MODE_E;

/* mixer id                                                                 */
typedef enum hiHAL_MIXER_E
{
    HAL_MIXER_1     = 0x0,
    HAL_MIXER_2     = 0x1,
    HAL_MIXER_3     = 0x2,
    HAL_MIXER_BUTT

} HAL_MIXER_E;

/* priority layer                                                           */
typedef enum hiHAL_MXIER_LAYER_E
{
    HAL_MXIER_LAYER_NONE     = 0x0,
    HAL_MXIER_LAYER_HD       = 0x1,
    HAL_MXIER_LAYER_AD       = 0x2,
    HAL_MXIER_LAYER_G0       = 0x3,
    HAL_MXIER_LAYER_G1       = 0x4,
    HAL_MXIER_LAYER_G2       = 0x5,
    HAL_MXIER_LAYER_G3       = 0x6,
    HAL_MXIER_LAYER_SD       = 0x7,
    HAL_MXIER_LAYER_BUTT

} HAL_MXIER_LAYER_E;

/* mixer priority                                                           */
typedef enum hiHAL_MIXER_PRIO_E
{
    HAL_MIXER_PRIO_LOW     = 0x0,
    HAL_MIXER_PRIO_1       = 0x1,
    HAL_MIXER_PRIO_2       = 0x2,
    HAL_MIXER_PRIO_3       = 0x3,
    HAL_MIXER_PRIO_HIGH    = 0x4,
    HAL_MIXER_PRIO_BUTT

} HAL_MIXER_PRIO_E;

/* vou coef load mode */
typedef enum
{
    HAL_DISP_COEFMODE_HOR  = 0,
    HAL_DISP_COEFMODE_VER  = 0x1,
    HAL_DISP_COEFMODE_LUT  = 0x2,
    HAL_DISP_COEFMODE_GAM  = 0x3,
    HAL_DISP_COEFMODE_ALL  = 0x4

}HAL_DISP_COEFMODE_E;

/* vou zoom mode */
typedef enum
{
    HAL_DISP_ZMEMODE_HORL  = 0x0,
    HAL_DISP_ZMEMODE_HORC  = 0x1,
    HAL_DISP_ZMEMODE_VERL  = 0x2,
    HAL_DISP_ZMEMODE_VERC  = 0x3,

    HAL_DISP_ZMEMODE_HOR   = 0x4,
    HAL_DISP_ZMEMODE_VER   = 0x5,
    HAL_DISP_ZMEMODE_ALPHA = 0x6,
    HAL_DISP_ZMEMODE_ALL   = 0x7

}HAL_DISP_ZMEMODE_E;

typedef enum hiHAL_DISP_ZME_TYPE_E
{
    HAL_DISP_ZMETYPE_LUM   = 0x0,
    HAL_DISP_ZMETYPE_CHR   = 0x1,
    HAL_DISP_ZMETYPE_ALL   = 0x2,

} HAL_DISP_ZME_TYPE_E;

/*HD_DATEʽ*/
typedef enum tagHAL_DISP_ENCODEFORMAT_E
{
    HAL_DISP_ENCODEFORMAT_480P = 0,
    HAL_DISP_ENCODEFORMAT_576P = 1,
    HAL_DISP_ENCODEFORMAT_720P = 2,
    HAL_DISP_ENCODEFORMAT_1080P = 3,
    HAL_DISP_ENCODEFORMAT_1080I =  4,
    HAL_DISP_ENCODEFORMAT_295M1080P = 5,
    HAL_DISP_ENCODEFORMAT_195M1080I = 6,
    HAL_DISP_ENCODEFORMAT_AS1152I = 7,
    HAL_DISP_ENCODEFORMAT_AS1080I = 8,

    HAL_DISP_ENCODEFORMAT_BUTT
} HAL_DISP_ENCODEFORMAT_E;

/*HD_DATEͬģʽ*/
typedef enum tagHAL_DISP_SYNCFORMAT_E
{
    HAL_DISP_SYNCFORMAT_RGB  = 0,
    HAL_DISP_SYNCFORMAT_YPBPR = 1,
    HAL_DISP_SYNCFORMAT_VGA = 2,

    HAL_DISP_SYNCFORMAT_BUTT
} HAL_DISP_SYNCFORMAT_E;

/*HD_DATEɫʿռתʽ*/
typedef enum tagHAL_DISP_HD_CSCCOEF_E
{
    HAL_DISP_HD_CSCCOEF_YPBPR  = 0,
    HAL_DISP_HD_CSCCOEF_RGB_709 = 1,
    HAL_DISP_HD_CSCCOEF_RGB_601 = 2,
    HAL_DISP_HD_CSCCOEF_RGB_SMPTE240 = 3,

    HAL_DISP_HD_CSCCOEF_BUTT
} HAL_DISP_HD_CSCCOEF_E;

/*HD_DATEͬ*/
typedef enum tagHAL_DISP_HD_SYNCSEL_E
{
    HAL_DISP_HD_OUTPUT_NONE  = 0,
    HAL_DISP_HD_OUTPUT_HSYNC = 1,
    HAL_DISP_HD_OUTPUT_VSYNC = 2,
    HAL_DISP_HD_OUTPUT_FID = 3,

    HAL_DISP_HD_SYNCSEL_BUTT
} HAL_DISP_HD_SYNCSEL_E;

/*HD_DATEͬ*/
typedef enum tagHAL_DISP_HD_VIDEOSEL_E
{
    HAL_DISP_HD_VIDEOSEL_NONE  = 0,
    HAL_DISP_HD_VIDEOSEL_R_PR = 1,
    HAL_DISP_HD_VIDEOSEL_G_Y = 2,
    HAL_DISP_HD_VIDEOSEL_B_PB = 3,

    HAL_DISP_HD_VIDEOSEL_BUTT
} HAL_DISP_HD_VIDEOSEL_E;

/*HD_DATEͬ*/
typedef enum tagHAL_DISP_HD_SRCCTRL_E
{
    HAL_DISP_HD_NONE  = 0,
    HAL_DISP_FILTER_ONLY1 = 1,
    HAL_DISP_2X_INTERPOL = 2,
    HAL_DISP_4X_INTERPOL = 3,

    HAL_DISP_SRCCTRL_BUTT
} HAL_DISP_HD_SRCCTRL_E;

/*δСϢ*/
typedef struct tagHAL_DISP_RECT_S
{
    HI_S32 s32SX;       /*source horizontal start position*/
    HI_S32 s32SY;       /*source vertical start position*/

    HI_S32 s32DXS;       /*dispaly horizontal start position*/
    HI_S32 s32DYS;       /*display vertical start position*/

    HI_S32 s32DXL;       /*dispaly horizontal end position*/
    HI_S32 s32DYL;       /*display vertical end position*/

    HI_S32 s32VX;       /*video horizontal start position*/
    HI_S32 s32VY;       /*video vertical start position*/

    HI_U32 u32InWidth;   /*input width*/
    HI_U32 u32InHeight;  /*input height*/
    HI_U32 u32OutWidth;   /*output width*/
    HI_U32 u32OutHeight;  /*output height*/
} HAL_DISP_RECT_S;

/*Ƶ֡ͬϢ*/
typedef struct tagHAL_DISP_SYNCINFO_S
{
    HI_BOOL  bSynm;
    HI_BOOL  bIop;
    HI_U8    u8Intfb;

    HI_U16    u16Vact ;
    HI_U16    u16Vbb;
    HI_U16    u16Vfb;

    HI_U16    u16Hact;
    HI_U16    u16Hbb;
    HI_U16    u16Hfb;

    HI_U16    u16Bvact;
    HI_U16    u16Bvbb;
    HI_U16    u16Bvfb;

    HI_U16    u16Hpw;
    HI_U16    u16Vpw;

    HI_BOOL  bIdv;
    HI_BOOL  bIhs;
    HI_BOOL  bIvs;
} HAL_DISP_SYNCINFO_S;

/* vou graphic layer key  */
typedef struct tagHAL_GFX_KEY_S
{
    HI_U8 u8Key_r_min;
    HI_U8 u8Key_g_min;
    HI_U8 u8Key_b_min;

    HI_U8 u8Key_r_max;
    HI_U8 u8Key_g_max;
    HI_U8 u8Key_b_max;

    HI_BOOL bKeyMode;
} HAL_GFX_KEY_S;

/* vou graphic layer mask  */
typedef struct tagHAL_GFX_MASK_S
{
    HI_U8 u8Mask_r;
    HI_U8 u8Mask_g;
    HI_U8 u8Mask_b;

} HAL_GFX_MASK_S;

/* vou graphic layer alpha process  */
typedef struct tagHAL_GFX_ALPHA_S
{
    HAL_GFX_KEY_S stKey;
    HAL_GFX_MASK_S stMask;

    HI_U8 u8galpha;
    HI_U8 u8palpha0;
    HI_U8 u8palpha1;

}HAL_GFX_ALPHA_S;

/* vou background color */
typedef struct tagHAL_DISP_BKCOLOR_S
{
    HI_U8 u8Bkg_a;
    HI_U8 u8Bkg_y;
    HI_U8 u8Bkg_cb;
    HI_U8 u8Bkg_cr;

} HAL_DISP_BKCOLOR_S;

/* clip setting */
typedef struct tagHAL_DISP_CLIP_S
{
    HI_U16 u16ClipLow_y;
    HI_U16 u16ClipLow_cb;
    HI_U16 u16ClipLow_cr;

    HI_U16 u16ClipHigh_y;
    HI_U16 u16ClipHigh_cb;
    HI_U16 u16ClipHigh_cr;

} HAL_DISP_CLIP_S;

/* HD_DATE CSCƼ˲ϵ*/
typedef struct tagHAL_DISP_HD_CSCCTRL_S
{
    HI_BOOL  bCscCtrl;    //ɫȿռת

    HI_U8    u8CscCoef_r_y;
    HI_U8    u8CscCoef_r_cb;
    HI_U8    u8CscCoef_r_cr;

    HI_U8    u8CscCoef_g_y;
    HI_U8    u8CscCoef_g_cb;
    HI_U8    u8CscCoef_g_cr;

    HI_U8    u8CscCoef_b_y;
    HI_U8    u8CscCoef_b_cb;
    HI_U8    u8CscCoef_b_cr;

} HAL_DISP_HD_CSCCTRL_S;

/* HD_DATE ӿڼͬϢ*/
typedef struct tagHAL_DISP_HD_OUPUTINTERFACE_S
{
    HI_U8    u8VideoOutCtrl;    //Ƶʽ
    HI_U8    u8SyncAddCtrl;     //ͬӿ
    HI_U8    u8VideoFt;         //ͬʽ

    HI_U8    u8Video1Sel;       //video1_outƵѡ
    HI_U8    u8Video2Sel;       //video2_outƵѡ
    HI_U8    u8Video3Sel;       //video3_outƵѡ
    HI_U8    u8HsyncSel;        //hsyncѡ
    HI_U8    u8VsyncSel;        //vsyncѡ

} HAL_DISP_HD_OUPUTINTERFACE_S;

/* HD_DATE ӿڼϢ*/
typedef struct tagHAL_DISP_HD_INTERFACEPOLA_S
{
    HI_BOOL bFidOutPola;     //FIDԿ
    HI_BOOL bVsyncOutPola;   //VSYNCԿ
    HI_BOOL bHsyncOutPola;   //HSYNCԿ

    HI_BOOL bFidInPola;      //FIDԿ
    HI_BOOL bVsyncInPola;    //VSYNCԿ
    HI_BOOL bHsyncInPola;    //HYNCԿ

} HAL_DISP_HD_INTERFACEPOLA_S;

/* HD_DATE ˲Ƽ˲ϵ*/
typedef struct tagHAL_DISP_HD_FILTERCTRL_S
{
    HI_BOOL  bSdSel;
    //HI_BOOL  bSyncLpfEn;

    HI_U8    u8SrcCtrl;    //

    HI_U8    u8CoefTap11;
    HI_U8    u8CoefTap12;
    HI_U8    u8CoefTap13;
    HI_U8    u8CoefTap14;

    HI_U8    u8CoefTap21;
    HI_U8    u8CoefTap22;
    HI_U8    u8CoefTap23;
    HI_U8    u8CoefTap24;

    HI_U8    u8CoefTap31;
    HI_U8    u8CoefTap32;
    HI_U8    u8CoefTap33;
    HI_U8    u8CoefTap34;

    HI_U8    u8CoefTap41;
    HI_U8    u8CoefTap42;
    HI_U8    u8CoefTap43;
    HI_U8    u8CoefTap44;

    HI_U16    u16CoefTap51;
    HI_U16    u16CoefTap52;
    HI_U16    u16CoefTap53;
    HI_U16    u16CoefTap54;

    HI_U16    u16CoefTap61;
    HI_U16    u16CoefTap62;
    HI_U16    u16CoefTap63;
    HI_U16    u16CoefTap64;

    HI_U16    u16CoefTap71;
    HI_U16    u16CoefTap72;
    HI_U16    u16CoefTap73;
    HI_U16    u16CoefTap74;

    HI_U16    u16CoefTap81;
    HI_U16    u16CoefTap82;
    HI_U16    u16CoefTap83;
    HI_U16    u16CoefTap84;

    HI_U16    u16CoefTap91;
    HI_U16    u16CoefTap92;
    HI_U16    u16CoefTap93;
    HI_U16    u16CoefTap94;

    HI_U8    u8CoefTap101;
    HI_U8    u8CoefTap102;
    HI_U8    u8CoefTap103;
    HI_U8    u8CoefTap104;

    HI_U8    u8CoefTap111;
    HI_U8    u8CoefTap112;
    HI_U8    u8CoefTap113;
    HI_U8    u8CoefTap114;

    HI_U8    u8CoefTap121;
    HI_U8    u8CoefTap122;
    HI_U8    u8CoefTap123;
    HI_U8    u8CoefTap124;

    HI_U8    u8CoefTap131;
    HI_U8    u8CoefTap132;
    HI_U8    u8CoefTap133;
    HI_U8    u8CoefTap134;

} HAL_DISP_HD_FILTERCTRL_S;

typedef struct
{
    HI_U32 gmm_multi    ;
    HI_U32 thd_med_high ;
    HI_U32 thd_med_low  ;
    HI_U32 thd_high     ;
    HI_U32 thd_low      ;
} GMMTHD_S;

typedef struct
{
    HI_S16 csc_coef00;
    HI_S16 csc_coef01;
    HI_S16 csc_coef02;

    HI_S16 csc_coef10;
    HI_S16 csc_coef11;
    HI_S16 csc_coef12;

    HI_S16 csc_coef20;
    HI_S16 csc_coef21;
    HI_S16 csc_coef22;

    HI_S16 csc_in_dc0;
    HI_S16 csc_in_dc1;
    HI_S16 csc_in_dc2;

    HI_S16 csc_out_dc0;
    HI_S16 csc_out_dc1;
    HI_S16 csc_out_dc2;
} IntfCscCoef_S;




#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

#endif /* End of ifndef __VOU_DEF_H__ */

