/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_gfx_hal.c
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2009/03/13
  Description   :
  History       :
  1.Date        : 2009/03/13
    Author      : x00100808
    Modification: Created file
  2.Date        : 2009/08/12
    Author      : w54723
    Modification: add interface HAL_GRAPHIC_GetLayerStrideAlign
******************************************************************************/

#ifdef __LINUX_OS__
#include <linux/kernel.h>       /* printk */
#include <asm/hardware.h>       /* IO_ADDRESS */
#include <asm/io.h>             /* ioremap_nocache */
#include <linux/delay.h>        /* for ndelay(ns) */
#else
#include <common.h>
#include <command.h>
#include <malloc.h>
#include <devices.h>
#include <version.h>
#include <net.h>
#include <asm/io.h>
#include <asm/arch/platform.h>
#include <asm/sizes.h>
#endif

#include "vou_reg.h"
#include "vou_def.h"


#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */

#define HAL_PRINT()

volatile VOU_REGS_S *pVoReg = NULL;

#define member_offset(member) \
	(int)(&pVoReg->member) - (int)pVoReg

#define member_size(member) \
	sizeof(pVoReg->member)

#define member_verify(member) \
    printf(#member": %x %d\n", member_offset(member), member_size(member))


#define IO_ADDRESS(x) (x)


/*****************************************************************************
 Prototype       : Hal initial
 Description     :

*****************************************************************************/

HI_VOID HAL_VOU_Init(HI_VOID)
{
#if 1
    pVoReg = (volatile VOU_REGS_S *)IO_ADDRESS(VO_BASE_ADDR);
#else
    pVoReg = (volatile VOU_REGS_S *)ioremap_nocache(VO_BASE_ADDR,sizeof(VOU_REGS_S));
#endif
}


/*****************************************************************************
 Prototype       : Control Relative
 Description     :

*****************************************************************************/

HI_VOID HAL_SYS_Control(HI_VOID)
{
     U_VOCTRL VOCTRL;

     VOCTRL.u32 = pVoReg->VOCTRL.u32;
#ifdef HI_FPGA
     VOCTRL.u32 = 0x44440;
#else
    /*
        2009-10-27
        old value = 0x00020201
        modified by chenping

        himm 0x20130000   0x040401;
        VOдoutstandingáͼβȣ
        [19:16]дoutstanding[11:8]outstanding[3:0]ͼβȻѯ1Ϊͼβ
     */

    #ifdef hi3515
        VOCTRL.u32 = 0x00020201;
    #else
        VOCTRL.u32 = 0x00040401;
    #endif
#endif
     pVoReg->VOCTRL.u32 = VOCTRL.u32;
}

HI_VOID HAL_WriteReg(HI_U32 Address, HI_U32 Value)
{
    *((volatile HI_U32 *)IO_ADDRESS(Address)) = Value;
}

HI_VOID HAL_ReadReg(HI_U32 Address, HI_U32 *pValue)
{
    *pValue = *((volatile HI_U32 *)IO_ADDRESS(Address));
}


/*****************************************************************************
 Prototype       : Display Channel Relative
 Description     :

*****************************************************************************/

HI_BOOL HAL_DISP_SetMux(HAL_DISP_CHANNEL_E enChan, HAL_DISP_MUX_E enMux)
{
    U_VOMUX                VOMUX;

    switch(enChan)
    {
        case HAL_DISP_CHANNEL_DHD:
        {
            VOMUX.u32 = pVoReg->VOMUX.u32;
            if (HAL_DISP_MUX_VGA == enMux)
            {
                VOMUX.bits.dac0_mux = 0x0;
                VOMUX.bits.dac1_mux = 0x0;
                VOMUX.bits.dac2_mux = 0x0;
            }
            else if (HAL_DISP_MUX_YPBPR == enMux)
            {
                VOMUX.bits.dac0_mux = 0x1;
                VOMUX.bits.dac1_mux = 0x1;
                VOMUX.bits.dac2_mux = 0x1;
            }
            else if (HAL_DISP_MUX_BT1120 == enMux)
            {
                VOMUX.bits.bt1120_mux = 0x0;
            }
            else if (HAL_DISP_MUX_BT1120S == enMux)
            {
                VOMUX.bits.bt1120_mux = 0x1;
            }
            else
            {
                HAL_PRINT();
            }

            pVoReg->VOMUX.u32 = VOMUX.u32;

            break;
        }
        case HAL_DISP_CHANNEL_DAD:
        {
            VOMUX.u32 = pVoReg->VOMUX.u32;
            if (HAL_DISP_MUX_VGA == enMux)
            {
                VOMUX.bits.dac3_mux = 0x2;
                VOMUX.bits.dac4_mux = 0x2;
                VOMUX.bits.dac5_mux = 0x2;
            }
            else if (HAL_DISP_MUX_CVBS == enMux)
            {
                VOMUX.bits.dac3_mux = 0x0;
            }
            else if (HAL_DISP_MUX_BT656 == enMux)
            {
                VOMUX.bits.dac3_mux = 0x1;
            }
            else
            {
                HAL_PRINT();
            }

            if (HAL_DISP_MUX_VGA != enMux)
            {
                /* ADSDͬʱCVBSʱʾˮӡӰ⣬Թرյdac5
                 * ýӿڶ S-VideoиãAD/SD S-VideoҪע!!!
                 */
                VOMUX.bits.dac5_mux = 0x3;
            }

            pVoReg->VOMUX.u32 = VOMUX.u32;

            break;
        }
        case HAL_DISP_CHANNEL_DSD:
        {
            VOMUX.u32 = pVoReg->VOMUX.u32;
            if (HAL_DISP_MUX_CVBS == enMux)
            {
                VOMUX.bits.dac4_mux = 0x0;
            }
            else if (HAL_DISP_MUX_BT656 == enMux)
            {
                VOMUX.bits.dac4_mux = 0x1;
            }
            else
            {
                HAL_PRINT();
            }

            pVoReg->VOMUX.u32 = VOMUX.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_IntfEnable(HAL_DISP_CHANNEL_E enChan, HI_BOOL enIntf)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;
    U_DSDCTRL              DSDCTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        //VOU VHD CHANNEL disable
        DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.intf_en = enIntf;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;

    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        //VOU VAD CHANNEL disable
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        DADCTRL.bits.intf_en = enIntf;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;

    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        //VOU VSD CHANNEL disable
        DSDCTRL.u32 = pVoReg->DSDCTRL.u32;
        DSDCTRL.bits.intf_en = enIntf;
        pVoReg->DSDCTRL.u32 = DSDCTRL.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_IntfMode(HI_BOOL bSlave)
{
    U_VOMUX                VOMUX;
    U_DHDCTRL              DHDCTRL;

    VOMUX.u32 = pVoReg->VOMUX.u32;
    VOMUX.bits.bt1120_mux = bSlave;
    pVoReg->VOMUX.u32 = VOMUX.u32;

    DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
    DHDCTRL.bits.slave_mode = bSlave;
    pVoReg->DHDCTRL.u32 = DHDCTRL.u32;

    return HI_TRUE;
}

HI_BOOL HAL_DISP_GetIntfEnable(HAL_DISP_CHANNEL_E enChan)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;
    U_DSDCTRL              DSDCTRL;

    HI_BOOL bEnable = HI_FALSE;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        //VOU VHD CHANNEL disable
        DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
        bEnable = DHDCTRL.bits.intf_en;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        //VOU VAD CHANNEL disable
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        bEnable = DADCTRL.bits.intf_en;

    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        //VOU VSD CHANNEL disable
        DSDCTRL.u32 = pVoReg->DSDCTRL.u32;
        bEnable = DSDCTRL.bits.intf_en;
    }

    return bEnable;
}


HI_BOOL HAL_DISP_SetIntfSync(HAL_DISP_CHANNEL_E enChan, HAL_DISP_SYNCINFO_S stSyncInfo)
{
    U_DHDCTRL              DHDCTRL;
    U_DHDVSYNC             DHDVSYNC;
    U_DHDHSYNC1            DHDHSYNC1;
    U_DHDHSYNC2            DHDHSYNC2;
    U_DHDVPLUS             DHDVPLUS;
    U_DHDPWR               DHDPWR;

    U_DADCTRL              DADCTRL;
    U_DADVSYNC             DADVSYNC;
    U_DADHSYNC1            DADHSYNC1;
    U_DADHSYNC2            DADHSYNC2;
    U_DADVPLUS             DADVPLUS;
    U_DADPWR               DADPWR;

    U_DSDCTRL              DSDCTRL;
    U_DSDVSYNC             DSDVSYNC;
    U_DSDHSYNC1            DSDHSYNC1;
    U_DSDHSYNC2            DSDHSYNC2;
    U_DSDVPLUS             DSDVPLUS;
    U_DSDPWR               DSDPWR;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.iop   = stSyncInfo.bIop;
        DHDCTRL.bits.intfb = stSyncInfo.u8Intfb;
        DHDCTRL.bits.synm  = stSyncInfo.bSynm;
        DHDCTRL.bits.idv   = stSyncInfo.bIdv;
        DHDCTRL.bits.ihs   = stSyncInfo.bIhs;
        DHDCTRL.bits.ivs   = stSyncInfo.bIvs;

        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;

        //Config VHD interface horizontal timming
        if (DHDCTRL.bits.intfb == 0) // 2clk/pixel
        {
            DHDHSYNC1.u32 = pVoReg->DHDHSYNC1.u32;
            DHDHSYNC2.u32 = pVoReg->DHDHSYNC2.u32;
            DHDHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DHDHSYNC1.bits.hbb  = (stSyncInfo.u16Hbb)*2-1;
            DHDHSYNC2.bits.hfb  = (stSyncInfo.u16Hfb)*2-1;
            pVoReg->DHDHSYNC1.u32 = DHDHSYNC1.u32;
            pVoReg->DHDHSYNC2.u32 = DHDHSYNC2.u32;
        }
        else
        {
            DHDHSYNC1.u32 = pVoReg->DHDHSYNC1.u32;
            DHDHSYNC2.u32 = pVoReg->DHDHSYNC2.u32;
            DHDHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DHDHSYNC1.bits.hbb  = stSyncInfo.u16Hbb -1;
            DHDHSYNC2.bits.hfb  = stSyncInfo.u16Hfb -1;
            pVoReg->DHDHSYNC1.u32 = DHDHSYNC1.u32;
            pVoReg->DHDHSYNC2.u32 = DHDHSYNC2.u32;
        }

        //Config VHD interface veritical timming
        DHDVSYNC.u32 = pVoReg->DHDVSYNC.u32;
        DHDVSYNC.bits.vact = stSyncInfo.u16Vact  -1;
        DHDVSYNC.bits.vbb = stSyncInfo.u16Vbb - 1;
        DHDVSYNC.bits.vfb =  stSyncInfo.u16Vfb - 1;
        pVoReg->DHDVSYNC.u32 = DHDVSYNC.u32;

        //Config VHD interface veritical bottom timming,no use in progressive mode
        DHDVPLUS.u32 = pVoReg->DHDVPLUS.u32;
        DHDVPLUS.bits.bvact = stSyncInfo.u16Bvact - 1;
        DHDVPLUS.bits.bvbb = stSyncInfo.u16Bvbb - 1;
        DHDVPLUS.bits.bvfb =  stSyncInfo.u16Bvfb - 1;
        pVoReg->DHDVPLUS.u32 = DHDVPLUS.u32;

        //Config VHD interface veritical bottom timming,
        DHDPWR.u32 = pVoReg->DHDPWR.u32;
        DHDPWR.bits.hpw = stSyncInfo.u16Hpw - 1;
        DHDPWR.bits.vpw = stSyncInfo.u16Vpw - 1;
        pVoReg->DHDPWR.u32 = DHDPWR.u32;

    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        //VOU VAD CHANNEL enable
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        DADCTRL.bits.iop = stSyncInfo.bIop;
        DADCTRL.bits.intfb = stSyncInfo.u8Intfb;
        DADCTRL.bits.synm = stSyncInfo.bSynm;
        DADCTRL.bits.idv = stSyncInfo.bIdv;
        DADCTRL.bits.ihs = stSyncInfo.bIhs;
        DADCTRL.bits.ivs = stSyncInfo.bIvs;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;

        //Config VAD interface horizontal timming
        if(DADCTRL.bits.intfb == 0)
        {
            DADHSYNC1.u32 = pVoReg->DADHSYNC1.u32;
            DADHSYNC2.u32 = pVoReg->DADHSYNC2.u32;
            DADHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DADHSYNC1.bits.hbb  = (stSyncInfo.u16Hbb)*2-1;
            DADHSYNC2.bits.hfb  = (stSyncInfo.u16Hfb)*2-1;
            pVoReg->DADHSYNC1.u32 = DADHSYNC1.u32;
            pVoReg->DADHSYNC2.u32 = DADHSYNC2.u32;
        }
        else
        {
            DADHSYNC1.u32 = pVoReg->DADHSYNC1.u32;
            DADHSYNC2.u32 = pVoReg->DADHSYNC2.u32;
            DADHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DADHSYNC1.bits.hbb  = stSyncInfo.u16Hbb -1;
            DADHSYNC2.bits.hfb  = stSyncInfo.u16Hfb -1;
            pVoReg->DADHSYNC1.u32 = DADHSYNC1.u32;
            pVoReg->DADHSYNC2.u32 = DADHSYNC2.u32;
        }

        //Config VAD interface veritical timming
        DADVSYNC.u32 = pVoReg->DHDVSYNC.u32;
        DADVSYNC.bits.vact = stSyncInfo.u16Vact  -1;
        DADVSYNC.bits.vbb = stSyncInfo.u16Vbb - 1;
        DADVSYNC.bits.vfb =  stSyncInfo.u16Vfb - 1;
        pVoReg->DADVSYNC.u32 = DADVSYNC.u32;

        //Config VAD interface veritical bottom timming,no use in progressive mode
        DADVPLUS.u32 = pVoReg->DADVPLUS.u32;
        DADVPLUS.bits.bvact = stSyncInfo.u16Bvact - 1;
        DADVPLUS.bits.bvbb = stSyncInfo.u16Bvbb - 1;
        DADVPLUS.bits.bvfb =  stSyncInfo.u16Bvfb - 1;
        pVoReg->DADVPLUS.u32 = DADVPLUS.u32;

        //Config VAD interface veritical bottom timming,
        DADPWR.u32 = pVoReg->DADPWR.u32;
        DADPWR.bits.hpw = stSyncInfo.u16Hpw - 1;
        DADPWR.bits.vpw = stSyncInfo.u16Vpw - 1 ;
        pVoReg->DADPWR.u32 = DADPWR.u32;

    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        //VOU VSD CHANNEL enable
        DSDCTRL.u32 = pVoReg->DSDCTRL.u32;
        DSDCTRL.bits.iop = stSyncInfo.bIop;
        DSDCTRL.bits.intfb = stSyncInfo.u8Intfb;
        DSDCTRL.bits.synm = stSyncInfo.bSynm;
        DSDCTRL.bits.idv = stSyncInfo.bIdv;
        DSDCTRL.bits.ihs = stSyncInfo.bIhs;
        DSDCTRL.bits.ivs = stSyncInfo.bIvs;
        pVoReg->DSDCTRL.u32 = DSDCTRL.u32;

        //Config VSD interface horizontal timming
        if(DSDCTRL.bits.intfb == 0)
        {
            DSDHSYNC1.u32 = pVoReg->DSDHSYNC1.u32;
            DSDHSYNC2.u32 = pVoReg->DSDHSYNC2.u32;
            DSDHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DSDHSYNC1.bits.hbb  = (stSyncInfo.u16Hbb)*2-1;
            DSDHSYNC2.bits.hfb  = (stSyncInfo.u16Hfb)*2-1;
            pVoReg->DSDHSYNC1.u32 = DSDHSYNC1.u32;
            pVoReg->DSDHSYNC2.u32 = DSDHSYNC2.u32;
        }
        else
        {
            DSDHSYNC1.u32 = pVoReg->DSDHSYNC1.u32;
            DSDHSYNC2.u32 = pVoReg->DSDHSYNC2.u32;
            DSDHSYNC1.bits.hact = stSyncInfo.u16Hact -1;
            DSDHSYNC1.bits.hbb  = stSyncInfo.u16Hbb -1;
            DSDHSYNC2.bits.hfb  = stSyncInfo.u16Hfb -1;
            pVoReg->DSDHSYNC1.u32 = DSDHSYNC1.u32;
            pVoReg->DSDHSYNC2.u32 = DSDHSYNC2.u32;
        }

        //Config VSD interface veritical timming
        DSDVSYNC.u32 = pVoReg->DSDVSYNC.u32;
        DSDVSYNC.bits.vact = stSyncInfo.u16Vact  -1;
        DSDVSYNC.bits.vbb = stSyncInfo.u16Vbb - 1;
        DSDVSYNC.bits.vfb =  stSyncInfo.u16Vfb - 1;
        pVoReg->DSDVSYNC.u32 = DSDVSYNC.u32;

        //Config VSD interface veritical bottom timming,no use in progressive mode
        DSDVPLUS.u32 = pVoReg->DSDVPLUS.u32;
        DSDVPLUS.bits.bvact = stSyncInfo.u16Bvact - 1;
        DSDVPLUS.bits.bvbb = stSyncInfo.u16Bvbb - 1;
        DSDVPLUS.bits.bvfb =  stSyncInfo.u16Bvfb - 1;
        pVoReg->DSDVPLUS.u32 = DSDVPLUS.u32;

        //Config VSD interface veritical bottom timming,
        DSDPWR.u32 = pVoReg->DSDPWR.u32;
        DSDPWR.bits.hpw = stSyncInfo.u16Hpw - 1;
        DSDPWR.bits.vpw = stSyncInfo.u16Vpw - 1 ;
        pVoReg->DSDPWR.u32 = DSDPWR.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_GetIntfIoP(HAL_DISP_CHANNEL_E enChan)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;

    HI_BOOL bInterlaced = HI_TRUE;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        if (DHDCTRL.bits.iop)
            bInterlaced = HI_FALSE;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        if (DADCTRL.bits.iop)
            bInterlaced = HI_FALSE;
    }

    return bInterlaced;
}

HI_BOOL HAL_DISP_SetIntfSyncMode(HAL_DISP_CHANNEL_E enChan, HAL_DISP_SYNC_MODE_E Mode)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.synm  = Mode;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        DADCTRL.bits.synm = Mode;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_SetIntfBitWidth(HAL_DISP_CHANNEL_E enChan, HAL_DISP_BIT_WIDTH_E Width)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.intfb  = Width;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        DADCTRL.bits.intfb = Width;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}


HI_BOOL HAL_DISP_SetIntfDataFmt(HAL_DISP_CHANNEL_E enChan, HAL_INTF_DATA_FORMAT_E stIntfDataFmt)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;
    U_DSDCTRL              DSDCTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        //VOU VHD CHANNEL enable
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.intfdm = stIntfDataFmt;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        //VOU VAD CHANNEL enable
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        DADCTRL.bits.intfdm = stIntfDataFmt;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        //VOU VSD CHANNEL enable
        DSDCTRL.u32 = pVoReg->DSDCTRL.u32;
        DSDCTRL.bits.intfdm = stIntfDataFmt;
        pVoReg->DSDCTRL.u32 = DSDCTRL.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_IntfCscEnable(HAL_DISP_CHANNEL_E enChan, HI_BOOL enCSC)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;
    U_DSDCTRL              DSDCTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.cscen = enCSC;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 =  pVoReg->DADCTRL.u32;
        DADCTRL.bits.cscen = enCSC;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        DSDCTRL.u32 =  pVoReg->DSDCTRL.u32;
        DSDCTRL.bits.cscen = enCSC;
        pVoReg->DSDCTRL.u32 = DSDCTRL.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_SetIntfCscCoef(HAL_DISP_CHANNEL_E enChan, IntfCscCoef_S stCscCoef)
{
    U_DHDCSCIDC            DHDCSCIDC;
    U_DHDCSCODC            DHDCSCODC;
    U_DHDCSCP0             DHDCSCP0;
    U_DHDCSCP1             DHDCSCP1;
    U_DHDCSCP2             DHDCSCP2;
    U_DHDCSCP3             DHDCSCP3;
    U_DHDCSCP4             DHDCSCP4;

    U_DADCSCIDC            DADCSCIDC;
    U_DADCSCODC            DADCSCODC;
    U_DADCSCP0             DADCSCP0;
    U_DADCSCP1             DADCSCP1;
    U_DADCSCP2             DADCSCP2;
    U_DADCSCP3             DADCSCP3;
    U_DADCSCP4             DADCSCP4;

    U_DSDCSCIDC            DSDCSCIDC;
    U_DSDCSCODC            DSDCSCODC;
    U_DSDCSCP0             DSDCSCP0;
    U_DSDCSCP1             DSDCSCP1;
    U_DSDCSCP2             DSDCSCP2;
    U_DSDCSCP3             DSDCSCP3;
    U_DSDCSCP4             DSDCSCP4;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCSCIDC.u32 =  pVoReg->DHDCSCIDC.u32;
        DHDCSCIDC.bits.cscidc2 = stCscCoef.csc_in_dc2;
        DHDCSCIDC.bits.cscidc1 = stCscCoef.csc_in_dc1;
        DHDCSCIDC.bits.cscidc0 = stCscCoef.csc_in_dc0;
         pVoReg->DHDCSCIDC.u32 = DHDCSCIDC.u32;

        DHDCSCODC.u32 =  pVoReg->DHDCSCODC.u32;
        DHDCSCODC.bits.cscodc2 = stCscCoef.csc_out_dc2;
        DHDCSCODC.bits.cscodc1 = stCscCoef.csc_out_dc1;
        DHDCSCODC.bits.cscodc0 = stCscCoef.csc_out_dc0;
         pVoReg->DHDCSCODC.u32 = DHDCSCODC.u32;

        DHDCSCP0.u32 =  pVoReg->DHDCSCP0.u32;
        DHDCSCP0.bits.cscp00 = stCscCoef.csc_coef00;
        DHDCSCP0.bits.cscp01 = stCscCoef.csc_coef01;
         pVoReg->DHDCSCP0.u32 = DHDCSCP0.u32;

        DHDCSCP1.u32 =  pVoReg->DHDCSCP1.u32;
        DHDCSCP1.bits.cscp02 = stCscCoef.csc_coef02;
        DHDCSCP1.bits.cscp10 = stCscCoef.csc_coef10;
         pVoReg->DHDCSCP1.u32 = DHDCSCP1.u32;

        DHDCSCP2.u32 =  pVoReg->DHDCSCP2.u32;
        DHDCSCP2.bits.cscp11 = stCscCoef.csc_coef11;
        DHDCSCP2.bits.cscp12 = stCscCoef.csc_coef12;
         pVoReg->DHDCSCP2.u32 = DHDCSCP2.u32;

        DHDCSCP3.u32 =  pVoReg->DHDCSCP3.u32;
        DHDCSCP3.bits.cscp20 = stCscCoef.csc_coef20;
        DHDCSCP3.bits.cscp21 = stCscCoef.csc_coef21;
         pVoReg->DHDCSCP3.u32 = DHDCSCP3.u32;

        DHDCSCP4.u32 =  pVoReg->DHDCSCP4.u32;
        DHDCSCP4.bits.cscp22 = stCscCoef.csc_coef22;
         pVoReg->DHDCSCP4.u32 = DHDCSCP4.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCSCIDC.u32 =  pVoReg->DADCSCIDC.u32;
        DADCSCIDC.bits.cscidc2 = stCscCoef.csc_in_dc2;
        DADCSCIDC.bits.cscidc1 = stCscCoef.csc_in_dc1;
        DADCSCIDC.bits.cscidc0 = stCscCoef.csc_in_dc0;
         pVoReg->DADCSCIDC.u32 = DADCSCIDC.u32;

        DADCSCODC.u32 =  pVoReg->DADCSCODC.u32;
        DADCSCODC.bits.cscodc2 = stCscCoef.csc_out_dc2;
        DADCSCODC.bits.cscodc1 = stCscCoef.csc_out_dc1;
        DADCSCODC.bits.cscodc0 = stCscCoef.csc_out_dc0;
         pVoReg->DADCSCODC.u32 = DADCSCODC.u32;

        DADCSCP0.u32 =  pVoReg->DADCSCP0.u32;
        DADCSCP0.bits.cscp00 = stCscCoef.csc_coef00;
        DADCSCP0.bits.cscp01 = stCscCoef.csc_coef01;
         pVoReg->DADCSCP0.u32 = DADCSCP0.u32;

        DADCSCP1.u32 =  pVoReg->DADCSCP1.u32;
        DADCSCP1.bits.cscp02 = stCscCoef.csc_coef02;
        DADCSCP1.bits.cscp10 = stCscCoef.csc_coef10;
         pVoReg->DADCSCP1.u32 = DADCSCP1.u32;

        DADCSCP2.u32 =  pVoReg->DADCSCP2.u32;
        DADCSCP2.bits.cscp11 = stCscCoef.csc_coef11;
        DADCSCP2.bits.cscp12 = stCscCoef.csc_coef12;
         pVoReg->DADCSCP2.u32 = DADCSCP2.u32;

        DADCSCP3.u32 =  pVoReg->DADCSCP3.u32;
        DADCSCP3.bits.cscp20 = stCscCoef.csc_coef20;
        DADCSCP3.bits.cscp21 = stCscCoef.csc_coef21;
         pVoReg->DADCSCP3.u32 = DADCSCP3.u32;

        DADCSCP4.u32 =  pVoReg->DADCSCP4.u32;
        DADCSCP4.bits.cscp22 = stCscCoef.csc_coef22;
         pVoReg->DADCSCP4.u32 = DADCSCP4.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        DSDCSCIDC.u32 =  pVoReg->DSDCSCIDC.u32;
        DSDCSCIDC.bits.cscidc2 = stCscCoef.csc_in_dc2;
        DSDCSCIDC.bits.cscidc1 = stCscCoef.csc_in_dc1;
        DSDCSCIDC.bits.cscidc0 = stCscCoef.csc_in_dc0;
         pVoReg->DSDCSCIDC.u32 = DSDCSCIDC.u32;

        DSDCSCODC.u32 =  pVoReg->DSDCSCODC.u32;
        DSDCSCODC.bits.cscodc2 = stCscCoef.csc_out_dc2;
        DSDCSCODC.bits.cscodc1 = stCscCoef.csc_out_dc1;
        DSDCSCODC.bits.cscodc0 = stCscCoef.csc_out_dc0;
         pVoReg->DSDCSCODC.u32 = DSDCSCODC.u32;

        DSDCSCP0.u32 =  pVoReg->DSDCSCP0.u32;
        DSDCSCP0.bits.cscp00 = stCscCoef.csc_coef00;
        DSDCSCP0.bits.cscp01 = stCscCoef.csc_coef01;
         pVoReg->DSDCSCP0.u32 = DSDCSCP0.u32;

        DSDCSCP1.u32 =  pVoReg->DSDCSCP1.u32;
        DSDCSCP1.bits.cscp02 = stCscCoef.csc_coef02;
        DSDCSCP1.bits.cscp10 = stCscCoef.csc_coef10;
         pVoReg->DSDCSCP1.u32 = DSDCSCP1.u32;

        DSDCSCP2.u32 =  pVoReg->DSDCSCP2.u32;
        DSDCSCP2.bits.cscp11 = stCscCoef.csc_coef11;
        DSDCSCP2.bits.cscp12 = stCscCoef.csc_coef12;
         pVoReg->DSDCSCP2.u32 = DSDCSCP2.u32;

        DSDCSCP3.u32 =  pVoReg->DSDCSCP3.u32;
        DSDCSCP3.bits.cscp20 = stCscCoef.csc_coef20;
        DSDCSCP3.bits.cscp21 = stCscCoef.csc_coef21;
         pVoReg->DSDCSCP3.u32 = DSDCSCP3.u32;

        DSDCSCP4.u32 =  pVoReg->DSDCSCP4.u32;
        DSDCSCP4.bits.cscp22 = stCscCoef.csc_coef22;
         pVoReg->DSDCSCP4.u32 = DSDCSCP4.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_SetIntfClip(HAL_DISP_CHANNEL_E enChan, HI_BOOL enClip, HAL_DISP_CLIP_S stClipData)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;
    U_DSDCTRL              DSDCTRL;

    U_DHDCLIPL             DHDCLIPL;
    U_DHDCLIPH             DHDCLIPH;
    U_DADCLIPL             DADCLIPL;
    U_DADCLIPH             DADCLIPH;
    U_DSDCLIPL             DSDCLIPL;
    U_DSDCLIPH             DSDCLIPH;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
        DHDCTRL.bits.clipen = enClip;
        pVoReg->DHDCTRL.u32 = DHDCTRL.u32;

        DHDCLIPL.u32 =  pVoReg->DHDCLIPL.u32;
        DHDCLIPL.bits.clipcl2 = stClipData.u16ClipLow_y;
        DHDCLIPL.bits.clipcl1 = stClipData.u16ClipLow_cb;
        DHDCLIPL.bits.clipcl0 = stClipData.u16ClipLow_cr;
        pVoReg->DHDCLIPL.u32 = DHDCLIPL.u32;

        DHDCLIPH.u32 =  pVoReg->DHDCLIPH.u32;
        DHDCLIPH.bits.clipch2 = stClipData.u16ClipHigh_y;
        DHDCLIPH.bits.clipch1 = stClipData.u16ClipHigh_cb;
        DHDCLIPH.bits.clipch0 = stClipData.u16ClipHigh_cr;
        pVoReg->DHDCLIPH.u32 = DHDCLIPH.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 =  pVoReg->DADCTRL.u32;
        DADCTRL.bits.clipen = enClip;
        pVoReg->DADCTRL.u32 = DADCTRL.u32;

        DADCLIPL.u32 =  pVoReg->DADCLIPL.u32;
        DADCLIPL.bits.clipcl2 = stClipData.u16ClipLow_y;
        DADCLIPL.bits.clipcl1 = stClipData.u16ClipLow_cb;
        DADCLIPL.bits.clipcl0 = stClipData.u16ClipLow_cr;
        pVoReg->DADCLIPL.u32 = DADCLIPL.u32;

        DADCLIPH.u32 =  pVoReg->DADCLIPH.u32;
        DADCLIPH.bits.clipch2 = stClipData.u16ClipHigh_y;
        DADCLIPH.bits.clipch1 = stClipData.u16ClipHigh_cb;
        DADCLIPH.bits.clipch0 = stClipData.u16ClipHigh_cr;
        pVoReg->DADCLIPH.u32 = DADCLIPH.u32;
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        DSDCTRL.u32 =  pVoReg->DSDCTRL.u32;
        DSDCTRL.bits.clipen = enClip;
        pVoReg->DSDCTRL.u32 = DSDCTRL.u32;

        DSDCLIPL.u32 =  pVoReg->DSDCLIPL.u32;
        DSDCLIPL.bits.clipcl2 = stClipData.u16ClipLow_y;
        DSDCLIPL.bits.clipcl1 = stClipData.u16ClipLow_cb;
        DSDCLIPL.bits.clipcl0 = stClipData.u16ClipLow_cr;
        pVoReg->DSDCLIPL.u32 = DSDCLIPL.u32;

        DSDCLIPH.u32 =  pVoReg->DSDCLIPH.u32;
        DSDCLIPH.bits.clipch2 = stClipData.u16ClipHigh_y;
        DSDCLIPH.bits.clipch1 = stClipData.u16ClipHigh_cb;
        DSDCLIPH.bits.clipch0 = stClipData.u16ClipHigh_cr;
        pVoReg->DSDCLIPH.u32 = DSDCLIPH.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_GetIntfSyncSize(HAL_DISP_CHANNEL_E enChan, HI_U32 *pu32Width, HI_U32 *pu32Height)
{
    HI_BOOL bProgress = HI_FALSE;
    HI_U32 u32Widht = 720;
    HI_U32 u32Height = 576;

    U_DHDCTRL              DHDCTRL;
    U_DHDVSYNC             DHDVSYNC;
    U_DHDHSYNC1            DHDHSYNC1;

    U_DADCTRL              DADCTRL;
    U_DADVSYNC             DADVSYNC;
    U_DADHSYNC1            DADHSYNC1;

    U_DSDCTRL              DSDCTRL;
    U_DSDVSYNC             DSDVSYNC;
    U_DSDHSYNC1            DSDHSYNC1;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        DHDCTRL.u32 = pVoReg->DHDCTRL.u32;
        bProgress = DHDCTRL.bits.iop;

        DHDHSYNC1.u32 = pVoReg->DHDHSYNC1.u32;
        u32Widht = DHDHSYNC1.bits.hact + 1;

        DHDVSYNC.u32 = pVoReg->DHDVSYNC.u32;

        if (!bProgress)
        {
            u32Height = (DHDVSYNC.bits.vact + 1) * 2;
        }
        else
        {
            u32Height = (DHDVSYNC.bits.vact + 1);
        }
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        DADCTRL.u32 = pVoReg->DADCTRL.u32;
        bProgress = DADCTRL.bits.iop;

        DADHSYNC1.u32 = pVoReg->DADHSYNC1.u32;
        u32Widht = DADHSYNC1.bits.hact + 1;

        DADVSYNC.u32 = pVoReg->DADVSYNC.u32;

        if (!bProgress)
        {
            u32Height = (DADVSYNC.bits.vact + 1) * 2;
        }
        else
        {
            u32Height = DADVSYNC.bits.vact + 1;
        }
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        DSDCTRL.u32 = pVoReg->DSDCTRL.u32;
        bProgress = DSDCTRL.bits.iop;

        DSDHSYNC1.u32 = pVoReg->DSDHSYNC1.u32;
        u32Widht = DSDHSYNC1.bits.hact + 1;

        DSDVSYNC.u32 = pVoReg->DSDVSYNC.u32;

        u32Height = (DSDVSYNC.bits.vact + 1) * 2;
    }
    else
    {
        return HI_FALSE;
    }

    *pu32Width = u32Widht;
    *pu32Height = u32Height;

    return HI_TRUE;
}

/*
 * we make default link as follow:
 *      HD -> Mixer_1
 *      AD -> Mixer_2
 *      SD -> Mixer_3
 */
HI_BOOL HAL_VIDEO_LayerBindMixer(HAL_VIDEO_LAYER_E enLayer, HAL_MIXER_E enMixer)
{
    U_CBCFG                CBCFG;

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            /* VHD layer mixer link */
            CBCFG.u32 = pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr0 = HAL_MIXER_1;
            pVoReg->CBCFG.u32 = CBCFG.u32;
            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            /* VAD layer mixer link */
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr1 = HAL_MIXER_2;
            pVoReg->CBCFG.u32 = CBCFG.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}



/*****************************************************************************
 Prototype       : Graphics Surface Relative
 Description     :

*****************************************************************************/

HI_BOOL HAL_GRAPHIC_EnableLayer(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL bEnable)
{
    U_G0CTRL               G0CTRL;
    U_G1CTRL               G1CTRL;
    U_G2CTRL               G2CTRL;
    U_G3CTRL               G3CTRL;
    U_HCCTRL               HCCTRL;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CTRL.u32 =  pVoReg->G0CTRL.u32;
            G0CTRL.bits.g0_en = bEnable;
             pVoReg->G0CTRL.u32 = G0CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CTRL.u32 =  pVoReg->G1CTRL.u32;
            G1CTRL.bits.g1_en = bEnable;
             pVoReg->G1CTRL.u32 = G1CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CTRL.u32 =  pVoReg->G2CTRL.u32;
            G2CTRL.bits.g2_en = bEnable;
             pVoReg->G2CTRL.u32 = G2CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CTRL.u32 =  pVoReg->G3CTRL.u32;
            G3CTRL.bits.g3_en = bEnable;
             pVoReg->G3CTRL.u32 = G3CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCTRL.u32 =  pVoReg->HCCTRL.u32;
            HCCTRL.bits.hc_en = bEnable;
             pVoReg->HCCTRL.u32 = HCCTRL.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_GetLayerEnable(HAL_GRAPHIC_LAYER_E enLayer)
{
    U_G0CTRL               G0CTRL;
    U_G1CTRL               G1CTRL;
    U_G2CTRL               G2CTRL;
    U_G3CTRL               G3CTRL;
    U_HCCTRL               HCCTRL;

    HI_BOOL bEnable = HI_FALSE;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CTRL.u32 =  pVoReg->G0CTRL.u32;
            bEnable = G0CTRL.bits.g0_en;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CTRL.u32 =  pVoReg->G1CTRL.u32;
            bEnable = G1CTRL.bits.g1_en;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CTRL.u32 =  pVoReg->G2CTRL.u32;
            bEnable = G2CTRL.bits.g2_en;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CTRL.u32 =  pVoReg->G3CTRL.u32;
            bEnable = G3CTRL.bits.g3_en;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCTRL.u32 =  pVoReg->HCCTRL.u32;
            bEnable = HCCTRL.bits.hc_en;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return bEnable;
}

HI_BOOL HAL_GRAPHIC_SetLayerPixelFmt(HAL_GRAPHIC_LAYER_E enLayer, HAL_PIXEL_FORMAT_E enPixelFmt)
{
    U_G0CTRL               G0CTRL;
    U_G1CTRL               G1CTRL;
    U_G2CTRL               G2CTRL;
    U_G3CTRL               G3CTRL;
    U_HCCTRL               HCCTRL;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CTRL.u32 =  pVoReg->G0CTRL.u32;
            G0CTRL.bits.ifmt = enPixelFmt;
             pVoReg->G0CTRL.u32 = G0CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CTRL.u32 =  pVoReg->G1CTRL.u32;
            G1CTRL.bits.ifmt = enPixelFmt;
             pVoReg->G1CTRL.u32 = G1CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CTRL.u32 =  pVoReg->G2CTRL.u32;
            G2CTRL.bits.ifmt = enPixelFmt;
             pVoReg->G2CTRL.u32 = G2CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CTRL.u32 =  pVoReg->G3CTRL.u32;
            G3CTRL.bits.ifmt = enPixelFmt;
             pVoReg->G3CTRL.u32 = G3CTRL.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCTRL.u32 =  pVoReg->HCCTRL.u32;
            HCCTRL.bits.ifmt = enPixelFmt;
             pVoReg->HCCTRL.u32 = HCCTRL.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerAddr(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Addr)
{
    U_G0ADDR               G0ADDR;
    U_G1ADDR               G1ADDR;
    U_G2ADDR               G2ADDR;
    U_G3ADDR               G3ADDR;
    U_HCADDR               HCADDR;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0ADDR.u32 = u32Addr;
            pVoReg->G0ADDR.u32 = G0ADDR.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1ADDR.u32 = u32Addr;
            pVoReg->G1ADDR.u32 = G1ADDR.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2ADDR.u32 = u32Addr;
            pVoReg->G2ADDR.u32 = G2ADDR.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3ADDR.u32 = u32Addr;
            pVoReg->G3ADDR.u32 = G3ADDR.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCADDR.u32 = u32Addr;
            pVoReg->HCADDR.u32 = HCADDR.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerStride(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Stride)
{
    U_G0STRIDE             G0STRIDE;
    U_G1STRIDE             G1STRIDE;
    U_G2STRIDE             G2STRIDE;
    U_G3STRIDE             G3STRIDE;
    U_HCSTRIDE             HCSTRIDE;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0STRIDE.u32 = u32Stride;
            pVoReg->G0STRIDE.u32 = G0STRIDE.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1STRIDE.u32 = u32Stride;
            pVoReg->G1STRIDE.u32 = G1STRIDE.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2STRIDE.u32 = u32Stride;
            pVoReg->G2STRIDE.u32 =  G2STRIDE.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3STRIDE.u32 = u32Stride;
            pVoReg->G3STRIDE.u32 =  G3STRIDE.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCSTRIDE.u32 = u32Stride;
            pVoReg->HCSTRIDE.u32 =  HCSTRIDE.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}


HI_BOOL HAL_GRAPHIC_GetLayerStrideAlign(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 *pu32StrideAlign)
{
    *pu32StrideAlign = 16;

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerInReso(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Width, HI_U32 u32Height)
{
    U_G0IRESO              G0IRESO;
    U_G1IRESO              G1IRESO;
    U_G2IRESO              G2IRESO;
    U_G3IRESO              G3IRESO;
    U_HCIRESO              HCIRESO;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0IRESO.u32 =  pVoReg->G0IRESO.u32;
            G0IRESO.bits.iw = u32Width - 1;
            G0IRESO.bits.ih = u32Height - 1;
            pVoReg->G0IRESO.u32 = G0IRESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1IRESO.u32 =  pVoReg->G1IRESO.u32;
            G1IRESO.bits.iw = u32Width - 1;
            G1IRESO.bits.ih = u32Height - 1;
            pVoReg->G1IRESO.u32 = G1IRESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2IRESO.u32 =  pVoReg->G2IRESO.u32;
            G2IRESO.bits.iw = u32Width - 1;
            G2IRESO.bits.ih = u32Height - 1;
            pVoReg->G2IRESO.u32 = G2IRESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3IRESO.u32 =  pVoReg->G3IRESO.u32;
            G3IRESO.bits.iw = u32Width - 1;
            G3IRESO.bits.ih = u32Height - 1;
            pVoReg->G3IRESO.u32 = G3IRESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCIRESO.u32 =  pVoReg->HCIRESO.u32;
            HCIRESO.bits.iw = u32Width - 1;
            HCIRESO.bits.ih = u32Height - 1;
            pVoReg->HCIRESO.u32 = HCIRESO.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerOutReso(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Width, HI_U32 u32Height)
{
    U_G0ORESO              G0ORESO;
    U_G1ORESO              G1ORESO;
    U_G2ORESO              G2ORESO;
    U_G3ORESO              G3ORESO;
    U_HCORESO              HCORESO;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0ORESO.u32 =  pVoReg->G0ORESO.u32;
            G0ORESO.bits.ow = u32Width -1;
            G0ORESO.bits.oh = u32Height -1;
            pVoReg->G0ORESO.u32 = G0ORESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1ORESO.u32 =  pVoReg->G1ORESO.u32;
            G1ORESO.bits.ow = u32Width -1;
            G1ORESO.bits.oh = u32Height -1;
            pVoReg->G1ORESO.u32 = G1ORESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2ORESO.u32 =  pVoReg->G2ORESO.u32;
            G2ORESO.bits.ow = u32Width -1;
            G2ORESO.bits.oh = u32Height -1;
            pVoReg->G2ORESO.u32 = G2ORESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3ORESO.u32 =  pVoReg->G3ORESO.u32;
            G3ORESO.bits.ow = u32Width -1;
            G3ORESO.bits.oh = u32Height -1;
            pVoReg->G3ORESO.u32 = G3ORESO.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCORESO.u32 =  pVoReg->HCORESO.u32;
            HCORESO.bits.ow = u32Width -1;
            HCORESO.bits.oh = u32Height -1;
            pVoReg->HCORESO.u32 = HCORESO.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerSrcStart(HAL_GRAPHIC_LAYER_E enLayer, HI_S32 s32SX, HI_S32 s32SY)
{
    U_G0SFPOS              G0SFPOS;
    U_G1SFPOS              G1SFPOS;
    U_G2SFPOS              G2SFPOS;
    U_G3SFPOS              G3SFPOS;
    U_HCSFPOS              HCSFPOS;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0SFPOS.u32 =  pVoReg->G0SFPOS.u32;
            G0SFPOS.bits.src_xfpos = s32SX;
            G0SFPOS.bits.src_yfpos = s32SY;
            pVoReg->G0SFPOS.u32 = G0SFPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1SFPOS.u32 =  pVoReg->G1SFPOS.u32;
            G1SFPOS.bits.src_xfpos = s32SX;
            G1SFPOS.bits.src_yfpos = s32SY;
            pVoReg->G1SFPOS.u32 = G1SFPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2SFPOS.u32 =  pVoReg->G2SFPOS.u32;
            G2SFPOS.bits.src_xfpos = s32SX;
            G2SFPOS.bits.src_yfpos = s32SY;
            pVoReg->G2SFPOS.u32 = G2SFPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3SFPOS.u32 =  pVoReg->G3SFPOS.u32;
            G3SFPOS.bits.src_xfpos = s32SX;
            G3SFPOS.bits.src_yfpos = s32SY;
            pVoReg->G3SFPOS.u32 = G3SFPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCSFPOS.u32 =  pVoReg->HCSFPOS.u32;
            HCSFPOS.bits.src_xfpos = s32SX;
            HCSFPOS.bits.src_yfpos = s32SY;
            pVoReg->HCSFPOS.u32 = HCSFPOS.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerDispRect(HAL_GRAPHIC_LAYER_E enLayer, HAL_RECT_S stDispRect)
{
    U_G0DFPOS              G0DFPOS;
    U_G0DLPOS              G0DLPOS;
    U_G1DFPOS              G1DFPOS;
    U_G1DLPOS              G1DLPOS;
    U_G2DFPOS              G2DFPOS;
    U_G2DLPOS              G2DLPOS;
    U_G3DFPOS              G3DFPOS;
    U_G3DLPOS              G3DLPOS;
    U_HCDFPOS              HCDFPOS;
    U_HCDLPOS              HCDLPOS;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0DFPOS.u32 =  pVoReg->G0DFPOS.u32;
            G0DFPOS.bits.disp_xfpos = stDispRect.s32X;
            G0DFPOS.bits.disp_yfpos = stDispRect.s32Y;
            pVoReg->G0DFPOS.u32 = G0DFPOS.u32;

            G0DLPOS.u32 =  pVoReg->G0DLPOS.u32;
            G0DLPOS.bits.disp_xlpos = stDispRect.s32X + stDispRect.u32Width -1;
            G0DLPOS.bits.disp_ylpos = stDispRect.s32Y + stDispRect.u32Height -1;
            pVoReg->G0DLPOS.u32 = G0DLPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1DFPOS.u32 =  pVoReg->G1DFPOS.u32;
            G1DFPOS.bits.disp_xfpos = stDispRect.s32X;
            G1DFPOS.bits.disp_yfpos = stDispRect.s32Y;
            pVoReg->G1DFPOS.u32 = G1DFPOS.u32;

            G1DLPOS.u32 =  pVoReg->G1DLPOS.u32;
            G1DLPOS.bits.disp_xlpos = stDispRect.s32X + stDispRect.u32Width -1;
            G1DLPOS.bits.disp_ylpos = stDispRect.s32Y + stDispRect.u32Height -1;
            pVoReg->G1DLPOS.u32 = G1DLPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2DFPOS.u32 =  pVoReg->G2DFPOS.u32;
            G2DFPOS.bits.disp_xfpos = stDispRect.s32X;
            G2DFPOS.bits.disp_yfpos = stDispRect.s32Y;
            pVoReg->G2DFPOS.u32 = G2DFPOS.u32;

            G2DLPOS.u32 =  pVoReg->G2DLPOS.u32;
            G2DLPOS.bits.disp_xlpos = stDispRect.s32X + stDispRect.u32Width -1;
            G2DLPOS.bits.disp_ylpos = stDispRect.s32Y + stDispRect.u32Height -1;
            pVoReg->G2DLPOS.u32 = G2DLPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3DFPOS.u32 =  pVoReg->G3DFPOS.u32;
            G3DFPOS.bits.disp_xfpos = stDispRect.s32X;
            G3DFPOS.bits.disp_yfpos = stDispRect.s32Y;
            pVoReg->G3DFPOS.u32 = G3DFPOS.u32;

            G3DLPOS.u32 =  pVoReg->G3DLPOS.u32;
            G3DLPOS.bits.disp_xlpos = stDispRect.s32X + stDispRect.u32Width -1;
            G3DLPOS.bits.disp_ylpos = stDispRect.s32Y + stDispRect.u32Height -1;
            pVoReg->G3DLPOS.u32 = G3DLPOS.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCDFPOS.u32 =  pVoReg->HCDFPOS.u32;
            HCDFPOS.bits.disp_xfpos = stDispRect.s32X;
            HCDFPOS.bits.disp_yfpos = stDispRect.s32Y;
            pVoReg->HCDFPOS.u32 = HCDFPOS.u32;

            HCDLPOS.u32 =  pVoReg->HCDLPOS.u32;
            HCDLPOS.bits.disp_xlpos = stDispRect.s32X + stDispRect.u32Width -1;
            HCDLPOS.bits.disp_ylpos = stDispRect.s32Y + stDispRect.u32Height -1;
            pVoReg->HCDLPOS.u32 = HCDLPOS.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetRegUp(HAL_GRAPHIC_LAYER_E enLayer)
{
    U_G0UPD                G0UPD;
    U_G1UPD                G1UPD;
    U_G2UPD                G2UPD;
    U_G3UPD                G3UPD;
    U_HCUPD                HCUPD;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            /* G0 layer register update */
            G0UPD.bits.regup = 0x1;
            pVoReg->G0UPD.u32 = G0UPD.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            /* G1 layer register update */
            G1UPD.bits.regup = 0x1;
            pVoReg->G1UPD.u32 = G1UPD.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            /* G2 layer register update */
            G2UPD.bits.regup = 0x1;
            pVoReg->G2UPD.u32 = G2UPD.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            /* G3 layer register update */
            G3UPD.bits.regup = 0x1;
            pVoReg->G3UPD.u32 = G3UPD.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            /* HC layer register update */
            HCUPD.bits.regup = 0x1;
            pVoReg->HCUPD.u32 = HCUPD.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetCsc(HAL_GRAPHIC_LAYER_E enLayer,
                            HI_BOOL bCscEn,
                            HAL_CSC_MODE_E enMode)
{
    U_G0CTRL               G0CTRL;
    U_G1CTRL               G1CTRL;
    U_G2CTRL               G2CTRL;
    U_G3CTRL               G3CTRL;
    U_HCCTRL               HCCTRL;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CTRL.u32 =  pVoReg->G0CTRL.u32;
            G0CTRL.bits.csc_en = bCscEn;
            G0CTRL.bits.csc_mode = enMode;
            pVoReg->G0CTRL.u32 = G0CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CTRL.u32 =  pVoReg->G1CTRL.u32;
            G1CTRL.bits.csc_en = bCscEn;
            G1CTRL.bits.csc_mode = enMode;
            pVoReg->G1CTRL.u32 = G1CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CTRL.u32 =  pVoReg->G2CTRL.u32;
            G2CTRL.bits.csc_en = bCscEn;
            G2CTRL.bits.csc_mode = enMode;
            pVoReg->G2CTRL.u32 = G2CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CTRL.u32 =  pVoReg->G3CTRL.u32;
            G3CTRL.bits.csc_en = bCscEn;
            G3CTRL.bits.csc_mode = enMode;
            pVoReg->G3CTRL.u32 = G3CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCTRL.u32 =  pVoReg->HCCTRL.u32;
            HCCTRL.bits.csc_en = bCscEn;
            HCCTRL.bits.csc_mode = enMode;
            pVoReg->HCCTRL.u32 = HCCTRL.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetBitExt(HAL_GRAPHIC_LAYER_E enLayer,
                                HAL_GFX_BITEXTEND_E enMode)
{
    U_G0CTRL               G0CTRL;
    U_G1CTRL               G1CTRL;
    U_G2CTRL               G2CTRL;
    U_G3CTRL               G3CTRL;
    U_HCCTRL               HCCTRL;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CTRL.u32 =  pVoReg->G0CTRL.u32;
            G0CTRL.bits.bitext = enMode;
             pVoReg->G0CTRL.u32 = G0CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CTRL.u32 =  pVoReg->G1CTRL.u32;
            G1CTRL.bits.bitext = enMode;
             pVoReg->G1CTRL.u32 = G1CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CTRL.u32 =  pVoReg->G2CTRL.u32;
            G2CTRL.bits.bitext = enMode;
             pVoReg->G2CTRL.u32 = G2CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CTRL.u32 =  pVoReg->G3CTRL.u32;
            G3CTRL.bits.bitext = enMode;
             pVoReg->G3CTRL.u32 = G3CTRL.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCTRL.u32 =  pVoReg->HCCTRL.u32;
            HCCTRL.bits.bitext = enMode;
             pVoReg->HCCTRL.u32 = HCCTRL.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetPixelAlphaEnable(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL  bAlphaEn)
{
    U_G0CBMPARA            G0CBMPARA;
    U_G1CBMPARA            G1CBMPARA;
    U_G2CBMPARA            G2CBMPARA;
    U_G3CBMPARA            G3CBMPARA;
    U_HCCBMPARA            HCCBMPARA;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CBMPARA.u32 =  pVoReg->G0CBMPARA.u32;
            G0CBMPARA.bits.palpha_en = bAlphaEn;
             pVoReg->G0CBMPARA.u32 = G0CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CBMPARA.u32 =  pVoReg->G1CBMPARA.u32;
            G1CBMPARA.bits.palpha_en = bAlphaEn;
             pVoReg->G1CBMPARA.u32 = G1CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CBMPARA.u32 =  pVoReg->G2CBMPARA.u32;
            G2CBMPARA.bits.palpha_en = bAlphaEn;
             pVoReg->G2CBMPARA.u32 = G2CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CBMPARA.u32 =  pVoReg->G3CBMPARA.u32;
            G3CBMPARA.bits.palpha_en = bAlphaEn;
             pVoReg->G3CBMPARA.u32 = G3CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCBMPARA.u32 =  pVoReg->HCCBMPARA.u32;
            HCCBMPARA.bits.palpha_en = bAlphaEn;
             pVoReg->HCCBMPARA.u32 = HCCBMPARA.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetPixelAlpha(HAL_GRAPHIC_LAYER_E enLayer, HI_U8 u8Alpha0, HI_U8 u8Alpha1)
{
     U_G0CKEYMAX            G0CKEYMAX;
     U_G0CKEYMIN            G0CKEYMIN;

     U_G1CKEYMAX            G1CKEYMAX;
     U_G1CKEYMIN            G1CKEYMIN;

     U_G2CKEYMAX            G2CKEYMAX;
     U_G2CKEYMIN            G2CKEYMIN;

     U_G3CKEYMAX            G3CKEYMAX;
     U_G3CKEYMIN            G3CKEYMIN;

     U_HCCKEYMAX            HCCKEYMAX;
     U_HCCKEYMIN            HCCKEYMIN;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CKEYMAX.u32 = pVoReg->G0CKEYMAX.u32;
            G0CKEYMAX.bits.va0 = u8Alpha0;

            G0CKEYMIN.u32 = pVoReg->G0CKEYMIN.u32;
            G0CKEYMIN.bits.va1 = u8Alpha1;

            pVoReg->G0CKEYMAX.u32 = G0CKEYMAX.u32;
            pVoReg->G0CKEYMIN.u32 = G0CKEYMIN.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CKEYMAX.u32 = pVoReg->G1CKEYMAX.u32;
            G1CKEYMAX.bits.va0 = u8Alpha0;

            G1CKEYMIN.u32 = pVoReg->G1CKEYMIN.u32;
            G1CKEYMIN.bits.va1 = u8Alpha1;

            pVoReg->G1CKEYMAX.u32 = G1CKEYMAX.u32;
            pVoReg->G1CKEYMIN.u32 = G1CKEYMIN.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CKEYMAX.u32 = pVoReg->G2CKEYMAX.u32;
            G2CKEYMAX.bits.va0 = u8Alpha0;

            G2CKEYMIN.u32 = pVoReg->G2CKEYMIN.u32;
            G2CKEYMIN.bits.va1 = u8Alpha1;

            pVoReg->G2CKEYMAX.u32 = G2CKEYMAX.u32;
            pVoReg->G2CKEYMIN.u32 = G2CKEYMIN.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CKEYMAX.u32 = pVoReg->G3CKEYMAX.u32;
            G3CKEYMAX.bits.va0 = u8Alpha0;

            G3CKEYMIN.u32 = pVoReg->G3CKEYMIN.u32;
            G3CKEYMIN.bits.va1 = u8Alpha1;

            pVoReg->G3CKEYMAX.u32 = G3CKEYMAX.u32;
            pVoReg->G3CKEYMIN.u32 = G3CKEYMIN.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCKEYMAX.u32 = pVoReg->HCCKEYMAX.u32;
            HCCKEYMAX.bits.va0 = u8Alpha0;

            HCCKEYMIN.u32 = pVoReg->HCCKEYMIN.u32;
            HCCKEYMIN.bits.va1 = u8Alpha1;

            pVoReg->HCCKEYMAX.u32 = HCCKEYMAX.u32;
            pVoReg->HCCKEYMIN.u32 = HCCKEYMIN.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetAlphaMode(HAL_GRAPHIC_LAYER_E enLayer,
                                 HAL_GRAPHIC_ALPHA_ARANGE_E enArange)
{
    U_G0CBMPARA            G0CBMPARA;
    U_G1CBMPARA            G1CBMPARA;
    U_G2CBMPARA            G2CBMPARA;
    U_G3CBMPARA            G3CBMPARA;
    U_HCCBMPARA            HCCBMPARA;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CBMPARA.u32 =  pVoReg->G0CBMPARA.u32;
            G0CBMPARA.bits.palpha_range = enArange;
             pVoReg->G0CBMPARA.u32 = G0CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CBMPARA.u32 =  pVoReg->G1CBMPARA.u32;
            G1CBMPARA.bits.palpha_range = enArange;
             pVoReg->G1CBMPARA.u32 = G1CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CBMPARA.u32 =  pVoReg->G2CBMPARA.u32;
            G2CBMPARA.bits.palpha_range = enArange;
             pVoReg->G2CBMPARA.u32 = G2CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CBMPARA.u32 =  pVoReg->G3CBMPARA.u32;
            G3CBMPARA.bits.palpha_range = enArange;
             pVoReg->G3CBMPARA.u32 = G3CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCBMPARA.u32 =  pVoReg->HCCBMPARA.u32;
            HCCBMPARA.bits.palpha_range = enArange;
             pVoReg->HCCBMPARA.u32 = HCCBMPARA.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetLayerGalpha(HAL_GRAPHIC_LAYER_E enLayer, HI_U8 u8Alpha)
{
    U_G0CBMPARA            G0CBMPARA;
    U_G1CBMPARA            G1CBMPARA;
    U_G2CBMPARA            G2CBMPARA;
    U_G3CBMPARA            G3CBMPARA;
    U_HCCBMPARA            HCCBMPARA;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CBMPARA.u32 =  pVoReg->G0CBMPARA.u32;
            G0CBMPARA.bits.galpha = u8Alpha;
             pVoReg->G0CBMPARA.u32 = G0CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CBMPARA.u32 =  pVoReg->G1CBMPARA.u32;
            G1CBMPARA.bits.galpha = u8Alpha;
             pVoReg->G1CBMPARA.u32 = G1CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CBMPARA.u32 =  pVoReg->G2CBMPARA.u32;
            G2CBMPARA.bits.galpha = u8Alpha;
             pVoReg->G2CBMPARA.u32 = G2CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CBMPARA.u32 =  pVoReg->G3CBMPARA.u32;
            G3CBMPARA.bits.galpha = u8Alpha;
            pVoReg->G3CBMPARA.u32 = G3CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCBMPARA.u32 =  pVoReg->HCCBMPARA.u32;
            HCCBMPARA.bits.galpha = u8Alpha;
             pVoReg->HCCBMPARA.u32 = HCCBMPARA.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetColorKeyMode(HAL_GRAPHIC_LAYER_E enLayer,
                                    HAL_COLORKEY_MODE_E enMode)
{
    U_G0CBMPARA            G0CBMPARA;
    U_G1CBMPARA            G1CBMPARA;
    U_G2CBMPARA            G2CBMPARA;
    U_G3CBMPARA            G3CBMPARA;
    U_HCCBMPARA            HCCBMPARA;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CBMPARA.u32 = pVoReg->G0CBMPARA.u32;
            G0CBMPARA.bits.key_mode = enMode;
            pVoReg->G0CBMPARA.u32 = G0CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CBMPARA.u32 =  pVoReg->G1CBMPARA.u32;
            G1CBMPARA.bits.key_mode = enMode;
            pVoReg->G1CBMPARA.u32 = G1CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CBMPARA.u32 =  pVoReg->G2CBMPARA.u32;
            G2CBMPARA.bits.key_mode = enMode;
            pVoReg->G2CBMPARA.u32 = G2CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CBMPARA.u32 =  pVoReg->G3CBMPARA.u32;
            G3CBMPARA.bits.key_mode = enMode;
            pVoReg->G3CBMPARA.u32 = G3CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCBMPARA.u32 =  pVoReg->HCCBMPARA.u32;
            HCCBMPARA.bits.key_mode = enMode;
            pVoReg->HCCBMPARA.u32 = HCCBMPARA.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetColorKeyEnable(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL bkeyEn)
{
    U_G0CBMPARA            G0CBMPARA;
    U_G1CBMPARA            G1CBMPARA;
    U_G2CBMPARA            G2CBMPARA;
    U_G3CBMPARA            G3CBMPARA;
    U_HCCBMPARA            HCCBMPARA;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CBMPARA.u32 = pVoReg->G0CBMPARA.u32;
            G0CBMPARA.bits.key_en = bkeyEn;
            pVoReg->G0CBMPARA.u32 = G0CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CBMPARA.u32 =  pVoReg->G1CBMPARA.u32;
            G1CBMPARA.bits.key_en = bkeyEn;
            pVoReg->G1CBMPARA.u32 = G1CBMPARA.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CBMPARA.u32 =  pVoReg->G2CBMPARA.u32;
            G2CBMPARA.bits.key_en = bkeyEn;
            pVoReg->G2CBMPARA.u32 = G2CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CBMPARA.u32 =  pVoReg->G3CBMPARA.u32;
            G3CBMPARA.bits.key_en = bkeyEn;
            pVoReg->G3CBMPARA.u32 = G3CBMPARA.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCBMPARA.u32 =  pVoReg->HCCBMPARA.u32;
            HCCBMPARA.bits.key_en = bkeyEn;
            pVoReg->HCCBMPARA.u32 = HCCBMPARA.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_SetColorKeyValue(HAL_GRAPHIC_LAYER_E enLayer,HI_U32 u32Min, HI_U32 u32Max)
{
    U_G0CKEYMAX            G0CKEYMAX;
    U_G0CKEYMIN            G0CKEYMIN;

    U_G1CKEYMAX            G1CKEYMAX;
    U_G1CKEYMIN            G1CKEYMIN;

    U_G2CKEYMAX            G2CKEYMAX;
    U_G2CKEYMIN            G2CKEYMIN;

    U_G3CKEYMAX            G3CKEYMAX;
    U_G3CKEYMIN            G3CKEYMIN;

    U_HCCKEYMAX            HCCKEYMAX;
    U_HCCKEYMIN            HCCKEYMIN;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            G0CKEYMAX.u32 = pVoReg->G0CKEYMAX.u32;
            G0CKEYMIN.u32 = pVoReg->G0CKEYMIN.u32;

            G0CKEYMAX.bits.keyr_max = (u32Max>>16 & 0xff);
            G0CKEYMAX.bits.keyg_max = (u32Max>>8  & 0xff);
            G0CKEYMAX.bits.keyb_max = (u32Max     & 0xff);

            G0CKEYMIN.bits.keyr_min = (u32Min>>16 & 0xff);
            G0CKEYMIN.bits.keyg_min = (u32Min>>8  & 0xff);
            G0CKEYMIN.bits.keyb_min = (u32Min     & 0xff);

            pVoReg->G0CKEYMAX.u32 = G0CKEYMAX.u32;
            pVoReg->G0CKEYMIN.u32 = G0CKEYMIN.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            G1CKEYMAX.u32 = pVoReg->G1CKEYMAX.u32;
            G1CKEYMIN.u32 = pVoReg->G1CKEYMIN.u32;

            G1CKEYMAX.bits.keyr_max = (u32Max>>16 & 0xff);
            G1CKEYMAX.bits.keyg_max = (u32Max>>8  & 0xff);
            G1CKEYMAX.bits.keyb_max = (u32Max     & 0xff);

            G1CKEYMIN.bits.keyr_min = (u32Min>>16 & 0xff);
            G1CKEYMIN.bits.keyg_min = (u32Min>>8  & 0xff);
            G1CKEYMIN.bits.keyb_min = (u32Min     & 0xff);

            pVoReg->G1CKEYMAX.u32 = G1CKEYMAX.u32;
            pVoReg->G1CKEYMIN.u32 = G1CKEYMIN.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            G2CKEYMAX.u32 = pVoReg->G2CKEYMAX.u32;
            G2CKEYMIN.u32 = pVoReg->G2CKEYMIN.u32;

            G2CKEYMAX.bits.keyr_max = (u32Max>>16 & 0xff);
            G2CKEYMAX.bits.keyg_max = (u32Max>>8  & 0xff);
            G2CKEYMAX.bits.keyb_max = (u32Max     & 0xff);

            G2CKEYMIN.bits.keyr_min = (u32Min>>16 & 0xff);
            G2CKEYMIN.bits.keyg_min = (u32Min>>8  & 0xff);
            G2CKEYMIN.bits.keyb_min = (u32Min     & 0xff);

            pVoReg->G2CKEYMAX.u32 = G2CKEYMAX.u32;
            pVoReg->G2CKEYMIN.u32 = G2CKEYMIN.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            G3CKEYMAX.u32 = pVoReg->G3CKEYMAX.u32;
            G3CKEYMIN.u32 = pVoReg->G3CKEYMIN.u32;

            G3CKEYMAX.bits.keyr_max = (u32Max>>16 & 0xff);
            G3CKEYMAX.bits.keyg_max = (u32Max>>8  & 0xff);
            G3CKEYMAX.bits.keyb_max = (u32Max     & 0xff);

            G3CKEYMIN.bits.keyr_min = (u32Min>>16 & 0xff);
            G3CKEYMIN.bits.keyg_min = (u32Min>>8  & 0xff);
            G3CKEYMIN.bits.keyb_min = (u32Min     & 0xff);

            pVoReg->G3CKEYMAX.u32 = G3CKEYMAX.u32;
            pVoReg->G3CKEYMIN.u32 = G3CKEYMIN.u32;

            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            HCCKEYMAX.u32 = pVoReg->HCCKEYMAX.u32;
            HCCKEYMIN.u32 = pVoReg->HCCKEYMIN.u32;

            HCCKEYMAX.bits.keyr_max = (u32Max>>16 & 0xff);
            HCCKEYMAX.bits.keyg_max = (u32Max>>8  & 0xff);
            HCCKEYMAX.bits.keyb_max = (u32Max     & 0xff);

            HCCKEYMIN.bits.keyr_min = (u32Min>>16 & 0xff);
            HCCKEYMIN.bits.keyg_min = (u32Min>>8  & 0xff);
            HCCKEYMIN.bits.keyb_min = (u32Min     & 0xff);

            pVoReg->HCCKEYMAX.u32 = HCCKEYMAX.u32;
            pVoReg->HCCKEYMIN.u32 = HCCKEYMIN.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

/*
 * we make default link as follow:
 *      G0 -> Mixer_1
 *      G3 -> Mixer_3
 */
HI_BOOL HAL_GRAPHIC_LayerBindMixer(HAL_GRAPHIC_LAYER_E enLayer, HAL_MIXER_E enMixer)
{
    U_CBCFG                CBCFG;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            /* G0 layer mixer link */
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr2 = HAL_MIXER_1;
            pVoReg->CBCFG.u32 = CBCFG.u32;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            /* G1 layer mixer link */
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr3 = enMixer;
            pVoReg->CBCFG.u32 = CBCFG.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            /* G2 layer mixer link */
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr4 = enMixer;
            pVoReg->CBCFG.u32 = CBCFG.u32;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            /* HC layer mixer link */
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.sur_attr5 = enMixer;
            pVoReg->CBCFG.u32 = CBCFG.u32;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GRAPHIC_LayerGetBindMixer(HAL_GRAPHIC_LAYER_E enLayer, HAL_MIXER_E *penMixer)
{
    U_CBCFG                CBCFG;

    CBCFG.u32 =  pVoReg->CBCFG.u32;

    switch(enLayer)
    {
        case HAL_GRAPHIC_LAYER_G0:
        {
            /* G0 layer mixer link mixer1 */
            *penMixer = HAL_MIXER_1;
            break;
        }
        case HAL_GRAPHIC_LAYER_G1:
        {
            /* G1 layer mixer link which? */
            if (CBCFG.u32 & 0x08000000)
            {
                *penMixer = HAL_MIXER_2;
            }
            else
            {
                *penMixer = HAL_MIXER_1;
            }
            break;
        }
        case HAL_GRAPHIC_LAYER_G2:
        {
            /* G2 layer mixer link mixer2 */
            *penMixer = HAL_MIXER_2;
            break;
        }
        case HAL_GRAPHIC_LAYER_G3:
        {
            /* G2 layer mixer link mixer3 */
            *penMixer = HAL_MIXER_3;
            break;
        }
        case HAL_GRAPHIC_LAYER_HC:
        {
            /* HC layer mixer link which? */
            if (CBCFG.u32 & 0x20000000)
            {
                *penMixer = HAL_MIXER_2;
            }
            else
            {
                *penMixer = HAL_MIXER_1;
            }
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}


/*****************************************************************************
 Prototype       : Interrrupt Relative
 Description     :

*****************************************************************************/

HI_BOOL HAL_DISP_SetIntMask(HI_U32 u32MaskEn)
{
    U_VOINTMSK             VOINTMSK;

    /* Dispaly interrupt mask enable */
    VOINTMSK.u32 =  pVoReg->VOINTMSK.u32;
    VOINTMSK.u32 = VOINTMSK.u32 | u32MaskEn;
    pVoReg->VOINTMSK.u32 = VOINTMSK.u32;

    return HI_TRUE;
}

HI_BOOL HAL_DISP_ClrIntMask(HI_U32 u32MaskEn)
{
    U_VOINTMSK             VOINTMSK;

    /* Dispaly interrupt mask disable */
    VOINTMSK.u32 =  pVoReg->VOINTMSK.u32;
    VOINTMSK.u32 = VOINTMSK.u32 & (~u32MaskEn);
     pVoReg->VOINTMSK.u32 = VOINTMSK.u32;

    return HI_TRUE;
}

HI_BOOL HAL_DISP_SetVTThd(HAL_DISP_CHANNEL_E enLayer, HI_U16 u16Thd)
{
    U_DHDVTTHD             DHDVTTHD;
    U_DADVTTHD             DADVTTHD;
    U_DSDVTTHD             DSDVTTHD;

    /* set VHD blank end threshold */
    if(enLayer == HAL_DISP_CHANNEL_DHD)
    {
        DHDVTTHD.u32 =  pVoReg->DHDVTTHD.u32;
        DHDVTTHD.bits.vtmgthd = u16Thd;
        pVoReg->DHDVTTHD.u32 = DHDVTTHD.u32;
    }
    else if(enLayer == HAL_DISP_CHANNEL_DAD)
    {
        DADVTTHD.u32 =  pVoReg->DADVTTHD.u32;
        DADVTTHD.bits.vtmgthd = u16Thd;
        pVoReg->DADVTTHD.u32 = DADVTTHD.u32;
    }
    else if(enLayer == HAL_DISP_CHANNEL_DSD)
    {
        DSDVTTHD.u32 =  pVoReg->DSDVTTHD.u32;
        DSDVTTHD.bits.vtmgthd = u16Thd;
        pVoReg->DSDVTTHD.u32 = DSDVTTHD.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_SetVTThdMode(HAL_DISP_CHANNEL_E enLayer, HAL_UPDATE_MODE_E enMode)
{
    U_DHDVTTHD             DHDVTTHD;
    U_DADVTTHD             DADVTTHD;
    U_DSDVTTHD             DSDVTTHD;

    /* set VHD blank end threshold */
    if(enLayer == HAL_DISP_CHANNEL_DHD)
    {
        DHDVTTHD.u32 =  pVoReg->DHDVTTHD.u32;
        DHDVTTHD.bits.thd_mode = enMode;
        pVoReg->DHDVTTHD.u32 = DHDVTTHD.u32;
    }
    else if(enLayer == HAL_DISP_CHANNEL_DAD)
    {
        DADVTTHD.u32 =  pVoReg->DADVTTHD.u32;
        DADVTTHD.bits.thd_mode = enMode;
        pVoReg->DADVTTHD.u32 = DADVTTHD.u32;
    }
    else if(enLayer == HAL_DISP_CHANNEL_DSD)
    {
        DSDVTTHD.u32 =  pVoReg->DSDVTTHD.u32;
        DSDVTTHD.bits.thd_mode = enMode;
        pVoReg->DSDVTTHD.u32 = DSDVTTHD.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_DISP_ClrIntStatus(HI_U32 u32IntMsk)
{
    U_VOINTSTA             VOINTSTA;

    /* read interrupt status */
    VOINTSTA.u32 =  pVoReg->VOINTSTA.u32;
    VOINTSTA.u32 = VOINTSTA.u32 & u32IntMsk;
    pVoReg->VOINTSTA.u32 = u32IntMsk;

    return HI_TRUE;
}

HI_BOOL HAL_DISP_GetCertainIntStatus(HI_U32 u32IntMsk)
{
    U_VOINTSTA             VOINTSTA;
    VOINTSTA.u32 = pVoReg->VOINTSTA.u32;
    VOINTSTA.u32 = VOINTSTA.u32 & u32IntMsk;

    if (VOINTSTA.u32 == u32IntMsk)
    {
        return HI_TRUE;
    }
    else
    {
        return HI_FALSE;
    }
}

HI_U32 HAL_DISP_GetIntStatus(HI_VOID)
{
    /* read interrupt status */
    return pVoReg->VOINTSTA.u32;
}

HI_BOOL HAL_DISP_GetIntField(HAL_DISP_CHANNEL_E enLayer)
{
    U_DHDSTATE             DHDSTATE;
    U_DHDSTATE             DADSTATE;
    U_DHDSTATE             DSDSTATE;

    HI_BOOL bBottom = HI_FALSE;

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            DHDSTATE.u32 =  pVoReg->DHDSTATE.u32;
            bBottom = DHDSTATE.bits.bottom_field;
            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            DADSTATE.u32 =  pVoReg->DADSTATE.u32;
            bBottom = DADSTATE.bits.bottom_field;
            break;
        }
        case HAL_VIDEO_LAYER_SD:
        {
            DSDSTATE.u32 =  pVoReg->DSDSTATE.u32;
            bBottom = DSDSTATE.bits.bottom_field;
            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return bBottom;
}

/*****************************************************************************
 Prototype       : Mixer Relative
 Description     :

*****************************************************************************/

/*
 * priority lader:  0(low) ~ 4(high)
 */
HI_BOOL HAL_CMB_SetMixerPriority(HAL_MXIER_LAYER_E enLayer, HAL_MIXER_PRIO_E enPrio)
{
    U_CBCFG                CBCFG;

    /* SD and G3 priority settings                                          */
    if (HAL_MXIER_LAYER_G3 == enLayer || HAL_MXIER_LAYER_SD == enLayer)
    {
        CBCFG.u32 =  pVoReg->CBCFG.u32;
        CBCFG.bits.mixer3_prio = enPrio;
        pVoReg->CBCFG.u32 = CBCFG.u32;

        return HI_TRUE;
    }

    switch(enPrio)
    {
        case 0:
        {
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.mixer_prio0 = enLayer;
            pVoReg->CBCFG.u32 = CBCFG.u32;

            break;
        }
        case 1:
        {
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.mixer_prio1 = enLayer;
            pVoReg->CBCFG.u32 = CBCFG.u32;

            break;
        }
        case 2:
        {
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.mixer_prio2 = enLayer;
            pVoReg->CBCFG.u32 = CBCFG.u32;

            break;
        }
        case 3:
        {
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.mixer_prio3 = enLayer;
            pVoReg->CBCFG.u32 = CBCFG.u32;

            break;
        }
        case 4:
        {
            CBCFG.u32 =  pVoReg->CBCFG.u32;
            CBCFG.bits.mixer_prio4 = enLayer;
            pVoReg->CBCFG.u32 = CBCFG.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }
    return HI_TRUE;
}

HI_BOOL HAL_CMB_SetMixer3Priority(HAL_MXIER_LAYER_E enLayer, HI_BOOL bVdoGfx)
{
    U_CBCFG                CBCFG;

    CBCFG.u32 = pVoReg->CBCFG.u32;
    CBCFG.bits.mixer3_prio = bVdoGfx;
    pVoReg->CBCFG.u32 = CBCFG.u32;

    return HI_TRUE;
}

HI_BOOL HAL_CMB_SetMixerBackGroud(HAL_MIXER_E enMixer, HI_U32 u32BkGrd)
{
    if(HAL_MIXER_1 == enMixer)
    {
        pVoReg->CBMBKG1.u32 = u32BkGrd;
    }
    else if (HAL_MIXER_2 == enMixer)
    {
        pVoReg->CBMBKG2.u32 = u32BkGrd;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}

HI_BOOL HAL_CMB_SetMixerBackGroudByYuv(HAL_MIXER_E enMixer, HAL_DISP_BKCOLOR_S stBkg)
{
    U_CBMBKG1              CBMBKG1;
    U_CBMBKG2              CBMBKG2;

    if(HAL_MIXER_1 == enMixer)
    {
        /* HC layer mixer link */
        CBMBKG1.u32 =  pVoReg->CBMBKG1.u32;
        CBMBKG1.bits.cbm_bkgy1 = stBkg.u8Bkg_y;
        CBMBKG1.bits.cbm_bkgcb1 = stBkg.u8Bkg_cb;
        CBMBKG1.bits.cbm_bkgcr1 = stBkg.u8Bkg_cr;
        pVoReg->CBMBKG1.u32 = CBMBKG1.u32;
    }
    else if (HAL_MIXER_2 == enMixer)
    {
        /* HC layer mixer link */
        CBMBKG2.u32 =  pVoReg->CBMBKG2.u32;
        CBMBKG2.bits.cbm_bkgy2 = stBkg.u8Bkg_y;
        CBMBKG2.bits.cbm_bkgcb2 = stBkg.u8Bkg_cb;
        CBMBKG2.bits.cbm_bkgcr2 = stBkg.u8Bkg_cr;
        pVoReg->CBMBKG2.u32 = CBMBKG2.u32;
    }
    else
    {
        return HI_FALSE;
    }

    return HI_TRUE;
}




/*****************************************************************************
 Prototype       : Gamma Relative
 Description     :

*****************************************************************************/

HI_BOOL HAL_GAMMA_SetGmmThd(HAL_VIDEO_LAYER_E enLayer)
{
    U_GMMTHD1              DHDGMMTHD1;
    U_GMMTHD2              DHDGMMTHD2;
    U_GMMTHD1              DADGMMTHD1;
    U_GMMTHD2              DADGMMTHD2;

    GMMTHD_S stGmmThd =
    {
        .gmm_multi     = 50,
        .thd_med_high  = 740,
        .thd_med_low   = 280,
        .thd_high      = 620,
        .thd_low       = 400,
    };

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            DHDGMMTHD2.bits.gmm_multiple = stGmmThd.gmm_multi   ;
            DHDGMMTHD2.bits.thd_med_high = stGmmThd.thd_med_high;
            DHDGMMTHD2.bits.Reserved_0   = 0;
            DHDGMMTHD1.bits.thd_med_low  = stGmmThd.thd_med_low ;
            DHDGMMTHD1.bits.thd_high     = stGmmThd.thd_high    ;
            DHDGMMTHD1.bits.thd_low      = stGmmThd.thd_low     ;
            DHDGMMTHD1.bits.Reserved_0   = 0;
            pVoReg->DHDGMMTHD2.u32 = DHDGMMTHD2.u32;
            pVoReg->DHDGMMTHD1.u32 = DHDGMMTHD1.u32;

            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            DADGMMTHD2.bits.gmm_multiple = stGmmThd.gmm_multi   ;
            DADGMMTHD2.bits.thd_med_high = stGmmThd.thd_med_high;
            DADGMMTHD2.bits.Reserved_0   = 0;
            DADGMMTHD1.bits.thd_med_low  = stGmmThd.thd_med_low ;
            DADGMMTHD1.bits.thd_high     = stGmmThd.thd_high    ;
            DADGMMTHD1.bits.thd_low      = stGmmThd.thd_low     ;
            DADGMMTHD1.bits.Reserved_0   = 0;
            pVoReg->DADGMMTHD2.u32 = DADGMMTHD2.u32;
            pVoReg->DADGMMTHD1.u32 = DADGMMTHD1.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GAMMA_SetGmmTable(HAL_VIDEO_LAYER_E enLayer)
{
    U_GMMTABLEn            DHDGMMLOWn[3] ;
    U_GMMTABLEn            DHDGMMMEDn[3] ;
    U_GMMTABLEn            DHDGMMHIGHn[3];
    U_GMMTABLEn            DHDGMMMLn[3]  ;
    U_GMMTABLEn            DHDGMMMHn[3]  ;

    U_GMMTABLEn            DADGMMLOWn[3] ;
    U_GMMTABLEn            DADGMMMEDn[3] ;
    U_GMMTABLEn            DADGMMHIGHn[3];
    U_GMMTABLEn            DADGMMMLn[3]  ;
    U_GMMTABLEn            DADGMMMHn[3]  ;

#if 1   /* fanjinguo provide */
    static HI_U32 upTable[8][9] =
                                  {  {0, 112,224, 360, 552, 752, 864, 944, 1023},
    				                 {0, 68, 156, 288, 480, 668, 828, 936, 1023},
    				                 {0, 36, 120, 240, 384, 532, 696, 852, 1023},
    				                 {0, 88, 188, 324, 480, 668, 828, 936, 1023},
    				                 {0, 68, 156, 288, 480, 680, 840, 892, 1023},
    				                 {0, 0,  0,   0,  0, 1023, 1023, 1023, 1023},
    				                 {0, 68, 68,  196, 480, 600, 748, 876, 1023},
    				                 {0, 55, 255, 383, 483, 639, 709, 863, 1023}
    							  };
#else   /* fuleisan provide */
    static HI_U32 upTable[8][9] =
                                  {
    				                 {0, 68, 156, 288, 480, 668, 828, 936, 1023},
    				                 {0, 36, 120, 240, 384, 532, 696, 852, 1023},
    				                 {0, 88, 188, 324, 480, 668, 828, 936, 1023},
    				                 {0, 68, 156, 288, 480, 680, 840, 892, 1023},
    				                 {0, 0,  0,   0,  0, 1023, 1023, 1023, 1023},
    				                 {0, 68, 68,  196, 480, 600, 748, 876, 1023},
    				                 {0, 55, 255, 383, 483, 639, 709, 863, 1023},
                                     {0, 112,224, 360, 552, 752, 864, 944, 1023}
    							  };


#endif

    HI_U32 ii = 0;

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            for (ii = 0; ii < 3; ii++)
            {
                DHDGMMLOWn[ii].bits.table_data1n = upTable[0][0 + ii*3];
                DHDGMMLOWn[ii].bits.table_data2n = upTable[0][1 + ii*3];
                DHDGMMLOWn[ii].bits.table_data3n = upTable[0][2 + ii*3];
                DHDGMMLOWn[ii].bits.Reserved_0   = 0;
                 pVoReg->DHDGMMLOWn[ii].u32 = DHDGMMLOWn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DHDGMMMEDn[ii].bits.table_data1n = upTable[1][0 + ii*3];
                DHDGMMMEDn[ii].bits.table_data2n = upTable[1][1 + ii*3];
                DHDGMMMEDn[ii].bits.table_data3n = upTable[1][2 + ii*3];
                DHDGMMMEDn[ii].bits.Reserved_0   = 0;
                 pVoReg->DHDGMMMEDn[ii].u32 = DHDGMMMEDn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DHDGMMHIGHn[ii].bits.table_data1n = upTable[2][0 + ii*3];
                DHDGMMHIGHn[ii].bits.table_data2n = upTable[2][1 + ii*3];
                DHDGMMHIGHn[ii].bits.table_data3n = upTable[2][2 + ii*3];
                DHDGMMHIGHn[ii].bits.Reserved_0   = 0;
                 pVoReg->DHDGMMHIGHn[ii].u32 = DHDGMMHIGHn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DHDGMMMLn[ii].bits.table_data1n = upTable[3][0 + ii*3];
                DHDGMMMLn[ii].bits.table_data2n = upTable[3][1 + ii*3];
                DHDGMMMLn[ii].bits.table_data3n = upTable[3][2 + ii*3];
                DHDGMMMLn[ii].bits.Reserved_0   = 0;
                 pVoReg->DHDGMMMLn[ii].u32 = DHDGMMMLn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DHDGMMMHn[ii].bits.table_data1n = upTable[4][0 + ii*3];
                DHDGMMMHn[ii].bits.table_data2n = upTable[4][1 + ii*3];
                DHDGMMMHn[ii].bits.table_data3n = upTable[4][2 + ii*3];
                DHDGMMMHn[ii].bits.Reserved_0   = 0;
                 pVoReg->DHDGMMMHn[ii].u32 = DHDGMMMHn[ii].u32;
            }

            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            for (ii = 0; ii < 3; ii++)
            {
                DADGMMLOWn[ii].bits.table_data1n = upTable[0][0 + ii*3];
                DADGMMLOWn[ii].bits.table_data2n = upTable[0][1 + ii*3];
                DADGMMLOWn[ii].bits.table_data3n = upTable[0][2 + ii*3];
                 pVoReg->DADGMMLOWn[ii].u32 = DADGMMLOWn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DADGMMMEDn[ii].bits.table_data1n = upTable[1][0 + ii*3];
                DADGMMMEDn[ii].bits.table_data2n = upTable[1][1 + ii*3];
                DADGMMMEDn[ii].bits.table_data3n = upTable[1][2 + ii*3];
                 pVoReg->DADGMMMEDn[ii].u32 = DADGMMMEDn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DADGMMHIGHn[ii].bits.table_data1n = upTable[2][0 + ii*3];
                DADGMMHIGHn[ii].bits.table_data2n = upTable[2][1 + ii*3];
                DADGMMHIGHn[ii].bits.table_data3n = upTable[2][2 + ii*3];
                 pVoReg->DADGMMHIGHn[ii].u32 = DADGMMHIGHn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DADGMMMLn[ii].bits.table_data1n = upTable[3][0 + ii*3];
                DADGMMMLn[ii].bits.table_data2n = upTable[3][1 + ii*3];
                DADGMMMLn[ii].bits.table_data3n = upTable[3][2 + ii*3];
                 pVoReg->DADGMMMLn[ii].u32 = DADGMMMLn[ii].u32;
            }

            for (ii = 0; ii < 3; ii++)
            {
                DADGMMMHn[ii].bits.table_data1n = upTable[4][0 + ii*3];
                DADGMMMHn[ii].bits.table_data2n = upTable[4][1 + ii*3];
                DADGMMMHn[ii].bits.table_data3n = upTable[4][2 + ii*3];
                 pVoReg->DADGMMMHn[ii].u32 = DADGMMMHn[ii].u32;
            }

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_GAMMA_GmmCtrl(HAL_VIDEO_LAYER_E enLayer, HI_U32 uGmmEn, HI_U32 uGmmMode)
{
    U_DHDCTRL              DHDCTRL;
    U_DADCTRL              DADCTRL;

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            DHDCTRL.u32 =  pVoReg->DHDCTRL.u32;
            DHDCTRL.bits.gmmen   = uGmmEn  ;
            DHDCTRL.bits.gmmmode = uGmmMode;
            pVoReg->DHDCTRL.u32 = DHDCTRL.u32;

            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            DADCTRL.u32 =  pVoReg->DADCTRL.u32;
            DADCTRL.bits.gmmen   = uGmmEn  ;
            DADCTRL.bits.gmmmode = uGmmMode;
            pVoReg->DADCTRL.u32 = DADCTRL.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

HI_BOOL HAL_ACC_SetAccAddr(HAL_VIDEO_LAYER_E enLayer, HI_U32 uAccAddr)
{
    U_ACCAD                DHDACCAD;
    U_ACCAD                DADACCAD;

    switch(enLayer)
    {
        case HAL_VIDEO_LAYER_HD:
        {
            DHDACCAD.u32 = pVoReg->DHDACCAD.u32;
            DHDACCAD.bits.coef_addr = uAccAddr;
            pVoReg->DHDACCAD.u32 = DHDACCAD.u32;

            break;
        }
        case HAL_VIDEO_LAYER_AD:
        {
            DADACCAD.u32 = pVoReg->DADACCAD.u32;
            DADACCAD.bits.coef_addr = uAccAddr;
            pVoReg->DADACCAD.u32 = DADACCAD.u32;

            break;
        }
        default:
        {
            return HI_FALSE;
        }
    }

    return HI_TRUE;
}

/*****************************************************************************
 Prototype       : DATE Relative
 Description     : Digitalized Analog TV Encoder(ֻģźű)
 Attention       :

    DateĴĶдVOUECOԭҪ⴦DateĶдȷDateõֵ
    дһDateַĴͶһDateַĴֵΪ˵ȷĴ̡

    дDateĴ£
    1	Write  addr_date_xxx
    2	Wait 50nsHDDATE/150nsADDATESDDATE
    3	Read  0x2013000c
    ϵΪһDateַд

    DateĴ£
    1	Read  addr_date_xxxʱֵȷֵ
    2	Wait״̬50nsHDDATE/150nsADDATESDDATE
    3	Read  addr_date_xxxʱֵȷֵ
    4	Read  0x2013000c
    ϵĸΪһDateַд


*****************************************************************************/

#ifdef __LINUX_OS__
#define HD_DELAY    (ndelay(200))
#define AS_DELAY    (ndelay(100))
#else
#define HD_DELAY    (udelay(2))
#define AS_DELAY    (udelay(1))
#endif

HI_U32 g_u32Version = 0;

#define HAL_DATE_READ_VERSION (g_u32Version = pVoReg->VOUVERSION1)

HI_BOOL HAL_DATE_Enable(HAL_DISP_CHANNEL_E enChan, HI_BOOL bEnable)
{
    U_HDATE_EN             HDATE_EN;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        //HDATE_EN.u32 = pVoReg->HDATE_EN.u32;
        HDATE_EN.bits.hd_en = bEnable;
        HDATE_EN.bits.Reserved_0 = 0;
        pVoReg->HDATE_EN.u32 = HDATE_EN.u32;

        HD_DELAY;
    }
    else
    {
        return HI_FALSE;
    }

    HAL_DATE_READ_VERSION;

    return HI_TRUE;
}

HI_BOOL HAL_DATE_PolaCtrl(HAL_DISP_CHANNEL_E enChan)
{
    U_HDATE_POLA_CTRL      HDATE_POLA_CTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        #if 0
        HDATE_POLA_CTRL.u32 = pVoReg->HDATE_POLA_CTRL.u32;
        HD_DELAY;
        HDATE_POLA_CTRL.u32 = pVoReg->HDATE_POLA_CTRL.u32;
        HAL_DATE_READ_VERSION;
        #endif

        HDATE_POLA_CTRL.u32 = 0x0;
        HDATE_POLA_CTRL.bits.hsync_in_pola = HI_TRUE;   // 1HD_DATEͬΪԣ0ͬͷ
        HDATE_POLA_CTRL.bits.vsync_in_pola = HI_TRUE;   // 1HD_DATEĳͬΪԣ0ͬͷ
        pVoReg->HDATE_POLA_CTRL.u32 = HDATE_POLA_CTRL.u32;

        HD_DELAY;
    }
    else
    {
        return HI_FALSE;
    }

    HAL_DATE_READ_VERSION;

    return HI_TRUE;
}

HI_BOOL HAL_DATE_VideoFmt(HAL_DISP_CHANNEL_E enChan, U_HDATE_VIDEO_FORMAT VFormat)
{
    U_HDATE_VIDEO_FORMAT   HDATE_VIDEO_FORMAT;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        #if 0
        HDATE_VIDEO_FORMAT.u32 = pVoReg->HDATE_VIDEO_FORMAT.u32;
        #endif

        HDATE_VIDEO_FORMAT.u32 = 0x0;
        HDATE_VIDEO_FORMAT.bits.video_ft        = VFormat.bits.video_ft;
        HDATE_VIDEO_FORMAT.bits.sync_add_ctrl   = VFormat.bits.sync_add_ctrl;
        HDATE_VIDEO_FORMAT.bits.video_out_ctrl  = VFormat.bits.video_out_ctrl;
        HDATE_VIDEO_FORMAT.bits.csc_ctrl        = VFormat.bits.csc_ctrl;

        pVoReg->HDATE_VIDEO_FORMAT.u32 = HDATE_VIDEO_FORMAT.u32;

        HD_DELAY;
    }
    else
    {
        return HI_FALSE;
    }

    HAL_DATE_READ_VERSION;

    return HI_TRUE;
}

HI_BOOL HAL_DATE_OutCtrl(HAL_DISP_CHANNEL_E enChan, U_HDATE_OUT_CTRL OutCtrl)
{
    U_HDATE_OUT_CTRL       HDATE_OUT_CTRL;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        #if 0
        HDATE_OUT_CTRL.u32 = pVoReg->HDATE_OUT_CTRL.u32;
        #endif

        HDATE_OUT_CTRL.u32 = 0x0;
        HDATE_OUT_CTRL.bits.vsync_sel   = OutCtrl.bits.vsync_sel;
        HDATE_OUT_CTRL.bits.hsync_sel   = OutCtrl.bits.hsync_sel;
        HDATE_OUT_CTRL.bits.video3_sel  = OutCtrl.bits.video3_sel;
        HDATE_OUT_CTRL.bits.video2_sel  = OutCtrl.bits.video2_sel;
        HDATE_OUT_CTRL.bits.video1_sel  = OutCtrl.bits.video1_sel;
        HDATE_OUT_CTRL.bits.src_ctrl    = OutCtrl.bits.src_ctrl;
        HDATE_OUT_CTRL.bits.sync_lpf_en = OutCtrl.bits.sync_lpf_en;
        HDATE_OUT_CTRL.bits.sd_sel      = OutCtrl.bits.sd_sel;

        pVoReg->HDATE_OUT_CTRL.u32 = HDATE_OUT_CTRL.u32;

        HD_DELAY;
    }
    else
    {
        return HI_FALSE;
    }

    HAL_DATE_READ_VERSION;

    return HI_TRUE;
}

/*****************************************************************************
 Prototype       : HAL_DATE_SetNorm
 Description     : CVBS DATE CONFIG
                   DATEĴڽоƬ˵ECOԸüĴܶд
                   ֱд룬дҪ50nsʱٶһ°汾Ĵ
                   ÿζдҪ״̬ʱа汾ĴĶС
 Input           : enChan  **
                   enNorm  **
 Output          : None
 Return Value    :
 Global Variable
    Read Only    :
    Read & Write :
  History
  1.Date         : 2009/7/28
    Author       : x00100808
    Modification : Created function

*****************************************************************************/
HI_BOOL HAL_DATE_SetNorm(HAL_DISP_CHANNEL_E enChan, HAL_DISP_NORM_E enNorm)
{
    U_ADATE_NORM            ADATE_NORM;
    U_SDATE_NORM            SDATE_NORM;

    if(enChan == HAL_DISP_CHANNEL_DHD)
    {
        // VOU VHD DATE
        // HD_DELAY;
    }
    else if(enChan == HAL_DISP_CHANNEL_DAD)
    {
        //VOU VAD CHANNEL DATE
        //ADATE_NORM.u32 = pVoReg->ADATE_NORM.u32;
        if (HAL_DISP_NORM_NTSC == enNorm)
        {
            ADATE_NORM.u32 = 0x308440dc;    //0x308440fc    رݲֹһӰĳ
        }
        else
        {
            #if 0
            ADATE_NORM.u32 = 0x528440dc;    //0x528440fc
            #else
            /* XuCong ֵҪCVBS dacͼҪCSCʹһʹ 20090814 */
            ADATE_NORM.u32 = 0x638414dc;
            #endif
        }
        pVoReg->ADATE_NORM.u32 = ADATE_NORM.u32;

        AS_DELAY;
    }
    else if(enChan == HAL_DISP_CHANNEL_DSD)
    {
        //VOU VSD CHANNEL DATE
        //SDATE_NORM.u32 = pVoReg->SDATE_NORM.u32;
        if (HAL_DISP_NORM_NTSC == enNorm)
        {
            SDATE_NORM.u32 = 0x308440dc;    //0x308440fc    رݲֹһӰĳ
        }
        else
        {
            #if 0
            SDATE_NORM.u32 = 0x528440dc;
            #else
            /* XuCong ֵҪCVBS dacͼҪCSCʹһʹ 20090814 */
            SDATE_NORM.u32 = 0x638414dc;
            #endif
        }
        pVoReg->SDATE_NORM.u32 = SDATE_NORM.u32;

        AS_DELAY;
    }
    else
    {
        return HI_FALSE;
    }

    HAL_DATE_READ_VERSION;

    return HI_TRUE;
}


/*****************************************************************************
 Prototype       : INTF Control
 Description     : Interface control while initialize


*****************************************************************************/
static inline void HI_RegSetBit(unsigned long value, unsigned long offset,
    unsigned long addr)
{
	unsigned long t, mask;

	mask = 1 << offset;
	t = readl(addr);
	t &= ~mask;
	t |= (value << offset) & mask;
	writel(t, addr);
}

static inline void HI_RegWrite32(unsigned long value, unsigned long mask,
    unsigned long addr)
{
	unsigned long t;

	t = readl(addr);
	t &= ~mask;
	t |= value & mask;
	writel(t, addr);
}

HI_S32 HAL_INTF_DivSel(HI_S32 s32VoDev, HI_U32 u32DivSel, HI_U32 u32Addr)
{
    if (0 == s32VoDev)/* [17:16] */
    {
        HI_RegWrite32(u32DivSel << 16, 0x03 << 16, IO_ADDRESS(u32Addr));
    }
    else if (1 == s32VoDev || 2 == s32VoDev)/* [15:14] */
    {
        HI_RegWrite32(u32DivSel << 14, 0x03 << 14,  IO_ADDRESS(u32Addr));
    }
    else
    {
        return HI_FAILURE;
    }
    return HI_SUCCESS;
}

HI_S32 HAL_INTF_DacEnable(HI_S32 s32DacId, HI_BOOL bEnable, HI_U32 u32Addr)
{
    HI_U32 u32Val = (bEnable == HI_FALSE)? 0 : 1;

    if (0 == s32DacId)/* [8] */
    {
        HI_RegSetBit(u32Val, 8, IO_ADDRESS(u32Addr));
    }
    else if (1 == s32DacId)/* [9] */
    {
        HI_RegSetBit(u32Val, 9,  IO_ADDRESS(u32Addr));
    }
    else
    {
        return HI_FAILURE;
    }

    return HI_SUCCESS;
}

HI_S32 HAL_SYS_UndoVouSoftRst(HI_U32 u32Addr)
{
    HI_RegSetBit(0x1, 26, IO_ADDRESS(u32Addr));
    HI_RegSetBit(0x1, 27, IO_ADDRESS(u32Addr));
    HI_RegSetBit(0x1, 28, IO_ADDRESS(u32Addr));
    HI_RegSetBit(0x1, 29, IO_ADDRESS(u32Addr));
    return 0;
}

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

