#
# spec file for package tcpd (Version 7.6)
#
# Copyright (c) 2010 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild


Name:           tcpd
Url:            ftp://ftp.porcupine.org/pub/security/index.html
License:        BSD3c
Group:          Productivity/Networking/System
Provides:       nkitb:/usr/sbin/tcpd
BuildRequires:  linux-kernel-headers
AutoReqProv:    on
# bug437293
%ifarch ppc64
Obsoletes:      tcpd-64bit
%endif
#
Version:        7.6
Release:        866.1
Summary:        A security wrapper for TCP daemons
Source:         tcp_wrappers_%{version}.tar.bz2
Source2:        baselibs.conf
Patch0:         tcp_wrappers_%{version}.diff
Patch1:         tcp_wrappers_%{version}-ipv6-1.6.diff
Patch2:         tcp_wrappers_%{version}-ipv6-fix.diff
Patch3:         tcp_wrappers_%{version}-ipv6.fix.fix.diff
Patch4:         tcp_wrappers_%{version}-ipv6.fix.fix2.diff
Patch5:         tcp_wrappers_%{version}-host_name_mapping-fix.diff
Patch6:         tcp_wrappers_%{version}-fix_options-fix.diff
Patch7:         tcp_wrappers_%{version}-shared-lib.diff
Patch8:         tcp_wrappers_%{version}-builtin.diff
Patch9:         tcp_wrappers_%{version}-multi_local_interfaces-fix.diff
Patch10:        tcp_wrappers_%{version}-optflags.diff
Patch11:        tcp_wrappers_%{version}-nonvoid.diff
Patch12:        tcp_wrappers_%{version}-prototypes.diff
Patch13:        tcp_wrappers_%{version}-hosts_ctl.diff
Patch14:        tcp_wrappers_%{version}-uninitialized.diff
Patch15:        tcp_wrappers_%{version}-fedora-bug11881.diff
Patch16:        tcp_wrappers_%{version}-fedora-bug141110.diff
Patch17:        tcp_wrappers_%{version}-fedora-docu.diff
Patch18:        tcp_wrappers_%{version}-fedora-sig.diff
Patch19:        tcp_wrappers_%{version}-fedora-sigchld.diff
Patch20:        tcp_wrappers_%{version}-fedora-sigjmp.diff
Patch21:        tcp_wrappers_%{version}-fedora-sigalarm.diff
Patch22:        tcp_wrappers_%{version}-fedora-strerror.diff
Patch23:        tcp_wrappers_%{version}-fedora-fixgethostbyname.diff
Patch24:        tcp_wrappers_%{version}-fedora-bug220015.diff
Patch25:        tcp_wrappers_%{version}-shared-lib2.diff
Patch26:        tcp_wrappers_%{version}-fedora-bug17795.diff
Patch27:        tcp_wrappers_%{version}-fedora-bug17847.diff
Patch28:        tcp_wrappers_7.6-implicit-decl.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
This package contains a small daemon program that can monitor and
filter incoming requests for finger, ftp, telnet, rlogin, rsh, exec,
tftp, talk, and other network services.



Authors:
--------
    Wietse Venema <wietse@wzv.win.tue.nl>

%package devel
License:        BSD3c
Summary:        Include Files and Libraries for the TCP wrapper library
Group:          Productivity/Networking/System
Requires:       %{name} = %{version}
Requires:       glibc-devel
# bug437293
%ifarch ppc64
Obsoletes:      tcpd-devel-64bit
%endif
#

%description devel
This package contains the library and header files, which are necessary
to compile and link programs against the TCP wrapper library.



%prep
%setup -q -n tcp_wrappers_%{version}
%patch0
%patch1
%patch2
%patch3
%patch4
%patch5
%patch6
%patch7
%patch8
%patch9
%patch10
%patch11
%patch12
%patch13
%patch14
%patch15
%patch16
%patch17
%patch18
%patch19
%patch20
%patch21
%patch22
%patch23
%patch24
%patch25
%patch26
%patch27
%patch28

%build
# make RPM_OPT_FLAGS="$RPM_OPT_FLAGS -fPIC -DPIC -D_REENTRANT -DHAVE_STRERROR" LDFLAGS="-pie" MAJOR=%{LIB_MAJOR} MINOR=%{LIB_MINOR} REL=%{LIB_REL} linux
make %{?jobs:-j%jobs} linux

%install
install -d -m 755 $RPM_BUILD_ROOT%{_includedir}
install -d -m 755 $RPM_BUILD_ROOT%{_libdir}
install -d -m 755 $RPM_BUILD_ROOT%{_sbindir}
install -d -m 755 $RPM_BUILD_ROOT%{_mandir}/man{1,3,5,8}
install -d -m 755 $RPM_BUILD_ROOT/%{_lib}
install -m 644 ip6utils.h tcpd.h $RPM_BUILD_ROOT%{_includedir}
install -m 644 libwrap.a $RPM_BUILD_ROOT/%{_libdir}
install -m 755 safe_finger tcpd tcpdchk tcpdmatch try-from $RPM_BUILD_ROOT%{_sbindir}
install -m 644 hosts_access.3 $RPM_BUILD_ROOT%{_mandir}/man3
install -m 644 hosts_access.5 hosts_options.5 $RPM_BUILD_ROOT%{_mandir}/man5
install -m 644 tcpd.8 tcpdchk.8 tcpdmatch.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m 644 shared/libwrap.so.0.%{version} $RPM_BUILD_ROOT/%{_lib}
cd $RPM_BUILD_ROOT/%{_lib}
ln -sf libwrap.so.0.%{version} libwrap.so.0
cd $RPM_BUILD_ROOT%{_libdir}
ln -sf /%{_lib}/libwrap.so.0.%{version} libwrap.so

%clean
[ -d $RPM_BUILD_ROOT -a "$RPM_BUILD_ROOT" != "" ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(644,root,root,755)
%doc BLURB CHANGES DISCLAIMER README README.ipv6 README.NIS
%doc %{_mandir}/man?/*
%attr(755,root,root) /%{_lib}/libwrap.so.*
%attr(755,root,root) %{_sbindir}/*

%files devel
%defattr(644,root,root,755)
%{_includedir}/tcpd.h
%{_includedir}/ip6utils.h
%{_libdir}/libwrap.a
%{_libdir}/libwrap.so

%changelog
* Mon Feb  1 2010 jengelh@medozas.de
- remove not-needed sparcv9 baselib exception
* Sun Dec 13 2009 jengelh@medozas.de
- add baselibs.conf as a source
- add baselibs for SPARC
- enable parallel building
* Fri Oct 30 2009 crrodriguez@opensuse.org
- fix build
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Tue Nov 11 2008 ro@suse.de
- SLE-11 uses PPC64 instead of PPC, adapt baselibs.conf
* Mon Oct 13 2008 prusnak@suse.cz
- applied patches from Fedora package
  * fedora-bug11881.diff - replace sprintf with snprintf
  * fedora-bug17795.diff - add hostfile matching
  * fedora-bug17847.diff - add wildcard matching
  * fedora-bug141110.diff - fix table_match usage
  * fedora-bug220015.diff - add sock_hostnofd function
  * fedora-docu.diff - fix manpage
  * fedora-fixgethostbyname.diff - fix gethostbyname usage
  * fedora-sig.diff - fix signal usage
  * fedora-sigalarm.diff - fix signal usage
  * fedora-sigchld.diff - fix signal usage
  * fedora-sigjmp.diff - fix signal usage
  * fedora-strerror.diff - fix strerror usage
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Tue May 30 2006 lmichnovic@suse.cz
- fixed uninitilized filepointer (uninitialized.diff) [#178636]
* Fri Mar 31 2006 lmichnovic@suse.cz
- fixed missing definition of hosts_ctl() in tcpd.h (hosts_ctl.diff)
  [#162303]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Sun Jan 15 2006 schwab@suse.de
- Don't strip binaries.
* Fri Sep 16 2005 meissner@suse.de
- fixed all implicit warnings.
* Fri Jun 24 2005 ro@suse.de
- build with fPIE/pie
- really use RPM_OPT_FLAGS
- fix some non-void-return warnings
* Thu Jan 13 2005 postadal@suse.cz
- fixed crashing on system with more than one network interface [#49368]
* Wed Sep 15 2004 aj@suse.de
- Fix warnings about implicit functions to compile with GCC 4.0.
* Mon Mar 22 2004 ro@suse.de
- installed shared lib to /%%_lib, not /usr/%%_lib
  and add symlinks (fix for part of #36514)
* Thu Feb 12 2004 kukuk@suse.de
- Create subpackage "tcpd-devel"
* Mon Feb  9 2004 postadal@suse.cz
- added support for compiling as shared library with soname of libwrap0 (version 7.6)
* Sun Jan 11 2004 adrian@suse.de
- build as user
* Fri Oct 31 2003 postadal@suse.cz
- fixed invalid warning about "host name mismatch" [#26519, #32772]
* Wed Sep 10 2003 postadal@suse.cz
- fixed handling patterns ending with period [#27322]
* Sat Mar 15 2003 kukuk@suse.de
- Don't handle IPv4 netmask as Prefix length [#25409]
* Mon Dec 16 2002 postadal@suse.cz
- added ip6utils.h to filelist [#22487]
* Fri Dec 13 2002 postadal@suse.cz
- fixed fix_options function in libwrap.a [#22000]
- included patch ipv6-fix.diff of mludvig@suse.cz to make tcpd work
  with IPv4 and mapped IPv4 addresses. [#16162]
- turned off remote username lookups (allways_rfc931) [#22013]
* Thu Jan 10 2002 cihlar@suse.cz
- use %%{_libdir}
* Tue Nov 20 2001 cihlar@suse.cz
- fixed SEGFAULT in tcpdchk [#12135]
* Thu Sep  6 2001 schwab@suse.de
- Compile with -fPIC so that it can be included in a shared library.
* Wed Sep  5 2001 schwab@suse.de
- Add prototypes for C++.
* Thu Mar 22 2001 ro@suse.de
- added split-aliases as provides
* Tue Feb 27 2001 cihlar@suse.cz
- fixed %%files
- clean up spec file
- bzipped sources
* Tue Apr 11 2000 kukuk@suse.de
- Split from nkitb
