#include <config.h>
#include <common.h>
#include <linux-adapter.h>
#include <asm/arch/platform.h>

static void _delay_cl(unsigned long cl)
{
	for(cl=(cl*CFG_CPUCLK_SCALE)>>2; cl!=0; cl--)
		__asm__ __volatile__("nop");
}

void hisi_oem_init(void)
{
	unsigned long base = REG_BASE_SCTL;
	
	//EPLL
	__raw_writel(REG_CONF_PERCTRL6,base + REG_SC_PERCTRL6);
	__raw_writel(REG_CONF_PERCTRL7,base + REG_SC_PERCTRL7);
	_delay_cl(100);
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL7)|(1<<22),base + REG_SC_PERCTRL7);
	
	/* GTCLKOUT config for GMAC */
	__raw_writel(__raw_readl(REG_BASE_IOCFG + 0x012C) | 0x1 ,REG_BASE_IOCFG + 0x012C);

    /* SDA and SCL config */
	__raw_writel(0x01, REG_BASE_IOCFG + 0x00FC);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x0100);
    
    /*pci-gpio multiuse*/
    __raw_writel(0x01, REG_BASE_IOCFG + 0x0138);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x013c);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x0140);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x0144);

    /*USB power config add by eric 110720*/
    __raw_writel(0x01, REG_BASE_IOCFG + 0x74);
    __raw_writel(__raw_readl(REG_BASE_GPIO6 + 0x400)|(1<<1), REG_BASE_GPIO6 + 0x400);
    __raw_writel(0x00, REG_BASE_GPIO6 + (1<<(1+2)));

    /*Enable buzz pin gpio3_2*/
    __raw_writel(__raw_readl(REG_BASE_GPIO3 + 0x400)|(1<<2), REG_BASE_GPIO3 + 0x400);
    __raw_writel(0x00, REG_BASE_GPIO3 + (1<<(2+2)));

    /*Enable rs485 led gpio2_5*/
    __raw_writel(__raw_readl(REG_BASE_GPIO2 + 0x400)|(1<<5), REG_BASE_GPIO2 + 0x400);
    __raw_writel(0x00, REG_BASE_GPIO2 + (1<<(5+2)));

    /*Alarm out 1-4*/
    __raw_writel(0x01, REG_BASE_IOCFG + 0x38);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x3c);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x40);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x44);

    /*GPIO5_0 - GPIO5_7 for video channel led indicator*/
    __raw_writel(0x01, REG_BASE_IOCFG + 0x50);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x54);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x58);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x5c);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x60);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x64);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x68);
    __raw_writel(0x01, REG_BASE_IOCFG + 0x6c);

   /*ACKOUT*/
    __raw_writel(0x01, REG_BASE_IOCFG + 0x10C);
}

