/*
 * (C) Copyright 2003
 * Kyle Harris, kharris@nexus-tech.net
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <linux-adapter.h>
#include <asm/arch/platform.h>

void slave_start(void)
{
	DECLARE_GLOBAL_DATA_PTR;
	
	unsigned int slave_bootaddr, slave_kerneladdr, slave_initrdaddr;
	image_header_t hdr;
	char *slave_env;
	char *kernel_addr;
	char *initrd_addr;
	char *img_addr;
	unsigned int len,data;
	char cmd_buf[40];
	ulong tmp;
	int boot_flag;
	
	boot_flag = __raw_readl(REG_BASE_SCTL + SC_STARTMOD_OFFSET) & 0x60;
	boot_flag = boot_flag >> 5;

	if ( (boot_flag & 0x1) == 1 ){
		goto go_slave;		/* go init slavestart */
	}
	
	img_addr = getenv("slave_boot_addr");
	if (img_addr)
		slave_bootaddr = simple_strtoul(img_addr,NULL,16);
	else
		slave_bootaddr = CFG_SLAVE_BOOT_ADDR;

	img_addr = getenv("slave_kernel_addr");
	if (img_addr)
		slave_kerneladdr = simple_strtoul(img_addr,NULL,16);
	else
		printf("ERROR: can't get slave_kernel_addr!\n");
	
	img_addr = getenv("slave_initrd_addr");
	if (img_addr)
		slave_initrdaddr = simple_strtoul(img_addr,NULL,16);
	else
		printf("ERROR: can't get slave_kernel_addr!\n",slave_initrdaddr);

	//handle boot image
	memmove (&hdr, (char *)slave_bootaddr, sizeof(image_header_t));
	if (ntohl(hdr.ih_magic) != IH_MAGIC) {
		printf("ERROR! unknown slave_boot.img format, addr=0x%x, data=0x%x!\n", slave_bootaddr, ntohl(hdr.ih_magic));
		return ;
	}

	len  = ntohl(hdr.ih_size);
	data = slave_bootaddr + sizeof(image_header_t);
	memmove ((void *) ntohl(hdr.ih_load), (uchar *)data, len);
	slave_bootaddr = ntohl(hdr.ih_load);		

#if SLAVR_BOOT_DEBUG
	printf("slave_kerneladdr =%x, slave_kerneladdr & 0xf0000000=%x!\n",slave_kerneladdr, slave_kerneladdr & 0xF0000000);
#endif

	if((slave_kerneladdr >> 28) == 8){
		//kernel is in flash
		memmove (&hdr, (char *)slave_kerneladdr, sizeof(image_header_t));
		if ((ntohl(hdr.ih_magic) != IH_MAGIC) || (hdr.ih_type != IH_TYPE_KERNEL)) {
			printf("WARNING! unknown slave_kernel.img format!\n");
			goto handleenv;
		}

		len  = ntohl(hdr.ih_size) + sizeof(image_header_t);
//		memmove ((void *) ntohl(hdr.ih_load), (uchar *)slave_kerneladdr, len);
		memmove (0xe0300000, (uchar *)slave_kerneladdr, len);
		kernel_addr = 0xe0300000;
	}
	else
	{
		kernel_addr = (void *)slave_kerneladdr;
	}
       // kernel_addr = (void *)ntohl(hdr.ih_load)+0x200000;
	if((slave_initrdaddr >> 28) == 8){
		//initrd is in flash
		memmove (&hdr, (char *)slave_initrdaddr, sizeof(image_header_t));
		if (ntohl(hdr.ih_magic) != IH_MAGIC) {
			printf("WARNING! unknown slave_initrd.img format!\n");
			goto handleenv;
		}
		len  = ntohl(hdr.ih_size)+sizeof(image_header_t);
		data = slave_initrdaddr;
		memmove ((void *) ntohl(hdr.ih_load), (uchar *)data, len);
		initrd_addr = (void *) ntohl(hdr.ih_load);
	}
	else
	{
		initrd_addr = (void *)slave_initrdaddr;
	}
	sprintf (cmd_buf, "setenv slave_bootcmd bootm %p %p", kernel_addr, initrd_addr);
	run_command(cmd_buf,0);

handleenv:
	slave_env = (void *)CFG_SLAVE_ENV_ADDR; 
	memmove (slave_env, (char *)gd->env_addr, CFG_ENV_SIZE);
	
#if SLAVR_BOOT_DEBUG
	printf("start slave arm!\n");
#endif
go_slave:
	tmp = __raw_readl(0x20050074);
	tmp = tmp & 0xffffff00;
	__raw_writel(tmp | MEM_SLAVE_RESET,0x20050074);
	__raw_writel(__raw_readl(0x20050050) | (1 << 1),0x20050050);
}

int do_slavestart(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	unsigned int kernel_addr, initrd_addr; 
	char cmd_buf[40];
	char *env;
#if SLAVR_BOOT_DEBUG
	printf("Enter do_slavestart!\n");
#endif
	if(argc < 2){
		env = getenv("slave_kernel_addr");
		if(env){
			kernel_addr = simple_strtoul(env, NULL, 16);
		}else{
			kernel_addr = CFG_SLAVE_KERNEL_ADDR;
		}

		env = getenv("slave_initrd_addr");
		if(env){
			initrd_addr = simple_strtoul(env, NULL, 16);
		}else{
			initrd_addr = CFG_SLAVE_INITRD_ADDR;
		}
	}else{
		kernel_addr = simple_strtoul(argv[1], NULL, 16);
		initrd_addr = simple_strtoul(argv[2], NULL, 16);
	}

        sprintf (cmd_buf, "setenv slave_kernel_addr 0x%x", kernel_addr);
#if SLAVR_BOOT_DEBUG
	printf("cmd_buf=%s!\n",cmd_buf);
#endif
	run_command(cmd_buf,0);

        sprintf (cmd_buf, "setenv slave_initrd_addr 0x%x", initrd_addr);
#if SLAVR_BOOT_DEBUG
	printf("cmd_buf=%s!\n",cmd_buf);
#endif
	run_command(cmd_buf,0);
    __raw_writel(__raw_readl(0x20050050) & 0xfffffffd,0x20050050);
	slave_start();
}

U_BOOT_CMD(
 	slavestart,	3,	0,	do_slavestart,
 	"slavestart   - start slave arm!\n",
 	"slave_kernel_addr slave_initrd_addr  \n"
);



