/*
 * (C) Copyright 2009-2010
 * Kevin Hsu, Hisilicon inc, xujilin@huawei.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Video output Support
 */
#include <common.h>
#include <command.h>
#include <hi35xx_vo.h>


extern int set_vobg(unsigned int dev, unsigned int rgb);
extern int start_vo(unsigned int dev, unsigned int type, unsigned int sync);
extern int stop_vo(unsigned int dev);
extern int start_gx(unsigned int layer, unsigned addr, unsigned int strd, unsigned int x, unsigned int y, unsigned int w, unsigned int h);
extern int stop_gx(unsigned int layer);


int check_vo_support(unsigned int dev, unsigned int type, unsigned int sync)
{
    if (VO_DEV_HD == dev)
    {
        if (!HI_3520_VO && VO_INTF_VGA != type)
        {
            return -1;
        }

        if (VO_INTF_VGA == type
            || VO_INTF_BT1120 == type || VO_INTF_LCD == type)
        {
            if (sync < VO_OUTPUT_720P60 || sync > VO_OUTPUT_1440x900_60)
            {
                return -1;
            }
        }
        else if (VO_INTF_YPBPR == type)
        {
            if (sync < VO_OUTPUT_720P60 || sync > VO_OUTPUT_1080P30)
            {
                return -1;
            }
        }
        else
        {
            return -1;
        }
    }
    else if (VO_DEV_AD == dev && HI_3520_VO)
    {
        if (VO_INTF_VGA == type)
        {
            if (sync < VO_OUTPUT_800x600_60 || sync > VO_OUTPUT_1440x900_60)
            {
                return -1;
            }
        }
        else if (VO_INTF_CVBS == type || VO_INTF_BT656 == type)
        {
            if (sync != VO_OUTPUT_PAL && sync != VO_OUTPUT_NTSC)
            {
                return -1;
            }
        }
        else
        {
            return -1;
        }
    }
    else if (VO_DEV_SD == dev)
    {
        if (VO_INTF_CVBS == type)
        {
            if (sync != VO_OUTPUT_PAL && sync != VO_OUTPUT_NTSC)
            {
                return -1;
            }
        }
        else if (!HI_3520_VO)
        {
            if (VO_INTF_BT656 != type)
            {
                return -1;
            }
        }
        else
        {
            return -1;
        }
    }
    else
    {
        return -1;
    }

    return 0;
}

int do_vobg(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    unsigned int dev, rgb;

    if (argc < 3)
    {
        printf("Insufficient parameter!\n");
        printf ("Usage:\n%s\n", cmdtp->usage);
        return -1;
    }

    dev = (unsigned int)simple_strtoul(argv[1], NULL, 10);
    rgb = (unsigned int)simple_strtoul(argv[2], NULL, 10);
    if (dev >= VO_DEV_BUTT)
    {
        printf("Invalid parameter!\n");
        return -1;
    }

    set_vobg(dev, rgb);

    printf("set vo %d bg as %#x!\n", dev, rgb);

    return 0;
}

int do_startvo(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    unsigned int dev, type, sync;

    if (argc < 4)
    {
        printf("Insufficient parameter!\n");
        printf ("Usage:\n%s\n", cmdtp->usage);
        return -1;
    }

    dev  = (unsigned int)simple_strtoul(argv[1], NULL, 10);
    type = (unsigned int)simple_strtoul(argv[2], NULL, 10);
    sync = (unsigned int)simple_strtoul(argv[3], NULL, 10);
    if (dev >= VO_DEV_BUTT || type >= VO_INTF_BUTT || sync >= VO_OUTPUT_BUTT)
    {
        printf("Invalid parameter!\n");
        return -1;
    }

    if (check_vo_support(dev, type, sync))
    {
        printf("Unsupport parameter!\n");
        return -1;
    }

    start_vo(dev, type, sync);

    printf("dev %d opened!\n", dev);

    return 0;
}

int do_stopvo(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    unsigned int dev;

    if (argc < 2)
    {
        printf("Insufficient parameter!\n");
        printf ("Usage:\n%s\n", cmdtp->usage);
        return -1;
    }

    dev = (unsigned int)simple_strtoul(argv[1], NULL, 10);
    if (dev >= VO_DEV_BUTT)
    {
        printf("Invalid parameter!\n");
        return -1;
    }

    stop_vo(dev);

    printf("dev %d closed!\n", dev);

    return 0;
}

int do_startgx(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    unsigned int layer, addr, strd, x, y, w, h;

    if (argc < 8)
    {
        printf("Insufficient parameter!\n");
        printf ("Usage:\n%s\n", cmdtp->usage);
        return -1;
    }

    layer = (unsigned int)simple_strtoul(argv[1], NULL, 10);
    addr  = (unsigned int)simple_strtoul(argv[2], NULL, 16);
    strd  = (unsigned int)simple_strtoul(argv[3], NULL, 10);
    x     = (unsigned int)simple_strtoul(argv[4], NULL, 10);
    y     = (unsigned int)simple_strtoul(argv[5], NULL, 10);
    w     = (unsigned int)simple_strtoul(argv[6], NULL, 10);
    h     = (unsigned int)simple_strtoul(argv[7], NULL, 10);

    if (layer >= VO_GRAPHC_BUTT || strd > (PIC_MAX_WIDTH*2)
        || x > PIC_MAX_WIDTH   || (x & 0x1)
        || y > PIC_MAX_HEIGHT  || (y & 0x1)
        || w > PIC_MAX_WIDTH   || (w & 0x1) || w < PIC_MIN_LENTH
        || h > PIC_MAX_HEIGHT  || (h & 0x1) || h < PIC_MIN_LENTH
        )
    {
        printf("Invalid parameter!\n");
        return -1;
    }

    start_gx(layer, addr, strd, x, y, w, h);

    printf("graphic layer %d opened!\n", layer);

    return 0;
}

int do_stopgx(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    unsigned int layer;

    if (argc < 2)
    {
        printf("Insufficient parameter!\n");
        printf ("Usage:\n%s\n", cmdtp->usage);
        return -1;
    }

    layer = (unsigned int)simple_strtoul(argv[1], NULL, 10);
    if (layer >= VO_GRAPHC_BUTT)
    {
        printf("Invalid parameter!\n");
        return -1;
    }

    stop_gx(layer);

    printf("graphic layer %d closed!\n", layer);

    return 0;
}



U_BOOT_CMD(
	startvo,    CFG_MAXARGS,	1,  do_startvo,
	"startvo   - open interface of vo device.\n"
	"\t- startvo [dev type sync]",
	"\nargs: [dev, type, sync]\n"
	"\t-<dev> : 0(HD), 1(AD), 2(SD)\n"
	"\t-<type>: 0(CVBS),1(BT.656),2(VGA),3(YPbPr),4(BT.1120)\n"
	"\t-<sync>:\n"
	"\t\t0(PAL),1(NTSC),2(720P@60)\n"
	"\t\t3(1080I50),4(1080I60),5(1080P25),6(1080P30)\n"
	"\t\t7(800x600),8(1024x768),9(1280x1024),10(1366x768),11(1440x900)\n"
	);

U_BOOT_CMD(
	stopvo,    CFG_MAXARGS,	1,  do_stopvo,
	"stopvo   - close interface of vo device.\n"
	"\t- stopvo [dev]",
	"\nargs: [dev]\n"
	"\t-<dev> : 0(HD), 1(AD), 2(SD)\n"
	);

U_BOOT_CMD(
	startgx,    CFG_MAXARGS,	1,  do_startgx,
	"startgx   - open graphics layer.\n"
	"\t- startgx [layer addr stride x y w h]\n",
	"\nargs: [layer, addr, stride, x, y, w, h]\n"
	"\t-<layer>   : 0(G0), 1(G1), 2(G2), 3(G3), 4(HC)\n"
	"\t-<addr>    : picture address\n"
	"\t-<stride>  : picture stride\n"
	"\t-<x,y,w,h> : display area\n"
	);

U_BOOT_CMD(
	stopgx,    CFG_MAXARGS,	1,  do_stopgx,
	"stopgx   - close graphics layer.\n"
	"\t- stopgx [layer]",
	"\nargs: [layer]\n"
	"\t-<layer> : 0(G0), 1(G1), 2(G2), 3(G3), 4(HC)\n"
	);

U_BOOT_CMD(
	setvobg,    CFG_MAXARGS,	1,  do_vobg,
	"setvobg   - set vo backgroud color.\n"
	"\t- setvobg [dev color]",
	"\nargs: [dev, color]\n"
	"\t-<dev> : 0(HD), 1(AD), 2(SD)\n"
	"\t-<color>: rgb color space\n"
	);

