#ifndef __H2GMAC_REG_H__
#define __H2GMAC_REG_H__
/*REG DEFINE*/
#define             STATION_ADDR_LOW                        0x00000000
#define             STATION_ADDR_HIGH                       0x00000004
#define             FD_FC_TYPE                              0x0000000C
#define             FIFO_THRSLD                             0x00000010
#define             FC_TX_TIMER                             0x0000001C
#define             FD_FC_ADDR_LOW                          0x00000020
#define             FD_FC_ADDR_HIGH                         0x00000024
#define             IPG_TX_TIMER                            0x00000030
#define             PAUSE_THR                               0x00000038
#define             MAX_FRM_SIZE                            0x0000003C
#define             PORT_MODE                               0x00000040
#define             PORT_EN                                 0x00000044
#define             PAUSE_EN                                0x00000048
#define             SHORT_RUNTS_THR                         0x00000050
#define             DROP_UNK_CTL_FRM                        0x00000054
#define             TRANSMIT_CONTROL                        0x00000060
#define             REC_FILT_CONTROL                        0x00000064
#define             PORT_MC_ADDR_LOW                        0x00000068
#define             PORT_MC_ADDR_HIGH                       0x0000006C
#define             MAC_CLR                                 0x00000070
#define             PORT_STATUS                             0x00000164
#define             SMII_STAT                               0x00000168
#define             LED_MOD                                 0x0000016C
#define             PHYCONTROL                              0x00000180
#define             PHY_STATUS                              0x00000184
#define             PHY_ID1                                 0x00000188
#define             PHY_ID2                                 0x0000018C
#define             LINE_LOOP_BACK                          0x000001A8
#define             CF_CRC_STRIP                            0x000001B0
#define             MODE_CHANGE_EN                          0x000001B4
#define             LOOP_REG                                0x000001DC
#define             RECV_CONTROL                            0x000001E0
#define             VLAN_CODE                               0x000001E8
#define             RX_OVERRUN_CNT                          0x000001EC
#define             RX_LENGTHFIELD_ERR_CNT                  0x000001F4
#define             RX_FAIL_COMMA_CNT                       0x000001F8
#define             RX_OCTETS_TOTAL_OK                      0x00000080
#define             RX_OCTETS_BAD                           0x00000084
#define             RX_UC_PKTS                              0x00000088
#define             RX_MC_PKTS                              0x0000008C
#define             RX_BC_PKTS                              0x00000090
#define             RX_PKTS_64OCTETS                        0x00000094
#define             RX_PKTS_65TO127OCTETS                   0x00000098
#define             RX_PKTS_128TO255OCTETS                  0x0000009C
#define             RX_PKTS_255TO511OCTETS                  0x000000A0
#define             RX_PKTS_512TO1023OCTETS                 0x000000A4
#define             RX_PKTS_1024TO1518OCTETS                0x000000A8
#define             RX_PKTS_1519TOMAXOCTETS                 0x000000AC
#define             RX_FCS_ERRORS                           0x000000B0
#define             RX_TAGGED                               0x000000B4
#define             RX_DATA_ERR                             0x000000B8
#define             RX_ALIGN_ERRORS                         0x000000BC
#define             RX_LONG_ERRORS                          0x000000C0
#define             RX_JABBER_ERRORS                        0x000000C4
#define             RX_PAUSE_MACCONTROL_FRAMCOUNTER         0x000000C8
#define             RX_UNKNOWN_MACCONTROL_FRAMCOUNTER       0x000000CC
#define             RX_VERY_LONG_ERR_CNT                    0x000000D0
#define             RX_RUNT_ERR_CNT                         0x000000D4
#define             RX_SHORT_ERR_CNT                        0x000000D8
#define             OCTETS_TRANSMITTED_OK                   0x00000100
#define             OCTETS_TRANSMITTED_BAD                  0x00000104
#define             TX_UC_PKTS                              0x00000108
#define             TX_MC_PKTS                              0x0000010C
#define             TX_BC_PKTS                              0x00000110
#define             TX_PKTS_64OCTETS                        0x00000114
#define             TX_PKTS_65TO127OCTETS                   0x00000118
#define             TX_PKTS_128TO255OCTETS                  0x0000011C
#define             TX_PKTS_255TO511OCTETS                  0x00000120
#define             TX_PKTS_512TO1023OCTETS                 0x00000124
#define             TX_PKTS_1024TO1518OCTETS                0x00000128
#define             TX_PKTS_1519TOMAXOCTETS                 0x0000012C
#define             TX_EXCESSIVE_LENGTH_DROP                0x0000014C
#define             TX_UNDERRUN                             0x00000150
#define             TX_TAGGED                               0x00000154
#define             TX_CRC_ERROR                            0x00000158
#define             TX_PAUSE_FRAMES                         0x0000015C
#define             MAC_SA_ADDR_L                           0x00000200
#define             MAC_SA_ADDR_H                           0x00000204
#define             MAC_DA_ADDR_L                           0x00000208
#define             MAC_DA_ADDR_H                           0x0000020C
#define             CESOP_FRAME_TYPE                        0x00000210
#define             CONTROL_WORD                            0x00000214
#define             FLOW_CTRL_PKG_THRSLD                    0x00000218
#define             CRF_FLOW_TIME_THRSLD                    0x0000021C
#define             FILTER_LIST0                            0x00000220
#define             FILTER_LIST1                            0x00000224
#define             FILTER_LIST2                            0x00000228
#define             FILTER_LIST3                            0x0000022C
#define             FILTER_LIST4                            0x00000230
#define             FILTER_LIST5                            0x00000234
#define             FILTER_LIST6                            0x00000238
#define             FILTER_LIST7                            0x0000023C
#define             FILTER_LIST8                            0x00000240
#define             FILTER_LIST9                            0x00000244
#define             FILTER_LIST10                           0x00000248
#define             FILTER_LIST11                           0x0000024C
#define             FILTER_LIST12                           0x00000250
#define             FILTER_LIST13                           0x00000254
#define             FILTER_LIST14                           0x00000258
#define             FILTER_LIST15                           0x0000025C
#define             CRF_UDP_NO                              0x00000260
#define             CRF_TX_FIFO_THRSLD                      0x00000264
#define             CRF_RX_FIFO_THRSLD                      0x00000268
#define             CRF_RX_BASE_ADDR                        0x0000026C
#define             CRF_INTRPT_THRSLD                       0x00000270
#define             CRF_FIFO_CLR                            0x00000274
#define             CRF_SLAVE_EOF                           0x00000278
#define             CRF_INTRPT_CLR                          0x0000027C
#define             ERR_GIVEN_PKG_CNT                       0x00000280
#define             ERR_FRM_TYPE_CNT                        0x00000288
#define             ERR_IP_TYPE_CNT                         0x0000028C
#define             ERR_UDP_CNT                             0x00000290
#define             OVER_FLOW_CNT                           0x00000294
#define             OVER_LENGTH_CNT                         0x00000298
#define             TX_CRF_ST                               0x0000029C
#define             FIFO_CURR_STATUS                        0x000002A0
#define             FIFO_HIS_STATUS                         0x000002A4
#define             CRF_CFF_DATA_NUM                        0x000002A8
#define             FLOW_OUT_IP_CNT                         0x000002AC
#define             FLOW_OUT_CTRL_CNT                       0x000002B0
#define             IP_CHK_ERR_CNT                          0x000002B4
#define             UDP_CHK_ERR_CNT                         0x000002B8
#define             TX_RUNT_ERR_PKG_CNT                     0x000002BC
#define             RX_ERR_TOTAL_CNT                        0x000002C0
#define             TX_FL_ERR_PKG_CNT                       0x000002C4
#define             RX_TRANS_PKG_CNT                        0x000002C8
#define             TX_TRANS_PKG_CNT                        0x000002CC
#define             RX_BM_OVERFLOW                          0x000002D0
#define             TX_ADDR_OVERFLOW                        0x000002D4
#define             RX_ADDR_OVERFLOW                        0x000002D8
#define             TXRX_CFG_INDEX                          0x0000033C
#define             CRF_TX_PAUSE                            0x00000340
#define             CRF_RX_ADDR_NUM                         0x00000344
#define             CRF_CTRL_0_TYPE                         0x00000348
#define             CRF_CTRL_1_TYPE                         0x0000034C
#define             CRF_CTRL_2_TYPE                         0x00000350
#define             CRF_CTRL_3_TYPE                         0x00000354
#define             CRF_BM_PKT_THRSLD                       0x00000358
#define             CRF_BM_TIME_THRSLD                      0x0000035C
#define             MDIO_SINGLE_CMD                         0x000003C0
#define             MDIO_SINGLE_DATA                        0x000003C4
#define             MDIO_SCAN_EN                            0x000003C8
#define             MDIO_CTL                                0x000003CC
#define             MDIO_RDATA_STATUS                       0x000003D0
#define             TX_CFF_LEN(m)                          (0x0400 + (m) * 0x4)
#define             TX_CFF_ADDR(n)                          (0x0580 + (n) * 0x4)
#define             RX_CFF_ADDR(n)                          (0x0480 + (n) * 0x4)
#define             DATA_FIFO_ADDR(j)                       (0x0500 + (j) * 0x4)

#define MK_BITS(shift, nbits) ((((shift) & 0x1F) << 16) | ((nbits) & 0x3F))
//#define MK_BITS(shift,nbits)    (((2 << ((nbits) - 1)) - 1) << (shift))     /*((2 ^ (nbit - 1))-1) << shift*/
/*bit description*/
#define             station_addr_high_B                     MK_BITS(0, 16)
#define             fd_fc_type_B                            MK_BITS(0, 16)
#define             thrsld_inter_clock_B                    MK_BITS(24, 8)
#define             thrsld_for_p_empty_B                    MK_BITS(16, 8)
#define             thrsld_for_p_full_B                     MK_BITS(8, 8)
#define             buff_sz_for_tsmt_B                      MK_BITS(0, 7)
#define             fc_tx_timer_B                           MK_BITS(0, 16)
#define             fd_fc_addr_high_B                       MK_BITS(0, 16)
#define             ipg_tx_timer_B                          MK_BITS(0, 8)
#define             pause_thr_B                             MK_BITS(0, 16)
#define             max_frm_size_B                          MK_BITS(0, 14)
#define             port_mode_B                             MK_BITS(0, 3)
#define             tx_en_B                                 MK_BITS(2, 1)
#define             rx_en_B                                 MK_BITS(1, 1)
#define             tx_fdfc_B                               MK_BITS(1, 1)
#define             rx_fdfc_B                               MK_BITS(0, 1)
#define             short_runts_thr_B                       MK_BITS(0, 5)
#define             drop_unk_ctl_frm_B                      MK_BITS(0, 1)
#define             pad_enable_B                            MK_BITS(7, 1)
#define             crc_add_B                               MK_BITS(6, 1)
#define             an_enable_B                             MK_BITS(5, 1)   //RW
#define             link_sel_B                              MK_BITS(4, 1)
#define             crc_err_pass_B                          MK_BITS(5, 1)
#define             pause_frm_pass_B                        MK_BITS(4, 1)
#define             vlan_drop_en_B                          MK_BITS(3, 1)
#define             bc_drop_en_B                            MK_BITS(2, 1)
#define             mc_match_en_B                           MK_BITS(1, 1)
#define             uc_match_en_B                           MK_BITS(0, 1)
#define             port_mc_addr_high_B                     MK_BITS(0, 16)
#define             soft_rst_smii_B                         MK_BITS(4, 1)
#define             soft_rst_mdio_B                         MK_BITS(3, 1)
#define             soft_rst_mii_B                          MK_BITS(2, 1)
#define             soft_rst_rx_B                           MK_BITS(1, 1)
#define             soft_rst_tx_B                           MK_BITS(0, 1)
#define             ge_link_stat_B                          MK_BITS(4, 1)
#define             fe_link_state_B                         MK_BITS(3, 1)
#define             speed_st_B                              MK_BITS(1, 2)
#define             duplex_st_B                             MK_BITS(0, 1)
#define             rxfrm_cnt_mii_B                         MK_BITS(12, 4)
#define             rxfrm_cnt_phy_B                         MK_BITS(8, 4)
#define             txfrm_cnt_mii_B                         MK_BITS(4, 4)
#define             txfrm_cnt_phy_B                         MK_BITS(0, 4)
#define             led_mod_B                               MK_BITS(0, 1)
#define             phy_reset_B                             MK_BITS(15, 1)
#define             loopback_B                              MK_BITS(14, 1)
#define             speed_sel_low_B                         MK_BITS(13, 1)
#define             an_en_B                                 MK_BITS(12, 1)  //RO
#define             power_down_B                            MK_BITS(11, 1)  
#define             isolate_B                               MK_BITS(10, 1)
#define             restart_an_B                            MK_BITS(9, 1)
#define             duplex_mode_B                           MK_BITS(8, 1)
#define             col_test_B                              MK_BITS(7, 1)
#define             speed_sel_high_B                        MK_BITS(6, 1)
#define             phy100baset4_B                          MK_BITS(15, 1)
#define             phy100basex_fd_B                        MK_BITS(14, 1)
#define             phy100basex_hd_B                        MK_BITS(13, 1)
#define             phy10mbps_fd_B                          MK_BITS(12, 1)
#define             phy10mbps_hd_B                          MK_BITS(11, 1)
#define             phy100baset2_fd_B                       MK_BITS(10, 1)
#define             phy100baset2_hd_B                       MK_BITS(9, 1)
#define             extended_status_B                       MK_BITS(8, 1)
#define             mf_pre_sup_B                            MK_BITS(6, 1)
#define             remote_fault_B                          MK_BITS(4, 1)
#define             an_ability_B                            MK_BITS(3, 1)
#define             link_status_B                           MK_BITS(2, 1)
#define             jabber_det_B                            MK_BITS(1, 1)
#define             extended_cap_B                          MK_BITS(0, 1)
#define             phy_id1_B                               MK_BITS(0, 16)
#define             phy_id2_B                               MK_BITS(10, 6)
#define             man_model_B                             MK_BITS(4, 6)
#define             man_rev_B                               MK_BITS(0, 4)
#define             line_loop_back_B                        MK_BITS(0, 1)
#define             cf_crc_strip_B                          MK_BITS(0, 1)
#define             mode_change_en_B                        MK_BITS(0, 1)
#define             ss_smii_connect_B                       MK_BITS(3, 1)
#define             cf2mi_lp_en_B                           MK_BITS(2, 1)
#define             cf_ext_drive_lp_B                       MK_BITS(1, 1)
#define             runt_pkt_en_B                           MK_BITS(4, 1)
#define             strip_pad_en_B                          MK_BITS(3, 1)
#define             cf_vlan_code_B                          MK_BITS(0, 16)
#define             mac_sa_addr_h_B                         MK_BITS(0, 16)
#define             mac_da_addr_h_B                         MK_BITS(0, 16)
#define             crf_cesop_type_B                        MK_BITS(0, 16)
#define             crf_ip_head_chk_en_B                    MK_BITS(27, 1)
#define             crf_udp_sum_chk_en_B                    MK_BITS(26, 1)
#define             crf_tx_standard_B                       MK_BITS(25, 1)
#define             crf_tx_mode_B                           MK_BITS(24, 1)
#define             crf_insert_0_byte_B                     MK_BITS(23, 1)
#define             crf_remove_0_byte_B                     MK_BITS(22, 1)
#define             crf_ip_flow_ctrl_B                      MK_BITS(21, 1)
#define             crf_ctrl_flow_ctrl_B                    MK_BITS(20, 1)
#define             crf_cesop_up_test_B                     MK_BITS(19, 1)
#define             crf_cesop_down_test_B                   MK_BITS(18, 1)
#define             crf_filt_unused_pkg_B                   MK_BITS(17, 1)
#define             crf_bm_flow_ctrl_B                      MK_BITS(16, 1)
#define             crf_peel_dsa_B                          MK_BITS(15, 1)
#define             crf_add_da_sa_B                         MK_BITS(14, 1)
#define             crf_large_packet_B                      MK_BITS(0, 14)
#define             crf_ip_pkg_thrsld_B                     MK_BITS(16, 16)
#define             crf_ctrl_pkg_thrsld_B                   MK_BITS(0, 16)
#define             crf_flow_time_thrsld_B                  MK_BITS(0, 8)
#define             crf_filt_cfgN_B                         MK_BITS(17, 1)
#define             crf_filt_idN_B                          MK_BITS(16, 1)    
#define             crf_filt_frm_typeN_B                    MK_BITS(0, 16)
#define             crf_udp_max_no_B                        MK_BITS(16, 16)
#define             crf_udp_min_no_B                        MK_BITS(0, 16)
#define             crf_tx_p_full_th_B                      MK_BITS(16, 10) //TX FIFO WATERLINE HIGH
#define             crf_tx_p_empty_th_B                     MK_BITS(0, 10)  //TX FIFO WATERLINE LOW
#define             crf_rx_p_full_th_B                      MK_BITS(16, 10) //RX FIFO WATERLINE HIGH
#define             crf_rx_p_empty_th_B                     MK_BITS(0, 10)  //RX FIFO WATERLINE LOW
#define             crf_tx_up_addr_B                        MK_BITS(9, 7)   //!! no use for h2 gmac
#define             crf_rx_base_addr_B                      MK_BITS(0, 9)   //!! no use for h2 gmac
#define             mac_fifoerr_int_en_B                    MK_BITS(31, 1)
#define             p2a_err_intrpt_en_B                     MK_BITS(30, 1)                    
#define             crf_rxint_en_B                          MK_BITS(29, 1)
#define             crf_txint_en_B                          MK_BITS(28, 1)
#define             cfg_fifoemp_intrpt_en_B                 MK_BITS(27, 1)
#define             crf_pkg_intrpt_en_B                     MK_BITS(26, 1)
#define             crf_intrpt_pkt_B                        MK_BITS(17, 9)   //RX MULTI-PKG CONFIG HERE!
#define             crf_time_intrpt_en_B                    MK_BITS(16, 1)   
#define             crf_intrpt_time_B                       MK_BITS(0, 15)   //RX MULTI-PKG TIMEOUT CONFIG HERE
#define             crf_tx_st_rst_B                         MK_BITS(3, 1)
#define             crf_cff_clr_B                           MK_BITS(2, 1)
#define             crf_rff_clr_B                           MK_BITS(1, 1)
#define             crf_tff_clr_B                           MK_BITS(0, 1)
#define             crf_slave_sel_B                         MK_BITS(1, 2)
#define             crf_slave_eof_B                         MK_BITS(0, 1)
#define             mac_fifo_err_int_B                      MK_BITS(20, 1)
#define             p2a_err_intrpt_B                        MK_BITS(19, 1)
#define             rx_crf_intrpt_B                         MK_BITS(18, 1)  //RAW RX INT, WRITE 1 TO CLEAN
#define             tx_crf_intrpt_B                         MK_BITS(17, 1)  //RAW TX INT, WRITE 1 TO CLEAN
#define             cfg_fifo_emp_intrpt_B                   MK_BITS(16, 1)  //RAW TX FIFO EMPTY INT, WRITE 1 TO CLEAN
#define             mac_fifoerr_int_sta_B                   MK_BITS(4, 1)   
#define             p2a_err_intrpt_sta_B                    MK_BITS(3, 1)
#define             rx_intrpt_sta_B                         MK_BITS(2, 1)
#define             tx_intrpt_sta_B                         MK_BITS(1, 1)
#define             cfg_fifoemp_intrpt_sta_B                MK_BITS(0, 1)
#define             tx_crf_st_B                             MK_BITS(0, 2)
#define             cff_crf_tx_full_B                       MK_BITS(11, 1)
#define             cff_crf_tx_empty_B                      MK_BITS(10, 1)
#define             cff_crf_rx_full_B                       MK_BITS(9, 1)
#define             cff_crf_rx_empty_B                      MK_BITS(8, 1)
#define             rff_crf_p_empty_B                       MK_BITS(7, 1)
#define             rff_crf_empty_B                         MK_BITS(6, 1)
#define             rff_crf_p_full_B                        MK_BITS(5, 1)
#define             rff_crf_full_B                          MK_BITS(4, 1)
#define             tff_crf_p_empty_B                       MK_BITS(3, 1)
#define             tff_crf_empty_B                         MK_BITS(2, 1)
#define             tff_crf_p_full_B                        MK_BITS(1, 1)
#define             tff_crf_full_B                          MK_BITS(0, 1)
#define             cff_crf_tx_full_h_B                     MK_BITS(11, 1)
#define             cff_crf_tx_empty_h_B                    MK_BITS(10, 1)
#define             cff_crf_rx_full_h_B                     MK_BITS(9, 1)
#define             cff_crf_rx_empty_h_B                    MK_BITS(8, 1)
#define             rff_crf_p_empty_h_B                     MK_BITS(7, 1)
#define             rff_crf_empty_h_B                       MK_BITS(6, 1)
#define             rff_crf_p_full_h_B                      MK_BITS(5, 1)
#define             rff_crf_full_h_B                        MK_BITS(4, 1)
#define             tff_crf_p_empty_h_B                     MK_BITS(3, 1)
#define             tff_crf_empty_h_B                       MK_BITS(2, 1)
#define             tff_crf_p_full_h_B                      MK_BITS(1, 1)
#define             tff_crf_full_h_B                        MK_BITS(0, 1)
#define             crf_rx_cfg_num_B                        MK_BITS(16, 9)  //how many pkg left in logic which will be used to receive pkg 
#define             crf_tx_cfg_num_B                        MK_BITS(0, 9)   //how many pkg left in logic which will be sent out                      
#define             txrd_cfg_index_B                        MK_BITS(16, 8)  //!!!!!WHAT'S THIS???
#define             rxrd_cfg_index_B                        MK_BITS(0, 8)   //!!! AND THIS????
#define             crf_tx_pause_auto_b                     MK_BITS(0, 1)   //to decide mac send flow control frame in which way 
#define             crf_rx_addr_num_B                       MK_BITS(0, 8)
#define             crf_ctrl_N_type_B                       MK_BITS(0, 16)
#define             crf_bm_pkt_thrsld_B                     MK_BITS(0, 16)
#define             crf_bm_time_thrsld_B                    MK_BITS(0, 20)  //1 us as unit
#define             mdio_cmd_B                              MK_BITS(20, 1)  //0:mdio operation done,1: start mdio operation
#define             op_code_B                               MK_BITS(16, 2)  //01: write, 10: read
#define             phy_addr_B                              MK_BITS(8, 2)   //
#define             reg_addr_B                              MK_BITS(0, 5)   //PHY REG ADDR
#define             mdio_wr_data_B                          MK_BITS(0, 16)
#define             mdio_rd_data_B                          MK_BITS(16, 16)
#define             mdio_scan_en_B                          MK_BITS(0, 4)
#define             mdio_in_work_B                          MK_BITS(3, 1)
#define             mdio_in_work_en_B                       MK_BITS(2, 1)
#define             autoscan_en_B                           MK_BITS(1, 1)
#define             mdc_speed_B                             MK_BITS(0, 1)
#define             mdio_rdata_status_B                     MK_BITS(0, 1)   //is mdio read data valid? 0:valid,1:invalid

#define BITS_NAME(name) (name ## _B)

#endif


