#ifndef __H2GMAC_UTIL_H__
#define __H2GMAC_UTIL_H__
#include "h2gmac.h"
/*debug trace*/
#define H2GMAC_TRACE_LEVEL 8
#define h2gmac_trace(level, msg...) do { \
        if ((level) >= H2GMAC_TRACE_LEVEL) { \
            printf("h2gmac_trace:%s:%d: ", __FILE__, __LINE__); \
            printf(msg); \
            printf("\n"); \
        } \
    } while (0)

#define dpl()\
do{	\
	printf("%s->%d\n",__func__,__LINE__);\
}while(0)

#define h2gmac_error(args...) do { \
        printf("h2gmac:%s:%d: ", __FILE__, __LINE__); \
        printf(args); \
        printf("\n"); \
    } while (0)

#define h2gmac_assert(cond) do { \
        if (!(cond)) \
            printf("Assert:h2gmac:%s:%d\n", \
                   __FILE__, \
                   __LINE__);\
    } while (0)
/*io operation*/
#define h2gmac_readl(ld, ofs) ({ unsigned long reg = readl((ld)->iobase + (ofs)); \
                                h2gmac_trace(2, "iobase: 0x%x, readl(0x%04X) = 0x%08lX",(ld)->iobase, (ofs), reg); \
                                reg; })
#define h2gmac_writel(ld, v, ofs) do { writel(v, (ld)->iobase + (ofs)); \
                                      h2gmac_trace(2, "iobase: 0x%x, writel(0x%04X) = 0x%08lX",(ld)->iobase, (ofs), (unsigned long)(v)); \
    } while (0)

#define h2gmac_writel_bits(ld, v, ofs, bits_desc) do { \
        unsigned long _bits_desc = bits_desc; \
        unsigned long _shift = (_bits_desc) >> 16; \
        unsigned long _reg  = h2gmac_readl(ld, ofs); \
        unsigned long _mask = ((_bits_desc & 0x3F) < 32) ? (((1 << (_bits_desc & 0x3F)) - 1) << (_shift)) : 0xffffffff; \
        h2gmac_writel(ld, (_reg & (~_mask)) | (((v) << (_shift)) & _mask), ofs); \
    } while (0)
#define h2gmac_readl_bits(ld, ofs, bits_desc) ({ \
                                                  unsigned long _bits_desc = bits_desc; \
                                                  unsigned long _shift = (_bits_desc) >> 16; \
                                                  unsigned long _mask = ((_bits_desc & 0x3F) < 32) ? (((1 << (_bits_desc & 0x3F)) - 1) << (_shift)) : 0xffffffff; \
                                                  (h2gmac_readl(ld, ofs) & _mask) >> (_shift); })
#if 0
#define hireg_trace(level, msg...) do { \
        if ((level) >= H2GMAC_TRACE_LEVEL) { \
            printf("hireg_trace:%s:%d: ", __FILE__, __LINE__); \
            printf(msg); \
            printf("\n"); \
        } \
    } while (0)

#define hireg_readl(base, ofs) ({ unsigned long reg = readl((base) + (ofs)); \
                                  hireg_trace(1, "_readl(0x%04X) = 0x%08lX", (ofs), reg); \
                                  reg; })

#define hireg_writel(base, v, ofs) do { writel((v), (base) + (ofs)); \
                                        hireg_trace(1, "_writel(0x%04X) = 0x%08lX", (ofs), (unsigned long)(v)); \
    } while (0)

#define hireg_writel_bits(base, v, ofs, bits_desc) do { \
        unsigned long _bits_desc = bits_desc; \
        unsigned long _shift = (_bits_desc) >> 16; \
        unsigned long _reg  = hireg_readl(base, ofs); \
        unsigned long _mask = ((_bits_desc & 0x3F) < 32) ? (((1 << (_bits_desc & 0x3F)) - 1) << (_shift)) : 0xffffffff; \
        hireg_writel(base, (_reg & (~_mask)) | (((v) << (_shift)) & _mask), ofs); \
    } while (0)


#define hireg_readl_bits(base, ofs, bits_desc) ({ \
                                                    unsigned long _bits_desc = bits_desc; \
                                                    unsigned long _shift = (_bits_desc) >> 16; \
                                                    unsigned long _mask = ((_bits_desc & 0x3F) < 32) ? (((1 << (_bits_desc & 0x3F)) - 1) << (_shift)) : 0xffffffff; \
                                                    (hireg_readl(base, ofs) & _mask) >> (_shift); })
#endif
#define local_lock_init(ld)
#define local_lock_exit(ld)

#define local_lock(ld) 
#define local_unlock(ld) 



#endif


