/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_reg.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2009/03/11
  Description   :
  History       :
  1.Date        : 2009/03/11
    Author      : x00100808
    Modification: Created file

******************************************************************************/

#ifndef __VOU_REG_H__
#define __VOU_REG_H__

#include "hi_type.h"

#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */


/*****************************************************************************
 Prototype       : TOP REGISTER

 Description     : VOCTRL           VOƼĴ
                   VOINTSTA         VOж״̬
                   VOINTMSK         VOUжμĴ
                   VOUVERSION1      VOU汾Ĵ1
                   VOUVERSION2      VOU汾Ĵ2
                   VOMUX            VOӿڸѡĴ
                   VODEBUG          debugĴ
                   VOPARAUP         ϵLUTصļĴʹ
                   VHDHCOEFAD       VHDˮƽȡˮƽɫ˲ϵַ
                   VHDVCOEFAD       VHDֱȡˮƽɫ˲ϵַ
                   VADHCOEFAD       VADˮƽȡˮƽɫ˲ϵַ
                   VADVCOEFAD       VADֱȡˮƽɫ˲ϵַ
                   DHDACCAD         DHDͨACCϵұַ
                   DADACCAD         DHDͨACCϵұַ

 History        :

*****************************************************************************/

// Define the union U_VOCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    arb_mode              : 4   ; // [3..0]
        unsigned int    outstd                : 3   ; // [6..4]
        unsigned int    Reserved_1            : 1   ; // [7]
        unsigned int    axi_rid0              : 4   ; // [11..8]
        unsigned int    axi_rid1              : 4   ; // [15..12]
        unsigned int    axi_wid0              : 4   ; // [19..16]
        unsigned int    Reserved_0            : 4   ; // [23..20]
        unsigned int    hc_rid_sel            : 1   ; // [24]
        unsigned int    g3_rid_sel            : 1   ; // [25]
        unsigned int    g2_rid_sel            : 1   ; // [26]
        unsigned int    g1_rid_sel            : 1   ; // [27]
        unsigned int    g0_rid_sel            : 1   ; // [28]
        unsigned int    vsd_rid_sel           : 1   ; // [29]
        unsigned int    vad_rid_sel           : 1   ; // [30]
        unsigned int    vhd_rid_sel           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VOCTRL;

// Define the union U_VOINTSTA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    dsdvtthd_int          : 1   ; // [0]
        unsigned int    dsduf_int             : 1   ; // [1]
        unsigned int    dadvtthd_int          : 1   ; // [2]
        unsigned int    daduf_int             : 1   ; // [3]
        unsigned int    dhdvtthd_int          : 1   ; // [4]
        unsigned int    dhduf_int             : 1   ; // [5]
        unsigned int    Reserved_2            : 2   ; // [7..6]
        unsigned int    vtrr_int              : 1   ; // [8]
        unsigned int    vte_int               : 1   ; // [9]
        unsigned int    Reserved_1            : 2   ; // [11..10]
        unsigned int    vsdrd_int             : 1   ; // [12]
        unsigned int    vadrd_int             : 1   ; // [13]
        unsigned int    vhdrd_int             : 1   ; // [14]
        unsigned int    g0rd_int              : 1   ; // [15]
        unsigned int    g1rd_int              : 1   ; // [16]
        unsigned int    g2rd_int              : 1   ; // [17]
        unsigned int    g3rd_int              : 1   ; // [18]
        unsigned int    hcrd_int              : 1   ; // [19]
        unsigned int    vsdrr_int             : 1   ; // [20]
        unsigned int    vadrr_int             : 1   ; // [21]
        unsigned int    vhdrr_int             : 1   ; // [22]
        unsigned int    g0rr_int              : 1   ; // [23]
        unsigned int    g1rr_int              : 1   ; // [24]
        unsigned int    g2rr_int              : 1   ; // [25]
        unsigned int    g3rr_int              : 1   ; // [26]
        unsigned int    hcrr_int              : 1   ; // [27]
        unsigned int    Reserved_0            : 2   ; // [29..28]
        unsigned int    vbierr_int            : 1   ; // [30]
        unsigned int    be_int                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VOINTSTA;

// Define the union U_VOINTMSK
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    dsdvtthd_intmsk       : 1   ; // [0]
        unsigned int    dsduf_intmsk          : 1   ; // [1]
        unsigned int    dadvtthdg_intmsk      : 1   ; // [2]
        unsigned int    daduf_intmsk          : 1   ; // [3]
        unsigned int    dhdvtthd_intmsk       : 1   ; // [4]
        unsigned int    dhduf_intmsk          : 1   ; // [5]
        unsigned int    Reserved_2            : 2   ; // [7..6]
        unsigned int    vtrr_intmsk           : 1   ; // [8]
        unsigned int    vte_intmsk            : 1   ; // [9]
        unsigned int    Reserved_1            : 2   ; // [11..10]
        unsigned int    vsdrd_intmsk          : 1   ; // [12]
        unsigned int    vadrd_intmsk          : 1   ; // [13]
        unsigned int    vhdrd_intmsk          : 1   ; // [14]
        unsigned int    g0rd_intmsk           : 1   ; // [15]
        unsigned int    g1rd_intmsk           : 1   ; // [16]
        unsigned int    g2rd_intmsk           : 1   ; // [17]
        unsigned int    g3rd_intmsk           : 1   ; // [18]
        unsigned int    hcrd_intmsk           : 1   ; // [19]
        unsigned int    vsdrr_intmsk          : 1   ; // [20]
        unsigned int    vadrr_intmsk          : 1   ; // [21]
        unsigned int    vhdrr_intmsk          : 1   ; // [22]
        unsigned int    g0rr_intmsk           : 1   ; // [23]
        unsigned int    g1rr_intmsk           : 1   ; // [24]
        unsigned int    g2rr_intmsk           : 1   ; // [25]
        unsigned int    g3rr_intmsk           : 1   ; // [26]
        unsigned int    hcrr_intmsk           : 1   ; // [27]
        unsigned int    Reserved_0            : 2   ; // [29..28]
        unsigned int    vbierr_int            : 1   ; // [30]
        unsigned int    be_intmsk             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VOINTMSK;

// Define the union U_VODEBUG
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    rm_enable           : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VODEBUG;

// Define the union U_VOMUX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    dac0_mux              : 1   ; // [0]
        unsigned int    dac1_mux              : 1   ; // [1]
        unsigned int    dac2_mux              : 1   ; // [2]
        unsigned int    Reserved_0            : 3   ; // [5..3]
        unsigned int    bt1120_mux            : 1   ; // [6]
        unsigned int    Reserved_1            : 1   ; // [7]
        unsigned int    dac3_mux              : 2   ; // [9..8]
        unsigned int    dac4_mux              : 2   ; // [11..10]
        unsigned int    dac5_mux              : 2   ; // [13..12]
        unsigned int    Reserved_2            : 18  ; // [31..14]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VOMUX;

// Define the union U_VOPARAUP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhd_hcoef_upd         : 1   ; // [0]
        unsigned int    vhd_vcoef_upd         : 1   ; // [1]
        unsigned int    vad_hcoef_upd         : 1   ; // [2]
        unsigned int    vad_vcoef_upd         : 1   ; // [3]
        unsigned int    dhd_acc_upd           : 1   ; // [4]
        unsigned int    dad_acc_upd           : 1   ; // [5]
        unsigned int    Reserved_0            : 26  ; // [31..6]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VOPARAUP;

/* add by l67259 */
// Define the union U_VHDHCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDHCOEFAD;

// Define the union U_VHDVCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDVCOEFAD;

// Define the union U_VADHCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADHCOEFAD;

// Define the union U_VADVCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADVCOEFAD;

// Define the union U_ACCAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_ACCAD;


// Define the union U_G0HCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0HCOEFAD;

// Define the union U_G0CLUTAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0CLUTAD;

// Define the union U_G1HCOEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1HCOEFAD;

// Define the union U_G2CLUTAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2CLUTAD;

// Define the union U_G3CLUTAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3CLUTAD;



/*****************************************************************************
 Prototype       : VDC_HD REGISTER

 Description     : VHDCTRL



 History        :

*****************************************************************************/

// Define the union U_VHDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 4   ; // [3..0]
        unsigned int    Reserved_1            : 8   ; // [11..4]
        unsigned int    chm_rmode             : 2   ; // [13..12]
        unsigned int    lm_rmode              : 2   ; // [15..14]
        unsigned int    bfield_first          : 1   ; // [16]
        unsigned int    regup_rate            : 1   ; // [17]
        unsigned int    Reserved_0            : 13  ; // [30..18]
        unsigned int    vhd_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCTRL;

// Define the union U_VHDUPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDUPD;

/* add by l67259 */
// Define the union U_VHDLADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdladdr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDLADDR;

// Define the union U_VHDLCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdlcaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDLCADDR;

// Define the union U_VHDCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdcaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCADDR;

// Define the union U_VHDCCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdccaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCCADDR;

// Define the union U_VHDNADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdnaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDNADDR;

// Define the union U_VHDNCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdncaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDNCADDR;

// Define the union U_VHDSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vhdstride             : 16  ; // [15..0]
        unsigned int    vhdcstride            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDSTRIDE;

// Define the union U_VHDCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    edge_proc             : 1   ; // [8]
        unsigned int    Reserved_0            : 23  ; // [31..9]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCBMPARA;

// Define the union U_VHDORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDORESO;

// Define the union U_VHDIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDIRESO;

// Define the union U_VHDSFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDSFPOS;

// Define the union U_VHDDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDDFPOS;

// Define the union U_VHDDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDDLPOS;

// Define the union U_VHDVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xfpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_yfpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDVFPOS;

// Define the union U_VHDVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xlpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_ylpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDVLPOS;

// Define the union U_VHDBK
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vbk_cr                : 8   ; // [7..0]
        unsigned int    vbk_cb                : 8   ; // [15..8]
        unsigned int    vbk_y                 : 8   ; // [23..16]
        unsigned int    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDBK;

// Define the union U_VHDLMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 11  ; // [27..17]
        unsigned int    vlmid_en              : 1   ; // [28]
        unsigned int    hlmid_en              : 1   ; // [29]
        unsigned int    vlmsc_en              : 1   ; // [30]
        unsigned int    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDLMSP;

// Define the union U_VHDCHMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 11  ; // [27..17]
        unsigned int    vchmid_en             : 1   ; // [28]
        unsigned int    hchmid_en             : 1   ; // [29]
        unsigned int    vchmsc_en             : 1   ; // [30]
        unsigned int    hchmsc_en             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCHMSP;

// Define the union U_VHDHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_hratio             : 16  ; // [15..0]
        unsigned int    lm_hphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDLMHSP;

// Define the union U_VHDLMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_vratio             : 16  ; // [15..0]
        unsigned int    lm_vphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDLMVSP;

// Define the union U_VHDCHMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_hratio            : 16  ; // [15..0]
        unsigned int    chm_hphase            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCHMHSP;

// Define the union U_VHDCHMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_vratio            : 16  ; // [15..0]
        unsigned int    chm_vphase            : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDCHMVSP;

// Define the union U_DIECTRL
typedef union
{
    // Define the struct bits
    struct
    {
    	unsigned int    die_reff_cfg          : 1   ; //[0]
        unsigned int    die_reff_cfg_en       : 1   ; //[1]
        unsigned int    Reserved_4            : 14  ; // [15..2]
        unsigned int    stinfo_stop           : 1   ; // [16]
        unsigned int    stinfo_rst            : 1   ; // [17]
        unsigned int    chm_tsmix_en          : 1   ; // [18]
        unsigned int    lm_tflt_en            : 1   ; // [19]
        unsigned int    lm_st_tsmix_en        : 1   ; // [20]
        unsigned int    lm_mov_tsmix_en       : 1   ; // [21]
        unsigned int    Reserved_3            : 1   ; // [22]
        unsigned int    die_rf_mode           : 1   ; // [23]
        unsigned int    die_chmmode           : 1   ; // [24]
        unsigned int    Reserved_2            : 1   ; // [25]
        unsigned int    die_lmmode            : 1   ; // [26]
        unsigned int    Reserved_1            : 1   ; // [27]
        unsigned int    die_frt               : 1   ; // [28]
        unsigned int    Reserved_0            : 1   ; // [29]
        unsigned int    die_chroma_en         : 1   ; // [30]
        unsigned int    die_luma_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DIECTRL;


// Define the union U_DIETHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    md_thd                : 5   ; // [4..0]
        unsigned int    Reserved_2            : 3   ; // [7..5]
        unsigned int    st_thd                : 3   ; // [10..8]
        unsigned int    Reserved_1            : 1   ; // [11]
        unsigned int    med_thd               : 4   ; // [15..12]
        unsigned int    fld_diff_thd          : 6   ; // [21..16]
        unsigned int    Reserved_0            : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DIETHD;

// Define the union U_DIEADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    dieaddr             : 32   ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_DIEADDR;

// Define the union U_MDTFC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    flt_n0             : 4  ; // [3..0]
        unsigned int    flt_n1             : 4  ; // [7..4]
        unsigned int    flt_n2             : 4  ; // [11..8]
        unsigned int    flt_n3             : 4  ; // [15..12]
        unsigned int    flt_n4             : 4  ; // [19..16]
        unsigned int    flt_n5             : 4  ; // [23..20]
        unsigned int    flt_n6             : 4  ; // [27..24]
        unsigned int    flt_n7             : 4  ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_DIEFLT;

// Define the union U_VHDSTATUS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    die_ref_field      : 1  ; // [0]
        unsigned int    reserved_0         : 31 ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_VHDSTATUS;


// Define the union U_MIMGMOD
typedef union U_MIMGMOD
{
    // Define the struct bits
    struct
    {
        unsigned int    brd_width             : 4   ; // [3..0]
        unsigned int    brd_clut              : 2   ; // [5..4]
        unsigned int    Reserved_0            : 26  ; // [31..6]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_MIMGMOD;

// Define the union U_BRDC
typedef union U_BRDC
{
    // Define the struct bits
    struct
    {
        unsigned int    brdc_cr           : 8   ; // [7..0]
        unsigned int    brdc_cb           : 8   ; // [15:8]
        unsigned int    brdc_y            : 8   ; // [23..16]
        unsigned int    Reserved_0        : 8   ; // [31:24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_BRDC;

// Define the union U_MIMGSPOSn
typedef union U_MIMGSPOSn
{
    // Define the struct bits
    struct
    {
        unsigned int    spos_x            : 12  ; // [11..0]
        unsigned int    Reserved_0        : 4   ; // [15:12]
        unsigned int    spos_y            : 12  ; // [27..16]
        unsigned int    die_st_stop       : 1   ; // [28]   hi3515 added function
        unsigned int    die_mode          : 1   ; // [29]
        unsigned int    die_valid         : 1   ; // [30]
        unsigned int    Reserved_2        : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_MIMGSPOSn;


// Define the union U_MIMGFPOSn
typedef union U_MIMGFPOSn
{
    // Define the struct bits
    struct
    {
        unsigned int    fpos_x            : 12  ; // [11..0]
        unsigned int    Reserved_0        : 4   ; // [15:12]
        unsigned int    fpos_y            : 12  ; // [27..16]
        unsigned int    Reserved_1        : 4   ; // [31:28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_MIMGFPOSn;




/*****************************************************************************
 Prototype       : VDC_AD REGISTER

 Description     : VADCTRL



 History        :

*****************************************************************************/

// Define the union U_VADCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 4   ; // [3..0]
        unsigned int    Reserved_1            : 8   ; // [11..4]
        unsigned int    chm_rmode             : 2   ; // [13..12]
        unsigned int    lm_rmode              : 2   ; // [15..14]
        unsigned int    bfield_first          : 1   ; // [16]
        unsigned int    regup_rate            : 1   ; // [17]
        unsigned int    Reserved_0            : 13  ; // [30..18]
        unsigned int    vad_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCTRL;

// Define the union U_VADUPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADUPD;

// Define the union U_VADLADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadladdr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADLADDR;

// Define the union U_VADLCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadlcaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADLCADDR;

// Define the union U_VADCCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadccaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCCADDR;

// Define the union U_VADNADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadnaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADNADDR;

// Define the union U_VADNCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadncaddr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADNCADDR;

// Define the union U_VADADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_VADADDR;

// Define the union U_VADCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadcaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_VADCADDR;

// Define the union U_VADSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vadstride             : 16  ; // [15..0]
        unsigned int    vadcstride            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADSTRIDE;

// Define the union U_VADCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    edge_proc             : 1   ; // [8]
        unsigned int    Reserved_0            : 23  ; // [31..9]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCBMPARA;

// Define the union U_VADORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADORESO;

// Define the union U_VADIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADIRESO;

// Define the union U_VADSFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADSFPOS;

// Define the union U_VADDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADDFPOS;

// Define the union U_VADDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADDLPOS;

// Define the union U_VADVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xfpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_yfpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADVFPOS;

// Define the union U_VADVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xlpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_ylpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADVLPOS;

// Define the union U_VADBK
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vbk_cr                : 8   ; // [7..0]
        unsigned int    vbk_cb                : 8   ; // [15..8]
        unsigned int    vbk_y                 : 8   ; // [23..16]
        unsigned int    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADBK;

// Define the union U_VADLMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 11  ; // [27..17]
        unsigned int    vlmid_en              : 1   ; // [28]
        unsigned int    hlmid_en              : 1   ; // [29]
        unsigned int    vlmsc_en              : 1   ; // [30]
        unsigned int    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADLMSP;

// Define the union U_VADCHMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 11  ; // [27..17]
        unsigned int    vchmid_en             : 1   ; // [28]
        unsigned int    hchmid_en             : 1   ; // [29]
        unsigned int    vchmsc_en             : 1   ; // [30]
        unsigned int    hchmsc_en             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCHMSP;


// Define the union U_VADLMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_hratio             : 16  ; // [15..0]
        unsigned int    lm_hphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADLMHSP;

// Define the union U_VADLMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_vratio             : 16  ; // [15..0]
        unsigned int    lm_vphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADLMVSP;

// Define the union U_VADCHMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_hratio            : 16  ; // [15..0]
        unsigned int    chm_hphase            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCHMHSP;

// Define the union U_VADCHMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_vratio            : 16  ; // [15..0]
        unsigned int    chm_vphase            : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADCHMVSP;



/*****************************************************************************
 Prototype       : VDC_SD REGISTER

 Description     : VSDCTRL



 History        :

*****************************************************************************/

// Define the union U_VSDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 4   ; // [3..0]
        unsigned int    Reserved_1            : 8   ; // [11..4]
        unsigned int    chm_rmode             : 2   ; // [13..12]
        unsigned int    lm_rmode              : 2   ; // [15..14]
        unsigned int    bfield_first          : 1   ; // [16]
        unsigned int    regup_rate            : 1   ; // [17]
        unsigned int    Reserved_0            : 13  ; // [30..18]
        unsigned int    vsd_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDCTRL;

// Define the union U_VSDUPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDUPD;

// Define the union U_VSDADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vsdaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_VSDADDR;

// Define the union U_VSDCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vsdcaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_VSDCADDR;

// Define the union U_VSDSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vsdstride             : 16  ; // [15..0]
        unsigned int    vsdcstride            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDSTRIDE;

// Define the union U_VSDCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    edge_proc             : 1   ; // [8]
        unsigned int    Reserved_0            : 23  ; // [31..9]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDCBMPARA;

// Define the union U_VSDORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDORESO;

// Define the union U_VSDIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDIRESO;

// Define the union U_VSDSFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDSFPOS;

// Define the union U_VSDDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDDFPOS;

// Define the union U_VSDDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDDLPOS;

// Define the union U_VSDVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xfpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_yfpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDVFPOS;

// Define the union U_VSDVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_xlpos           : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    video_ylpos           : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDVLPOS;

// Define the union U_VSDBK
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vbk_cr                : 8   ; // [7..0]
        unsigned int    vbk_cb                : 8   ; // [15..8]
        unsigned int    vbk_y                 : 8   ; // [23..16]
        unsigned int    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDBK;

// Define the union U_VSDLMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    vlmsc_en              : 1   ; // [30]
        unsigned int    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDLMSP;

// Define the union U_VSDCHMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    vchmsc_en             : 1   ; // [30]
        unsigned int    hchmsc_en             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDCHMSP;

// Define the union U_VSDLMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_hratio             : 16  ; // [15..0]
        unsigned int    lm_hphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDLMHSP;

// Define the union U_VSDLMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_vratio             : 16  ; // [15..0]
        unsigned int    lm_vphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDLMVSP;

// Define the union U_VSDCHMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_hratio            : 16  ; // [15..0]
        unsigned int    chm_hphase            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDCHMHSP;

// Define the union U_VSDCHMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_vratio            : 16  ; // [15..0]
        unsigned int    chm_vphase            : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VSDCHMVSP;



/*****************************************************************************
 Prototype       : GDC_G0 REGISTER

 Description     : G0CTRL



 History        :

*****************************************************************************/

// Define the union U_G0CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 8   ; // [7..0]
        unsigned int    bitext                : 2   ; // [9..8]
        unsigned int    Reserved_0            : 19  ; // [28..10]
        unsigned int    csc_mode              : 1   ; // [29]
        unsigned int    csc_en                : 1   ; // [30]
        unsigned int    g0_en                 : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0CTRL;

// Define the union U_G0UPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0UPD;

// Define the union U_G0ADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g0addr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_G0ADDR;

// Define the union U_G0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g0stride              : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0STRIDE;

// Define the union U_G0CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    palpha_range          : 1   ; // [8]
        unsigned int    Reserved_1            : 2   ; // [10..9]
        unsigned int    edge_proc             : 1   ; // [11]
        unsigned int    palpha_en             : 1   ; // [12]
        unsigned int    premult_en            : 1   ; // [13]
        unsigned int    key_en                : 1   ; // [14]
        unsigned int    key_mode              : 1   ; // [15]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0CBMPARA;

// Define the union U_G0KEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_max              : 8   ; // [7..0]
        unsigned int    keyg_max              : 8   ; // [15..8]
        unsigned int    keyr_max              : 8   ; // [23..16]
        unsigned int    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0CKEYMAX;

// Define the union U_G0CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_min              : 8   ; // [7..0]
        unsigned int    keyg_min              : 8   ; // [15..8]
        unsigned int    keyr_min              : 8   ; // [23..16]
        unsigned int    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0CKEYMIN;

// Define the union U_G0IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0IRESO;

// Define the union U_G0ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0ORESO;

// Define the union U_G0SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0SFPOS;

// Define the union U_G0FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0DFPOS;

// Define the union U_G0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos            : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0DLPOS;

// Define the union U_G0HSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hratio                : 16  ; // [15..0]
        unsigned int    hsc_en                : 1   ; // [16]
        unsigned int    hsc_alpha_en          : 1   ; // [17]
        unsigned int    hmid_en               : 1   ; // [18]
        unsigned int    Reserved_0            : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0HSP;


/*****************************************************************************
 Prototype       : GDC_G1 REGISTER

 Description     : G1CTRL



 History        :

*****************************************************************************/

// Define the union U_G1CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 8   ; // [7..0]
        unsigned int    bitext                : 2   ; // [9..8]
        unsigned int    Reserved_0            : 19  ; // [28..10]
        unsigned int    csc_mode              : 1   ; // [29]
        unsigned int    csc_en                : 1   ; // [30]
        unsigned int    g1_en                 : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1CTRL;

// Define the union U_G1UPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1UPD;

// Define the union U_G1ADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g1addr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_G1ADDR;

// Define the union U_G1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g1stride              : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1STRIDE;

// Define the union U_G1CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    palpha_range          : 1   ; // [8]
        unsigned int    Reserved_1            : 2   ; // [10..9]
        unsigned int    edge_proc             : 1   ; // [11]
        unsigned int    palpha_en             : 1   ; // [12]
        unsigned int    premult_en            : 1   ; // [13]
        unsigned int    key_en                : 1   ; // [14]
        unsigned int    key_mode              : 1   ; // [15]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1CBMPARA;

// Define the union U_G1KEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_max              : 8   ; // [7..0]
        unsigned int    keyg_max              : 8   ; // [15..8]
        unsigned int    keyr_max              : 8   ; // [23..16]
        unsigned int    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1CKEYMAX;

// Define the union U_G1CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_min              : 8   ; // [7..0]
        unsigned int    keyg_min              : 8   ; // [15..8]
        unsigned int    keyr_min              : 8   ; // [23..16]
        unsigned int    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1CKEYMIN;

// Define the union U_G1IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1IRESO;

// Define the union U_G1ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1ORESO;

// Define the union U_G1SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1SFPOS;

// Define the union U_G1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1DFPOS;

// Define the union U_G1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1DLPOS;

// Define the union U_G1HSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hratio                : 16  ; // [15..0]
        unsigned int    hsc_en                : 1   ; // [16]
        unsigned int    hsc_alpha_en          : 1   ; // [17]
        unsigned int    hmid_en               : 1   ; // [18]
        unsigned int    Reserved_0            : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1HSP;


/*****************************************************************************
 Prototype       : GDC_G2 REGISTER

 Description     : G2CTRL



 History        :

*****************************************************************************/

// Define the union U_G2CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 8   ; // [7..0]
        unsigned int    bitext                : 2   ; // [9..8]
        unsigned int    Reserved_0            : 19  ; // [28..10]
        unsigned int    csc_mode              : 1   ; // [29]
        unsigned int    csc_en                : 1   ; // [30]
        unsigned int    g2_en                 : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2CTRL;

// Define the union U_G2UPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2UPD;

// Define the union U_G2ADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g2addr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_G2ADDR;

// Define the union U_G2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g2stride              : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2STRIDE;

// Define the union U_G2CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    palpha_range          : 1   ; // [8]
        unsigned int    Reserved_1            : 2   ; // [10..9]
        unsigned int    edge_proc             : 1   ; // [11]
        unsigned int    palpha_en             : 1   ; // [12]
        unsigned int    premult_en            : 1   ; // [13]
        unsigned int    key_en                : 1   ; // [14]
        unsigned int    key_mode              : 1   ; // [15]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2CBMPARA;

// Define the union U_G2KEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_max              : 8   ; // [7..0]
        unsigned int    keyg_max              : 8   ; // [15..8]
        unsigned int    keyr_max              : 8   ; // [23..16]
        unsigned int    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2CKEYMAX;

// Define the union U_G2CKEYMIN
typedef union
{
    // Define the struct bits
    struct

    {
        unsigned int    keyb_min              : 8   ; // [7..0]
        unsigned int    keyg_min              : 8   ; // [15..8]
        unsigned int    keyr_min              : 8   ; // [23..16]
        unsigned int    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2CKEYMIN;

// Define the union U_G2IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2IRESO;

// Define the union U_G2ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2ORESO;

// Define the union U_G2SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2SFPOS;

// Define the union U_G2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2DFPOS;

// Define the union U_G2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2DLPOS;

// Define the union U_G2HSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hratio                : 16  ; // [15..0]
        unsigned int    hsc_en                : 1   ; // [16]
        unsigned int    hsc_alpha_en          : 1   ; // [17]
        unsigned int    hmid_en               : 1   ; // [18]
        unsigned int    Reserved_0            : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G2HSP;


/*****************************************************************************
 Prototype       : GDC_G3 REGISTER

 Description     : G3CTRL



 History        :

*****************************************************************************/

// Define the union U_G3CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 8   ; // [7..0]
        unsigned int    bitext                : 2   ; // [9..8]
        unsigned int    Reserved_0            : 19  ; // [28..10]
        unsigned int    csc_mode              : 1   ; // [29]
        unsigned int    csc_en                : 1   ; // [30]
        unsigned int    g3_en                 : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3CTRL;

// Define the union U_G3UPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3UPD;

// Define the union U_G3ADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g3addr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_G3ADDR;

// Define the union U_G3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    g3stride              : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3STRIDE;

// Define the union U_G3CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    palpha_range          : 1   ; // [8]
        unsigned int    Reserved_1            : 2   ; // [10..9]
        unsigned int    edge_proc             : 1   ; // [11]
        unsigned int    palpha_en             : 1   ; // [12]
        unsigned int    premult_en            : 1   ; // [13]
        unsigned int    key_en                : 1   ; // [14]
        unsigned int    key_mode              : 1   ; // [15]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3CBMPARA;

// Define the union U_G3KEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_max              : 8   ; // [7..0]
        unsigned int    keyg_max              : 8   ; // [15..8]
        unsigned int    keyr_max              : 8   ; // [23..16]
        unsigned int    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3CKEYMAX;

// Define the union U_G3CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_min              : 8   ; // [7..0]
        unsigned int    keyg_min              : 8   ; // [15..8]
        unsigned int    keyr_min              : 8   ; // [23..16]
        unsigned int    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3CKEYMIN;

// Define the union U_G3IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3IRESO;

// Define the union U_G3ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3ORESO;

// Define the union U_G3SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3SFPOS;

// Define the union U_G3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3DFPOS;

// Define the union U_G3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3DLPOS;

// Define the union U_G3HSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hratio                : 16  ; // [15..0]
        unsigned int    hsc_en                : 1   ; // [16]
        unsigned int    hsc_alpha_en          : 1   ; // [17]
        unsigned int    hmid_en               : 1   ; // [18]
        unsigned int    Reserved_0            : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G3HSP;


/*****************************************************************************
 Prototype       : GDC_HC REGISTER

 Description     : HCCTRL



 History        :

*****************************************************************************/

// Define the union U_HCCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ifmt                  : 8   ; // [7..0]
        unsigned int    bitext                : 2   ; // [9..8]
        unsigned int    Reserved_0            : 19  ; // [28..10]
        unsigned int    csc_mode              : 1   ; // [29]
        unsigned int    csc_en                : 1   ; // [30]
        unsigned int    hc_en                 : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCCTRL;

// Define the union U_HCUPD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    regup                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCUPD;

// Define the union U_HCADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hcaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_HCADDR;

// Define the union U_HCSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hcstride              : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCSTRIDE;

// Define the union U_HCCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    galpha                : 8   ; // [7..0]
        unsigned int    palpha_range          : 1   ; // [8]
        unsigned int    Reserved_2            : 2   ; // [10..9]
        unsigned int    edge_proc             : 1   ; // [11]
        unsigned int    palpha_en             : 1   ; // [12]
        unsigned int    Reserved_1            : 1   ; // [13]
        unsigned int    key_en                : 1   ; // [14]
        unsigned int    key_mode              : 1   ; // [15]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCCBMPARA;

// Define the union U_HCKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_max              : 8   ; // [7..0]
        unsigned int    keyg_max              : 8   ; // [15..8]
        unsigned int    keyr_max              : 8   ; // [23..16]
        unsigned int    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCCKEYMAX;

// Define the union U_HCCKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    keyb_min              : 8   ; // [7..0]
        unsigned int    keyg_min              : 8   ; // [15..8]
        unsigned int    keyr_min              : 8   ; // [23..16]
        unsigned int    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCCKEYMIN;

// Define the union U_HCIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCIRESO;

// Define the union U_HCORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCORESO;

// Define the union U_HCSFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    src_xfpos             : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    src_yfpos             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCSFPOS;


// Define the union U_HCFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xfpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_yfpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCDFPOS;

// Define the union U_HCLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    disp_xlpos                 : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    disp_ylpos                 : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HCDLPOS;


/*****************************************************************************
 Prototype       : WBC REGISTER

 Description     : WBCCTRL



 History        :

*****************************************************************************/

// Define the union U_WBC0CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    wbc_fmt               : 8   ; // [7..0]
        unsigned int    req_space             : 5   ; // [12..8]
        unsigned int    Reserved_0            : 15  ; // [27..13]
        unsigned int    csc_en                : 1   ; // [28]
        unsigned int    wr_mode               : 1   ; // [29]
        unsigned int    regup_rate            : 1   ; // [30]
        unsigned int    wbc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0CTRL;

// Define the union U_WBC0ADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    wbcaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_WBC0ADDR;

// Define the union U_WBC0CADDR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    wbccaddr             : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

}U_WBC0CADDR;

// Define the union U_WBC0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    wbcstride             : 16  ; // [15..0]
        unsigned int    wbccstride            : 16  ; // [31..16]

    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0STRIDE;

// Define the union U_WBC0ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    ow                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    oh                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0ORESO;

// Define the union U_WBC0IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    iw                    : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    ih                    : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0IRESO;

// Define the union U_WBC0LMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    vlmsc_en              : 1   ; // [30]
        unsigned int    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0LMSP;

// Define the union U_WBC0CHMSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fld_offset            : 16  ; // [15..0]
        unsigned int    shift_field           : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    vchmsc_en             : 1   ; // [30]
        unsigned int    hchmsc_en             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0CHMSP;

// Define the union U_WBC0HSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_hratio             : 16  ; // [15..0]
        unsigned int    lm_hphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0LMHSP;

// Define the union U_WBC0LMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    lm_vratio             : 16  ; // [15..0]
        unsigned int    lm_vphase             : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0LMVSP;

// Define the union U_WBC0CHMHSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_hratio            : 16  ; // [15..0]
        unsigned int    chm_hphase            : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0CHMHSP;

// Define the union U_WBC0CHMVSP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    chm_vratio            : 16  ; // [15..0]
        unsigned int    chm_vphase            : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0CHMVSP;

// Define the union U_WBC0COEFUP
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_vupd             : 1   ; // [0]
        unsigned int    coef_hupd             : 1   ; // [1]
        unsigned int    Reserved_0            : 30  ; // [31..2]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0COEFUP;

// Define the union U_WBC0COEFAD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_addr            : 32  ; // [31..0]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_WBC0COEFAD;


/*****************************************************************************
 Prototype       : CBM REGISTER

 Description     : CBMBKG1
                   CBMBKG2
                   CBMWBC
                   CBCFG

 History        :

*****************************************************************************/

// Define the union U_CBMBKG1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cbm_bkgcr1             : 8   ; // [7..0]
        unsigned int    cbm_bkgcb1            : 8   ; // [15..8]
        unsigned int    cbm_bkgy1            : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CBMBKG1;

// Define the union U_CBMBKG2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cbm_bkgcr2             : 8   ; // [7..0]
        unsigned int    cbm_bkgcb2            : 8   ; // [15..8]
        unsigned int    cbm_bkgy2            : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CBMBKG2;

// Define the union U_CBMWBC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    wbc0_source           : 1   ; // [0]
        unsigned int    Reserved_1            : 3   ; // [3..1]
        unsigned int    wbc0_mode             : 1   ; // [4]
        unsigned int    Reserved_0            : 27  ; // [31..5]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CBMWBC;

// Define the union U_CBCFG
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    mixer_prio0           : 3   ; // [2..0]
        unsigned int    mixer_prio1           : 3   ; // [5..3]
        unsigned int    mixer_prio2           : 3   ; // [8..6]
        unsigned int    mixer_prio3           : 3   ; // [11..9]
        unsigned int    mixer_prio4           : 3   ; // [14..12]
        unsigned int    mixer3_prio           : 1   ; // [15]
        unsigned int    Reserved_1            : 8   ; // [23..16]
        unsigned int    sur_attr0             : 1   ; // [24]
        unsigned int    sur_attr1             : 1   ; // [25]
        unsigned int    sur_attr2             : 1   ; // [26]
        unsigned int    sur_attr3             : 1   ; // [27]
        unsigned int    sur_attr4             : 1   ; // [28]
        unsigned int    sur_attr5             : 1   ; // [29]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CBCFG;


/*****************************************************************************
 Prototype       : DDC_HD REGISTER

 Description     : DHDCTRL




 History        :

*****************************************************************************/

// Define the union U_DHDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    intfdm                : 4   ; // [3..0]
        unsigned int    intfb                 : 2   ; // [5..4]
        unsigned int    synm                  : 1   ; // [6]
        unsigned int    iop                   : 1   ; // [7]
        unsigned int    ivs                   : 1   ; // [8]
        unsigned int    ihs                   : 1   ; // [9]
        unsigned int    idv                   : 1   ; // [10]
        unsigned int    Reserved_1            : 2   ; // [12..11]
        unsigned int    gmmmode               : 1   ; // [13]
        unsigned int    gmmen                 : 1   ; // [14]
        unsigned int    cscen                 : 1   ; // [15]
        unsigned int    clipen                : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    slave_mode            : 1   ; // [30]
        unsigned int    intf_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCTRL;

// Define the union U_DHDVSYNC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vact                  : 12  ; // [11..0]
        unsigned int    vbb                   : 8   ; // [19..12]
        unsigned int    vfb                   : 8   ; // [27..20]

        unsigned int    Reserved_0            : 4   ; // [31..28]

    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDVSYNC;

// Define the union U_DHDHSYNC1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hact                  : 16  ; // [15..0]
        unsigned int    hbb                   : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDHSYNC1;

// Define the union U_DHDHSYNC2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hfb                   : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDHSYNC2;

// Define the union U_DHDVPLUS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    bvact                 : 12  ; // [11..0]
        unsigned int    bvbb                  : 8   ; // [19..12]
        unsigned int    bvfb                  : 8   ; // [27..20]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDVPLUS;

// Define the union U_DHDPWR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hpw                   : 16   ; // [15..0]
        unsigned int    vpw                   : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDPWR;

// Define the union U_DHDFIFOTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    aalmthd               : 12  ; // [11..0]
        unsigned int    Reserved_0            : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDFIFOTHD;

// Define the union U_DHDVTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vtmgthd               : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    thd_mode              : 1   ; // [16]
        unsigned int    Reserved_0            : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDVTTHD;

// Define the union U_DHDCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscidc0               : 9   ; // [8..0]
        unsigned int    cscidc1               : 9   ; // [17..9]
        unsigned int    cscidc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCIDC;

// Define the union U_DHDCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscodc0               : 9   ; // [8..0]
        unsigned int    cscodc1               : 9   ; // [17..9]
        unsigned int    cscodc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCODC;

// Define the union U_DHDCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp00                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp01                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCP0;

// Define the union U_DHDCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp02                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp10                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCP1;

// Define the union U_DHDCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp11                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp12                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCP2;

// Define the union U_DHDCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp20                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp21                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCP3;

// Define the union U_DHDCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp22                : 13  ; // [12..0]
        unsigned int    Reserved_0            : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCSCP4;

// Define the union U_DHDCLIPL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipcl0               : 10  ; // [9..0]
        unsigned int    clipcl1               : 10  ; // [19..10]
        unsigned int    clipcl2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCLIPL;

// Define the union U_DHDCLIPH
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipch0               : 10  ; // [9..0]
        unsigned int    clipch1               : 10  ; // [19..10]
        unsigned int    clipch2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDCLIPH;

// Define the union U_GMMTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    thd_low               : 10  ; // [9..0]
        unsigned int    thd_high              : 10  ; // [19..10]
        unsigned int    thd_med_low           : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_GMMTHD1;

// Define the union U_GMMTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    thd_med_high          : 10  ; // [9..0]
        unsigned int    gmm_multiple          : 8   ; // [17..10]
        unsigned int    Reserved_0            : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_GMMTHD2;


/*****************************************************************************
 Prototype       : DDC_AD REGISTER

 Description     : DADCTRL




 History        :

*****************************************************************************/

// Define the union U_DADCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    intfdm                : 4   ; // [3..0]
        unsigned int    intfb                 : 2   ; // [5..4]
        unsigned int    synm                  : 1   ; // [6]
        unsigned int    iop                   : 1   ; // [7]
        unsigned int    ivs                   : 1   ; // [8]
        unsigned int    ihs                   : 1   ; // [9]
        unsigned int    idv                   : 1   ; // [10]
        unsigned int    Reserved_1            : 2   ; // [12..11]
        unsigned int    gmmmode               : 1   ; // [13]
        unsigned int    gmmen                 : 1   ; // [14]
        unsigned int    cscen                 : 1   ; // [15]
        unsigned int    clipen                : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    slave_mode            : 1   ; // [30]
        unsigned int    intf_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCTRL;

// Define the union U_DADVSYNC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vact                  : 12  ; // [11..0]
        unsigned int    vbb                   : 8   ; // [19..12]
        unsigned int    vfb                   : 8   ; // [27..20]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADVSYNC;

// Define the union U_DADHSYNC1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hact                  : 16  ; // [15..0]
        unsigned int    hbb                   : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADHSYNC1;

// Define the union U_DADHSYNC2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hfb                   : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADHSYNC2;

// Define the union U_DADVPLUS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    bvact                 : 12  ; // [11..0]
        unsigned int    bvbb                  : 8   ; // [19..12]
        unsigned int    bvfb                  : 8   ; // [27..20]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADVPLUS;

// Define the union U_DADPWR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hpw                   : 16   ; // [15..0]
        unsigned int    vpw                   : 8   ; // [23..15]
        unsigned int    Reserved_0            : 8  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADPWR;

// Define the union U_DADFIFOTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    aalmthd               : 12  ; // [11..0]
        unsigned int    Reserved_0            : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADFIFOTHD;

// Define the union U_DADVTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vtmgthd               : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    thd_mode              : 1   ; // [16]
        unsigned int    Reserved_0            : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADVTTHD;

// Define the union U_DADCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscidc0               : 9   ; // [8..0]
        unsigned int    cscidc1               : 9   ; // [17..9]
        unsigned int    cscidc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCIDC;

// Define the union U_DADCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscodc0               : 9   ; // [8..0]
        unsigned int    cscodc1               : 9   ; // [17..9]
        unsigned int    cscodc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCODC;

// Define the union U_DADCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp00                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp01                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCP0;

// Define the union U_DADCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp02                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp10                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCP1;

// Define the union U_DADCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp11                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp12                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCP2;

// Define the union U_DADCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp20                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp21                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCP3;

// Define the union U_DADCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp22                : 13  ; // [12..0]
        unsigned int    Reserved_0            : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCSCP4;

// Define the union U_DADCLIPL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipcl0               : 10  ; // [9..0]
        unsigned int    clipcl1               : 10  ; // [19..10]
        unsigned int    clipcl2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCLIPL;

// Define the union U_DADCLIPH
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipch0               : 10  ; // [9..0]
        unsigned int    clipch1               : 10  ; // [19..10]
        unsigned int    clipch2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DADCLIPH;


/*****************************************************************************
 Prototype       : DDC_SD REGISTER

 Description     : DSDCTRL




 History        :

*****************************************************************************/

// Define the union U_DSDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    intfdm                : 4   ; // [3..0]
        unsigned int    intfb                 : 2   ; // [5..4]
        unsigned int    synm                  : 1   ; // [6]
        unsigned int    iop                   : 1   ; // [7]
        unsigned int    ivs                   : 1   ; // [8]
        unsigned int    ihs                   : 1   ; // [9]
        unsigned int    idv                   : 1   ; // [10]
        unsigned int    Reserved_1            : 3   ; // [13..11]
        unsigned int    gmmen                 : 1   ; // [14]
        unsigned int    cscen                 : 1   ; // [15]
        unsigned int    clipen                : 1   ; // [16]
        unsigned int    Reserved_0            : 13  ; // [29..17]
        unsigned int    slave_mode            : 1   ; // [30]
        unsigned int    intf_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCTRL;

// Define the union U_DSDVSYNC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vact                  : 12  ; // [11..0]
        unsigned int    vbb                   : 8   ; // [19..12]
        unsigned int    vfb                   : 8   ; // [27..20]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDVSYNC;

// Define the union U_DSDHSYNC1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hact                  : 16  ; // [15..0]
        unsigned int    hbb                   : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDHSYNC1;

// Define the union U_DSDHSYNC2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hfb                   : 16  ; // [15..0]
        unsigned int    Reserved_0            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDHSYNC2;

// Define the union U_DSDVPLUS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    bvact                 : 12  ; // [11..0]
        unsigned int    bvbb                  : 8   ; // [19..12]
        unsigned int    bvfb                  : 8   ; // [27..20]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDVPLUS;

// Define the union U_DSDPWR
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hpw                   : 16   ; // [15..0]
        unsigned int    vpw                   : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8  ; // [31..16]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDPWR;

// Define the union U_DSDFIFOTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    aalmthd               : 12  ; // [11..0]
        unsigned int    Reserved_0            : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDFIFOTHD;

// Define the union U_DSDVTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vtmgthd               : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    thd_mode              : 1   ; // [16]
        unsigned int    Reserved_0            : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDVTTHD;

// Define the union U_DSDCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscidc0               : 9   ; // [8..0]
        unsigned int    cscidc1               : 9   ; // [17..9]
        unsigned int    cscidc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCIDC;

// Define the union U_DSDCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscodc0               : 9   ; // [8..0]
        unsigned int    cscodc1               : 9   ; // [17..9]
        unsigned int    cscodc2               : 9   ; // [26..18]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCODC;

// Define the union U_DSDCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp00                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp01                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCP0;

// Define the union U_DSDCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp02                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp10                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCP1;

// Define the union U_DSDCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp11                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp12                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCP2;

// Define the union U_DSDCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp20                : 13  ; // [12..0]
        unsigned int    Reserved_1            : 3   ; // [15..13]
        unsigned int    cscp21                : 13  ; // [28..16]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCP3;

// Define the union U_DSDCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cscp22                : 13  ; // [12..0]
        unsigned int    Reserved_0            : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCSCP4;

// Define the union U_DSDCLIPL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipcl0               : 10  ; // [9..0]
        unsigned int    clipcl1               : 10  ; // [19..10]
        unsigned int    clipcl2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCLIPL;

// Define the union U_DSDCLIPH
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    clipch0               : 10  ; // [9..0]
        unsigned int    clipch1               : 10  ; // [19..10]
        unsigned int    clipch2               : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DSDCLIPH;


/*****************************************************************************
 Prototype       : VHD COEF REGISTER

 Description     : VHDHLCOEF
                   VHDHCCOEF
                   VHDVLCOEF
                   VHDVCCOEF




 History        :

*****************************************************************************/

// Define the union U_VHDHLCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HLCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HLCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDHLCOEF;

// Define the union U_VHDHCCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HCCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HCCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDHCCOEF;

// Define the union U_VHDVLCOEF
typedef union
{
    // Define the struct bits

    struct
    {
        unsigned int    VLCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    VLCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDVLCOEF;

// Define the union U_VHDVCCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    VCCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    VCCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VHDVCCOEF;


/*****************************************************************************
 Prototype       : VAD COEF REGISTER

 Description     : VADHLCOEF
                   VADHCCOEF
                   VADVLCOEF
                   VADVCCOEF




 History        :

*****************************************************************************/

// Define the union U_VADHLCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HLCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HLCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADHLCOEF;

// Define the union U_VADHCCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HCCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HCCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADHCCOEF;

// Define the union U_VADVLCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    VLCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    VLCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADVLCOEF;

// Define the union U_VADVCCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    VCCOEFn1              : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    VCCOEFn2              : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_VADVCCOEF;


/*****************************************************************************
 Prototype       : GRAPHICS LAYER COEF REGISTER

 Description     : G0HCOEF
                   G1HCOEF
                   G2HCOEF
                   G3HCOEF


 History        :

*****************************************************************************/

// Define the union U_G0HCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HCOEFn1               : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HCOEFn2               : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G0HCOEF;

// Define the union U_G1HCOEF
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    HCOEFn1               : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    HCOEFn2               : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_G1HCOEF;


/*****************************************************************************
 Prototype       : GAMMA TABLE REGISTER

 Description     : GMMTABL





 History        :

*****************************************************************************/

// Define the union U_GMMTABLEn
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    table_data1n          : 10  ; // [9..0]
        unsigned int    table_data2n          : 10  ; // [19..10]
        unsigned int    table_data3n          : 10  ; // [29..20]
        unsigned int    Reserved_0            : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_GMMTABLEn;

// Define the union U_GMMSTAT
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cnt_value             : 21  ; // [20..0]
        unsigned int    Reserved_0            : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_GMMSTAT;


/*****************************************************************************
 Prototype       : HD_DATE REGISTER

 Description     : HD_DATE





 History        :

*****************************************************************************/

// Define HD_DATE
// Define the union U_HDATE_EN
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hd_en                 : 1   ; // [0]
        unsigned int    Reserved_0            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_EN;

// Define the union U_HDATE_POLA_CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hsync_in_pola         : 1   ; // [0]
        unsigned int    vsync_in_pola         : 1   ; // [1]
        unsigned int    fid_in_pola           : 1   ; // [2]
        unsigned int    hsync_out_pola        : 1   ; // [3]
        unsigned int    vsync_out_pola        : 1   ; // [4]
        unsigned int    fid_out_pola          : 1   ; // [5]
        unsigned int    Reserved_0            : 26  ; // [31..6]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_POLA_CTRL;

// Define the union U_HDATE_VIDEO_FORMAT
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    video_ft              : 4   ; // [3..0]
        unsigned int    sync_add_ctrl         : 3   ; // [6..4]
        unsigned int    video_out_ctrl        : 2   ; // [8..7]
        unsigned int    csc_ctrl              : 3   ; // [11..9]
        unsigned int    Reserved_0            : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_VIDEO_FORMAT;

// Define the union U_HDATE_STATE
typedef union
{

    // Define the struct bits
    struct
    {
        unsigned int    line_len              : 13  ; // [12..0]
        unsigned int    Reserved_2            : 3   ; // [15..13]
        unsigned int    frame_len             : 11  ; // [26..16]
        unsigned int    Reserved_1            : 1   ; // [27]
        unsigned int    mv_en_pin             : 1   ; // [28]
        unsigned int    Reserved_0            : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_STATE;

// Define the union U_HDATE_OUT_CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vsync_sel             : 2   ; // [1..0]
        unsigned int    hsync_sel             : 2   ; // [3..2]
        unsigned int    video3_sel            : 2   ; // [5..4]
        unsigned int    video2_sel            : 2   ; // [7..6]
        unsigned int    video1_sel            : 2   ; // [9..8]
        unsigned int    src_ctrl              : 2   ; // [11..10]
        unsigned int    sync_lpf_en           : 1   ; // [12]
        unsigned int    sd_sel                : 1   ; // [13]
        unsigned int    Reserved_0            : 18  ; // [31..14]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_OUT_CTRL;

// Define the union U_HDATE_SRC_13_COEF1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap1_1           : 5   ; // [4..0]
        unsigned int    Reserved_1            : 11  ; // [15..5]
        unsigned int    coef_tap1_3           : 5   ; // [20..16]
        unsigned int    Reserved_0            : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF1;

// Define the union U_HDATE_SRC_13_COEF2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap2_1           : 6   ; // [5..0]
        unsigned int    Reserved_1            : 10  ; // [15..6]
        unsigned int    coef_tap2_3           : 6   ; // [21..16]
        unsigned int    Reserved_0            : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF2;

// Define the union U_HDATE_SRC_13_COEF3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap3_1           : 7   ; // [6..0]
        unsigned int    Reserved_1            : 9   ; // [15..7]
        unsigned int    coef_tap3_3           : 7   ; // [22..16]
        unsigned int    Reserved_0            : 9   ; // [31..23]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF3;

// Define the union U_HDATE_SRC_13_COEF4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap4_1           : 8   ; // [7..0]
        unsigned int    Reserved_1            : 8   ; // [15..8]
        unsigned int    coef_tap4_3           : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF4;

// Define the union U_HDATE_SRC_13_COEF5
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap5_1           : 9   ; // [8..0]
        unsigned int    Reserved_1            : 7   ; // [15..9]
        unsigned int    coef_tap5_3           : 9   ; // [24..16]
        unsigned int    Reserved_0            : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF5;

// Define the union U_HDATE_SRC_13_COEF6
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap6_1           : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    coef_tap6_3           : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF6;

// Define the union U_HDATE_SRC_13_COEF7
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap7_1           : 11  ; // [10..0]
        unsigned int    Reserved_1            : 5   ; // [15..11]
        unsigned int    coef_tap7_3           : 11  ; // [26..16]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF7;

// Define the union U_HDATE_SRC_13_COEF8
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap8_1           : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    coef_tap8_3           : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF8;

// Define the union U_HDATE_SRC_13_COEF9
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap9_1           : 9   ; // [8..0]
        unsigned int    Reserved_1            : 7   ; // [15..9]
        unsigned int    coef_tap9_3           : 9   ; // [24..16]
        unsigned int    Reserved_0            : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF9;

// Define the union U_HDATE_SRC_13_COEF10
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap10_1          : 8   ; // [7..0]
        unsigned int    Reserved_1            : 8   ; // [15..8]
        unsigned int    coef_tap10_3          : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF10;

// Define the union U_HDATE_SRC_13_COEF11
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap11_1          : 7   ; // [6..0]
        unsigned int    Reserved_1            : 9   ; // [15..7]
        unsigned int    coef_tap11_3          : 7   ; // [22..16]
        unsigned int    Reserved_0            : 9   ; // [31..23]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF11;

// Define the union U_HDATE_SRC_13_COEF12
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap12_1          : 6   ; // [5..0]
        unsigned int    Reserved_1            : 10  ; // [15..6]
        unsigned int    coef_tap12_3          : 6   ; // [21..16]
        unsigned int    Reserved_0            : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF12;

// Define the union U_HDATE_SRC_13_COEF13
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap13_1          : 5   ; // [4..0]
        unsigned int    Reserved_1            : 11  ; // [15..5]
        unsigned int    coef_tap13_3          : 5   ; // [20..16]
        unsigned int    Reserved_0            : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_13_COEF13;

// Define the union U_HDATE_SRC_24_COEF1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap1_2           : 5   ; // [4..0]
        unsigned int    Reserved_1            : 11  ; // [15..5]
        unsigned int    coef_tap1_4           : 5   ; // [20..16]
        unsigned int    Reserved_0            : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF1;

// Define the union U_HDATE_SRC_24_COEF2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap2_2           : 6   ; // [5..0]
        unsigned int    Reserved_1            : 10  ; // [15..6]
        unsigned int    coef_tap2_4           : 6   ; // [21..16]
        unsigned int    Reserved_0            : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF2;

// Define the union U_HDATE_SRC_24_COEF3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap3_2           : 7   ; // [6..0]
        unsigned int    Reserved_1            : 9   ; // [15..7]
        unsigned int    coef_tap3_4           : 7   ; // [22..16]
        unsigned int    Reserved_0            : 9   ; // [31..23]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF3;

// Define the union U_HDATE_SRC_24_COEF4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap4_2           : 8   ; // [7..0]
        unsigned int    Reserved_1            : 8   ; // [15..8]
        unsigned int    coef_tap4_4           : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF4;

// Define the union U_HDATE_SRC_24_COEF5
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap5_2           : 9   ; // [8..0]
        unsigned int    Reserved_1            : 7   ; // [15..9]
        unsigned int    coef_tap5_4           : 9   ; // [24..16]
        unsigned int    Reserved_0            : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF5;

// Define the union U_HDATE_SRC_24_COEF6
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap6_2           : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    coef_tap6_4           : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF6;

// Define the union U_HDATE_SRC_24_COEF7
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap7_2           : 11  ; // [10..0]
        unsigned int    Reserved_1            : 5   ; // [15..11]
        unsigned int    coef_tap7_4           : 11  ; // [26..16]
        unsigned int    Reserved_0            : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF7;

// Define the union U_HDATE_SRC_24_COEF8
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap8_2           : 10  ; // [9..0]
        unsigned int    Reserved_1            : 6   ; // [15..10]
        unsigned int    coef_tap8_4           : 10  ; // [25..16]
        unsigned int    Reserved_0            : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF8;

// Define the union U_HDATE_SRC_24_COEF9
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap9_2           : 9   ; // [8..0]
        unsigned int    Reserved_1            : 7   ; // [15..9]
        unsigned int    coef_tap9_4           : 9   ; // [24..16]
        unsigned int    Reserved_0            : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF9;

// Define the union U_HDATE_SRC_24_COEF10
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap10_2          : 8   ; // [7..0]
        unsigned int    Reserved_1            : 8   ; // [15..8]
        unsigned int    coef_tap10_4          : 8   ; // [23..16]
        unsigned int    Reserved_0            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF10;

// Define the union U_HDATE_SRC_24_COEF11
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap11_2          : 7   ; // [6..0]
        unsigned int    Reserved_1            : 9   ; // [15..7]
        unsigned int    coef_tap11_4          : 7   ; // [22..16]
        unsigned int    Reserved_0            : 9   ; // [31..23]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF11;

// Define the union U_HDATE_SRC_24_COEF12
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap12_2          : 6   ; // [5..0]
        unsigned int    Reserved_1            : 10  ; // [15..6]
        unsigned int    coef_tap12_4          : 6   ; // [21..16]
        unsigned int    Reserved_0            : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF12;

// Define the union U_HDATE_SRC_24_COEF13
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    coef_tap13_2          : 5   ; // [4..0]
        unsigned int    Reserved_1            : 11  ; // [15..5]
        unsigned int    coef_tap13_4          : 5   ; // [20..16]
        unsigned int    Reserved_0            : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_SRC_24_COEF13;

// Define the union U_HDATE_CSC_COEF1
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    csc_coef_r_y          : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    csc_coef_r_cb         : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CSC_COEF1;

// Define the union U_HDATE_CSC_COEF2
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    csc_coef_r_cr         : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    csc_coef_g_y          : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CSC_COEF2;

// Define the union U_HDATE_CSC_COEF3
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    csc_coef_g_cb         : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    csc_coef_g_cr         : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CSC_COEF3;

// Define the union U_HDATE_CSC_COEF4
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    csc_coef_b_y          : 12  ; // [11..0]
        unsigned int    Reserved_1            : 4   ; // [15..12]
        unsigned int    csc_coef_b_cb         : 12  ; // [27..16]
        unsigned int    Reserved_0            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CSC_COEF4;

// Define the union U_HDATE_CSC_COEF5
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    csc_coef_b_cr         : 12  ; // [11..0]
        unsigned int    Reserved_0            : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CSC_COEF5;

// Define the union U_HDATE_TEST
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    test_data             : 10  ; // [9..0]
        unsigned int    Reserved_0            : 22  ; // [31..10]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_TEST;

// Define the union U_HDATE_VBI_CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cgmsb_add_en          : 1   ; // [0]
        unsigned int    cgmsa_add_en          : 1   ; // [1]
        unsigned int    mv_en                 : 1   ; // [2]
        unsigned int    vbi_lpf_en            : 1   ; // [3]
        unsigned int    Reserved_0            : 28  ; // [31..4]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_VBI_CTRL;

// Define the union U_HDATE_CGMSA_DATA
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    cgmsa_data            : 20  ; // [19..0]
        unsigned int    Reserved_0            : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CGMSA_DATA;

// Define the union U_HDATE_CGMSB_H
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    hdate_cgmsb_h         : 6   ; // [5..0]
        unsigned int    Reserved_0            : 26  ; // [31..6]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_HDATE_CGMSB_H;

/*****************************************************************************
 Prototype       : AD_DATE REGISTER

 Description     : AD_DATE





 History        :

*****************************************************************************/

// Define the union U_ADATE_NORM
typedef union
{
    // Define an unsigned member
    unsigned int    u32;

} U_ADATE_NORM;



/*****************************************************************************
 Prototype       : SD_DATE REGISTER

 Description     : SD_DATE





 History        :

*****************************************************************************/

// Define the union U_SDATE_NORM
typedef union
{
    // Define an unsigned member
    unsigned int    u32;

} U_SDATE_NORM;


/*****************************************************************************
 Prototype       : CCD REGISTER

 Description     : CCD





 History        :

*****************************************************************************/

// Define the union U_CCDIMGMOD
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    img_mode              : 7   ; // [6..0]
        unsigned int    img_right             : 1   ; // [7..7]
        unsigned int    ccd_en                : 1   ; // [8..8]
        unsigned int    Reserved              : 23  ; // [31..9]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CCDIMGMOD;

// Define the union U_DHDSTATE
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    vback_blank           : 1   ; // [0]
        unsigned int    vblank                : 1   ; // [1]
        unsigned int    bottom_field          : 1   ; // [2]
        unsigned int    Reserved              : 29  ; // [31..3]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_DHDSTATE;

// Define the union U_CCDSPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    spos_x                : 12  ; // [11..0]
        unsigned int    Reserved_0            : 4   ; // [15..12]
        unsigned int    spos_y                : 12  ; // [27..16]
        unsigned int    Reserved_1            : 3   ; // [30..28]
        unsigned int    img_valid             : 1   ; // [31..31]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CCDSPOS;

// Define the union U_CCDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        unsigned int    fpos_x                : 12  ; // [11..0]
        unsigned int    Reserved_0            : 4   ; // [15..12]
        unsigned int    fpos_y                : 12  ; // [27..16]
        unsigned int    Reserved_1            : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    unsigned int    u32;

} U_CCDFPOS;


/*****************************************************************************
 Prototype       : GLOBAL REGISTER STRUCTURE

 Description     : GLOBAL REGISTER





 History        :

*****************************************************************************/

// Define the global struct
typedef struct
{
    /* TOP register                                                         */
     U_VOCTRL               VOCTRL;             // 0x00
     U_VOINTSTA             VOINTSTA;
     U_VOINTMSK             VOINTMSK;
     unsigned int           VOUVERSION1;
     unsigned int           VOUVERSION2;
     unsigned int           reserved01[2];      // 0x14~0x18
     U_VOMUX                VOMUX;
     U_VODEBUG              VODEBUG;
     unsigned int           reserved02[2];      // 0x24~0x28
     U_VOPARAUP             VOPARAUP;           // 0x2c
     U_VHDHCOEFAD           VHDHCOEFAD;
     U_VHDVCOEFAD           VHDVCOEFAD;
     U_VADHCOEFAD           VADHCOEFAD;
     U_VADVCOEFAD           VADVCOEFAD;
     U_ACCAD                DHDACCAD;           // 0x40
     U_ACCAD                DADACCAD;           // 0x44
     unsigned int           reserved0[46];      // 0x48~0xfc


    /* VDC_HD register                                                      */
     U_VHDCTRL              VHDCTRL;            // 0x100
     U_VHDUPD               VHDUPD;
     U_VHDLADDR             VHDLADDR;
     U_VHDLCADDR            VHDLCADDR;
     U_VHDCADDR             VHDCADDR;
     U_VHDCCADDR            VHDCCADDR;
     U_VHDNADDR             VHDNADDR;
     U_VHDNCADDR            VHDNCADDR;
     U_VHDSTRIDE            VHDSTRIDE;
     U_VHDCBMPARA           VHDCBMPARA;         // 0x124
     U_VHDORESO             VHDORESO;
     U_VHDIRESO             VHDIRESO;
     U_VHDSFPOS             VHDSFPOS;
     U_VHDDFPOS             VHDDFPOS;
     U_VHDDLPOS             VHDDLPOS;
     U_VHDVFPOS             VHDVFPOS;
     U_VHDVLPOS             VHDVLPOS;           // 0x144
     U_VHDBK                VHDBK;
     unsigned int           reserved10[2];      // 0x148~0x14c
     U_VHDLMSP              VHDLMSP;            // 0x150
     U_VHDCHMSP             VHDCHMSP;
     U_VHDLMHSP             VHDLMHSP;
     U_VHDLMVSP             VHDLMVSP;
     U_VHDCHMHSP            VHDCHMHSP;
     U_VHDCHMVSP            VHDCHMVSP;
     unsigned int           reserved11[2];      // 0x168~0x16c
     U_DIECTRL              VHDDIECTRL;         // 0x170
     U_DIETHD               VHDDIETHD;
     U_DIEADDR              VHDDIEADDR;
     unsigned int           reserved12;         // 0x17C
     U_DIEFLT               VHDDIETSMIX[4];     // 0x180~0x18c
     U_DIEFLT               VHDDIETFLT[4];      // 0x190~0x19c
     U_DIEFLT               VHDDIEVFLT[4];      // 0x1a0~0x1ac
     unsigned int           reserved13[16];     // 0x1b0~0x1bc 0x1c0~0x1cc 0x1d0~0x1dc 0x1e0~0x1ec
     U_VHDSTATUS            VHDSTATUS;          // 0x1f0
     unsigned int           reserved13_1[3];    // 0x1f4~0x1fc


    /* VDC_AD register                                                      */
     U_VADCTRL              VADCTRL;            // 0x200
     U_VADUPD               VADUPD;
     U_VADLADDR             VADLADDR;
     U_VADLCADDR            VADLCADDR;
     U_VADCADDR             VADCADDR;
     U_VADCCADDR            VADCCADDR;
     U_VADNADDR             VADNADDR;
     U_VADNCADDR            VADNCADDR;
     U_VADSTRIDE            VADSTRIDE;
     U_VADCBMPARA           VADCBMPARA;         // 0x224
     U_VADORESO             VADORESO;
     U_VADIRESO             VADIRESO;
     U_VADSFPOS             VADSFPOS;
     U_VADDFPOS             VADDFPOS;
     U_VADDLPOS             VADDLPOS;
     U_VADVFPOS             VADVFPOS;
     U_VADVLPOS             VADVLPOS;
     U_VADBK                VADBK;              // 0x244
     unsigned int           reserved23[2];      // 0x248~0x24c
     U_VADLMSP              VADLMSP;            // 0x250
     U_VADCHMSP             VADCHMSP;
     U_VADLMHSP             VADLMHSP;
     U_VADLMVSP             VADLMVSP;
     U_VADCHMHSP            VADCHMHSP;
     U_VADCHMVSP            VADCHMVSP;          // 0x264
     unsigned int           reserved20[2];      // 0x268~0x26c
     U_DIECTRL              VADDIECTRL;         // 0x270
     U_DIETHD               VADDIETHD;
     U_DIEADDR              VADDIEADDR;
     unsigned int           reserved24;         // 0x27C
     U_DIEFLT               VADDIETSMIX[4];     // 0x280~0x28c
     U_DIEFLT               VADDIETFLT[4];
     U_DIEFLT               VADDIEVFLT[4];
     unsigned int           reserved25[16];     // 0x2b0~0x2bc 0x2c0~0x2cc 0x2d0~0x2dc 0x2e0~0x2ec
     U_VHDSTATUS            VADSTATUS;          // 0x2f0
     unsigned int           reserved25_1[3];    // 0x2f4~0x2fc


    /* VDC_SD register                                                      */
     U_VSDCTRL              VSDCTRL;            // 0x300
     U_VSDUPD               VSDUPD;
     unsigned int           reserved31[2];      // 0x308~0x30c
     U_VSDADDR              VSDADDR;            // 0x310
     U_VSDCADDR             VSDCADDR;
     unsigned int           reserved32[2];      // 0x318~0x31c
     U_VSDSTRIDE            VSDSTRIDE;          // 0x320
     U_VSDCBMPARA           VSDCBMPARA;
     U_VSDORESO             VSDORESO;
     U_VSDIRESO             VSDIRESO;
     U_VSDSFPOS             VSDSFPOS;
     U_VSDDFPOS             VSDDFPOS;
     U_VSDDLPOS             VSDDLPOS;
     U_VSDVFPOS             VSDVFPOS;
     U_VSDVLPOS             VSDVLPOS;
     U_VSDBK                VSDBK;              // 0x344
     unsigned int           reserved33[46];     // 0x348 0x350 0x360 0x370 0x380 0x390
                                                // 0x3a0 0x3b0 0x3c0 0x3d0 0x3e0 0x3f0

    /* G0 register                                                          */
     U_G0CTRL               G0CTRL;             // 0x400
     U_G0UPD                G0UPD;
     U_G0ADDR               G0ADDR;
     U_G0STRIDE             G0STRIDE;
     U_G0CBMPARA            G0CBMPARA;
     U_G0CKEYMAX            G0CKEYMAX;
     U_G0CKEYMIN            G0CKEYMIN;
     U_G0IRESO              G0IRESO;
     U_G0ORESO              G0ORESO;
     U_G0SFPOS              G0SFPOS;
     U_G0DFPOS              G0DFPOS;
     U_G0DLPOS              G0DLPOS;            // 0x42c
     unsigned int           reserved40[52];     // 0x430~0x4fc


    /* G1 register                                                          */
     U_G1CTRL               G1CTRL;             // 0x500
     U_G1UPD                G1UPD;
     U_G1ADDR               G1ADDR;
     U_G1STRIDE             G1STRIDE;
     U_G1CBMPARA            G1CBMPARA;
     U_G1CKEYMAX            G1CKEYMAX;
     U_G1CKEYMIN            G1CKEYMIN;
     U_G1IRESO              G1IRESO;
     U_G1ORESO              G1ORESO;
     U_G1SFPOS              G1SFPOS;
     U_G1DFPOS              G1DFPOS;
     U_G1DLPOS              G1DLPOS;            // 0x52c
     unsigned int           reserved50[52];     // 0x530~0x5fc


    /* G2 register                                                          */
     U_G2CTRL               G2CTRL;             // 0x600
     U_G2UPD                G2UPD;
     U_G2ADDR               G2ADDR;
     U_G2STRIDE             G2STRIDE;
     U_G2CBMPARA            G2CBMPARA;
     U_G2CKEYMAX            G2CKEYMAX;
     U_G2CKEYMIN            G2CKEYMIN;
     U_G2IRESO              G2IRESO;
     U_G2ORESO              G2ORESO;
     U_G2SFPOS              G2SFPOS;
     U_G2DFPOS              G2DFPOS;
     U_G2DLPOS              G2DLPOS;
     unsigned int           reserved60[52];     //0x630~0x6fc


    /* G3 register                                                          */
     U_G3CTRL               G3CTRL;             // 0x700
     U_G3UPD                G3UPD;
     U_G3ADDR               G3ADDR;
     U_G3STRIDE             G3STRIDE;
     U_G3CBMPARA            G3CBMPARA;
     U_G3CKEYMAX            G3CKEYMAX;
     U_G3CKEYMIN            G3CKEYMIN;
     U_G3IRESO              G3IRESO;
     U_G3ORESO              G3ORESO;
     U_G3SFPOS              G3SFPOS;
     U_G3DFPOS              G3DFPOS;
     U_G3DLPOS              G3DLPOS;
     unsigned int           reserved70[52];    // 0x730~0x7fc


    /* HC register                                                          */
     U_HCCTRL               HCCTRL;             // 0x800
     U_HCUPD                HCUPD;
     U_HCADDR               HCADDR;
     U_HCSTRIDE             HCSTRIDE;
     U_HCCBMPARA            HCCBMPARA;
     U_HCCKEYMAX            HCCKEYMAX;
     U_HCCKEYMIN            HCCKEYMIN;
     U_HCIRESO              HCIRESO;
     U_HCORESO              HCORESO;
     U_HCSFPOS              HCSFPOS;
     U_HCDFPOS              HCDFPOS;
     U_HCDLPOS              HCDLPOS;            // 0x82c
     unsigned int           reserved80[52];     // 0x830~0x900


    /* WBC register                                                         */
     U_WBC0CTRL             WBC0CTRL;           // 0x900
     U_WBC0ADDR             WBC0ADDR;
     U_WBC0CADDR            WBC0CADDR;
     U_WBC0STRIDE           WBC0STRIDE;
     U_WBC0ORESO            WBC0ORESO;
     U_WBC0IRESO            WBC0IRESO;
     U_WBC0LMSP             WBC0LMSP;
     U_WBC0CHMSP            WBC0CHMSP;
     U_WBC0LMHSP            WBC0LMHSP;
     U_WBC0LMVSP            WBC0LMVSP;
     U_WBC0CHMHSP           WBC0CHMHSP;
     U_WBC0CHMVSP           WBC0CHMVSP;
     U_WBC0COEFUP           WBC0COEFUP;
     U_WBC0COEFAD           WBC0COEFAD;
     unsigned int           reserved90[114];    // 0x934~0xafc


    /* CBM register                                                         */
     U_CBMBKG1              CBMBKG1;            // 0xb00
     U_CBMBKG2              CBMBKG2;
     U_CBMWBC               CBMWBC;
     U_CBCFG                CBCFG;
     unsigned int           reservedb0[60];     // 0xb10~0xbfc


    /* DDC_HD register                                                      */
     U_DHDCTRL              DHDCTRL;            // 0xc00
     U_DHDVSYNC             DHDVSYNC;
     U_DHDHSYNC1            DHDHSYNC1;
     U_DHDHSYNC2            DHDHSYNC2;
     U_DHDVPLUS             DHDVPLUS;
     U_DHDPWR               DHDPWR;
     U_DHDFIFOTHD           DHDFIFOTHD;
     U_DHDVTTHD             DHDVTTHD;
     U_DHDCSCIDC            DHDCSCIDC;
     U_DHDCSCODC            DHDCSCODC;
     U_DHDCSCP0             DHDCSCP0;
     U_DHDCSCP1             DHDCSCP1;
     U_DHDCSCP2             DHDCSCP2;
     U_DHDCSCP3             DHDCSCP3;
     U_DHDCSCP4             DHDCSCP4;
     U_DHDCLIPL             DHDCLIPL;
     U_DHDCLIPH             DHDCLIPH;           // 0xc40
     U_GMMTHD1              DHDGMMTHD1;
     U_GMMTHD2              DHDGMMTHD2;
     unsigned int           reservedc0;         // 0xc4c
     U_GMMTABLEn            DHDGMMLOWn[3] ;     // 0xc50~0xc58
     unsigned int           reservedc1    ;
     U_GMMTABLEn            DHDGMMMEDn[3] ;     // 0xc60~0xc68
     unsigned int           reservedc2    ;
     U_GMMTABLEn            DHDGMMHIGHn[3];     // 0xc70~0xc78
     unsigned int           reservedc3    ;
     U_GMMTABLEn            DHDGMMMLn[3]  ;     // 0xc80~0xc88
     unsigned int           reservedc4[5] ;
     U_GMMTABLEn            DHDGMMMHn[3]  ;     // 0xca0~0xca8
     unsigned int           reservedc5    ;     // 0xcac
     U_GMMSTAT              DHDGMMSTATLOW ;     // 0xcb0
     U_GMMSTAT              DHDGMMSTATMED ;     // 0xcb4
     U_GMMSTAT              DHDGMMSTATHIGH;     // 0xcb8
     unsigned int           reservedc6    ;     // 0xcbc
     U_GMMSTAT              DHDGMMSTATMLOW;     // 0xcc0
     U_GMMSTAT              DHDGMMSTATMHIGH;    // 0xcc4
     unsigned int           reservedc7[6];      // 0xcc8~0xcdc
     U_CCDIMGMOD            CCDIMGMODE;         // 0xce0
     unsigned int           reservedc8[3];      // 0xce4~0xcec
     U_DHDSTATE             DHDSTATE;           // 0xcf0
     unsigned int           reservedc9[3];

    /* DDC_AD register                                                      */
     U_DADCTRL              DADCTRL;            // 0xd00
     U_DADVSYNC             DADVSYNC;
     U_DADHSYNC1            DADHSYNC1;
     U_DADHSYNC2            DADHSYNC2;
     U_DADVPLUS             DADVPLUS;
     U_DADPWR               DADPWR;
     U_DADFIFOTHD           DADFIFOTHD;
     U_DADVTTHD             DADVTTHD;
     U_DADCSCIDC            DADCSCIDC;
     U_DADCSCODC            DADCSCODC;
     U_DADCSCP0             DADCSCP0;
     U_DADCSCP1             DADCSCP1;
     U_DADCSCP2             DADCSCP2;
     U_DADCSCP3             DADCSCP3;
     U_DADCSCP4             DADCSCP4;
     U_DADCLIPL             DADCLIPL;
     U_DADCLIPH             DADCLIPH;
     U_GMMTHD1              DADGMMTHD1;         // 0xd44
     U_GMMTHD2              DADGMMTHD2;
     unsigned int           reservedd0   ;      // 0xd4c
     U_GMMTABLEn            DADGMMLOWn[3] ;     // 0xd50~0xd58
     unsigned int           reservedd1   ;
     U_GMMTABLEn            DADGMMMEDn[3] ;     // 0xd60~0xd68
     unsigned int           reservedd2   ;
     U_GMMTABLEn            DADGMMHIGHn[3];     // 0xd70~0xd78
     unsigned int           reservedd3   ;
     U_GMMTABLEn            DADGMMMLn[3]  ;     // 0xd80~0xd88
     unsigned int           reservedd4[5];
     U_GMMTABLEn            DADGMMMHn[3]  ;     // 0xda0~0xda8
     unsigned int           reservedd5   ;
     U_GMMSTAT              DADGMMSTATLOW ;     // 0xdb0
     U_GMMSTAT              DADGMMSTATMED ;     // 0xdb4
     U_GMMSTAT              DADGMMSTATHIGH;     // 0xdb8
     unsigned int           reservedd6   ;      // 0xdbc
     U_GMMSTAT              DADGMMSTATMLOW;     // 0xdc0
     U_GMMSTAT              DADGMMSTATMHIGH;    // 0xdc4
     unsigned int           reservedd7[10];      // 0xdc8~0xdec
     U_DHDSTATE             DADSTATE;           // 0xdf0
     unsigned int           reservedd8[3];      // 0xdf4~0xdfc


    /* DDC_SD register                                                      */
     U_DSDCTRL              DSDCTRL;            // 0xe00
     U_DSDVSYNC             DSDVSYNC;
     U_DSDHSYNC1            DSDHSYNC1;
     U_DSDHSYNC2            DSDHSYNC2;
     U_DSDVPLUS             DSDVPLUS;
     U_DSDPWR               DSDPWR;
     U_DSDFIFOTHD           DSDFIFOTHD;
     U_DSDVTTHD             DSDVTTHD;
     U_DSDCSCIDC            DSDCSCIDC;
     U_DSDCSCODC            DSDCSCODC;
     U_DSDCSCP0             DSDCSCP0;
     U_DSDCSCP1             DSDCSCP1;
     U_DSDCSCP2             DSDCSCP2;
     U_DSDCSCP3             DSDCSCP3;
     U_DSDCSCP4             DSDCSCP4;
     U_DSDCLIPL             DSDCLIPL;
     U_DSDCLIPH             DSDCLIPH;           // 0xe40
     unsigned int           reservede0[43];     // 0xe44~0xeec
     U_DHDSTATE             DSDSTATE;           // 0xef0
     unsigned int           reservede1[3];      // 0xef4~0xefc


    /* CCD register                                                         */
     U_CCDSPOS              CCDSPOS[32]   ;     // 0xf00~0xf7c
     U_CCDFPOS              CCDFPOS[32]   ;     // 0xf80~0xffc


    /* VHD COEFFICIENT register                                             */
     U_VHDHLCOEF            VHDHLCOEF[72];      // 0x1000~0x111c
     unsigned int           reserved100[56];    // 0x1120~0x11fc
     U_VHDHCCOEF            VHDHCCOEF[36];      // 0x1200~0x128c
     unsigned int           reserved101[28];    // 0x1290~0x12fc
     U_VHDVLCOEF            VHDVLCOEF[36];      // 0x1300~0x138c
     unsigned int           reserved102[28];    // 0x1390~0x13fc
     U_VHDVCCOEF            VHDVCCOEF[36];      // 0x1400~0x148c
     unsigned int           reserved103[28];    // 0x1490~0x14fc


    /* VAD COEFFICIENT register                                             */
     U_VADHLCOEF            VADHLCOEF[72];      // 0x1500~0x161c
     unsigned int           reserved110[56];    // 0x1620~0x16fc
     U_VADHCCOEF            VADHCCOEF[36];      // 0x1700~0x178c
     unsigned int           reserved111[28];    // 0x1790~0x17fc
     U_VADVLCOEF            VADVLCOEF[36];      // 0x1800~0x188c
     unsigned int           reserved112[28];    // 0x1890~0x18fc
     U_VADVCCOEF            VADVCCOEF[36];      // 0x1900~0x198c
     unsigned int           reserved113[28];    // 0x1990~0x19fc
     unsigned int           reserved130[384];   // 0x1a00~0x1ffc


    /* HDDATE register                                                       */
     unsigned int           HDATE_VERSION;          // 0x2000~0x2004
     U_HDATE_EN             HDATE_EN;               // 0x2004
     U_HDATE_POLA_CTRL      HDATE_POLA_CTRL;        // 0x2008
     U_HDATE_VIDEO_FORMAT   HDATE_VIDEO_FORMAT;     // 0x200c
     U_HDATE_STATE          HDATE_STATE;            // 0x2010
     U_HDATE_OUT_CTRL       HDATE_OUT_CTRL;         // 0x2014
     U_HDATE_SRC_13_COEF1   HDATE_SRC_13_COEF1;     // 0x2018
     U_HDATE_SRC_13_COEF2   HDATE_SRC_13_COEF2;
     U_HDATE_SRC_13_COEF3   HDATE_SRC_13_COEF3;
     U_HDATE_SRC_13_COEF4   HDATE_SRC_13_COEF4;
     U_HDATE_SRC_13_COEF5   HDATE_SRC_13_COEF5;
     U_HDATE_SRC_13_COEF6   HDATE_SRC_13_COEF6;
     U_HDATE_SRC_13_COEF7   HDATE_SRC_13_COEF7;
     U_HDATE_SRC_13_COEF8   HDATE_SRC_13_COEF8;
     U_HDATE_SRC_13_COEF9   HDATE_SRC_13_COEF9;
     U_HDATE_SRC_13_COEF10  HDATE_SRC_13_COEF10;
     U_HDATE_SRC_13_COEF11  HDATE_SRC_13_COEF11;
     U_HDATE_SRC_13_COEF12  HDATE_SRC_13_COEF12;
     U_HDATE_SRC_13_COEF13  HDATE_SRC_13_COEF13;
     U_HDATE_SRC_24_COEF1   HDATE_SRC_24_COEF1;     // 0x204c
     U_HDATE_SRC_24_COEF2   HDATE_SRC_24_COEF2;
     U_HDATE_SRC_24_COEF3   HDATE_SRC_24_COEF3;
     U_HDATE_SRC_24_COEF4   HDATE_SRC_24_COEF4;
     U_HDATE_SRC_24_COEF5   HDATE_SRC_24_COEF5;
     U_HDATE_SRC_24_COEF6   HDATE_SRC_24_COEF6;
     U_HDATE_SRC_24_COEF7   HDATE_SRC_24_COEF7;
     U_HDATE_SRC_24_COEF8   HDATE_SRC_24_COEF8;
     U_HDATE_SRC_24_COEF9   HDATE_SRC_24_COEF9;
     U_HDATE_SRC_24_COEF10  HDATE_SRC_24_COEF10;
     U_HDATE_SRC_24_COEF11  HDATE_SRC_24_COEF11;
     U_HDATE_SRC_24_COEF12  HDATE_SRC_24_COEF12;
     U_HDATE_SRC_24_COEF13  HDATE_SRC_24_COEF13;
     U_HDATE_CSC_COEF1      HDATE_CSC_COEF1;        // 0x2080
     U_HDATE_CSC_COEF2      HDATE_CSC_COEF2;
     U_HDATE_CSC_COEF3      HDATE_CSC_COEF3;
     U_HDATE_CSC_COEF4      HDATE_CSC_COEF4;
     U_HDATE_CSC_COEF5      HDATE_CSC_COEF5;
     unsigned int           reservedhddata0[3];     // 0x2094
     U_HDATE_TEST           HDATE_TEST;             // 0x20a0
     U_HDATE_VBI_CTRL       HDATE_VBI_CTRL;
     U_HDATE_CGMSA_DATA     HDATE_CGMSA_DATA;       // 0x20a8
     U_HDATE_CGMSB_H        HDATE_CGMSB_H;
     unsigned int           HDATE_CGMSB_DATA1;
     unsigned int           HDATE_CGMSB_DATA2;
     unsigned int           HDATE_CGMSB_DATA3;
     unsigned int           HDATE_CGMSB_DATA4;      // 0x20bc
     unsigned int           reservedhddate[16];     // 0x20c0~0x20fc


    /* ADDATE register                                                      */
     U_ADATE_NORM            ADATE_NORM;           // 0x2100~0x2104
     unsigned int            reservedaddate[63];   // 0x2104~0x21fc



    /* SDDATE register                                                      */
     U_SDATE_NORM            SDATE_NORM;           // 0x2200~0x2204
     unsigned int            reservedsddate[63];   // 0x2204~0x22fc



    /* VHD_DIEBRD register                                                  */
     U_MIMGSPOSn            VHDMIMGSPOSn[32];   // 0x2300~0x237c
     U_MIMGFPOSn            VHDMIMGFPOSn[32];   // 0x2380~0x23fc


    /* VAD_DIEBRD register                                                  */
     U_MIMGSPOSn            VADMIMGSPOSn[32];   // 0x2400~0x247c
     U_MIMGFPOSn            VADMIMGFPOSn[32];   // 0x2480~0x24fc

} VOU_REGS_S;




#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

#endif  /* End of #ifdef __VOU_REG_H__ */

