/*
 * (C) Copyright 2009-2010
 * Kevin Hsu, Hisilicon inc, xujilin@huawei.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/************************************************
 * NAME	    : hi35xx_vo.h
 *
 * Based on hi35xx User's manual Rev 0.0
 ************************************************/


#ifndef __HI35XX_VO_H__
#define __HI35XX_VO_H__

#define HI_3520_VO  1
#define PIC_MAX_WIDTH   1920
#define PIC_MAX_HEIGHT  1080
#define PIC_MIN_LENTH   16

typedef enum hiVO_DEV_E
{
    VO_DEV_HD   = 0,
    VO_DEV_AD   = 1,
    VO_DEV_SD   = 2,
    VO_DEV_BUTT

} VO_DEV_E;

typedef enum hiVO_INTF_TYPE_E
{
    VO_INTF_CVBS     = 0,                  /* for SD or AD */
    VO_INTF_BT656    = 1,                  /* for AD only */
    VO_INTF_VGA      = 2,                  /* for HD or AD */
    VO_INTF_YPBPR    = 3,                  /* for HD only */
    VO_INTF_BT1120   = 4,                  /* for HD only */
    VO_INTF_LCD      = 5,                  /* for HD only */
    VO_INTF_BUTT

} VO_INTF_TYPE_E;

typedef enum hiVO_INTF_SYNC_E
{
    VO_OUTPUT_PAL           = 0,
    VO_OUTPUT_NTSC          = 1,

    VO_OUTPUT_720P60        = 2,
    VO_OUTPUT_1080I50       = 3,
    VO_OUTPUT_1080I60       = 4,
    VO_OUTPUT_1080P25       = 5,
    VO_OUTPUT_1080P30       = 6,

    VO_OUTPUT_800x600_60    = 7,
    VO_OUTPUT_1024x768_60   = 8,
    VO_OUTPUT_1280x1024_60  = 9,
    VO_OUTPUT_1366x768_60   = 10,
    VO_OUTPUT_1440x900_60   = 11,

    VO_OUTPUT_BUTT

} VO_INTF_SYNC_E;

typedef enum hiVO_GRAPHIC_E
{
    VO_GRAPHC_G0    = 0,
    VO_GRAPHC_G1    = 1,
    VO_GRAPHC_G2    = 2,
    VO_GRAPHC_G3    = 3,
    VO_GRAPHC_G4    = 4,
    VO_GRAPHC_BUTT

} VO_GRAPHIC_E;

#endif

