//cpu_led_init();
	//cpu_led_wr(1);
/*
 *  linux/arch/arm/mach-hi3520-v100/pci.c
 *Copyright (c) 2006 Hisilicon Co., Ltd. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *
 * ARM hi3520 PCI driver.
 *
 * 12/2006 Initial version
 *
 */
#include <linux/autoconf.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/ptrace.h>
#include <linux/slab.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <linux/spinlock.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/string.h>

#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/mach/pci.h>

#include <asm/arch/early-debug.h>

#include <asm/arch/pci.h>

static unsigned long hil_pci_clk_sel = 16;
static int __init hil_setup_pci_bus_clock(char *s)
{
    hil_pci_clk_sel = simple_strtoul(s, NULL, 0);
    return 1;
}
__setup("pciclksel=", hil_setup_pci_bus_clock);


/*
 * these spaces are mapped using the following base registers:
 *
 * Usage Local Bus Memory         Base/Map registers used
 *
 * Mem   B0000000 - B00003FF      BRIDGE REGISET
 * Mem   B0010000 - B001FFFF       IO
 * Mem   B0020000 - B7FFFFFF       LB_BASE0/LB_MAP0,  non prefetch
 * Mem   B8000000 - BFFFFFFF   	   LB_BASE1/LB_MAP1,  prefetch
 *
 */
#define PCIIRQ			29 

static unsigned long pci_slot_ignore = 0;
unsigned long hi3520_pci_cfg_virt_base;
unsigned long hi3520_pci_virt_base;
unsigned long hi3520_sys_ctl_register_virt_base;
dma_addr_t hi3520_pci_dma_zone_base;
unsigned char *hi3520_pci_dma_zone_virt_base;


static int __init hi3520_pci_slot_ignore(char *str)
{
    int retval;
    int slot;

    while ((retval = get_option(&str,&slot))) {
	if ((slot < 0) || (slot > 31)) {
	    printk("Illegal slot value: %d\n",slot);
	} else {
	    pci_slot_ignore |= (1 << slot);
	}
    }
    return 1;
}

__setup("pci_slot_ignore=", hi3520_pci_slot_ignore);

static unsigned long __pci_addr(struct pci_bus *bus,
	unsigned int devfn, int offset)
{
    unsigned long addr,slot;
    unsigned int where;
    unsigned int busnr = bus->number;
    PCI_HAL_DEBUG(0, "ok, count its address %d", 1);

    /*
     * Trap out illegal values
     */
    if ((offset > 255)||(busnr > 255) || (devfn > 255))
    {
	BUG();
    }

    /* type 0*/
    //there should has an address bit for the idsel signal of slave, the bit can be count out 
    //according to the devfn.
    where=((unsigned long)offset&(~0xffffff03U));
    if (busnr == 0) {
	slot=PCI_SLOT(devfn);
	if(slot>15) slot=15;
	addr=(( 0x01U<< (16+slot)) | (PCI_FUNC(devfn) << 8) | where);
	PCI_HAL_DEBUG(0,"pcibus unmber %d,pci address is 0x%lx\n",busnr,addr);
    } 
    else {
	addr=((busnr << 16) |(PCI_SLOT(devfn) << 11) | (PCI_FUNC(devfn) << 8) | where|0x00000001U);	
	PCI_HAL_DEBUG(0,"pcibus unmber %d,pci address is 0x%lx\n",busnr,addr);
    }	

    return addr;	
}

static int pci_config_dma_read(unsigned int address,int size,unsigned int val)
{
    unsigned int control;
    int i;

    //dump_stack();

    /*write config address to dma pci address register */
    hi3520_bridge_ahb_writel(RDMA_PCI_ADDR, address);
    /*write value address to dma ahb register*/
    hi3520_bridge_ahb_writel(RDMA_AHB_ADDR, val);
    /*write dma control register*/
    control = (size<<8 |0|DMAR_CONF);
    hi3520_bridge_ahb_writel(RDMA_CONTROL, control);
    control |= DMAC_START;
    hi3520_bridge_ahb_writel(RDMA_CONTROL, control);

    for(i=0; i<10000 && (hi3520_bridge_ahb_readl(RDMA_CONTROL)&0x00000001); i++) {
	udelay(100);
    };
    if(hi3520_bridge_ahb_readl(RDMA_CONTROL)&0x00000001)
	printk(KERN_ERR "pci_config_dma_read timeout!\n");

    return 0;
}

static int pci_config_dma_write(unsigned int address,int size,unsigned int val)
{
    unsigned int control;
    int i;

    /*write config address to dma pci address register */
    hi3520_bridge_ahb_writel(WDMA_PCI_ADDR, address);
    /*write value address to dma ahb register*/
    hi3520_bridge_ahb_writel(WDMA_AHB_ADDR, val);
    /*write dma control register*/
    control = (size<<8 |0|DMAW_CONF);
    hi3520_bridge_ahb_writel(WDMA_CONTROL, control);
    control |= DMAC_START;
    hi3520_bridge_ahb_writel(WDMA_CONTROL, control);

    for(i=0; i<10000 && (hi3520_bridge_ahb_readl(WDMA_CONTROL)&0x00000001); i++) {
	udelay(100);
    };
    if(hi3520_bridge_ahb_readl(WDMA_CONTROL)&0x00000001)
	printk(KERN_ERR "pci_config_dma_write timeout!\n");
    return 0;
}

static int hi3520_read_config(struct pci_bus *bus, unsigned int devfn, int where,
	int size, u32 *val)
{
    unsigned long shift;
    unsigned long addr = __pci_addr(bus, devfn, where);
    u32 v;
    int slot = PCI_SLOT(devfn);
    PCI_HAL_DEBUG(0, "ok, read it %d", 1);

    if (pci_slot_ignore & (1 << slot)) {
	/* Ignore this slot */
	switch (size) {
	    case 1:
		v = 0xff;
		break;
	    case 2:
		v = 0xffff;
		break;
	    default:
		v = 0xffffffff;
	}
    } else {
	pci_config_dma_read(addr,4,hi3520_pci_dma_zone_base);
	PCI_HAL_DEBUG(0, "ok, read it %d", 2);
    }

    v=*(volatile unsigned long *)hi3520_pci_dma_zone_virt_base;
    shift=(((unsigned long)where)&0x00000003UL)<<3;
    *val = (v>>shift);
    return PCIBIOS_SUCCESSFUL;
}

static int hi3520_write_config(struct pci_bus *bus, unsigned int devfn, int where,
	int size, u32 val)
{
    unsigned long shift;
    unsigned long addr = __pci_addr(bus, devfn, where);
    int slot = PCI_SLOT(devfn);
    pci_config_dma_read(addr,4,hi3520_pci_dma_zone_base);
    switch(size){
	case 1:
	    shift=(((unsigned long)where)&0x00000003UL)<<3;
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base&=(~(0xff<<shift));
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base|=(val<<shift);
	    break;

	case 2:
	    shift=(((unsigned long)where)&0x00000003UL)<<3;
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base&=(~(0xffff<<shift));
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base|=(val<<shift);
	    break;

	case 4:
	    shift=(((unsigned long)where)&0x00000003UL)<<3;
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base&=(~(0xffffffff<<shift));
	    *(volatile unsigned int *)hi3520_pci_dma_zone_virt_base|=(val<<shift);
	    break;
    }

    PCI_HAL_DEBUG(0, "ok, write it %d", 1);
    if (pci_slot_ignore & (1 << slot)) {
	return PCIBIOS_SUCCESSFUL;
    }

    pci_config_dma_write(addr,4,hi3520_pci_dma_zone_base);
    return PCIBIOS_SUCCESSFUL;
}

static struct pci_ops pci_hi3520_ops = {
    .read	= hi3520_read_config,
    .write	= hi3520_write_config,
};


static struct resource io_mem = {
    .name	= "PCI I/O space",
    .start	= HI3520_PCI_MEM_BASE0,
    .end	= HI3520_PCI_MEM_BASE0+HI3520_PCI_MEM_BASE0_SIZE-1,
    .flags	= IORESOURCE_IO,
};


static struct resource non_mem = {
    .name	= "PCI non-prefetchable",
    .start	= HI3520_PCI_MEM_BASE1,
    .end	= HI3520_PCI_MEM_BASE1+HI3520_PCI_MEM_BASE1_SIZE-1,
    .flags	= IORESOURCE_MEM,
};

static struct resource pre_mem = {
    .name	= "PCI prefetchable",
    .start	= HI3520_PCI_MEM_BASE2,
    .end	= HI3520_PCI_MEM_BASE2+HI3520_PCI_MEM_BASE2_SIZE-1,
    .flags	= IORESOURCE_MEM | IORESOURCE_PREFETCH,
};

static int __init pci_hi3520_setup_resources(struct resource **resource)
{
    int ret = 0;

    ret = request_resource(&iomem_resource, &io_mem);
    if (ret) {
	printk(KERN_ERR "PCI: unable to allocate I/O "
		"memory region (%d)\n", ret);
	goto out;
    }

    ret = request_resource(&iomem_resource, &non_mem);
    if (ret) {
	printk(KERN_ERR "PCI: unable to allocate non-prefetchable "
		"memory region (%d)\n", ret);
	goto release_io_mem;
    }
    ret = request_resource(&iomem_resource, &pre_mem);
    if (ret) {
	printk(KERN_ERR "PCI: unable to allocate prefetchable "
		"memory region (%d)\n", ret);
	goto release_non_mem;
    }

    /*
     * bus->resource[0] is the IO resource for this bus
     * bus->resource[1] is the mem resource for this bus
     * bus->resource[2] is the prefetch mem resource for this bus
     */
    resource[0] = &io_mem;
    resource[1] = &non_mem;
    resource[2] = &pre_mem;
    PCI_HAL_DEBUG(0, "ok, resources are start from %x", HI3520_PCI_MEM_BASE0);
    goto out;

release_non_mem:
    release_resource(&non_mem);
release_io_mem:
    release_resource(&pre_mem);
out:
    return ret;
}

int __init pci_hi3520_setup(int nr, struct pci_sys_data *sys)
{
    int ret = 0;
    PCI_HAL_DEBUG(0, "ok, setup bus %d", 1);
    if (nr == 0) {
	sys->mem_offset = 0;
	ret = pci_hi3520_setup_resources(sys->resource);
	PCI_HAL_DEBUG(0, "ok, resource ret %d", ret);
	if (ret < 0) {
	    printk("pci_hi3520_setup: resources... oops?\n");
	    goto out;
	}
    } else {
	printk("pci_hi3520_setup: resources... nr == 0??\n");
	goto out; 
    }
out:
    return  1;
}

    static int
hi3520_pci_fault(unsigned long addr, unsigned int fsr, struct pt_regs *regs)
{
    return 0;
}

/*
 * map the specified device/slot/pin to an IRQ.   Different backplanes may need to modify this.
 */
static int __init hi3520_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{

    int irq;
    int devslot = PCI_SLOT(dev->devfn);
    irq = PCIIRQ;	/* only one irq number for pci */
    PCI_HAL_DEBUG(0, "ok, irq number registed in %d", irq);
    PCI_HAL_DEBUG(0,"map irq: slot %d, pin %d, devslot %d, irq: %d\n",slot,pin,devslot,irq);

    return irq;
}


struct pci_bus *pci_hi3520_scan_bus(int nr, struct pci_sys_data *sys)
{	
    PCI_HAL_DEBUG(0, "ok, find them %d", 1);
    return pci_scan_bus(sys->busnr, &pci_hi3520_ops, sys);
}

/*
 * V3_LB_BASE? - local bus address
 * V3_LB_MAP?  - pci bus address
 */
void __init pci_hi3520_preinit(void)
{
    int i=0;

    unsigned long register_value=0;
    PCI_HAL_DEBUG(0, "ok, bios is running %d", 1);
    hi3520_sys_ctl_register_virt_base=IO_ADDRESS(REG_BASE_SCTL);
    /* demux for pci arbitary */


    register_value =__raw_readl( hi3520_sys_ctl_register_virt_base + 0x24);
    __raw_writel(register_value | 0x2000, hi3520_sys_ctl_register_virt_base + 0x24); //H2 ASIC
//    __raw_writel(register_value | 0x4000, hi3520_sys_ctl_register_virt_base + 0x24);//H2 FPGA
    //soft reset the bridge
    /*mw 0x101e005c 0x3  //config Sys_CTRL, set bridge to Host,and start the pci clock
      mw 0x101e0050 0x00002000   //soft reset PCI
      mw 0x101e001c 0x00000000   //clear soft reset*/
    register_value =__raw_readl( hi3520_sys_ctl_register_virt_base + 0x5c);
    //__raw_writel((register_value| 0x3), hi3520_sys_ctl_register_virt_base + 0x5c);
    __raw_writel((register_value | 0x3), hi3520_sys_ctl_register_virt_base + 0x5c);//internal clock
    //__raw_writel(((register_value& 0xfffffffd)| 0x1), hi3520_sys_ctl_register_virt_base + 0x5c);//external clock

    register_value=__raw_readl( hi3520_sys_ctl_register_virt_base+0x50);
    __raw_writel(register_value|0x0002000, hi3520_sys_ctl_register_virt_base+0x50);
    for(;i<100;i++);
    register_value=__raw_readl( hi3520_sys_ctl_register_virt_base+0x50);
    register_value&=0xffffdfff;
    __raw_writel(register_value, hi3520_sys_ctl_register_virt_base+0x50);
    for(i=0;i<100;i++);

    /* according the current description, there is no multi-use */
#if 0
    register_value =__raw_readl( hi3520_sys_ctl_register_virt_base + 0x20);
    __raw_writel(register_value | 0x2000, hi3520_sys_ctl_register_virt_base + 0x20);
#endif
    /*
     * Hook in our fault handler for PCI errors
     */
    hook_fault_code(4, hi3520_pci_fault, SIGBUS, "external abort on linefetch");
    hook_fault_code(6, hi3520_pci_fault, SIGBUS, "external abort on linefetch");
    hook_fault_code(8, hi3520_pci_fault, SIGBUS, "external abort on non-linefetch");
    hook_fault_code(10, hi3520_pci_fault, SIGBUS, "external abort on non-linefetch");
    //spin_lock_irqsave(&hi3520_lock, flags);
    //spin_unlock_irqrestore(&hi3520_lock, flags);

    hi3520_pci_dma_zone_virt_base = dma_alloc_coherent(NULL, SZ_4K, &hi3520_pci_dma_zone_base, GFP_DMA);

    if(hi3520_pci_dma_zone_virt_base == 0){

	PCI_HAL_DEBUG(0, "hi3520_pci_dma_zone_virt_base alloc error %d", 1);

	return ;
    }

    memset(hi3520_pci_dma_zone_virt_base ,0xa5, SZ_4K);
    //set host bridge address when it acts as a slave in a transaction
    //hi3511_bridge_ahb_writel(PCIAHB_ADDR_PF, PHYS_OFFSET+1);
    hi3520_bridge_ahb_writel(PCIAHB_ADDR_PF, 0xc0000001);
    hi3520_bridge_ahb_writel(PCIAHB_SIZ_PF, 0xc0000000);

}

void __init pci_hi3520_postinit(void)
{
    //clear host interrupt register,close interrupt
    hi3520_bridge_ahb_writel(CPU_ISTATUS, 0xffffffff);
    hi3520_bridge_ahb_writel(CPU_IMASK, 0x01000000);
    //hi3520_bridge_ahb_writel(CPU_ICMD, 0xffffffff);
    PCI_HAL_DEBUG(0,"istatus and imask %d \n",hi3520_bridge_ahb_readl(CPU_IMASK) );
    PCI_HAL_DEBUG(0,"istatus and imask %d \n",hi3520_bridge_ahb_readl(CPU_ISTATUS) );
}

static struct hw_pci hi3520_pci __initdata = {
    .swizzle		= NULL,
    .map_irq		= hi3520_map_irq,
    .nr_controllers		= 1,
    .setup			= pci_hi3520_setup,
    .scan			= pci_hi3520_scan_bus,
    .preinit		= pci_hi3520_preinit,
    .postinit		= pci_hi3520_postinit,
};

static int __initdata hil_pcimod=0;

static int __init hil_setup_pcimod(char *s)
{
    if(strcmp(s, "host") ==0)
	hil_pcimod = 1;

    return 1;
}
__setup("pcimod=", hil_setup_pcimod);

static int __init hi3520_pci_init(void)
{
    unsigned int reg = 0;

    /* 0 for 62.5MHZ,1 for 31.25MHZ, 2 for  six-divided frequency of arm9,3 for 12-divided */
    static const unsigned char div[4] = {0,1,2,3};
    if(hil_pci_clk_sel >3)
    {
	printk("pci clk devider is out of range:0~3!\n");
	return -1;
    }
    reg = readl(IO_ADDRESS(REG_BASE_SCTL + 0x54));
    reg &= ~(0x3 << 23);
    reg |= (div[hil_pci_clk_sel] << 23);
    writel(reg,IO_ADDRESS(REG_BASE_SCTL + 0x54));

    if(hil_pcimod ==0) {
	printk("Hisilicon PCI work at slave mode.\n");
	return 0;
    }

    PCI_HAL_DEBUG(0, "begin %d", 1);
    pci_common_init(&hi3520_pci);

    return 0;
}

subsys_initcall(hi3520_pci_init);

