#!/bin/sh

# like: ~$ ./this-script /home/linux-2.6.14 /home/kbuild/ arm

ARCH=$3
KERNEL_DIR="$1"

pushd $2 >/dev/null
KBUILD_DIR=`pwd`
popd >/dev/null

#dir_src
#dir_dst_base
#partern
copy_dir_parterns()
{
	find $1 -name "$3" | while read makefile
	do
		cp -dpfv --parents $makefile $2
	done
}

pushd $KERNEL_DIR/ >/dev/null

#make clean

while read tops
do
	[ -f $tops ] && { cp $tops $KBUILD_DIR -dpfv; continue; }
	! [ -d $tops ] && continue;
	case $tops in
	arch)
		copy_dir_parterns $tops $KBUILD_DIR "Make*"
		copy_dir_parterns $tops $KBUILD_DIR "Kconfig*"
		copy_dir_parterns $tops/arm $KBUILD_DIR "*mach-types"
		continue
		;;
	include)
		for incs in include/*
		do
			case $incs in 
			include/asm-$ARCH)
				cp -afv --parents $incs $KBUILD_DIR
				;;
			include/asm-generic)
				cp -afv --parents $incs $KBUILD_DIR
				;;
			include/asm-*)
				;;
			*)
				cp -afv --parents $incs $KBUILD_DIR
				;;
			esac
		done
		continue
		;;
	scripts)
		rm $KBUILD_DIR/scripts -fr
		cp $tops $KBUILD_DIR/ -afv
		continue
		;;
	*)
		copy_dir_parterns $tops $KBUILD_DIR "Make*"
		copy_dir_parterns $tops $KBUILD_DIR "Kconfig*"
		continue
		;;
	esac
done << EOF
`find . -mindepth 1 -maxdepth 1 -printf "%P\n"`
EOF

popd >/dev/null

pushd $KBUILD_DIR >/dev/null
rm -fr .*.cmd .*.[oS] *vmlinux .*vmlinux .tmp*
popd >/dev/null

