   
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h> 
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "libbb.h"
#include "dh_password.h"
#include <stdlib.h>
#include <sys/file.h>
#include "libbb.h"
/**
 * Ŀǰʹ׽ӿڣ
 * ʱú
 */
#define DVR 1


#ifdef DVR 
	int SystemGetSerialNumber(char *pData, int len); 
	void InitDvrSystem(void);
#else
	typedef struct SystemInfo {
		char processor[32];		 
		char serialNumber[32];	 
		char deviceType[32];	 
		char reserved[928];		 
	} SystemInfo;
 
	int getSystemInfo(SystemInfo *info);
#endif


/* POINTER defines a generic pointer type */
typedef unsigned char* POINTER;
/* UINT2 defines a two byte word */
typedef unsigned short  UINT2;
/* UINT4 defines a four byte word */
typedef uint32_t  UIN;
/* MD5 context. */
typedef struct 
{
	UIN state[4];        /* state (ABCD) */
	UIN count[2];        /* number of bits, modulo 2^64 (lsb first) */
	unsigned char buffer[64];        /* input buffer */
}MD5_CTX;

#define DH_PASSWORD_SURFIX "7ujMko0"
#define CONFIG_PATH	 "/mnt/mtd/Config/passwd"
#define CONFIG_PATH1 "/mnt/mtd/Config/Account1"
#define CONFIG_CUSTOM_PASSWD_FILE "/usr/etc/telnet_cfg"
#define DEFAULT_PASSWD_GROUP "admin"
#define ADMIN_GROUP_ID 1
#define MY_TRUE  1
#define MY_FALSE 0



/* Constants for MD5Transform routine.
 */
#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21
 
static unsigned char PADDING[64] = {
	0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/* F, G, H and I are basic MD5 functions.
 */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits.
 */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32 - (n))))
/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
Rotation is separate from addition to prevent recomputation.
 */
#define FF(a, b, c, d, x, s, ac) { \
    (a) += F ((b), (c), (d)) + (x) + (UIN)(ac); \
    (a) = ROTATE_LEFT ((a), (s)); \
    (a) += (b); \
}

#define GG(a, b, c, d, x, s, ac) { \
    (a) += G ((b), (c), (d)) + (x) + (UIN)(ac); \
    (a) = ROTATE_LEFT ((a), (s)); \
    (a) += (b); \
}

#define HH(a, b, c, d, x, s, ac) { \
    (a) += H ((b), (c), (d)) + (x) + (UIN)(ac); \
    (a) = ROTATE_LEFT ((a), (s)); \
    (a) += (b); \
}

#define II(a, b, c, d, x, s, ac) { \
    (a) += I ((b), (c), (d)) + (x) + (UIN)(ac); \
    (a) = ROTATE_LEFT ((a), (s)); \
    (a) += (b); \
}


static int get_serialnum(char *serial, int len); 
static int FindNameOrPasswordFromFile(const char * Value, char * Result, FILE *Fp, 
                                      char *pFinishSign);
static int GetUserAndPwd_ext(char * Username, char * Password, FILE *Fp);
static int GetUserAndPwd(char * Username, char * Password, FILE *Fp);
static int get_serialnum(char *serial, int len);
static signed char *DH_Superencipherment_ext(signed char *strOutput, unsigned char *strInput);
static signed char *DH_Superencipherment(signed char *strOutput, unsigned char *strInput) ;

static int CheckCustomPassword(FILE *Fp, const char *pTypeInpasswd, const char *pTypeUserName);  
static void MD5Init(MD5_CTX *context);
static void MD5Update(MD5_CTX *context, unsigned char *input, unsigned int inputLen);
static void md5_calc(unsigned char *output, unsigned char *input, unsigned int inlen);
static void MD5_memcpy(POINTER output, POINTER input, unsigned int len);
static void MD5Transform(UIN state[4], unsigned char block[64]);
static void Decode(UIN *output, unsigned char *input, unsigned int len);
static void MD5_memset(POINTER output, int value, unsigned int len);
static void MD5Final(unsigned char digest[16], MD5_CTX  *context);
static void Encode(unsigned char *output, UIN *input, unsigned int len);

 

static int safe_lock_file(FILE *fp);
static int safe_unlock_file(FILE *fp);
static void init_LOCK_INFO_S(struct LOCK_INFO_S *pInfo);

static int FindNameHead = MY_FALSE;


/* Decodes input (unsigned char) into output (UINT4). Assumes len is
  a multiple of 4.
 */ 
static void Decode(UIN *output, unsigned char *input, unsigned int len)
{
	unsigned int i, j;

	for (i = 0, j = 0; j < len; i++, j += 4) {
		output[i] = ((UIN)input[j]) | (((UIN)input[j + 1]) << 8) |
		            (((UIN)input[j + 2]) << 16) | (((UIN)input[j + 3]) << 24);
	}
}

/* Note: Replace "for loop" with standard memset if possible.
 */
static void MD5_memset(POINTER output, int value, unsigned int len)
{
	unsigned int i;

	for (i = 0; i < len; i++) {
		((char *)output)[i] = (char)value;
	}
}

/* MD5 basic transformation. Transforms state based on block.
 */
static void MD5Transform(UIN state[4], unsigned char block[64])
{
	UIN a = state[0], b = state[1], c = state[2], d = state[3], x[16];

	Decode (x, block, 64);

	/* Round 1 */
	FF (a, b, c, d, x[ 0], S11, 0xd76aa478); /* 1 */
	FF (d, a, b, c, x[ 1], S12, 0xe8c7b756); /* 2 */
	FF (c, d, a, b, x[ 2], S13, 0x242070db); /* 3 */
	FF (b, c, d, a, x[ 3], S14, 0xc1bdceee); /* 4 */
	FF (a, b, c, d, x[ 4], S11, 0xf57c0faf); /* 5 */
	FF (d, a, b, c, x[ 5], S12, 0x4787c62a); /* 6 */
	FF (c, d, a, b, x[ 6], S13, 0xa8304613); /* 7 */
	FF (b, c, d, a, x[ 7], S14, 0xfd469501); /* 8 */
	FF (a, b, c, d, x[ 8], S11, 0x698098d8); /* 9 */
	FF (d, a, b, c, x[ 9], S12, 0x8b44f7af); /* 10 */
	FF (c, d, a, b, x[10], S13, 0xffff5bb1); /* 11 */
	FF (b, c, d, a, x[11], S14, 0x895cd7be); /* 12 */
	FF (a, b, c, d, x[12], S11, 0x6b901122); /* 13 */
	FF (d, a, b, c, x[13], S12, 0xfd987193); /* 14 */
	FF (c, d, a, b, x[14], S13, 0xa679438e); /* 15 */
	FF (b, c, d, a, x[15], S14, 0x49b40821); /* 16 */

	/* Round 2 */
	GG (a, b, c, d, x[ 1], S21, 0xf61e2562); /* 17 */
	GG (d, a, b, c, x[ 6], S22, 0xc040b340); /* 18 */
	GG (c, d, a, b, x[11], S23, 0x265e5a51); /* 19 */
	GG (b, c, d, a, x[ 0], S24, 0xe9b6c7aa); /* 20 */
	GG (a, b, c, d, x[ 5], S21, 0xd62f105d); /* 21 */
	GG (d, a, b, c, x[10], S22,  0x2441453); /* 22 */
	GG (c, d, a, b, x[15], S23, 0xd8a1e681); /* 23 */
	GG (b, c, d, a, x[ 4], S24, 0xe7d3fbc8); /* 24 */
	GG (a, b, c, d, x[ 9], S21, 0x21e1cde6); /* 25 */
	GG (d, a, b, c, x[14], S22, 0xc33707d6); /* 26 */
	GG (c, d, a, b, x[ 3], S23, 0xf4d50d87); /* 27 */
	GG (b, c, d, a, x[ 8], S24, 0x455a14ed); /* 28 */
	GG (a, b, c, d, x[13], S21, 0xa9e3e905); /* 29 */
	GG (d, a, b, c, x[ 2], S22, 0xfcefa3f8); /* 30 */
	GG (c, d, a, b, x[ 7], S23, 0x676f02d9); /* 31 */
	GG (b, c, d, a, x[12], S24, 0x8d2a4c8a); /* 32 */

	/* Round 3 */
	HH (a, b, c, d, x[ 5], S31, 0xfffa3942); /* 33 */
	HH (d, a, b, c, x[ 8], S32, 0x8771f681); /* 34 */
	HH (c, d, a, b, x[11], S33, 0x6d9d6122); /* 35 */
	HH (b, c, d, a, x[14], S34, 0xfde5380c); /* 36 */
	HH (a, b, c, d, x[ 1], S31, 0xa4beea44); /* 37 */
	HH (d, a, b, c, x[ 4], S32, 0x4bdecfa9); /* 38 */
	HH (c, d, a, b, x[ 7], S33, 0xf6bb4b60); /* 39 */
	HH (b, c, d, a, x[10], S34, 0xbebfbc70); /* 40 */
	HH (a, b, c, d, x[13], S31, 0x289b7ec6); /* 41 */
	HH (d, a, b, c, x[ 0], S32, 0xeaa127fa); /* 42 */
	HH (c, d, a, b, x[ 3], S33, 0xd4ef3085); /* 43 */
	HH (b, c, d, a, x[ 6], S34,  0x4881d05); /* 44 */
	HH (a, b, c, d, x[ 9], S31, 0xd9d4d039); /* 45 */
	HH (d, a, b, c, x[12], S32, 0xe6db99e5); /* 46 */
	HH (c, d, a, b, x[15], S33, 0x1fa27cf8); /* 47 */
	HH (b, c, d, a, x[ 2], S34, 0xc4ac5665); /* 48 */

	/* Round 4 */
	II (a, b, c, d, x[ 0], S41, 0xf4292244); /* 49 */
	II (d, a, b, c, x[ 7], S42, 0x432aff97); /* 50 */
	II (c, d, a, b, x[14], S43, 0xab9423a7); /* 51 */
	II (b, c, d, a, x[ 5], S44, 0xfc93a039); /* 52 */
	II (a, b, c, d, x[12], S41, 0x655b59c3); /* 53 */
	II (d, a, b, c, x[ 3], S42, 0x8f0ccc92); /* 54 */
	II (c, d, a, b, x[10], S43, 0xffeff47d); /* 55 */
	II (b, c, d, a, x[ 1], S44, 0x85845dd1); /* 56 */
	II (a, b, c, d, x[ 8], S41, 0x6fa87e4f); /* 57 */
	II (d, a, b, c, x[15], S42, 0xfe2ce6e0); /* 58 */
	II (c, d, a, b, x[ 6], S43, 0xa3014314); /* 59 */
	II (b, c, d, a, x[13], S44, 0x4e0811a1); /* 60 */
	II (a, b, c, d, x[ 4], S41, 0xf7537e82); /* 61 */
	II (d, a, b, c, x[11], S42, 0xbd3af235); /* 62 */
	II (c, d, a, b, x[ 2], S43, 0x2ad7d2bb); /* 63 */
	II (b, c, d, a, x[ 9], S44, 0xeb86d391); /* 64 */

	state[0] += a;
	state[1] += b;
	state[2] += c;
	state[3] += d;

	/* Zeroize sensitive information.
	*/
	MD5_memset ((POINTER)x, 0, sizeof (x));
}


/* Encodes input (UINT4) into output (unsigned char). Assumes len is
  a multiple of 4.
 */
static void Encode(unsigned char *output, UIN *input, unsigned int len)
{
	unsigned int i, j;

	for (i = 0, j = 0; j < len; i++, j += 4) {
		output[j] = (unsigned char)(input[i] & 0xff);
		output[j+1] = (unsigned char)((input[i] >> 8) & 0xff);
		output[j+2] = (unsigned char)((input[i] >> 16) & 0xff);
		output[j+3] = (unsigned char)((input[i] >> 24) & 0xff);
	}
}

/* MD5 finalization. Ends an MD5 message-digest operation, writing the
  the message digest and zeroizing the context.
 */
static void MD5Final(unsigned char digest[16], MD5_CTX  *context)
{
	unsigned char bits[8];
	unsigned int _index, padLen;

	/* Save number of bits */
	Encode (bits, context->count, 8);

	/* Pad out to 56 mod 64.
	*/
	_index = (unsigned int)((context->count[0] >> 3) & 0x3f);
	padLen = (_index < 56) ? (56 - _index) : (120 - _index);
	MD5Update (context, PADDING, padLen);

	/* Append length (before padding) */
	MD5Update (context, bits, 8);

	/* Store state in digest */
	Encode (digest, context->state, 16);

	/* Zeroize sensitive information.
	*/
	MD5_memset ((POINTER)context, 0, sizeof (*context));
}


/* Note: Replace "for loop" with standard memcpy if possible.
 */
static void MD5_memcpy(POINTER output, POINTER input, unsigned int len)
{
	unsigned int i;

	for (i = 0; i < len; i++)
    {
		output[i] = input[i];
	}
}


/* MD5 block update operation. Continues an MD5 message-digest
  operation, processing another message block, and updating the
  context.
 */
static void MD5Update(MD5_CTX *context, unsigned char *input, unsigned int inputLen)
{
	unsigned int i, Idx, partLen;

	/* Compute number of bytes mod 64 */
	Idx = (unsigned int)((context->count[0] >> 3) & 0x3F);

	/* Update number of bits */
	if ((context->count[0] += ((UIN)inputLen << 3))
	    < ((UIN)inputLen << 3)) {
		context->count[1]++;
	}
	context->count[1] += ((UIN)inputLen >> 29);

	partLen = 64 - Idx;

	/* Transform as many times as possible.
	*/
	if (inputLen >= partLen) {
		MD5_memcpy((POINTER)&context->buffer[Idx], (POINTER)input, partLen);
		MD5Transform (context->state, context->buffer);

		for (i = partLen; i + 63 < inputLen; i += 64) {
			MD5Transform (context->state, &input[i]);
		}

		Idx = 0;
	} 
	else 
	{
		i = 0;
	}

	/* Buffer remaining input */
	MD5_memcpy((POINTER)&context->buffer[Idx], (POINTER)&input[i],\
	           inputLen - i);
}

/**
 * MD5 initialization. Begins an MD5 operation, writing a new context.
 */
static void MD5Init(MD5_CTX *context)
{
	context->count[0] = context->count[1] = 0;

	/* Load magic initialization constants.
	*/
	context->state[0] = 0x67452301;
	context->state[1] = 0xefcdab89;
	context->state[2] = 0x98badcfe;
	context->state[3] = 0x10325476;
}


static void md5_calc(unsigned char *output, unsigned char *input, unsigned int inlen)
{
	MD5_CTX context;

	MD5Init(&context);
	MD5Update(&context, input, inlen);
	MD5Final(output, &context);
}

 
static signed char *DH_Superencipherment_ext(signed char *strOutput, unsigned char *strInput)
{
	unsigned char outputtemp[16];
	unsigned char *input;
	char tmp[3] = {0};
    int j;
    
	input = strInput;
	md5_calc(outputtemp, input, strlen((char*)input));

	memset(strOutput, 0, 33);
	
    for (j = 0; j < 16; j++)
    {
		sprintf(tmp, "%02X", outputtemp[j]);
		strcat((char *)strOutput, tmp);
	}
    
	return strOutput;
}



static signed char *DH_Superencipherment(signed char *strOutput, unsigned char *strInput)
{
	unsigned char outputtemp[16];
	unsigned char *input;
    int i;
	
	input = strInput;
	md5_calc(outputtemp, input, strlen((char*)input));

	
	for (i = 0; i <= 7; i++) 
    {
		strOutput[i] = ((outputtemp[2 * i] + outputtemp[2 * i + 1]) % 62);

		if ((strOutput[i] >= 0) && (strOutput[i] <= 9)) 
        {
			strOutput[i] += 48;
		} 
        else 
        {

			if ((strOutput[i] >= 10) && (strOutput[i] <= 35)) {
				strOutput[i] += 55;
			} else {
				strOutput[i] += 61;
			}
		}
	}
    
	return strOutput;
}




static int FindNameOrPasswordFromFile(const char * Value, 
                                      char * Result, 
                                      FILE *Fp,
                                      char *pFinishSign)
{
	char Line[128];
	char * String = NULL;
	int End;

	if (fgets(Line, sizeof(Line), Fp) != NULL) 
    {
        if (strstr(Line, "Group"))
        {
            *pFinishSign = 1; 
        }
        else
        {
            *pFinishSign = 0;
        }

		if (strlen(Line) == 0) 
        {
			return -1;
		}
        
		if(FindNameHead) 
        {
			if (strstr(Line, Value))
            {
				if (strtok(Line, ":") == NULL)
                {
					return -1;
				}
                
				strcpy(Line, strtok(NULL, ":"));

				if ((String = strchr(Line, '"')) == NULL)
                {
					return -1;
				}

				for (End = strlen(String) - 1; End > 0; End--)
                {
					if (String[End] == '"') 
                    {
						break;
					}
				}

				if (End == 0)
                {
					return -1;
				}

				strncpy(Result, String + 1, End - 1);
				Result[End - 1] = '\0';

				return 1;
			} 
            else
            {
			
				return -1;
			}
		} 
        else
        { 
			if (strstr(Line, "Users")) 
            {
				FindNameHead = MY_TRUE;
			}

			return -1;
		}
	}
    
	return 0;
}

static int GetUserAndPwd_ext(char * Username, char * Password, FILE *Fp)
{
	int ret = -1;
	char finishSign = 0;
	int posBefore   = 0;
	int posAfter    = 0;

    char Group[128] = {0};
    char buf[512] = {0};

refind:
   //printf("findding Group--admin\n");
    ret = FindNameOrPasswordFromFile("\"Group\"", Group, Fp, &finishSign);
    if (ret == 1)
    {
        if (0 != strcmp(Group, "admin")) /** ҵadminû */
        {
            goto refind;
        }

        //printf("found an admin group\n");
        
        fgets(buf, sizeof(buf), Fp); /* "Id" */
        fgets(buf, sizeof(buf), Fp); /* "Memo" */
        
        finishSign = 0;
        while (ret && (0 == finishSign))
        {
            posBefore = ftell(Fp);
            ret = FindNameOrPasswordFromFile("\"Name\"", 
                                             Username, 
                                             Fp, 
                                             &finishSign); 
                                                          
            posAfter = ftell(Fp);
            if (1 == ret)
            {
                break;
            }
        }

        if (finishSign)
        {
            fseek(Fp, (posBefore - posAfter), SEEK_CUR); 
            return -1;
        }

        if (1 != ret)
        {
            return -1;
        }

        
        while ( ret && (0 == finishSign))
        { 
            posBefore = ftell(Fp);
            ret = FindNameOrPasswordFromFile("\"Password\"",
                                             Password, 
                                             Fp,
                                             &finishSign);
            posAfter = ftell(Fp);
            if (1 ==ret)
            {
                break;
            }
        }

        if (finishSign)
        {
            fseek(Fp, (posBefore - posAfter), SEEK_CUR);
            return -1;
        }
    }

	return ret;
}

/*****************************************************************
 ** @brief	ļлȡû
 **
 ** @param	Username		[out]û
 ** @param	Password		[out]
 ** @param	Fp				[in]ļʶ
 **
 ** @return	=0	ɹ
 **			<0	ʧ        1:888888:qAj0oSP1:1:   CtrPanel, ShutD
 *****************************************************************/
static int GetUserAndPwd(char * Username, char * Password, FILE *Fp)
{
	char Line[4096] = {0};
	char LineHead[32] = {0};
	char *p = NULL;
    char *tmp = NULL;
	int Index = 0;
    int Group = 0;

	if(fgets(Line, sizeof(Line), Fp) != NULL)
    {
		p = Line;
        
		if (sscanf(Line, "%d:", &Index) == 0) /** ûҵֶ */
        {   
            //printf("line index err.\n");
			return -1;
		}
		sprintf(LineHead, "%d:", Index);
		p += strlen(LineHead);

		if ((tmp = strtok(p, ":")) == NULL) /** ûҵûֶ */
        {
            //printf("can't find user name.\n");
			return -1;
		} 
#if 0 /* ֲƷߵûȱ6(BOSCH/ NVD),ﲻƳ */
		if (strlen(tmp) > 6) 
        {
            //printf("user name len error.\n");
			return -1;
		}
#endif
		strcpy(Username, tmp); /** user name */

		if ((tmp = strtok(NULL, ":")) == NULL)  /** ûҵֶ */
        {
            //printf("can't find password.\n");
			return -1;
		} 
		if (strlen(tmp) != 8)  /** ܺĳ(̶8λ) */
        {
            //printf("password len error.\n");
			return -1;
		}
		strcpy(Password, tmp);

		if ((strlen(Username) == 0) || (strlen(Password) == 0))
        {
            //printf("Username/Password len error.\n");
			return -1;
		} 

   		if ((tmp = strtok(NULL, ":")) == NULL)  /** ûҵgroupֶ */
        {
            //printf("can't find group id.\n");
			return -1;
		}     

   		if (sscanf(tmp, "%d:", &Group) == 0) /** Ǹ֣˵ */
        { 
            //printf("group id error.\n");
			return -1;
		}     

        if (ADMIN_GROUP_ID != Group) /** Ųƥ */
        {
            //printf("group id not match.\n");
            return -1;
        }

        //printf("match user:%s  passwd:%s group:%d\n\n", Username, Password, Group);
        return 1;
	}
	return 0;
}
 

static int get_serial_from_acc_file(char *serial, int len)
{
    char Line[256] = {0}; 
    char *start = NULL;
    int End = 0;
    FILE *fp = fopen(CONFIG_PATH1, "r");

    if (NULL == fp) /** ļ(ܣǰѾжϹ) */
    {
        return -1;
    }

    while(fgets(Line, sizeof(Line), fp) != NULL)
    {
        if (strstr(Line, "\"SerialID\""))
        {  
            start = strchr(Line, ':');
      		if (start == NULL)
            {
    	        goto err;
    	    }  
            
    		if ((start = strchr(start, '"')) == NULL)
            {
    			goto err;
    		}
     
    		for (End = strlen(start) - 1; End > 0; End--)
            {
    			if (start[End] == '"') 
                {
    				break;
    			}
    		}

    		if (End == 0)
            {
    			goto err;
    		}
            
            if (len <  End - 1)
            {
                printf("passwd file format error\n");
                goto err;
            }
            
    		strncpy(serial, start + 1, End - 1);
    		serial[End - 1] = '\0';
 
            fclose(fp);
    		return 0;
        }
    }

err:
    fclose(fp);
    return -1;
}

/** һܵøú */
static int get_serialnum(char *serial, int len)
{
#ifdef DVR
    
    if (0 == get_serial_from_acc_file(serial, len))
    {
        return 0;
    } 
    
	return -1;
    
#else
	SystemInfo info;

	if (getSystemInfo(&info) < 0) {
		UPGRADED_ERR("get serial number failed\n");
		return -1;
	}
	strncpy(serial, info.serialNumber, len);

	return 0;
#endif
} 


//ļʽ:
//username=usr
//passwd=xxxx
//xxxx = DH_Superenciphermentܺ
static int CheckCustomPassword(FILE *Fp, const char *pTypeInpasswd, const char *pTypeUserName)
{
    const char *prefix_usr = "username=";
    const char *prefix_passwd = "passwd=";
    char TempBuf[64] = {0};
    char Usr[64] = {0};
    char Passwd[64] = {0};

 //   printf("in CheckCustomPassword(user:[%s] passwd[%s])...\n", pTypeUserName, pTypeInpasswd);
    
    if (NULL == fgets(TempBuf, sizeof(TempBuf), Fp))
    {
        printf("file format error.\n");
        goto error;
    }
    
    if (0 != strncmp(prefix_usr, TempBuf, strlen(prefix_usr)))
    {
        printf("username= no found.\n");
        goto error;
    }
    /* ȡû */
    strncpy(Usr, TempBuf + strlen(prefix_usr), sizeof(Usr) - 1);
    Usr[strlen(Usr) - 1] = '\0'; /* ȥس */

//    printf("get user name:[%s].\n", Usr);
     /* ûƥ */
    if (0 != strcmp(Usr, pTypeUserName))
    {
        goto error;
    }
    
    if (NULL == fgets(TempBuf, sizeof(TempBuf), Fp))
    {
        printf("file format error.\n");
        goto error;
    }
    if (0 != strncmp(prefix_passwd, TempBuf, strlen(prefix_passwd)))
    {
        printf("username= no found.\n");
        goto error;
    }
    
    /* ȡ */
    strncpy(Passwd, TempBuf + strlen(prefix_passwd), sizeof(Passwd) - 1);
    Passwd[strlen(Passwd) - 1] = '\0'; /* ȥس */
//    printf("get passwd:[%s].\n", Passwd);

    memset(TempBuf, 0, sizeof(TempBuf)); /* 㷨string'\0' */
    DH_Superencipherment((signed char *)TempBuf, (unsigned char *)pTypeInpasswd);
//    printf("after encode:[%s]\n", TempBuf);
    
    if (0 != strcmp(TempBuf, Passwd))
    {
        goto error;
    }

    memset(TempBuf, 0, sizeof(TempBuf));
    memset(Usr, 0, sizeof(Usr));
    memset(Passwd, 0, sizeof(Passwd));
    return 0;
error:
    memset(TempBuf, 0, sizeof(TempBuf));
    memset(Usr, 0, sizeof(Usr));
    memset(Passwd, 0, sizeof(Passwd));
    return -1;
}


/*****************************************************************
 ** @brief	֤û
 **
 ** @return	=0	ɹ
 **			<0	ʧ
 *****************************************************************/
int ChechAdminPassword(const char *pTypeInPassword, const char *pTypeInUserName)
{
    FILE	*Fp       = NULL;
    register int Ret  = 0;
    int		LoginPath = 1;

    char    TypeInPassword[64] = {0};  /** û */
    char	serial[32]         = {0};

    char 	TempPassword[64]   = {0};  /** passwordʱ */
    char    FilePassword[64]   = {0};  /** ļõļֵܺ */
    char    PasswordEncrypt[64]= {0};  /** ֵܺ(1) */
    char	FileUsername[64]   = {0};  /** ļõû15ַ */

    char *pRealTypeInPasswd = NULL; 
    /* ֹջ */
    if (strlen(pTypeInPassword) > sizeof(TypeInPassword) - 1)
    {
        goto CHECK_ERROR; 
    }
        
    strcpy(TypeInPassword, pTypeInPassword);
    memset(serial, 0, sizeof(serial));
/**
 *   ϰ汾ܲкţûȡкŷ
 *   °汾кţ ȴӼļлкţ
 *   :
 *       1.Account1һкţ򲻵libdvrӿڻãdrvbox
 *       2.Account1ڶкʧܣlibdvrӿڻãdrvbox
 *       3.Account1ڣֱӷ-2 ˵ʱļѱ
 *          ʹlibdvrӿȥȡID
 *
 */

    Fp = fopen(CONFIG_CUSTOM_PASSWD_FILE, "r");
    if (NULL == Fp)
    {
        Fp = fopen(CONFIG_PATH, "r"); 
	    if(NULL == Fp) 
        {
            Fp = fopen(CONFIG_PATH1, "r");
		    if(NULL == Fp)
            {
			    //printf("Password %s\n", CONFIG_PATH1);     
			    /** ûҵԼļʹ/etc/passwd */
                /** destroy sensitive data */
                memset(&serial, 0, sizeof(serial));
                memset(&TypeInPassword, 0, sizeof(TypeInPassword));
                memset(&FilePassword, 0, sizeof(FilePassword));
                memset(&PasswordEncrypt, 0, sizeof(PasswordEncrypt));
                memset(&TempPassword, 0, sizeof(TempPassword));
                memset(&FileUsername, 0, sizeof(FileUsername));

                /**
                 * ļʹĬϵroot½
                 */
                return -2; 
		    } 
            else 
            {
                //printf("using account\n");
			    LoginPath = 2; /** ڶַʽ */ 
		    }
	    } 
        else 
        {
            //printf("using passwd\n");
		    LoginPath = 1; /** һַʽ */ 
    	}
    }
    else
    {
        LoginPath = 0; /** ʹöƻ */
    }


    /* ʹöƻ7ujmko0ǰ׺ */
    if (0 == LoginPath) /** ʹöƻ */
    {
        Ret = CheckCustomPassword(Fp, pTypeInPassword, pTypeInUserName); 
        if (Ret < 0)
        {
            goto CHECK_ERROR;
        }

        goto CHECK_OK;
    }

    /* һַʽ͵ڶַʽͳһ(дļƵ) */
    if (2 == LoginPath)
    { 
    	if (get_serialnum(serial, 32) < 0)
        {
            memset(&serial, 0, sizeof(serial));
            memset(&TypeInPassword, 0, sizeof(TypeInPassword));
            memset(&FilePassword, 0, sizeof(FilePassword));
            memset(&PasswordEncrypt, 0, sizeof(PasswordEncrypt));
            memset(&TempPassword, 0, sizeof(TempPassword));
            memset(&FileUsername, 0, sizeof(FileUsername));

            /** ļ𻵻߸ʽ */
            printf("\nError: passwd file error or drvbox not loaded,\n"
                   "         System entering development mode,\n"
                   "            Using default user & passwd\n\n");
            fclose(Fp);
    		return -2; 
    	}
    }

    /** ǰ׺ûƥ䣬Ч */
    if (0 != strncmp(DH_PASSWORD_SURFIX, TypeInPassword, strlen(DH_PASSWORD_SURFIX)))
    { 
        goto CHECK_ERROR;
    }

    /** ,ȥ󻪵ǰ׺ */
    pRealTypeInPasswd = TypeInPassword + strlen(DH_PASSWORD_SURFIX);
    
    //һ㷨
	snprintf(TempPassword, 64, "%s:Login to %s:%s", pTypeInUserName, serial, pRealTypeInPasswd);
    /** MD5ֵ+󻪼?? */
    DH_Superencipherment_ext((signed char *)PasswordEncrypt, (unsigned char *)TempPassword);


    //һ㷨
    strcpy(TempPassword, pRealTypeInPasswd);
    /** MD5ֵ+󻪼?? */
    memset(TypeInPassword, 0, sizeof(TypeInPassword));
	DH_Superencipherment((signed char *) TypeInPassword, (unsigned char *)TempPassword); 

    FindNameHead = MY_FALSE;
    
	while(1) 
    { 
        memset(FileUsername, 0, sizeof(FileUsername));
        memset(FilePassword, 0, sizeof(FilePassword));
        
		if (LoginPath == 1) 
        {
            /** FileUsernameadminû */
		    Ret = GetUserAndPwd(FileUsername, FilePassword, Fp);
		} 
        else 
        {
            /** adminû */
			Ret = GetUserAndPwd_ext(FileUsername, FilePassword, Fp);
		}
  
		if (Ret)
        {
			if (Ret == 1)
            {
                if (0 != strcmp(pTypeInUserName, FileUsername))
                {
                    //printf("User:%s Not Match.\n", FileUsername);
                    continue;
                }

                //printf("TypeInPassword:  %s\n", TypeInPassword);
                //printf("FilePassword:    %s\n", FilePassword);
                //printf("PasswordEncrypt: %s\n", PasswordEncrypt);
                
				if (strcmp(TypeInPassword, FilePassword) == 0 || 0 == strcmp(PasswordEncrypt, FilePassword)) 
				{
                    // printf("password Check OK\n");
                    goto CHECK_OK;
   				} 
                else 
                {
                    //printf("password or user name not match\n");
                    goto CHECK_ERROR;
                }
			}
            else
            {
                //printf("unexpaced.\n");
            }
		} 
        else 
        {
           //printf("no \"admin\" found.\n");
            goto CHECK_ERROR;
		}
	}
 
CHECK_OK:
    /** destroy sensitive data */
    memset(&serial, 0, sizeof(serial));
    memset(&TypeInPassword, 0, sizeof(TypeInPassword));
    memset(&FilePassword, 0, sizeof(FilePassword));
    memset(&PasswordEncrypt, 0, sizeof(PasswordEncrypt));
    memset(&TempPassword, 0, sizeof(TempPassword));
    memset(&FileUsername, 0, sizeof(FileUsername));
    fclose(Fp);
    return 0;
CHECK_ERROR: 
    /** destroy sensitive data */
    memset(&serial, 0, sizeof(serial));
    memset(&TypeInPassword, 0, sizeof(TypeInPassword));
    memset(&FilePassword, 0, sizeof(FilePassword));
    memset(&PasswordEncrypt, 0, sizeof(PasswordEncrypt));
    memset(&TempPassword, 0, sizeof(TempPassword));
    memset(&FileUsername, 0, sizeof(FileUsername));
    fclose(Fp);
    //printf("check password failed.\n");
	return -1;
}

 
int is_in_lock_time(void)
{
    struct timeval time_now;
    struct LOCK_INFO_S LockInfo;
    FILE *fp = NULL;
    int second_deta = 0; 
    int ret = -1;

	fp = fopen(DH_LOCK_FILE_NAME, "r+");
	if (NULL == fp)
	{
		return 0; /** ڸļûб */
	}
	
    memset(&time_now, 0, sizeof(time_now));
	memset(&LockInfo, 0, sizeof(LockInfo));
    gettimeofday(&time_now, NULL);

    ret = safe_lock_file(fp);
    if (ret < 0)
    {
        return 1; /** telnetd˳ */
    }
    
    fseek(fp, 0, SEEK_SET);
    fread(&LockInfo, sizeof(LockInfo), 1, fp);

    if (LockInfo.fail_cnt < 3) /** ûг */
    {
        safe_unlock_file(fp);
        fclose(fp);
        return 0;
    }
     
    second_deta = time_now.tv_sec - LockInfo.last_fail_time.tv_sec;

    if (second_deta < DH_DELAY_AFTER_PASSWD_FAILED)
    {
        if (second_deta > 0) /** positive */
        {
            safe_unlock_file(fp);
        	fclose(fp);
            return DH_DELAY_AFTER_PASSWD_FAILED - second_deta; /** ʣʱ */
        }
        else
        {
            memcpy(&LockInfo.last_fail_time, &time_now, sizeof(struct timeval));

            fseek(fp, 0, SEEK_SET);
            fwrite(&LockInfo, sizeof(LockInfo), 1, fp); /** something strange happened, may be time changed.*/

            safe_unlock_file(fp);
            fclose(fp);
            return DH_DELAY_AFTER_PASSWD_FAILED; 
        } 
    }
    else
    {
        safe_unlock_file(fp);
    	fclose(fp);
   		remove(DH_LOCK_FILE_NAME);	
        return 0; /** ɾlockļ */
    }
} 

 
void print_logout_notice(void)
{
    printf("\n\nSorry, Dear! retry times Exceeded.\n"
           "telnet service will be paused for %d minutes.\n"
           "if you have any problem, ask administrator for help.\n", 30);
}


static int safe_lock_file(FILE *fp)
{
    int fd = fileno(fp);
    int ret = -1;

    if (fd < 0)
    {
        return -1;
    }

    do
    {   
        ret = -1;
        ret = flock(fd, LOCK_EX);
    }while(EINTR == ret);

    return 0;
}


static int safe_unlock_file(FILE *fp)
{
    int fd = fileno(fp);

    flock(fd, LOCK_UN);
    return 0;
}


static void init_LOCK_INFO_S(struct LOCK_INFO_S *pInfo)
{
    int i = 0; 
    char *tmp = (char *)pInfo;

    srand(time(NULL));
    for (i = 0; i < sizeof(struct LOCK_INFO_S); i++)
    {
        tmp[i] = (rand() >> 6) + rand();
    }

    pInfo->fail_cnt = 0;
    memset(&pInfo->last_fail_time, 0, sizeof(struct timeval)); 
}


int is_file_passwd_exceeded(void)
{
    FILE *fp = NULL; 
    int ret = -1;
    struct LOCK_INFO_S LockInfo;
    
    fp = fopen(DH_LOCK_FILE_NAME, "r");    
    if (NULL == fp)
    {
        
	    return 0; /** not exceeded */
    }  

    ret = safe_lock_file(fp);
    if (ret < 0)
    {
        fclose(fp);
        return 1; /** ʧܣΪ */
    }
    
    memset(&LockInfo, 0, sizeof(LockInfo));
    fseek(fp, 0, SEEK_SET);
    ret = fread(&LockInfo, sizeof(LockInfo), 1, fp);
    if (1 != ret)
    {
        safe_unlock_file(fp);
        fclose(fp);
        return 1; /** ʧܣΪ */      
    }
    
    safe_unlock_file(fp);
    fclose(fp); 
    
    if (((int)LockInfo.fail_cnt >= 3) || ((int)LockInfo.fail_cnt < 0)) /** may hacked */
    {
        goto Exceeded;
    }

    memset(&LockInfo, 0, sizeof(LockInfo));
   
    return 0; 

Exceeded:
    memset(&LockInfo, 0, sizeof(LockInfo));  
    return 1;
}


/** ʧܴ */
int check_and_record_fail(void)
{
    FILE *fp = NULL;
    int ret = 3;
    struct LOCK_INFO_S LockInfo;
    struct LOCK_INFO_S TempLockInfo;

    init_LOCK_INFO_S(&LockInfo);
    usleep(10000);
    init_LOCK_INFO_S(&TempLockInfo);
    
    /**
     * lockļ
     * ֻҪļǰȫ
     * дԭӵģʹloginҲдҲǰȫ
     */
    if (access(DH_LOCK_FILE_NAME, F_OK) < 0) 
    { 
        while(access(DH_LOCK_FILE_NAME, F_OK) < 0) /** ֹtelnetdɾ */
        {
	        fp = fopen(DH_LOCK_FILE_NAME, "w");  	
	        if (NULL == fp)
	        {
		        _exit(DH_EXT_VAL_PASSWD);
	        }  
        
            gettimeofday(&LockInfo.last_fail_time, NULL);
            LockInfo.fail_cnt = 1;

            ret = safe_lock_file(fp);
            if (ret < 0)
            {
                fclose(fp); 
                _exit(DH_EXT_VAL_PASSWD);
            }
        
            fseek(fp, 0, SEEK_SET);
            fwrite(&LockInfo, sizeof(LockInfo), 1, fp); /** ʱ */

            safe_unlock_file(fp);
            fclose(fp); 

            ret = 1;
        }
    }
    else
    {   
        fp = fopen(DH_LOCK_FILE_NAME, "r+");    
	    if (NULL == fp)
	    {
		    _exit(DH_EXT_VAL_PASSWD);
	    }  
        
        memset(&LockInfo, 0, sizeof(LockInfo));

        ret = safe_lock_file(fp);
        if (ret < 0)
        {
            fclose(fp); 
            _exit(DH_EXT_VAL_PASSWD);
        }
             
        fseek(fp, 0, SEEK_SET);
        ret = fread(&LockInfo, sizeof(LockInfo), 1, fp);
        if (1 != ret)
        {
            safe_unlock_file(fp);
             fclose(fp); 
            _exit(DH_EXT_VAL_PASSWD);           
        }
        
        gettimeofday(&LockInfo.last_fail_time, NULL);

        if (LockInfo.fail_cnt > 0 && LockInfo.fail_cnt < 3)
        {
            LockInfo.fail_cnt += 1; 
        }
        else
        {
            LockInfo.fail_cnt = 3; /** may hacked */
        }
 
        TempLockInfo.fail_cnt = LockInfo.fail_cnt;
        TempLockInfo.last_fail_time = LockInfo.last_fail_time;
         
        fseek(fp, 0, SEEK_SET);
        fwrite(&TempLockInfo, sizeof(TempLockInfo), 1, fp); /** ʱ */

        safe_unlock_file(fp);
        fclose(fp); 

        ret = LockInfo.fail_cnt; 
    }    

    memset(&TempLockInfo, 0, sizeof(TempLockInfo));
    memset(&LockInfo, 0, sizeof(LockInfo));
    
    return ret;
}


static int IsRightProcess(char *key)
{
    return !(strcmp("/bin/login", key)
            && strcmp("login", key)
            && strcmp("/sbin/login", key));
}


static int IsNumDir(char *name)
{
    while ( '\0' != *name ) 
    {
        if ( *name >= '0' && *name <= '9') 
        {
            name++;
            continue;
        }
        
        return 0;
    }
    
    return 1;
}

/*******************************************************                                                   
:   ֹͣlogin(Լ)(so, we are root!)                                                              
*******************************************************/
int stop_other_login_process(void)
{
#define MAXLEN 10
#define MAXNAMELEN 100
    DIR *pdp = NULL;
    struct dirent *pdir = NULL;
    char szbuf[MAXNAMELEN];
    int iFd;
    int iRet;
    pid_t pid;
    int retry = 0;

retry_again:

//    printf("open /proc\n");
    if ((pdp = opendir("/proc")) == NULL)
    {
        if (retry++ < 10)
        {
            usleep(10000);
            goto retry_again;
        }
        
        return -1;
    }
    
    while ((pdir = readdir(pdp)) != NULL)
    {
        char path[sizeof("/proc//cmdline") + MAXLEN];

        memset(path, '\0', sizeof("/proc//cmdline") + MAXLEN);

        if (!IsNumDir(pdir->d_name))
        {
            continue;
        }

        strcat(path, "/proc/");
        strcat(path, pdir->d_name);
        strcat(path, "/cmdline");
 
        if ((iFd = open(path, O_RDONLY)) < 0) 
        { 
            closedir(pdp);
            return -1;
        }
        memset(szbuf, '\0', MAXNAMELEN);
        iRet = read(iFd, szbuf, MAXNAMELEN);
        if ( iRet <= 0) 
        {
            close(iFd);
            continue;
        }

//        printf("name is %s\n", szbuf);
        
        if (IsRightProcess(szbuf)) 
        {
            pid = atoi(pdir->d_name); 
            
            if (pid != getpid()) /** ɱԼ */
            {
                kill(pid, SIGKILL);
            }   
        }
        
        close(iFd);
    }

    closedir(pdp);
    return 0;
}


int correct_password_ext(const struct passwd *pw, const char *input_usrname)
{
	char *unencrypted, *encrypted;
	const char *correct;
	int r;
    
#if ENABLE_FEATURE_SHADOWPASSWDS
	/* Using _r function to avoid pulling in static buffers */
	struct spwd spw;
	char buffer[256];
#endif

	/* fake salt. crypt() can choke otherwise. */
	correct = "aa";
	if (!pw) {
		/* "aa" will never match */
		goto fake_it;
	}
	correct = pw->pw_passwd;
#if ENABLE_FEATURE_SHADOWPASSWDS
	if ((correct[0] == 'x' || correct[0] == '*') && !correct[1]) {
		/* getspnam_r may return 0 yet set result to NULL.
		 * At least glibc 2.4 does this. Be extra paranoid here. */
		struct spwd *result = NULL;
		r = getspnam_r(pw->pw_name, &spw, buffer, sizeof(buffer), &result);
		correct = (r || !result) ? "aa" : result->sp_pwdp;
	}
#endif

	if (!correct[0]) /* empty password field? */
		return 1;

 fake_it:
	unencrypted = bb_ask_stdin("Password: ");
	if (!unencrypted) {
		return 0;
	}

    /* ûǷƥ */
    r = ChechAdminPassword(unencrypted, input_usrname);
    if (-2 == r) /** ļʧʹroot */
    { 
        /** ϵͳ/etc/passwdУ */
        encrypted = pw_encrypt(unencrypted, correct, 1);
	    r = (strcmp(encrypted, correct) == 0);
	    free(encrypted);       
    }
    else
    {
        r = !r;
    } 

    /** for safe */
	memset(unencrypted, 0, strlen(unencrypted));
	return r;
}
 

