/**
 * system/src/bld/main.c
 *
 * History:
 *    2005/01/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2007, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <common.h>
#include <command.h>
#include <net.h>
#include <miiphy.h>
#include <malloc.h>
#include <net.h>
#include <netdev.h>
#include <asm/errno.h>
#include <asm/io.h>

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/basedef.h>
#include <asm/arch/ambhw/eth.h>
#include <asm/arch/netdev/tftp.h>
#include <asm/arch/bldnet.h>
#include <asm/arch/bldfunc.h>
#include <asm/arch/ambhw/intvec.h>


#include <asm/arch/bldfunc.h>
#include <asm/arch/ambhw.h>
#define __FLDRV_IMPL__
#include <asm/arch/fio/firmfl.h>
#include <asm/arch/hal/hal.h>

extern void get_stepping_info(int *chip, int *major, int *minor);
extern void rct_set_usb_debounce(void);
extern void rct_set_usb_ext_clk(void);
extern int a5s_nand_init(void);
extern int a5s_nand_reset(void);
extern int amb_gpio_init(void);



extern const u32 hotboot_valid;
extern const u32 hotboot_pattern;

extern int amboot_bsp_self_refresh_exit(void) __attribute__ ((weak));
extern int amboot_bsp_self_refresh_check_valid(void) __attribute__ ((weak));
extern int amboot_bsp_power_off(void) __attribute__ ((weak));
extern int amboot_bsp_hw_init(void) __attribute__ ((weak));
extern int amboot_bsp_system_init(void) __attribute__ ((weak));
extern int amboot_bsp_check_usbmode(void) __attribute__ ((weak));
extern int amboot_bsp_cortex_init_pre(void) __attribute__ ((weak));
extern int amboot_bsp_cortex_init_post(void) __attribute__ ((weak));
extern int amb_gpio_direction_output(int gpio,int value);

int changed_to_ext_pll = 0;

void set_softdisc(void)
{

 if (usb_check_connected()) {

  *(volatile u32 *)(((0x60000000 + 0x6000) + (0x404))) = 0x00000400;
  *(volatile u32 *)(((0x60000000 + 0x6000) + (0x400))) = 0x00000004;
 }

} 

void init_usb_pll(void)
{
 rct_set_usb_debounce();

 udelay(1000);
 if(!changed_to_ext_pll)
  rct_enable_usb();
 else
  rct_set_usb_ext_clk();

 udelay(1000);

 set_softdisc();

}


void enable_usb_reg(void)
{
    init_usb_pll();
}

int usb_check_connected(void)
{

 vic_set_type(0, 4);


 if ((*(volatile unsigned int *)(((0x60000000 + 0x3000) + (0x08)))) & 1)
  return 1;
 else
  return 0;
}

void usb_disconnect(void)
{
// enable_usb_reg();
 set_softdisc();
 rct_suspend_usb();
}

static void uart_init(void)
{

#if	defined(AMBOOT_UART_19200)
	static const int baud = 19200;
#elif	defined(AMBOOT_UART_38400)
	static const int baud = 38400;
#elif	defined(AMBOOT_UART_57600)
	static const int baud = 57600;
#else
	static const int baud = 115200;
#endif
	u32 clk;
	u16 dl;

	rct_set_uart_pll();
	writeb(0x00, UART0_REG(UART_SRR_OFFSET));

#if	defined(__FPGA__)
	clk = get_apb_bus_freq_hz();
#else
	clk = get_uart_freq_hz();
#endif

	dl = clk * 10 / baud / 16;
	if (dl % 10 >= 5)
		dl = (dl / 10) + 1;
	else
		dl = (dl / 10);

	writeb(UART_LC_DLAB, UART0_LC_REG);
	writeb(dl & 0xff, UART0_DLL_REG);
	writeb(dl >> 8, UART0_DLH_REG);
	writeb(UART_LC_8N1, UART0_LC_REG);
}


/**
 * The C entry point of the bootloader.
 */
int a5s_base_init(void)
{
    unsigned int boot_from = rct_boot_from();
    
    amb_gpio_init();
    //amb_gpio_direction_output(PHY_RESET_PIN,1);//enable PHY for scan
    uart_init();
    /* RCT/PLL setup */
    rct_pll_init();
    rct_switch_core_freq();

    /* RCT/PLL  setup */
    rct_reset_fio();
    fio_exit_random_mode();
    enable_fio_dma();

    //led_init();;
    //led_on(); 
    /* Initialize various peripherals used in AMBoot */
    //vic_init();

    /* Initial firmware information */
    //set_part_dev();

	/* initial boot device */
    if ((boot_from & BOOT_FROM_NAND) == BOOT_FROM_NAND) {
        a5s_nand_init();
        a5s_nand_reset();		
        //nand_scan_bbt(0);
        
        /* Alway attempt to load HAL and set it up! */ 
        hal_init();
        set_dram_arbitration();

        rct_x_usb_clksrc();
        if (amboot_bsp_hw_init != NULL) { 
            amboot_bsp_hw_init();
        }

#if defined(CONFIG_AMBOOT_BAPI_SUPPORT)
        cmd_bapi_init(0);
#endif

        usb_disconnect(); 

        if (amboot_bsp_system_init != NULL) {
            amboot_bsp_system_init();
        }
    }

#if 0
#if defined(USE_HAL)
        /* DUMP BST and HAL Version */
        printf("BST (%d)",readl(g_haladdr + readl(g_haladdr + 0xc))); 
        if (amb_get_version(HAL_BASE_VP, &hal_version) != -1) {
        printf("  ,HAL (%d)\n",hal_version);
        } else {
        printf("0\n");
        } 
        printf("SYS (%08x)\n",amb_get_system_configuration(HAL_BASE_VP)); 
#endif

#if	(RCT_ARM_CLK_SRC_IDSP == 1 || RCT_ARM_CLK_SRC_CORE_DDR == 1)
        printf("Arm freq: %dMHz\n",get_arm_bus_freq_hz()/1000000); 
        printf("iDSP freq: %dMHz\n",get_idsp_freq_hz()/1000000); 
#endif
        printf("Core freq: %dMHz\n",get_core_bus_freq_hz()/1000000); 
        printf("Dram freq: %dMHz\n",get_ddr_freq_hz()/1000000); 
        printf("AHB freq: %dMHz\n",get_ahb_bus_freq_hz()/1000000); 
        printf("APB freq: %dMHz\n",get_apb_bus_freq_hz()/1000000); 
        printf("UART freq: %dMHz\n",get_uart_freq_hz()/1000000); 
        printf("SD freq: %dMHz\n",get_sd_freq_hz()/1000000); 
#if     (CHIP_REV == I1)
        printf("Cortex freq: ");
        printf("%d\n",amb_get_cortex_clock_frequency(HAL_BASE_VP)/100);
        printf("00\r\n");
        printf("AXI freq: ");
        printf("%d\n",amb_get_axi_clock_frequency(HAL_BASE_VP)/100);
        printf("00\r\n");
        printf("DDD freq: ");
        printf("%d\n",amb_get_3d_clock_frequency(HAL_BASE_VP));
        printf("\r\n");
        printf("GTX freq: ");
        printf("%d\n",amb_get_gtx_clock_frequency(HAL_BASE_VP));
        printf("\r\n");
        printf("SDXC freq: ");
        printf("%d\n",amb_get_sdxc_clock_frequency(HAL_BASE_VP));
        printf("\r\n");
#endif

#endif 

	return 0;
}
