/**
 * system/src/bld/loader.c
 *
 * History:
 *    2005/03/08 - [Charles Chiou] created file
 *    2007/10/11 - [Charles Chiou] added PBA partition
 *    2008/11/18 - [Charles Chiou] added HAL and SEC partitions
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <ambhw.h>
#include <bldfunc.h>
#define __FLDRV_IMPL__
#include <fio/firmfl.h>
#include <fio/firmfl_api.h>
#include <hotboot.h>
#include <self_refresh_const.h> 

extern u32 __heap_start;
extern u32 __heap_end;

/**
 * The bootloader may need to use code decompression algorithm
 * on images stored in flash memory. The memory pointed to by
 * by this address is used as a temporary storage area for the
 * compressed code when it is loaded from the flash memory.
 *
 * For now, we just use the last 16MB of DRAM.
 */
static const u32 G_scratch_addr = DRAM_START_ADDR + DRAM_SIZE - 0x1000000;
 
/*****************************************************************************/ 
#if !defined(CONFIG_NAND_NONE) || !defined(CONFIG_NOR_NONE) || \
    !defined(CONFIG_SNOR_NONE) || !defined(CONFIG_ONENAND_NONE) || \
    defined(FIRMWARE_CONTAINER)

extern u8 *atag_data;
static int boot_from_dev(u32 dev_id ,const char *cmdline, int verbose)
{
	int rval = 0;
	u32 rmd_start = 0;
	u32 rmd_size = 0;
	void *jump_addr = NULL;

    printf("hotboot_valid:0x%08x\r\n",hotboot_valid); 
 
	a5s_nand_read_byte(0xc0208000, 0x000e0000, 0x00456ad4);
	jump_addr = (void *)0xc0208000;
	if (jump_addr != 0x0) {
		if (verbose) {
			printf("jumping to %08x\n",(u32) jump_addr); 
		}

#if (ETH_INSTANCES >= 1)
		//bld_net_down();
		eth_halt();
#endif
        printf("MACH_ID:%08x\n",AMBOOT_DEFAULT_LINUX_MACHINE_ID);
		setup_tags(jump_addr, cmdline, 0xc0000000, 0x10000000,
			rmd_start, rmd_size, 1);
		printf("atag_data:%08x\n",atag_data);
		a5s_nand_read_byte(atag_data, 0x7ae0000, 0xf00);
		//cleanup_before_linux ();
		//return -1;
		jump_to_kernel(jump_addr);
	} 

	printf("return\n");
	return rval;
}
#endif

#if !defined(CONFIG_NAND_NONE)

/**
 * Try to boot from NAND.
 */
int a5s_nand_boot(const char *cmdline, int verbose)
{
	int i, rval = 0;
	
	rval = boot_from_dev(BOOT_DEV_NAND, cmdline, verbose);
done:

	return rval;
}    
#endif	/* ENABLE_FLASH */
