/**
 * system/src/bld/piggy_ptb.S
 *
 * History:
 *    2007/04/26 - [Charles Chiou] created file
 *    2007/10/11 - [Charles Chiou] added PBA partition
 *
 * Copyright (C) 2004-2007, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */


#include <ambhw.h>
#include <fio/firmfl.h>

.text

piggy_ptb:

/****************************************************************************/
/* flpart_table_t.bst                                                       */
/****************************************************************************/

#ifndef BST_CRC32
#error "BST_CRC32 not defined"
#endif
#ifndef BST_IMG_LEN
#error "BST_IMG_LEN not defined"
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef BST_VERSION_INFO
#include xstr(BST_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif

bst_part:	.word	BST_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	BST_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC

/****************************************************************************/
/* flpart_table_t.bld                                                       */
/****************************************************************************/

#ifndef BLD_CRC32
#error "BLD_CRC32 not defined"
#endif
#ifndef BLD_IMG_LEN
#error "BLD_IMG_LEN not defined"
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef BLD_VERSION_INFO
#include xstr(BLD_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif

bld_part:	.word	BLD_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	BLD_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC

/****************************************************************************/
/* flpart_table_t.pri                                                       */
/****************************************************************************/

pri_part:
	
#if (PRI_VALID == 1)
#ifndef PRI_CRC32
#define PRI_CRC32	0x0
#endif
#ifndef PRI_IMG_LEN
#define PRI_IMG_LEN	0x0
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef PRI_VERSION_INFO
#include xstr(PRI_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif
		.word	PRI_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	PRI_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC
#else
		.rept	7
		.word	0xffffffff
		.endr
#endif

/****************************************************************************/
/* flpart_table_t.bak                                                       */
/****************************************************************************/

bak_part:
		.word	0xffffffff
		.word	0xffffffff
		.word	0xffffffff
		.word	0xffffffff
		.word	0xffffffff
		.word	0xffffffff
		.word	0xffffffff

/****************************************************************************/
/* flpart_table_t.rmd                                                       */
/****************************************************************************/

rmd_part:
	
#if (RMD_VALID == 1)
#ifndef RMD_CRC32
#define RMD_CRC32	0x0
#endif
#ifndef RMD_IMG_LEN
#define RMD_IMG_LEN	0x0
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef RMD_VERSION_INFO
#include xstr(RMD_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif
		.word	RMD_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	RMD_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC
#else
		.rept	7
		.word	0xffffffff
		.endr
#endif

/****************************************************************************/
/* flpart_table_t.rom                                                       */
/****************************************************************************/

rom_part:
	
#if (ROM_VALID == 1)
#ifndef ROM_CRC32
#define ROM_CRC32	0x0
#endif
#ifndef ROM_IMG_LEN
#define ROM_IMG_LEN	0x0
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef ROM_VERSION_INFO
#include xstr(ROM_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif
		.word	ROM_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	ROM_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC
#else
		.rept	7
		.word	0xffffffff
		.endr
#endif

/****************************************************************************/
/* flpart_table_t.dsp                                                       */
/****************************************************************************/

dsp_part:

#if (DSP_VALID == 1)
#ifndef DSP_CRC32
#define DSP_CRC32	0x0
#endif
#ifndef DSP_IMG_LEN
#define DSP_IMG_LEN	0x0
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef DSP_VERSION_INFO
#include xstr(DSP_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif
		.word	DSP_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	DSP_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC
#else
		.rept	7
		.word	0xffffffff
		.endr
#endif

/****************************************************************************/
/* flpart_table_t.pba                                                       */
/****************************************************************************/

pba_part:

#if (PBA_VALID == 1)
#ifndef PBA_CRC32
#define PBA_CRC32	0x0
#endif
#ifndef PBA_IMG_LEN
#define PBA_IMG_LEN	0x0
#endif
#undef FIRM_VER_NUM
#undef FIRM_VER_DATE
#undef FIRM_MEM_ADDR
#undef FIRM_FLAG
#undef __VERSION_INFO__
#ifdef PBA_VERSION_INFO
#include xstr(PBA_VERSION_INFO)
#endif
#ifndef FIRM_VER_NUM
#define FIRM_VER_NUM	0x0
#endif
#ifndef FIRM_VER_DATE
#define FIRM_VER_DATE	0x0
#endif
#ifndef FIRM_MEM_ADDR
#define FIRM_MEM_ADDR	0x0
#endif
#ifndef FIRM_FLAG
#define	FIRM_FLAG	0x0
#endif
		.word	PBA_CRC32
		.word	FIRM_VER_NUM
		.word	FIRM_VER_DATE
		.word	PBA_IMG_LEN
		.word	FIRM_MEM_ADDR
		.word	FIRM_FLAG
		.word	FLPART_MAGIC
#else
		.rept	7
		.word	0xffffffff
		.endr
#endif

/****************************************************************************/
/* flpart_table_t.dev                                                       */
/****************************************************************************/

dev:	
/* sn: */	.rept	32
		.byte	0x0
		.endr

/* usbdl_mode: */
#ifdef AMBOOT_DEV_USBDL_MODE
		.byte	0x1
#else
		.byte	0x0
#endif

/* auto_boot: */
#ifdef AMBOOT_DEV_AUTO_BOOT
		.byte	0x1
#else
		.byte	0x0
#endif

/* cmdline: */
#ifdef AMBOOT_DEV_CMDLINE
		/* Hmmm... this is a hard one... We don't support it for now */
		/* .asciz AMBOOT_DEV_CMDLINE */
		.rept	512
		.byte	0x0
		.endr
#else
		.rept	512
		.byte	0x0
		.endr
#endif
/* rsv:	*/	.rept	2
		.byte	0xff
		.endr
	
#if (ETH_INSTANCES == 1)

/* eth_mac: */	.rept	6
		.byte	0xff
		.endr

/* lan_ip: */	.word	0xffffffff
/* lan_mask: */	.word	0xffffffff
/* lan_gw: */	.word	0xffffffff
/* auto_dl: */	.byte	0xff
/* tftpd: */	.word	0xffffffff
/* pri_addr: */	.word	0xffffffff
/* pri_file: */	.rept	32
		.byte	0x0
		.endr
/* pri_comp: */	.byte	0x0
/* rmd_addr: */	.word	0xffffffff
/* rmd_file: */	.rept	32
		.byte	0x0
		.endr
/* rmd_comp: */	.byte	0x0
/* dsp_addr: */	.word	0xffffffff
/* dsp_file: */	.rept	32
		.byte	0x0
		.endr
/* dsp_comp: */	.byte	0x0
/* rsv2: */	.rept	2
		.byte	0xff
		.endr

#endif  /* ETH_INSTANCES == 1 */

/* magic */	.word	FLPART_MAGIC
