/**
 * system/src/bld/testmem3.S
 *
 * History:
 *    2005/09/09 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

.text
.globl testram3
	@ r0 = address to start test
	@ r1 = size of memory to test
	@ returns r0 = 0 - ram present, r0 = <addr> - no ram at <addr>
testram3:
	stmdb	sp!, {r1 - r5, lr}

	mov	r2, #0x55		@ Setup test pattern 0x55555555
	orr	r2, r2, #0x5500
	orr	r2, r2, #0x550000
	orr	r2, r2, #0x55000000
	mov	r3, #0xaa		@ Setup test pattern 0xaaaaaaaa
	orr	r3, r3, #0xaa00
	orr	r3, r3, #0xaa0000
	orr	r3, r3, #0xaa000000

_loop:
	ldr	r4, [r0]	@ Read old value

	str	r2, [r0]	@ Write pattern 0x55555555
	ldr	r5, [r0]	@ Read it back
	cmp	r2, r5		@ Test if values match
	bne	bad

	str	r3, [r0]	@ Write pattern 0xaaaaaaaa
	ldr	r5, [r0]	@ Read it back
	cmp	r3, r5		@ Test if values match
	bne	bad

	str	r4, [r0]	@ Restore old value

	add	r0, r0, #4	@ Increment address
	sub	r1, r1, #4	@ Decrement size (count)
	cmp	r1, #0
	bne	_loop

	mov	r0, #0
	ldmia	sp!, {r1 - r5, pc}

bad:
	str	r4, [r0]	@ Restore old value anyway
	ldmia	sp!, {r1 - r5, pc}
