/*
 * Copyright (C) 2009, Texas Instruments, Incorporated
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <common.h>
#include <asm/cache.h>
#include <asm/arch/cpu.h>
#include <asm/arch/ddr_defs.h>
#include <asm/arch/ddr_defs_ti814x.h>
#include <asm/arch/hardware.h>
#include <asm/arch/sys_proto.h>
#include <asm/arch/clock.h>
#include <asm/arch/mem.h>
#include <asm/arch/nand.h>
#include <linux/mtd/nand.h>
#include <nand.h>
#include <net.h>
#include <miiphy.h>
#include <netdev.h>

//#include <asm/u-boot-arm.h>

#define DDR0_PHY_BASE_ADDR		0x47C0C400
#define DDR1_PHY_BASE_ADDR		0x47C0C800
#define EMIF4_0_SDRAM_ZQCR		(EMIF4_0_CFG_BASE + 0xC8)
#define EMIF4_1_SDRAM_ZQCR		(EMIF4_1_CFG_BASE + 0xC8)


static void cmd_macro_config(u32 ddr_phy, u32 inv_clk_out,
			 u32 ctrl_slave_ratio_cs0, u32 cmd_dll_lock_diff)
{
	u32 ddr_phy_base = (DDR_PHY0 == ddr_phy) ?
			 DDR0_PHY_BASE_ADDR : DDR1_PHY_BASE_ADDR;

	__raw_writel(inv_clk_out,
		 ddr_phy_base + CMD1_REG_PHY_INVERT_CLKOUT_0);
	__raw_writel(inv_clk_out,
		 ddr_phy_base + CMD0_REG_PHY_INVERT_CLKOUT_0);
	__raw_writel(inv_clk_out,
		 ddr_phy_base + CMD2_REG_PHY_INVERT_CLKOUT_0);

	__raw_writel(((ctrl_slave_ratio_cs0 << 10) | ctrl_slave_ratio_cs0),
		ddr_phy_base + CMD0_REG_PHY_CTRL_SLAVE_RATIO_0);
	__raw_writel(((ctrl_slave_ratio_cs0 << 10) | ctrl_slave_ratio_cs0),
		ddr_phy_base + CMD1_REG_PHY_CTRL_SLAVE_RATIO_0);
	__raw_writel(((ctrl_slave_ratio_cs0 << 10) | ctrl_slave_ratio_cs0),
		 ddr_phy_base + CMD2_REG_PHY_CTRL_SLAVE_RATIO_0);

	__raw_writel(cmd_dll_lock_diff,
		 ddr_phy_base + CMD0_REG_PHY_DLL_LOCK_DIFF_0);
	__raw_writel(cmd_dll_lock_diff,
		 ddr_phy_base + CMD1_REG_PHY_DLL_LOCK_DIFF_0);
	__raw_writel(cmd_dll_lock_diff,
		 ddr_phy_base + CMD2_REG_PHY_DLL_LOCK_DIFF_0);
}

static void data_macro_config(u32 macro_num, u32 phy_num, u32 rd_dqs_cs0,
		u32 wr_dqs_cs0, u32 fifo_we_cs0, u32 wr_data_cs0)
{
	/* 0xA4 is size of each data macro mmr region.
	 * phy1 is at offset 0x400 from phy0
	 */
	u32 base = (macro_num * 0xA4) + (phy_num * 0x400);

	__raw_writel(((rd_dqs_cs0 << 10) | rd_dqs_cs0),
		(DATA0_REG_PHY0_RD_DQS_SLAVE_RATIO_0 + base));
	__raw_writel(((wr_dqs_cs0 << 10) | wr_dqs_cs0),
		(DATA0_REG_PHY0_WR_DQS_SLAVE_RATIO_0 + base));
	__raw_writel(((PHY_WRLVL_INIT_CS1_DEFINE << 10) |
		PHY_WRLVL_INIT_CS0_DEFINE),
		(DATA0_REG_PHY0_WRLVL_INIT_RATIO_0 + base));
	__raw_writel(((PHY_GATELVL_INIT_CS1_DEFINE << 10) |
		PHY_GATELVL_INIT_CS0_DEFINE),
		(DATA0_REG_PHY0_GATELVL_INIT_RATIO_0 + base));
	__raw_writel(((fifo_we_cs0 << 10) | fifo_we_cs0),
		(DATA0_REG_PHY0_FIFO_WE_SLAVE_RATIO_0 + base));
	__raw_writel(((wr_data_cs0 << 10) | wr_data_cs0),
		(DATA0_REG_PHY0_WR_DATA_SLAVE_RATIO_0 + base));
	__raw_writel(PHY_DLL_LOCK_DIFF_DEFINE,
		(DATA0_REG_PHY0_DLL_LOCK_DIFF_0 + base));
}

#define is_ddr3(v) 1

#ifdef CONFIG_SETUP_PLL
static void pll_config(u32, u32, u32, u32, u32);
static void l3_pll_config(void);
static void ddr_pll_config(void);
#endif



#ifdef CONFIG_TI814X_CONFIG_DDR
static void config_ti814x_ddr(void)
{
	int macro, phy_num;
	
	/*Enable the Power Domain Transition of L3 Fast Domain Peripheral*/
	__raw_writel(0x2, CM_DEFAULT_FW_CLKCTRL);
	/*Enable the Power Domain Transition of L3 Fast Domain Peripheral*/
	__raw_writel(0x2, CM_DEFAULT_L3_FAST_CLKSTCTRL);
	__raw_writel(0x2, CM_DEFAULT_EMIF_0_CLKCTRL);				/*Enable EMIF0 Clock*/
	__raw_writel(0x2, CM_DEFAULT_EMIF_1_CLKCTRL);				/*Enable EMIF1 Clock*/
	__raw_writel(0x2, CM_DEFAULT_DMM_CLKCTRL);

	/*Poll for L3_FAST_GCLK  & DDR_GCLK  are active*/
	while ((__raw_readl(CM_DEFAULT_L3_FAST_CLKSTCTRL) & 0x300) != 0x300);
	/*Poll for Module is functional*/
	while ((__raw_readl(CM_DEFAULT_EMIF_0_CLKCTRL)) != 0x2);
	while ((__raw_readl(CM_DEFAULT_EMIF_1_CLKCTRL)) != 0x2);
	while ((__raw_readl(CM_DEFAULT_DMM_CLKCTRL)) != 0x2);

	if (is_ddr3()) {
		cmd_macro_config(DDR_PHY0, DDR3_PHY_INVERT_CLKOUT_OFF,
				DDR3_PHY_CTRL_SLAVE_RATIO_CS0_DEFINE,
				PHY_CMD0_DLL_LOCK_DIFF_DEFINE);
		cmd_macro_config(DDR_PHY1, DDR3_PHY_INVERT_CLKOUT_OFF,
				DDR3_PHY_CTRL_SLAVE_RATIO_CS0_DEFINE,
				PHY_CMD0_DLL_LOCK_DIFF_DEFINE);

		for (phy_num = 0; phy_num <= DDR_PHY1; phy_num++) {
			for (macro = 0; macro <= DATA_MACRO_3; macro++) {
					data_macro_config(macro, phy_num,
						DDR3_PHY_RD_DQS_CS0_DEFINE_J, 
						DDR3_PHY_WR_DQS_CS0_DEFINE_J, 
						DDR3_PHY_RD_DQS_GATE_CS0_DEFINE_J, 
						DDR3_PHY_WR_DATA_CS0_DEFINE_J); 
			}
		}

	}

	/* DDR IO CTRL config */
	__raw_writel(DDR0_IO_CTRL_DEFINE_J, DDR0_IO_CTRL);
	__raw_writel(DDR1_IO_CTRL_DEFINE_J, DDR1_IO_CTRL);

	__raw_writel(__raw_readl(VTP0_CTRL_REG) | 0x00000040 , VTP0_CTRL_REG);
	__raw_writel(__raw_readl(VTP1_CTRL_REG) | 0x00000040 , VTP1_CTRL_REG);

	// Write 0 to CLRZ bit
	__raw_writel(__raw_readl(VTP0_CTRL_REG) & 0xfffffffe , VTP0_CTRL_REG);
	__raw_writel(__raw_readl(VTP1_CTRL_REG) & 0xfffffffe , VTP1_CTRL_REG);

	// Write 1 to CLRZ bit
	__raw_writel(__raw_readl(VTP0_CTRL_REG) | 0x00000001 , VTP0_CTRL_REG);
	__raw_writel(__raw_readl(VTP1_CTRL_REG) | 0x00000001 , VTP1_CTRL_REG);

	// Read VTP control registers & check READY bits
	while ((__raw_readl(VTP0_CTRL_REG) & 0x00000020) != 0x20);
	while ((__raw_readl(VTP1_CTRL_REG) & 0x00000020) != 0x20);

	/*
	 * Program the PG2.1 DMM to Access EMIF0 and EMIF1
	 * 512MB sections with 512-byte interleaving
	 */
	__raw_writel(PG2_1_DMM_LISA_MAP__0_1G, DMM_LISA_MAP__0);
	__raw_writel(PG2_1_DMM_LISA_MAP__1_1G, DMM_LISA_MAP__1);
	__raw_writel(PG2_1_DMM_LISA_MAP__2_1G, DMM_LISA_MAP__2);
	__raw_writel(PG2_1_DMM_LISA_MAP__3_1G, DMM_LISA_MAP__3);

	while (__raw_readl(DMM_LISA_MAP__0) != PG2_1_DMM_LISA_MAP__0_1G);
	while (__raw_readl(DMM_LISA_MAP__1) != PG2_1_DMM_LISA_MAP__1_1G);
	while (__raw_readl(DMM_LISA_MAP__2) != PG2_1_DMM_LISA_MAP__2_1G);
	while (__raw_readl(DMM_LISA_MAP__3) != PG2_1_DMM_LISA_MAP__3_1G);
	
	__raw_writel(0x80000000, DMM_PAT_BASE_ADDR);

	{
		/*Program EMIF0 CFG Registers*/
		__raw_writel(DDR3_EMIF_READ_LATENCY, EMIF4_0_DDR_PHY_CTRL_1);
		__raw_writel(DDR3_EMIF_READ_LATENCY, EMIF4_0_DDR_PHY_CTRL_1_SHADOW);
		__raw_writel(DDR3_EMIF_TIM1, EMIF4_0_SDRAM_TIM_1);
		__raw_writel(DDR3_EMIF_TIM1, EMIF4_0_SDRAM_TIM_1_SHADOW);
		__raw_writel(DDR3_EMIF_TIM2_1G, EMIF4_0_SDRAM_TIM_2);
		__raw_writel(DDR3_EMIF_TIM2_1G, EMIF4_0_SDRAM_TIM_2_SHADOW);
		__raw_writel(DDR3_EMIF_TIM3_1G, EMIF4_0_SDRAM_TIM_3);
		__raw_writel(DDR3_EMIF_TIM3_1G, EMIF4_0_SDRAM_TIM_3_SHADOW);
		__raw_writel(DDR3_EMIF_SDRAM_CONFIG_1G, EMIF4_0_SDRAM_CONFIG);

		__raw_writel(DDR_EMIF_REF_CTRL | DDR_EMIF_REF_TRIGGER,
						 EMIF4_0_SDRAM_REF_CTRL);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_0_SDRAM_REF_CTRL_SHADOW);
		__raw_writel(DDR3_EMIF_SDRAM_ZQCR, EMIF4_0_SDRAM_ZQCR);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_0_SDRAM_REF_CTRL);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_0_SDRAM_REF_CTRL_SHADOW);

		__raw_writel(DDR3_EMIF_REF_CTRL, EMIF4_0_SDRAM_REF_CTRL);
		__raw_writel(DDR3_EMIF_REF_CTRL, EMIF4_0_SDRAM_REF_CTRL_SHADOW);
		//__raw_writel(DDR3_EMIF_SDRAM_CONFIG, EMIF4_0_SDRAM_CONFIG);

		/*Program EMIF1 CFG Registers*/
		__raw_writel(DDR3_EMIF_READ_LATENCY, EMIF4_1_DDR_PHY_CTRL_1);
		__raw_writel(DDR3_EMIF_READ_LATENCY, EMIF4_1_DDR_PHY_CTRL_1_SHADOW);
		__raw_writel(DDR3_EMIF_TIM1, EMIF4_1_SDRAM_TIM_1);
		__raw_writel(DDR3_EMIF_TIM1, EMIF4_1_SDRAM_TIM_1_SHADOW);
		__raw_writel(DDR3_EMIF_TIM2_1G, EMIF4_1_SDRAM_TIM_2);
		__raw_writel(DDR3_EMIF_TIM2_1G, EMIF4_1_SDRAM_TIM_2_SHADOW);
		__raw_writel(DDR3_EMIF_TIM3_1G, EMIF4_1_SDRAM_TIM_3);
		__raw_writel(DDR3_EMIF_TIM3_1G, EMIF4_1_SDRAM_TIM_3_SHADOW);
		__raw_writel(DDR3_EMIF_SDRAM_CONFIG_1G, EMIF4_1_SDRAM_CONFIG);

		__raw_writel(DDR_EMIF_REF_CTRL | DDR_EMIF_REF_TRIGGER,
						 EMIF4_1_SDRAM_REF_CTRL);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_1_SDRAM_REF_CTRL_SHADOW);
		__raw_writel(DDR3_EMIF_SDRAM_ZQCR, EMIF4_1_SDRAM_ZQCR);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_1_SDRAM_REF_CTRL);
		__raw_writel(DDR_EMIF_REF_CTRL, EMIF4_1_SDRAM_REF_CTRL_SHADOW);

		__raw_writel(DDR3_EMIF_REF_CTRL, EMIF4_1_SDRAM_REF_CTRL);
		__raw_writel(DDR3_EMIF_REF_CTRL, EMIF4_1_SDRAM_REF_CTRL_SHADOW);
		//__raw_writel(DDR3_EMIF_SDRAM_CONFIG, EMIF4_1_SDRAM_CONFIG);
	}
}

#endif




static void ddr_rw_delay(int delay)
{	
	int i = 0;
	while(i < delay)
		i++;
}
static void ddr_rw_recfg(void)
{
	__raw_writel(0xaa, 0x88000000);
	if(__raw_readl(0xa8000000) != 0xaa){
		__raw_writel(0x400, 0x8c000000);
		return;
	}
	__raw_writel(0x55, 0xa8000000);
	if(__raw_readl(0x88000000) != 0x55){
		__raw_writel(0x400, 0x8c000000);
		return;
	}

	__raw_writel(PG2_1_DMM_LISA_MAP__0_512M, DMM_LISA_MAP__0);
	__raw_writel(PG2_1_DMM_LISA_MAP__1_512M, DMM_LISA_MAP__1);
	__raw_writel(PG2_1_DMM_LISA_MAP__2_512M, DMM_LISA_MAP__2);
	__raw_writel(PG2_1_DMM_LISA_MAP__3_512M, DMM_LISA_MAP__3);

	while (__raw_readl(DMM_LISA_MAP__0) != PG2_1_DMM_LISA_MAP__0_512M);
	while (__raw_readl(DMM_LISA_MAP__1) != PG2_1_DMM_LISA_MAP__1_512M);
	while (__raw_readl(DMM_LISA_MAP__2) != PG2_1_DMM_LISA_MAP__2_512M);
	while (__raw_readl(DMM_LISA_MAP__3) != PG2_1_DMM_LISA_MAP__3_512M);

	__raw_writel(DDR3_EMIF_SDRAM_CONFIG_512M, EMIF4_0_SDRAM_CONFIG);
	__raw_writel(DDR3_EMIF_SDRAM_CONFIG_512M, EMIF4_1_SDRAM_CONFIG);

	__raw_writel(DDR3_EMIF_TIM2_512M, EMIF4_0_SDRAM_TIM_2);
	__raw_writel(DDR3_EMIF_TIM2_512M, EMIF4_0_SDRAM_TIM_2_SHADOW);
	__raw_writel(DDR3_EMIF_TIM3_512M, EMIF4_0_SDRAM_TIM_3);
	__raw_writel(DDR3_EMIF_TIM3_512M, EMIF4_0_SDRAM_TIM_3_SHADOW);
	__raw_writel(DDR3_EMIF_TIM2_512M, EMIF4_1_SDRAM_TIM_2);
	__raw_writel(DDR3_EMIF_TIM2_512M, EMIF4_1_SDRAM_TIM_2_SHADOW);
	__raw_writel(DDR3_EMIF_TIM3_512M, EMIF4_1_SDRAM_TIM_3);
	__raw_writel(DDR3_EMIF_TIM3_512M, EMIF4_1_SDRAM_TIM_3_SHADOW);

	/*ĳһַдڴС*/
	__raw_writel(0x200, 0x8c000000);
	
#if 0
	if((__raw_readl(0xa8000000) == 0xaa) && (__raw_readl(0x8a000000) == 0x55)){
		__raw_writel(PG2_1_DMM_LISA_MAP__0_512M, DMM_LISA_MAP__0);
		__raw_writel(PG2_1_DMM_LISA_MAP__1_512M, DMM_LISA_MAP__1);
		__raw_writel(PG2_1_DMM_LISA_MAP__2_512M, DMM_LISA_MAP__2);
		__raw_writel(PG2_1_DMM_LISA_MAP__3_512M, DMM_LISA_MAP__3);

		while (__raw_readl(DMM_LISA_MAP__0) != PG2_1_DMM_LISA_MAP__0_512M);
		while (__raw_readl(DMM_LISA_MAP__1) != PG2_1_DMM_LISA_MAP__1_512M);
		while (__raw_readl(DMM_LISA_MAP__2) != PG2_1_DMM_LISA_MAP__2_512M);
		while (__raw_readl(DMM_LISA_MAP__3) != PG2_1_DMM_LISA_MAP__3_512M);

		__raw_writel(DDR3_EMIF_SDRAM_CONFIG_512M, EMIF4_0_SDRAM_CONFIG);
		__raw_writel(DDR3_EMIF_SDRAM_CONFIG_512M, EMIF4_1_SDRAM_CONFIG);
		/*ĳһַдڴС*/
		__raw_writel(0x200, 0x8c000000);
	}else{
		__raw_writel(0x400, 0x8c000000);
	}
	
#endif
}





#ifdef CONFIG_SETUP_PLL


static void l3_pll_config()
{
	pll_config(L3_PLL_BASE,
			L3_N, L3_M,
			L3_M2, L3_CLKCTRL);
}

static void ddr_pll_config()
{
	pll_config(DDR_PLL_BASE,
			DDR_N, DDR_M,
			DDR_M2, DDR_CLKCTRL);
}

/*
 * configure individual ADPLLJ
 */
static void pll_config(u32 base, u32 n, u32 m, u32 m2, u32 clkctrl_val)
{
	u32 m2nval, mn2val, read_clkctrl = 0;

	m2nval = (m2 << 16) | n;
	mn2val = m;

	/* by-pass pll */
	read_clkctrl = __raw_readl(base + ADPLLJ_CLKCTRL);
	__raw_writel((read_clkctrl | 0x00800000), (base + ADPLLJ_CLKCTRL));
	while ((__raw_readl(base + ADPLLJ_STATUS) & 0x101) != 0x101);
	read_clkctrl = __raw_readl(base + ADPLLJ_CLKCTRL);
	__raw_writel((read_clkctrl & 0xfffffffe), (base + ADPLLJ_CLKCTRL));


	/*
	 * ref_clk = 20/(n + 1);
	 * clkout_dco = ref_clk * m;
	 * clk_out = clkout_dco/m2;
	*/

	__raw_writel(m2nval, (base + ADPLLJ_M2NDIV));
	__raw_writel(mn2val, (base + ADPLLJ_MN2DIV));

	/* Load M2, N2 dividers of ADPLL */
	__raw_writel(0x1, (base + ADPLLJ_TENABLEDIV));
	__raw_writel(0x0, (base + ADPLLJ_TENABLEDIV));

	/* Loda M, N dividers of ADPLL */
	__raw_writel(0x1, (base + ADPLLJ_TENABLE));
	__raw_writel(0x0, (base + ADPLLJ_TENABLE));

	read_clkctrl = __raw_readl(base + ADPLLJ_CLKCTRL);

	if (MODENA_PLL_BASE == base)
		__raw_writel((read_clkctrl & 0xff7fffff) | clkctrl_val,
			base + ADPLLJ_CLKCTRL);
	else
		__raw_writel((read_clkctrl & 0xff7fe3ff) | clkctrl_val,
			base + ADPLLJ_CLKCTRL);
	/* Wait for phase and freq lock */
	while ((__raw_readl(base + ADPLLJ_STATUS) & 0x600) != 0x600);

}
#endif

/*
 * Enable the clks & power for perifs (TIMER1, UART0,...)
 */
void s_per_clocks_enable(void)
{
	u32 temp;

	__raw_writel(0x2, CM_ALWON_L3_SLOW_CLKSTCTRL);

	/* Selects OSC0 (20MHz) for DMTIMER1 */
	temp = __raw_readl(DMTIMER_CLKSRC);
	temp &= ~(0x7 << 3);
	temp |= (0x4 << 3);
	__raw_writel(temp, DMTIMER_CLKSRC);
	__raw_writel(0x2,(DM_TIMER1_BASE + 0x54));
	while(__raw_readl(DM_TIMER1_BASE + 0x10) & 1);
	__raw_writel(0x1,(DM_TIMER1_BASE + 0x38));

	/* SPI */
	__raw_writel(0x2, CM_ALWON_SPI_CLKCTRL);
	while(__raw_readl(CM_ALWON_SPI_CLKCTRL) != 0x2);

}

/*
 * inits clocks for PRCM as defined in clocks.h
 */
static void s_prcm_init(u32 in_ddr)
{
	/* Enable the control module */
	__raw_writel(0x2, CM_ALWON_CONTROL_CLKCTRL);

#ifdef CONFIG_SETUP_PLL

	l3_pll_config();
	ddr_pll_config();

	/*  With clk freqs setup to desired values,
	 *  enable the required peripherals
	 */
	s_per_clocks_enable();
#endif
}

void unlock_pll_control_mmr()
{
	/* ??? */
	__raw_writel(0x1EDA4C3D, 0x481C5040);
	__raw_writel(0x2FF1AC2B, 0x48140060);
	__raw_writel(0xF757FDC0, 0x48140064);
	__raw_writel(0xE2BC3A6D, 0x48140068);
	__raw_writel(0x1EBF131D, 0x4814006c);
	__raw_writel(0x6F361E05, 0x48140070);

}

/*
 * early system init of muxing and clocks.
 */
void s_init(u32 in_ddr)
{
	/* Can be removed as A8 comes up with L2 enabled */
	l2_cache_enable();
	unlock_pll_control_mmr();
	/* Setup the PLLs and the clocks for the peripherals */
	s_prcm_init(in_ddr);
#if defined(CONFIG_TI814X_CONFIG_DDR)
	if (!in_ddr){
		config_ti814x_ddr();	/* Do DDR settings */
		ddr_rw_delay(0x10000);
		ddr_rw_recfg();
	}
#endif
}
