#include <common.h>
#include <spi.h>
#include <malloc.h>
#include <asm/io.h>
#include <asm/arch/omap3_spi.h>

#include <../tools/tiimage.h>

#include <asm/arch/cpu.h>
#include <asm/arch/ddr_defs.h>
#include <asm/arch/hardware.h>
#include <asm/arch/sys_proto.h>
#include <asm/arch/clock.h>




#undef OMAP3_MCSPI1_BASE
#define OMAP3_MCSPI1_BASE 0x48030100


static inline void spi_enable(struct mcspi *regs)
{
	writel(OMAP3_MCSPI_CHCTRL_EN, &regs->channel[0].chctrl);
}

static inline void spi_disable(struct mcspi *regs)
{
	writel(0, &regs->channel[0].chctrl);
}

static void inline spi_enable_cs(struct mcspi *regs)
{
	writel((readl(&regs->channel[0].chconf) | (0x00100000)),&regs->channel[0].chconf);
}

static inline void spi_disable_cs(struct mcspi *regs)
{
	writel((readl(&regs->channel[0].chconf) & ~(0x00100000)),&regs->channel[0].chconf);
}

void dm814x_spi_init(void)
{
	struct mcspi	*regs = (struct mcspi	*)OMAP3_MCSPI1_BASE;
	unsigned int conf;
	unsigned int tmp;

	writel(OMAP3_MCSPI_SYSCONFIG_SOFTRESET, &regs->sysconfig);
	do {
		tmp = readl(&regs->sysstatus);
	} while (!(tmp & OMAP3_MCSPI_SYSSTATUS_RESETDONE));

	writel(OMAP3_MCSPI_SYSCONFIG_AUTOIDLE |
	       OMAP3_MCSPI_SYSCONFIG_ENAWAKEUP |
	       OMAP3_MCSPI_SYSCONFIG_SMARTIDLE,
	       &regs->sysconfig);

	writel(OMAP3_MCSPI_WAKEUPENABLE_WKEN, &regs->wakeupenable);
	
	conf = readl(&regs->modulctrl);
	conf &= ~(OMAP3_MCSPI_MODULCTRL_STEST | OMAP3_MCSPI_MODULCTRL_MS);
	conf |= OMAP3_MCSPI_MODULCTRL_SINGLE;
	writel(conf, &regs->modulctrl);
	conf = (OMAP3_MCSPI_CHCONF_DPE0 | ((32 - 1) << 7) | OMAP3_MCSPI_CHCONF_EPOL |\
			OMAP3_MCSPI_CHCONF_POL |OMAP3_MCSPI_CHCONF_PHA | 0x01 << 2 | \
			 OMAP3_MCSPI_CHCONF_TCS | OMAP3_MCSPI_CHCONF_FFEW |
			OMAP3_MCSPI_CHCONF_FFER |OMAP3_MCSPI_CHCONF_TRM_RX_ONLY);
	writel(conf, &regs->channel[0].chconf);
	//writel(0x00060080,0x48140B98);
	return;
}

inline __attribute__((always_inline))
static unsigned int spi_read_word(struct mcspi *regs)
{
	//while ((readl(&regs->channel[0].chstat) &OMAP3_MCSPI_CHSTAT_TXS) == 0);
	//writel(data, &regs->channel[0].tx);
	while ((readl(&regs->channel[0].chstat) &OMAP3_MCSPI_CHSTAT_RXS) == 0);
	return readl(&regs->channel[0].rx);
}

static void spi_load(unsigned int * p,unsigned int len,unsigned int offset)
{
	struct mcspi	*regs = (struct mcspi	*)OMAP3_MCSPI1_BASE;
	unsigned int i;
	unsigned int addr;
	spi_enable(regs);
	spi_enable_cs(regs);
	addr = offset | 0x03<<24;
	
	while ((readl(&regs->channel[0].chstat) &OMAP3_MCSPI_CHSTAT_TXS) == 0);
	writel(addr, &regs->channel[0].tx);
	spi_read_word(regs);
	
	for (i = len; i;i-=4) {
		*p = spi_read_word(regs);
		p++;
	}
	spi_disable_cs(regs);
	spi_disable(regs);
	return;
}

unsigned  int spi_load_stage2(unsigned int *p,unsigned int  len,unsigned int offset)
{
	dm814x_spi_init();
	spi_load(p,len,offset);
	return 1;
}

#if 0
unsigned  int  spi_load_ubl(unsigned int *p,unsigned int  len,unsigned int offset)
{
	struct uboot_header ubh;
	struct uboot_image *ubm = (struct uboot_image *)0;//waring! jsut for calc offset
	unsigned int crc;
	memcpy(p,0x40300010,8*1024);//load crc32_tab
	spi_load((unsigned int *)&ubh,sizeof(ubm->uboot_h2),(unsigned int)&ubm->uboot_h2);
	if (ubh.magic == UBOOT_MAGIC){
		crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubh.header_crc32));
		if (crc != ubh.header_crc32)
			goto err1;
		spi_load(ubh.ubl_entry,ubh.ubl_size,(unsigned int)&ubm->uboot2);
		crc = crc32(0,ubh.ubl_entry,ubh.ubl_size);
		if (crc != ubh.ubl_crc32)
			goto err1;
		return ubh.ubl_entry;
	}

err1:
	spi_load((unsigned int *)&ubh,sizeof(ubm->uboot_h1),(unsigned int)&ubm->uboot_h1);
	if (ubh.magic == UBOOT_MAGIC){
		crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubh.header_crc32));
		if (crc != ubh.header_crc32)
			return 0;
		spi_load(ubh.ubl_entry,ubh.ubl_size,(unsigned int)&ubm->uboot2);
		crc = crc32(0,ubh.ubl_entry,ubh.ubl_size);
		if (crc != ubh.ubl_crc32)
			return 0;
		return ubh.ubl_entry;
	}
	return 0;
}

unsigned  int  spi_load_uboot(unsigned int *p,unsigned int  len,unsigned int offset)
{
	struct uboot_header ubh;
	struct uboot_image *ubm = (struct uboot_image *)0;//waring! jsut for calc offset
	unsigned int crc;
	spi_load((unsigned int *)&ubh,sizeof(ubm->uboot_h2),(unsigned int)&ubm->uboot_h2);
	memcpy(p,ubh.ubl_entry,8*1024);//load crc32_tab
	if (ubh.magic == UBOOT_MAGIC){
		crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubm->uboot_h2.header_crc32));
		if (crc != ubh.header_crc32)
			goto err1;
		spi_load(ubh.load_addr,ubh.uboot_size,(unsigned int)&ubm->uboot2);
		crc = crc32(0,ubh.load_addr,ubh.uboot_size);
		if (crc != ubh.uboot_crc32)
			goto err1;
		return ubh.load_addr;
	}

err1:
	spi_load((unsigned int *)&ubh,sizeof(ubm->uboot_h1),(unsigned int)&ubm->uboot_h1);
	if (ubh.magic == UBOOT_MAGIC){
		crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubm->uboot_h1.header_crc32));
		if (crc != ubh.header_crc32)
			return 0;
		spi_load(ubh.load_addr,ubh.uboot_size,(unsigned int)&ubm->uboot2);
		crc = crc32(0,ubh.load_addr,ubh.uboot_size);
		if (crc != ubh.uboot_crc32)
			return 0;
		return ubh.load_addr;
	}
	return 0;
}
#else
unsigned  int  spi_load_ubl(unsigned int *p,unsigned int  len,unsigned int offset)
{
	struct uboot_header ubh;
	struct uboot_image *ubm = (struct uboot_image *)0;//waring! jsut for calc offset
	unsigned int crc;
	int i;
	for (i = 1;i>=0;i--){
		spi_load((unsigned int *)&ubh,sizeof(struct uboot_header),(unsigned int)&ubm->uboot_img[i]);
		if (ubh.magic == UBOOT_MAGIC){
			crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubh.header_crc32));
			if (crc != ubh.header_crc32)
				continue;
			spi_load(ubh.ubl_entry,ubh.ubl_size,(unsigned int)ubm->uboot_img[i].uboot_bin);
			crc = crc32(0,ubh.ubl_entry,ubh.ubl_size);
			if (crc != ubh.ubl_crc32)
				continue;
			//*(unsigned int *)0x82000000 = crc;
			return ubh.ubl_entry;
		}
	}
	return 0;
}

unsigned  int  spi_load_uboot(unsigned int *p,unsigned int  len,unsigned int offset)
{
	struct uboot_header ubh;
	struct uboot_image *ubm = (struct uboot_image *)0;//waring! jsut for calc offset
	unsigned int *boot_from = (unsigned int *)BOOT_FROM;
	unsigned int crc;
	int i;
	for (i = 1;i>=0; i--){
		spi_load((unsigned int *)&ubh,sizeof(struct uboot_header),(unsigned int)&ubm->uboot_img[i]);
		if (ubh.magic == UBOOT_MAGIC){
			crc = crc32(0U,(const unsigned char *)&ubh,sizeof(struct uboot_header) - sizeof(ubh.header_crc32));
			if (crc != ubh.header_crc32)
				continue;
			spi_load(ubh.load_addr,ubh.uboot_size,(unsigned int)ubm->uboot_img[i].uboot_bin);
			crc = crc32(0,ubh.load_addr,ubh.uboot_size);
			if (crc != ubh.uboot_crc32)
				continue;
			 *boot_from = i;
			return ubh.load_addr;
		}
	}
	return 0;
}
#endif